# encoding: utf8
from __future__ import unicode_literals

from ...symbols import ORTH, LEMMA


_exc = {
    # หน่วยงานรัฐ / government agency
    "กกต.": [{ORTH: "กกต.", LEMMA: "คณะกรรมการการเลือกตั้ง"}],
    "กทท.": [{ORTH: "กทท.", LEMMA: "การท่าเรือแห่งประเทศไทย"}],
    "กทพ.": [{ORTH: "กทพ.", LEMMA: "การทางพิเศษแห่งประเทศไทย"}],
    "กบข.": [{ORTH: "กบข.", LEMMA: "กองทุนบำเหน็จบำนาญข้าราชการพลเรือน"}],
    "กบว.": [{ORTH: "กบว.", LEMMA: "คณะกรรมการบริหารวิทยุกระจายเสียงและวิทยุโทรทัศน์"}],
    "กปน.": [{ORTH: "กปน.", LEMMA: "การประปานครหลวง"}],
    "กปภ.": [{ORTH: "กปภ.", LEMMA: "การประปาส่วนภูมิภาค"}],
    "กปส.": [{ORTH: "กปส.", LEMMA: "กรมประชาสัมพันธ์"}],
    "กผม.": [{ORTH: "กผม.", LEMMA: "กองผังเมือง"}],
    "กฟน.": [{ORTH: "กฟน.", LEMMA: "การไฟฟ้านครหลวง"}],
    "กฟผ.": [{ORTH: "กฟผ.", LEMMA: "การไฟฟ้าฝ่ายผลิตแห่งประเทศไทย"}],
    "กฟภ.": [{ORTH: "กฟภ.", LEMMA: "การไฟฟ้าส่วนภูมิภาค"}],
    "ก.ช.น.": [{ORTH: "ก.ช.น.", LEMMA: "คณะกรรมการช่วยเหลือชาวนาชาวไร่"}],
    "กยศ.": [{ORTH: "กยศ.", LEMMA: "กองทุนเงินให้กู้ยืมเพื่อการศึกษา"}],
    "ก.ล.ต.": [{ORTH: "ก.ล.ต.", LEMMA: "คณะกรรมการกำกับหลักทรัพย์และตลาดหลักทรัพย์"}],
    "กศ.บ.": [{ORTH: "กศ.บ.", LEMMA: "การศึกษาบัณฑิต"}],
    "กศน.": [{ORTH: "กศน.", LEMMA: "กรมการศึกษานอกโรงเรียน"}],
    "กสท.": [{ORTH: "กสท.", LEMMA: "การสื่อสารแห่งประเทศไทย"}],
    "กอ.รมน.": [{ORTH: "กอ.รมน.", LEMMA: "กองอำนวยการรักษาความมั่นคงภายใน"}],
    "กร.": [{ORTH: "กร.", LEMMA: "กองเรือยุทธการ"}],
    "ขสมก.": [{ORTH: "ขสมก.", LEMMA: "องค์การขนส่งมวลชนกรุงเทพ"}],
    "คตง.": [{ORTH: "คตง.", LEMMA: "คณะกรรมการตรวจเงินแผ่นดิน"}],
    "ครม.": [{ORTH: "ครม.", LEMMA: "คณะรัฐมนตรี"}],
    "คมช.": [{ORTH: "คมช.", LEMMA: "คณะมนตรีความมั่นคงแห่งชาติ"}],
    "ตชด.": [{ORTH: "ตชด.", LEMMA: "ตำรวจตะเวนชายเดน"}],
    "ตม.": [{ORTH: "ตม.", LEMMA: "กองตรวจคนเข้าเมือง"}],
    "ตร.": [{ORTH: "ตร.", LEMMA: "ตำรวจ"}],
    "ททท.": [{ORTH: "ททท.", LEMMA: "การท่องเที่ยวแห่งประเทศไทย"}],
    "ททบ.": [{ORTH: "ททบ.", LEMMA: "สถานีวิทยุโทรทัศน์กองทัพบก"}],
    "ทบ.": [{ORTH: "ทบ.", LEMMA: "กองทัพบก"}],
    "ทร.": [{ORTH: "ทร.", LEMMA: "กองทัพเรือ"}],
    "ทอ.": [{ORTH: "ทอ.", LEMMA: "กองทัพอากาศ"}],
    "ทอท.": [{ORTH: "ทอท.", LEMMA: "การท่าอากาศยานแห่งประเทศไทย"}],
    "ธ.ก.ส.": [{ORTH: "ธ.ก.ส.", LEMMA: "ธนาคารเพื่อการเกษตรและสหกรณ์การเกษตร"}],
    "ธปท.": [{ORTH: "ธปท.", LEMMA: "ธนาคารแห่งประเทศไทย"}],
    "ธอส.": [{ORTH: "ธอส.", LEMMA: "ธนาคารอาคารสงเคราะห์"}],
    "นย.": [{ORTH: "นย.", LEMMA: "นาวิกโยธิน"}],
    "ปตท.": [{ORTH: "ปตท.", LEMMA: "การปิโตรเลียมแห่งประเทศไทย"}],
    "ป.ป.ช.": [
        {
            ORTH: "ป.ป.ช.",
            LEMMA: "คณะกรรมการป้องกันและปราบปรามการทุจริตและประพฤติมิชอบในวงราชการ",
        }
    ],
    "ป.ป.ส.": [{ORTH: "ป.ป.ส.", LEMMA: "คณะกรรมการป้องกันและปราบปรามยาเสพติด"}],
    "บพร.": [{ORTH: "บพร.", LEMMA: "กรมการบินพลเรือน"}],
    "บย.": [{ORTH: "บย.", LEMMA: "กองบินยุทธการ"}],
    "พสวท.": [
        {
            ORTH: "พสวท.",
            LEMMA: "โครงการพัฒนาและส่งเสริมผู้มีความรู้ความสามารถพิเศษทางวิทยาศาสตร์และเทคโนโลยี",
        }
    ],
    "มอก.": [{ORTH: "มอก.", LEMMA: "สำนักงานมาตรฐานผลิตภัณฑ์อุตสาหกรรม"}],
    "ยธ.": [{ORTH: "ยธ.", LEMMA: "กรมโยธาธิการ"}],
    "รพช.": [{ORTH: "รพช.", LEMMA: "สำนักงานเร่งรัดพัฒนาชนบท"}],
    "รฟท.": [{ORTH: "รฟท.", LEMMA: "การรถไฟแห่งประเทศไทย"}],
    "รฟม.": [{ORTH: "รฟม.", LEMMA: "การรถไฟฟ้าขนส่งมวลชนแห่งประเทศไทย"}],
    "ศธ.": [{ORTH: "ศธ.", LEMMA: "กระทรวงศึกษาธิการ"}],
    "ศนธ.": [{ORTH: "ศนธ.", LEMMA: "ศูนย์กลางนิสิตนักศึกษาแห่งประเทศไทย"}],
    "สกจ.": [{ORTH: "สกจ.", LEMMA: "สหกรณ์จังหวัด"}],
    "สกท.": [{ORTH: "สกท.", LEMMA: "สำนักงานคณะกรรมการส่งเสริมการลงทุน"}],
    "สกว.": [{ORTH: "สกว.", LEMMA: "สำนักงานกองทุนสนับสนุนการวิจัย"}],
    "สคบ.": [{ORTH: "สคบ.", LEMMA: "สำนักงานคณะกรรมการคุ้มครองผู้บริโภค"}],
    "สจร.": [{ORTH: "สจร.", LEMMA: "สำนักงานคณะกรรมการจัดระบบการจราจรทางบก"}],
    "สตง.": [{ORTH: "สตง.", LEMMA: "สำนักงานตรวจเงินแผ่นดิน"}],
    "สทท.": [{ORTH: "สทท.", LEMMA: "สถานีวิทยุโทรทัศน์แห่งประเทศไทย"}],
    "สทร.": [{ORTH: "สทร.", LEMMA: "สำนักงานกลางทะเบียนราษฎร์"}],
    "สธ": [{ORTH: "สธ", LEMMA: "กระทรวงสาธารณสุข"}],
    "สนช.": [{ORTH: "สนช.", LEMMA: "สภานิติบัญญัติแห่งชาติ,สำนักงานนวัตกรรมแห่งชาติ"}],
    "สนนท.": [{ORTH: "สนนท.", LEMMA: "สหพันธ์นิสิตนักศึกษาแห่งประเทศไทย"}],
    "สปก.": [{ORTH: "สปก.", LEMMA: "สำนักงานการปฏิรูปที่ดินเพื่อเกษตรกรรม"}],
    "สปช.": [{ORTH: "สปช.", LEMMA: "สำนักงานคณะกรรมการการประถมศึกษาแห่งชาติ"}],
    "สปอ.": [{ORTH: "สปอ.", LEMMA: "สำนักงานการประถมศึกษาอำเภอ"}],
    "สพช.": [{ORTH: "สพช.", LEMMA: "สำนักงานคณะกรรมการนโยบายพลังงานแห่งชาติ"}],
    "สยช.": [
        {ORTH: "สยช.", LEMMA: "สำนักงานคณะกรรมการส่งเสริมและประสานงานเยาวชนแห่งชาติ"}
    ],
    "สวช.": [{ORTH: "สวช.", LEMMA: "สำนักงานคณะกรรมการวัฒนธรรมแห่งชาติ"}],
    "สวท.": [{ORTH: "สวท.", LEMMA: "สถานีวิทยุกระจายเสียงแห่งประเทศไทย"}],
    "สวทช.": [{ORTH: "สวทช.", LEMMA: "สำนักงานพัฒนาวิทยาศาสตร์และเทคโนโลยีแห่งชาติ"}],
    "สคช.": [
        {ORTH: "สคช.", LEMMA: "สำนักงานคณะกรรมการพัฒนาการเศรษฐกิจและสังคมแห่งชาติ"}
    ],
    "สสว.": [{ORTH: "สสว.", LEMMA: "สำนักงานส่งเสริมวิสาหกิจขนาดกลางและขนาดย่อม"}],
    "สสส.": [{ORTH: "สสส.", LEMMA: "สำนักงานกองทุนสนับสนุนการสร้างเสริมสุขภาพ"}],
    "สสวท.": [{ORTH: "สสวท.", LEMMA: "สถาบันส่งเสริมการสอนวิทยาศาสตร์และเทคโนโลยี"}],
    "อตก.": [{ORTH: "อตก.", LEMMA: "องค์การตลาดเพื่อเกษตรกร"}],
    "อบจ.": [{ORTH: "อบจ.", LEMMA: "องค์การบริหารส่วนจังหวัด"}],
    "อบต.": [{ORTH: "อบต.", LEMMA: "องค์การบริหารส่วนตำบล"}],
    "อปพร.": [{ORTH: "อปพร.", LEMMA: "อาสาสมัครป้องกันภัยฝ่ายพลเรือน"}],
    "อย.": [{ORTH: "อย.", LEMMA: "สำนักงานคณะกรรมการอาหารและยา"}],
    "อ.ส.ม.ท.": [{ORTH: "อ.ส.ม.ท.", LEMMA: "องค์การสื่อสารมวลชนแห่งประเทศไทย"}],
    # มหาวิทยาลัย / สถานศึกษา / university / college
    "มทส.": [{ORTH: "มทส.", LEMMA: "มหาวิทยาลัยเทคโนโลยีสุรนารี"}],
    "มธ.": [{ORTH: "มธ.", LEMMA: "มหาวิทยาลัยธรรมศาสตร์"}],
    "ม.อ.": [{ORTH: "ม.อ.", LEMMA: "มหาวิทยาลัยสงขลานครินทร์"}],
    "มทร.": [{ORTH: "มทร.", LEMMA: "มหาวิทยาลัยเทคโนโลยีราชมงคล"}],
    "มมส.": [{ORTH: "มมส.", LEMMA: "มหาวิทยาลัยมหาสารคาม"}],
    "วท.": [{ORTH: "วท.", LEMMA: "วิทยาลัยเทคนิค"}],
    "สตม.": [{ORTH: "สตม.", LEMMA: "สำนักงานตรวจคนเข้าเมือง (ตำรวจ)"}],
    # ยศ / rank
    "ดร.": [{ORTH: "ดร.", LEMMA: "ดอกเตอร์"}],
    "ด.ต.": [{ORTH: "ด.ต.", LEMMA: "ดาบตำรวจ"}],
    "จ.ต.": [{ORTH: "จ.ต.", LEMMA: "จ่าตรี"}],
    "จ.ท.": [{ORTH: "จ.ท.", LEMMA: "จ่าโท"}],
    "จ.ส.ต.": [{ORTH: "จ.ส.ต.", LEMMA: "จ่าสิบตรี (ทหารบก)"}],
    "จสต.": [{ORTH: "จสต.", LEMMA: "จ่าสิบตำรวจ"}],
    "จ.ส.ท.": [{ORTH: "จ.ส.ท.", LEMMA: "จ่าสิบโท"}],
    "จ.ส.อ.": [{ORTH: "จ.ส.อ.", LEMMA: "จ่าสิบเอก"}],
    "จ.อ.": [{ORTH: "จ.อ.", LEMMA: "จ่าเอก"}],
    "ทพญ.": [{ORTH: "ทพญ.", LEMMA: "ทันตแพทย์หญิง"}],
    "ทนพ.": [{ORTH: "ทนพ.", LEMMA: "เทคนิคการแพทย์"}],
    "นจอ.": [{ORTH: "นจอ.", LEMMA: "นักเรียนจ่าอากาศ"}],
    "น.ช.": [{ORTH: "น.ช.", LEMMA: "นักโทษชาย"}],
    "น.ญ.": [{ORTH: "น.ญ.", LEMMA: "นักโทษหญิง"}],
    "น.ต.": [{ORTH: "น.ต.", LEMMA: "นาวาตรี"}],
    "น.ท.": [{ORTH: "น.ท.", LEMMA: "นาวาโท"}],
    "นตท.": [{ORTH: "นตท.", LEMMA: "นักเรียนเตรียมทหาร"}],
    "นนส.": [{ORTH: "นนส.", LEMMA: "นักเรียนนายสิบทหารบก"}],
    "นนร.": [{ORTH: "นนร.", LEMMA: "นักเรียนนายร้อย"}],
    "นนอ.": [{ORTH: "นนอ.", LEMMA: "นักเรียนนายเรืออากาศ"}],
    "นพ.": [{ORTH: "นพ.", LEMMA: "นายแพทย์"}],
    "นพท.": [{ORTH: "นพท.", LEMMA: "นายแพทย์ทหาร"}],
    "นรจ.": [{ORTH: "นรจ.", LEMMA: "นักเรียนจ่าทหารเรือ"}],
    "นรต.": [{ORTH: "นรต.", LEMMA: "นักเรียนนายร้อยตำรวจ"}],
    "นศพ.": [{ORTH: "นศพ.", LEMMA: "นักศึกษาแพทย์"}],
    "นศท.": [{ORTH: "นศท.", LEMMA: "นักศึกษาวิชาทหาร"}],
    "น.สพ.": [{ORTH: "น.สพ.", LEMMA: "นายสัตวแพทย์ (พ.ร.บ.วิชาชีพการสัตวแพทย์)"}],
    "น.อ.": [{ORTH: "น.อ.", LEMMA: "นาวาเอก"}],
    "บช.ก.": [{ORTH: "บช.ก.", LEMMA: "กองบัญชาการตำรวจสอบสวนกลาง"}],
    "บช.น.": [{ORTH: "บช.น.", LEMMA: "กองบัญชาการตำรวจนครบาล"}],
    "ผกก.": [{ORTH: "ผกก.", LEMMA: "ผู้กำกับการ"}],
    "ผกก.ภ.": [{ORTH: "ผกก.ภ.", LEMMA: "ผู้กำกับการตำรวจภูธร"}],
    "ผจก.": [{ORTH: "ผจก.", LEMMA: "ผู้จัดการ"}],
    "ผช.": [{ORTH: "ผช.", LEMMA: "ผู้ช่วย"}],
    "ผชก.": [{ORTH: "ผชก.", LEMMA: "ผู้ชำนาญการ"}],
    "ผช.ผอ.": [{ORTH: "ผช.ผอ.", LEMMA: "ผู้ช่วยผู้อำนวยการ"}],
    "ผญบ.": [{ORTH: "ผญบ.", LEMMA: "ผู้ใหญ่บ้าน"}],
    "ผบ.": [{ORTH: "ผบ.", LEMMA: "ผู้บังคับบัญชา"}],
    "ผบก.": [{ORTH: "ผบก.", LEMMA: "ผู้บังคับบัญชาการ (ตำรวจ)"}],
    "ผบก.น.": [{ORTH: "ผบก.น.", LEMMA: "ผู้บังคับการตำรวจนครบาล"}],
    "ผบก.ป.": [{ORTH: "ผบก.ป.", LEMMA: "ผู้บังคับการตำรวจกองปราบปราม"}],
    "ผบก.ปค.": [
        {
            ORTH: "ผบก.ปค.",
            LEMMA: "ผู้บังคับการ กองบังคับการปกครอง (โรงเรียนนายร้อยตำรวจ)",
        }
    ],
    "ผบก.ปม.": [{ORTH: "ผบก.ปม.", LEMMA: "ผู้บังคับการตำรวจป่าไม้"}],
    "ผบก.ภ.": [{ORTH: "ผบก.ภ.", LEMMA: "ผู้บังคับการตำรวจภูธร"}],
    "ผบช.": [{ORTH: "ผบช.", LEMMA: "ผู้บัญชาการ (ตำรวจ)"}],
    "ผบช.ก.": [{ORTH: "ผบช.ก.", LEMMA: "ผู้บัญชาการตำรวจสอบสวนกลาง"}],
    "ผบช.ตชด.": [{ORTH: "ผบช.ตชด.", LEMMA: "ผู้บัญชาการตำรวจตระเวนชายแดน"}],
    "ผบช.น.": [{ORTH: "ผบช.น.", LEMMA: "ผู้บัญชาการตำรวจนครบาล"}],
    "ผบช.ภ.": [{ORTH: "ผบช.ภ.", LEMMA: "ผู้บัญชาการตำรวจภูธร"}],
    "ผบ.ทบ.": [{ORTH: "ผบ.ทบ.", LEMMA: "ผู้บัญชาการทหารบก"}],
    "ผบ.ตร.": [{ORTH: "ผบ.ตร.", LEMMA: "ผู้บัญชาการตำรวจแห่งชาติ"}],
    "ผบ.ทร.": [{ORTH: "ผบ.ทร.", LEMMA: "ผู้บัญชาการทหารเรือ"}],
    "ผบ.ทอ.": [{ORTH: "ผบ.ทอ.", LEMMA: "ผู้บัญชาการทหารอากาศ"}],
    "ผบ.ทสส.": [{ORTH: "ผบ.ทสส.", LEMMA: "ผู้บัญชาการทหารสูงสุด"}],
    "ผวจ.": [{ORTH: "ผวจ.", LEMMA: "ผู้ว่าราชการจังหวัด"}],
    "ผู้ว่าฯ": [{ORTH: "ผู้ว่าฯ", LEMMA: "ผู้ว่าราชการจังหวัด"}],
    "พ.จ.ต.": [{ORTH: "พ.จ.ต.", LEMMA: "พันจ่าตรี"}],
    "พ.จ.ท.": [{ORTH: "พ.จ.ท.", LEMMA: "พันจ่าโท"}],
    "พ.จ.อ.": [{ORTH: "พ.จ.อ.", LEMMA: "พันจ่าเอก"}],
    "พญ.": [{ORTH: "พญ.", LEMMA: "แพทย์หญิง"}],
    "ฯพณฯ": [{ORTH: "ฯพณฯ", LEMMA: "พณท่าน"}],
    "พ.ต.": [{ORTH: "พ.ต.", LEMMA: "พันตรี"}],
    "พ.ท.": [{ORTH: "พ.ท.", LEMMA: "พันโท"}],
    "พ.อ.": [{ORTH: "พ.อ.", LEMMA: "พันเอก"}],
    "พ.ต.อ.พิเศษ": [{ORTH: "พ.ต.อ.พิเศษ", LEMMA: "พันตำรวจเอกพิเศษ"}],
    "พลฯ": [{ORTH: "พลฯ", LEMMA: "พลทหาร"}],
    "พล.๑ รอ.": [{ORTH: "พล.๑ รอ.", LEMMA: "กองพลที่ ๑ รักษาพระองค์ กองทัพบก"}],
    "พล.ต.": [{ORTH: "พล.ต.", LEMMA: "พลตรี"}],
    "พล.ต.ต.": [{ORTH: "พล.ต.ต.", LEMMA: "พลตำรวจตรี"}],
    "พล.ต.ท.": [{ORTH: "พล.ต.ท.", LEMMA: "พลตำรวจโท"}],
    "พล.ต.อ.": [{ORTH: "พล.ต.อ.", LEMMA: "พลตำรวจเอก"}],
    "พล.ท.": [{ORTH: "พล.ท.", LEMMA: "พลโท"}],
    "พล.ปตอ.": [{ORTH: "พล.ปตอ.", LEMMA: "กองพลทหารปืนใหญ่ต่อสู่อากาศยาน"}],
    "พล.ม.": [{ORTH: "พล.ม.", LEMMA: "กองพลทหารม้า"}],
    "พล.ม.๒": [{ORTH: "พล.ม.๒", LEMMA: "กองพลทหารม้าที่ ๒"}],
    "พล.ร.ต.": [{ORTH: "พล.ร.ต.", LEMMA: "พลเรือตรี"}],
    "พล.ร.ท.": [{ORTH: "พล.ร.ท.", LEMMA: "พลเรือโท"}],
    "พล.ร.อ.": [{ORTH: "พล.ร.อ.", LEMMA: "พลเรือเอก"}],
    "พล.อ.": [{ORTH: "พล.อ.", LEMMA: "พลเอก"}],
    "พล.อ.ต.": [{ORTH: "พล.อ.ต.", LEMMA: "พลอากาศตรี"}],
    "พล.อ.ท.": [{ORTH: "พล.อ.ท.", LEMMA: "พลอากาศโท"}],
    "พล.อ.อ.": [{ORTH: "พล.อ.อ.", LEMMA: "พลอากาศเอก"}],
    "พ.อ.พิเศษ": [{ORTH: "พ.อ.พิเศษ", LEMMA: "พันเอกพิเศษ"}],
    "พ.อ.ต.": [{ORTH: "พ.อ.ต.", LEMMA: "พันจ่าอากาศตรี"}],
    "พ.อ.ท.": [{ORTH: "พ.อ.ท.", LEMMA: "พันจ่าอากาศโท"}],
    "พ.อ.อ.": [{ORTH: "พ.อ.อ.", LEMMA: "พันจ่าอากาศเอก"}],
    "ภกญ.": [{ORTH: "ภกญ.", LEMMA: "เภสัชกรหญิง"}],
    "ม.จ.": [{ORTH: "ม.จ.", LEMMA: "หม่อมเจ้า"}],
    "มท1": [{ORTH: "มท1", LEMMA: "รัฐมนตรีว่าการกระทรวงมหาดไทย"}],
    "ม.ร.ว.": [{ORTH: "ม.ร.ว.", LEMMA: "หม่อมราชวงศ์"}],
    "มล.": [{ORTH: "มล.", LEMMA: "หม่อมหลวง"}],
    "ร.ต.": [{ORTH: "ร.ต.", LEMMA: "ร้อยตรี,เรือตรี,เรืออากาศตรี"}],
    "ร.ต.ต.": [{ORTH: "ร.ต.ต.", LEMMA: "ร้อยตำรวจตรี"}],
    "ร.ต.ท.": [{ORTH: "ร.ต.ท.", LEMMA: "ร้อยตำรวจโท"}],
    "ร.ต.อ.": [{ORTH: "ร.ต.อ.", LEMMA: "ร้อยตำรวจเอก"}],
    "ร.ท.": [{ORTH: "ร.ท.", LEMMA: "ร้อยโท,เรือโท,เรืออากาศโท"}],
    "รมช.": [{ORTH: "รมช.", LEMMA: "รัฐมนตรีช่วยว่าการกระทรวง"}],
    "รมต.": [{ORTH: "รมต.", LEMMA: "รัฐมนตรี"}],
    "รมว.": [{ORTH: "รมว.", LEMMA: "รัฐมนตรีว่าการกระทรวง"}],
    "รศ.": [{ORTH: "รศ.", LEMMA: "รองศาสตราจารย์"}],
    "ร.อ.": [{ORTH: "ร.อ.", LEMMA: "ร้อยเอก,เรือเอก,เรืออากาศเอก"}],
    "ศ.": [{ORTH: "ศ.", LEMMA: "ศาสตราจารย์"}],
    "ส.ต.": [{ORTH: "ส.ต.", LEMMA: "สิบตรี"}],
    "ส.ต.ต.": [{ORTH: "ส.ต.ต.", LEMMA: "สิบตำรวจตรี"}],
    "ส.ต.ท.": [{ORTH: "ส.ต.ท.", LEMMA: "สิบตำรวจโท"}],
    "ส.ต.อ.": [{ORTH: "ส.ต.อ.", LEMMA: "สิบตำรวจเอก"}],
    "ส.ท.": [{ORTH: "ส.ท.", LEMMA: "สิบโท"}],
    "สพ.": [{ORTH: "สพ.", LEMMA: "สัตวแพทย์"}],
    "สพ.ญ.": [{ORTH: "สพ.ญ.", LEMMA: "สัตวแพทย์หญิง"}],
    "สพ.ช.": [{ORTH: "สพ.ช.", LEMMA: "สัตวแพทย์ชาย"}],
    "ส.อ.": [{ORTH: "ส.อ.", LEMMA: "สิบเอก"}],
    "อจ.": [{ORTH: "อจ.", LEMMA: "อาจารย์"}],
    "อจญ.": [{ORTH: "อจญ.", LEMMA: "อาจารย์ใหญ่"}],
    # วุฒิ / bachelor degree
    "ป.": [{ORTH: "ป.", LEMMA: "ประถมศึกษา"}],
    "ป.กศ.": [{ORTH: "ป.กศ.", LEMMA: "ประกาศนียบัตรวิชาการศึกษา"}],
    "ป.กศ.สูง": [{ORTH: "ป.กศ.สูง", LEMMA: "ประกาศนียบัตรวิชาการศึกษาชั้นสูง"}],
    "ปวช.": [{ORTH: "ปวช.", LEMMA: "ประกาศนียบัตรวิชาชีพ"}],
    "ปวท.": [{ORTH: "ปวท.", LEMMA: "ประกาศนียบัตรวิชาชีพเทคนิค"}],
    "ปวส.": [{ORTH: "ปวส.", LEMMA: "ประกาศนียบัตรวิชาชีพชั้นสูง"}],
    "ปทส.": [{ORTH: "ปทส.", LEMMA: "ประกาศนียบัตรครูเทคนิคชั้นสูง"}],
    "กษ.บ.": [{ORTH: "กษ.บ.", LEMMA: "เกษตรศาสตรบัณฑิต"}],
    "กษ.ม.": [{ORTH: "กษ.ม.", LEMMA: "เกษตรศาสตรมหาบัณฑิต"}],
    "กษ.ด.": [{ORTH: "กษ.ด.", LEMMA: "เกษตรศาสตรดุษฎีบัณฑิต"}],
    "ค.บ.": [{ORTH: "ค.บ.", LEMMA: "ครุศาสตรบัณฑิต"}],
    "คศ.บ.": [{ORTH: "คศ.บ.", LEMMA: "คหกรรมศาสตรบัณฑิต"}],
    "คศ.ม.": [{ORTH: "คศ.ม.", LEMMA: "คหกรรมศาสตรมหาบัณฑิต"}],
    "คศ.ด.": [{ORTH: "คศ.ด.", LEMMA: "คหกรรมศาสตรดุษฎีบัณฑิต"}],
    "ค.อ.บ.": [{ORTH: "ค.อ.บ.", LEMMA: "ครุศาสตรอุตสาหกรรมบัณฑิต"}],
    "ค.อ.ม.": [{ORTH: "ค.อ.ม.", LEMMA: "ครุศาสตรอุตสาหกรรมมหาบัณฑิต"}],
    "ค.อ.ด.": [{ORTH: "ค.อ.ด.", LEMMA: "ครุศาสตรอุตสาหกรรมดุษฎีบัณฑิต"}],
    "ทก.บ.": [{ORTH: "ทก.บ.", LEMMA: "เทคโนโลยีการเกษตรบัณฑิต"}],
    "ทก.ม.": [{ORTH: "ทก.ม.", LEMMA: "เทคโนโลยีการเกษตรมหาบัณฑิต"}],
    "ทก.ด.": [{ORTH: "ทก.ด.", LEMMA: "เทคโนโลยีการเกษตรดุษฎีบัณฑิต"}],
    "ท.บ.": [{ORTH: "ท.บ.", LEMMA: "ทันตแพทยศาสตรบัณฑิต"}],
    "ท.ม.": [{ORTH: "ท.ม.", LEMMA: "ทันตแพทยศาสตรมหาบัณฑิต"}],
    "ท.ด.": [{ORTH: "ท.ด.", LEMMA: "ทันตแพทยศาสตรดุษฎีบัณฑิต"}],
    "น.บ.": [{ORTH: "น.บ.", LEMMA: "นิติศาสตรบัณฑิต"}],
    "น.ม.": [{ORTH: "น.ม.", LEMMA: "นิติศาสตรมหาบัณฑิต"}],
    "น.ด.": [{ORTH: "น.ด.", LEMMA: "นิติศาสตรดุษฎีบัณฑิต"}],
    "นศ.บ.": [{ORTH: "นศ.บ.", LEMMA: "นิเทศศาสตรบัณฑิต"}],
    "นศ.ม.": [{ORTH: "นศ.ม.", LEMMA: "นิเทศศาสตรมหาบัณฑิต"}],
    "นศ.ด.": [{ORTH: "นศ.ด.", LEMMA: "นิเทศศาสตรดุษฎีบัณฑิต"}],
    "บช.บ.": [{ORTH: "บช.บ.", LEMMA: "บัญชีบัณฑิต"}],
    "บช.ม.": [{ORTH: "บช.ม.", LEMMA: "บัญชีมหาบัณฑิต"}],
    "บช.ด.": [{ORTH: "บช.ด.", LEMMA: "บัญชีดุษฎีบัณฑิต"}],
    "บธ.บ.": [{ORTH: "บธ.บ.", LEMMA: "บริหารธุรกิจบัณฑิต"}],
    "บธ.ม.": [{ORTH: "บธ.ม.", LEMMA: "บริหารธุรกิจมหาบัณฑิต"}],
    "บธ.ด.": [{ORTH: "บธ.ด.", LEMMA: "บริหารธุรกิจดุษฎีบัณฑิต"}],
    "พณ.บ.": [{ORTH: "พณ.บ.", LEMMA: "พาณิชยศาสตรบัณฑิต"}],
    "พณ.ม.": [{ORTH: "พณ.ม.", LEMMA: "พาณิชยศาสตรมหาบัณฑิต"}],
    "พณ.ด.": [{ORTH: "พณ.ด.", LEMMA: "พาณิชยศาสตรดุษฎีบัณฑิต"}],
    "พ.บ.": [{ORTH: "พ.บ.", LEMMA: "แพทยศาสตรบัณฑิต"}],
    "พ.ม.": [{ORTH: "พ.ม.", LEMMA: "แพทยศาสตรมหาบัณฑิต"}],
    "พ.ด.": [{ORTH: "พ.ด.", LEMMA: "แพทยศาสตรดุษฎีบัณฑิต"}],
    "พธ.บ.": [{ORTH: "พธ.บ.", LEMMA: "พุทธศาสตรบัณฑิต"}],
    "พธ.ม.": [{ORTH: "พธ.ม.", LEMMA: "พุทธศาสตรมหาบัณฑิต"}],
    "พธ.ด.": [{ORTH: "พธ.ด.", LEMMA: "พุทธศาสตรดุษฎีบัณฑิต"}],
    "พบ.บ.": [{ORTH: "พบ.บ.", LEMMA: "พัฒนบริหารศาสตรบัณฑิต"}],
    "พบ.ม.": [{ORTH: "พบ.ม.", LEMMA: "พัฒนบริหารศาสตรมหาบัณฑิต"}],
    "พบ.ด.": [{ORTH: "พบ.ด.", LEMMA: "พัฒนบริหารศาสตรดุษฎีบัณฑิต"}],
    "พย.บ.": [{ORTH: "พย.บ.", LEMMA: "พยาบาลศาสตรดุษฎีบัณฑิต"}],
    "พย.ม.": [{ORTH: "พย.ม.", LEMMA: "พยาบาลศาสตรมหาบัณฑิต"}],
    "พย.ด.": [{ORTH: "พย.ด.", LEMMA: "พยาบาลศาสตรดุษฎีบัณฑิต"}],
    "พศ.บ.": [{ORTH: "พศ.บ.", LEMMA: "พาณิชยศาสตรบัณฑิต"}],
    "พศ.ม.": [{ORTH: "พศ.ม.", LEMMA: "พาณิชยศาสตรมหาบัณฑิต"}],
    "พศ.ด.": [{ORTH: "พศ.ด.", LEMMA: "พาณิชยศาสตรดุษฎีบัณฑิต"}],
    "ภ.บ.": [{ORTH: "ภ.บ.", LEMMA: "เภสัชศาสตรบัณฑิต"}],
    "ภ.ม.": [{ORTH: "ภ.ม.", LEMMA: "เภสัชศาสตรมหาบัณฑิต"}],
    "ภ.ด.": [{ORTH: "ภ.ด.", LEMMA: "เภสัชศาสตรดุษฎีบัณฑิต"}],
    "ภ.สถ.บ.": [{ORTH: "ภ.สถ.บ.", LEMMA: "ภูมิสถาปัตยกรรมศาสตรบัณฑิต"}],
    "รป.บ.": [{ORTH: "รป.บ.", LEMMA: "รัฐประศาสนศาสตร์บัณฑิต"}],
    "รป.ม.": [{ORTH: "รป.ม.", LEMMA: "รัฐประศาสนศาสตร์มหาบัณฑิต"}],
    "วท.บ.": [{ORTH: "วท.บ.", LEMMA: "วิทยาศาสตรบัณฑิต"}],
    "วท.ม.": [{ORTH: "วท.ม.", LEMMA: "วิทยาศาสตรมหาบัณฑิต"}],
    "วท.ด.": [{ORTH: "วท.ด.", LEMMA: "วิทยาศาสตรดุษฎีบัณฑิต"}],
    "ศ.บ.": [{ORTH: "ศ.บ.", LEMMA: "ศิลปบัณฑิต"}],
    "ศศ.บ.": [{ORTH: "ศศ.บ.", LEMMA: "ศิลปศาสตรบัณฑิต"}],
    "ศษ.บ.": [{ORTH: "ศษ.บ.", LEMMA: "ศึกษาศาสตรบัณฑิต"}],
    "ศส.บ.": [{ORTH: "ศส.บ.", LEMMA: "เศรษฐศาสตรบัณฑิต"}],
    "สถ.บ.": [{ORTH: "สถ.บ.", LEMMA: "สถาปัตยกรรมศาสตรบัณฑิต"}],
    "สถ.ม.": [{ORTH: "สถ.ม.", LEMMA: "สถาปัตยกรรมศาสตรมหาบัณฑิต"}],
    "สถ.ด.": [{ORTH: "สถ.ด.", LEMMA: "สถาปัตยกรรมศาสตรดุษฎีบัณฑิต"}],
    "สพ.บ.": [{ORTH: "สพ.บ.", LEMMA: "สัตวแพทยศาสตรบัณฑิต"}],
    "อ.บ.": [{ORTH: "อ.บ.", LEMMA: "อักษรศาสตรบัณฑิต"}],
    "อ.ม.": [{ORTH: "อ.ม.", LEMMA: "อักษรศาสตรมหาบัณฑิต"}],
    "อ.ด.": [{ORTH: "อ.ด.", LEMMA: "อักษรศาสตรดุษฎีบัณฑิต"}],
    # ปี / เวลา / year / time
    "ชม.": [{ORTH: "ชม.", LEMMA: "ชั่วโมง"}],
    "จ.ศ.": [{ORTH: "จ.ศ.", LEMMA: "จุลศักราช"}],
    "ค.ศ.": [{ORTH: "ค.ศ.", LEMMA: "คริสต์ศักราช"}],
    "ฮ.ศ.": [{ORTH: "ฮ.ศ.", LEMMA: "ฮิจเราะห์ศักราช"}],
    "ว.ด.ป.": [{ORTH: "ว.ด.ป.", LEMMA: "วัน เดือน ปี"}],
    # ระยะทาง / distance
    "ฮม.": [{ORTH: "ฮม.", LEMMA: "เฮกโตเมตร"}],
    "ดคม.": [{ORTH: "ดคม.", LEMMA: "เดคาเมตร"}],
    "ดม.": [{ORTH: "ดม.", LEMMA: "เดซิเมตร"}],
    "มม.": [{ORTH: "มม.", LEMMA: "มิลลิเมตร"}],
    "ซม.": [{ORTH: "ซม.", LEMMA: "เซนติเมตร"}],
    "กม.": [{ORTH: "กม.", LEMMA: "กิโลเมตร"}],
    # น้ำหนัก / weight
    "น.น.": [{ORTH: "น.น.", LEMMA: "น้ำหนัก"}],
    "ฮก.": [{ORTH: "ฮก.", LEMMA: "เฮกโตกรัม"}],
    "ดคก.": [{ORTH: "ดคก.", LEMMA: "เดคากรัม"}],
    "ดก.": [{ORTH: "ดก.", LEMMA: "เดซิกรัม"}],
    "ซก.": [{ORTH: "ซก.", LEMMA: "เซนติกรัม"}],
    "มก.": [{ORTH: "มก.", LEMMA: "มิลลิกรัม"}],
    "ก.": [{ORTH: "ก.", LEMMA: "กรัม"}],
    "กก.": [{ORTH: "กก.", LEMMA: "กิโลกรัม"}],
    # ปริมาตร / volume
    "ฮล.": [{ORTH: "ฮล.", LEMMA: "เฮกโตลิตร"}],
    "ดคล.": [{ORTH: "ดคล.", LEMMA: "เดคาลิตร"}],
    "ดล.": [{ORTH: "ดล.", LEMMA: "เดซิลิตร"}],
    "ซล.": [{ORTH: "ซล.", LEMMA: "เซนติลิตร"}],
    "ล.": [{ORTH: "ล.", LEMMA: "ลิตร"}],
    "กล.": [{ORTH: "กล.", LEMMA: "กิโลลิตร"}],
    "ลบ.": [{ORTH: "ลบ.", LEMMA: "ลูกบาศก์"}],
    # พื้นที่ / area
    "ตร.ซม.": [{ORTH: "ตร.ซม.", LEMMA: "ตารางเซนติเมตร"}],
    "ตร.ม.": [{ORTH: "ตร.ม.", LEMMA: "ตารางเมตร"}],
    "ตร.ว.": [{ORTH: "ตร.ว.", LEMMA: "ตารางวา"}],
    "ตร.กม.": [{ORTH: "ตร.กม.", LEMMA: "ตารางกิโลเมตร"}],
    # เดือน / month
    "ม.ค.": [{ORTH: "ม.ค.", LEMMA: "มกราคม"}],
    "ก.พ.": [{ORTH: "ก.พ.", LEMMA: "กุมภาพันธ์"}],
    "มี.ค.": [{ORTH: "มี.ค.", LEMMA: "มีนาคม"}],
    "เม.ย.": [{ORTH: "เม.ย.", LEMMA: "เมษายน"}],
    "พ.ค.": [{ORTH: "พ.ค.", LEMMA: "พฤษภาคม"}],
    "มิ.ย.": [{ORTH: "มิ.ย.", LEMMA: "มิถุนายน"}],
    "ก.ค.": [{ORTH: "ก.ค.", LEMMA: "กรกฎาคม"}],
    "ส.ค.": [{ORTH: "ส.ค.", LEMMA: "สิงหาคม"}],
    "ก.ย.": [{ORTH: "ก.ย.", LEMMA: "กันยายน"}],
    "ต.ค.": [{ORTH: "ต.ค.", LEMMA: "ตุลาคม"}],
    "พ.ย.": [{ORTH: "พ.ย.", LEMMA: "พฤศจิกายน"}],
    "ธ.ค.": [{ORTH: "ธ.ค.", LEMMA: "ธันวาคม"}],
    # เพศ / gender
    "ช.": [{ORTH: "ช.", LEMMA: "ชาย"}],
    "ญ.": [{ORTH: "ญ.", LEMMA: "หญิง"}],
    "ด.ช.": [{ORTH: "ด.ช.", LEMMA: "เด็กชาย"}],
    "ด.ญ.": [{ORTH: "ด.ญ.", LEMMA: "เด็กหญิง"}],
    # ที่อยู่ / address
    "ถ.": [{ORTH: "ถ.", LEMMA: "ถนน"}],
    "ต.": [{ORTH: "ต.", LEMMA: "ตำบล"}],
    "อ.": [{ORTH: "อ.", LEMMA: "อำเภอ"}],
    "จ.": [{ORTH: "จ.", LEMMA: "จังหวัด"}],
    # สรรพนาม / pronoun
    "ข้าฯ": [{ORTH: "ข้าฯ", LEMMA: "ข้าพระพุทธเจ้า"}],
    "ทูลเกล้าฯ": [{ORTH: "ทูลเกล้าฯ", LEMMA: "ทูลเกล้าทูลกระหม่อม"}],
    "น้อมเกล้าฯ": [{ORTH: "น้อมเกล้าฯ", LEMMA: "น้อมเกล้าน้อมกระหม่อม"}],
    "โปรดเกล้าฯ": [{ORTH: "โปรดเกล้าฯ", LEMMA: "โปรดเกล้าโปรดกระหม่อม"}],
    # การเมือง / politic
    "ขจก.": [{ORTH: "ขจก.", LEMMA: "ขบวนการโจรก่อการร้าย"}],
    "ขบด.": [{ORTH: "ขบด.", LEMMA: "ขบวนการแบ่งแยกดินแดน"}],
    "นปช.": [{ORTH: "นปช.", LEMMA: "แนวร่วมประชาธิปไตยขับไล่เผด็จการ"}],
    "ปชป.": [{ORTH: "ปชป.", LEMMA: "พรรคประชาธิปัตย์"}],
    "ผกค.": [{ORTH: "ผกค.", LEMMA: "ผู้ก่อการร้ายคอมมิวนิสต์"}],
    "พท.": [{ORTH: "พท.", LEMMA: "พรรคเพื่อไทย"}],
    "พ.ร.ก.": [{ORTH: "พ.ร.ก.", LEMMA: "พระราชกำหนด"}],
    "พ.ร.ฎ.": [{ORTH: "พ.ร.ฎ.", LEMMA: "พระราชกฤษฎีกา"}],
    "พ.ร.บ.": [{ORTH: "พ.ร.บ.", LEMMA: "พระราชบัญญัติ"}],
    "รธน.": [{ORTH: "รธน.", LEMMA: "รัฐธรรมนูญ"}],
    "รบ.": [{ORTH: "รบ.", LEMMA: "รัฐบาล"}],
    "รสช.": [{ORTH: "รสช.", LEMMA: "คณะรักษาความสงบเรียบร้อยแห่งชาติ"}],
    "ส.ก.": [{ORTH: "ส.ก.", LEMMA: "สมาชิกสภากรุงเทพมหานคร"}],
    "สจ.": [{ORTH: "สจ.", LEMMA: "สมาชิกสภาจังหวัด"}],
    "สว.": [{ORTH: "สว.", LEMMA: "สมาชิกวุฒิสภา"}],
    "ส.ส.": [{ORTH: "ส.ส.", LEMMA: "สมาชิกสภาผู้แทนราษฎร"}],
    # ทั่วไป / general
    "ก.ข.ค.": [{ORTH: "ก.ข.ค.", LEMMA: "ก้างขวางคอ"}],
    "กทม.": [{ORTH: "กทม.", LEMMA: "กรุงเทพมหานคร"}],
    "กรุงเทพฯ": [{ORTH: "กรุงเทพฯ", LEMMA: "กรุงเทพมหานคร"}],
    "ขรก.": [{ORTH: "ขรก.", LEMMA: "ข้าราชการ"}],
    "ขส": [{ORTH: "ขส.", LEMMA: "ขนส่ง"}],
    "ค.ร.น.": [{ORTH: "ค.ร.น.", LEMMA: "คูณร่วมน้อย"}],
    "ค.ร.ม.": [{ORTH: "ค.ร.ม.", LEMMA: "คูณร่วมมาก"}],
    "ง.ด.": [{ORTH: "ง.ด.", LEMMA: "เงินเดือน"}],
    "งป.": [{ORTH: "งป.", LEMMA: "งบประมาณ"}],
    "จก.": [{ORTH: "จก.", LEMMA: "จำกัด"}],
    "จขกท.": [{ORTH: "จขกท.", LEMMA: "เจ้าของกระทู้"}],
    "จนท.": [{ORTH: "จนท.", LEMMA: "เจ้าหน้าที่"}],
    "จ.ป.ร.": [
        {
            ORTH: "จ.ป.ร.",
            LEMMA: "มหาจุฬาลงกรณ ปรมราชาธิราช (พระปรมาภิไธยในพระบาทสมเด็จพระจุลจอมเกล้าเจ้าอยู่หัว)",
        }
    ],
    "จ.ม.": [{ORTH: "จ.ม.", LEMMA: "จดหมาย"}],
    "จย.": [{ORTH: "จย.", LEMMA: "จักรยาน"}],
    "จยย.": [{ORTH: "จยย.", LEMMA: "จักรยานยนต์"}],
    "ตจว.": [{ORTH: "ตจว.", LEMMA: "ต่างจังหวัด"}],
    "โทร.": [{ORTH: "โทร.", LEMMA: "โทรศัพท์"}],
    "ธ.": [{ORTH: "ธ.", LEMMA: "ธนาคาร"}],
    "น.ร.": [{ORTH: "น.ร.", LEMMA: "นักเรียน"}],
    "น.ศ.": [{ORTH: "น.ศ.", LEMMA: "นักศึกษา"}],
    "น.ส.": [{ORTH: "น.ส.", LEMMA: "นางสาว"}],
    "น.ส.๓": [{ORTH: "น.ส.๓", LEMMA: "หนังสือรับรองการทำประโยชน์ในที่ดิน"}],
    "น.ส.๓ ก.": [
        {ORTH: "น.ส.๓ ก", LEMMA: "หนังสือแสดงกรรมสิทธิ์ในที่ดิน (มีระวางกำหนด)"}
    ],
    "นสพ.": [{ORTH: "นสพ.", LEMMA: "หนังสือพิมพ์"}],
    "บ.ก.": [{ORTH: "บ.ก.", LEMMA: "บรรณาธิการ"}],
    "บจก.": [{ORTH: "บจก.", LEMMA: "บริษัทจำกัด"}],
    "บงล.": [{ORTH: "บงล.", LEMMA: "บริษัทเงินทุนและหลักทรัพย์จำกัด"}],
    "บบส.": [{ORTH: "บบส.", LEMMA: "บรรษัทบริหารสินทรัพย์สถาบันการเงิน"}],
    "บมจ.": [{ORTH: "บมจ.", LEMMA: "บริษัทมหาชนจำกัด"}],
    "บลจ.": [{ORTH: "บลจ.", LEMMA: "บริษัทหลักทรัพย์จัดการกองทุนรวมจำกัด"}],
    "บ/ช": [{ORTH: "บ/ช", LEMMA: "บัญชี"}],
    "บร.": [{ORTH: "บร.", LEMMA: "บรรณารักษ์"}],
    "ปชช.": [{ORTH: "ปชช.", LEMMA: "ประชาชน"}],
    "ปณ.": [{ORTH: "ปณ.", LEMMA: "ที่ทำการไปรษณีย์"}],
    "ปณก.": [{ORTH: "ปณก.", LEMMA: "ที่ทำการไปรษณีย์กลาง"}],
    "ปณส.": [{ORTH: "ปณส.", LEMMA: "ที่ทำการไปรษณีย์สาขา"}],
    "ปธ.": [{ORTH: "ปธ.", LEMMA: "ประธาน"}],
    "ปธน.": [{ORTH: "ปธน.", LEMMA: "ประธานาธิบดี"}],
    "ปอ.": [{ORTH: "ปอ.", LEMMA: "รถยนต์โดยสารประจำทางปรับอากาศ"}],
    "ปอ.พ.": [{ORTH: "ปอ.พ.", LEMMA: "รถยนต์โดยสารประจำทางปรับอากาศพิเศษ"}],
    "พ.ก.ง.": [{ORTH: "พ.ก.ง.", LEMMA: "พัสดุเก็บเงินปลายทาง"}],
    "พ.ก.ส.": [{ORTH: "พ.ก.ส.", LEMMA: "พนักงานเก็บค่าโดยสาร"}],
    "พขร.": [{ORTH: "พขร.", LEMMA: "พนักงานขับรถ"}],
    "ภ.ง.ด.": [{ORTH: "ภ.ง.ด.", LEMMA: "ภาษีเงินได้"}],
    "ภ.ง.ด.๙": [{ORTH: "ภ.ง.ด.๙", LEMMA: "แบบแสดงรายการเสียภาษีเงินได้ของกรมสรรพากร"}],
    "ภ.ป.ร.": [
        {
            ORTH: "ภ.ป.ร.",
            LEMMA: "ภูมิพลอดุยเดช ปรมราชาธิราช (พระปรมาภิไธยในพระบาทสมเด็จพระปรมินทรมหาภูมิพลอดุลยเดช)",
        }
    ],
    "ภ.พ.": [{ORTH: "ภ.พ.", LEMMA: "ภาษีมูลค่าเพิ่ม"}],
    "ร.": [{ORTH: "ร.", LEMMA: "รัชกาล"}],
    "ร.ง.": [{ORTH: "ร.ง.", LEMMA: "โรงงาน"}],
    "ร.ด.": [{ORTH: "ร.ด.", LEMMA: "รักษาดินแดน"}],
    "รปภ.": [{ORTH: "รปภ.", LEMMA: "รักษาความปลอดภัย"}],
    "รพ.": [{ORTH: "รพ.", LEMMA: "โรงพยาบาล"}],
    "ร.พ.": [{ORTH: "ร.พ.", LEMMA: "โรงพิมพ์"}],
    "รร.": [{ORTH: "รร.", LEMMA: "โรงเรียน,โรงแรม"}],
    "รสก.": [{ORTH: "รสก.", LEMMA: "รัฐวิสาหกิจ"}],
    "ส.ค.ส.": [{ORTH: "ส.ค.ส.", LEMMA: "ส่งความสุขปีใหม่"}],
    "สต.": [{ORTH: "สต.", LEMMA: "สตางค์"}],
    "สน.": [{ORTH: "สน.", LEMMA: "สถานีตำรวจ"}],
    "สนข.": [{ORTH: "สนข.", LEMMA: "สำนักงานเขต"}],
    "สนง.": [{ORTH: "สนง.", LEMMA: "สำนักงาน"}],
    "สนญ.": [{ORTH: "สนญ.", LEMMA: "สำนักงานใหญ่"}],
    "ส.ป.ช.": [{ORTH: "ส.ป.ช.", LEMMA: "สร้างเสริมประสบการณ์ชีวิต"}],
    "สภ.": [{ORTH: "สภ.", LEMMA: "สถานีตำรวจภูธร"}],
    "ส.ล.น.": [{ORTH: "ส.ล.น.", LEMMA: "สร้างเสริมลักษณะนิสัย"}],
    "สวญ.": [{ORTH: "สวญ.", LEMMA: "สารวัตรใหญ่"}],
    "สวป.": [{ORTH: "สวป.", LEMMA: "สารวัตรป้องกันปราบปราม"}],
    "สว.สส.": [{ORTH: "สว.สส.", LEMMA: "สารวัตรสืบสวน"}],
    "ส.ห.": [{ORTH: "ส.ห.", LEMMA: "สารวัตรทหาร"}],
    "สอ.": [{ORTH: "สอ.", LEMMA: "สถานีอนามัย"}],
    "สอท.": [{ORTH: "สอท.", LEMMA: "สถานเอกอัครราชทูต"}],
    "เสธ.": [{ORTH: "เสธ.", LEMMA: "เสนาธิการ"}],
    "หจก.": [{ORTH: "หจก.", LEMMA: "ห้างหุ้นส่วนจำกัด"}],
    "ห.ร.ม.": [{ORTH: "ห.ร.ม.", LEMMA: "ตัวหารร่วมมาก"}],
}


TOKENIZER_EXCEPTIONS = _exc
