# coding: utf8
from __future__ import unicode_literals

from ...symbols import POS, PUNCT, SYM, ADJ, NUM, DET, ADV, ADP, X, VERB
from ...symbols import NOUN, PROPN, PART, INTJ, SPACE, PRON, SCONJ, AUX, CONJ


TAG_MAP = {
    "AP__Gender=Fem|Number=Plur|Poss=Yes|PronType=Prs": {POS: DET},
    "AP__Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs": {POS: DET},
    "AP__Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs": {POS: DET},
    "AP__Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs": {POS: DET},
    "AP__Gender=Masc|Poss=Yes|PronType=Prs": {POS: DET},
    "AP__Number=Sing|Poss=Yes|PronType=Prs": {POS: DET},
    "AP__Poss=Yes|PronType=Prs": {POS: DET},
    "A__Degree=Abs|Gender=Fem|Number=Plur": {POS: ADJ},
    "A__Degree=Abs|Gender=Fem|Number=Sing": {POS: ADJ},
    "A__Degree=Abs|Gender=Masc|Number=Plur": {POS: ADJ},
    "A__Degree=Abs|Gender=Masc|Number=Sing": {POS: ADJ},
    "A__Degree=Cmp": {POS: ADJ},
    "A__Degree=Cmp|Number=Plur": {POS: ADJ},
    "A__Degree=Cmp|Number=Sing": {POS: ADJ},
    "A__Gender=Fem|Number=Plur": {POS: ADJ},
    "A__Gender=Fem|Number=Sing": {POS: ADJ},
    "A__Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs": {POS: ADJ},
    "A__Gender=Masc": {POS: ADJ},
    "A__Gender=Masc|Number=Plur": {POS: ADJ},
    "A__Gender=Masc|Number=Sing": {POS: ADJ},
    "A__Number=Plur": {POS: ADJ},
    "A__Number=Sing": {POS: ADJ},
    "A___": {POS: ADJ},
    "BN__PronType=Neg": {POS: ADV},
    "B__Degree=Abs": {POS: ADV},
    "B__Degree=Abs|Gender=Masc|Number=Sing": {POS: ADV},
    "B___": {POS: ADV},
    "CC___": {POS: CONJ},
    "CS___": {POS: SCONJ},
    "DD__Gender=Fem|Number=Plur|PronType=Dem": {POS: DET},
    "DD__Gender=Fem|Number=Sing|PronType=Dem": {POS: DET},
    "DD__Gender=Masc|Number=Plur|PronType=Dem": {POS: DET},
    "DD__Gender=Masc|Number=Sing|PronType=Dem": {POS: DET},
    "DD__Gender=Masc|PronType=Dem": {POS: DET},
    "DD__Number=Plur|PronType=Dem": {POS: DET},
    "DD__Number=Sing|PronType=Dem": {POS: DET},
    "DE__PronType=Exc": {POS: DET},
    "DI__Definite=Def|Gender=Fem|Number=Plur|PronType=Art": {POS: DET},
    "DI__Gender=Fem|Number=Plur": {POS: DET},
    "DI__Gender=Fem|Number=Plur|PronType=Ind": {POS: DET},
    "DI__Gender=Fem|Number=Sing|PronType=Ind": {POS: DET},
    "DI__Gender=Masc|Number=Plur": {POS: DET},
    "DI__Gender=Masc|Number=Plur|PronType=Ind": {POS: DET},
    "DI__Gender=Masc|Number=Sing|PronType=Ind": {POS: DET},
    "DI__Number=Sing|PronType=Art": {POS: DET},
    "DI__Number=Sing|PronType=Ind": {POS: DET},
    "DI__PronType=Ind": {POS: DET},
    "DQ__Gender=Fem|Number=Plur|PronType=Int": {POS: DET},
    "DQ__Gender=Fem|Number=Sing|PronType=Int": {POS: DET},
    "DQ__Gender=Masc|Number=Plur|PronType=Int": {POS: DET},
    "DQ__Gender=Masc|Number=Sing|PronType=Int": {POS: DET},
    "DQ__Number=Plur|PronType=Int": {POS: DET},
    "DQ__Number=Sing|PronType=Int": {POS: DET},
    "DQ__PronType=Int": {POS: DET},
    "DQ___": {POS: DET},
    "DR__Number=Plur|PronType=Rel": {POS: DET},
    "DR__PronType=Rel": {POS: DET},
    "E__Gender=Masc|Number=Sing": {POS: ADP},
    "E___": {POS: ADP},
    "FB___": {POS: PUNCT},
    "FC___": {POS: PUNCT},
    "FF___": {POS: PUNCT},
    "FS___": {POS: PUNCT},
    "I__Polarity=Neg": {POS: INTJ},
    "I__Polarity=Pos": {POS: INTJ},
    "I___": {POS: INTJ},
    "NO__Gender=Fem|Number=Plur|NumType=Ord": {POS: ADJ},
    "NO__Gender=Fem|Number=Sing|NumType=Ord": {POS: ADJ},
    "NO__Gender=Masc|Number=Plur": {POS: ADJ},
    "NO__Gender=Masc|Number=Plur|NumType=Ord": {POS: ADJ},
    "NO__Gender=Masc|Number=Sing|NumType=Ord": {POS: ADJ},
    "NO__NumType=Ord": {POS: ADJ},
    "NO__Number=Sing|NumType=Ord": {POS: ADJ},
    "NO___": {POS: ADJ},
    "N__Gender=Masc|Number=Sing": {POS: NUM},
    "N__NumType=Card": {POS: NUM},
    "N__NumType=Range": {POS: NUM},
    "N___": {POS: NUM},
    "PART___": {POS: PART},
    "PC__Clitic=Yes|Definite=Def|Gender=Fem|Number=Plur|PronType=Art": {POS: PRON},
    "PC__Clitic=Yes|Gender=Fem|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Gender=Fem|Number=Plur|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Gender=Fem|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Gender=Fem|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Gender=Masc|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Gender=Masc|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Gender=Masc|Number=Sing|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Plur|Person=1|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Plur|Person=2|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Plur|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Sing|Person=1|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Sing|Person=2|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|Person=3|PronType=Prs": {POS: PRON},
    "PC__Clitic=Yes|PronType=Prs": {POS: PRON},
    "PD__Gender=Fem|Number=Plur|PronType=Dem": {POS: PRON},
    "PD__Gender=Fem|Number=Sing|PronType=Dem": {POS: PRON},
    "PD__Gender=Masc|Number=Plur|PronType=Dem": {POS: PRON},
    "PD__Gender=Masc|Number=Sing|PronType=Dem": {POS: PRON},
    "PD__Number=Plur|PronType=Dem": {POS: PRON},
    "PD__Number=Sing|PronType=Dem": {POS: PRON},
    "PD__PronType=Dem": {POS: PRON},
    "PE__Gender=Fem|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PE__Gender=Fem|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PE__Gender=Masc|Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PE__Gender=Masc|Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PE__Number=Plur|Person=1|PronType=Prs": {POS: PRON},
    "PE__Number=Plur|Person=2|PronType=Prs": {POS: PRON},
    "PE__Number=Plur|Person=3|PronType=Prs": {POS: PRON},
    "PE__Number=Sing|Person=1|PronType=Prs": {POS: PRON},
    "PE__Number=Sing|Person=2|PronType=Prs": {POS: PRON},
    "PE__Number=Sing|Person=3|PronType=Prs": {POS: PRON},
    "PE__Person=3|PronType=Prs": {POS: PRON},
    "PE__PronType=Prs": {POS: PRON},
    "PI__Gender=Fem|Number=Plur|PronType=Ind": {POS: PRON},
    "PI__Gender=Fem|Number=Sing|PronType=Ind": {POS: PRON},
    "PI__Gender=Masc|Number=Plur|PronType=Ind": {POS: PRON},
    "PI__Gender=Masc|Number=Sing": {POS: PRON},
    "PI__Gender=Masc|Number=Sing|PronType=Ind": {POS: PRON},
    "PI__Number=Plur|PronType=Ind": {POS: PRON},
    "PI__Number=Sing|PronType=Ind": {POS: PRON},
    "PI__PronType=Ind": {POS: PRON},
    "PP__Gender=Fem|Number=Sing|Poss=Yes|PronType=Prs": {POS: PRON},
    "PP__Gender=Masc|Number=Plur|Poss=Yes|PronType=Prs": {POS: PRON},
    "PP__Gender=Masc|Number=Sing|Poss=Yes|PronType=Prs": {POS: PRON},
    "PP__Number=Plur|Poss=Yes|PronType=Prs": {POS: PRON},
    "PP__Number=Sing|Poss=Yes|PronType=Prs": {POS: PRON},
    "PQ__Gender=Fem|Number=Plur|PronType=Int": {POS: PRON},
    "PQ__Gender=Fem|Number=Sing|PronType=Int": {POS: PRON},
    "PQ__Gender=Masc|Number=Plur|PronType=Int": {POS: PRON},
    "PQ__Gender=Masc|Number=Sing|PronType=Int": {POS: PRON},
    "PQ__Number=Plur|PronType=Int": {POS: PRON},
    "PQ__Number=Sing|PronType=Int": {POS: PRON},
    "PQ__PronType=Int": {POS: PRON},
    "PR__Gender=Masc|Number=Plur|PronType=Rel": {POS: PRON},
    "PR__Gender=Masc|Number=Sing|PronType=Rel": {POS: PRON},
    "PR__Gender=Masc|PronType=Rel": {POS: PRON},
    "PR__Number=Plur|PronType=Rel": {POS: PRON},
    "PR__Number=Sing|PronType=Rel": {POS: PRON},
    "PR__Person=3|PronType=Rel": {POS: PRON},
    "PR__PronType=Rel": {POS: PRON},
    "RD__Definite=Def": {POS: DET},
    "RD__Definite=Def|Gender=Fem": {POS: DET},
    "RD__Definite=Def|Gender=Fem|Number=Plur|PronType=Art": {POS: DET},
    "RD__Definite=Def|Gender=Fem|Number=Sing|PronType=Art": {POS: DET},
    "RD__Definite=Def|Gender=Masc|Number=Plur|PronType=Art": {POS: DET},
    "RD__Definite=Def|Gender=Masc|Number=Sing|PronType=Art": {POS: DET},
    "RD__Definite=Def|Number=Plur|PronType=Art": {POS: DET},
    "RD__Definite=Def|Number=Sing|PronType=Art": {POS: DET},
    "RD__Definite=Def|PronType=Art": {POS: DET},
    "RD__Gender=Fem|Number=Sing": {POS: DET},
    "RD__Gender=Masc|Number=Sing": {POS: DET},
    "RD__Number=Sing": {POS: DET},
    "RD__Number=Sing|PronType=Art": {POS: DET},
    "RI__Definite=Ind|Gender=Fem|Number=Plur|PronType=Art": {POS: DET},
    "RI__Definite=Ind|Gender=Fem|Number=Sing|PronType=Art": {POS: DET},
    "RI__Definite=Ind|Gender=Masc|Number=Plur|PronType=Art": {POS: DET},
    "RI__Definite=Ind|Gender=Masc|Number=Sing|PronType=Art": {POS: DET},
    "RI__Definite=Ind|Number=Sing|PronType=Art": {POS: DET},
    "RI__Definite=Ind|PronType=Art": {POS: DET},
    "SP__Gender=Fem|Number=Plur": {POS: PROPN},
    "SP__NumType=Card": {POS: PROPN},
    "SP___": {POS: PROPN},
    "SW__Foreign=Yes": {POS: X},
    "SW__Foreign=Yes|Gender=Masc": {POS: X},
    "SW__Foreign=Yes|Number=Sing": {POS: X},
    "SYM___": {POS: SYM},
    "S__Gender=Fem": {POS: NOUN},
    "S__Gender=Fem|Number=Plur": {POS: NOUN},
    "S__Gender=Fem|Number=Sing": {POS: NOUN},
    "S__Gender=Masc": {POS: NOUN},
    "S__Gender=Masc|Number=Plur": {POS: NOUN},
    "S__Gender=Masc|Number=Sing": {POS: NOUN},
    "S__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part": {POS: NOUN},
    "S__Number=Plur": {POS: NOUN},
    "S__Number=Sing": {POS: NOUN},
    "S___": {POS: NOUN},
    "Sw___": {POS: X},
    "T__Gender=Fem|Number=Plur|PronType=Tot": {POS: DET},
    "T__Gender=Fem|Number=Sing": {POS: DET},
    "T__Gender=Fem|Number=Sing|PronType=Tot": {POS: DET},
    "T__Gender=Masc|Number=Plur|PronType=Tot": {POS: DET},
    "T__Gender=Masc|Number=Sing|PronType=Tot": {POS: DET},
    "T__Number=Plur|PronType=Tot": {POS: DET},
    "T__PronType=Tot": {POS: DET},
    "VA__Gender=Fem|Number=Plur|Tense=Past|VerbForm=Part": {POS: AUX},
    "VA__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part": {POS: AUX},
    "VA__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Part": {POS: AUX},
    "VA__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part": {POS: AUX},
    "VA__Mood=Cnd|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Cnd|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Cnd|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Cnd|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=2|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=2|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=3|Tense=Past|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=1|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=1|Tense=Past|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=2|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=3|Tense=Past|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Sub|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Sub|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Sub|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Sub|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Sub|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VA__Mood=Sub|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VA__VerbForm=Ger": {POS: AUX},
    "VA__VerbForm=Inf": {POS: AUX},
    "VM__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part": {POS: AUX},
    "VM__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part": {POS: AUX},
    "VM__Mood=Cnd|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Cnd|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Cnd|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Cnd|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Cnd|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Cnd|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Imp|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Imp|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=2|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=3|Tense=Past|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=2|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=2|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=3|Tense=Past|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Sub|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Sub|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Sub|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Sub|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Sub|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: AUX},
    "VM__Mood=Sub|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: AUX},
    "VM__VerbForm=Ger": {POS: AUX},
    "VM__VerbForm=Inf": {POS: AUX},
    "V__Gender=Fem|Number=Plur|Tense=Past|VerbForm=Part": {POS: VERB},
    "V__Gender=Fem|Number=Sing|Tense=Past|VerbForm=Part": {POS: VERB},
    "V__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Fin": {POS: VERB},
    "V__Gender=Masc|Number=Plur|Tense=Past|VerbForm=Part": {POS: VERB},
    "V__Gender=Masc|Number=Sing|Tense=Past|VerbForm=Part": {POS: VERB},
    "V__Mood=Cnd|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Cnd|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Cnd|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Cnd|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Cnd|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Cnd|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Imp|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Imp|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Imp|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Imp|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=1|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=1|Tense=Past|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=2|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=3|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=3|Tense=Past|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=1|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=1|Tense=Past|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=2|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=3|Tense=Fut|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=3|Tense=Past|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Ind|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Plur|Person=1|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Plur|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Plur|Person=2|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Plur|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Plur|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Sing|Person=1|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Sing|Person=1|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Sing|Person=2|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Sing|Person=3|Tense=Imp|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Sing|Person=3|Tense=Pres|VerbForm=Fin": {POS: VERB},
    "V__Mood=Sub|Number=Sing|Person=3|VerbForm=Fin": {POS: VERB},
    "V__Number=Plur|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V__Number=Sing|Tense=Pres|VerbForm=Part": {POS: VERB},
    "V__Tense=Past|VerbForm=Part": {POS: VERB},
    "V__VerbForm=Ger": {POS: VERB},
    "V__VerbForm=Inf": {POS: VERB},
    "X___": {POS: X},
    "_SP": {POS: SPACE},
}
