#!/usr/local/bin/python
#
# Copyright (c) 2003, 2004 Neil Blakey-Milner
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

import re
import urlparse

def any_of(aString, aList):
    """Checks if any strings in aList appear in aString"""

    for match in aList:
        if aString.count(match):
            return 1
    return 0

# From Mark Pilgrim's sitestats
def simplifyReferer(aReferer):
    """Change an URL to a simplified referer form"""

    if aReferer[:5] == "news:":
        rc = "news:"
    else:
        urldata = urlparse.urlparse(aReferer)
        domain = urldata[1].lower()
        if domain == 'radio.weblogs.com':
            radioid = urldata[2][1:].split('/', 1)[0]
            if radioid:
                domain += '/' + urldata[2].split('/')[1] + '/'
        if domain.find('.google.') > -1:
            domain = 'google.com'
        domain = re.sub('^www[.]', '', domain)
        if domain.find('search.yahoo.') > -1:
            domain = 'search.yahoo.com'
        if domain.find('search.msn.') > -1:
            domain = 'search.msn.com'
        if domain.find('.ask.') > -1:
            domain = 'ask.com'
    return domain

def concat(aString, length):
    """If a string is over a specific length, truncate them and add
    ellipsis to shorten it to the specific length."""

    if len(aString) < length:
        return aString
    return aString[:length - 3] + "..."

