#!/usr/local/bin/python
#
# Copyright (c) 2003 Neil Blakey-Milner
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

# sibling imports
import agentparsing
import config
import util

def excludeReferer(aReferer):
    """Check whether a referer should be allowed in the referer list"""

    if aReferer in config.EXCLUDEDREFERERS:
        # internal traffic, referer spammers, &c.
        return 1
    if aReferer.count(':5335'):
        # Radio pages, as per Mark Pilgrim's sitestats
        return 1
    return 0

def excludedIP(aLine):
    """Check whether a log entry should be processed based on the IP"""
    if aLine["ip"] in config.EXCLUDEIPS:
        return 1
    return 0

def excludeSearches(aSearch):
    """Check whether a search should be allowed in the search list"""
    if aSearch in config.EXCLUDESEARCHES:
        return 1
    return 0

def excludedBot(aLine):
    """Check whether a log entry should be processed based on the Agent"""
    a = agentparsing.isBot(aLine["agent"])
    return a

def excludedURL(aLine):
    """Check whether a log entry should be processed based on the URL"""
    url = aLine["url"]
    return util.any_of(url, config.IGNORE_URLS)

def excludeFailures(aLine):
    """Check whether a log entry should be processed based on the HTTP code"""
    code = aLine["code"]
    if code in config.EXCLUDEDRESPONSES:
        return 1
    return 0

