#!/bin/bash
#
# test_shellwords.sh
# (C) Copyright 2002 by Hartmut Goebel <h.goebel@crazy-compilers.com>
#
# This script may be used in three ways:
#
# 1) Called without any argument:
#    This will read in test data from $TESTDATA and output
#    the results (one test in a line).
#    The result is generated by calling this script recursively
#    with arguments (see number 3 below).
#
# 2) Called with first argument '--line-by-line'
#    This is the same like the next option but outputs each
#    argument on a seperate line. This is intedet to be used
#    when called by 'test_shellwords.py'
#
# 3) Called with some arguments
#    This will output the supplied arguments seperated by bars.
#

if [ "$#" -ne 0 ] ; then # called with arguments
    if [ "$1" = "--line-by-line" ] ; then
	# option is used when called from test_shellwords.py
	shift # remove the option
	exec 2>&1
	# output all words/arguments, one per line
	for i in "$@" ; do
	    # prepend a hash-mark to distingish between 
	    # empty args an no args at all
	    echo -E "#$i"
	done
    else
	# output all words/arguments, seperated by bars
	for i in "$@" ; do
	    echo -nE "|$i| "
	done
	echo
    fi
    exit 0
fi

PROGRAM_NAME=$0
TESTDATE=$(dirname $PROGRAM_NAME)/test/test_data.txt

cat $TESTDATE | (
    read -r
    while [ $? -eq 0 ] ; do
	if [ -n "${REPLY/\\#*}" ] ; then
	    echo -nE $REPLY 
	    echo -en "\t"
	    # recursively call this script again
	    # this as to be piped into 'bash' to make quotes and
	    # escapes to be handled/expanded
	    echo "$PROGRAM_NAME $REPLY" | bash
	fi
	read -r
    done
)
