# SentiPy

> Welcome to the Sentiment Investor API wrapper. This package can be used to easily access trending stocks and individual ticker data from the sentimentinvestor.com website. 

## Installing

SentiPy can be installed with [pip](https://pip.pypa.io/en/stable/):

```
$ python3 -m pip install sentiment-investor
```

On macOS, it can also be installed via [MacPorts](https://ports.macports.org/port/py-sentipy/):

```
$ sudo port install py-sentipy
```

## Setup

To use this package you will need a developer token and key, which can be obtained from [sentimentinvestor.com/developer/dashboard](https://sentimentinvestor.com/developer/dashboard). 

## Documentation

SentiPy has usage and reference documentation at [sentimentinvestor.com/developer/python-docs](https://sentimentinvestor.com/developer/python-docs).

## 🤝 Contributing

Contributions, issues and feature requests are welcome!<br />Feel free to check the [issues page](https://github.com/sentimentinvestor/sentipy/issues).

### Geting Started

First, fork the [GitHub project](https://github.com/sentimentinvestor/sentipy) to your account. Then, run the following with your GitHub handle in place of `INSERT_GITHUB_NAME`:

```sh
$ git clone https://github.com/INSERT_GITHUB_NAME/sentipy
$ cd sentipy
$ poetry install && poetry shell
$ pre-commit install
```

This then runs the formatters when you're about to commit any changes.

### Authors

The following people have made notable contributions to the development of this library (in chronological order):

- [Rob Stock](https://github.com/lipton-green-tea)
- [Timothy Langer](https://github.com/ZeevoX)
- [Haren S](https://github.com/harens)

The full list of contributors is [here](https://github.com/sentimentinvestor/sentipy/graphs/contributors).

## Licence

SentiPy is made available under the MIT Licence. For more details, see [LICENSE.txt](https://github.com/sentimentinvestor/sentipy/blob/master/LICENSE).
