import pathlib
from setuptools import find_packages, setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="sentiment-investor",
    version="2.0.0",
    description="Access the Sentiment Investor API through Python",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://sentimentinvestor.com",
    author="Robert Stok",
    author_email="rs.stok@gmail.com",
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
    ],
    packages=find_packages(exclude=("tests",)),
    include_package_data=True,
    install_requires=find_packages(exclude=("tests",)),
    entry_points={},
)
