#-----------------------------------------------------------------------------
#
#  Copyright (c) 2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: Greg Rogers
#
#-----------------------------------------------------------------------------

""" Public API for units system. """

from __future__ import absolute_import
from scimath.units.unit_manager import unit_manager
from scimath.units.unit_system import UnitSystem
from scimath.units.unit_parser import unit_parser

from .unit_traits import UnitsTrait, UnitSystemTrait
from .family_name_trait import FamilyNameTrait

from scimath.units.unit import unit, dimensionless

from .quantity import Quantity
from .meta_quantity import MetaQuantity

from .convert import convert, parser, convert_str

from .has_units import has_units
from .function_signature import (call_signature, def_signature,
                                 function_arguments)
from .unit_array import UnitArray
from .unit_scalar import UnitScalar
