# Pull Requests

Here are some guidelines for pull requests:

* All work is submitted via Pull Requests.
* Pull Requests can be submitted as soon as there is code worth discussing. The worst case is that the PR is closed.
* Pull Requests should be made against master
* Pull Requests should be tested, if feasible:
    - bugfixes should include regression tests.
    - new behavior should at least get minimal exercise.
    - new features should include a screenshot
* Don't make 'cleanup' pull requests just to change code style. We don't follow any style guide strictly, and we consider formatting changes unnecessary noise. If you're making functional changes, you can clean up the specific pieces of code you're working on.

Pyvis wraps  vis.js so JavaScript functionality issues should be directed at the main `vis.js` project.

# Other contributions

Outside of Pull Requests (PRs), we welcome additions/corrections/clarification to the existing documentation as contributions at least as valuable as code submissions.  
