import CoreServices
from PyObjCTools.TestSupport import TestCase


class TestFiles(TestCase):
    def assert_not_wrapped(self, name):
        self.assertTrue(
            not hasattr(CoreServices, name), "%r exposed in bindings" % (name,)
        )

    def test_not_wrapped(self):
        self.assert_not_wrapped("HFSUniStr255")
        self.assert_not_wrapped("kFSFileSecurityRemoveACL")
        self.assert_not_wrapped("fsCurPerm")
        self.assert_not_wrapped("fsRdPerm")
        self.assert_not_wrapped("fsWrPerm")
        self.assert_not_wrapped("fsRdWrPerm")
        self.assert_not_wrapped("fsRdWrShPerm")
        self.assert_not_wrapped("fsRdAccessPerm")
        self.assert_not_wrapped("fsWrAccessPerm")
        self.assert_not_wrapped("fsRdDenyPerm")
        self.assert_not_wrapped("fsWrDenyPerm")
        self.assert_not_wrapped("fsRtParID")
        self.assert_not_wrapped("fsRtDirID")
        self.assert_not_wrapped("fsAtMark")
        self.assert_not_wrapped("fsFromStart")
        self.assert_not_wrapped("fsFromLEOF")
        self.assert_not_wrapped("fsFromMark")
        self.assert_not_wrapped("kFSAllowConcurrentAsyncIOMask")
        self.assert_not_wrapped("kFSPleaseCacheBit")
        self.assert_not_wrapped("kFSPleaseCacheMask")
        self.assert_not_wrapped("kFSNoCacheBit")
        self.assert_not_wrapped("kFSNoCacheMask")
        self.assert_not_wrapped("kFSRdVerifyBit")
        self.assert_not_wrapped("kFSRdVerifyMask")
        self.assert_not_wrapped("kFSForceReadBit")
        self.assert_not_wrapped("kFSForceReadMask")
        self.assert_not_wrapped("kFSNewLineBit")
        self.assert_not_wrapped("kFSNewLineMask")
        self.assert_not_wrapped("kFSNewLineCharMask")
        self.assert_not_wrapped("fsSBPartialName")
        self.assert_not_wrapped("fsSBFullName")
        self.assert_not_wrapped("fsSBFlAttrib")
        self.assert_not_wrapped("fsSBFlFndrInfo")
        self.assert_not_wrapped("fsSBFlLgLen")
        self.assert_not_wrapped("fsSBFlPyLen")
        self.assert_not_wrapped("fsSBFlRLgLen")
        self.assert_not_wrapped("fsSBFlRPyLen")
        self.assert_not_wrapped("fsSBFlCrDat")
        self.assert_not_wrapped("fsSBFlMdDat")
        self.assert_not_wrapped("fsSBFlBkDat")
        self.assert_not_wrapped("fsSBFlXFndrInfo")
        self.assert_not_wrapped("fsSBFlParID")
        self.assert_not_wrapped("fsSBNegate")
        self.assert_not_wrapped("fsSBDrUsrWds")
        self.assert_not_wrapped("fsSBDrNmFls")
        self.assert_not_wrapped("fsSBDrCrDat")
        self.assert_not_wrapped("fsSBDrMdDat")
        self.assert_not_wrapped("fsSBDrBkDat")
        self.assert_not_wrapped("fsSBDrFndrInfo")
        self.assert_not_wrapped("fsSBDrParID")
        self.assert_not_wrapped("fsSBNodeID")
        self.assert_not_wrapped("fsSBAttributeModDate")
        self.assert_not_wrapped("fsSBAccessDate")
        self.assert_not_wrapped("fsSBPermissions")
        self.assert_not_wrapped("fsSBSkipPackageContents")
        self.assert_not_wrapped("fsSBSkipHiddenItems")
        self.assert_not_wrapped("fsSBUserID")
        self.assert_not_wrapped("fsSBGroupID")
        self.assert_not_wrapped("fsSBPartialNameBit")
        self.assert_not_wrapped("fsSBFullNameBit")
        self.assert_not_wrapped("fsSBFlAttribBit")
        self.assert_not_wrapped("fsSBFlFndrInfoBit")
        self.assert_not_wrapped("fsSBFlLgLenBit")
        self.assert_not_wrapped("fsSBFlPyLenBit")
        self.assert_not_wrapped("fsSBFlRLgLenBit")
        self.assert_not_wrapped("fsSBFlRPyLenBit")
        self.assert_not_wrapped("fsSBFlCrDatBit")
        self.assert_not_wrapped("fsSBFlMdDatBit")
        self.assert_not_wrapped("fsSBFlBkDatBit")
        self.assert_not_wrapped("fsSBFlXFndrInfoBit")
        self.assert_not_wrapped("fsSBFlParIDBit")
        self.assert_not_wrapped("fsSBNegateBit")
        self.assert_not_wrapped("fsSBDrUsrWdsBit")
        self.assert_not_wrapped("fsSBDrNmFlsBit")
        self.assert_not_wrapped("fsSBDrCrDatBit")
        self.assert_not_wrapped("fsSBDrMdDatBit")
        self.assert_not_wrapped("fsSBDrBkDatBit")
        self.assert_not_wrapped("fsSBDrFndrInfoBit")
        self.assert_not_wrapped("fsSBDrParIDBit")
        self.assert_not_wrapped("fsSBNodeIDBit")
        self.assert_not_wrapped("fsSBAttributeModDateBit")
        self.assert_not_wrapped("fsSBAccessDateBit")
        self.assert_not_wrapped("fsSBPermissionsBit")
        self.assert_not_wrapped("fsSBSkipPackageContentsBit")
        self.assert_not_wrapped("fsSBSkipHiddenItemsBit")
        self.assert_not_wrapped("fsSBUserIDBit")
        self.assert_not_wrapped("fsSBGroupIDBit")
        self.assert_not_wrapped("bLimitFCBs")
        self.assert_not_wrapped("bLocalWList")
        self.assert_not_wrapped("bNoMiniFndr")
        self.assert_not_wrapped("bNoVNEdit")
        self.assert_not_wrapped("bNoLclSync")
        self.assert_not_wrapped("bTrshOffLine")
        self.assert_not_wrapped("bNoSwitchTo")
        self.assert_not_wrapped("bNoDeskItems")
        self.assert_not_wrapped("bNoBootBlks")
        self.assert_not_wrapped("bAccessCntl")
        self.assert_not_wrapped("bNoSysDir")
        self.assert_not_wrapped("bHasExtFSVol")
        self.assert_not_wrapped("bHasOpenDeny")
        self.assert_not_wrapped("bHasCopyFile")
        self.assert_not_wrapped("bHasMoveRename")
        self.assert_not_wrapped("bHasDesktopMgr")
        self.assert_not_wrapped("bHasShortName")
        self.assert_not_wrapped("bHasFolderLock")
        self.assert_not_wrapped("bHasPersonalAccessPrivileges")
        self.assert_not_wrapped("bHasUserGroupList")
        self.assert_not_wrapped("bHasCatSearch")
        self.assert_not_wrapped("bHasFileIDs")
        self.assert_not_wrapped("bHasBTreeMgr")
        self.assert_not_wrapped("bHasBlankAccessPrivileges")
        self.assert_not_wrapped("bSupportsAsyncRequests")
        self.assert_not_wrapped("bSupportsTrashVolumeCache")
        self.assert_not_wrapped("bHasDirectIO")
        self.assert_not_wrapped("bIsEjectable")
        self.assert_not_wrapped("bSupportsHFSPlusAPIs")
        self.assert_not_wrapped("bSupportsFSCatalogSearch")
        self.assert_not_wrapped("bSupportsFSExchangeObjects")
        self.assert_not_wrapped("bSupports2TBFiles")
        self.assert_not_wrapped("bSupportsLongNames")
        self.assert_not_wrapped("bSupportsMultiScriptNames")
        self.assert_not_wrapped("bSupportsNamedForks")
        self.assert_not_wrapped("bSupportsSubtreeIterators")
        self.assert_not_wrapped("bL2PCanMapFileBlocks")
        self.assert_not_wrapped("bParentModDateChanges")
        self.assert_not_wrapped("bAncestorModDateChanges")
        self.assert_not_wrapped("bSupportsSymbolicLinks")
        self.assert_not_wrapped("bIsAutoMounted")
        self.assert_not_wrapped("bAllowCDiDataHandler")
        self.assert_not_wrapped("bSupportsExclusiveLocks")
        self.assert_not_wrapped("bSupportsJournaling")
        self.assert_not_wrapped("bNoVolumeSizes")
        self.assert_not_wrapped("bIsOnInternalBus")
        self.assert_not_wrapped("bIsCaseSensitive")
        self.assert_not_wrapped("bIsCasePreserving")
        self.assert_not_wrapped("bDoNotDisplay")
        self.assert_not_wrapped("bIsRemovable")
        self.assert_not_wrapped("bNoRootTimes")
        self.assert_not_wrapped("bIsOnExternalBus")
        self.assert_not_wrapped("bSupportsExtendedFileSecurity")
        self.assert_not_wrapped("kWidePosOffsetBit")
        self.assert_not_wrapped("kUseWidePositioning")
        self.assert_not_wrapped("kMaximumBlocksIn4GB")
        self.assert_not_wrapped("fsUnixPriv")
        self.assert_not_wrapped("kNoUserAuthentication")
        self.assert_not_wrapped("kPassword")
        self.assert_not_wrapped("kEncryptPassword")
        self.assert_not_wrapped("kTwoWayEncryptPassword")
        self.assert_not_wrapped("knoUser")
        self.assert_not_wrapped("kadministratorUser")
        self.assert_not_wrapped("knoGroup")
        self.assert_not_wrapped("kFSInvalidVolumeRefNum")
        self.assert_not_wrapped("FSRef")
        self.assert_not_wrapped("CatPositionRec")
        self.assert_not_wrapped("FSSpec")
        self.assert_not_wrapped("FSSpec")
        self.assert_not_wrapped("ParamBlockRec")
        self.assert_not_wrapped("IOParam")
        self.assert_not_wrapped("FileParam")
        self.assert_not_wrapped("VolumeParam")
        self.assert_not_wrapped("CntrlParam")
        self.assert_not_wrapped("SlotDevParam")
        self.assert_not_wrapped("MultiDevParam")
        self.assert_not_wrapped("ParamBlockRec")
        self.assert_not_wrapped("HFileInfo")
        self.assert_not_wrapped("DirInfo")
        self.assert_not_wrapped("CInfoPBRec")
        self.assert_not_wrapped("XCInfoPBRec")
        self.assert_not_wrapped("DTPBRec")
        self.assert_not_wrapped("HIOParam")
        self.assert_not_wrapped("HFileParam")
        self.assert_not_wrapped("HVolumeParam")
        self.assert_not_wrapped("XIOParam")
        self.assert_not_wrapped("XVolumeParam")
        self.assert_not_wrapped("AccessParam")
        self.assert_not_wrapped("ObjParam")
        self.assert_not_wrapped("CopyParam")
        self.assert_not_wrapped("WDParam")
        self.assert_not_wrapped("FIDParam")
        self.assert_not_wrapped("ForeignPrivParam")
        self.assert_not_wrapped("CSParam")
        self.assert_not_wrapped("HParamBlockRec")
        self.assert_not_wrapped("CMovePBRec")
        self.assert_not_wrapped("WDPBRec")
        self.assert_not_wrapped("FCBPBRec")
        self.assert_not_wrapped("VCB")
        self.assert_not_wrapped("DrvQEl")
        self.assert_not_wrapped("FSPermissionInfo")
        self.assert_not_wrapped("kFSCatInfoNone")
        self.assert_not_wrapped("kFSCatInfoTextEncoding")
        self.assert_not_wrapped("kFSCatInfoNodeFlags")
        self.assert_not_wrapped("kFSCatInfoVolume")
        self.assert_not_wrapped("kFSCatInfoParentDirID")
        self.assert_not_wrapped("kFSCatInfoNodeID")
        self.assert_not_wrapped("kFSCatInfoCreateDate")
        self.assert_not_wrapped("kFSCatInfoContentMod")
        self.assert_not_wrapped("kFSCatInfoAttrMod")
        self.assert_not_wrapped("kFSCatInfoAccessDate")
        self.assert_not_wrapped("kFSCatInfoBackupDate")
        self.assert_not_wrapped("kFSCatInfoPermissions")
        self.assert_not_wrapped("kFSCatInfoFinderInfo")
        self.assert_not_wrapped("kFSCatInfoFinderXInfo")
        self.assert_not_wrapped("kFSCatInfoValence")
        self.assert_not_wrapped("kFSCatInfoDataSizes")
        self.assert_not_wrapped("kFSCatInfoRsrcSizes")
        self.assert_not_wrapped("kFSCatInfoSharingFlags")
        self.assert_not_wrapped("kFSCatInfoUserPrivs")
        self.assert_not_wrapped("kFSCatInfoUserAccess")
        self.assert_not_wrapped("kFSCatInfoSetOwnership")
        self.assert_not_wrapped("kFSCatInfoFSFileSecurityRef")
        self.assert_not_wrapped("kFSCatInfoAllDates")
        self.assert_not_wrapped("kFSCatInfoGettableInfo")
        self.assert_not_wrapped("kFSCatInfoSettableInfo")
        self.assert_not_wrapped("kFSCatInfoReserved")
        self.assert_not_wrapped("kFSNodeLockedBit")
        self.assert_not_wrapped("kFSNodeLockedMask")
        self.assert_not_wrapped("kFSNodeResOpenBit")
        self.assert_not_wrapped("kFSNodeResOpenMask")
        self.assert_not_wrapped("kFSNodeDataOpenBit")
        self.assert_not_wrapped("kFSNodeDataOpenMask")
        self.assert_not_wrapped("kFSNodeIsDirectoryBit")
        self.assert_not_wrapped("kFSNodeIsDirectoryMask")
        self.assert_not_wrapped("kFSNodeCopyProtectBit")
        self.assert_not_wrapped("kFSNodeCopyProtectMask")
        self.assert_not_wrapped("kFSNodeForkOpenBit")
        self.assert_not_wrapped("kFSNodeForkOpenMask")
        self.assert_not_wrapped("kFSNodeHardLinkBit")
        self.assert_not_wrapped("kFSNodeHardLinkMask")
        self.assert_not_wrapped("kFSNodeInSharedBit")
        self.assert_not_wrapped("kFSNodeInSharedMask")
        self.assert_not_wrapped("kFSNodeIsMountedBit")
        self.assert_not_wrapped("kFSNodeIsMountedMask")
        self.assert_not_wrapped("kFSNodeIsSharePointBit")
        self.assert_not_wrapped("kFSNodeIsSharePointMask")
        self.assert_not_wrapped("FSCatalogInfo")
        self.assert_not_wrapped("FSRefParam")
        self.assert_not_wrapped("FSRefForkIOParam")
        self.assert_not_wrapped("kFSIterateFlat")
        self.assert_not_wrapped("kFSIterateSubtree")
        self.assert_not_wrapped("kFSIterateDelete")
        self.assert_not_wrapped("kFSIterateReserved")
        self.assert_not_wrapped("FSSearchParams")
        self.assert_not_wrapped("FSCatalogBulkParam")
        self.assert_not_wrapped("kFSAllocDefaultFlags")
        self.assert_not_wrapped("kFSAllocAllOrNothingMask")
        self.assert_not_wrapped("kFSAllocContiguousMask")
        self.assert_not_wrapped("kFSAllocNoRoundUpMask")
        self.assert_not_wrapped("kFSAllocReservedMask")
        self.assert_not_wrapped("FSForkIOParam")
        self.assert_not_wrapped("FSForkInfo")
        self.assert_not_wrapped("FSForkCBInfoParam")
        self.assert_not_wrapped("FSRangeLockParam")
        self.assert_not_wrapped("kFSVolInfoNone")
        self.assert_not_wrapped("kFSVolInfoCreateDate")
        self.assert_not_wrapped("kFSVolInfoModDate")
        self.assert_not_wrapped("kFSVolInfoBackupDate")
        self.assert_not_wrapped("kFSVolInfoCheckedDate")
        self.assert_not_wrapped("kFSVolInfoFileCount")
        self.assert_not_wrapped("kFSVolInfoDirCount")
        self.assert_not_wrapped("kFSVolInfoSizes")
        self.assert_not_wrapped("kFSVolInfoBlocks")
        self.assert_not_wrapped("kFSVolInfoNextAlloc")
        self.assert_not_wrapped("kFSVolInfoRsrcClump")
        self.assert_not_wrapped("kFSVolInfoDataClump")
        self.assert_not_wrapped("kFSVolInfoNextID")
        self.assert_not_wrapped("kFSVolInfoFinderInfo")
        self.assert_not_wrapped("kFSVolInfoFlags")
        self.assert_not_wrapped("kFSVolInfoFSInfo")
        self.assert_not_wrapped("kFSVolInfoDriveInfo")
        self.assert_not_wrapped("kFSVolInfoGettableInfo")
        self.assert_not_wrapped("kFSVolInfoSettableInfo")
        self.assert_not_wrapped("kFSVolFlagDefaultVolumeBit")
        self.assert_not_wrapped("kFSVolFlagDefaultVolumeMask")
        self.assert_not_wrapped("kFSVolFlagFilesOpenBit")
        self.assert_not_wrapped("kFSVolFlagFilesOpenMask")
        self.assert_not_wrapped("kFSVolFlagHardwareLockedBit")
        self.assert_not_wrapped("kFSVolFlagHardwareLockedMask")
        self.assert_not_wrapped("kFSVolFlagJournalingActiveBit")
        self.assert_not_wrapped("kFSVolFlagJournalingActiveMask")
        self.assert_not_wrapped("kFSVolFlagSoftwareLockedBit")
        self.assert_not_wrapped("kFSVolFlagSoftwareLockedMask")
        self.assert_not_wrapped("FSVolumeInfo")
        self.assert_not_wrapped("FSVolumeInfoParam")
        self.assert_not_wrapped("GetVolParmsInfoBuffer")
        self.assert_not_wrapped("AppleShareMediaType")
        self.assert_not_wrapped("VolMountInfoHeader")
        self.assert_not_wrapped("VolumeMountInfoHeader")
        self.assert_not_wrapped("volMountNoLoginMsgFlagBit")
        self.assert_not_wrapped("volMountNoLoginMsgFlagMask")
        self.assert_not_wrapped("volMountExtendedFlagsBit")
        self.assert_not_wrapped("volMountExtendedFlagsMask")
        self.assert_not_wrapped("volMountInteractBit")
        self.assert_not_wrapped("volMountInteractMask")
        self.assert_not_wrapped("volMountChangedBit")
        self.assert_not_wrapped("volMountChangedMask")
        self.assert_not_wrapped("volMountFSReservedMask")
        self.assert_not_wrapped("volMountSysReservedMask")
        self.assert_not_wrapped("AFPVolMountInfo")
        self.assert_not_wrapped("AFPXVolMountInfo")
        self.assert_not_wrapped("kAFPExtendedFlagsAlternateAddressMask")
        self.assert_not_wrapped("kAFPTagTypeIP")
        self.assert_not_wrapped("kAFPTagTypeIPPort")
        self.assert_not_wrapped("kAFPTagTypeDDP")
        self.assert_not_wrapped("kAFPTagTypeDNS")
        self.assert_not_wrapped("kAFPTagLengthIP")
        self.assert_not_wrapped("kAFPTagLengthIPPort")
        self.assert_not_wrapped("kAFPTagLengthDDP")
        self.assert_not_wrapped("AFPTagData")
        self.assert_not_wrapped("AFPAlternateAddress")
        self.assert_not_wrapped("kLargeIconSize")
        self.assert_not_wrapped("kLarge4BitIconSize")
        self.assert_not_wrapped("kLarge8BitIconSize")
        self.assert_not_wrapped("kSmallIconSize")
        self.assert_not_wrapped("kSmall4BitIconSize")
        self.assert_not_wrapped("kSmall8BitIconSize")
        self.assert_not_wrapped("NewIOCompletionUPP")
        self.assert_not_wrapped("DisposeIOCompletionUPP")
        self.assert_not_wrapped("InvokeIOCompletionUPP")
        self.assert_not_wrapped("FSMakeFSRefUnicode")
        self.assert_not_wrapped("PBMakeFSRefUnicodeSync")
        self.assert_not_wrapped("PBMakeFSRefUnicodeAsync")
        self.assert_not_wrapped("FSCompareFSRefs")
        self.assert_not_wrapped("PBCompareFSRefsSync")
        self.assert_not_wrapped("PBCompareFSRefsAsync")
        self.assert_not_wrapped("FSCreateFileUnicode")
        self.assert_not_wrapped("PBCreateFileUnicodeSync")
        self.assert_not_wrapped("PBCreateFileUnicodeAsync")
        self.assert_not_wrapped("FSCreateDirectoryUnicode")
        self.assert_not_wrapped("PBCreateDirectoryUnicodeSync")
        self.assert_not_wrapped("PBCreateDirectoryUnicodeAsync")
        self.assert_not_wrapped("FSDeleteObject")
        self.assert_not_wrapped("PBDeleteObjectSync")
        self.assert_not_wrapped("PBDeleteObjectAsync")
        self.assert_not_wrapped("FSUnlinkObject")
        self.assert_not_wrapped("PBUnlinkObjectSync")
        self.assert_not_wrapped("PBUnlinkObjectAsync")
        self.assert_not_wrapped("FSMoveObject")
        self.assert_not_wrapped("PBMoveObjectSync")
        self.assert_not_wrapped("PBMoveObjectAsync")
        self.assert_not_wrapped("FSExchangeObjects")
        self.assert_not_wrapped("PBExchangeObjectsSync")
        self.assert_not_wrapped("PBExchangeObjectsAsync")
        self.assert_not_wrapped("kFSReplaceObjectDefaultOptions")
        self.assert_not_wrapped("kFSReplaceObjectReplaceMetadata")
        self.assert_not_wrapped("kFSReplaceObjectSaveOriginalAsABackup")
        self.assert_not_wrapped("kFSReplaceObjectReplacePermissionInfo")
        self.assert_not_wrapped("kFSReplaceObjectPreservePermissionInfo")
        self.assert_not_wrapped("kFSReplaceObjectDoNotCheckObjectWriteAccess")
        self.assert_not_wrapped("FSReplaceObject")
        self.assert_not_wrapped("FSPathReplaceObject")
        self.assert_not_wrapped("FSGetTemporaryDirectoryForReplaceObject")
        self.assert_not_wrapped("FSPathGetTemporaryDirectoryForReplaceObject")
        self.assert_not_wrapped("FSRenameUnicode")
        self.assert_not_wrapped("PBRenameUnicodeSync")
        self.assert_not_wrapped("PBRenameUnicodeAsync")
        self.assert_not_wrapped("FSGetCatalogInfo")
        self.assert_not_wrapped("PBGetCatalogInfoSync")
        self.assert_not_wrapped("PBGetCatalogInfoAsync")
        self.assert_not_wrapped("FSSetCatalogInfo")
        self.assert_not_wrapped("PBSetCatalogInfoSync")
        self.assert_not_wrapped("PBSetCatalogInfoAsync")
        self.assert_not_wrapped("FSOpenIterator")
        self.assert_not_wrapped("PBOpenIteratorSync")
        self.assert_not_wrapped("PBOpenIteratorAsync")
        self.assert_not_wrapped("FSCloseIterator")
        self.assert_not_wrapped("PBCloseIteratorSync")
        self.assert_not_wrapped("PBCloseIteratorAsync")
        self.assert_not_wrapped("FSGetCatalogInfoBulk")
        self.assert_not_wrapped("PBGetCatalogInfoBulkSync")
        self.assert_not_wrapped("PBGetCatalogInfoBulkAsync")
        self.assert_not_wrapped("FSCatalogSearch")
        self.assert_not_wrapped("PBCatalogSearchSync")
        self.assert_not_wrapped("PBCatalogSearchAsync")
        self.assert_not_wrapped("FSCreateFileAndOpenForkUnicode")
        self.assert_not_wrapped("PBCreateFileAndOpenForkUnicodeSync")
        self.assert_not_wrapped("PBCreateFileAndOpenForkUnicodeAsync")
        self.assert_not_wrapped("FSCreateFork")
        self.assert_not_wrapped("PBCreateForkSync")
        self.assert_not_wrapped("PBCreateForkAsync")
        self.assert_not_wrapped("FSDeleteFork")
        self.assert_not_wrapped("PBDeleteForkSync")
        self.assert_not_wrapped("PBDeleteForkAsync")
        self.assert_not_wrapped("FSIterateForks")
        self.assert_not_wrapped("PBIterateForksSync")
        self.assert_not_wrapped("PBIterateForksAsync")
        self.assert_not_wrapped("FSOpenFork")
        self.assert_not_wrapped("PBOpenForkSync")
        self.assert_not_wrapped("PBOpenForkAsync")
        self.assert_not_wrapped("FSReadFork")
        self.assert_not_wrapped("PBReadForkSync")
        self.assert_not_wrapped("PBReadForkAsync")
        self.assert_not_wrapped("FSWriteFork")
        self.assert_not_wrapped("PBWriteForkSync")
        self.assert_not_wrapped("PBWriteForkAsync")
        self.assert_not_wrapped("FSGetForkPosition")
        self.assert_not_wrapped("PBGetForkPositionSync")
        self.assert_not_wrapped("PBGetForkPositionAsync")
        self.assert_not_wrapped("FSSetForkPosition")
        self.assert_not_wrapped("PBSetForkPositionSync")
        self.assert_not_wrapped("PBSetForkPositionAsync")
        self.assert_not_wrapped("FSGetForkSize")
        self.assert_not_wrapped("PBGetForkSizeSync")
        self.assert_not_wrapped("PBGetForkSizeAsync")
        self.assert_not_wrapped("FSSetForkSize")
        self.assert_not_wrapped("PBSetForkSizeSync")
        self.assert_not_wrapped("PBSetForkSizeAsync")
        self.assert_not_wrapped("FSAllocateFork")
        self.assert_not_wrapped("PBAllocateForkSync")
        self.assert_not_wrapped("PBAllocateForkAsync")
        self.assert_not_wrapped("FSFlushFork")
        self.assert_not_wrapped("PBFlushForkSync")
        self.assert_not_wrapped("PBFlushForkAsync")
        self.assert_not_wrapped("FSCloseFork")
        self.assert_not_wrapped("PBCloseForkSync")
        self.assert_not_wrapped("PBCloseForkAsync")
        self.assert_not_wrapped("FSGetForkCBInfo")
        self.assert_not_wrapped("PBGetForkCBInfoSync")
        self.assert_not_wrapped("PBGetForkCBInfoAsync")
        self.assert_not_wrapped("FSLockRange")
        self.assert_not_wrapped("PBXLockRangeSync")
        self.assert_not_wrapped("PBXLockRangeAsync")
        self.assert_not_wrapped("FSUnlockRange")
        self.assert_not_wrapped("PBXUnlockRangeSync")
        self.assert_not_wrapped("PBXUnlockRangeAsync")
        self.assert_not_wrapped("FSGetVolumeInfo")
        self.assert_not_wrapped("PBGetVolumeInfoSync")
        self.assert_not_wrapped("PBGetVolumeInfoAsync")
        self.assert_not_wrapped("FSSetVolumeInfo")
        self.assert_not_wrapped("PBSetVolumeInfoSync")
        self.assert_not_wrapped("PBSetVolumeInfoAsync")
        self.assert_not_wrapped("FSGetDataForkName")
        self.assert_not_wrapped("FSGetResourceForkName")
        self.assert_not_wrapped("FSRefMakePath")
        self.assert_not_wrapped("FSPathMakeRef")
        self.assert_not_wrapped("kFSPathMakeRefDefaultOptions")
        self.assert_not_wrapped("kFSPathMakeRefDoNotFollowLeafSymlink")
        self.assert_not_wrapped("FSPathMakeRefWithOptions")
        self.assert_not_wrapped("FSIsFSRefValid")
        self.assert_not_wrapped("kFNDirectoryModifiedMessage")
        self.assert_not_wrapped("FNNotify")
        self.assert_not_wrapped("FNNotifyByPath")
        self.assert_not_wrapped("FNNotifyAll")
        self.assert_not_wrapped(
            "typedef struct OpaqueFNSubscriptionRef*  FNSubscriptionRef;"
        )
        self.assert_not_wrapped("kFNNoImplicitAllSubscription")
        self.assert_not_wrapped("kFNNotifyInBackground")
        self.assert_not_wrapped("NewFNSubscriptionUPP")
        self.assert_not_wrapped("DisposeFNSubscriptionUPP")
        self.assert_not_wrapped("InvokeFNSubscriptionUPP")
        self.assert_not_wrapped("FNSubscribe")
        self.assert_not_wrapped("FNSubscribeByPath")
        self.assert_not_wrapped("FNUnsubscribe")
        self.assert_not_wrapped("FNGetDirectoryForSubscription")
        self.assert_not_wrapped("kAsyncMountInProgress")
        self.assert_not_wrapped("kAsyncMountComplete")
        self.assert_not_wrapped("kAsyncUnmountInProgress")
        self.assert_not_wrapped("kAsyncUnmountComplete")
        self.assert_not_wrapped("kAsyncEjectInProgress")
        self.assert_not_wrapped("kAsyncEjectComplete")
        self.assert_not_wrapped("NewFSVolumeMountUPP")
        self.assert_not_wrapped("NewFSVolumeUnmountUPP")
        self.assert_not_wrapped("NewFSVolumeEjectUPP")
        self.assert_not_wrapped("DisposeFSVolumeMountUPP")
        self.assert_not_wrapped("DisposeFSVolumeUnmountUPP")
        self.assert_not_wrapped("DisposeFSVolumeEjectUPP")
        self.assert_not_wrapped("InvokeFSVolumeMountUPP")
        self.assert_not_wrapped("InvokeFSVolumeUnmountUPP")
        self.assert_not_wrapped("InvokeFSVolumeEjectUPP")
        self.assert_not_wrapped("kFSMountServerMarkDoNotDisplay")
        self.assert_not_wrapped("kFSMountServerMountOnMountDir")
        self.assert_not_wrapped("kFSMountServerSuppressConnectionUI")
        self.assert_not_wrapped("kFSMountServerMountWithoutNotification")
        self.assert_not_wrapped("kFSEjectVolumeForceEject")
        self.assert_not_wrapped("kFSUnmountVolumeForceUnmount")
        self.assert_not_wrapped("FSCreateVolumeOperation")
        self.assert_not_wrapped("FSDisposeVolumeOperation")
        self.assert_not_wrapped("FSMountLocalVolumeSync")
        self.assert_not_wrapped("FSMountLocalVolumeAsync")
        self.assert_not_wrapped("FSMountServerVolumeSync")
        self.assert_not_wrapped("FSMountServerVolumeAsync")
        self.assert_not_wrapped("FSGetAsyncMountStatus")
        self.assert_not_wrapped("FSUnmountVolumeSync")
        self.assert_not_wrapped("FSUnmountVolumeAsync")
        self.assert_not_wrapped("FSGetAsyncUnmountStatus")
        self.assert_not_wrapped("FSCancelVolumeOperation")
        self.assert_not_wrapped("FSEjectVolumeSync")
        self.assert_not_wrapped("FSEjectVolumeAsync")
        self.assert_not_wrapped("FSGetAsyncEjectStatus")
        self.assert_not_wrapped("FSCopyDiskIDForVolume")
        self.assert_not_wrapped("FSCopyURLForVolume")
        self.assert_not_wrapped("FSGetVolumeForDiskID")
        self.assert_not_wrapped("FSCopyDADiskForVolume")
        self.assert_not_wrapped("FSGetVolumeForDADisk")
        self.assert_not_wrapped("FSFileOperationClientContext;")
        self.assert_not_wrapped("kFSFileOperationDefaultOptions")
        self.assert_not_wrapped("kFSFileOperationOverwrite")
        self.assert_not_wrapped("kFSFileOperationSkipSourcePermissionErrors")
        self.assert_not_wrapped("kFSFileOperationDoNotMoveAcrossVolumes")
        self.assert_not_wrapped("kFSFileOperationSkipPreflight")
        self.assert_not_wrapped("kFSOperationStageUndefined")
        self.assert_not_wrapped("kFSOperationStagePreflighting")
        self.assert_not_wrapped("kFSOperationStageRunning")
        self.assert_not_wrapped("kFSOperationStageComplete")
        self.assert_not_wrapped("kFSOperationTotalBytesKey")
        self.assert_not_wrapped("kFSOperationBytesCompleteKey")
        self.assert_not_wrapped("kFSOperationBytesRemainingKey")
        self.assert_not_wrapped("kFSOperationTotalObjectsKey")
        self.assert_not_wrapped("kFSOperationObjectsCompleteKey")
        self.assert_not_wrapped("kFSOperationObjectsRemainingKey")
        self.assert_not_wrapped("kFSOperationTotalUserVisibleObjectsKey")
        self.assert_not_wrapped("kFSOperationUserVisibleObjectsCompleteKey")
        self.assert_not_wrapped("kFSOperationUserVisibleObjectsRemainingKey")
        self.assert_not_wrapped("kFSOperationThroughputKey")
        self.assert_not_wrapped("FSCopyObjectSync")
        self.assert_not_wrapped("FSMoveObjectSync")
        self.assert_not_wrapped("FSMoveObjectToTrashSync")
        self.assert_not_wrapped("FSPathCopyObjectSync")
        self.assert_not_wrapped("FSPathMoveObjectSync")
        self.assert_not_wrapped("FSPathMoveObjectToTrashSync")
        self.assert_not_wrapped("FSFileOperationGetTypeID")
        self.assert_not_wrapped("FSFileOperationCreate")
        self.assert_not_wrapped("FSFileOperationScheduleWithRunLoop")
        self.assert_not_wrapped("FSFileOperationUnscheduleFromRunLoop")
        self.assert_not_wrapped("FSCopyObjectAsync")
        self.assert_not_wrapped("FSMoveObjectAsync")
        self.assert_not_wrapped("FSMoveObjectToTrashAsync")
        self.assert_not_wrapped("FSPathCopyObjectAsync")
        self.assert_not_wrapped("FSPathMoveObjectAsync")
        self.assert_not_wrapped("FSPathMoveObjectToTrashAsync")
        self.assert_not_wrapped("FSFileOperationCancel")
        self.assert_not_wrapped("FSFileOperationCopyStatus")
        self.assert_not_wrapped("FSPathFileOperationCopyStatus")
        self.assert_not_wrapped("FSCreateStringFromHFSUniStr")
        self.assert_not_wrapped("FSGetHFSUniStrFromString")
        self.assert_not_wrapped("FSFileSecurityGetTypeID")
        self.assert_not_wrapped("FSFileSecurityCreate")
        self.assert_not_wrapped("FSFileSecurityCreateWithFSPermissionInfo")
        self.assert_not_wrapped("FSFileSecurityRefCreateCopy")
        self.assert_not_wrapped("FSFileSecurityGetOwnerUUID")
        self.assert_not_wrapped("FSFileSecuritySetOwnerUUID")
        self.assert_not_wrapped("FSFileSecurityGetGroupUUID")
        self.assert_not_wrapped("FSFileSecuritySetGroupUUID")
        self.assert_not_wrapped("FSFileSecurityCopyAccessControlList")
        self.assert_not_wrapped("FSFileSecuritySetAccessControlList")
        self.assert_not_wrapped("FSFileSecurityGetOwner")
        self.assert_not_wrapped("FSFileSecuritySetOwner")
        self.assert_not_wrapped("FSFileSecurityGetGroup")
        self.assert_not_wrapped("FSFileSecuritySetGroup")
        self.assert_not_wrapped("FSFileSecurityGetMode")
        self.assert_not_wrapped("FSFileSecuritySetMode")
        self.assert_not_wrapped("pleaseCacheBit")
        self.assert_not_wrapped("pleaseCacheMask")
        self.assert_not_wrapped("noCacheBit")
        self.assert_not_wrapped("noCacheMask")
        self.assert_not_wrapped("rdVerifyBit")
        self.assert_not_wrapped("rdVerifyMask")
        self.assert_not_wrapped("rdVerify")
        self.assert_not_wrapped("forceReadBit")
        self.assert_not_wrapped("forceReadMask")
        self.assert_not_wrapped("newLineBit")
        self.assert_not_wrapped("newLineMask")
        self.assert_not_wrapped("newLineCharMask")
        self.assert_not_wrapped("kOwnerID2Name")
        self.assert_not_wrapped("kGroupID2Name")
        self.assert_not_wrapped("kOwnerName2ID")
        self.assert_not_wrapped("kGroupName2ID")
        self.assert_not_wrapped("kReturnNextUser")
        self.assert_not_wrapped("kReturnNextGroup")
        self.assert_not_wrapped("kReturnNextUG")
        self.assert_not_wrapped("kVCBFlagsIdleFlushBit")
        self.assert_not_wrapped("kVCBFlagsIdleFlushMask")
        self.assert_not_wrapped("kVCBFlagsHFSPlusAPIsBit")
        self.assert_not_wrapped("kVCBFlagsHFSPlusAPIsMask")
        self.assert_not_wrapped("kVCBFlagsHardwareGoneBit")
        self.assert_not_wrapped("kVCBFlagsHardwareGoneMask")
        self.assert_not_wrapped("kVCBFlagsVolumeDirtyBit")
        self.assert_not_wrapped("kVCBFlagsVolumeDirtyMask")
        self.assert_not_wrapped("kioVAtrbDefaultVolumeBit")
        self.assert_not_wrapped("kioVAtrbDefaultVolumeMask")
        self.assert_not_wrapped("kioVAtrbFilesOpenBit")
        self.assert_not_wrapped("kioVAtrbFilesOpenMask")
        self.assert_not_wrapped("kioVAtrbHardwareLockedBit")
        self.assert_not_wrapped("kioVAtrbHardwareLockedMask")
        self.assert_not_wrapped("kioVAtrbSoftwareLockedBit")
        self.assert_not_wrapped("kioVAtrbSoftwareLockedMask")
        self.assert_not_wrapped("kioFlAttribLockedBit")
        self.assert_not_wrapped("kioFlAttribLockedMask")
        self.assert_not_wrapped("kioFlAttribResOpenBit")
        self.assert_not_wrapped("kioFlAttribResOpenMask")
        self.assert_not_wrapped("kioFlAttribDataOpenBit")
        self.assert_not_wrapped("kioFlAttribDataOpenMask")
        self.assert_not_wrapped("kioFlAttribDirBit")
        self.assert_not_wrapped("kioFlAttribDirMask")
        self.assert_not_wrapped("ioDirFlg")
        self.assert_not_wrapped("ioDirMask")
        self.assert_not_wrapped("kioFlAttribCopyProtBit")
        self.assert_not_wrapped("kioFlAttribCopyProtMask")
        self.assert_not_wrapped("kioFlAttribFileOpenBit")
        self.assert_not_wrapped("kioFlAttribFileOpenMask")
        self.assert_not_wrapped("kioFlAttribInSharedBit")
        self.assert_not_wrapped("kioFlAttribInSharedMask")
        self.assert_not_wrapped("kioFlAttribMountedBit")
        self.assert_not_wrapped("kioFlAttribMountedMask")
        self.assert_not_wrapped("kioFlAttribSharePointBit")
        self.assert_not_wrapped("kioFlAttribSharePointMask")
        self.assert_not_wrapped("kioFCBWriteBit")
        self.assert_not_wrapped("kioFCBWriteMask")
        self.assert_not_wrapped("kioFCBResourceBit")
        self.assert_not_wrapped("kioFCBResourceMask")
        self.assert_not_wrapped("kioFCBWriteLockedBit")
        self.assert_not_wrapped("kioFCBWriteLockedMask")
        self.assert_not_wrapped("kioFCBLargeFileBit")
        self.assert_not_wrapped("kioFCBLargeFileMask")
        self.assert_not_wrapped("kioFCBSharedWriteBit")
        self.assert_not_wrapped("kioFCBSharedWriteMask")
        self.assert_not_wrapped("kioFCBFileLockedBit")
        self.assert_not_wrapped("kioFCBFileLockedMask")
        self.assert_not_wrapped("kioFCBOwnClumpBit")
        self.assert_not_wrapped("kioFCBOwnClumpMask")
        self.assert_not_wrapped("kioFCBModifiedBit")
        self.assert_not_wrapped("kioFCBModifiedMask")
        self.assert_not_wrapped("kForkInfoFlagsWriteBit")
        self.assert_not_wrapped("kForkInfoFlagsWriteMask")
        self.assert_not_wrapped("kForkInfoFlagsResourceBit")
        self.assert_not_wrapped("kForkInfoFlagsResourceMask")
        self.assert_not_wrapped("kForkInfoFlagsWriteLockedBit")
        self.assert_not_wrapped("kForkInfoFlagsWriteLockedMask")
        self.assert_not_wrapped("kForkInfoFlagsLargeFileBit")
        self.assert_not_wrapped("kForkInfoFlagsLargeFileMask")
        self.assert_not_wrapped("kForkInfoFlagsSharedWriteBit")
        self.assert_not_wrapped("kForkInfoFlagsSharedWriteMask")
        self.assert_not_wrapped("kForkInfoFlagsFileLockedBit")
        self.assert_not_wrapped("kForkInfoFlagsFileLockedMask")
        self.assert_not_wrapped("kForkInfoFlagsOwnClumpBit")
        self.assert_not_wrapped("kForkInfoFlagsOwnClumpMask")
        self.assert_not_wrapped("kForkInfoFlagsModifiedBit")
        self.assert_not_wrapped("kForkInfoFlagsModifiedMask")
        self.assert_not_wrapped("kioACUserNoSeeFolderBit")
        self.assert_not_wrapped("kioACUserNoSeeFolderMask")
        self.assert_not_wrapped("kioACUserNoSeeFilesBit")
        self.assert_not_wrapped("kioACUserNoSeeFilesMask")
        self.assert_not_wrapped("kioACUserNoMakeChangesBit")
        self.assert_not_wrapped("kioACUserNoMakeChangesMask")
        self.assert_not_wrapped("kioACUserNotOwnerBit")
        self.assert_not_wrapped("kioACUserNotOwnerMask")
        self.assert_not_wrapped("kioACAccessOwnerBit")
        self.assert_not_wrapped("kioACAccessOwnerMask")
        self.assert_not_wrapped("kioACAccessBlankAccessBit")
        self.assert_not_wrapped("kioACAccessBlankAccessMask")
        self.assert_not_wrapped("kioACAccessUserWriteBit")
        self.assert_not_wrapped("kioACAccessUserWriteMask")
        self.assert_not_wrapped("kioACAccessUserReadBit")
        self.assert_not_wrapped("kioACAccessUserReadMask")
        self.assert_not_wrapped("kioACAccessUserSearchBit")
        self.assert_not_wrapped("kioACAccessUserSearchMask")
        self.assert_not_wrapped("kioACAccessEveryoneWriteBit")
        self.assert_not_wrapped("kioACAccessEveryoneWriteMask")
        self.assert_not_wrapped("kioACAccessEveryoneReadBit")
        self.assert_not_wrapped("kioACAccessEveryoneReadMask")
        self.assert_not_wrapped("kioACAccessEveryoneSearchBit")
        self.assert_not_wrapped("kioACAccessEveryoneSearchMask")
        self.assert_not_wrapped("kioACAccessGroupWriteBit")
        self.assert_not_wrapped("kioACAccessGroupWriteMask")
        self.assert_not_wrapped("kioACAccessGroupReadBit")
        self.assert_not_wrapped("kioACAccessGroupReadMask")
        self.assert_not_wrapped("kioACAccessGroupSearchBit")
        self.assert_not_wrapped("kioACAccessGroupSearchMask")
        self.assert_not_wrapped("kioACAccessOwnerWriteBit")
        self.assert_not_wrapped("kioACAccessOwnerWriteMask")
        self.assert_not_wrapped("kioACAccessOwnerReadBit")
        self.assert_not_wrapped("kioACAccessOwnerReadMask")
        self.assert_not_wrapped("kioACAccessOwnerSearchBit")
        self.assert_not_wrapped("kioACAccessOwnerSearchMask")
        self.assert_not_wrapped("kfullPrivileges")
        self.assert_not_wrapped("kownerPrivileges")
        self.assert_not_wrapped("FSGetVolumeParms")
        self.assert_not_wrapped("FSGetVolumeMountInfoSize")
        self.assert_not_wrapped("FSGetVolumeMountInfo")
        self.assert_not_wrapped("FSVolumeMount")
        self.assert_not_wrapped("FSFlushVolume")
        self.assert_not_wrapped("PBFlushVolumeSync")
        self.assert_not_wrapped("PBFlushVolumeAsync")
        self.assert_not_wrapped("PBFSCopyFileSync")
        self.assert_not_wrapped("PBFSCopyFileAsync")
        self.assert_not_wrapped("FSResolveNodeID")
        self.assert_not_wrapped("PBFSResolveNodeIDSync")
        self.assert_not_wrapped("PBFSResolveNodeIDAsync")
        self.assert_not_wrapped("FSpMakeFSRef")
        self.assert_not_wrapped("PBMakeFSRefSync")
        self.assert_not_wrapped("PBMakeFSRefAsync")
        self.assert_not_wrapped("PBCloseSync")
        self.assert_not_wrapped("PBCloseAsync")
        self.assert_not_wrapped("PBReadSync")
        self.assert_not_wrapped("PBReadAsync")
        self.assert_not_wrapped("PBWriteSync")
        self.assert_not_wrapped("PBWriteAsync")
        self.assert_not_wrapped("PBWaitIOComplete")
        self.assert_not_wrapped("PBHGetVolParmsSync")
        self.assert_not_wrapped("PBHGetVolParmsAsync")
        self.assert_not_wrapped("PBGetVolMountInfoSize")
        self.assert_not_wrapped("PBGetVolMountInfo")
        self.assert_not_wrapped("PBVolumeMount")
        self.assert_not_wrapped("FlushVol")
        self.assert_not_wrapped("PBFlushVolSync")
        self.assert_not_wrapped("PBFlushVolAsync")
        self.assert_not_wrapped("PBHOpenDenySync")
        self.assert_not_wrapped("PBHOpenDenyAsync")
        self.assert_not_wrapped("PBHOpenRFDenySync")
        self.assert_not_wrapped("PBHOpenRFDenyAsync")
        self.assert_not_wrapped("PBHGetDirAccessSync")
        self.assert_not_wrapped("PBHGetDirAccessAsync")
        self.assert_not_wrapped("PBHSetDirAccessSync")
        self.assert_not_wrapped("PBHSetDirAccessAsync")
        self.assert_not_wrapped("PBHMapIDSync")
        self.assert_not_wrapped("PBHMapIDAsync")
        self.assert_not_wrapped("PBHMapNameSync")
        self.assert_not_wrapped("PBHMapNameAsync")
        self.assert_not_wrapped("PBHCopyFileSync")
        self.assert_not_wrapped("PBHCopyFileAsync")
        self.assert_not_wrapped("PBCreateFileIDRefSync")
        self.assert_not_wrapped("PBCreateFileIDRefAsync")
        self.assert_not_wrapped("PBResolveFileIDRefSync")
        self.assert_not_wrapped("PBResolveFileIDRefAsync")
        self.assert_not_wrapped("PBDeleteFileIDRefSync")
        self.assert_not_wrapped("PBDeleteFileIDRefAsync")
        self.assert_not_wrapped("PBXGetVolInfoSync")
        self.assert_not_wrapped("PBXGetVolInfoAsync")
        self.assert_not_wrapped("PBAllocateSync")
        self.assert_not_wrapped("PBAllocateAsync")
        self.assert_not_wrapped("PBGetEOFSync")
        self.assert_not_wrapped("PBGetEOFAsync")
        self.assert_not_wrapped("PBSetEOFSync")
        self.assert_not_wrapped("PBSetEOFAsync")
        self.assert_not_wrapped("PBGetFPosSync")
        self.assert_not_wrapped("PBGetFPosAsync")
        self.assert_not_wrapped("PBSetFPosSync")
        self.assert_not_wrapped("PBSetFPosAsync")
        self.assert_not_wrapped("PBFlushFileSync")
        self.assert_not_wrapped("PBFlushFileAsync")
        self.assert_not_wrapped("PBUnmountVol")
        self.assert_not_wrapped("PBCatSearchSync")
        self.assert_not_wrapped("PBCatSearchAsync")
        self.assert_not_wrapped("UnmountVol")
        self.assert_not_wrapped("HSetVol")
        self.assert_not_wrapped("FSClose")
        self.assert_not_wrapped("FSRead")
        self.assert_not_wrapped("FSWrite")
        self.assert_not_wrapped("Allocate")
        self.assert_not_wrapped("GetEOF")
        self.assert_not_wrapped("SetEOF")
        self.assert_not_wrapped("GetFPos")
        self.assert_not_wrapped("SetFPos")
        self.assert_not_wrapped("GetVRefNum")
        self.assert_not_wrapped("PBLockRangeSync")
        self.assert_not_wrapped("PBLockRangeAsync")
        self.assert_not_wrapped("PBUnlockRangeSync")
        self.assert_not_wrapped("PBUnlockRangeAsync")
        self.assert_not_wrapped("PBHSetVolSync")
        self.assert_not_wrapped("PBHSetVolAsync")
        self.assert_not_wrapped("PBHGetVolSync")
        self.assert_not_wrapped("PBHGetVolAsync")
        self.assert_not_wrapped("PBCatMoveSync")
        self.assert_not_wrapped("PBCatMoveAsync")
        self.assert_not_wrapped("PBDirCreateSync")
        self.assert_not_wrapped("PBDirCreateAsync")
        self.assert_not_wrapped("PBGetFCBInfoSync")
        self.assert_not_wrapped("PBGetFCBInfoAsync")
        self.assert_not_wrapped("PBGetCatInfoSync")
        self.assert_not_wrapped("PBGetCatInfoAsync")
        self.assert_not_wrapped("PBSetCatInfoSync")
        self.assert_not_wrapped("PBSetCatInfoAsync")
        self.assert_not_wrapped("PBAllocContigSync")
        self.assert_not_wrapped("PBAllocContigAsync")
        self.assert_not_wrapped("PBSetVInfoSync")
        self.assert_not_wrapped("PBSetVInfoAsync")
        self.assert_not_wrapped("PBHGetVInfoSync")
        self.assert_not_wrapped("PBHGetVInfoAsync")
        self.assert_not_wrapped("PBHOpenSync")
        self.assert_not_wrapped("PBHOpenAsync")
        self.assert_not_wrapped("PBHOpenRFSync")
        self.assert_not_wrapped("PBHOpenRFAsync")
        self.assert_not_wrapped("PBHOpenDFSync")
        self.assert_not_wrapped("PBHOpenDFAsync")
        self.assert_not_wrapped("PBHCreateSync")
        self.assert_not_wrapped("PBHCreateAsync")
        self.assert_not_wrapped("PBHDeleteSync")
        self.assert_not_wrapped("PBHDeleteAsync")
        self.assert_not_wrapped("PBHRenameSync")
        self.assert_not_wrapped("PBHRenameAsync")
        self.assert_not_wrapped("PBHRstFLockSync")
        self.assert_not_wrapped("PBHRstFLockAsync")
        self.assert_not_wrapped("PBHSetFLockSync")
        self.assert_not_wrapped("PBHSetFLockAsync")
        self.assert_not_wrapped("PBHGetFInfoSync")
        self.assert_not_wrapped("PBHGetFInfoAsync")
        self.assert_not_wrapped("PBHSetFInfoSync")
        self.assert_not_wrapped("PBHSetFInfoAsync")
        self.assert_not_wrapped("PBMakeFSSpecSync")
        self.assert_not_wrapped("PBMakeFSSpecAsync")
        self.assert_not_wrapped("HGetVol")
        self.assert_not_wrapped("HOpen")
        self.assert_not_wrapped("HOpenDF")
        self.assert_not_wrapped("HOpenRF")
        self.assert_not_wrapped("AllocContig")
        self.assert_not_wrapped("HCreate")
        self.assert_not_wrapped("DirCreate")
        self.assert_not_wrapped("HDelete")
        self.assert_not_wrapped("HGetFInfo")
        self.assert_not_wrapped("HSetFInfo")
        self.assert_not_wrapped("HSetFLock")
        self.assert_not_wrapped("HRstFLock")
        self.assert_not_wrapped("HRename")
        self.assert_not_wrapped("CatMove")
        self.assert_not_wrapped("PBHGetLogInInfoSync")
        self.assert_not_wrapped("PBHGetLogInInfoAsync")
        self.assert_not_wrapped("PBHMoveRenameSync")
        self.assert_not_wrapped("PBHMoveRenameAsync")
        self.assert_not_wrapped("PBGetXCatInfoSync")
        self.assert_not_wrapped("PBGetXCatInfoAsync")
        self.assert_not_wrapped("PBExchangeFilesSync")
        self.assert_not_wrapped("PBExchangeFilesAsync")
        self.assert_not_wrapped("PBGetForeignPrivsSync")
        self.assert_not_wrapped("PBGetForeignPrivsAsync")
        self.assert_not_wrapped("PBSetForeignPrivsSync")
        self.assert_not_wrapped("PBSetForeignPrivsAsync")
        self.assert_not_wrapped("kLargeIcon")
        self.assert_not_wrapped("kLarge4BitIcon")
        self.assert_not_wrapped("kLarge8BitIcon")
        self.assert_not_wrapped("kSmallIcon")
        self.assert_not_wrapped("kSmall4BitIcon")
        self.assert_not_wrapped("kSmall8BitIcon")
        self.assert_not_wrapped("kicnsIconFamily")
        self.assert_not_wrapped("PBDTGetPath")
        self.assert_not_wrapped("PBDTCloseDown")
        self.assert_not_wrapped("PBDTAddIconSync")
        self.assert_not_wrapped("PBDTAddIconAsync")
        self.assert_not_wrapped("PBDTGetIconSync")
        self.assert_not_wrapped("PBDTGetIconAsync")
        self.assert_not_wrapped("PBDTGetIconInfoSync")
        self.assert_not_wrapped("PBDTGetIconInfoAsync")
        self.assert_not_wrapped("PBDTAddAPPLSync")
        self.assert_not_wrapped("PBDTAddAPPLAsync")
        self.assert_not_wrapped("PBDTRemoveAPPLSync")
        self.assert_not_wrapped("PBDTRemoveAPPLAsync")
        self.assert_not_wrapped("PBDTGetAPPLSync")
        self.assert_not_wrapped("PBDTGetAPPLAsync")
        self.assert_not_wrapped("PBDTSetCommentSync")
        self.assert_not_wrapped("PBDTSetCommentAsync")
        self.assert_not_wrapped("PBDTRemoveCommentSync")
        self.assert_not_wrapped("PBDTRemoveCommentAsync")
        self.assert_not_wrapped("PBDTGetCommentSync")
        self.assert_not_wrapped("PBDTGetCommentAsync")
        self.assert_not_wrapped("PBDTFlushSync")
        self.assert_not_wrapped("PBDTFlushAsync")
        self.assert_not_wrapped("PBDTResetSync")
        self.assert_not_wrapped("PBDTResetAsync")
        self.assert_not_wrapped("PBDTGetInfoSync")
        self.assert_not_wrapped("PBDTGetInfoAsync")
        self.assert_not_wrapped("PBDTOpenInform")
        self.assert_not_wrapped("PBDTDeleteSync")
        self.assert_not_wrapped("PBDTDeleteAsync")
        self.assert_not_wrapped("FSMakeFSSpec")
        self.assert_not_wrapped("FSpOpenDF")
        self.assert_not_wrapped("FSpOpenRF")
        self.assert_not_wrapped("FSpCreate")
        self.assert_not_wrapped("FSpDirCreate")
        self.assert_not_wrapped("FSpDelete")
        self.assert_not_wrapped("FSpGetFInfo")
        self.assert_not_wrapped("FSpSetFInfo")
        self.assert_not_wrapped("FSpSetFLock")
        self.assert_not_wrapped("FSpRstFLock")
        self.assert_not_wrapped("FSpRename")
        self.assert_not_wrapped("FSpCatMove")
        self.assert_not_wrapped("FSpExchangeFiles")
        self.assert_not_wrapped("PBShareSync")
        self.assert_not_wrapped("PBShareAsync")
        self.assert_not_wrapped("PBUnshareSync")
        self.assert_not_wrapped("PBUnshareAsync")
        self.assert_not_wrapped("PBGetUGEntrySync")
        self.assert_not_wrapped("PBGetUGEntryAsync")
        self.assert_not_wrapped("PBGetVInfo")
        self.assert_not_wrapped("PBXGetVolInfo")
        self.assert_not_wrapped("PBGetVol")
        self.assert_not_wrapped("PBSetVol")
        self.assert_not_wrapped("PBFlushVol")
        self.assert_not_wrapped("PBCreate")
        self.assert_not_wrapped("PBDelete")
        self.assert_not_wrapped("PBOpenDF")
        self.assert_not_wrapped("PBOpenRF")
        self.assert_not_wrapped("PBRename")
        self.assert_not_wrapped("PBGetFInfo")
        self.assert_not_wrapped("PBSetFInfo")
        self.assert_not_wrapped("PBSetFLock")
        self.assert_not_wrapped("PBRstFLock")
        self.assert_not_wrapped("PBSetFVers")
        self.assert_not_wrapped("PBAllocate")
        self.assert_not_wrapped("PBGetEOF")
        self.assert_not_wrapped("PBSetEOF")
        self.assert_not_wrapped("PBGetFPos")
        self.assert_not_wrapped("PBSetFPos")
        self.assert_not_wrapped("PBFlushFile")
        self.assert_not_wrapped("PBCatSearch")
        self.assert_not_wrapped("PBOpenWD")
        self.assert_not_wrapped("PBCloseWD")
        self.assert_not_wrapped("PBHSetVol")
        self.assert_not_wrapped("PBHGetVol")
        self.assert_not_wrapped("PBCatMove")
        self.assert_not_wrapped("PBDirCreate")
        self.assert_not_wrapped("PBGetWDInfo")
        self.assert_not_wrapped("PBGetFCBInfo")
        self.assert_not_wrapped("PBGetCatInfo")
        self.assert_not_wrapped("PBSetCatInfo")
        self.assert_not_wrapped("PBAllocContig")
        self.assert_not_wrapped("PBLockRange")
        self.assert_not_wrapped("PBUnlockRange")
        self.assert_not_wrapped("PBSetVInfo")
        self.assert_not_wrapped("PBHGetVInfo")
        self.assert_not_wrapped("PBHOpen")
        self.assert_not_wrapped("PBHOpenRF")
        self.assert_not_wrapped("PBHOpenDF")
        self.assert_not_wrapped("PBHCreate")
        self.assert_not_wrapped("PBHDelete")
        self.assert_not_wrapped("PBHRename")
        self.assert_not_wrapped("PBHRstFLock")
        self.assert_not_wrapped("PBHSetFLock")
        self.assert_not_wrapped("PBHGetFInfo")
        self.assert_not_wrapped("PBHSetFInfo")
        self.assert_not_wrapped("PBMakeFSSpec")
        self.assert_not_wrapped("PBHGetVolParms")
        self.assert_not_wrapped("PBHGetLogInInfo")
        self.assert_not_wrapped("PBHGetDirAccess")
        self.assert_not_wrapped("PBHSetDirAccess")
        self.assert_not_wrapped("PBHMapID")
        self.assert_not_wrapped("PBHMapName")
        self.assert_not_wrapped("PBHCopyFile")
        self.assert_not_wrapped("PBHMoveRename")
        self.assert_not_wrapped("PBHOpenDeny")
        self.assert_not_wrapped("PBHOpenRFDeny")
        self.assert_not_wrapped("PBExchangeFiles")
        self.assert_not_wrapped("PBCreateFileIDRef")
        self.assert_not_wrapped("PBResolveFileIDRef")
        self.assert_not_wrapped("PBDeleteFileIDRef")
        self.assert_not_wrapped("PBGetForeignPrivs")
        self.assert_not_wrapped("PBSetForeignPrivs")
        self.assert_not_wrapped("PBDTAddIcon")
        self.assert_not_wrapped("PBDTGetIcon")
        self.assert_not_wrapped("PBDTGetIconInfo")
        self.assert_not_wrapped("PBDTAddAPPL")
        self.assert_not_wrapped("PBDTRemoveAPPL")
        self.assert_not_wrapped("PBDTGetAPPL")
        self.assert_not_wrapped("PBDTSetComment")
        self.assert_not_wrapped("PBDTRemoveComment")
        self.assert_not_wrapped("PBDTGetComment")
        self.assert_not_wrapped("PBDTFlush")
        self.assert_not_wrapped("PBDTReset")
        self.assert_not_wrapped("PBDTGetInfo")
        self.assert_not_wrapped("PBDTDelete")
