from PyObjCTools.TestSupport import *
from Quartz import *
import Quartz


class TestCGImageProperties(TestCase):
    @min_os_level("10.14")
    def testFunctions(self):
        CGImageSourceGetPrimaryImageIndex

    def testConstants(self):
        self.assertEqual(IMAGEIO_PNG_NO_FILTERS, 0x00)
        self.assertEqual(IMAGEIO_PNG_FILTER_NONE, 0x08)
        self.assertEqual(IMAGEIO_PNG_FILTER_SUB, 0x10)
        self.assertEqual(IMAGEIO_PNG_FILTER_UP, 0x20)
        self.assertEqual(IMAGEIO_PNG_FILTER_AVG, 0x40)
        self.assertEqual(IMAGEIO_PNG_FILTER_PAETH, 0x80)
        self.assertEqual(
            IMAGEIO_PNG_ALL_FILTERS,
            IMAGEIO_PNG_FILTER_NONE
            | IMAGEIO_PNG_FILTER_SUB
            | IMAGEIO_PNG_FILTER_UP
            | IMAGEIO_PNG_FILTER_AVG
            | IMAGEIO_PNG_FILTER_PAETH,
        )

        self.assertIsInstance(kCGImagePropertyTIFFDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyGIFDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyJFIFDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyExifDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyPNGDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyRawDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFDictionary, unicode)

        self.assertIsInstance(kCGImagePropertyFileSize, unicode)
        self.assertIsInstance(kCGImagePropertyPixelHeight, unicode)
        self.assertIsInstance(kCGImagePropertyPixelWidth, unicode)
        self.assertIsInstance(kCGImagePropertyDPIHeight, unicode)
        self.assertIsInstance(kCGImagePropertyDPIWidth, unicode)
        self.assertIsInstance(kCGImagePropertyDepth, unicode)
        self.assertIsInstance(kCGImagePropertyOrientation, unicode)
        self.assertIsInstance(kCGImagePropertyIsFloat, unicode)
        self.assertIsInstance(kCGImagePropertyIsIndexed, unicode)
        self.assertIsInstance(kCGImagePropertyHasAlpha, unicode)
        self.assertIsInstance(kCGImagePropertyColorModel, unicode)
        self.assertIsInstance(kCGImagePropertyProfileName, unicode)
        self.assertIsInstance(kCGImagePropertyColorModelRGB, unicode)
        self.assertIsInstance(kCGImagePropertyColorModelGray, unicode)
        self.assertIsInstance(kCGImagePropertyColorModelCMYK, unicode)
        self.assertIsInstance(kCGImagePropertyColorModelLab, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFCompression, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFPhotometricInterpretation, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFDocumentName, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFImageDescription, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFMake, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFModel, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFOrientation, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFXResolution, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFYResolution, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFResolutionUnit, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFSoftware, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFTransferFunction, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFDateTime, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFArtist, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFHostComputer, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFCopyright, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFWhitePoint, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFPrimaryChromaticities, unicode)
        self.assertIsInstance(kCGImagePropertyJFIFVersion, unicode)
        self.assertIsInstance(kCGImagePropertyJFIFXDensity, unicode)
        self.assertIsInstance(kCGImagePropertyJFIFYDensity, unicode)
        self.assertIsInstance(kCGImagePropertyJFIFDensityUnit, unicode)
        self.assertIsInstance(kCGImagePropertyJFIFIsProgressive, unicode)
        self.assertIsInstance(kCGImagePropertyExifExposureTime, unicode)
        self.assertIsInstance(kCGImagePropertyExifFNumber, unicode)
        self.assertIsInstance(kCGImagePropertyExifExposureProgram, unicode)
        self.assertIsInstance(kCGImagePropertyExifSpectralSensitivity, unicode)
        self.assertIsInstance(kCGImagePropertyExifISOSpeedRatings, unicode)
        self.assertIsInstance(kCGImagePropertyExifOECF, unicode)
        self.assertIsInstance(kCGImagePropertyExifVersion, unicode)
        self.assertIsInstance(kCGImagePropertyExifDateTimeOriginal, unicode)
        self.assertIsInstance(kCGImagePropertyExifDateTimeDigitized, unicode)
        self.assertIsInstance(kCGImagePropertyExifComponentsConfiguration, unicode)
        self.assertIsInstance(kCGImagePropertyExifCompressedBitsPerPixel, unicode)
        self.assertIsInstance(kCGImagePropertyExifShutterSpeedValue, unicode)
        self.assertIsInstance(kCGImagePropertyExifApertureValue, unicode)
        self.assertIsInstance(kCGImagePropertyExifBrightnessValue, unicode)
        self.assertIsInstance(kCGImagePropertyExifExposureBiasValue, unicode)
        self.assertIsInstance(kCGImagePropertyExifMaxApertureValue, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubjectDistance, unicode)
        self.assertIsInstance(kCGImagePropertyExifMeteringMode, unicode)
        self.assertIsInstance(kCGImagePropertyExifLightSource, unicode)
        self.assertIsInstance(kCGImagePropertyExifFlash, unicode)
        self.assertIsInstance(kCGImagePropertyExifFocalLength, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubjectArea, unicode)
        self.assertIsInstance(kCGImagePropertyExifMakerNote, unicode)
        self.assertIsInstance(kCGImagePropertyExifUserComment, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubsecTime, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubsecTimeOrginal, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubsecTimeDigitized, unicode)
        self.assertIsInstance(kCGImagePropertyExifFlashPixVersion, unicode)
        self.assertIsInstance(kCGImagePropertyExifColorSpace, unicode)
        self.assertIsInstance(kCGImagePropertyExifPixelXDimension, unicode)
        self.assertIsInstance(kCGImagePropertyExifPixelYDimension, unicode)
        self.assertIsInstance(kCGImagePropertyExifRelatedSoundFile, unicode)
        self.assertIsInstance(kCGImagePropertyExifFlashEnergy, unicode)
        self.assertIsInstance(kCGImagePropertyExifSpatialFrequencyResponse, unicode)
        self.assertIsInstance(kCGImagePropertyExifFocalPlaneXResolution, unicode)
        self.assertIsInstance(kCGImagePropertyExifFocalPlaneYResolution, unicode)
        self.assertIsInstance(kCGImagePropertyExifFocalPlaneResolutionUnit, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubjectLocation, unicode)
        self.assertIsInstance(kCGImagePropertyExifExposureIndex, unicode)
        self.assertIsInstance(kCGImagePropertyExifSensingMethod, unicode)
        self.assertIsInstance(kCGImagePropertyExifFileSource, unicode)
        self.assertIsInstance(kCGImagePropertyExifSceneType, unicode)
        self.assertIsInstance(kCGImagePropertyExifCFAPattern, unicode)
        self.assertIsInstance(kCGImagePropertyExifCustomRendered, unicode)
        self.assertIsInstance(kCGImagePropertyExifExposureMode, unicode)
        self.assertIsInstance(kCGImagePropertyExifWhiteBalance, unicode)
        self.assertIsInstance(kCGImagePropertyExifDigitalZoomRatio, unicode)
        self.assertIsInstance(kCGImagePropertyExifFocalLenIn35mmFilm, unicode)
        self.assertIsInstance(kCGImagePropertyExifSceneCaptureType, unicode)
        self.assertIsInstance(kCGImagePropertyExifGainControl, unicode)
        self.assertIsInstance(kCGImagePropertyExifContrast, unicode)
        self.assertIsInstance(kCGImagePropertyExifSaturation, unicode)
        self.assertIsInstance(kCGImagePropertyExifSharpness, unicode)
        self.assertIsInstance(kCGImagePropertyExifDeviceSettingDescription, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubjectDistRange, unicode)
        self.assertIsInstance(kCGImagePropertyExifImageUniqueID, unicode)
        self.assertIsInstance(kCGImagePropertyExifGamma, unicode)
        self.assertIsInstance(kCGImagePropertyGIFLoopCount, unicode)
        self.assertIsInstance(kCGImagePropertyGIFDelayTime, unicode)
        self.assertIsInstance(kCGImagePropertyGIFImageColorMap, unicode)
        self.assertIsInstance(kCGImagePropertyGIFHasGlobalColorMap, unicode)
        self.assertIsInstance(kCGImagePropertyPNGGamma, unicode)
        self.assertIsInstance(kCGImagePropertyPNGInterlaceType, unicode)
        self.assertIsInstance(kCGImagePropertyPNGXPixelsPerMeter, unicode)
        self.assertIsInstance(kCGImagePropertyPNGYPixelsPerMeter, unicode)
        self.assertIsInstance(kCGImagePropertyPNGsRGBIntent, unicode)
        self.assertIsInstance(kCGImagePropertyPNGChromaticities, unicode)
        self.assertIsInstance(kCGImagePropertyGPSVersion, unicode)
        self.assertIsInstance(kCGImagePropertyGPSLatitudeRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSLatitude, unicode)
        self.assertIsInstance(kCGImagePropertyGPSLongitudeRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSLongitude, unicode)
        self.assertIsInstance(kCGImagePropertyGPSAltitudeRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSAltitude, unicode)
        self.assertIsInstance(kCGImagePropertyGPSTimeStamp, unicode)
        self.assertIsInstance(kCGImagePropertyGPSSatellites, unicode)
        self.assertIsInstance(kCGImagePropertyGPSStatus, unicode)
        self.assertIsInstance(kCGImagePropertyGPSMeasureMode, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDOP, unicode)
        self.assertIsInstance(kCGImagePropertyGPSSpeedRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSSpeed, unicode)
        self.assertIsInstance(kCGImagePropertyGPSTrackRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSTrack, unicode)
        self.assertIsInstance(kCGImagePropertyGPSImgDirectionRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSImgDirection, unicode)
        self.assertIsInstance(kCGImagePropertyGPSMapDatum, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestLatitudeRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestLatitude, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestLongitudeRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestLongitude, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestBearingRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestBearing, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestDistanceRef, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDestDistance, unicode)
        self.assertIsInstance(kCGImagePropertyGPSProcessingMethod, unicode)
        self.assertIsInstance(kCGImagePropertyGPSAreaInformation, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDateStamp, unicode)
        self.assertIsInstance(kCGImagePropertyGPSDifferental, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCObjectTypeReference, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCObjectAttributeReference, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCObjectName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCEditStatus, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCEditorialUpdate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCUrgency, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCSubjectReference, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCategory, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCSupplementalCategory, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCFixtureIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCKeywords, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContentLocationCode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContentLocationName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCReleaseDate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCReleaseTime, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExpirationDate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExpirationTime, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCSpecialInstructions, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCActionAdvised, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCReferenceService, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCReferenceDate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCReferenceNumber, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCDateCreated, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCTimeCreated, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCDigitalCreationDate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCDigitalCreationTime, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCOriginatingProgram, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCProgramVersion, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCObjectCycle, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCByline, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCBylineTitle, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCity, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCSubLocation, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCProvinceState, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCountryPrimaryLocationCode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCountryPrimaryLocationName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCOriginalTransmissionReference, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCHeadline, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCredit, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCSource, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCopyrightNotice, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContact, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCCaptionAbstract, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCWriterEditor, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCImageType, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCImageOrientation, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCLanguageIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCStarRating, unicode)

        self.assertEqual(kCGImagePropertyOrientationUp, 1)
        self.assertEqual(kCGImagePropertyOrientationUpMirrored, 2)
        self.assertEqual(kCGImagePropertyOrientationDown, 3)
        self.assertEqual(kCGImagePropertyOrientationDownMirrored, 4)
        self.assertEqual(kCGImagePropertyOrientationLeftMirrored, 5)
        self.assertEqual(kCGImagePropertyOrientationRight, 6)
        self.assertEqual(kCGImagePropertyOrientationRightMirrored, 7)
        self.assertEqual(kCGImagePropertyOrientationLeft, 8)

    @min_os_level("10.5")
    def testConstants10_5(self):
        self.assertIsInstance(kCGImagePropertyMakerCanonDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonDictionary, unicode)
        self.assertIsInstance(kCGImageProperty8BIMDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyDNGDictionary, unicode)
        self.assertIsInstance(kCGImageProperty8BIMLayerNames, unicode)
        self.assertIsInstance(kCGImagePropertyDNGVersion, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBackwardVersion, unicode)
        self.assertIsInstance(kCGImagePropertyDNGUniqueCameraModel, unicode)
        self.assertIsInstance(kCGImagePropertyDNGLocalizedCameraModel, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCameraSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyDNGLensInfo, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFDescription, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFFirmware, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFOwnerName, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFImageName, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFImageFileName, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFReleaseMethod, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFReleaseTiming, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFRecordID, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFSelfTimingTime, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFCameraSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFImageSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFContinuousDrive, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFFocusMode, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFMeteringMode, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFShootingMode, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFLensModel, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFLensMaxMM, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFLensMinMM, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFWhiteBalanceIndex, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFFlashExposureComp, unicode)
        self.assertIsInstance(kCGImagePropertyCIFFMeasuredEV, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonISOSetting, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonColorMode, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonQuality, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonWhiteBalanceMode, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonSharpenMode, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonFocusMode, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonFlashSetting, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonISOSelection, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonFlashExposureComp, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonImageAdjustment, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonLensAdapter, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonLensType, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonLensInfo, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonFocusDistance, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonDigitalZoom, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonShootingMode, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonCameraSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyMakerNikonShutterCount, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonOwnerName, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonCameraSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonImageSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonFlashExposureComp, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonContinuousDrive, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonLensModel, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonFirmware, unicode)
        self.assertIsInstance(kCGImagePropertyMakerCanonAspectRatioInfo, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxLensInfo, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxLensModel, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxLensID, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxLensSerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxImageNumber, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxFlashCompensation, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxOwnerName, unicode)
        self.assertIsInstance(kCGImagePropertyExifAuxFirmware, unicode)

    @min_os_level("10.5")
    @expectedFailureIf(os_release().rsplit(".", 1)[0] == "10.6")
    def testConstants10_5_bad_on_10_6(self):
        self.assertTrue(hasattr(Quartz, "kCGImagePropertyMakerMinoltaDictionary"))
        self.assertTrue(hasattr(Quartz, "kCGImagePropertyMakerFujiDictionary"))
        self.assertTrue(hasattr(Quartz, "kCGImagePropertyMakerOlympusDictionary"))
        self.assertTrue(hasattr(Quartz, "kCGImagePropertyMakerPentaxDictionary"))

        self.assertIsInstance(kCGImagePropertyMakerMinoltaDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyMakerFujiDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyMakerOlympusDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyMakerPentaxDictionary, unicode)

    @min_os_level("10.7")
    def testConstants10_6(self):
        # Contants aren't actually available on OSX 10.6
        self.assertIsInstance(kCGImagePropertyIPTCCreatorContactInfo, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCRightsUsageTerms, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCScene, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoCity, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoCountry, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoAddress, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoPostalCode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoStateProvince, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoEmails, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoPhones, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCContactInfoWebURLs, unicode)

    @min_os_level("10.7")
    def testConstants10_7(self):
        self.assertIsInstance(kCGImagePropertyGIFUnclampedDelayTime, unicode)
        self.assertIsInstance(kCGImagePropertyPNGAuthor, unicode)
        self.assertIsInstance(kCGImagePropertyPNGCopyright, unicode)
        self.assertIsInstance(kCGImagePropertyPNGCreationTime, unicode)
        self.assertIsInstance(kCGImagePropertyPNGDescription, unicode)
        self.assertIsInstance(kCGImagePropertyPNGModificationTime, unicode)
        self.assertIsInstance(kCGImagePropertyPNGSoftware, unicode)
        self.assertIsInstance(kCGImagePropertyPNGTitle, unicode)

    @min_os_level("10.7")
    @expectedFailureIf(os_level_key(os_release()) <= os_level_key("10.9"))
    def testConstants10_7_broken(self):
        # The constants in this testcase are defined in headers and documentation,
        # but aren't exported by the framework...
        self.assertIsInstance(kCGImagePropertyExifCameraOwnerName, unicode)
        self.assertIsInstance(kCGImagePropertyExifBodySerialNumber, unicode)
        self.assertIsInstance(kCGImagePropertyExifLensSpecification, unicode)
        self.assertIsInstance(kCGImagePropertyExifLensMake, unicode)
        self.assertIsInstance(kCGImagePropertyExifLensModel, unicode)
        self.assertIsInstance(kCGImagePropertyExifLensSerialNumber, unicode)

    @min_os_level("10.9")
    def testConstants10_9(self):
        self.assertIsInstance(kCGImagePropertyOpenEXRDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyOpenEXRAspectRatio, unicode)
        self.assertIsInstance(kCGImagePropertyExifSensitivityType, unicode)
        self.assertIsInstance(kCGImagePropertyExifStandardOutputSensitivity, unicode)
        self.assertIsInstance(kCGImagePropertyExifRecommendedExposureIndex, unicode)
        self.assertIsInstance(kCGImagePropertyExifISOSpeed, unicode)
        self.assertIsInstance(kCGImagePropertyExifISOSpeedLatitudeyyy, unicode)
        self.assertIsInstance(kCGImagePropertyExifISOSpeedLatitudezzz, unicode)

    @min_os_level("10.10")
    def testConstants10_10(self):
        self.assertIsInstance(kCGImagePropertyMakerAppleDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyAPNGLoopCount, unicode)
        self.assertIsInstance(kCGImagePropertyAPNGDelayTime, unicode)
        self.assertIsInstance(kCGImagePropertyAPNGUnclampedDelayTime, unicode)
        self.assertIsInstance(kCGImagePropertyGPSHPositioningError, unicode)
        self.assertIsInstance(kCGImageProperty8BIMVersion, unicode)

    @min_os_level("10.11")
    def testConstants10_11(self):
        self.assertIsInstance(kCGImagePropertyTIFFTileWidth, unicode)
        self.assertIsInstance(kCGImagePropertyTIFFTileLength, unicode)
        self.assertIsInstance(kCGImagePropertyPNGCompressionFilter, unicode)
        self.assertIsInstance(kCGImagePropertyExifSubsecTimeOriginal, unicode)

    @min_os_level("10.12")
    def testConstants10_12(self):
        self.assertIsInstance(kCGImagePropertyDNGBlackLevel, unicode)
        self.assertIsInstance(kCGImagePropertyDNGWhiteLevel, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCalibrationIlluminant1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCalibrationIlluminant2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGColorMatrix1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGColorMatrix2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCameraCalibration1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCameraCalibration2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAsShotNeutral, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAsShotWhiteXY, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBaselineExposure, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBaselineNoise, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBaselineSharpness, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPrivateData, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCameraCalibrationSignature, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileCalibrationSignature, unicode)
        self.assertIsInstance(kCGImagePropertyDNGNoiseProfile, unicode)
        self.assertIsInstance(kCGImagePropertyDNGWarpRectilinear, unicode)
        self.assertIsInstance(kCGImagePropertyDNGWarpFisheye, unicode)
        self.assertIsInstance(kCGImagePropertyDNGFixVignetteRadial, unicode)

    @min_os_level("10.13")
    def testConstants10_13(self):
        self.assertIsInstance(kCGImagePropertyFileContentsDictionary, unicode)
        self.assertIsInstance(kCGImageAuxiliaryDataTypeDepth, unicode)
        self.assertIsInstance(kCGImageAuxiliaryDataTypeDisparity, unicode)

        self.assertIsInstance(kCGImageAuxiliaryDataInfoData, unicode)
        self.assertIsInstance(kCGImageAuxiliaryDataInfoDataDescription, unicode)
        self.assertIsInstance(kCGImageAuxiliaryDataInfoMetadata, unicode)
        self.assertIsInstance(kCGImagePropertyImageCount, unicode)
        self.assertIsInstance(kCGImagePropertyWidth, unicode)
        self.assertIsInstance(kCGImagePropertyHeight, unicode)
        self.assertIsInstance(kCGImagePropertyBytesPerRow, unicode)
        self.assertIsInstance(kCGImagePropertyNamedColorSpace, unicode)
        self.assertIsInstance(kCGImagePropertyPixelFormat, unicode)
        self.assertIsInstance(kCGImagePropertyImages, unicode)
        self.assertIsInstance(kCGImagePropertyThumbnailImages, unicode)
        self.assertIsInstance(kCGImagePropertyAuxiliaryData, unicode)
        self.assertIsInstance(kCGImagePropertyAuxiliaryDataType, unicode)

        # New definition in Xcode 10.14 SDK
        self.assertIsInstance(kCGImagePropertyPrimaryImage, unicode)

    @min_os_level("10.13.4")
    def testConstants10_13_4(self):
        self.assertIsInstance(kCGImagePropertyIPTCExtAboutCvTerm, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAboutCvTermCvId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAboutCvTermId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAboutCvTermName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAboutCvTermRefinedAbout, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAddlModelInfo, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkOrObject, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkCircaDateCreated, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkContentDescription, unicode)
        self.assertIsInstance(
            kCGImagePropertyIPTCExtArtworkContributionDescription, unicode
        )
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkCopyrightNotice, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkCreator, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkCreatorID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkCopyrightOwnerID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkCopyrightOwnerName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkLicensorID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkLicensorName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkDateCreated, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkPhysicalDescription, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkSource, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkSourceInventoryNo, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkSourceInvURL, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkStylePeriod, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtArtworkTitle, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAudioBitrate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAudioBitrateMode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtAudioChannelCount, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtCircaDateCreated, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContainerFormat, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContainerFormatIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContainerFormatName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContributor, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContributorIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContributorName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtContributorRole, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtCopyrightYear, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtCreator, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtCreatorIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtCreatorName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtCreatorRole, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtControlledVocabularyTerm, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreen, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegion, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionD, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionH, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionText, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionUnit, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionW, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionX, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDataOnScreenRegionY, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDigitalImageGUID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDigitalSourceFileType, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDigitalSourceType, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDopesheet, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDopesheetLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDopesheetLinkLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtDopesheetLinkLinkQualifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtEmbdEncRightsExpr, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtEmbeddedEncodedRightsExpr, unicode)
        self.assertIsInstance(
            kCGImagePropertyIPTCExtEmbeddedEncodedRightsExprType, unicode
        )
        self.assertIsInstance(
            kCGImagePropertyIPTCExtEmbeddedEncodedRightsExprLangID, unicode
        )
        self.assertIsInstance(kCGImagePropertyIPTCExtEpisode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtEpisodeIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtEpisodeName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtEpisodeNumber, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtEvent, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtShownEvent, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtShownEventIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtShownEventName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtExternalMetadataLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtFeedIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtGenre, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtGenreCvId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtGenreCvTermId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtGenreCvTermName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtGenreCvTermRefinedAbout, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtHeadline, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtIPTCLastEdited, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLinkedEncRightsExpr, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLinkedEncodedRightsExpr, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLinkedEncodedRightsExprType, unicode)
        self.assertIsInstance(
            kCGImagePropertyIPTCExtLinkedEncodedRightsExprLangID, unicode
        )
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationCreated, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationCity, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationCountryCode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationCountryName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationGPSAltitude, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationGPSLatitude, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationGPSLongitude, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationLocationId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationLocationName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationProvinceState, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationSublocation, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationWorldRegion, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtLocationShown, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtMaxAvailHeight, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtMaxAvailWidth, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtModelAge, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtOrganisationInImageCode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtOrganisationInImageName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonHeard, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonHeardIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonHeardName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImage, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageWDetails, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageCharacteristic, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageCvTermCvId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageCvTermId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageCvTermName, unicode)
        self.assertIsInstance(
            kCGImagePropertyIPTCExtPersonInImageCvTermRefinedAbout, unicode
        )
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageDescription, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPersonInImageName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtProductInImage, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtProductInImageDescription, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtProductInImageGTIN, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtProductInImageName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPublicationEvent, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPublicationEventDate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPublicationEventIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtPublicationEventName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRating, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRatingRegion, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionCity, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionCountryCode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionCountryName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionGPSAltitude, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionGPSLatitude, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionGPSLongitude, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionLocationId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionLocationName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionProvinceState, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionSublocation, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingRegionWorldRegion, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingScaleMaxValue, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingScaleMinValue, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingSourceLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingValue, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRatingValueLogoLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRegistryID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRegistryEntryRole, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRegistryItemID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtRegistryOrganisationID, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtReleaseReady, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeason, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeasonIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeasonName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeasonNumber, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeries, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeriesIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSeriesName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtStorylineIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtStreamReady, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtStylePeriod, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSupplyChainSource, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSupplyChainSourceIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtSupplyChainSourceName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTemporalCoverage, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTemporalCoverageFrom, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTemporalCoverageTo, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTranscript, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTranscriptLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTranscriptLinkLink, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtTranscriptLinkLinkQualifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoBitrate, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoBitrateMode, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoDisplayAspectRatio, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoEncodingProfile, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoShotType, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoShotTypeIdentifier, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoShotTypeName, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVideoStreamsCount, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtVisualColor, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtWorkflowTag, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtWorkflowTagCvId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtWorkflowTagCvTermId, unicode)
        self.assertIsInstance(kCGImagePropertyIPTCExtWorkflowTagCvTermName, unicode)
        self.assertIsInstance(
            kCGImagePropertyIPTCExtWorkflowTagCvTermRefinedAbout, unicode
        )

    @min_os_level("10.14")
    def testConstants10_14(self):
        self.assertIsInstance(kCGImagePropertyDNGActiveArea, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAnalogBalance, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAntiAliasStrength, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAsShotICCProfile, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAsShotPreProfileMatrix, unicode)
        self.assertIsInstance(kCGImagePropertyDNGAsShotProfileName, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBaselineExposureOffset, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBayerGreenSplit, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBestQualityScale, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBlackLevelDeltaH, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBlackLevelDeltaV, unicode)
        self.assertIsInstance(kCGImagePropertyDNGBlackLevelRepeatDim, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCFALayout, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCFAPlaneColor, unicode)
        self.assertIsInstance(kCGImagePropertyDNGChromaBlurRadius, unicode)
        self.assertIsInstance(kCGImagePropertyDNGColorimetricReference, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCurrentICCProfile, unicode)
        self.assertIsInstance(kCGImagePropertyDNGCurrentPreProfileMatrix, unicode)
        self.assertIsInstance(kCGImagePropertyDNGDefaultBlackRender, unicode)
        self.assertIsInstance(kCGImagePropertyDNGDefaultCropOrigin, unicode)
        self.assertIsInstance(kCGImagePropertyDNGDefaultCropSize, unicode)
        self.assertIsInstance(kCGImagePropertyDNGDefaultScale, unicode)
        self.assertIsInstance(kCGImagePropertyDNGDefaultUserCrop, unicode)
        self.assertIsInstance(kCGImagePropertyDNGExtraCameraProfiles, unicode)
        self.assertIsInstance(kCGImagePropertyDNGForwardMatrix1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGForwardMatrix2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGLinearizationTable, unicode)
        self.assertIsInstance(kCGImagePropertyDNGLinearResponseLimit, unicode)
        self.assertIsInstance(kCGImagePropertyDNGMakerNoteSafety, unicode)
        self.assertIsInstance(kCGImagePropertyDNGMaskedAreas, unicode)
        self.assertIsInstance(kCGImagePropertyDNGNewRawImageDigest, unicode)
        self.assertIsInstance(kCGImagePropertyDNGNoiseReductionApplied, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOpcodeList1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOpcodeList2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOpcodeList3, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOriginalBestQualityFinalSize, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOriginalDefaultCropSize, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOriginalDefaultFinalSize, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOriginalRawFileData, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOriginalRawFileDigest, unicode)
        self.assertIsInstance(kCGImagePropertyDNGOriginalRawFileName, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPreviewApplicationName, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPreviewApplicationVersion, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPreviewColorSpace, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPreviewDateTime, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPreviewSettingsDigest, unicode)
        self.assertIsInstance(kCGImagePropertyDNGPreviewSettingsName, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileCopyright, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileEmbedPolicy, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileHueSatMapData1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileHueSatMapData2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileHueSatMapDims, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileHueSatMapEncoding, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileLookTableData, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileLookTableDims, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileLookTableEncoding, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileName, unicode)
        self.assertIsInstance(kCGImagePropertyDNGProfileToneCurve, unicode)
        self.assertIsInstance(kCGImagePropertyDNGRawDataUniqueID, unicode)
        self.assertIsInstance(kCGImagePropertyDNGRawImageDigest, unicode)
        self.assertIsInstance(kCGImagePropertyDNGRawToPreviewGain, unicode)
        self.assertIsInstance(kCGImagePropertyDNGReductionMatrix1, unicode)
        self.assertIsInstance(kCGImagePropertyDNGReductionMatrix2, unicode)
        self.assertIsInstance(kCGImagePropertyDNGRowInterleaveFactor, unicode)
        self.assertIsInstance(kCGImagePropertyDNGShadowScale, unicode)
        self.assertIsInstance(kCGImagePropertyDNGSubTileBlockSize, unicode)

        self.assertIsInstance(kCGImageAuxiliaryDataTypePortraitEffectsMatte, unicode)

        self.assertIsInstance(kCGImagePropertyPNGComment, unicode)
        self.assertIsInstance(kCGImagePropertyPNGDisclaimer, unicode)
        self.assertIsInstance(kCGImagePropertyPNGSource, unicode)
        self.assertIsInstance(kCGImagePropertyPNGWarning, unicode)

    @min_os_level("10.15")
    def testConstants10_15(self):
        self.assertIsInstance(kCGImagePropertyHEICSDictionary, unicode)
        self.assertIsInstance(kCGImagePropertyHEICSLoopCount, unicode)
        self.assertIsInstance(kCGImagePropertyHEICSDelayTime, unicode)
        self.assertIsInstance(kCGImagePropertyHEICSUnclampedDelayTime, unicode)
        self.assertIsInstance(kCGImagePropertyHEICSCanvasPixelWidth, unicode)
        self.assertIsInstance(kCGImagePropertyHEICSCanvasPixelHeight, unicode)
        self.assertIsInstance(kCGImagePropertyHEICSFrameInfoArray, unicode)
        self.assertIsInstance(kCGImagePropertyExifOffsetTime, unicode)
        self.assertIsInstance(kCGImagePropertyExifOffsetTimeOriginal, unicode)
        self.assertIsInstance(kCGImagePropertyExifOffsetTimeDigitized, unicode)
        self.assertIsInstance(kCGImagePropertyGIFCanvasPixelWidth, unicode)
        self.assertIsInstance(kCGImagePropertyGIFCanvasPixelHeight, unicode)
        self.assertIsInstance(kCGImagePropertyGIFFrameInfoArray, unicode)
        self.assertIsInstance(kCGImagePropertyAPNGFrameInfoArray, unicode)
        self.assertIsInstance(kCGImagePropertyAPNGCanvasPixelWidth, unicode)
        self.assertIsInstance(kCGImagePropertyAPNGCanvasPixelHeight, unicode)
        self.assertIsInstance(
            kCGImageAuxiliaryDataTypeSemanticSegmentationSkinMatte, unicode
        )
        self.assertIsInstance(
            kCGImageAuxiliaryDataTypeSemanticSegmentationHairMatte, unicode
        )
        self.assertIsInstance(
            kCGImageAuxiliaryDataTypeSemanticSegmentationTeethMatte, unicode
        )

    @min_os_level("10.15.1")
    def testConstants10_15_1(self):
        self.assertIsInstance(
            kCGImagePropertyExifCompositeImage, unicode
        )
        self.assertIsInstance(
            kCGImagePropertyExifSourceImageNumberOfCompositeImage, unicode
        )
        self.assertIsInstance(
            kCGImagePropertyExifSourceExposureTimesOfCompositeImage, unicode
        )

if __name__ == "__main__":
    main()
