from PyObjCTools.TestSupport import *

import Security

class TestCSCommon (TestCase):

    def test_types(self):
        self.assertIsCFType(Security.SecCodeRef)
        self.assertIsCFType(Security.SecRequirementRef)

    def test_constants(self):
        self.assertEqual(Security.errSecCSUnimplemented, -67072)
        self.assertEqual(Security.errSecCSInvalidObjectRef, -67071)
        self.assertEqual(Security.errSecCSInvalidFlags, -67070)
        self.assertEqual(Security.errSecCSObjectRequired, -67069)
        self.assertEqual(Security.errSecCSStaticCodeNotFound, -67068)
        self.assertEqual(Security.errSecCSUnsupportedGuestAttributes, -67067)
        self.assertEqual(Security.errSecCSInvalidAttributeValues, -67066)
        self.assertEqual(Security.errSecCSNoSuchCode, -67065)
        self.assertEqual(Security.errSecCSMultipleGuests, -67064)
        self.assertEqual(Security.errSecCSGuestInvalid, -67063)
        self.assertEqual(Security.errSecCSUnsigned, -67062)
        self.assertEqual(Security.errSecCSSignatureFailed, -67061)
        self.assertEqual(Security.errSecCSSignatureNotVerifiable, -67060)
        self.assertEqual(Security.errSecCSSignatureUnsupported, -67059)
        self.assertEqual(Security.errSecCSBadDictionaryFormat, -67058)
        self.assertEqual(Security.errSecCSResourcesNotSealed, -67057)
        self.assertEqual(Security.errSecCSResourcesNotFound, -67056)
        self.assertEqual(Security.errSecCSResourcesInvalid, -67055)
        self.assertEqual(Security.errSecCSBadResource, -67054)
        self.assertEqual(Security.errSecCSResourceRulesInvalid, -67053)
        self.assertEqual(Security.errSecCSReqInvalid, -67052)
        self.assertEqual(Security.errSecCSReqUnsupported, -67051)
        self.assertEqual(Security.errSecCSReqFailed, -67050)
        self.assertEqual(Security.errSecCSBadObjectFormat, -67049)
        self.assertEqual(Security.errSecCSInternalError, -67048)
        self.assertEqual(Security.errSecCSHostReject, -67047)
        self.assertEqual(Security.errSecCSNotAHost, -67046)
        self.assertEqual(Security.errSecCSSignatureInvalid, -67045)
        self.assertEqual(Security.errSecCSHostProtocolRelativePath, -67044)
        self.assertEqual(Security.errSecCSHostProtocolContradiction, -67043)
        self.assertEqual(Security.errSecCSHostProtocolDedicationError, -67042)
        self.assertEqual(Security.errSecCSHostProtocolNotProxy, -67041)
        self.assertEqual(Security.errSecCSHostProtocolStateError, -67040)
        self.assertEqual(Security.errSecCSHostProtocolUnrelated, -67039)
        self.assertEqual(Security.errSecCSNotSupported, -67037)
        self.assertEqual(Security.errSecCSCMSTooLarge, -67036)
        self.assertEqual(Security.errSecCSHostProtocolInvalidHash, -67035)
        self.assertEqual(Security.errSecCSStaticCodeChanged, -67034)
        self.assertEqual(Security.errSecCSDBDenied, -67033)
        self.assertEqual(Security.errSecCSDBAccess, -67032)
        self.assertEqual(Security.errSecCSSigDBDenied, Security.errSecCSDBDenied)
        self.assertEqual(Security.errSecCSSigDBAccess, Security.errSecCSDBAccess)
        self.assertEqual(Security.errSecCSHostProtocolInvalidAttribute, -67031)
        self.assertEqual(Security.errSecCSInfoPlistFailed, -67030)
        self.assertEqual(Security.errSecCSNoMainExecutable, -67029)
        self.assertEqual(Security.errSecCSBadBundleFormat, -67028)
        self.assertEqual(Security.errSecCSNoMatches, -67027)
        self.assertEqual(Security.errSecCSFileHardQuarantined, -67026)
        self.assertEqual(Security.errSecCSOutdated, -67025)
        self.assertEqual(Security.errSecCSDbCorrupt, -67024)
        self.assertEqual(Security.errSecCSResourceDirectoryFailed, -67023)
        self.assertEqual(Security.errSecCSUnsignedNestedCode, -67022)
        self.assertEqual(Security.errSecCSBadNestedCode, -67021)
        self.assertEqual(Security.errSecCSBadCallbackValue, -67020)
        self.assertEqual(Security.errSecCSHelperFailed, -67019)
        self.assertEqual(Security.errSecCSVetoed, -67018)
        self.assertEqual(Security.errSecCSBadLVArch, -67017)
        self.assertEqual(Security.errSecCSResourceNotSupported, -67016)
        self.assertEqual(Security.errSecCSRegularFile, -67015)
        self.assertEqual(Security.errSecCSUnsealedAppRoot, -67014)
        self.assertEqual(Security.errSecCSWeakResourceRules, -67013)
        self.assertEqual(Security.errSecCSDSStoreSymlink, -67012)
        self.assertEqual(Security.errSecCSAmbiguousBundleFormat, -67011)
        self.assertEqual(Security.errSecCSBadMainExecutable, -67010)
        self.assertEqual(Security.errSecCSBadFrameworkVersion, -67009)
        self.assertEqual(Security.errSecCSUnsealedFrameworkRoot, -67008)
        self.assertEqual(Security.errSecCSWeakResourceEnvelope, -67007)
        self.assertEqual(Security.errSecCSCancelled, -67006)
        self.assertEqual(Security.errSecCSInvalidPlatform, -67005)
        self.assertEqual(Security.errSecCSTooBig, -67004)
        self.assertEqual(Security.errSecCSInvalidSymlink, -67003)
        self.assertEqual(Security.errSecCSNotAppLike, -67002)
        self.assertEqual(Security.errSecCSBadDiskImageFormat, -67001)
        self.assertEqual(Security.errSecCSUnsupportedDigestAlgorithm, -67000)
        self.assertEqual(Security.errSecCSInvalidAssociatedFileData, -66999)
        self.assertEqual(Security.errSecCSInvalidTeamIdentifier, -66998)
        self.assertEqual(Security.errSecCSBadTeamIdentifier, -66997)
        self.assertEqual(Security.errSecCSSignatureUntrusted, -66996)
        self.assertEqual(Security.errSecMultipleExecSegments, -66995)
        self.assertEqual(Security.errSecCSInvalidEntitlements, -66994)
        self.assertEqual(Security.errSecCSInvalidRuntimeVersion, -66993)
        self.assertEqual(Security.errSecCSRevokedNotarization, -66992)

        self.assertIsInstance(Security.kSecCFErrorArchitecture, unicode)
        self.assertIsInstance(Security.kSecCFErrorPattern, unicode)
        self.assertIsInstance(Security.kSecCFErrorResourceSeal, unicode)
        self.assertIsInstance(Security.kSecCFErrorResourceAdded, unicode)
        self.assertIsInstance(Security.kSecCFErrorResourceAltered, unicode)
        self.assertIsInstance(Security.kSecCFErrorResourceMissing, unicode)
        self.assertIsInstance(Security.kSecCFErrorInfoPlist, unicode)
        self.assertIsInstance(Security.kSecCFErrorGuestAttributes, unicode)
        self.assertIsInstance(Security.kSecCFErrorRequirementSyntax, unicode)
        self.assertIsInstance(Security.kSecCFErrorPath, unicode)

        self.assertEqual(Security.kSecNoGuest, 0)

        self.assertEqual(Security.kSecCSDefaultFlags, 0)
        self.assertEqual(Security.kSecCSConsiderExpiration, 1 << 31)
        self.assertEqual(Security.kSecCSEnforceRevocationChecks, 1 << 30)
        self.assertEqual(Security.kSecCSNoNetworkAccess, 1 << 29)
        self.assertEqual(Security.kSecCSReportProgress, 1 << 28)
        self.assertEqual(Security.kSecCSCheckTrustedAnchors, 1 << 27)
        self.assertEqual(Security.kSecCSQuickCheck, 1 << 26)

        self.assertEqual(Security.kSecCodeSignatureHost, 0x0001)
        self.assertEqual(Security.kSecCodeSignatureAdhoc, 0x0002)
        self.assertEqual(Security.kSecCodeSignatureForceHard, 0x0100)
        self.assertEqual(Security.kSecCodeSignatureForceKill, 0x0200)
        self.assertEqual(Security.kSecCodeSignatureForceExpiration, 0x0400)
        self.assertEqual(Security.kSecCodeSignatureRestrict, 0x0800)
        self.assertEqual(Security.kSecCodeSignatureEnforcement, 0x1000)
        self.assertEqual(Security.kSecCodeSignatureLibraryValidation, 0x2000)
        self.assertEqual(Security.kSecCodeSignatureRuntime, 0x10000)

        self.assertEqual(Security.kSecCodeStatusValid, 0x0001)
        self.assertEqual(Security.kSecCodeStatusHard, 0x0100)
        self.assertEqual(Security.kSecCodeStatusKill, 0x0200)
        self.assertEqual(Security.kSecCodeStatusDebugged, 0x10000000)
        self.assertEqual(Security.kSecCodeStatusPlatform, 0x04000000)

        self.assertEqual(Security.kSecHostRequirementType, 1)
        self.assertEqual(Security.kSecGuestRequirementType, 2)
        self.assertEqual(Security.kSecDesignatedRequirementType, 3)
        self.assertEqual(Security.kSecLibraryRequirementType, 4)
        self.assertEqual(Security.kSecPluginRequirementType, 5)
        self.assertEqual(Security.kSecInvalidRequirementType, 6)
        self.assertEqual(Security.kSecRequirementTypeCount, Security.kSecInvalidRequirementType)

        self.assertEqual(Security.kSecCodeSignatureNoHash, 0)
        self.assertEqual(Security.kSecCodeSignatureHashSHA1, 1)
        self.assertEqual(Security.kSecCodeSignatureHashSHA256, 2)
        self.assertEqual(Security.kSecCodeSignatureHashSHA256Truncated, 3)
        self.assertEqual(Security.kSecCodeSignatureHashSHA384, 4)
        self.assertEqual(Security.kSecCodeSignatureHashSHA512, 5)

    @min_os_level('10.12')
    def test_constants_10_12(self):
        self.assertIsInstance(Security.kSecCFErrorResourceSideband, unicode)

if __name__ == "__main__":
    main()
