
% Increase counter:

if (exist("idx", "var"));
  idx = idx + 1;
else;
  idx = 1;
end;

% Version, title and date:

VERSION                   (idx, [1: 13]) = 'Serpent 1.1.7' ;
TITLE                     (idx, [1: 30]) = '[CHAR] lwr2 Burnup Calculation' ;
DATE                      (idx, [1: 24]) = 'Sun May 22 22:33:50 2011' ;

% Run parameters:

POP                       (idx, 1)       = 5000 ;
CYCLES                    (idx, 1)       = 130 ;
SKIP                      (idx, 1)       = 30 ;
SEED                      (idx, 1)       = 1306121630 ;
MPI_TASKS                 (idx, 1)       = 1 ;
DEBUG                     (idx, 1)       = 0 ;
CPU_TYPE                  (idx, [1: 47]) = 'Intel(R) Core(TM) i7 CPU       M 640  @ 2.80GHz' ;
CPU_MHZ                   (idx, 1)       = 1463.0 ;
AVAIL_MEM                 (idx, 1)       = 7928.7 ;

% Delta-tracking parameters:

DT_THRESH                 (idx, 1)       = 9.00000E-01 ;
DT_FRAC                   (idx, 1)       = 9.75652E-01 ;
DT_EFF                    (idx, 1)       = 7.70260E-01 ;
MIN_MACROXS               (idx, 1)       = 1.20020E-01 ;

% Run statistics:

RUNNING_TIME              (idx, 1)       = 3.44928E+00 ;
INIT_TIME                 (idx, 1)       = 9.18017E-01 ;
TRANSPORT_CYCLE_TIME      (idx, 1)       = 2.52073E+00 ;
BURNUP_CYCLE_TIME         (idx, 1)       = 0.00000E+00 ;
PROCESS_TIME              (idx, 1)       = 1.04667E-02 ;
CYCLE_IDX                 (idx, 1)       = 130 ;
SOURCE_NEUTRONS           (idx, 1)       = 650000 ;
MEMSIZE                   (idx, 1)       = 3897.9;

% Energy grid parameters:

ERG_EMIN                  (idx, 1)        = 1.00000E-09 ;
ERG_EMAX                  (idx, 1)        = 1.00000E+01 ;
ERG_TOL                   (idx, 1)        = 5.00000E-05 ;
ERG_NE                    (idx, 1)        = 287264 ;
ERG_NE_INI                (idx, 1)        = 1167121 ;
ERG_NE_IMP                (idx, 1)        = 102321 ;
ERG_DIX                   (idx, 1)        = 0 ;

% Nuclides and reaction channels:

TOT_ISOTOPES              (idx, 1)        = 4132 ;
TOT_TRANSPORT_ISOTOPES    (idx, 1)        = 294 ;
TOT_DECAY_ISOTOPES        (idx, 1)        = 3838 ;
TOT_REA_CHANNELS          (idx, 1)        = 11719 ;

% Reaction mode counters:

COLLISIONS                (idx, 1)        = 21523975 ;
FISSION_FRACTION          (idx, 1)        = 1.53280E-02 ;
CAPTURE_FRACTION          (idx, 1)        = 1.49149E-02 ;
ELASTIC_FRACTION          (idx, 1)        = 5.96002E-01 ;
INELASTIC_FRACTION        (idx, 1)        = 9.84507E-03 ;
ALPHA_FRACTION            (idx, 1)        = 0.00000E+00 ;
BOUND_SCATTERING_FRACTION (idx, 1)        = 3.63866E-01 ;
NXN_FRACTION              (idx, 1)        = 4.40904E-05 ;
UNKNOWN_FRACTION          (idx, 1)        = 0.00000E+00 ;
VIRTUAL_FRACTION          (idx, 1)        = 2.29740E-01 ;

FREEGAS_FRACTION          (idx, 1)        = 7.14005E-01 ;
TOTAL_ELASTIC_FRACTION    (idx, 1)        = 9.59868E-01 ;
FISSILE_FISSION_FRACTION  (idx, 1)        = 9.45396E-01 ;
LEAKAGE_REACTIONS         (idx, 1)        = 0 ;

REA_SAMPLING_EFF          (idx, 1)        = 7.03409E-01 ;

% Slowing-down and thermalization:

COL_SLOW                  (idx, [1:   2]) = [  2.18652E+01 0.00045 ];
COL_THERM                 (idx, [1:   2]) = [  1.98342E+01 0.00136 ];
COL_TOT                   (idx, [1:   2]) = [  3.30678E+01 0.00079 ];
SLOW_TIME                 (idx, [1:   2]) = [  2.80318E-06 0.00108 ];
THERM_TIME                (idx, [1:   2]) = [  3.08297E-05 0.00149 ];
SLOW_DIST                 (idx, [1:   2]) = [  1.55864E+01 0.00093 ];
THERM_DIST                (idx, [1:   2]) = [  4.96081E+00 0.00104 ];
THERM_FRAC                (idx, [1:   2]) = [  6.67855E-01 0.00085 ];

% Parameters for burnup calculation:

BURN_MODE                 (idx, 1)        = 2 ;
BURN_STEP                 (idx, 1)        = 1 ;
BURN_TOT_STEPS            (idx, 1)        = 3 ;
BURNUP                    (idx, 1)        = 0.00000E+00 ;
BURN_DAYS                 (idx, 1)        = 0.00000E+00 ;
ENERGY_OUTPUT             (idx, 1)        = 0.00000E+00 ;
DEP_TTA_CUTOFF            (idx, 1)        = 1.00000E-15 ;
DEP_STABILITY_CUTOFF      (idx, 1)        = 1.00000E-22 ;
DEP_FP_YIELD_CUTOFF       (idx, 1)        = 1.00000E-22 ;
DEP_XS_FRAC_CUTOFF        (idx, 1)        = 0.00000E+00 ;
BURN_MATERIALS            (idx, 1)        = 10 ;
FP_NUCLIDES_INCLUDED      (idx, 1)        = 220 ;
FP_NUCLIDES_AVAILABLE     (idx, 1)        = 267 ;
TOT_ACTIVITY              (idx, 1)        = 2.92350E+09 ;
TOT_DECAY_HEAT            (idx, 1)        = 2.27199E-03 ;

% Fission source entropies:

ENTROPY_X                 (idx, [1:   2]) = [  9.94609E-01 0.00011 ];
ENTROPY_Y                 (idx, [1:   2]) = [  9.94681E-01 0.00011 ];
ENTROPY_Z                 (idx, [1:   2]) = [  1.72492E-17 0.27297 ];
ENTROPY_TOT               (idx, [1:   2]) = [  9.90170E-01 0.00010 ];

% Fission source centre:

SOURCE_X0                 (idx, [1:   2]) = [ -7.77804E-03 1.38812 ];
SOURCE_Y0                 (idx, [1:   2]) = [ -1.28481E-02 0.90836 ];
SOURCE_Z0                 (idx, [1:   2]) = [  2.56785E+01 0.03403 ];

% Criticality eigenvalues:

ANA_KEFF                  (idx, [1:   2]) = [  1.24711E+00 0.00132 ];
IMP_KEFF                  (idx, [1:   2]) = [  1.24207E+00 0.00053 ];
COL_KEFF                  (idx, [1:   2]) = [  1.24183E+00 0.00122 ];
ABS_KEFF                  (idx, [1:   2]) = [  1.24207E+00 0.00053 ];
ABS_KINF                  (idx, [1:   2]) = [  1.24207E+00 0.00053 ];
ABS_GC_KEFF               (idx, [1:   2]) = [  1.24207E+00 0.00053 ];
ABS_GC_KINF               (idx, [1:   2]) = [  1.24207E+00 0.00053 ];
IMPL_ALPHA_EIG            (idx, [1:   2]) = [  1.06517E+04 0.00241 ];
FIXED_ALPHA_EIG           (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
GEOM_ALBEDO               (idx, [1:   2]) = [  1.00000E+00 0.00000 ];

% Normalized total reaction rates:

TOT_POWER                 (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
TOT_GENRATE               (idx, [1:   2]) = [  3.78906E+15 0.00003 ];
TOT_FISSRATE              (idx, [1:   2]) = [  1.54181E+15 0.00000 ];
TOT_ABSRATE               (idx, [1:   2]) = [  3.05497E+15 0.00054 ];
TOT_LEAKRATE              (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
TOT_LOSSRATE              (idx, [1:   2]) = [  3.05497E+15 0.00054 ];
TOT_FLUX                  (idx, [1:   2]) = [  1.41638E+17 0.00098 ];
TOT_RR                    (idx, [1:   2]) = [  1.01047E+17 0.00085 ];
TOT_SOLU_ABSRATE          (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
TOT_FMASS                 (idx, 1)        = 1.24914E+00 ;
TOT_POWDENS               (idx, [1:   2]) = [  4.00000E-02 0.00000 ];

% Reaction rates in burnable materials :

BURN_POWER                (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
BURN_GENRATE              (idx, [1:   2]) = [  3.78906E+15 0.00003 ];
BURN_FISSRATE             (idx, [1:   2]) = [  1.54181E+15 0.00000 ];
BURN_ABSRATE              (idx, [1:   2]) = [  2.76582E+15 0.00060 ];
BURN_FLUX                 (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
BURN_FMASS                (idx, 1)        = 1.24914E+00 ;
BURN_POWDENS              (idx, [1:   2]) = [  4.00000E-02 0.00000 ];


% Point-kinetic parameters:

ANA_PROMPT_LIFETIME       (idx, [1:   2]) = [  2.26882E-05 0.00168 ];
IMPL_PROMPT_LIFETIME      (idx, [1:   2]) = [  2.27248E-05 0.00104 ];
ANA_REPROD_TIME           (idx, [1:   2]) = [  1.81957E-05 0.00190 ];
IMPL_REPROD_TIME          (idx, [1:   2]) = [  1.82960E-05 0.00092 ];
DELAYED_EMTIME            (idx, [1:   2]) = [  9.90582E+00 0.03719 ];

% Six-factor formula:

SIX_FF_ETA                (idx, [1:   2]) = [  1.73829E+00 0.00111 ];
SIX_FF_F                  (idx, [1:   2]) = [  8.79530E-01 0.00056 ];
SIX_FF_P                  (idx, [1:   2]) = [  6.66002E-01 0.00086 ];
SIX_FF_EPSILON            (idx, [1:   2]) = [  1.22497E+00 0.00087 ];
SIX_FF_LF                 (idx, [1:   2]) = [  1.00000E+00 0.00000 ];
SIX_FF_LT                 (idx, [1:   2]) = [  1.00000E+00 0.00000 ];
SIX_FF_KINF               (idx, [1:   2]) = [  1.24720E+00 0.00133 ];
SIX_FF_KEFF               (idx, [1:   2]) = [  1.24720E+00 0.00133 ];

% Delayed neutron parameters:

PRECURSOR_GROUPS          (idx, 1)        = 6 ;
BETA_EFF                  (idx, [1:  14]) = [  6.62125E-03 0.02384  1.80968E-04 0.12572  1.02856E-03 0.06261  1.03811E-03 0.06045  3.06082E-03 0.03259  9.33259E-04 0.05854  3.79531E-04 0.09593 ];
BETA_ZERO                 (idx, [1:  14]) = [  6.96400E-03 0.00057  2.03626E-04 0.00389  1.11352E-03 0.00168  1.09359E-03 0.00111  3.19306E-03 0.00055  1.01912E-03 0.00389  3.41086E-04 0.00194 ];
DECAY_CONSTANT            (idx, [1:  14]) = [  8.50800E-01 0.04997  1.24907E-02 0.00001  3.16608E-02 0.00082  1.10214E-01 0.00109  3.20020E-01 0.00082  1.34435E+00 0.00072  8.83599E+00 0.00455 ];

% Parameters for group constant generation

GC_UNI                    (idx, 1)       = 0 ;
GC_SYM                    (idx, 1)       = 8 ;
GC_NE                     (idx, 1)       = 10 ;
GC_BOUNDS                 (idx, [1: 11]) = [  1.00000E+01  1.00000E+00  1.00000E-01  1.00000E-02  1.00000E-03  1.00000E-04  1.00000E-05  1.00000E-06  1.00000E-07  1.00000E-08  1.00000E-09 ];

% Few-group cross sections:

FLUX                      (idx, [1:  22]) = [  1.41638E+17 0.00098  2.95260E+16 0.00163  3.02012E+16 0.00166  1.31207E+16 0.00166  1.04144E+16 0.00165  9.58294E+15 0.00171  8.46590E+15 0.00184  7.65122E+15 0.00168  2.43026E+16 0.00104  8.22846E+15 0.00131  1.44892E+14 0.00534 ];
LEAK                      (idx, [1:  22]) = [  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
TOTXS                     (idx, [1:  22]) = [  7.13433E-01 0.00042  2.05490E-01 0.00039  4.18013E-01 0.00025  7.17230E-01 0.00037  8.42098E-01 0.00046  8.63191E-01 0.00050  8.67360E-01 0.00047  8.68240E-01 0.00057  1.10934E+00 0.00034  1.73691E+00 0.00060  4.61004E+00 0.00393 ];
FISSXS                    (idx, [1:  22]) = [  1.08869E-02 0.00098  3.09019E-03 0.00169  2.95787E-04 0.00107  4.00622E-04 0.00155  9.73945E-04 0.00204  2.98936E-03 0.00248  7.19735E-03 0.00313  6.06637E-03 0.00401  3.00465E-02 0.00103  6.51131E-02 0.00156  1.68115E-01 0.00963 ];
CAPTXS                    (idx, [1:  22]) = [  1.06837E-02 0.00089  6.55741E-04 0.00205  8.78522E-04 0.00098  2.72688E-03 0.00170  6.44559E-03 0.00274  1.43199E-02 0.00310  2.64250E-02 0.00355  2.94332E-02 0.00422  1.87392E-02 0.00061  3.73811E-02 0.00093  1.05137E-01 0.00568 ];
ABSXS                     (idx, [1:  22]) = [  2.15706E-02 0.00077  3.74593E-03 0.00155  1.17431E-03 0.00100  3.12751E-03 0.00165  7.41953E-03 0.00248  1.73092E-02 0.00272  3.36223E-02 0.00304  3.54996E-02 0.00369  4.87858E-02 0.00086  1.02494E-01 0.00133  2.73252E-01 0.00806 ];
ELAXS                     (idx, [1:  22]) = [  6.84802E-01 0.00044  1.78596E-01 0.00041  4.06660E-01 0.00027  7.13407E-01 0.00038  8.34679E-01 0.00047  8.45881E-01 0.00051  8.33738E-01 0.00050  8.32740E-01 0.00060  1.06055E+00 0.00037  1.63441E+00 0.00066  4.33679E+00 0.00416 ];
INELAXS                   (idx, [1:  22]) = [  7.06046E-03 0.00134  2.31482E-02 0.00136  1.01789E-02 0.00120  6.95721E-04 0.00330  2.19284E-10 0.00354 -9.02353E-18 24.18056 -2.87856E-16 0.70092 -2.80339E-16 0.83497  3.37743E-16 1.69817 -3.45989E-16 1.85536 -1.47330E-15 0.20816 ];
SCATTXS                   (idx, [1:  22]) = [  6.91832E-01 0.00043  2.01600E-01 0.00039  4.16838E-01 0.00025  7.14102E-01 0.00038  8.34679E-01 0.00047  8.45881E-01 0.00051  8.33738E-01 0.00050  8.32740E-01 0.00060  1.06055E+00 0.00037  1.63441E+00 0.00066  4.33679E+00 0.00416 ];
N2NXS                     (idx, [1:  22]) = [  3.00457E-05 0.01508  1.44125E-04 0.01501  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
REMXS                     (idx, [1:  22]) = [  2.15706E-02 0.00077  7.23447E-02 0.00109  9.11554E-02 0.00090  2.00992E-01 0.00095  2.49062E-01 0.00101  2.63154E-01 0.00111  2.80263E-01 0.00103  2.80958E-01 0.00122  2.56045E-01 0.00085  6.49210E-01 0.00092  3.58578E+00 0.00419 ];
NUBAR                     (idx, [1:  22]) = [  2.45753E+00 0.00003  2.78674E+00 0.00026  2.48112E+00 0.00002  2.42836E+00 0.00000  2.43382E+00 0.00000  2.43368E+00 0.00000  2.43583E+00 0.00000  2.43666E+00 0.00000  2.43670E+00 0.00000  2.43670E+00 0.00000  2.43670E+00 0.00000 ];
NSF                       (idx, [1:  22]) = [  2.67549E-02 0.00097  8.61168E-03 0.00178  7.33885E-04 0.00107  9.72856E-04 0.00155  2.37041E-03 0.00204  7.27515E-03 0.00248  1.75315E-02 0.00313  1.47817E-02 0.00401  7.32143E-02 0.00103  1.58661E-01 0.00156  4.09645E-01 0.00963 ];
RECIPVEL                  (idx, [1:  22]) = [  4.89502E-07 0.00126  4.95628E-10 0.00034  1.23040E-09 0.00032  4.12123E-09 0.00037  1.34651E-08 0.00036  4.25356E-08 0.00040  1.34237E-07 0.00039  4.37447E-07 0.00041  1.51282E-06 0.00021  3.16585E-06 0.00027  9.46881E-06 0.00121 ];
FISSE                     (idx, [1:  22]) = [  2.02269E+02 0.00000  2.06186E+02 0.00000  2.02026E+02 0.00000  2.02024E+02 0.00000  2.02027E+02 0.00000  2.02024E+02 0.00000  2.02023E+02 0.00000  2.02022E+02 0.00000  2.02023E+02 0.00000  2.02023E+02 0.00000  2.02023E+02 0.00000 ];

% Fission spectra:

CHI                       (idx, [1:  20]) = [  6.99307E-01 0.00077  2.87705E-01 0.00195  1.25635E-02 0.01179  4.12499E-04 0.05927  1.21991E-05 0.34390  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
CHIP                      (idx, [1:  20]) = [  7.03406E-01 0.00078  2.84230E-01 0.00198  1.19885E-02 0.01218  3.66535E-04 0.06280  9.19239E-06 0.40034  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
CHID                      (idx, [1:  20]) = [  1.11674E-01 0.03865  7.84682E-01 0.00770  9.59954E-02 0.04918  7.14761E-03 0.17646  5.00970E-04 0.70770  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];

% Group-transfer probabilities and cross sections:

GTRANSFP                  (idx, [1: 200]) = [  6.60441E-01 0.00058  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  3.13680E-01 0.00123  7.84135E-01 0.00023  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.36012E-02 0.00560  1.95220E-01 0.00090  7.22923E-01 0.00029  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.05821E-03 0.01930  1.85946E-02 0.00421  2.50323E-01 0.00089  7.10501E-01 0.00034  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.93588E-04 0.05856  1.83445E-03 0.01376  2.40933E-02 0.00443  2.61208E-01 0.00092  7.09370E-01 0.00038  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.21532E-05 0.18980  1.89945E-04 0.04261  2.39385E-03 0.01506  2.55611E-02 0.00420  2.62221E-01 0.00100  7.04182E-01 0.00041  5.16320E-05 0.10766  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  3.90696E-06 0.44025  2.27793E-05 0.12352  2.40010E-04 0.04357  2.45539E-03 0.01486  2.56634E-02 0.00491  2.67516E-01 0.00112  7.05247E-01 0.00042  1.18201E-03 0.01414  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.99336E-06 0.34386  2.45273E-05 0.14578  2.51653E-04 0.04533  2.52498E-03 0.01517  2.60067E-02 0.00504  2.76268E-01 0.00110  8.04576E-01 0.00023  3.06722E-01 0.00099  2.11688E-01 0.00507  0.00000E+00 0.00000  0.00000E+00 0.00000  2.49446E-06 0.44023  2.10532E-05 0.17708  2.09614E-04 0.05025  2.19355E-03 0.01815  1.76891E-02 0.00563  1.88839E-01 0.00097  6.65499E-01 0.00044  5.52094E-01 0.00241  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.14913E-06 0.49418  1.10016E-05 0.22577  1.01890E-04 0.08088  7.43721E-04 0.03274  5.40281E-03 0.00555  2.77782E-02 0.00314  2.36218E-01 0.00501 ];
GTRANSFXS                 (idx, [1: 200]) = [  1.33145E-01 0.00073  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  6.32374E-02 0.00126  3.26857E-01 0.00031  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.75796E-03 0.00560  8.13756E-02 0.00098  5.16238E-01 0.00038  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.14994E-04 0.01936  7.75094E-03 0.00422  1.78759E-01 0.00107  5.93036E-01 0.00049  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  3.90251E-05 0.05857  7.64695E-04 0.01378  1.72054E-02 0.00448  2.18028E-01 0.00113  6.00036E-01 0.00049  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.46209E-06 0.18974  7.91676E-05 0.04260  1.70964E-03 0.01512  2.13355E-02 0.00424  2.21813E-01 0.00127  5.87097E-01 0.00050  4.29687E-05 0.10762  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  7.86112E-07 0.44027  9.49310E-06 0.12354  1.71380E-04 0.04355  2.04969E-03 0.01494  2.17096E-02 0.00504  2.23044E-01 0.00138  5.87282E-01 0.00062  1.25363E-03 0.01416  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.24862E-06 0.34386  1.74962E-05 0.14575  2.10124E-04 0.04537  2.13597E-03 0.01521  2.16832E-02 0.00509  2.30066E-01 0.00140  8.53295E-01 0.00040  5.01313E-01 0.00121  9.18348E-01 0.00698  0.00000E+00 0.00000  0.00000E+00 0.00000  1.78506E-06 0.44023  1.75632E-05 0.17714  1.77287E-04 0.05021  1.82884E-03 0.01817  1.47301E-02 0.00564  2.00275E-01 0.00110  1.08770E+00 0.00076  2.39418E+00 0.00472  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.79722E-06 0.49419  9.31684E-06 0.22586  8.49901E-05 0.08096  6.19357E-04 0.03276  5.72996E-03 0.00556  4.54030E-02 0.00331  1.02425E+00 0.00629 ];

% Diffusion parameters:

DIFFAREA                  (idx, [1:  22]) = [  5.76479E+01 0.00180  2.47206E+01 0.00278  1.21877E+01 0.00220  3.48878E+00 0.00263  2.43156E+00 0.00210  2.29700E+00 0.00218  2.15660E+00 0.00243  2.16603E+00 0.00244  1.73267E+00 0.00180  3.86288E-01 0.00210  2.52812E-02 0.00931 ];
DIFFCOEF                  (idx, [1:  22]) = [  1.24350E+00 0.00197  1.78806E+00 0.00244  1.11086E+00 0.00201  7.01090E-01 0.00224  6.05541E-01 0.00192  6.04380E-01 0.00195  6.04351E-01 0.00230  6.08443E-01 0.00210  4.43597E-01 0.00156  2.50765E-01 0.00204  9.06200E-02 0.00996 ];
TRANSPXS                  (idx, [1:  22]) = [  2.68193E-01 0.00196  1.86564E-01 0.00243  3.00225E-01 0.00201  4.75754E-01 0.00222  5.50734E-01 0.00192  5.51799E-01 0.00195  5.51935E-01 0.00231  5.48156E-01 0.00209  7.51670E-01 0.00157  1.32998E+00 0.00203  3.72575E+00 0.01001 ];
MUBAR                     (idx, [1:  22]) = [  6.43555E-01 0.00123  9.38788E-02 0.02365  2.82573E-01 0.00511  3.38136E-01 0.00448  3.49035E-01 0.00395  3.68086E-01 0.00374  3.78274E-01 0.00438  3.84320E-01 0.00395  3.37220E-01 0.00357  2.48896E-01 0.00740  2.00450E-01 0.05203 ];

% Material buckling:

MAT_BUCKLING              (idx, [1:   2]) = [  4.20048E-03 0.00307 ];

% Leakage estimate of diffusion coefficient:

LEAK_DIFFCOEF             (idx, [1:  22]) = [  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];

% PN scattering cross sections:

SCATT0                    (idx, [1:  22]) = [  7.00055E-01 0.00042  2.04052E-01 0.00037  4.21861E-01 0.00021  7.22546E-01 0.00032  8.44535E-01 0.00042  8.55422E-01 0.00047  8.43958E-01 0.00049  8.42785E-01 0.00055  1.07284E+00 0.00035  1.65452E+00 0.00068  4.38828E+00 0.00488 ];
SCATT1                    (idx, [1:  22]) = [  2.79266E-01 0.00046  8.80567E-02 0.00117  1.76744E-01 0.00084  3.42321E-01 0.00087  4.13602E-01 0.00094  4.25971E-01 0.00099  4.30173E-01 0.00105  4.11133E-01 0.00120  3.64060E-01 0.00077  3.70561E-01 0.00154  3.52672E-01 0.01990 ];
SCATT2                    (idx, [1:  22]) = [  1.00973E-01 0.00075  4.86625E-02 0.00196  6.69315E-02 0.00178  1.26795E-01 0.00206  1.53344E-01 0.00181  1.58483E-01 0.00193  1.62405E-01 0.00198  1.62847E-01 0.00202  1.14033E-01 0.00184  8.09442E-02 0.00576  3.38559E-02 0.15971 ];
SCATT3                    (idx, [1:  22]) = [  1.37873E-02 0.00469  1.51465E-02 0.00516  1.94968E-03 0.05337  2.56553E-04 0.79617 -1.20790E-04 1.93127  5.68100E-04 0.46262  3.60227E-03 0.07795  2.98007E-02 0.00903  3.99815E-02 0.00438  2.48722E-02 0.01531  2.26265E-02 0.19601 ];
SCATT4                    (idx, [1:  22]) = [ -8.99988E-03 0.00630  6.62381E-03 0.01062 -8.80668E-03 0.01058 -2.09905E-02 0.00820 -2.57039E-02 0.00868 -2.73144E-02 0.00881 -2.89473E-02 0.00911 -1.24588E-02 0.01905  9.67445E-04 0.16167 -9.83504E-03 0.03595 -1.52948E-02 0.26076 ];
SCATT5                    (idx, [1:  22]) = [  1.88742E-03 0.02379  4.98430E-03 0.01228  6.35578E-05 1.37443 -1.09602E-05 14.47485  2.30299E-04 0.91953 -1.13770E-03 0.17242 -5.42725E-03 0.03952 -9.89397E-03 0.02110  6.56947E-03 0.02068  1.04375E-02 0.02479  1.98396E-02 0.18518 ];

% P1 diffusion parameters:

P1_TRANSPXS               (idx, [1:  22]) = [  4.34167E-01 0.00054  1.17433E-01 0.00103  2.41269E-01 0.00060  3.74909E-01 0.00064  4.28496E-01 0.00080  4.37220E-01 0.00082  4.37187E-01 0.00089  4.57107E-01 0.00094  7.45280E-01 0.00048  1.36635E+00 0.00069  4.25737E+00 0.00426 ];
P1_DIFFCOEF               (idx, [1:  22]) = [  7.67783E-01 0.00054  2.83888E+00 0.00103  1.38165E+00 0.00060  8.89153E-01 0.00064  7.77979E-01 0.00080  7.62458E-01 0.00082  7.62528E-01 0.00089  7.29306E-01 0.00094  4.47272E-01 0.00048  2.43975E-01 0.00069  7.84794E-02 0.00427 ];
P1_MUBAR                  (idx, [1:  22]) = [  3.98922E-01 0.00034  4.31542E-01 0.00116  4.18961E-01 0.00077  4.73764E-01 0.00066  4.89733E-01 0.00070  4.97959E-01 0.00073  5.09700E-01 0.00077  4.87813E-01 0.00084  3.39340E-01 0.00066  2.23967E-01 0.00133  8.03863E-02 0.01958 ];

% Assembly discontinuity factors:

ADFS                      (idx, [1:  80]) = [  9.83887E-01 0.00516  9.98974E-01 0.00391  1.00638E+00 0.00474  1.00858E+00 0.00466  1.00678E+00 0.00466  1.00934E+00 0.00490  1.00111E+00 0.00464  9.62140E-01 0.00338  9.63189E-01 0.00524  1.05939E+00 0.01694  9.83887E-01 0.00516  9.98974E-01 0.00391  1.00638E+00 0.00474  1.00858E+00 0.00466  1.00678E+00 0.00466  1.00934E+00 0.00490  1.00111E+00 0.00464  9.62140E-01 0.00338  9.63189E-01 0.00524  1.05939E+00 0.01694  9.83887E-01 0.00516  9.98974E-01 0.00391  1.00638E+00 0.00474  1.00858E+00 0.00466  1.00678E+00 0.00466  1.00934E+00 0.00490  1.00111E+00 0.00464  9.62140E-01 0.00338  9.63189E-01 0.00524  1.05939E+00 0.01694  9.83887E-01 0.00516  9.98974E-01 0.00391  1.00638E+00 0.00474  1.00858E+00 0.00466  1.00678E+00 0.00466  1.00934E+00 0.00490  1.00111E+00 0.00464  9.62140E-01 0.00338  9.63189E-01 0.00524  1.05939E+00 0.01694 ];
ADFC                      (idx, [1:  80]) = [  9.47977E-01 0.05881  9.92146E-01 0.03580  9.89923E-01 0.04290  1.04081E+00 0.04149  1.03616E+00 0.03968  1.06651E+00 0.04640  9.25418E-01 0.05399  9.27123E-01 0.02467  9.47299E-01 0.03969  9.63778E-01 0.14005  9.47977E-01 0.05881  9.92146E-01 0.03580  9.89923E-01 0.04290  1.04081E+00 0.04149  1.03616E+00 0.03968  1.06651E+00 0.04640  9.25418E-01 0.05399  9.27123E-01 0.02467  9.47299E-01 0.03969  9.63778E-01 0.14005  9.47977E-01 0.05881  9.92146E-01 0.03580  9.89923E-01 0.04290  1.04081E+00 0.04149  1.03616E+00 0.03968  1.06651E+00 0.04640  9.25418E-01 0.05399  9.27123E-01 0.02467  9.47299E-01 0.03969  9.63778E-01 0.14005  9.47977E-01 0.05881  9.92146E-01 0.03580  9.89923E-01 0.04290  1.04081E+00 0.04149  1.03616E+00 0.03968  1.06651E+00 0.04640  9.25418E-01 0.05399  9.27123E-01 0.02467  9.47299E-01 0.03969  9.63778E-01 0.14005 ];

% Power distributions in lattices:

LAT10                     (idx, [1:   3]) = [ 1   17   17 ];
POWDISTR10                (idx, [1: 578]) = [  9.18058E-01 0.01801  9.17927E-01 0.01786  9.15246E-01 0.01791  9.56501E-01 0.01818  9.41978E-01 0.01694  9.39791E-01 0.01805  9.32035E-01 0.01750  9.45009E-01 0.01545  9.54488E-01 0.01734  9.91233E-01 0.01736  9.64956E-01 0.01566  9.76002E-01 0.01669  9.74098E-01 0.01673  9.40830E-01 0.01859  9.24570E-01 0.01664  9.25932E-01 0.01955  9.31077E-01 0.01697  9.50595E-01 0.01725  9.27608E-01 0.01789  9.54717E-01 0.01638  9.88289E-01 0.01761  1.00090E+00 0.01817  9.74276E-01 0.01666  9.90666E-01 0.01535  9.64554E-01 0.01726  1.02302E+00 0.01594  9.94046E-01 0.01839  9.72634E-01 0.01548  1.00797E+00 0.01765  9.76791E-01 0.01813  9.64979E-01 0.01803  9.36964E-01 0.01915  9.33595E-01 0.01675  9.31242E-01 0.01849  9.19230E-01 0.01963  9.67916E-01 0.01829  9.76255E-01 0.01707  1.04688E+00 0.01723  1.03167E+00 0.01922  0.00000E+00 0.00000  1.00657E+00 0.01670  1.05228E+00 0.01564  0.00000E+00 0.00000  1.03336E+00 0.01674  1.03085E+00 0.01722  0.00000E+00 0.00000  1.04966E+00 0.01882  1.03511E+00 0.01756  9.54606E-01 0.01790  9.55017E-01 0.01790  9.31642E-01 0.02063  9.49280E-01 0.01825  9.74221E-01 0.01693  1.01986E+00 0.01642  0.00000E+00 0.00000  1.05642E+00 0.01737  1.06070E+00 0.01689  1.01720E+00 0.01713  1.01363E+00 0.01710  1.02804E+00 0.01752  1.01108E+00 0.01702  1.03965E+00 0.01479  1.04738E+00 0.01765  1.04137E+00 0.01701  0.00000E+00 0.00000  1.02193E+00 0.01823  9.71023E-01 0.02050  9.08471E-01 0.01688  9.54398E-01 0.01677  9.80474E-01 0.01810  1.04474E+00 0.01673  1.04908E+00 0.01507  1.02809E+00 0.01693  1.07736E+00 0.01769  1.03271E+00 0.01749  9.95945E-01 0.01572  1.01009E+00 0.01953  1.00657E+00 0.01602  1.00963E+00 0.01804  1.04751E+00 0.01493  1.03356E+00 0.01852  1.06786E+00 0.01591  1.01320E+00 0.01700  9.82593E-01 0.01985  9.39648E-01 0.01791  9.58264E-01 0.01687  1.00841E+00 0.01891  0.00000E+00 0.00000  1.06345E+00 0.01654  1.05261E+00 0.01654  0.00000E+00 0.00000  1.05255E+00 0.01502  1.05909E+00 0.01714  0.00000E+00 0.00000  1.05615E+00 0.01630  1.04616E+00 0.01796  0.00000E+00 0.00000  1.01445E+00 0.01621  1.05544E+00 0.01810  0.00000E+00 0.00000  9.61688E-01 0.01753  9.59567E-01 0.01786  9.81171E-01 0.01845  1.02611E+00 0.01942  1.04239E+00 0.01637  1.05521E+00 0.01455  1.02672E+00 0.01534  1.03448E+00 0.01483  1.02923E+00 0.01674  1.04040E+00 0.01771  1.05823E+00 0.01543  1.01422E+00 0.01644  1.01915E+00 0.01752  1.06090E+00 0.01599  1.04374E+00 0.01867  1.00268E+00 0.01671  1.01196E+00 0.01740  9.64679E-01 0.01694  9.53017E-01 0.01830  9.73846E-01 0.01759  1.00178E+00 0.01850  1.00648E+00 0.01674  9.93830E-01 0.01639  1.02473E+00 0.01691  1.04925E+00 0.01610  1.03758E+00 0.01725  1.03947E+00 0.01800  1.05362E+00 0.01585  1.01783E+00 0.02002  1.04050E+00 0.01630  1.04643E+00 0.01678  1.04061E+00 0.01821  9.93264E-01 0.01648  1.01055E+00 0.01419  9.81273E-01 0.01714  9.55847E-01 0.01533  9.60151E-01 0.01861  1.00672E+00 0.01722  0.00000E+00 0.00000  1.00764E+00 0.01818  1.05251E+00 0.01686  0.00000E+00 0.00000  1.07380E+00 0.01667  1.06591E+00 0.01534  0.00000E+00 0.00000  1.05218E+00 0.01594  1.05564E+00 0.01568  0.00000E+00 0.00000  1.05815E+00 0.01704  1.02596E+00 0.01673  0.00000E+00 0.00000  1.00714E+00 0.01705  9.87381E-01 0.01693  9.39111E-01 0.01715  9.92643E-01 0.01853  1.01938E+00 0.01484  9.99808E-01 0.01670  1.01696E+00 0.01741  1.04942E+00 0.01555  1.03930E+00 0.01630  9.99291E-01 0.01676  1.03104E+00 0.01714  1.00160E+00 0.01725  1.03727E+00 0.01723  1.03243E+00 0.01765  1.01618E+00 0.01836  1.00486E+00 0.01611  1.03791E+00 0.01716  9.78258E-01 0.01646  9.58784E-01 0.01798  9.76826E-01 0.01671  9.96784E-01 0.01743  1.03449E+00 0.01806  1.01526E+00 0.01515  1.03102E+00 0.01843  1.02274E+00 0.01764  1.02486E+00 0.01897  1.05150E+00 0.01833  1.06952E+00 0.01757  1.02657E+00 0.01643  1.01919E+00 0.01885  1.02785E+00 0.01618  1.04061E+00 0.01483  1.00245E+00 0.01694  9.89226E-01 0.01912  9.49287E-01 0.01845  9.40251E-01 0.01796  9.99217E-01 0.01745  9.82735E-01 0.01692  0.00000E+00 0.00000  1.06484E+00 0.01848  1.05541E+00 0.01580  0.00000E+00 0.00000  1.05989E+00 0.01710  1.04732E+00 0.01704  0.00000E+00 0.00000  1.04962E+00 0.01516  1.04664E+00 0.01840  0.00000E+00 0.00000  1.08448E+00 0.01643  1.04035E+00 0.01708  0.00000E+00 0.00000  1.01630E+00 0.01861  9.72349E-01 0.01867  9.78707E-01 0.01737  9.54159E-01 0.02043  1.03778E+00 0.01636  1.06345E+00 0.01658  1.01921E+00 0.01918  1.01490E+00 0.01744  1.04402E+00 0.01642  1.04387E+00 0.01643  1.01777E+00 0.01741  1.02120E+00 0.01781  1.03227E+00 0.01846  1.06739E+00 0.01660  1.06148E+00 0.01610  1.05270E+00 0.01633  1.06019E+00 0.01582  9.77678E-01 0.01501  9.70827E-01 0.01771  9.43216E-01 0.01843  9.67213E-01 0.01826  1.00551E+00 0.01683  0.00000E+00 0.00000  1.03589E+00 0.01800  1.06130E+00 0.01701  1.02855E+00 0.01709  1.04522E+00 0.01631  1.07913E+00 0.01704  1.02349E+00 0.01655  1.01929E+00 0.01612  1.06107E+00 0.01793  1.01766E+00 0.01619  0.00000E+00 0.00000  9.76162E-01 0.01801  9.58398E-01 0.01613  9.52459E-01 0.01634  9.25045E-01 0.02131  9.23384E-01 0.02011  9.52038E-01 0.01780  1.00790E+00 0.01811  1.03813E+00 0.01587  0.00000E+00 0.00000  1.03348E+00 0.01534  1.04234E+00 0.01744  0.00000E+00 0.00000  1.04537E+00 0.01772  1.02128E+00 0.01828  0.00000E+00 0.00000  1.00170E+00 0.01544  9.91129E-01 0.01785  9.66917E-01 0.01787  9.79511E-01 0.01784  9.33680E-01 0.01828  9.36627E-01 0.01882  9.10466E-01 0.01859  9.58892E-01 0.01748  9.45118E-01 0.01568  9.79235E-01 0.01905  9.88349E-01 0.01705  1.00189E+00 0.01785  9.87289E-01 0.01672  1.01816E+00 0.01751  9.74986E-01 0.01629  1.00344E+00 0.01609  1.01671E+00 0.01897  9.60234E-01 0.01806  9.52630E-01 0.02021  9.52438E-01 0.01951  9.26922E-01 0.01747  9.40316E-01 0.01787  9.01934E-01 0.01969  9.35081E-01 0.01614  9.10727E-01 0.01878  9.37583E-01 0.01862  9.50799E-01 0.01546  9.59358E-01 0.01696  9.56135E-01 0.01734  9.49287E-01 0.01887  1.00369E+00 0.01801  9.59963E-01 0.01650  9.76266E-01 0.01679  9.66172E-01 0.01813  9.41443E-01 0.01446  9.50104E-01 0.01945  9.00618E-01 0.01726  9.47762E-01 0.01693  9.13889E-01 0.01880 ];
PEAKF10                   (idx, [1:   4]) = [   13   12  1.08448E+00 0.01643 ];


% Increase counter:

if (exist("idx", "var"));
  idx = idx + 1;
else;
  idx = 1;
end;

% Version, title and date:

VERSION                   (idx, [1: 13]) = 'Serpent 1.1.7' ;
TITLE                     (idx, [1: 30]) = '[CHAR] lwr2 Burnup Calculation' ;
DATE                      (idx, [1: 24]) = 'Sun May 22 22:33:50 2011' ;

% Run parameters:

POP                       (idx, 1)       = 5000 ;
CYCLES                    (idx, 1)       = 130 ;
SKIP                      (idx, 1)       = 30 ;
SEED                      (idx, 1)       = 1306121630 ;
MPI_TASKS                 (idx, 1)       = 1 ;
DEBUG                     (idx, 1)       = 0 ;
CPU_TYPE                  (idx, [1: 47]) = 'Intel(R) Core(TM) i7 CPU       M 640  @ 2.80GHz' ;
CPU_MHZ                   (idx, 1)       = 1463.0 ;
AVAIL_MEM                 (idx, 1)       = 7928.7 ;

% Delta-tracking parameters:

DT_THRESH                 (idx, 1)       = 9.00000E-01 ;
DT_FRAC                   (idx, 1)       = 9.75465E-01 ;
DT_EFF                    (idx, 1)       = 7.64290E-01 ;
MIN_MACROXS               (idx, 1)       = 1.20020E-01 ;

% Run statistics:

RUNNING_TIME              (idx, 1)       = 9.62767E+00 ;
INIT_TIME                 (idx, 1)       = 9.18017E-01 ;
TRANSPORT_CYCLE_TIME      (idx, 1)       = 7.96977E+00 ;
BURNUP_CYCLE_TIME         (idx, 1)       = 2.22500E-02 ;
PROCESS_TIME              (idx, 1)       = 7.09267E-01 ;
CYCLE_IDX                 (idx, 1)       = 130 ;
SOURCE_NEUTRONS           (idx, 1)       = 650000 ;
MEMSIZE                   (idx, 1)       = 3897.9;

% Energy grid parameters:

ERG_EMIN                  (idx, 1)        = 1.00000E-09 ;
ERG_EMAX                  (idx, 1)        = 1.00000E+01 ;
ERG_TOL                   (idx, 1)        = 5.00000E-05 ;
ERG_NE                    (idx, 1)        = 287264 ;
ERG_NE_INI                (idx, 1)        = 1167121 ;
ERG_NE_IMP                (idx, 1)        = 102321 ;
ERG_DIX                   (idx, 1)        = 0 ;

% Nuclides and reaction channels:

TOT_ISOTOPES              (idx, 1)        = 4132 ;
TOT_TRANSPORT_ISOTOPES    (idx, 1)        = 294 ;
TOT_DECAY_ISOTOPES        (idx, 1)        = 3838 ;
TOT_REA_CHANNELS          (idx, 1)        = 11719 ;

% Reaction mode counters:

COLLISIONS                (idx, 1)        = 21125045 ;
FISSION_FRACTION          (idx, 1)        = 7.80595E-03 ;
CAPTURE_FRACTION          (idx, 1)        = 2.30117E-02 ;
ELASTIC_FRACTION          (idx, 1)        = 6.11749E-01 ;
INELASTIC_FRACTION        (idx, 1)        = 1.00591E-02 ;
ALPHA_FRACTION            (idx, 1)        = 0.00000E+00 ;
BOUND_SCATTERING_FRACTION (idx, 1)        = 3.47326E-01 ;
NXN_FRACTION              (idx, 1)        = 4.84733E-05 ;
UNKNOWN_FRACTION          (idx, 1)        = 0.00000E+00 ;
VIRTUAL_FRACTION          (idx, 1)        = 2.35710E-01 ;

FREEGAS_FRACTION          (idx, 1)        = 7.05457E-01 ;
TOTAL_ELASTIC_FRACTION    (idx, 1)        = 9.59075E-01 ;
FISSILE_FISSION_FRACTION  (idx, 1)        = 8.90365E-01 ;
LEAKAGE_REACTIONS         (idx, 1)        = 0 ;

REA_SAMPLING_EFF          (idx, 1)        = 3.18452E-01 ;

% Slowing-down and thermalization:

COL_SLOW                  (idx, [1:   2]) = [  2.18888E+01 0.00043 ];
COL_THERM                 (idx, [1:   2]) = [  2.07352E+01 0.00168 ];
COL_TOT                   (idx, [1:   2]) = [  3.24516E+01 0.00079 ];
SLOW_TIME                 (idx, [1:   2]) = [  2.56124E-06 0.00125 ];
THERM_TIME                (idx, [1:   2]) = [  3.27670E-05 0.00175 ];
SLOW_DIST                 (idx, [1:   2]) = [  1.54825E+01 0.00088 ];
THERM_DIST                (idx, [1:   2]) = [  4.98395E+00 0.00119 ];
THERM_FRAC                (idx, [1:   2]) = [  6.00208E-01 0.00109 ];

% Parameters for burnup calculation:

BURN_MODE                 (idx, 1)        = 2 ;
BURN_STEP                 (idx, 1)        = 2 ;
BURN_TOT_STEPS            (idx, 1)        = 3 ;
BURNUP                    (idx, 1)        = 8.40000E+01 ;
BURN_DAYS                 (idx, 1)        = 2.10000E+03 ;
ENERGY_OUTPUT             (idx, 1)        = 9.06577E+12 ;
DEP_TTA_CUTOFF            (idx, 1)        = 1.00000E-15 ;
DEP_STABILITY_CUTOFF      (idx, 1)        = 1.00000E-22 ;
DEP_FP_YIELD_CUTOFF       (idx, 1)        = 1.00000E-22 ;
DEP_XS_FRAC_CUTOFF        (idx, 1)        = 0.00000E+00 ;
BURN_MATERIALS            (idx, 1)        = 10 ;
FP_NUCLIDES_INCLUDED      (idx, 1)        = 220 ;
FP_NUCLIDES_AVAILABLE     (idx, 1)        = 267 ;
TOT_ACTIVITY              (idx, 1)        = 9.14388E+15 ;
TOT_DECAY_HEAT            (idx, 1)        = 2.40018E+03 ;

% Fission source entropies:

ENTROPY_X                 (idx, [1:   2]) = [  9.94637E-01 0.00016 ];
ENTROPY_Y                 (idx, [1:   2]) = [  9.94516E-01 0.00016 ];
ENTROPY_Z                 (idx, [1:   2]) = [  8.62461E-18 0.36907 ];
ENTROPY_TOT               (idx, [1:   2]) = [  9.86747E-01 0.00015 ];

% Fission source centre:

SOURCE_X0                 (idx, [1:   2]) = [ -2.66668E-02 0.56483 ];
SOURCE_Y0                 (idx, [1:   2]) = [ -2.27700E-02 0.76569 ];
SOURCE_Z0                 (idx, [1:   2]) = [ -1.45284E+01 0.05374 ];

% Criticality eigenvalues:

ANA_KEFF                  (idx, [1:   2]) = [  7.25311E-01 0.00196 ];
IMP_KEFF                  (idx, [1:   2]) = [  7.26832E-01 0.00076 ];
COL_KEFF                  (idx, [1:   2]) = [  7.26588E-01 0.00134 ];
ABS_KEFF                  (idx, [1:   2]) = [  7.26832E-01 0.00076 ];
ABS_KINF                  (idx, [1:   2]) = [  7.26832E-01 0.00076 ];
ABS_GC_KEFF               (idx, [1:   2]) = [  7.26832E-01 0.00076 ];
ABS_GC_KINF               (idx, [1:   2]) = [  7.26832E-01 0.00076 ];
IMPL_ALPHA_EIG            (idx, [1:   2]) = [ -1.26302E+04 0.00276 ];
FIXED_ALPHA_EIG           (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
GEOM_ALBEDO               (idx, [1:   2]) = [  1.00000E+00 0.00000 ];

% Normalized total reaction rates:

TOT_POWER                 (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
TOT_GENRATE               (idx, [1:   2]) = [  4.28819E+15 0.00003 ];
TOT_FISSRATE              (idx, [1:   2]) = [  1.49990E+15 0.00000 ];
TOT_ABSRATE               (idx, [1:   2]) = [  5.90963E+15 0.00075 ];
TOT_LEAKRATE              (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
TOT_LOSSRATE              (idx, [1:   2]) = [  5.90963E+15 0.00075 ];
TOT_FLUX                  (idx, [1:   2]) = [  2.70243E+17 0.00109 ];
TOT_RR                    (idx, [1:   2]) = [  1.91834E+17 0.00090 ];
TOT_SOLU_ABSRATE          (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
TOT_FMASS                 (idx, 1)        = 1.24914E+00 ;
TOT_POWDENS               (idx, [1:   2]) = [  4.00000E-02 0.00000 ];

% Reaction rates in burnable materials :

BURN_POWER                (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
BURN_GENRATE              (idx, [1:   2]) = [  4.28819E+15 0.00003 ];
BURN_FISSRATE             (idx, [1:   2]) = [  1.49990E+15 0.00000 ];
BURN_ABSRATE              (idx, [1:   2]) = [  5.37744E+15 0.00081 ];
BURN_FLUX                 (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
BURN_FMASS                (idx, 1)        = 1.24914E+00 ;
BURN_POWDENS              (idx, [1:   2]) = [  4.00000E-02 0.00000 ];


% Point-kinetic parameters:

ANA_PROMPT_LIFETIME       (idx, [1:   2]) = [  2.16033E-05 0.00180 ];
IMPL_PROMPT_LIFETIME      (idx, [1:   2]) = [  2.16352E-05 0.00121 ];
ANA_REPROD_TIME           (idx, [1:   2]) = [  2.97982E-05 0.00253 ];
IMPL_REPROD_TIME          (idx, [1:   2]) = [  2.97671E-05 0.00112 ];
DELAYED_EMTIME            (idx, [1:   2]) = [  1.06397E+01 0.04203 ];

% Six-factor formula:

SIX_FF_ETA                (idx, [1:   2]) = [  1.16446E+00 0.00186 ];
SIX_FF_F                  (idx, [1:   2]) = [  8.72870E-01 0.00061 ];
SIX_FF_P                  (idx, [1:   2]) = [  5.98017E-01 0.00110 ];
SIX_FF_EPSILON            (idx, [1:   2]) = [  1.19358E+00 0.00107 ];
SIX_FF_LF                 (idx, [1:   2]) = [  1.00000E+00 0.00000 ];
SIX_FF_LT                 (idx, [1:   2]) = [  1.00000E+00 0.00000 ];
SIX_FF_KINF               (idx, [1:   2]) = [  7.25391E-01 0.00195 ];
SIX_FF_KEFF               (idx, [1:   2]) = [  7.25391E-01 0.00195 ];

% Delayed neutron parameters:

PRECURSOR_GROUPS          (idx, 1)        = 6 ;
BETA_EFF                  (idx, [1:  14]) = [  4.30013E-03 0.02675  8.68231E-05 0.21690  8.47158E-04 0.06549  6.21529E-04 0.06874  1.82956E-03 0.04469  7.26857E-04 0.06644  1.88198E-04 0.13745 ];
BETA_ZERO                 (idx, [1:  14]) = [  4.69034E-03 0.00192  9.80953E-05 0.00811  9.07375E-04 0.00603  7.10310E-04 0.00287  1.90140E-03 0.00306  8.37109E-04 0.00596  2.36050E-04 0.00739 ];
DECAY_CONSTANT            (idx, [1:  14]) = [  6.97881E-01 0.06990  1.27436E-02 0.00517  3.01657E-02 0.00094  1.12966E-01 0.00256  3.22804E-01 0.00209  1.20633E+00 0.01060  7.03299E+00 0.04975 ];

% Parameters for group constant generation

GC_UNI                    (idx, 1)       = 0 ;
GC_SYM                    (idx, 1)       = 8 ;
GC_NE                     (idx, 1)       = 10 ;
GC_BOUNDS                 (idx, [1: 11]) = [  1.00000E+01  1.00000E+00  1.00000E-01  1.00000E-02  1.00000E-03  1.00000E-04  1.00000E-05  1.00000E-06  1.00000E-07  1.00000E-08  1.00000E-09 ];

% Few-group cross sections:

FLUX                      (idx, [1:  22]) = [  2.70243E+17 0.00109  5.81313E+16 0.00199  5.85760E+16 0.00158  2.54990E+16 0.00168  2.03425E+16 0.00179  1.87199E+16 0.00150  1.64922E+16 0.00182  1.36852E+16 0.00189  4.26594E+16 0.00100  1.58488E+16 0.00169  2.89117E+14 0.00538 ];
LEAK                      (idx, [1:  22]) = [  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
TOTXS                     (idx, [1:  22]) = [  7.09886E-01 0.00050  2.06767E-01 0.00041  4.20989E-01 0.00025  7.19057E-01 0.00035  8.52178E-01 0.00047  8.79576E-01 0.00044  8.77319E-01 0.00057  9.15699E-01 0.00062  1.12535E+00 0.00032  1.68833E+00 0.00058  4.35840E+00 0.00395 ];
FISSXS                    (idx, [1:  22]) = [  5.55103E-03 0.00108  2.76958E-03 0.00164  1.04688E-04 0.00138  7.45211E-05 0.00149  1.67784E-04 0.00207  5.59520E-04 0.00230  1.99169E-03 0.00340  1.65248E-03 0.00296  2.23387E-02 0.00119  1.86048E-02 0.00158  4.78072E-02 0.00954 ];
CAPTXS                    (idx, [1:  22]) = [  1.63185E-02 0.00083  6.71107E-04 0.00239  8.65149E-04 0.00102  2.72146E-03 0.00197  6.72130E-03 0.00252  1.63578E-02 0.00315  3.18009E-02 0.00318  6.63006E-02 0.00284  3.57026E-02 0.00082  5.13587E-02 0.00110  1.35008E-01 0.00625 ];
ABSXS                     (idx, [1:  22]) = [  2.18695E-02 0.00079  3.44069E-03 0.00156  9.69837E-04 0.00102  2.79598E-03 0.00195  6.88908E-03 0.00249  1.69174E-02 0.00307  3.37926E-02 0.00303  6.79530E-02 0.00280  5.80413E-02 0.00093  6.99635E-02 0.00123  1.82815E-01 0.00708 ];
ELAXS                     (idx, [1:  22]) = [  6.80838E-01 0.00052  1.79946E-01 0.00045  4.10387E-01 0.00026  7.15609E-01 0.00036  8.45288E-01 0.00048  8.62658E-01 0.00043  8.43527E-01 0.00058  8.47746E-01 0.00064  1.06731E+00 0.00035  1.61836E+00 0.00062  4.17559E+00 0.00421 ];
INELAXS                   (idx, [1:  22]) = [  7.17838E-03 0.00132  2.33811E-02 0.00112  9.63244E-03 0.00118  6.51199E-04 0.00312  4.38537E-07 0.00537  3.38016E-12 0.00229  4.34129E-13 0.00265  4.59009E-14 0.00528  1.59043E-15 0.34627  8.30238E-16 0.71167 -9.92703E-16 0.30590 ];
SCATTXS                   (idx, [1:  22]) = [  6.87981E-01 0.00050  2.03166E-01 0.00042  4.20019E-01 0.00025  7.16261E-01 0.00036  8.45289E-01 0.00048  8.62658E-01 0.00043  8.43527E-01 0.00058  8.47746E-01 0.00064  1.06731E+00 0.00035  1.61836E+00 0.00062  4.17559E+00 0.00421 ];
N2NXS                     (idx, [1:  22]) = [  3.46399E-05 0.01472  1.61029E-04 0.01463  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
REMXS                     (idx, [1:  22]) = [  2.18695E-02 0.00079  7.15774E-02 0.00113  9.11557E-02 0.00081  2.00949E-01 0.00097  2.48012E-01 0.00107  2.62521E-01 0.00097  2.80487E-01 0.00105  3.05644E-01 0.00127  2.70056E-01 0.00091  6.08225E-01 0.00086  3.36784E+00 0.00433 ];
NUBAR                     (idx, [1:  22]) = [  2.85898E+00 0.00003  2.82857E+00 0.00026  2.82366E+00 0.00002  2.81892E+00 0.00002  2.81521E+00 0.00005  2.80913E+00 0.00006  2.83320E+00 0.00010  2.88726E+00 0.00014  2.86565E+00 0.00001  2.85793E+00 0.00001  2.86007E+00 0.00007 ];
NSF                       (idx, [1:  22]) = [  1.58703E-02 0.00108  7.83409E-03 0.00173  2.95603E-04 0.00137  2.10069E-04 0.00149  4.72347E-04 0.00206  1.57177E-03 0.00232  5.64294E-03 0.00342  4.77114E-03 0.00297  6.40148E-02 0.00119  5.31711E-02 0.00158  1.36732E-01 0.00954 ];
RECIPVEL                  (idx, [1:  22]) = [  4.72408E-07 0.00150  4.92772E-10 0.00037  1.23066E-09 0.00031  4.12641E-09 0.00037  1.34743E-08 0.00037  4.25834E-08 0.00038  1.34029E-07 0.00035  4.27101E-07 0.00043  1.52739E-06 0.00026  3.18081E-06 0.00027  9.49427E-06 0.00113 ];
FISSE                     (idx, [1:  22]) = [  2.07921E+02 0.00000  2.06749E+02 0.00000  2.06739E+02 0.00000  2.07329E+02 0.00000  2.07321E+02 0.00001  2.07304E+02 0.00001  2.07772E+02 0.00002  2.08593E+02 0.00003  2.08150E+02 0.00000  2.07854E+02 0.00000  2.07749E+02 0.00001 ];

% Fission spectra:

CHI                       (idx, [1:  20]) = [  7.04248E-01 0.00077  2.83154E-01 0.00192  1.21227E-02 0.01130  4.61819E-04 0.05333  1.39271E-05 0.32294  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
CHIP                      (idx, [1:  20]) = [  7.07026E-01 0.00077  2.80816E-01 0.00193  1.17124E-02 0.01162  4.33321E-04 0.05527  1.23851E-05 0.34393  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
CHID                      (idx, [1:  20]) = [  1.18500E-01 0.04928  7.75884E-01 0.00944  9.87283E-02 0.05705  6.56683E-03 0.22165  3.20513E-04 1.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];

% Group-transfer probabilities and cross sections:

GTRANSFP                  (idx, [1: 200]) = [  6.65420E-01 0.00053  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  3.09291E-01 0.00115  7.85282E-01 0.00021  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.30126E-02 0.00610  1.94246E-01 0.00091  7.23353E-01 0.00032  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.04561E-03 0.01853  1.84159E-02 0.00412  2.49986E-01 0.00097  7.14749E-01 0.00036  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.01799E-04 0.06176  1.84591E-03 0.01345  2.40005E-02 0.00445  2.57583E-01 0.00104  7.15298E-01 0.00032  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.38698E-05 0.17660  1.93548E-04 0.04228  2.40662E-03 0.01398  2.49523E-02 0.00421  2.56905E-01 0.00091  7.07550E-01 0.00038  6.01188E-05 0.12294  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.56908E-06 0.46508  1.62121E-05 0.14967  2.34522E-04 0.04174  2.46067E-03 0.01530  2.51367E-02 0.00503  2.64578E-01 0.00108  7.19628E-01 0.00045  1.07237E-03 0.01403  0.00000E+00 0.00000  0.00000E+00 0.00000  7.56596E-07 1.00000  3.70410E-07 1.00000  1.83953E-05 0.17263  2.33081E-04 0.04521  2.44325E-03 0.01570  2.56705E-02 0.00525  2.62772E-01 0.00127  8.01359E-01 0.00025  3.04781E-01 0.00085  2.10854E-01 0.00564  0.00000E+00 0.00000  0.00000E+00 0.00000  1.49481E-06 0.57289  2.11083E-05 0.15412  2.09172E-04 0.05405  2.09980E-03 0.01836  1.68362E-02 0.00631  1.92118E-01 0.00103  6.67403E-01 0.00040  5.51805E-01 0.00248  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  5.29008E-07 1.00000  7.92008E-06 0.27287  1.01935E-04 0.07859  7.04066E-04 0.03215  5.45043E-03 0.00573  2.78152E-02 0.00314  2.37341E-01 0.00488 ];
GTRANSFXS                 (idx, [1: 200]) = [  1.35190E-01 0.00063  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  6.28376E-02 0.00126  3.29833E-01 0.00032  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.67556E-03 0.00617  8.15873E-02 0.00096  5.18107E-01 0.00041  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.15630E-04 0.01857  7.73500E-03 0.00412  1.79057E-01 0.00110  6.04166E-01 0.00052  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.09884E-05 0.06172  7.75308E-04 0.01344  1.71908E-02 0.00449  2.17734E-01 0.00122  6.17054E-01 0.00045  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.85300E-06 0.17665  8.13084E-05 0.04235  1.72386E-03 0.01401  2.10926E-02 0.00430  2.21624E-01 0.00111  5.96833E-01 0.00061  5.10260E-05 0.12292  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  9.30158E-07 0.46491  6.80924E-06 0.14971  1.67968E-04 0.04173  2.07999E-03 0.01530  2.16853E-02 0.00512  2.23182E-01 0.00131  6.10055E-01 0.00066  1.14469E-03 0.01411  0.00000E+00 0.00000  0.00000E+00 0.00000  1.53813E-07 1.00000  1.54511E-07 1.00000  1.31732E-05 0.17265  1.97168E-04 0.04536  2.10733E-03 0.01563  2.16552E-02 0.00539  2.22768E-01 0.00153  8.55298E-01 0.00035  4.93245E-01 0.00102  8.80620E-01 0.00722  0.00000E+00 0.00000  0.00000E+00 0.00000  1.07064E-06 0.57290  1.78483E-05 0.15409  1.80422E-04 0.05401  1.77108E-03 0.01834  1.42746E-02 0.00649  2.05053E-01 0.00118  1.08010E+00 0.00074  2.30440E+00 0.00507  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.42718E-07 1.00000  6.83531E-06 0.27245  8.59758E-05 0.07861  5.96866E-04 0.03216  5.81747E-03 0.00577  4.50170E-02 0.00330  9.90567E-01 0.00586 ];

% Diffusion parameters:

DIFFAREA                  (idx, [1:  22]) = [  5.70911E+01 0.00171  2.97396E+01 0.00315  1.28548E+01 0.00225  3.49220E+00 0.00225  2.40842E+00 0.00244  2.23350E+00 0.00242  2.12693E+00 0.00213  1.87474E+00 0.00264  1.60349E+00 0.00175  4.38690E-01 0.00185  3.34069E-02 0.01047 ];
DIFFCOEF                  (idx, [1:  22]) = [  1.24852E+00 0.00176  2.12819E+00 0.00275  1.17169E+00 0.00209  7.01678E-01 0.00207  5.97278E-01 0.00247  5.86296E-01 0.00236  5.96520E-01 0.00205  5.72880E-01 0.00229  4.32988E-01 0.00150  2.66806E-01 0.00180  1.12266E-01 0.00970 ];
TRANSPXS                  (idx, [1:  22]) = [  2.67090E-01 0.00177  1.56780E-01 0.00275  2.84649E-01 0.00207  4.75312E-01 0.00205  5.58518E-01 0.00243  5.68954E-01 0.00238  5.59099E-01 0.00204  5.82246E-01 0.00227  7.70069E-01 0.00151  1.24987E+00 0.00180  3.00614E+00 0.00993 ];
MUBAR                     (idx, [1:  22]) = [  6.43597E-01 0.00116  2.46033E-01 0.00865  3.24608E-01 0.00426  3.40282E-01 0.00416  3.47350E-01 0.00502  3.60032E-01 0.00467  3.77192E-01 0.00398  3.93295E-01 0.00419  3.32857E-01 0.00350  2.70864E-01 0.00575  3.22072E-01 0.02440 ];

% Material buckling:

MAT_BUCKLING              (idx, [1:   2]) = [ -4.78666E-03 0.00269 ];

% Leakage estimate of diffusion coefficient:

LEAK_DIFFCOEF             (idx, [1:  22]) = [  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];

% PN scattering cross sections:

SCATT0                    (idx, [1:  22]) = [  6.96200E-01 0.00049  2.05643E-01 0.00039  4.25159E-01 0.00022  7.25081E-01 0.00032  8.55199E-01 0.00043  8.72817E-01 0.00041  8.53253E-01 0.00054  8.57412E-01 0.00058  1.07971E+00 0.00034  1.63764E+00 0.00066  4.20189E+00 0.00517 ];
SCATT1                    (idx, [1:  22]) = [  2.77620E-01 0.00050  8.85952E-02 0.00103  1.78024E-01 0.00081  3.43168E-01 0.00092  4.14302E-01 0.00101  4.26423E-01 0.00094  4.30934E-01 0.00121  4.18170E-01 0.00134  3.64748E-01 0.00086  3.65231E-01 0.00175  3.50996E-01 0.01946 ];
SCATT2                    (idx, [1:  22]) = [  1.00737E-01 0.00085  4.91598E-02 0.00164  6.74222E-02 0.00177  1.27094E-01 0.00211  1.53827E-01 0.00197  1.59100E-01 0.00206  1.62603E-01 0.00232  1.65270E-01 0.00221  1.13849E-01 0.00179  7.93074E-02 0.00618  2.88550E-02 0.15762 ];
SCATT3                    (idx, [1:  22]) = [  1.31761E-02 0.00495  1.53205E-02 0.00554  1.84032E-03 0.05533  7.64147E-05 3.14743  8.26952E-05 2.97354  7.51301E-04 0.35626  3.62871E-03 0.08394  2.87195E-02 0.01023  3.97239E-02 0.00504  2.44720E-02 0.01621  2.36016E-02 0.17806 ];
SCATT4                    (idx, [1:  22]) = [ -9.28118E-03 0.00617  6.68775E-03 0.01057 -9.01467E-03 0.01056 -2.10470E-02 0.00922 -2.60971E-02 0.00820 -2.71135E-02 0.00948 -2.89642E-02 0.00928 -1.38639E-02 0.02017  8.10627E-04 0.23022 -9.87237E-03 0.03499 -1.73872E-02 0.23868 ];
SCATT5                    (idx, [1:  22]) = [  1.84333E-03 0.02628  5.03989E-03 0.01475 -6.60628E-05 1.15794 -2.75728E-05 6.20962 -3.09461E-04 0.64271 -9.58126E-04 0.21150 -5.49947E-03 0.04454 -1.07338E-02 0.02266  6.98927E-03 0.02341  1.06794E-02 0.02996  1.49887E-02 0.21682 ];

% P1 diffusion parameters:

P1_TRANSPXS               (idx, [1:  22]) = [  4.32266E-01 0.00065  1.18172E-01 0.00091  2.42965E-01 0.00067  3.75888E-01 0.00066  4.37875E-01 0.00070  4.53152E-01 0.00089  4.46386E-01 0.00102  4.97530E-01 0.00096  7.60606E-01 0.00046  1.32310E+00 0.00071  4.00741E+00 0.00421 ];
P1_DIFFCOEF               (idx, [1:  22]) = [  7.71172E-01 0.00065  2.82105E+00 0.00092  1.37202E+00 0.00067  8.86838E-01 0.00066  7.61300E-01 0.00070  7.35662E-01 0.00088  7.46838E-01 0.00102  6.70057E-01 0.00096  4.38259E-01 0.00045  2.51951E-01 0.00071  8.33737E-02 0.00430 ];
P1_MUBAR                  (idx, [1:  22]) = [  3.98767E-01 0.00037  4.30822E-01 0.00100  4.18723E-01 0.00077  4.73275E-01 0.00070  4.84441E-01 0.00071  4.88554E-01 0.00074  5.05035E-01 0.00088  4.87693E-01 0.00095  3.37819E-01 0.00071  2.23017E-01 0.00149  8.35055E-02 0.01844 ];

% Assembly discontinuity factors:

ADFS                      (idx, [1:  80]) = [  9.78394E-01 0.00578  9.92237E-01 0.00349  1.01519E+00 0.00421  1.00496E+00 0.00438  9.98951E-01 0.00482  9.99841E-01 0.00542  9.99442E-01 0.00524  9.48775E-01 0.00377  9.42881E-01 0.00485  9.96749E-01 0.01543  9.78394E-01 0.00578  9.92237E-01 0.00349  1.01519E+00 0.00421  1.00496E+00 0.00438  9.98951E-01 0.00482  9.99841E-01 0.00542  9.99442E-01 0.00524  9.48775E-01 0.00377  9.42881E-01 0.00485  9.96749E-01 0.01543  9.78394E-01 0.00578  9.92237E-01 0.00349  1.01519E+00 0.00421  1.00496E+00 0.00438  9.98951E-01 0.00482  9.99841E-01 0.00542  9.99442E-01 0.00524  9.48775E-01 0.00377  9.42881E-01 0.00485  9.96749E-01 0.01543  9.78394E-01 0.00578  9.92237E-01 0.00349  1.01519E+00 0.00421  1.00496E+00 0.00438  9.98951E-01 0.00482  9.99841E-01 0.00542  9.99442E-01 0.00524  9.48775E-01 0.00377  9.42881E-01 0.00485  9.96749E-01 0.01543 ];
ADFC                      (idx, [1:  80]) = [  9.65148E-01 0.05555  9.40868E-01 0.03786  1.01257E+00 0.03876  1.03125E+00 0.03653  9.89423E-01 0.04518  9.78207E-01 0.05065  1.02313E+00 0.05011  9.08921E-01 0.02769  9.50537E-01 0.03968  1.03306E+00 0.15455  9.65148E-01 0.05555  9.40868E-01 0.03786  1.01257E+00 0.03876  1.03125E+00 0.03653  9.89423E-01 0.04518  9.78207E-01 0.05065  1.02313E+00 0.05011  9.08921E-01 0.02769  9.50537E-01 0.03968  1.03306E+00 0.15455  9.65148E-01 0.05555  9.40868E-01 0.03786  1.01257E+00 0.03876  1.03125E+00 0.03653  9.89423E-01 0.04518  9.78207E-01 0.05065  1.02313E+00 0.05011  9.08921E-01 0.02769  9.50537E-01 0.03968  1.03306E+00 0.15455  9.65148E-01 0.05555  9.40868E-01 0.03786  1.01257E+00 0.03876  1.03125E+00 0.03653  9.89423E-01 0.04518  9.78207E-01 0.05065  1.02313E+00 0.05011  9.08921E-01 0.02769  9.50537E-01 0.03968  1.03306E+00 0.15455 ];

% Power distributions in lattices:

LAT10                     (idx, [1:   3]) = [ 1   17   17 ];
POWDISTR10                (idx, [1: 578]) = [  8.97229E-01 0.02117  9.15678E-01 0.01862  9.21606E-01 0.02018  9.43692E-01 0.01810  9.53834E-01 0.01940  9.90602E-01 0.02183  9.93920E-01 0.02124  9.81486E-01 0.01718  1.00062E+00 0.01999  9.44808E-01 0.01916  9.51681E-01 0.02002  9.73312E-01 0.02097  9.58019E-01 0.01842  9.58477E-01 0.01764  9.09671E-01 0.01860  9.48805E-01 0.01709  9.10611E-01 0.01774  8.80375E-01 0.01971  9.31912E-01 0.01971  9.58145E-01 0.01816  9.64066E-01 0.02038  9.74332E-01 0.01964  1.01778E+00 0.01918  9.60992E-01 0.01992  1.00820E+00 0.01827  1.01550E+00 0.01923  1.00355E+00 0.01972  1.00899E+00 0.02126  1.00854E+00 0.02092  9.80457E-01 0.01994  9.78292E-01 0.01987  9.25296E-01 0.02160  9.10007E-01 0.01797  9.09273E-01 0.02061  9.35204E-01 0.02142  9.55156E-01 0.02156  9.49421E-01 0.01864  1.01132E+00 0.01811  1.04291E+00 0.01672  0.00000E+00 0.00000  9.98367E-01 0.01987  1.03703E+00 0.01944  0.00000E+00 0.00000  1.04320E+00 0.01982  1.02454E+00 0.01769  0.00000E+00 0.00000  1.02824E+00 0.01816  1.01301E+00 0.01768  9.22270E-01 0.01968  9.34398E-01 0.02133  9.10188E-01 0.02120  9.52382E-01 0.01900  9.54444E-01 0.01995  9.90880E-01 0.01707  0.00000E+00 0.00000  1.02993E+00 0.01688  1.03544E+00 0.01885  1.00534E+00 0.01978  1.01241E+00 0.01810  1.07321E+00 0.02169  1.03435E+00 0.01807  1.03248E+00 0.01748  1.05826E+00 0.01868  1.06452E+00 0.01835  0.00000E+00 0.00000  1.00795E+00 0.01902  9.88966E-01 0.01807  9.50904E-01 0.01827  9.48779E-01 0.01930  9.99469E-01 0.01891  1.02396E+00 0.01907  1.05841E+00 0.01790  1.02740E+00 0.01917  1.05621E+00 0.01715  1.03633E+00 0.01534  1.02359E+00 0.01779  1.01262E+00 0.01900  1.00392E+00 0.01706  1.03896E+00 0.01879  1.07065E+00 0.01871  1.04067E+00 0.01901  1.04960E+00 0.01889  9.99296E-01 0.01724  9.99242E-01 0.01923  9.59464E-01 0.02151  9.35830E-01 0.02296  9.91002E-01 0.01934  0.00000E+00 0.00000  1.06956E+00 0.01759  1.07962E+00 0.01789  0.00000E+00 0.00000  1.04772E+00 0.01940  1.04999E+00 0.02089  0.00000E+00 0.00000  1.03500E+00 0.01928  1.07530E+00 0.02080  0.00000E+00 0.00000  1.04723E+00 0.01652  1.03533E+00 0.01766  0.00000E+00 0.00000  1.02363E+00 0.01684  9.66145E-01 0.01987  9.41222E-01 0.01897  1.02517E+00 0.02017  9.66599E-01 0.01722  1.02975E+00 0.02050  9.93812E-01 0.01768  1.03695E+00 0.01859  1.04895E+00 0.01880  9.81537E-01 0.01922  1.03960E+00 0.01818  1.06396E+00 0.02020  1.03968E+00 0.01910  1.07606E+00 0.01931  1.07970E+00 0.01763  1.05972E+00 0.01877  1.03795E+00 0.01829  9.81455E-01 0.01771  9.82924E-01 0.01937  9.55037E-01 0.01868  9.94284E-01 0.01686  9.92678E-01 0.01742  1.03271E+00 0.01866  1.00995E+00 0.01716  1.05886E+00 0.01903  1.04542E+00 0.01869  1.02600E+00 0.01954  1.05380E+00 0.01701  1.06413E+00 0.01705  1.02887E+00 0.01775  1.06865E+00 0.01696  1.04918E+00 0.01807  1.01303E+00 0.01872  1.02375E+00 0.01768  9.87944E-01 0.01838  9.76870E-01 0.01795  9.68284E-01 0.01928  9.82697E-01 0.01841  0.00000E+00 0.00000  1.06298E+00 0.01797  1.03175E+00 0.01888  0.00000E+00 0.00000  1.04119E+00 0.01977  1.06128E+00 0.01720  0.00000E+00 0.00000  1.07213E+00 0.01875  1.04490E+00 0.01864  0.00000E+00 0.00000  1.07699E+00 0.01912  1.03332E+00 0.01920  0.00000E+00 0.00000  9.93655E-01 0.02193  9.62109E-01 0.01791  9.67540E-01 0.01972  1.03660E+00 0.01817  1.00352E+00 0.01719  1.02980E+00 0.01732  1.01839E+00 0.01766  1.03683E+00 0.01774  1.02734E+00 0.01954  1.03511E+00 0.01983  1.03901E+00 0.01883  1.05620E+00 0.02072  1.03922E+00 0.01901  1.05697E+00 0.01986  1.04769E+00 0.01797  1.01110E+00 0.01708  1.02454E+00 0.01835  1.01810E+00 0.01976  9.32592E-01 0.01863  9.31219E-01 0.01979  9.65540E-01 0.01956  1.03589E+00 0.01927  9.93716E-01 0.01901  1.04710E+00 0.01819  1.04020E+00 0.01898  1.05882E+00 0.01579  1.04807E+00 0.01838  1.04544E+00 0.01991  1.04214E+00 0.01819  1.01529E+00 0.01857  1.04291E+00 0.02016  1.00124E+00 0.01714  1.00304E+00 0.01901  1.05884E+00 0.02018  9.81391E-01 0.01860  9.35481E-01 0.01950  9.66251E-01 0.01986  1.00110E+00 0.01853  0.00000E+00 0.00000  1.03538E+00 0.02037  1.04997E+00 0.01769  0.00000E+00 0.00000  1.04312E+00 0.02190  1.06692E+00 0.01871  0.00000E+00 0.00000  1.06324E+00 0.01880  1.06283E+00 0.01704  0.00000E+00 0.00000  1.03961E+00 0.01848  1.03045E+00 0.01681  0.00000E+00 0.00000  9.88754E-01 0.02027  9.42940E-01 0.01843  8.99444E-01 0.01970  9.85901E-01 0.01854  1.01578E+00 0.01876  1.03587E+00 0.01760  1.01953E+00 0.01929  1.06125E+00 0.01936  1.03195E+00 0.01934  1.04237E+00 0.01699  1.03142E+00 0.02017  1.03341E+00 0.01622  1.03183E+00 0.01815  1.05016E+00 0.01919  1.02534E+00 0.01720  1.06276E+00 0.01885  1.01612E+00 0.01755  9.50124E-01 0.01723  9.51555E-01 0.01808  9.63261E-01 0.01924  9.42324E-01 0.01951  9.96995E-01 0.01725  0.00000E+00 0.00000  1.07986E+00 0.01784  1.07755E+00 0.01740  1.03026E+00 0.01593  1.05109E+00 0.02171  1.06190E+00 0.01739  1.01618E+00 0.02112  1.01747E+00 0.01925  1.05310E+00 0.01893  1.00504E+00 0.01721  0.00000E+00 0.00000  9.84468E-01 0.01837  9.64765E-01 0.01842  8.94215E-01 0.01933  8.91167E-01 0.02007  9.41410E-01 0.01961  9.64144E-01 0.02103  1.02242E+00 0.01897  1.06145E+00 0.01806  0.00000E+00 0.00000  1.04406E+00 0.01847  1.03531E+00 0.01995  0.00000E+00 0.00000  1.04491E+00 0.01703  1.04951E+00 0.01804  0.00000E+00 0.00000  1.02098E+00 0.01956  9.99175E-01 0.02026  1.01816E+00 0.01752  9.33684E-01 0.01987  9.34530E-01 0.01923  9.05519E-01 0.02049  9.12799E-01 0.01789  9.37522E-01 0.01826  9.51092E-01 0.01778  9.83064E-01 0.01798  1.00459E+00 0.01772  1.00932E+00 0.02032  9.69780E-01 0.02029  1.02236E+00 0.01935  9.86035E-01 0.01845  9.77297E-01 0.01973  1.02828E+00 0.01679  9.69187E-01 0.01983  9.27193E-01 0.01996  9.52238E-01 0.01785  9.02719E-01 0.01909  9.27327E-01 0.01968  8.88911E-01 0.02011  8.94636E-01 0.01914  9.30833E-01 0.02048  9.47173E-01 0.01776  9.56790E-01 0.01858  9.50430E-01 0.01694  9.57748E-01 0.02251  9.84889E-01 0.01734  9.62458E-01 0.02006  9.95697E-01 0.01914  9.77540E-01 0.01938  9.35570E-01 0.01873  9.40197E-01 0.01908  8.96806E-01 0.01977  9.47153E-01 0.01758  9.01059E-01 0.01972  9.15306E-01 0.01913 ];
PEAKF10                   (idx, [1:   4]) = [    5   14  1.07986E+00 0.01784 ];


% Increase counter:

if (exist("idx", "var"));
  idx = idx + 1;
else;
  idx = 1;
end;

% Version, title and date:

VERSION                   (idx, [1: 13]) = 'Serpent 1.1.7' ;
TITLE                     (idx, [1: 30]) = '[CHAR] lwr2 Burnup Calculation' ;
DATE                      (idx, [1: 24]) = 'Sun May 22 22:33:50 2011' ;

% Run parameters:

POP                       (idx, 1)       = 5000 ;
CYCLES                    (idx, 1)       = 130 ;
SKIP                      (idx, 1)       = 30 ;
SEED                      (idx, 1)       = 1306121630 ;
MPI_TASKS                 (idx, 1)       = 1 ;
DEBUG                     (idx, 1)       = 0 ;
CPU_TYPE                  (idx, [1: 47]) = 'Intel(R) Core(TM) i7 CPU       M 640  @ 2.80GHz' ;
CPU_MHZ                   (idx, 1)       = 1463.0 ;
AVAIL_MEM                 (idx, 1)       = 7928.7 ;

% Delta-tracking parameters:

DT_THRESH                 (idx, 1)       = 9.00000E-01 ;
DT_FRAC                   (idx, 1)       = 9.75282E-01 ;
DT_EFF                    (idx, 1)       = 7.58682E-01 ;
MIN_MACROXS               (idx, 1)       = 1.20020E-01 ;

% Run statistics:

RUNNING_TIME              (idx, 1)       = 1.55383E+01 ;
INIT_TIME                 (idx, 1)       = 9.18017E-01 ;
TRANSPORT_CYCLE_TIME      (idx, 1)       = 1.32083E+01 ;
BURNUP_CYCLE_TIME         (idx, 1)       = 4.44333E-02 ;
PROCESS_TIME              (idx, 1)       = 1.35057E+00 ;
CYCLE_IDX                 (idx, 1)       = 130 ;
SOURCE_NEUTRONS           (idx, 1)       = 650000 ;
MEMSIZE                   (idx, 1)       = 3897.9;

% Energy grid parameters:

ERG_EMIN                  (idx, 1)        = 1.00000E-09 ;
ERG_EMAX                  (idx, 1)        = 1.00000E+01 ;
ERG_TOL                   (idx, 1)        = 5.00000E-05 ;
ERG_NE                    (idx, 1)        = 287264 ;
ERG_NE_INI                (idx, 1)        = 1167121 ;
ERG_NE_IMP                (idx, 1)        = 102321 ;
ERG_DIX                   (idx, 1)        = 0 ;

% Nuclides and reaction channels:

TOT_ISOTOPES              (idx, 1)        = 4132 ;
TOT_TRANSPORT_ISOTOPES    (idx, 1)        = 294 ;
TOT_DECAY_ISOTOPES        (idx, 1)        = 3838 ;
TOT_REA_CHANNELS          (idx, 1)        = 11719 ;

% Reaction mode counters:

COLLISIONS                (idx, 1)        = 20603913 ;
FISSION_FRACTION          (idx, 1)        = 7.11015E-03 ;
CAPTURE_FRACTION          (idx, 1)        = 2.44861E-02 ;
ELASTIC_FRACTION          (idx, 1)        = 6.26295E-01 ;
INELASTIC_FRACTION        (idx, 1)        = 1.02010E-02 ;
ALPHA_FRACTION            (idx, 1)        = 0.00000E+00 ;
BOUND_SCATTERING_FRACTION (idx, 1)        = 3.31859E-01 ;
NXN_FRACTION              (idx, 1)        = 4.88257E-05 ;
UNKNOWN_FRACTION          (idx, 1)        = 0.00000E+00 ;
VIRTUAL_FRACTION          (idx, 1)        = 2.41318E-01 ;

FREEGAS_FRACTION          (idx, 1)        = 6.97351E-01 ;
TOTAL_ELASTIC_FRACTION    (idx, 1)        = 9.58154E-01 ;
FISSILE_FISSION_FRACTION  (idx, 1)        = 8.86045E-01 ;
LEAKAGE_REACTIONS         (idx, 1)        = 0 ;

REA_SAMPLING_EFF          (idx, 1)        = 3.19878E-01 ;

% Slowing-down and thermalization:

COL_SLOW                  (idx, [1:   2]) = [  2.19424E+01 0.00051 ];
COL_THERM                 (idx, [1:   2]) = [  2.02742E+01 0.00163 ];
COL_TOT                   (idx, [1:   2]) = [  3.16518E+01 0.00083 ];
SLOW_TIME                 (idx, [1:   2]) = [  2.48288E-06 0.00120 ];
THERM_TIME                (idx, [1:   2]) = [  3.19051E-05 0.00171 ];
SLOW_DIST                 (idx, [1:   2]) = [  1.54005E+01 0.00099 ];
THERM_DIST                (idx, [1:   2]) = [  4.92184E+00 0.00117 ];
THERM_FRAC                (idx, [1:   2]) = [  5.71634E-01 0.00111 ];

% Parameters for burnup calculation:

BURN_MODE                 (idx, 1)        = 2 ;
BURN_STEP                 (idx, 1)        = 3 ;
BURN_TOT_STEPS            (idx, 1)        = 3 ;
BURNUP                    (idx, 1)        = 1.68000E+02 ;
BURN_DAYS                 (idx, 1)        = 4.20000E+03 ;
ENERGY_OUTPUT             (idx, 1)        = 1.81315E+13 ;
DEP_TTA_CUTOFF            (idx, 1)        = 1.00000E-15 ;
DEP_STABILITY_CUTOFF      (idx, 1)        = 1.00000E-22 ;
DEP_FP_YIELD_CUTOFF       (idx, 1)        = 1.00000E-22 ;
DEP_XS_FRAC_CUTOFF        (idx, 1)        = 0.00000E+00 ;
BURN_MATERIALS            (idx, 1)        = 10 ;
FP_NUCLIDES_INCLUDED      (idx, 1)        = 220 ;
FP_NUCLIDES_AVAILABLE     (idx, 1)        = 267 ;
TOT_ACTIVITY              (idx, 1)        = 1.20241E+16 ;
TOT_DECAY_HEAT            (idx, 1)        = 3.11114E+03 ;

% Fission source entropies:

ENTROPY_X                 (idx, [1:   2]) = [  9.94191E-01 0.00016 ];
ENTROPY_Y                 (idx, [1:   2]) = [  9.94395E-01 0.00017 ];
ENTROPY_Z                 (idx, [1:   2]) = [  6.16044E-18 0.44023 ];
ENTROPY_TOT               (idx, [1:   2]) = [  9.85541E-01 0.00016 ];

% Fission source centre:

SOURCE_X0                 (idx, [1:   2]) = [  1.50330E-02 1.27952 ];
SOURCE_Y0                 (idx, [1:   2]) = [ -2.35708E-02 0.68541 ];
SOURCE_Z0                 (idx, [1:   2]) = [  6.21033E+00 0.15594 ];

% Criticality eigenvalues:

ANA_KEFF                  (idx, [1:   2]) = [  6.56265E-01 0.00234 ];
IMP_KEFF                  (idx, [1:   2]) = [  6.58625E-01 0.00080 ];
COL_KEFF                  (idx, [1:   2]) = [  6.59713E-01 0.00156 ];
ABS_KEFF                  (idx, [1:   2]) = [  6.58625E-01 0.00080 ];
ABS_KINF                  (idx, [1:   2]) = [  6.58625E-01 0.00080 ];
ABS_GC_KEFF               (idx, [1:   2]) = [  6.58625E-01 0.00080 ];
ABS_GC_KINF               (idx, [1:   2]) = [  6.58625E-01 0.00080 ];
IMPL_ALPHA_EIG            (idx, [1:   2]) = [ -1.69958E+04 0.00243 ];
FIXED_ALPHA_EIG           (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
GEOM_ALBEDO               (idx, [1:   2]) = [  1.00000E+00 0.00000 ];

% Normalized total reaction rates:

TOT_POWER                 (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
TOT_GENRATE               (idx, [1:   2]) = [  4.35876E+15 0.00003 ];
TOT_FISSRATE              (idx, [1:   2]) = [  1.49674E+15 0.00000 ];
TOT_ABSRATE               (idx, [1:   2]) = [  6.62839E+15 0.00080 ];
TOT_LEAKRATE              (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
TOT_LOSSRATE              (idx, [1:   2]) = [  6.62839E+15 0.00080 ];
TOT_FLUX                  (idx, [1:   2]) = [  2.97326E+17 0.00127 ];
TOT_RR                    (idx, [1:   2]) = [  2.09472E+17 0.00109 ];
TOT_SOLU_ABSRATE          (idx, [1:   2]) = [  0.00000E+00 0.00000 ];
TOT_FMASS                 (idx, 1)        = 1.24914E+00 ;
TOT_POWDENS               (idx, [1:   2]) = [  4.00000E-02 0.00000 ];

% Reaction rates in burnable materials :

BURN_POWER                (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
BURN_GENRATE              (idx, [1:   2]) = [  4.35876E+15 0.00003 ];
BURN_FISSRATE             (idx, [1:   2]) = [  1.49674E+15 0.00000 ];
BURN_ABSRATE              (idx, [1:   2]) = [  6.07095E+15 0.00085 ];
BURN_FLUX                 (idx, [1:   2]) = [  4.99657E+04 0.00000 ];
BURN_FMASS                (idx, 1)        = 1.24914E+00 ;
BURN_POWDENS              (idx, [1:   2]) = [  4.00000E-02 0.00000 ];


% Point-kinetic parameters:

ANA_PROMPT_LIFETIME       (idx, [1:   2]) = [  2.00957E-05 0.00192 ];
IMPL_PROMPT_LIFETIME      (idx, [1:   2]) = [  2.00924E-05 0.00127 ];
ANA_REPROD_TIME           (idx, [1:   2]) = [  3.06410E-05 0.00287 ];
IMPL_REPROD_TIME          (idx, [1:   2]) = [  3.05073E-05 0.00114 ];
DELAYED_EMTIME            (idx, [1:   2]) = [  1.11406E+01 0.04497 ];

% Six-factor formula:

SIX_FF_ETA                (idx, [1:   2]) = [  1.09954E+00 0.00247 ];
SIX_FF_F                  (idx, [1:   2]) = [  8.75202E-01 0.00055 ];
SIX_FF_P                  (idx, [1:   2]) = [  5.69223E-01 0.00112 ];
SIX_FF_EPSILON            (idx, [1:   2]) = [  1.19851E+00 0.00104 ];
SIX_FF_LF                 (idx, [1:   2]) = [  1.00000E+00 0.00000 ];
SIX_FF_LT                 (idx, [1:   2]) = [  1.00000E+00 0.00000 ];
SIX_FF_KINF               (idx, [1:   2]) = [  6.56368E-01 0.00233 ];
SIX_FF_KEFF               (idx, [1:   2]) = [  6.56368E-01 0.00233 ];

% Delayed neutron parameters:

PRECURSOR_GROUPS          (idx, 1)        = 6 ;
BETA_EFF                  (idx, [1:  14]) = [  4.06599E-03 0.03121  7.90550E-05 0.20949  8.08496E-04 0.07466  5.66737E-04 0.07721  1.76922E-03 0.05065  6.67212E-04 0.06360  1.75265E-04 0.15357 ];
BETA_ZERO                 (idx, [1:  14]) = [  4.45601E-03 0.00239  8.96438E-05 0.00937  8.82836E-04 0.00670  6.73605E-04 0.00379  1.77401E-03 0.00343  8.10493E-04 0.00669  2.25422E-04 0.00901 ];
DECAY_CONSTANT            (idx, [1:  14]) = [  6.46505E-01 0.07224  1.28536E-02 0.00618  3.00819E-02 0.00061  1.12589E-01 0.00288  3.23412E-01 0.00220  1.14971E+00 0.01310  6.99459E+00 0.05045 ];

% Parameters for group constant generation

GC_UNI                    (idx, 1)       = 0 ;
GC_SYM                    (idx, 1)       = 8 ;
GC_NE                     (idx, 1)       = 10 ;
GC_BOUNDS                 (idx, [1: 11]) = [  1.00000E+01  1.00000E+00  1.00000E-01  1.00000E-02  1.00000E-03  1.00000E-04  1.00000E-05  1.00000E-06  1.00000E-07  1.00000E-08  1.00000E-09 ];

% Few-group cross sections:

FLUX                      (idx, [1:  22]) = [  2.97326E+17 0.00127  6.54236E+16 0.00194  6.57887E+16 0.00182  2.85693E+16 0.00199  2.27712E+16 0.00193  2.08276E+16 0.00196  1.81329E+16 0.00171  1.46630E+16 0.00181  4.44259E+16 0.00110  1.64220E+16 0.00166  3.01429E+14 0.00581 ];
LEAK                      (idx, [1:  22]) = [  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
TOTXS                     (idx, [1:  22]) = [  7.04549E-01 0.00043  2.08963E-01 0.00040  4.23850E-01 0.00022  7.21046E-01 0.00036  8.61561E-01 0.00050  8.97011E-01 0.00047  8.85900E-01 0.00051  9.31353E-01 0.00059  1.12967E+00 0.00035  1.69275E+00 0.00063  4.37006E+00 0.00421 ];
FISSXS                    (idx, [1:  22]) = [  5.03505E-03 0.00127  2.52983E-03 0.00168  1.02689E-04 0.00145  6.46054E-05 0.00167  1.43784E-04 0.00177  4.79092E-04 0.00240  1.77834E-03 0.00323  1.62049E-03 0.00270  2.14742E-02 0.00126  1.74219E-02 0.00183  4.44771E-02 0.01034 ];
CAPTXS                    (idx, [1:  22]) = [  1.72607E-02 0.00082  6.69475E-04 0.00217  8.60716E-04 0.00106  2.71307E-03 0.00174  6.98548E-03 0.00240  1.83945E-02 0.00250  3.59527E-02 0.00269  7.52539E-02 0.00246  3.83517E-02 0.00092  5.53522E-02 0.00132  1.44042E-01 0.00716 ];
ABSXS                     (idx, [1:  22]) = [  2.22958E-02 0.00084  3.19930E-03 0.00153  9.63404E-04 0.00106  2.77768E-03 0.00173  7.12927E-03 0.00237  1.88736E-02 0.00245  3.77311E-02 0.00258  7.68743E-02 0.00242  5.98259E-02 0.00099  7.27741E-02 0.00144  1.88519E-01 0.00789 ];
ELAXS                     (idx, [1:  22]) = [  6.75034E-01 0.00044  1.82285E-01 0.00044  4.13869E-01 0.00023  7.17675E-01 0.00036  8.54432E-01 0.00051  8.78138E-01 0.00048  8.48169E-01 0.00049  8.54479E-01 0.00059  1.06984E+00 0.00040  1.61997E+00 0.00069  4.18154E+00 0.00448 ];
INELAXS                   (idx, [1:  22]) = [  7.21853E-03 0.00115  2.34794E-02 0.00122  9.01777E-03 0.00118  5.93486E-04 0.00334  4.71249E-07 0.00616  3.60592E-12 0.00221  4.64090E-13 0.00222  4.97477E-14 0.00514  1.11027E-15 0.45263 -4.07959E-16 1.46463 -1.06202E-15 0.31087 ];
SCATTXS                   (idx, [1:  22]) = [  6.82220E-01 0.00043  2.05613E-01 0.00040  4.22886E-01 0.00022  7.18269E-01 0.00036  8.54432E-01 0.00051  8.78138E-01 0.00048  8.48169E-01 0.00049  8.54479E-01 0.00059  1.06984E+00 0.00040  1.61997E+00 0.00069  4.18154E+00 0.00448 ];
N2NXS                     (idx, [1:  22]) = [  3.32065E-05 0.01313  1.50905E-04 0.01305  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
REMXS                     (idx, [1:  22]) = [  2.22958E-02 0.00084  7.13127E-02 0.00113  9.09827E-02 0.00093  2.01301E-01 0.00097  2.48511E-01 0.00102  2.64753E-01 0.00108  2.84670E-01 0.00098  3.13730E-01 0.00114  2.71842E-01 0.00083  6.12216E-01 0.00098  3.37371E+00 0.00444 ];
NUBAR                     (idx, [1:  22]) = [  2.91217E+00 0.00003  2.84893E+00 0.00025  2.96452E+00 0.00002  2.95017E+00 0.00002  2.95821E+00 0.00004  2.93929E+00 0.00006  2.92228E+00 0.00007  3.03836E+00 0.00014  2.89966E+00 0.00001  2.97169E+00 0.00001  3.00122E+00 0.00005 ];
NSF                       (idx, [1:  22]) = [  1.46629E-02 0.00127  7.20740E-03 0.00175  3.04423E-04 0.00145  1.90597E-04 0.00167  4.25344E-04 0.00177  1.40818E-03 0.00237  5.19675E-03 0.00320  4.92361E-03 0.00269  6.22677E-02 0.00125  5.17725E-02 0.00183  1.33485E-01 0.01033 ];
RECIPVEL                  (idx, [1:  22]) = [  4.47305E-07 0.00148  4.92918E-10 0.00034  1.23060E-09 0.00030  4.12430E-09 0.00037  1.34695E-08 0.00040  4.25276E-08 0.00037  1.34002E-07 0.00039  4.24422E-07 0.00038  1.52632E-06 0.00024  3.18044E-06 0.00028  9.48726E-06 0.00109 ];
FISSE                     (idx, [1:  22]) = [  2.08360E+02 0.00000  2.06902E+02 0.00000  2.08151E+02 0.00000  2.08612E+02 0.00000  2.08708E+02 0.00000  2.08598E+02 0.00001  2.08666E+02 0.00002  2.09527E+02 0.00001  2.08457E+02 0.00000  2.08723E+02 0.00000  2.08742E+02 0.00000 ];

% Fission spectra:

CHI                       (idx, [1:  20]) = [  7.05104E-01 0.00089  2.82069E-01 0.00210  1.24051E-02 0.01159  4.13465E-04 0.06369  9.14142E-06 0.40063  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
CHIP                      (idx, [1:  20]) = [  7.07668E-01 0.00087  2.79921E-01 0.00209  1.20200E-02 0.01181  3.83097E-04 0.06701  7.61486E-06 0.44068  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];
CHID                      (idx, [1:  20]) = [  1.14642E-01 0.05245  7.76896E-01 0.00971  1.00839E-01 0.05319  7.23872E-03 0.22590  3.84615E-04 1.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];

% Group-transfer probabilities and cross sections:

GTRANSFP                  (idx, [1: 200]) = [  6.69463E-01 0.00057  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  3.05150E-01 0.00132  7.87132E-01 0.00024  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.30891E-02 0.00558  1.92527E-01 0.00096  7.23611E-01 0.00032  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  2.08240E-03 0.01819  1.82508E-02 0.00429  2.49515E-01 0.00090  7.17498E-01 0.00032  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.96708E-04 0.06678  1.87970E-03 0.01383  2.42312E-02 0.00439  2.55052E-01 0.00093  7.20004E-01 0.00038  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.80392E-05 0.22682  1.84250E-04 0.04386  2.37842E-03 0.01253  2.47677E-02 0.00439  2.52842E-01 0.00099  7.08860E-01 0.00038  5.19961E-05 0.11983  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  7.39645E-07 1.00000  2.37257E-05 0.12765  2.31933E-04 0.04819  2.43601E-03 0.01425  2.44835E-02 0.00496  2.63328E-01 0.00099  7.22813E-01 0.00046  1.03680E-03 0.01238  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.82051E-06 0.44024  3.01533E-05 0.13990  2.25767E-04 0.04246  2.47167E-03 0.01492  2.56094E-02 0.00447  2.59509E-01 0.00122  8.01828E-01 0.00024  3.05016E-01 0.00102  2.09523E-01 0.00564  0.00000E+00 0.00000  0.00000E+00 0.00000  2.47344E-06 0.44025  2.08553E-05 0.16957  1.88582E-04 0.04996  2.12804E-03 0.01955  1.69378E-02 0.00647  1.91665E-01 0.00098  6.67006E-01 0.00046  5.52179E-01 0.00256  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.06286E-05 0.24965  7.47366E-05 0.09363  6.88734E-04 0.03376  5.47032E-03 0.00551  2.79779E-02 0.00376  2.38298E-01 0.00502 ];
GTRANSFXS                 (idx, [1: 200]) = [  1.37651E-01 0.00072  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  6.27424E-02 0.00133  3.32867E-01 0.00030  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.74756E-03 0.00564  8.14176E-02 0.00102  5.19745E-01 0.00041  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.28176E-04 0.01820  7.71805E-03 0.00430  1.79221E-01 0.00106  6.13050E-01 0.00053  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  4.04520E-05 0.06679  7.94898E-04 0.01384  1.74048E-02 0.00443  2.17926E-01 0.00112  6.32258E-01 0.00051  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  3.71093E-06 0.22686  7.79174E-05 0.04386  1.70826E-03 0.01251  2.11632E-02 0.00449  2.22034E-01 0.00124  6.01230E-01 0.00057  4.44137E-05 0.11981  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  1.51961E-07 1.00000  1.00338E-05 0.12763  1.66555E-04 0.04816  2.08161E-03 0.01430  2.15001E-02 0.00500  2.23349E-01 0.00117  6.17623E-01 0.00066  1.10920E-03 0.01237  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  7.69000E-07 0.44024  2.16583E-05 0.13985  1.92965E-04 0.04248  2.17060E-03 0.01497  2.17210E-02 0.00449  2.21749E-01 0.00146  8.57829E-01 0.00041  4.94118E-01 0.00124  8.76619E-01 0.00779  0.00000E+00 0.00000  0.00000E+00 0.00000  1.77263E-06 0.44024  1.78060E-05 0.16965  1.65531E-04 0.04992  1.80529E-03 0.01963  1.44737E-02 0.00655  2.05054E-01 0.00115  1.08053E+00 0.00082  2.30858E+00 0.00487  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  9.34860E-06 0.24979  6.33046E-05 0.09351  5.88410E-04 0.03376  5.85226E-03 0.00549  4.53237E-02 0.00384  9.96349E-01 0.00664 ];

% Diffusion parameters:

DIFFAREA                  (idx, [1:  22]) = [  5.63264E+01 0.00186  3.02525E+01 0.00320  1.28805E+01 0.00210  3.47218E+00 0.00209  2.36935E+00 0.00185  2.16814E+00 0.00258  2.07226E+00 0.00231  1.79435E+00 0.00260  1.59013E+00 0.00182  4.33079E-01 0.00201  3.27057E-02 0.01011 ];
DIFFCOEF                  (idx, [1:  22]) = [  1.25579E+00 0.00189  2.15687E+00 0.00279  1.17178E+00 0.00189  6.98886E-01 0.00193  5.88761E-01 0.00178  5.73905E-01 0.00216  5.89843E-01 0.00213  5.62864E-01 0.00244  4.32227E-01 0.00164  2.65123E-01 0.00203  1.10211E-01 0.01016 ];
TRANSPXS                  (idx, [1:  22]) = [  2.65558E-01 0.00188  1.54700E-01 0.00279  2.84599E-01 0.00189  4.77180E-01 0.00193  5.66394E-01 0.00180  5.81167E-01 0.00217  5.65454E-01 0.00214  5.92660E-01 0.00242  7.71468E-01 0.00164  1.25794E+00 0.00202  3.06202E+00 0.00955 ];
MUBAR                     (idx, [1:  22]) = [  6.43464E-01 0.00118  2.63900E-01 0.00799  3.29283E-01 0.00387  3.39498E-01 0.00397  3.45406E-01 0.00389  3.59658E-01 0.00405  3.77767E-01 0.00405  3.96322E-01 0.00458  3.34792E-01 0.00376  2.68321E-01 0.00661  3.10123E-01 0.02687 ];

% Material buckling:

MAT_BUCKLING              (idx, [1:   2]) = [ -6.06360E-03 0.00254 ];

% Leakage estimate of diffusion coefficient:

LEAK_DIFFCOEF             (idx, [1:  22]) = [  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000  0.00000E+00 0.00000 ];

% PN scattering cross sections:

SCATT0                    (idx, [1:  22]) = [  6.90234E-01 0.00043  2.08116E-01 0.00039  4.27950E-01 0.00020  7.27036E-01 0.00030  8.64569E-01 0.00044  8.87891E-01 0.00047  8.58237E-01 0.00046  8.64050E-01 0.00056  1.08183E+00 0.00041  1.63780E+00 0.00078  4.23095E+00 0.00567 ];
SCATT1                    (idx, [1:  22]) = [  2.76269E-01 0.00043  8.95308E-02 0.00122  1.78692E-01 0.00085  3.43509E-01 0.00092  4.14065E-01 0.00106  4.27113E-01 0.00104  4.32825E-01 0.00096  4.21258E-01 0.00116  3.65980E-01 0.00088  3.64822E-01 0.00160  3.53845E-01 0.02196 ];
SCATT2                    (idx, [1:  22]) = [  1.00853E-01 0.00083  4.97506E-02 0.00169  6.80513E-02 0.00201  1.26777E-01 0.00182  1.53737E-01 0.00200  1.59392E-01 0.00173  1.63288E-01 0.00203  1.66920E-01 0.00219  1.14485E-01 0.00212  7.94245E-02 0.00588  3.36289E-02 0.15932 ];
SCATT3                    (idx, [1:  22]) = [  1.28210E-02 0.00507  1.52345E-02 0.00494  1.71453E-03 0.06044  2.42411E-04 0.83841 -3.19824E-04 0.76499  3.16730E-04 0.83152  3.90919E-03 0.07430  2.91638E-02 0.01110  3.99982E-02 0.00480  2.49485E-02 0.01572  2.65460E-02 0.16086 ];
SCATT4                    (idx, [1:  22]) = [ -9.28890E-03 0.00633  6.56159E-03 0.01146 -8.97898E-03 0.01065 -2.10074E-02 0.00930 -2.57228E-02 0.00902 -2.74790E-02 0.00827 -2.90739E-02 0.00919 -1.39565E-02 0.02108  1.05277E-03 0.15432 -9.46039E-03 0.03543 -8.36427E-03 0.43146 ];
SCATT5                    (idx, [1:  22]) = [  1.80183E-03 0.02591  4.98642E-03 0.01367 -1.34731E-05 6.67726  9.41093E-05 1.88960  3.32341E-04 0.65269 -9.11629E-04 0.23740 -5.28056E-03 0.04080 -1.04553E-02 0.02343  6.82741E-03 0.02387  9.63661E-03 0.02954  2.13346E-02 0.15877 ];

% P1 diffusion parameters:

P1_TRANSPXS               (idx, [1:  22]) = [  4.28280E-01 0.00060  1.19433E-01 0.00098  2.45158E-01 0.00060  3.77537E-01 0.00072  4.47496E-01 0.00083  4.69898E-01 0.00084  4.53074E-01 0.00091  5.10095E-01 0.00088  7.63691E-01 0.00049  1.32793E+00 0.00073  4.01622E+00 0.00436 ];
P1_DIFFCOEF               (idx, [1:  22]) = [  7.78343E-01 0.00060  2.79132E+00 0.00098  1.35973E+00 0.00060  8.82975E-01 0.00072  7.44951E-01 0.00083  7.09438E-01 0.00084  7.35794E-01 0.00091  6.53537E-01 0.00087  4.36490E-01 0.00049  2.51035E-01 0.00073  8.32006E-02 0.00437 ];
P1_MUBAR                  (idx, [1:  22]) = [  4.00258E-01 0.00040  4.30196E-01 0.00116  4.17553E-01 0.00079  4.72472E-01 0.00073  4.78917E-01 0.00077  4.81035E-01 0.00079  5.04312E-01 0.00070  4.87525E-01 0.00076  3.38296E-01 0.00073  2.22752E-01 0.00139  8.33576E-02 0.02004 ];

% Assembly discontinuity factors:

ADFS                      (idx, [1:  80]) = [  9.85932E-01 0.00532  9.98981E-01 0.00400  1.01411E+00 0.00475  1.00999E+00 0.00433  1.00856E+00 0.00488  1.01552E+00 0.00461  9.99929E-01 0.00589  9.52298E-01 0.00383  9.36713E-01 0.00522  9.74597E-01 0.01603  9.85932E-01 0.00532  9.98981E-01 0.00400  1.01411E+00 0.00475  1.00999E+00 0.00433  1.00856E+00 0.00488  1.01552E+00 0.00461  9.99929E-01 0.00589  9.52298E-01 0.00383  9.36713E-01 0.00522  9.74597E-01 0.01603  9.85932E-01 0.00532  9.98981E-01 0.00400  1.01411E+00 0.00475  1.00999E+00 0.00433  1.00856E+00 0.00488  1.01552E+00 0.00461  9.99929E-01 0.00589  9.52298E-01 0.00383  9.36713E-01 0.00522  9.74597E-01 0.01603  9.85932E-01 0.00532  9.98981E-01 0.00400  1.01411E+00 0.00475  1.00999E+00 0.00433  1.00856E+00 0.00488  1.01552E+00 0.00461  9.99929E-01 0.00589  9.52298E-01 0.00383  9.36713E-01 0.00522  9.74597E-01 0.01603 ];
ADFC                      (idx, [1:  80]) = [  9.23230E-01 0.05549  9.93796E-01 0.04142  1.08329E+00 0.03291  1.00832E+00 0.03783  1.01160E+00 0.03991  1.06157E+00 0.04524  9.23687E-01 0.05249  9.02321E-01 0.03436  9.13757E-01 0.04277  7.01452E-01 0.17029  9.23230E-01 0.05549  9.93796E-01 0.04142  1.08329E+00 0.03291  1.00832E+00 0.03783  1.01160E+00 0.03991  1.06157E+00 0.04524  9.23687E-01 0.05249  9.02321E-01 0.03436  9.13757E-01 0.04277  7.01452E-01 0.17029  9.23230E-01 0.05549  9.93796E-01 0.04142  1.08329E+00 0.03291  1.00832E+00 0.03783  1.01160E+00 0.03991  1.06157E+00 0.04524  9.23687E-01 0.05249  9.02321E-01 0.03436  9.13757E-01 0.04277  7.01452E-01 0.17029  9.23230E-01 0.05549  9.93796E-01 0.04142  1.08329E+00 0.03291  1.00832E+00 0.03783  1.01160E+00 0.03991  1.06157E+00 0.04524  9.23687E-01 0.05249  9.02321E-01 0.03436  9.13757E-01 0.04277  7.01452E-01 0.17029 ];

% Power distributions in lattices:

LAT10                     (idx, [1:   3]) = [ 1   17   17 ];
POWDISTR10                (idx, [1: 578]) = [  8.84233E-01 0.01844  9.02628E-01 0.01852  9.21006E-01 0.02009  8.93865E-01 0.02050  9.84290E-01 0.01968  9.63432E-01 0.01925  9.44691E-01 0.01885  9.33363E-01 0.01900  9.90005E-01 0.01822  9.72128E-01 0.02000  9.69462E-01 0.01763  9.96930E-01 0.01909  9.59494E-01 0.01943  9.49045E-01 0.02114  9.57304E-01 0.01874  9.16999E-01 0.02098  9.15209E-01 0.02169  9.05600E-01 0.01943  9.23402E-01 0.01997  9.11422E-01 0.02095  9.19561E-01 0.01981  9.96888E-01 0.01938  1.02945E+00 0.01820  9.63730E-01 0.01834  1.00663E+00 0.01845  9.55577E-01 0.02143  9.76602E-01 0.01915  9.89041E-01 0.01856  1.02085E+00 0.01947  9.58689E-01 0.02092  9.99998E-01 0.01668  9.55801E-01 0.02064  9.08581E-01 0.02102  8.64125E-01 0.01925  9.16905E-01 0.01889  9.09789E-01 0.01874  9.70179E-01 0.01968  9.93318E-01 0.01823  1.00239E+00 0.02183  0.00000E+00 0.00000  1.03328E+00 0.01838  1.01574E+00 0.01834  0.00000E+00 0.00000  9.95947E-01 0.01832  1.04732E+00 0.01851  0.00000E+00 0.00000  1.06870E+00 0.01691  1.02925E+00 0.01759  9.61041E-01 0.01893  9.01894E-01 0.02112  9.24709E-01 0.02305  9.03239E-01 0.02009  9.29702E-01 0.02001  1.01121E+00 0.02047  0.00000E+00 0.00000  1.03192E+00 0.01859  1.01322E+00 0.01843  1.02748E+00 0.01917  1.02176E+00 0.01925  1.02735E+00 0.01940  1.03983E+00 0.01784  1.05288E+00 0.01967  1.04791E+00 0.01885  1.04847E+00 0.01972  0.00000E+00 0.00000  9.81267E-01 0.01986  9.53563E-01 0.02068  9.53237E-01 0.01970  9.43297E-01 0.01930  9.54982E-01 0.01896  1.04323E+00 0.01933  1.05248E+00 0.02073  1.06127E+00 0.01811  1.05228E+00 0.01811  1.03353E+00 0.01998  9.95816E-01 0.01996  1.03661E+00 0.01959  1.02672E+00 0.02061  1.05916E+00 0.02015  1.06098E+00 0.02125  1.06925E+00 0.01835  1.04961E+00 0.02001  1.01282E+00 0.01947  9.84584E-01 0.01885  9.64820E-01 0.01859  9.61979E-01 0.01900  9.84528E-01 0.01912  0.00000E+00 0.00000  1.05758E+00 0.02030  1.06655E+00 0.01911  0.00000E+00 0.00000  1.04439E+00 0.01856  1.05682E+00 0.01760  0.00000E+00 0.00000  1.04125E+00 0.02003  1.06300E+00 0.02042  0.00000E+00 0.00000  1.06271E+00 0.01857  1.08618E+00 0.01983  0.00000E+00 0.00000  1.01326E+00 0.02172  9.87073E-01 0.01997  9.53897E-01 0.01992  1.02330E+00 0.01830  1.02873E+00 0.01827  1.01469E+00 0.01921  1.04800E+00 0.01873  1.04536E+00 0.02019  1.01535E+00 0.01737  9.60550E-01 0.01923  1.09255E+00 0.01605  9.84339E-01 0.01866  1.02716E+00 0.01912  1.04237E+00 0.01987  1.00057E+00 0.01667  9.97724E-01 0.01920  1.01555E+00 0.01942  9.83410E-01 0.01664  9.68459E-01 0.01864  9.76853E-01 0.01763  9.91340E-01 0.01930  1.06638E+00 0.01948  1.06006E+00 0.01922  1.02836E+00 0.01888  1.04793E+00 0.01992  1.03569E+00 0.01934  1.05523E+00 0.01762  1.04807E+00 0.01830  1.04521E+00 0.01957  1.05215E+00 0.01949  1.06629E+00 0.01807  1.05463E+00 0.01873  1.00305E+00 0.01737  1.02888E+00 0.01892  9.98405E-01 0.02010  1.01094E+00 0.02011  9.53472E-01 0.01874  1.01261E+00 0.01587  0.00000E+00 0.00000  1.06135E+00 0.01841  1.06197E+00 0.01951  0.00000E+00 0.00000  1.04517E+00 0.01866  1.06409E+00 0.01978  0.00000E+00 0.00000  1.06453E+00 0.02039  1.07593E+00 0.02056  0.00000E+00 0.00000  1.01905E+00 0.01888  1.05993E+00 0.02004  0.00000E+00 0.00000  9.84254E-01 0.01918  9.93253E-01 0.02063  9.53833E-01 0.02070  1.00024E+00 0.01746  1.02657E+00 0.01952  1.02393E+00 0.01971  1.04841E+00 0.01716  1.05931E+00 0.02047  1.02976E+00 0.01755  9.96602E-01 0.01895  1.04891E+00 0.01878  1.04645E+00 0.01850  1.02322E+00 0.01873  1.06216E+00 0.01791  1.01710E+00 0.01892  9.99068E-01 0.01994  1.01416E+00 0.01887  9.85666E-01 0.01881  9.75480E-01 0.01912  9.45292E-01 0.02024  1.00107E+00 0.01805  1.03436E+00 0.01951  9.86819E-01 0.01942  1.01526E+00 0.01913  1.04429E+00 0.01760  1.03716E+00 0.01949  1.06019E+00 0.01999  1.05986E+00 0.02107  1.06346E+00 0.01952  1.06048E+00 0.01892  1.09824E+00 0.01768  1.04511E+00 0.01861  1.00080E+00 0.01776  1.05444E+00 0.01990  9.75407E-01 0.01965  9.62909E-01 0.01859  9.80318E-01 0.02034  9.91847E-01 0.02077  0.00000E+00 0.00000  1.03871E+00 0.01806  1.06298E+00 0.01954  0.00000E+00 0.00000  1.05886E+00 0.01665  1.02633E+00 0.01909  0.00000E+00 0.00000  1.03039E+00 0.01853  1.04840E+00 0.01801  0.00000E+00 0.00000  1.02936E+00 0.01832  1.05341E+00 0.01878  0.00000E+00 0.00000  1.01887E+00 0.01840  9.46919E-01 0.02066  9.63271E-01 0.02064  9.66531E-01 0.02013  1.02074E+00 0.01941  1.07798E+00 0.02037  1.06670E+00 0.01912  1.03669E+00 0.01778  1.03781E+00 0.01780  1.02548E+00 0.01977  1.06541E+00 0.01978  1.00980E+00 0.01894  1.03207E+00 0.01946  1.05432E+00 0.01814  1.04667E+00 0.01972  1.06157E+00 0.01849  1.04354E+00 0.01915  9.95157E-01 0.01960  9.54164E-01 0.02148  9.44972E-01 0.01974  9.87439E-01 0.02006  1.01204E+00 0.01875  0.00000E+00 0.00000  1.07629E+00 0.01703  1.02570E+00 0.01852  1.02702E+00 0.01840  1.06646E+00 0.01830  1.06401E+00 0.01784  1.04369E+00 0.01813  1.01908E+00 0.01902  1.05804E+00 0.01685  1.05612E+00 0.01711  0.00000E+00 0.00000  1.00024E+00 0.01647  9.61243E-01 0.01968  9.53782E-01 0.01945  9.21321E-01 0.02061  9.23820E-01 0.01779  9.94857E-01 0.02181  1.02247E+00 0.01860  1.01606E+00 0.02140  0.00000E+00 0.00000  9.96962E-01 0.01793  1.02201E+00 0.01918  0.00000E+00 0.00000  1.02780E+00 0.01879  1.03548E+00 0.01935  0.00000E+00 0.00000  1.02497E+00 0.02106  9.92291E-01 0.01900  9.21633E-01 0.02186  9.34312E-01 0.01716  8.91884E-01 0.02010  9.09195E-01 0.01955  9.11285E-01 0.01844  9.34209E-01 0.01868  9.57255E-01 0.02081  9.77082E-01 0.01887  1.00387E+00 0.01748  1.00253E+00 0.01952  9.57534E-01 0.02160  1.01488E+00 0.01911  1.00756E+00 0.02126  9.93205E-01 0.01767  1.00918E+00 0.01883  1.00516E+00 0.01895  9.35383E-01 0.01958  9.28242E-01 0.02120  9.08624E-01 0.02026  9.10203E-01 0.01862  8.76842E-01 0.01866  9.09494E-01 0.01850  9.12969E-01 0.02157  9.02590E-01 0.02151  9.33268E-01 0.02089  9.63326E-01 0.01929  9.80342E-01 0.01810  9.77519E-01 0.01991  9.55820E-01 0.02184  9.63016E-01 0.02047  9.48885E-01 0.01876  9.73158E-01 0.01946  9.64908E-01 0.01792  9.61422E-01 0.02022  9.47988E-01 0.01934  8.95816E-01 0.01918  8.97559E-01 0.02105 ];
PEAKF10                   (idx, [1:   4]) = [   12   11  1.09824E+00 0.01768 ];

