###################
###  WARNING!!! ###
###################
# This file has been autogenerated

# Cython imports
from cython.operator cimport dereference as deref
from cython.operator cimport preincrement as inc
from libc.stdlib cimport malloc, free
from libc.string cimport memcpy
from libcpp.string cimport string as std_string
from libcpp.utility cimport pair
from libcpp.map cimport map as cpp_map
from libcpp.set cimport set as cpp_set
from libcpp cimport bool as cpp_bool
from libcpp.vector cimport vector as cpp_vector
from cpython.version cimport PY_MAJOR_VERSION

# Python Imports
import collections

cimport numpy as np
import numpy as np

np.import_array()

cimport extra_types

# Cython Imports For Types
cimport dtypes
cimport extra_types
from libcpp.vector cimport vector as cpp_vector
cimport numpy as np
from libcpp.string cimport string as std_string

# Imports For Types
import numpy as np

if PY_MAJOR_VERSION >= 3:
    basestring = str

# Dirty ifdef, else, else preprocessor hack
# see http://comments.gmane.org/gmane.comp.python.cython.user/4080
cdef extern from *:
    cdef void emit_ifpy2k "#if PY_MAJOR_VERSION == 2 //" ()
    cdef void emit_ifpy3k "#if PY_MAJOR_VERSION == 3 //" ()
    cdef void emit_else "#else //" ()
    cdef void emit_endif "#endif //" ()

# SetStr
cdef class _SetIterStr(object):
    cdef void init(self, cpp_set[std_string] * set_ptr):
        cdef cpp_set[std_string].iterator * itn = <cpp_set[std_string].iterator *> malloc(sizeof(set_ptr.begin()))
        itn[0] = set_ptr.begin()
        self.iter_now = itn

        cdef cpp_set[std_string].iterator * ite = <cpp_set[std_string].iterator *> malloc(sizeof(set_ptr.end()))
        ite[0] = set_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_set[std_string].iterator inow = deref(self.iter_now)
        cdef cpp_set[std_string].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = bytes(<char *> deref(inow).c_str()).decode()
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval


cdef class _SetStr:
    def __cinit__(self, new_set=True, bint free_set=True):
        cdef std_string s
        cdef cpp_set[std_string] * set_ptr
        cdef char * value_proxy

        # Decide how to init set, if at all
        if isinstance(new_set, _SetStr):
            self.set_ptr = (<_SetStr> new_set).set_ptr
        elif isinstance(new_set, np.generic) and np.PyArray_DescrFromScalar(new_set).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.set_ptr == NULL:
                self.set_ptr = new cpp_set[std_string]()
            np.PyArray_ScalarAsCtype(new_set, &set_ptr)
            self.set_ptr[0] = set_ptr[0]
        elif hasattr(new_set, '__iter__') or \
                (hasattr(new_set, '__len__') and
                hasattr(new_set, '__getitem__')):
            self.set_ptr = new cpp_set[std_string]()
            for value in new_set:
                value_bytes = value.encode()
                s = std_string(<char *> value_bytes)
                self.set_ptr.insert(s)
        elif bool(new_set):
            self.set_ptr = new cpp_set[std_string]()

        # Store free_set
        self._free_set = free_set

    def __dealloc__(self):
        if self._free_set:
            del self.set_ptr

    def __contains__(self, value):
        cdef std_string s
        cdef char * value_proxy
        if isinstance(value, basestring):
            value_bytes = value.encode()
            s = std_string(<char *> value_bytes)
        else:
            return False

        if 0 < self.set_ptr.count(s):
            return True
        else:
            return False

    def __len__(self):
        return self.set_ptr.size()

    def __iter__(self):
        cdef _SetIterStr si = _SetIterStr()
        si.init(self.set_ptr)
        return si

    def add(self, value):
        cdef std_string v
        cdef char * value_proxy
        value_bytes = value.encode()
        v = std_string(<char *> value_bytes)
        self.set_ptr.insert(v)
        return

    def discard(self, value):
        cdef std_string v
        cdef char * value_proxy
        if value in self:
            value_bytes = value.encode()
            v = std_string(<char *> value_bytes)
            self.set_ptr.erase(v)
        return


class SetStr(_SetStr, collections.Set):
    """Wrapper class for C++ standard library sets of type <string>.
    Provides set like interface on the Python level.


    Parameters
    ----------
    new_set : bool or set-like
        Boolean on whether to make a new set or not, or set-like object
        with values which are castable to the appropriate type.
    free_set : bool
        Flag for whether the pointer to the C++ set should be deallocated
        when the wrapper is dereferenced.

    """
    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "set([" + ", ".join([repr(i) for i in self]) + "])"



# SetInt
cdef class _SetIterInt(object):
    cdef void init(self, cpp_set[int] * set_ptr):
        cdef cpp_set[int].iterator * itn = <cpp_set[int].iterator *> malloc(sizeof(set_ptr.begin()))
        itn[0] = set_ptr.begin()
        self.iter_now = itn

        cdef cpp_set[int].iterator * ite = <cpp_set[int].iterator *> malloc(sizeof(set_ptr.end()))
        ite[0] = set_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_set[int].iterator inow = deref(self.iter_now)
        cdef cpp_set[int].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow))
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval


cdef class _SetInt:
    def __cinit__(self, new_set=True, bint free_set=True):
        cdef int s
        cdef cpp_set[int] * set_ptr


        # Decide how to init set, if at all
        if isinstance(new_set, _SetInt):
            self.set_ptr = (<_SetInt> new_set).set_ptr
        elif isinstance(new_set, np.generic) and np.PyArray_DescrFromScalar(new_set).type_num == np.NPY_INT32:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.set_ptr == NULL:
                self.set_ptr = new cpp_set[int]()
            np.PyArray_ScalarAsCtype(new_set, &set_ptr)
            self.set_ptr[0] = set_ptr[0]
        elif hasattr(new_set, '__iter__') or \
                (hasattr(new_set, '__len__') and
                hasattr(new_set, '__getitem__')):
            self.set_ptr = new cpp_set[int]()
            for value in new_set:

                s = <int> value
                self.set_ptr.insert(s)
        elif bool(new_set):
            self.set_ptr = new cpp_set[int]()

        # Store free_set
        self._free_set = free_set

    def __dealloc__(self):
        if self._free_set:
            del self.set_ptr

    def __contains__(self, value):
        cdef int s

        if isinstance(value, int):

            s = <int> value
        else:
            return False

        if 0 < self.set_ptr.count(s):
            return True
        else:
            return False

    def __len__(self):
        return self.set_ptr.size()

    def __iter__(self):
        cdef _SetIterInt si = _SetIterInt()
        si.init(self.set_ptr)
        return si

    def add(self, value):
        cdef int v


        v = <int> value
        self.set_ptr.insert(v)
        return

    def discard(self, value):
        cdef int v

        if value in self:

            v = <int> value
            self.set_ptr.erase(v)
        return


class SetInt(_SetInt, collections.Set):
    """Wrapper class for C++ standard library sets of type <integer>.
    Provides set like interface on the Python level.


    Parameters
    ----------
    new_set : bool or set-like
        Boolean on whether to make a new set or not, or set-like object
        with values which are castable to the appropriate type.
    free_set : bool
        Flag for whether the pointer to the C++ set should be deallocated
        when the wrapper is dereferenced.

    """
    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "set([" + ", ".join([repr(i) for i in self]) + "])"



# Map(Str, Str)
cdef class _MapIterStrStr(object):
    cdef void init(self, cpp_map[std_string, std_string] * map_ptr):
        cdef cpp_map[std_string, std_string].iterator * itn = <cpp_map[std_string, std_string].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[std_string, std_string].iterator * ite = <cpp_map[std_string, std_string].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[std_string, std_string].iterator inow = deref(self.iter_now)
        cdef cpp_map[std_string, std_string].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = bytes(<char *> deref(inow).first.c_str()).decode()
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapStrStr:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[std_string, std_string] item
        cdef cpp_map[std_string, std_string] * map_ptr
        cdef char * key_proxy
        cdef char * value_proxy

        # Decide how to init map, if at all
        if isinstance(new_map, _MapStrStr):
            self.map_ptr = (<_MapStrStr> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[std_string, std_string]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[std_string, std_string]()
            for key, value in new_map.items():
                key_bytes = key.encode()
                value_bytes = value.encode()
                item = pair[std_string, std_string](std_string(<char *> key_bytes), std_string(<char *> value_bytes))
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[std_string, std_string]()
            for key, value in new_map:
                key_bytes = key.encode()
                value_bytes = value.encode()
                item = pair[std_string, std_string](std_string(<char *> key_bytes), std_string(<char *> value_bytes))
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[std_string, std_string]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if not isinstance(key, basestring):
            return False
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterStrStr mi = _MapIterStrStr()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef std_string k
        cdef std_string v
        cdef char * key_proxy

        if not isinstance(key, basestring):
            raise TypeError("Only string keys are valid.")
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return bytes(<char *> deref(self.map_ptr)[k].c_str()).decode()
        else:
            raise KeyError

    def __setitem__(self, key, value):
        cdef char * key_proxy
        cdef char * value_proxy
        cdef pair[std_string, std_string] item
        key_bytes = key.encode()
        value_bytes = value.encode()
        item = pair[std_string, std_string](std_string(<char *> key_bytes), std_string(<char *> value_bytes))
        if 0 < self.map_ptr.count(std_string(<char *> key_bytes)):
            self.map_ptr.erase(std_string(<char *> key_bytes))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if key in self:
            key_bytes = key.encode()
            k = std_string(<char *> key_bytes)
            self.map_ptr.erase(k)


class MapStrStr(_MapStrStr, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <string, string>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Str, Int)
cdef class _MapIterStrInt(object):
    cdef void init(self, cpp_map[std_string, int] * map_ptr):
        cdef cpp_map[std_string, int].iterator * itn = <cpp_map[std_string, int].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[std_string, int].iterator * ite = <cpp_map[std_string, int].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[std_string, int].iterator inow = deref(self.iter_now)
        cdef cpp_map[std_string, int].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = bytes(<char *> deref(inow).first.c_str()).decode()
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapStrInt:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[std_string, int] item
        cdef cpp_map[std_string, int] * map_ptr
        cdef char * key_proxy


        # Decide how to init map, if at all
        if isinstance(new_map, _MapStrInt):
            self.map_ptr = (<_MapStrInt> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[std_string, int]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[std_string, int]()
            for key, value in new_map.items():
                key_bytes = key.encode()

                item = pair[std_string, int](std_string(<char *> key_bytes), <int> value)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[std_string, int]()
            for key, value in new_map:
                key_bytes = key.encode()

                item = pair[std_string, int](std_string(<char *> key_bytes), <int> value)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[std_string, int]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if not isinstance(key, basestring):
            return False
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterStrInt mi = _MapIterStrInt()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef std_string k
        cdef int v
        cdef char * key_proxy

        if not isinstance(key, basestring):
            raise TypeError("Only string keys are valid.")
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return int(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):
        cdef char * key_proxy

        cdef pair[std_string, int] item
        key_bytes = key.encode()

        item = pair[std_string, int](std_string(<char *> key_bytes), <int> value)
        if 0 < self.map_ptr.count(std_string(<char *> key_bytes)):
            self.map_ptr.erase(std_string(<char *> key_bytes))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if key in self:
            key_bytes = key.encode()
            k = std_string(<char *> key_bytes)
            self.map_ptr.erase(k)


class MapStrInt(_MapStrInt, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <string, integer>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Int, Str)
cdef class _MapIterIntStr(object):
    cdef void init(self, cpp_map[int, std_string] * map_ptr):
        cdef cpp_map[int, std_string].iterator * itn = <cpp_map[int, std_string].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[int, std_string].iterator * ite = <cpp_map[int, std_string].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[int, std_string].iterator inow = deref(self.iter_now)
        cdef cpp_map[int, std_string].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapIntStr:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[int, std_string] item
        cdef cpp_map[int, std_string] * map_ptr

        cdef char * value_proxy

        # Decide how to init map, if at all
        if isinstance(new_map, _MapIntStr):
            self.map_ptr = (<_MapIntStr> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[int, std_string]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[int, std_string]()
            for key, value in new_map.items():

                value_bytes = value.encode()
                item = pair[int, std_string](<int> key, std_string(<char *> value_bytes))
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[int, std_string]()
            for key, value in new_map:

                value_bytes = value.encode()
                item = pair[int, std_string](<int> key, std_string(<char *> value_bytes))
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[int, std_string]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef int k

        if not isinstance(key, int):
            return False

        k = <int> key

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterIntStr mi = _MapIterIntStr()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef int k
        cdef std_string v


        if not isinstance(key, int):
            raise TypeError("Only integer keys are valid.")

        k = <int> key

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return bytes(<char *> deref(self.map_ptr)[k].c_str()).decode()
        else:
            raise KeyError

    def __setitem__(self, key, value):

        cdef char * value_proxy
        cdef pair[int, std_string] item

        value_bytes = value.encode()
        item = pair[int, std_string](<int> key, std_string(<char *> value_bytes))
        if 0 < self.map_ptr.count(<int> key):
            self.map_ptr.erase(<int> key)
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef int k

        if key in self:

            k = <int> key
            self.map_ptr.erase(k)


class MapIntStr(_MapIntStr, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <integer, string>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Str, UInt)
cdef class _MapIterStrUInt(object):
    cdef void init(self, cpp_map[std_string, extra_types.uint32] * map_ptr):
        cdef cpp_map[std_string, extra_types.uint32].iterator * itn = <cpp_map[std_string, extra_types.uint32].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[std_string, extra_types.uint32].iterator * ite = <cpp_map[std_string, extra_types.uint32].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[std_string, extra_types.uint32].iterator inow = deref(self.iter_now)
        cdef cpp_map[std_string, extra_types.uint32].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = bytes(<char *> deref(inow).first.c_str()).decode()
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapStrUInt:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[std_string, extra_types.uint32] item
        cdef cpp_map[std_string, extra_types.uint32] * map_ptr
        cdef char * key_proxy


        # Decide how to init map, if at all
        if isinstance(new_map, _MapStrUInt):
            self.map_ptr = (<_MapStrUInt> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[std_string, extra_types.uint32]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[std_string, extra_types.uint32]()
            for key, value in new_map.items():
                key_bytes = key.encode()

                item = pair[std_string, extra_types.uint32](std_string(<char *> key_bytes), <extra_types.uint32> long(value))
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[std_string, extra_types.uint32]()
            for key, value in new_map:
                key_bytes = key.encode()

                item = pair[std_string, extra_types.uint32](std_string(<char *> key_bytes), <extra_types.uint32> long(value))
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[std_string, extra_types.uint32]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if not isinstance(key, basestring):
            return False
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterStrUInt mi = _MapIterStrUInt()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef std_string k
        cdef extra_types.uint32 v
        cdef char * key_proxy

        if not isinstance(key, basestring):
            raise TypeError("Only string keys are valid.")
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return int(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):
        cdef char * key_proxy

        cdef pair[std_string, extra_types.uint32] item
        key_bytes = key.encode()

        item = pair[std_string, extra_types.uint32](std_string(<char *> key_bytes), <extra_types.uint32> long(value))
        if 0 < self.map_ptr.count(std_string(<char *> key_bytes)):
            self.map_ptr.erase(std_string(<char *> key_bytes))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if key in self:
            key_bytes = key.encode()
            k = std_string(<char *> key_bytes)
            self.map_ptr.erase(k)


class MapStrUInt(_MapStrUInt, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <string, unsigned integer>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(UInt, Str)
cdef class _MapIterUIntStr(object):
    cdef void init(self, cpp_map[extra_types.uint32, std_string] * map_ptr):
        cdef cpp_map[extra_types.uint32, std_string].iterator * itn = <cpp_map[extra_types.uint32, std_string].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[extra_types.uint32, std_string].iterator * ite = <cpp_map[extra_types.uint32, std_string].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[extra_types.uint32, std_string].iterator inow = deref(self.iter_now)
        cdef cpp_map[extra_types.uint32, std_string].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapUIntStr:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[extra_types.uint32, std_string] item
        cdef cpp_map[extra_types.uint32, std_string] * map_ptr

        cdef char * value_proxy

        # Decide how to init map, if at all
        if isinstance(new_map, _MapUIntStr):
            self.map_ptr = (<_MapUIntStr> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[extra_types.uint32, std_string]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[extra_types.uint32, std_string]()
            for key, value in new_map.items():

                value_bytes = value.encode()
                item = pair[extra_types.uint32, std_string](<extra_types.uint32> long(key), std_string(<char *> value_bytes))
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[extra_types.uint32, std_string]()
            for key, value in new_map:

                value_bytes = value.encode()
                item = pair[extra_types.uint32, std_string](<extra_types.uint32> long(key), std_string(<char *> value_bytes))
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[extra_types.uint32, std_string]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef extra_types.uint32 k

        if not isinstance(key, int):
            return False

        k = <extra_types.uint32> long(key)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterUIntStr mi = _MapIterUIntStr()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef extra_types.uint32 k
        cdef std_string v


        if not isinstance(key, int):
            raise TypeError("Only unsigned integer keys are valid.")

        k = <extra_types.uint32> long(key)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return bytes(<char *> deref(self.map_ptr)[k].c_str()).decode()
        else:
            raise KeyError

    def __setitem__(self, key, value):

        cdef char * value_proxy
        cdef pair[extra_types.uint32, std_string] item

        value_bytes = value.encode()
        item = pair[extra_types.uint32, std_string](<extra_types.uint32> long(key), std_string(<char *> value_bytes))
        if 0 < self.map_ptr.count(<extra_types.uint32> long(key)):
            self.map_ptr.erase(<extra_types.uint32> long(key))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef extra_types.uint32 k

        if key in self:

            k = <extra_types.uint32> long(key)
            self.map_ptr.erase(k)


class MapUIntStr(_MapUIntStr, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <unsigned integer, string>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Str, Double)
cdef class _MapIterStrDouble(object):
    cdef void init(self, cpp_map[std_string, double] * map_ptr):
        cdef cpp_map[std_string, double].iterator * itn = <cpp_map[std_string, double].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[std_string, double].iterator * ite = <cpp_map[std_string, double].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[std_string, double].iterator inow = deref(self.iter_now)
        cdef cpp_map[std_string, double].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = bytes(<char *> deref(inow).first.c_str()).decode()
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapStrDouble:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[std_string, double] item
        cdef cpp_map[std_string, double] * map_ptr
        cdef char * key_proxy


        # Decide how to init map, if at all
        if isinstance(new_map, _MapStrDouble):
            self.map_ptr = (<_MapStrDouble> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[std_string, double]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[std_string, double]()
            for key, value in new_map.items():
                key_bytes = key.encode()

                item = pair[std_string, double](std_string(<char *> key_bytes), <double> value)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[std_string, double]()
            for key, value in new_map:
                key_bytes = key.encode()

                item = pair[std_string, double](std_string(<char *> key_bytes), <double> value)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[std_string, double]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if not isinstance(key, basestring):
            return False
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterStrDouble mi = _MapIterStrDouble()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef std_string k
        cdef double v
        cdef char * key_proxy

        if not isinstance(key, basestring):
            raise TypeError("Only string keys are valid.")
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return float(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):
        cdef char * key_proxy

        cdef pair[std_string, double] item
        key_bytes = key.encode()

        item = pair[std_string, double](std_string(<char *> key_bytes), <double> value)
        if 0 < self.map_ptr.count(std_string(<char *> key_bytes)):
            self.map_ptr.erase(std_string(<char *> key_bytes))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if key in self:
            key_bytes = key.encode()
            k = std_string(<char *> key_bytes)
            self.map_ptr.erase(k)


class MapStrDouble(_MapStrDouble, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <string, double>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(UInt, UInt)
cdef class _MapIterUIntUInt(object):
    cdef void init(self, cpp_map[extra_types.uint32, extra_types.uint32] * map_ptr):
        cdef cpp_map[extra_types.uint32, extra_types.uint32].iterator * itn = <cpp_map[extra_types.uint32, extra_types.uint32].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[extra_types.uint32, extra_types.uint32].iterator * ite = <cpp_map[extra_types.uint32, extra_types.uint32].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[extra_types.uint32, extra_types.uint32].iterator inow = deref(self.iter_now)
        cdef cpp_map[extra_types.uint32, extra_types.uint32].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapUIntUInt:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[extra_types.uint32, extra_types.uint32] item
        cdef cpp_map[extra_types.uint32, extra_types.uint32] * map_ptr



        # Decide how to init map, if at all
        if isinstance(new_map, _MapUIntUInt):
            self.map_ptr = (<_MapUIntUInt> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[extra_types.uint32, extra_types.uint32]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[extra_types.uint32, extra_types.uint32]()
            for key, value in new_map.items():


                item = pair[extra_types.uint32, extra_types.uint32](<extra_types.uint32> long(key), <extra_types.uint32> long(value))
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[extra_types.uint32, extra_types.uint32]()
            for key, value in new_map:


                item = pair[extra_types.uint32, extra_types.uint32](<extra_types.uint32> long(key), <extra_types.uint32> long(value))
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[extra_types.uint32, extra_types.uint32]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef extra_types.uint32 k

        if not isinstance(key, int):
            return False

        k = <extra_types.uint32> long(key)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterUIntUInt mi = _MapIterUIntUInt()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef extra_types.uint32 k
        cdef extra_types.uint32 v


        if not isinstance(key, int):
            raise TypeError("Only unsigned integer keys are valid.")

        k = <extra_types.uint32> long(key)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return int(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):


        cdef pair[extra_types.uint32, extra_types.uint32] item


        item = pair[extra_types.uint32, extra_types.uint32](<extra_types.uint32> long(key), <extra_types.uint32> long(value))
        if 0 < self.map_ptr.count(<extra_types.uint32> long(key)):
            self.map_ptr.erase(<extra_types.uint32> long(key))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef extra_types.uint32 k

        if key in self:

            k = <extra_types.uint32> long(key)
            self.map_ptr.erase(k)


class MapUIntUInt(_MapUIntUInt, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <unsigned integer, unsigned integer>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Int, Int)
cdef class _MapIterIntInt(object):
    cdef void init(self, cpp_map[int, int] * map_ptr):
        cdef cpp_map[int, int].iterator * itn = <cpp_map[int, int].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[int, int].iterator * ite = <cpp_map[int, int].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[int, int].iterator inow = deref(self.iter_now)
        cdef cpp_map[int, int].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapIntInt:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[int, int] item
        cdef cpp_map[int, int] * map_ptr



        # Decide how to init map, if at all
        if isinstance(new_map, _MapIntInt):
            self.map_ptr = (<_MapIntInt> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[int, int]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[int, int]()
            for key, value in new_map.items():


                item = pair[int, int](<int> key, <int> value)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[int, int]()
            for key, value in new_map:


                item = pair[int, int](<int> key, <int> value)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[int, int]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef int k

        if not isinstance(key, int):
            return False

        k = <int> key

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterIntInt mi = _MapIterIntInt()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef int k
        cdef int v


        if not isinstance(key, int):
            raise TypeError("Only integer keys are valid.")

        k = <int> key

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return int(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):


        cdef pair[int, int] item


        item = pair[int, int](<int> key, <int> value)
        if 0 < self.map_ptr.count(<int> key):
            self.map_ptr.erase(<int> key)
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef int k

        if key in self:

            k = <int> key
            self.map_ptr.erase(k)


class MapIntInt(_MapIntInt, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <integer, integer>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Int, Double)
cdef class _MapIterIntDouble(object):
    cdef void init(self, cpp_map[int, double] * map_ptr):
        cdef cpp_map[int, double].iterator * itn = <cpp_map[int, double].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[int, double].iterator * ite = <cpp_map[int, double].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[int, double].iterator inow = deref(self.iter_now)
        cdef cpp_map[int, double].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapIntDouble:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[int, double] item
        cdef cpp_map[int, double] * map_ptr



        # Decide how to init map, if at all
        if isinstance(new_map, _MapIntDouble):
            self.map_ptr = (<_MapIntDouble> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[int, double]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[int, double]()
            for key, value in new_map.items():


                item = pair[int, double](<int> key, <double> value)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[int, double]()
            for key, value in new_map:


                item = pair[int, double](<int> key, <double> value)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[int, double]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef int k

        if not isinstance(key, int):
            return False

        k = <int> key

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterIntDouble mi = _MapIterIntDouble()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef int k
        cdef double v


        if not isinstance(key, int):
            raise TypeError("Only integer keys are valid.")

        k = <int> key

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return float(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):


        cdef pair[int, double] item


        item = pair[int, double](<int> key, <double> value)
        if 0 < self.map_ptr.count(<int> key):
            self.map_ptr.erase(<int> key)
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef int k

        if key in self:

            k = <int> key
            self.map_ptr.erase(k)


class MapIntDouble(_MapIntDouble, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <integer, double>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Int, Complex)
cdef class _MapIterIntComplex(object):
    cdef void init(self, cpp_map[int, extra_types.complex_t] * map_ptr):
        cdef cpp_map[int, extra_types.complex_t].iterator * itn = <cpp_map[int, extra_types.complex_t].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[int, extra_types.complex_t].iterator * ite = <cpp_map[int, extra_types.complex_t].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[int, extra_types.complex_t].iterator inow = deref(self.iter_now)
        cdef cpp_map[int, extra_types.complex_t].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapIntComplex:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[int, extra_types.complex_t] item
        cdef cpp_map[int, extra_types.complex_t] * map_ptr



        # Decide how to init map, if at all
        if isinstance(new_map, _MapIntComplex):
            self.map_ptr = (<_MapIntComplex> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[int, extra_types.complex_t]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[int, extra_types.complex_t]()
            for key, value in new_map.items():


                item = pair[int, extra_types.complex_t](<int> key, extra_types.py2c_complex(value))
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[int, extra_types.complex_t]()
            for key, value in new_map:


                item = pair[int, extra_types.complex_t](<int> key, extra_types.py2c_complex(value))
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[int, extra_types.complex_t]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef int k

        if not isinstance(key, int):
            return False

        k = <int> key

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterIntComplex mi = _MapIterIntComplex()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef int k
        cdef extra_types.complex_t v


        if not isinstance(key, int):
            raise TypeError("Only integer keys are valid.")

        k = <int> key

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return complex(float(deref(self.map_ptr)[k].re), float(deref(self.map_ptr)[k].im))
        else:
            raise KeyError

    def __setitem__(self, key, value):


        cdef pair[int, extra_types.complex_t] item


        item = pair[int, extra_types.complex_t](<int> key, extra_types.py2c_complex(value))
        if 0 < self.map_ptr.count(<int> key):
            self.map_ptr.erase(<int> key)
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef int k

        if key in self:

            k = <int> key
            self.map_ptr.erase(k)


class MapIntComplex(_MapIntComplex, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <integer, complex>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(UInt, Double)
cdef class _MapIterUIntDouble(object):
    cdef void init(self, cpp_map[extra_types.uint32, double] * map_ptr):
        cdef cpp_map[extra_types.uint32, double].iterator * itn = <cpp_map[extra_types.uint32, double].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[extra_types.uint32, double].iterator * ite = <cpp_map[extra_types.uint32, double].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[extra_types.uint32, double].iterator inow = deref(self.iter_now)
        cdef cpp_map[extra_types.uint32, double].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapUIntDouble:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[extra_types.uint32, double] item
        cdef cpp_map[extra_types.uint32, double] * map_ptr



        # Decide how to init map, if at all
        if isinstance(new_map, _MapUIntDouble):
            self.map_ptr = (<_MapUIntDouble> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[extra_types.uint32, double]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[extra_types.uint32, double]()
            for key, value in new_map.items():


                item = pair[extra_types.uint32, double](<extra_types.uint32> long(key), <double> value)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[extra_types.uint32, double]()
            for key, value in new_map:


                item = pair[extra_types.uint32, double](<extra_types.uint32> long(key), <double> value)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[extra_types.uint32, double]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef extra_types.uint32 k

        if not isinstance(key, int):
            return False

        k = <extra_types.uint32> long(key)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterUIntDouble mi = _MapIterUIntDouble()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef extra_types.uint32 k
        cdef double v


        if not isinstance(key, int):
            raise TypeError("Only unsigned integer keys are valid.")

        k = <extra_types.uint32> long(key)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]

            return float(deref(self.map_ptr)[k])
        else:
            raise KeyError

    def __setitem__(self, key, value):


        cdef pair[extra_types.uint32, double] item


        item = pair[extra_types.uint32, double](<extra_types.uint32> long(key), <double> value)
        if 0 < self.map_ptr.count(<extra_types.uint32> long(key)):
            self.map_ptr.erase(<extra_types.uint32> long(key))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef extra_types.uint32 k

        if key in self:

            k = <extra_types.uint32> long(key)
            self.map_ptr.erase(k)


class MapUIntDouble(_MapUIntDouble, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <unsigned integer, double>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Str, VectorDouble)
cdef class _MapIterStrVectorDouble(object):
    cdef void init(self, cpp_map[std_string, cpp_vector[double]] * map_ptr):
        cdef cpp_map[std_string, cpp_vector[double]].iterator * itn = <cpp_map[std_string, cpp_vector[double]].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[std_string, cpp_vector[double]].iterator * ite = <cpp_map[std_string, cpp_vector[double]].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[std_string, cpp_vector[double]].iterator inow = deref(self.iter_now)
        cdef cpp_map[std_string, cpp_vector[double]].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = bytes(<char *> deref(inow).first.c_str()).decode()
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapStrVectorDouble:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[std_string, cpp_vector[double]] item
        cdef cpp_map[std_string, cpp_vector[double]] * map_ptr
        cdef char * key_proxy
        cdef cpp_vector[double] value_proxy
        cdef int ivalue
        cdef int value_size
        cdef double * value_data

        # Decide how to init map, if at all
        if isinstance(new_map, _MapStrVectorDouble):
            self.map_ptr = (<_MapStrVectorDouble> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[std_string, cpp_vector[double]]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[std_string, cpp_vector[double]]()
            for key, value in new_map.items():
                key_bytes = key.encode()
                # value is a ('vector', 'float64', 0)
                value_size = len(value)
                if isinstance(value, np.ndarray) and (<np.ndarray> value).descr.type_num == np.NPY_FLOAT64:
                    value_data = <double *> np.PyArray_DATA(<np.ndarray> value)
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = value_data[ivalue]
                else:
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = <double> value[ivalue]
                item = pair[std_string, cpp_vector[double]](std_string(<char *> key_bytes), value_proxy)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[std_string, cpp_vector[double]]()
            for key, value in new_map:
                key_bytes = key.encode()
                # value is a ('vector', 'float64', 0)
                value_size = len(value)
                if isinstance(value, np.ndarray) and (<np.ndarray> value).descr.type_num == np.NPY_FLOAT64:
                    value_data = <double *> np.PyArray_DATA(<np.ndarray> value)
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = value_data[ivalue]
                else:
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = <double> value[ivalue]
                item = pair[std_string, cpp_vector[double]](std_string(<char *> key_bytes), value_proxy)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[std_string, cpp_vector[double]]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if not isinstance(key, basestring):
            return False
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterStrVectorDouble mi = _MapIterStrVectorDouble()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef std_string k
        cdef cpp_vector[double] v
        cdef char * key_proxy
        cdef np.ndarray v_proxy
        cdef np.npy_intp v_proxy_shape[1]
        if not isinstance(key, basestring):
            raise TypeError("Only string keys are valid.")
        key_bytes = key.encode()
        k = std_string(<char *> key_bytes)

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]
            v_proxy_shape[0] = <np.npy_intp> deref(self.map_ptr)[k].size()
            v_proxy = np.PyArray_SimpleNewFromData(1, v_proxy_shape, np.NPY_FLOAT64, &deref(self.map_ptr)[k][0])
            return v_proxy
        else:
            raise KeyError

    def __setitem__(self, key, value):
        cdef char * key_proxy
        cdef cpp_vector[double] value_proxy
        cdef int ivalue
        cdef int value_size
        cdef double * value_data
        cdef pair[std_string, cpp_vector[double]] item
        key_bytes = key.encode()
        # value is a ('vector', 'float64', 0)
        value_size = len(value)
        if isinstance(value, np.ndarray) and (<np.ndarray> value).descr.type_num == np.NPY_FLOAT64:
            value_data = <double *> np.PyArray_DATA(<np.ndarray> value)
            value_proxy = cpp_vector[double](<size_t> value_size)
            for ivalue in range(value_size):
                value_proxy[ivalue] = value_data[ivalue]
        else:
            value_proxy = cpp_vector[double](<size_t> value_size)
            for ivalue in range(value_size):
                value_proxy[ivalue] = <double> value[ivalue]
        item = pair[std_string, cpp_vector[double]](std_string(<char *> key_bytes), value_proxy)
        if 0 < self.map_ptr.count(std_string(<char *> key_bytes)):
            self.map_ptr.erase(std_string(<char *> key_bytes))
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef std_string k
        cdef char * key_proxy
        if key in self:
            key_bytes = key.encode()
            k = std_string(<char *> key_bytes)
            self.map_ptr.erase(k)


class MapStrVectorDouble(_MapStrVectorDouble, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <string, vector [ndarray] of double>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



# Map(Int, VectorDouble)
cdef class _MapIterIntVectorDouble(object):
    cdef void init(self, cpp_map[int, cpp_vector[double]] * map_ptr):
        cdef cpp_map[int, cpp_vector[double]].iterator * itn = <cpp_map[int, cpp_vector[double]].iterator *> malloc(sizeof(map_ptr.begin()))
        itn[0] = map_ptr.begin()
        self.iter_now = itn

        cdef cpp_map[int, cpp_vector[double]].iterator * ite = <cpp_map[int, cpp_vector[double]].iterator *> malloc(sizeof(map_ptr.end()))
        ite[0] = map_ptr.end()
        self.iter_end = ite

    def __dealloc__(self):
        free(self.iter_now)
        free(self.iter_end)

    def __iter__(self):
        return self

    def __next__(self):
        cdef cpp_map[int, cpp_vector[double]].iterator inow = deref(self.iter_now)
        cdef cpp_map[int, cpp_vector[double]].iterator iend = deref(self.iter_end)

        if inow != iend:

            pyval = int(deref(inow).first)
        else:
            raise StopIteration

        inc(deref(self.iter_now))
        return pyval

cdef class _MapIntVectorDouble:
    def __cinit__(self, new_map=True, bint free_map=True):
        cdef pair[int, cpp_vector[double]] item
        cdef cpp_map[int, cpp_vector[double]] * map_ptr

        cdef cpp_vector[double] value_proxy
        cdef int ivalue
        cdef int value_size
        cdef double * value_data

        # Decide how to init map, if at all
        if isinstance(new_map, _MapIntVectorDouble):
            self.map_ptr = (<_MapIntVectorDouble> new_map).map_ptr
        elif isinstance(new_map, np.generic) and np.PyArray_DescrFromScalar(new_map).type_num == np.NPY_OBJECT:
            # scalars are copies, sadly not views, so we need to re-copy
            if self.map_ptr == NULL:
                self.map_ptr = new cpp_map[int, cpp_vector[double]]()
            np.PyArray_ScalarAsCtype(new_map, &map_ptr)
            self.map_ptr[0] = map_ptr[0]
        elif hasattr(new_map, 'items'):
            self.map_ptr = new cpp_map[int, cpp_vector[double]]()
            for key, value in new_map.items():

                # value is a ('vector', 'float64', 0)
                value_size = len(value)
                if isinstance(value, np.ndarray) and (<np.ndarray> value).descr.type_num == np.NPY_FLOAT64:
                    value_data = <double *> np.PyArray_DATA(<np.ndarray> value)
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = value_data[ivalue]
                else:
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = <double> value[ivalue]
                item = pair[int, cpp_vector[double]](<int> key, value_proxy)
                self.map_ptr.insert(item)
        elif hasattr(new_map, '__len__'):
            self.map_ptr = new cpp_map[int, cpp_vector[double]]()
            for key, value in new_map:

                # value is a ('vector', 'float64', 0)
                value_size = len(value)
                if isinstance(value, np.ndarray) and (<np.ndarray> value).descr.type_num == np.NPY_FLOAT64:
                    value_data = <double *> np.PyArray_DATA(<np.ndarray> value)
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = value_data[ivalue]
                else:
                    value_proxy = cpp_vector[double](<size_t> value_size)
                    for ivalue in range(value_size):
                        value_proxy[ivalue] = <double> value[ivalue]
                item = pair[int, cpp_vector[double]](<int> key, value_proxy)
                self.map_ptr.insert(item)
        elif bool(new_map):
            self.map_ptr = new cpp_map[int, cpp_vector[double]]()

        # Store free_map
        self._free_map = free_map

    def __dealloc__(self):
        if self._free_map:
            del self.map_ptr

    def __contains__(self, key):
        cdef int k

        if not isinstance(key, int):
            return False

        k = <int> key

        if 0 < self.map_ptr.count(k):
            return True
        else:
            return False

    def __len__(self):
        return self.map_ptr.size()

    def __iter__(self):
        cdef _MapIterIntVectorDouble mi = _MapIterIntVectorDouble()
        mi.init(self.map_ptr)
        return mi

    def __getitem__(self, key):
        cdef int k
        cdef cpp_vector[double] v

        cdef np.ndarray v_proxy
        cdef np.npy_intp v_proxy_shape[1]
        if not isinstance(key, int):
            raise TypeError("Only integer keys are valid.")

        k = <int> key

        if 0 < self.map_ptr.count(k):
            v = deref(self.map_ptr)[k]
            v_proxy_shape[0] = <np.npy_intp> deref(self.map_ptr)[k].size()
            v_proxy = np.PyArray_SimpleNewFromData(1, v_proxy_shape, np.NPY_FLOAT64, &deref(self.map_ptr)[k][0])
            return v_proxy
        else:
            raise KeyError

    def __setitem__(self, key, value):

        cdef cpp_vector[double] value_proxy
        cdef int ivalue
        cdef int value_size
        cdef double * value_data
        cdef pair[int, cpp_vector[double]] item

        # value is a ('vector', 'float64', 0)
        value_size = len(value)
        if isinstance(value, np.ndarray) and (<np.ndarray> value).descr.type_num == np.NPY_FLOAT64:
            value_data = <double *> np.PyArray_DATA(<np.ndarray> value)
            value_proxy = cpp_vector[double](<size_t> value_size)
            for ivalue in range(value_size):
                value_proxy[ivalue] = value_data[ivalue]
        else:
            value_proxy = cpp_vector[double](<size_t> value_size)
            for ivalue in range(value_size):
                value_proxy[ivalue] = <double> value[ivalue]
        item = pair[int, cpp_vector[double]](<int> key, value_proxy)
        if 0 < self.map_ptr.count(<int> key):
            self.map_ptr.erase(<int> key)
        self.map_ptr.insert(item)

    def __delitem__(self, key):
        cdef int k

        if key in self:

            k = <int> key
            self.map_ptr.erase(k)


class MapIntVectorDouble(_MapIntVectorDouble, collections.MutableMapping):
    """Wrapper class for C++ standard library maps of type <integer, vector [ndarray] of double>.
    Provides dictionary like interface on the Python level.

    Parameters
    ----------
    new_map : bool or dict-like
        Boolean on whether to make a new map or not, or dict-like object
        with keys and values which are castable to the appropriate type.
    free_map : bool
        Flag for whether the pointer to the C++ map should be deallocated
        when the wrapper is dereferenced.
    """

    def __str__(self):
        return self.__repr__()

    def __repr__(self):
        return "{" + ", ".join(["{0}: {1}".format(repr(key), repr(value)) for key, value in self.items()]) + "}"



