# -*- coding: utf-8 -*-
#
# metasci documentation build configuration file, created by
# sphinx-quickstart on Sun Feb  7 22:29:49 2010.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.
import os
import sys
import warnings

from pyne.utils import VnVWarning

warnings.simplefilter("ignore", VnVWarning)
# -- General configuration -----------------------------------------------------

sys.path.insert(0, os.path.dirname(__file__))

extensions = ['sphinx.ext.autodoc', 
              'sphinx.ext.doctest', 
              'sphinx.ext.pngmath', 
              'sphinx.ext.inheritance_diagram', 
              'sphinx.ext.autosummary',  # autosummary doesn't work with numpydoc...
              'sphinx.ext.viewcode', 
              'scisphinx.numpydoc', 
              'scisphinx.ipython_console_highlighting', 
              'breathe',
              'sphinxext.notebook_sphinxext', 
              'scisphinx.bibtex',
              ]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'PyNE'
copyright = u'2011-2014, The PyNE Development Team'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
sys.path.insert(0, os.path.dirname(os.path.dirname(__file__)))
from configure import INFO

version = INFO['version']
# The full version, including alpha/beta/rc tags.
release = INFO['version']
sys.path.pop(0)

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = []

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
#pygments_style = 'sphinx'
#pygments_style = 'friendly'
#pygments_style = 'bw'
#pygments_style = 'fruity'
#pygments_style = 'manni'
pygments_style = 'tango'


# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
#html_theme = 'default'
#html_theme = 'sphinxdoc'
#html_theme = 'altered_nature'
html_theme = 'cloud_pyne'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}
html_theme_options = {'sidebarbgcolor': '#F1FFF0',
                      'sidebartextcolor': '#864907',
                      'sidebarlinkcolor': '#A92727',
                      'sidebartrimcolor': '#504A4B',
                      'collapsiblesidebar': True, 
                      'relbarbgcolor': '#38761D',
                      'footerbgcolor': '#BED4EB',
                      'footertextcolor': '#504A4B',
                      'bodytrimcolor': '#80858a',
                      'linkcolor': '#A92727',
                      'textcolor': '#323039', 
                      'sectionbgcolor': '#864907',
                      #'sectiontextcolor': '#777777',
                      'sectiontrimcolor': '#f6fcfc', 
                      'codebgcolor': '#F1FFF0',
                      'codetextcolor': '#000000', 
                      'quotebgcolor': '#f6fcfc',
                      #'rubricbgcolor': '#D17519',
                      #'rubricbgcolor': '#69A74E',
                      'rubricbgcolor': '#996600',
                      #'min_height': 'bottom',
                      'googleanalytics_id': 'UA-37452818-1', 
                      }

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ["_theme"]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None
html_title = "{project} {release}".format(project=project, release=release)

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None
html_short_title = "{project}".format(project=project)

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = '../img/pyne_icon_small.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = '../img/pyne_icon.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_use_modindex = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'pynedoc'



# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
#latex_paper_size = 'letter'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('index', 'bright.tex', u'PyNE Documentation',
   u'The PyNE Development Team', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_use_modindex = True

# Autodocumentation Flags
autodoc_member_order = "groupwise"
autoclass_content = "both"
autosummary_generate = []


# C++ Autodocumentation Flags
breathe_projects = {"pyne": None,}
breathe_default_project = 'pyne'
breathe_domain_by_extension = {"h": "cpp",}
breathe_projects_source = {"pyne": '../cpp',}

for p in os.listdir(breathe_projects_source['pyne']):
    p, _ = os.path.splitext(p)
    breathe_projects['pyne_' + p] = breathe_projects['pyne']
    breathe_projects_source['pyne_' + p] = breathe_projects_source['pyne']

# Prevent numpy from making silly tables 
numpydoc_show_class_members = False


###############################################

# rxnames
from textwrap import TextWrapper
from prettytable import PrettyTable, FRAME
from pyne import rxname

tw = TextWrapper(initial_indent="    ", subsequent_indent="    ", 
                 break_long_words=False)
style = {"style": "margin-left:auto;margin-right:auto;"}
rxtab = PrettyTable(['reaction', 'id', 'description'])
rxtab.align['reaction'] = 'l'
rxtab.align['id'] = 'r'
rxtab.align['description'] = 'l'
for name in sorted(rxname.names):
    rxtab.add_row(["'" + name + "'", rxname.id(name), rxname.doc(name)])
rxtab = "\n".join(tw.wrap(rxtab.get_html_string(attributes=style)))

aliastab = PrettyTable(['alias', 'reaction'])
aliastab.align['alias'] = 'l'
aliastab.align['reaction'] = 'l'
for alias, rxid in sorted(rxname.altnames.items()):
    aliastab.add_row(["'" + alias + "'", "'" + rxname.name(rxid) + "'"])
aliastab = "\n".join(tw.wrap(aliastab.get_html_string(attributes=style)))

_rxname_rst = """**Reactions:**

.. raw:: html

    <div>
{0}
    </div>

**Reaction Aliases:**

.. raw:: html

    <div>
{1}
    </div>

""".format(rxtab, aliastab)

with open('rxname_listing', 'w') as f:
    f.write(_rxname_rst)
