#
# Copyright (C) 2011  Leo Singer
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from distutils.core import setup
from distutils.extension import Extension
import os.path
import os
import sys
import numpy


boostdir = os.getenv('BOOSTDIR')
if boostdir is None:
    boost_include_dirs = []
    boost_library_dirs = []
else:
    boost_include_dirs = [os.path.join(boostdir, 'include')]
    boost_library_dirs = [os.path.join(boostdir, 'lib')]


## {{{ http://code.activestate.com/recipes/502261/ (r1)
## But modified to throw an error if the package cannot be found.
def pkgconfig(*packages, **kw):
    import commands
    from distutils.errors import DistutilsExecError
    flag_map = {'-I': 'include_dirs', '-L': 'library_dirs', '-l': 'libraries'}
    status, output = commands.getstatusoutput("pkg-config --libs --cflags %s" % ' '.join(["'%s'" % s for s in packages]))
    if status != 0:
        raise DistutilsExecError("pkg-config: error %d\n%s" % (status, output))
    for token in output.split():
        kw.setdefault(flag_map.get(token[:2]), []).append(token[2:])
    return kw
## end of http://code.activestate.com/recipes/502261/ }}}


PACKAGE_VERSION = '0.7.2'


setup(
    name='pynds',
    version=PACKAGE_VERSION,
    author='Leo Singer',
    author_email='leo.singer@ligo.org',
    description='NDS1/NDS2 client',
    license='GNU General Public License Version 3',
    url='https://www.lsc-group.phys.uwm.edu/daswg/',
    download_url='https://www.lsc-group.phys.uwm.edu/daswg/download/software/source/',
    ext_modules=[
        Extension('nds', ['src/nds.cpp'],
            **pkgconfig('nds2-client >= 0.9.0c',
                include_dirs=[numpy.get_include()] + boost_include_dirs,
                library_dirs=boost_library_dirs,
                runtime_library_dirs=boost_library_dirs,
                libraries=['boost_python'],
				define_macros=[('PACKAGE_VERSION', '"%s"' % PACKAGE_VERSION)]
            )
        )
    ]
)
