import collections.abc
import contextlib
import pathlib
import queue
from py7zr.archiveinfo import Folder as Folder, Header as Header, SignatureHeader as SignatureHeader
from py7zr.callbacks import ExtractCallback as ExtractCallback
from py7zr.compressor import SupportedMethods as SupportedMethods, get_methods_names_string as get_methods_names_string
from py7zr.exceptions import Bad7zFile as Bad7zFile, CrcError as CrcError, DecompressionError as DecompressionError, InternalError as InternalError, UnsupportedCompressionMethodError as UnsupportedCompressionMethodError
from py7zr.helpers import ArchiveTimestamp as ArchiveTimestamp, MemIO as MemIO, NullIO as NullIO, calculate_crc32 as calculate_crc32, filetime_to_dt as filetime_to_dt, readlink as readlink
from py7zr.properties import DEFAULT_FILTERS as DEFAULT_FILTERS, MAGIC_7Z as MAGIC_7Z, get_default_blocksize as get_default_blocksize
from typing import Any, BinaryIO, Dict, IO, List, Optional, Union

FILE_ATTRIBUTE_UNIX_EXTENSION: int
FILE_ATTRIBUTE_WINDOWS_MASK: int

class ArchiveFile:
    id: Any = ...
    def __init__(self, id: int, file_info: Dict[str, Any]) -> None: ...
    def file_properties(self) -> Dict[str, Any]: ...
    @property
    def origin(self) -> pathlib.Path: ...
    @property
    def folder(self) -> Folder: ...
    @property
    def filename(self) -> str: ...
    @property
    def emptystream(self) -> bool: ...
    @property
    def uncompressed(self) -> List[int]: ...
    @property
    def compressed(self) -> Optional[int]: ...
    @property
    def crc32(self) -> Optional[int]: ...
    @property
    def archivable(self) -> bool: ...
    @property
    def is_directory(self) -> bool: ...
    @property
    def readonly(self) -> bool: ...
    def data(self) -> Optional[BinaryIO]: ...
    def has_strdata(self) -> bool: ...
    @property
    def is_symlink(self) -> bool: ...
    @property
    def is_junction(self) -> bool: ...
    @property
    def is_socket(self) -> bool: ...
    @property
    def lastwritetime(self) -> Optional[ArchiveTimestamp]: ...
    @property
    def posix_mode(self) -> Optional[int]: ...
    @property
    def st_fmt(self) -> Optional[int]: ...

class ArchiveFileList(collections.abc.Iterable):
    files_list: Any = ...
    index: int = ...
    offset: Any = ...
    def __init__(self, offset: int=...) -> None: ...
    def append(self, file_info: Dict[str, Any]) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> ArchiveFileListIterator: ...
    def __getitem__(self, index: Any): ...

class ArchiveFileListIterator(collections.abc.Iterator):
    def __init__(self, archive_file_list: Any) -> None: ...
    def __next__(self) -> ArchiveFile: ...

class ArchiveInfo:
    stat: Any = ...
    filename: Any = ...
    size: Any = ...
    header_size: Any = ...
    method_names: Any = ...
    solid: Any = ...
    blocks: Any = ...
    uncompressed: Any = ...
    def __init__(self, filename: Any, stat: Any, header_size: Any, method_names: Any, solid: Any, blocks: Any, uncompressed: Any) -> None: ...

class FileInfo:
    filename: Any = ...
    compressed: Any = ...
    uncompressed: Any = ...
    archivable: Any = ...
    is_directory: Any = ...
    creationtime: Any = ...
    crc32: Any = ...
    def __init__(self, filename: Any, compressed: Any, uncompressed: Any, archivable: Any, is_directory: Any, creationtime: Any, crc32: Any) -> None: ...

class SevenZipFile(contextlib.AbstractContextManager):
    mp: Any = ...
    password_protected: Any = ...
    filename: Any = ...
    fp: Any = ...
    mode: Any = ...
    encoded_header_mode: bool = ...
    header_encryption: Any = ...
    worker: Any = ...
    dereference: Any = ...
    reporterd: Any = ...
    q: Any = ...
    def __init__(self, file: Union[BinaryIO, str, pathlib.Path], mode: str=..., *, filters: Optional[List[Dict[str, int]]]=..., dereference: Any=..., password: Optional[str]=..., header_encryption: bool=..., blocksize: Optional[int]=..., mp: bool=...) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
    class ParseStatus:
        src_pos: Any = ...
        folder: int = ...
        outstreams: int = ...
        input: int = ...
        stream: int = ...
        def __init__(self, src_pos: int = ...) -> None: ...
    def set_encoded_header_mode(self, mode: bool) -> None: ...
    def set_encrypted_header(self, mode: bool) -> None: ...
    def getnames(self) -> List[str]: ...
    def archiveinfo(self) -> ArchiveInfo: ...
    def needs_password(self) -> bool: ...
    def list(self) -> List[FileInfo]: ...
    def readall(self) -> Optional[Dict[str, IO[Any]]]: ...
    def extractall(self, path: Optional[Any]=..., callback: Optional[ExtractCallback]=...) -> None: ...
    def read(self, targets: Optional[List[str]]=...) -> Optional[Dict[str, IO[Any]]]: ...
    def extract(self, path: Optional[Any]=..., targets: Optional[List[str]]=...) -> None: ...
    def reporter(self, callback: ExtractCallback) -> Any: ...
    def writeall(self, path: Union[pathlib.Path, str], arcname: Optional[str]=...) -> Any: ...
    def write(self, file: Union[pathlib.Path, str], arcname: Optional[str]=...) -> Any: ...
    def writed(self, targets: Dict[str, IO[Any]]) -> None: ...
    def writef(self, bio: IO[Any], arcname: str) -> Any: ...
    def writestr(self, data: Union[str, bytes, bytearray, memoryview], arcname: str) -> Any: ...
    def close(self) -> None: ...
    def reset(self) -> None: ...
    def test(self) -> Optional[bool]: ...
    def testzip(self) -> Optional[str]: ...

def is_7zfile(file: Union[BinaryIO, str, pathlib.Path]) -> bool: ...
def unpack_7zarchive(archive: Any, path: Any, extra: Optional[Any] = ...) -> None: ...
def pack_7zarchive(base_name: Any, base_dir: Any, owner: Optional[Any] = ..., group: Optional[Any] = ..., dry_run: Optional[Any] = ..., logger: Optional[Any] = ...) -> None: ...

class Worker:
    target_filepath: Any = ...
    files: Any = ...
    src_start: Any = ...
    header: Any = ...
    current_file_index: Any = ...
    last_file_index: Any = ...
    concurrent: Any = ...
    def __init__(self, files: Any, src_start: int, header: Any, mp: Any=...) -> None: ...
    def extract(self, fp: BinaryIO, parallel: bool, skip_notarget: Any=..., q: Any=...) -> None: ...
    def extract_single(self, fp: Union[BinaryIO, str], files: Any, src_start: int, src_end: int, q: Optional[queue.Queue], exc_q: Optional[queue.Queue]=..., skip_notarget: Any=...) -> None: ...
    def decompress(self, fp: BinaryIO, folder: Any, fq: IO[Any], size: int, compressed_size: Optional[int], src_end: int) -> int: ...
    def write(self, fp: BinaryIO, f: Any, assym: Any, folder: Any) -> Any: ...
    def writestr(self, fp: BinaryIO, f: Any, folder: Any) -> Any: ...
    def prepare_archive(self) -> None: ...
    def flush_archive(self, fp: Any, folder: Any) -> None: ...
    def archive(self, fp: BinaryIO, files: Any, folder: Any, deref: Any=...) -> Any: ...
    def register_filelike(self, id: int, fileish: Union[MemIO, pathlib.Path, None]) -> None: ...
