import abc
from abc import ABC, abstractmethod
from typing import Any

class Callback(ABC, metaclass=abc.ABCMeta):
    @abstractmethod
    def report_start_preparation(self) -> Any: ...
    @abstractmethod
    def report_start(self, processing_file_path: Any, processing_bytes: Any) -> Any: ...
    @abstractmethod
    def report_end(self, processing_file_path: Any, wrote_bytes: Any) -> Any: ...
    @abstractmethod
    def report_warning(self, message: Any) -> Any: ...
    @abstractmethod
    def report_postprocess(self) -> Any: ...

class ExtractCallback(Callback, metaclass=abc.ABCMeta): ...
class ArchiveCallback(Callback, metaclass=abc.ABCMeta): ...
