# pyright: reportPrivateUsage=false

from __future__ import annotations

from typing import Collection, Generic, Iterable, Iterator, TypeVar, overload

from typing_extensions import Self

from .. import _types as _t
from . import CDATA

_T = TypeVar("_T")

# Behaves like MutableMapping but deviates a lot in details
class _Attrib:
    def __bool__(self) -> bool: ...
    def __contains__(self, __o: object) -> bool: ...
    def __delitem__(self, __k: _t._AttrName) -> None: ...
    def __getitem__(self, __k: _t._AttrName) -> str: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    def __setitem__(self, __k: _t._AttrName, __v: _t._AttrVal) -> None: ...
    @property
    def _element(self) -> _Element: ...
    def get(self, key: _t._AttrName, default: _T) -> str | _T: ...
    def has_key(self, key: _t._AttrName) -> bool: ...
    def items(self) -> list[tuple[str, str]]: ...
    def iteritems(self) -> Iterator[tuple[str, str]]: ...
    def iterkeys(self) -> Iterator[str]: ...
    def itervalues(self) -> Iterator[str]: ...
    def keys(self) -> list[str]: ...
    def values(self) -> list[str]: ...

class _Element:
    @overload
    def __getitem__(self, __x: int) -> _Element: ...
    @overload
    def __getitem__(self, __x: slice) -> list[_Element]: ...
    def __contains__(self, __o: object) -> bool: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[_Element]: ...
    def addprevious(self, element: _Element) -> None: ...
    def append(self, element: _Element) -> None: ...
    @property
    def attrib(self) -> _Attrib: ...
    def find(self, path: _t._ElemPathArg) -> Self | None: ...
    def findall(
        self, path: _t._ElemPathArg, namespaces: _t._NSMapArg | None = None
    ) -> list[_Element]: ...
    @overload
    def get(self, key: _t._AttrName) -> str | None: ...
    @overload
    def get(self, key: _t._AttrName, default: _T) -> str | _T: ...
    def getparent(self) -> _Element | None: ...
    def index(self, child: _Element, start: int | None = None, end: int | None = None) -> int: ...
    def iterancestors(
        self, *, tag: _t._TagSelector | Collection[_t._TagSelector] | None = None
    ) -> Iterator[Self]: ...
    @overload
    def iterchildren(
        self, *tags: _t._TagSelector, reversed: bool = False
    ) -> Iterator[_Element]: ...
    @overload
    def iterchildren(
        self,
        *,
        tag: _t._TagSelector | Iterable[_t._TagSelector] | None = None,
        reversed: bool = False,
    ) -> Iterator[_Element]: ...
    @overload
    def itertext(self, *tags: _t._TagSelector, with_tail: bool = True) -> Iterator[str]: ...
    @overload
    def itertext(
        self,
        *,
        tag: _t._TagSelector | Collection[_t._TagSelector] | None = None,
        with_tail: bool = True,
    ) -> Iterator[str]: ...
    def remove(self, element: _Element) -> None: ...
    def set(self, key: _t._AttrName, value: _t._AttrVal) -> None: ...
    @property
    def tag(self) -> str: ...
    @property
    def tail(self) -> str | None: ...
    @property
    def text(self) -> str | None: ...
    @text.setter
    def text(self, value: str | CDATA | None) -> None: ...
    def xpath(
        self,
        _path: str,
        /,
        namespaces: _t._NonDefaultNSMapArg | None = None,
    ) -> _t._XPathObject: ...

class _ElementTree(Generic[_t._ET_co]): ...
