@page CHANGES-2-4 Version 2.4

## Version 2.4 (Dec 15, 2017)

Version 2.4 contains several improvements with respect to 2.3. Users currently working with 2.3
should have a look at the section "Changes leading to incompatible behavior" below and
might need tiny adjustments in their input files.
Notice that version 2.4 includes already all the fixes in branch 2.3 up to 2.3.3 indicated in \ref CHANGES-2-3 .

Changes from version 2.3 which are relevant for users:
- Changes leading to incompatible behavior:
  - A c++11 compliant compiler is required (see \issue{212}). This should mean:
    - gcc 4.8
    - clang 3.3
    - intel 15
    Since the number of c++11 features that we use is limited, older compilers might work as well.
  - The meaning of BIASFACTOR=1 in \ref METAD has been modified and can now be used to indicate unbiased
    simulations. Non-well-tempered metadynamics is BIASFACTOR=-1, which is the new default value.
    Notice that this has an implication on the bias factor written in the HILLS file when doing
    non-well-tempered metadynamics.
  - Due to a change in \ref COMMITTOR, the format of its output file has been slightly changed.
  - \ref HISTOGRAM : When using weights default is now to output histogram divided by number of frames from which data was taken.  In addition the 
    UNORMALIZED flag has been replaced with the keyword NORMALIZATION, which can be set equal to true, false or ndata.
  - All switching functions are now stretched by default, also when using the "simple syntax" (e.g. `COORDINATION NN=6`).
    Switching functions were already stretched by default when using the advanced syntax (e.g. `COORDINATION SWITCH={}`)
    since version 2.2.  Notice that this will introduce small numerical differences in the computed switching functions.
- New modules:
  - A new PLUMED-ISDB module have been included, this module includes a number of CVs to calculate experimental data with the internal ability
    to also calculate a \ref METAINFERENCE score.
    - New actions include:
      - \ref EMMI
      - \ref SAXS
      - \ref RESCALE, \ref SELECT, \ref SELECTOR
    - Updated actions include:
      - \ref CS2BACKBONE
      - \ref FRET
      - \ref JCOUPLING
      - \ref METAINFERENCE
      - \ref NOE
      - \ref PRE
      - \ref RDC, \ref PCS
      - \ref PBMETAD
  - A new EDS module have been included, contributed by Glen Hocky and Andrew White.
    This module implements the following methods:
    - \ref EDS
  - A new DRR module have been included, contributed by Haochuan Chen and Haohao Fu.
    This module implements the following methods:
    - \ref DRR
    - \ref drr_tool
  - A new VES module have been included, contributed by Omar Valsson.
    This module implements the following methods:
    - \ref BF_CHEBYSHEV
    - \ref BF_COMBINED
    - \ref BF_COSINE
    - \ref BF_CUSTOM
    - \ref BF_FOURIER
    - \ref BF_LEGENDRE
    - \ref BF_POWERS
    - \ref BF_SINE
    - \ref OPT_AVERAGED_SGD
    - \ref OPT_DUMMY
    - \ref TD_CHI
    - \ref TD_CHISQUARED
    - \ref TD_CUSTOM
    - \ref TD_EXPONENTIAL
    - \ref TD_EXPONENTIALLY_MODIFIED_GAUSSIAN
    - \ref TD_GAUSSIAN
    - \ref TD_GENERALIZED_EXTREME_VALUE
    - \ref TD_GENERALIZED_NORMAL
    - \ref TD_GRID
    - \ref TD_LINEAR_COMBINATION
    - \ref TD_PRODUCT_COMBINATION
    - \ref TD_PRODUCT_DISTRIBUTION
    - \ref TD_UNIFORM
    - \ref TD_VONMISES
    - \ref TD_WELLTEMPERED
    - \ref VES_LINEAR_EXPANSION
    - \ref VES_OUTPUT_BASISFUNCTIONS
    - \ref VES_OUTPUT_FES
    - \ref VES_OUTPUT_TARGET_DISTRIBUTION
    - \ref ves_md_linearexpansion
- New collective variables:
  - \ref DIMER (thanks to Marco Nava).
  - \ref EEFSOLV : EEF1 implicit solvent solvation energy
  - \ref ADAPTIVE_PATH : Adaptive path variables using the method from \cite BerndAdaptivePath
- New actions:
  - \ref INENVELOPE
  - \ref TOPOLOGY_MATRIX
  - \ref BOND_DIRECTIONS
  - \ref DUMPGRAPH
  - \ref GRID_TO_XYZ
  - \ref INTEGRATE_GRID
  - \ref LWALLS
  - \ref MAXENT
  - \ref MCOLV_COMBINE
  - \ref MCOLV_PRODUCT
  - \ref POLYMER_ANGLES
  - \ref XANGLES , \ref YANGLES , \ref ZANGLES
  - \ref XYTORSIONS , \ref XZTORSIONS , \ref YXTORSIONS , \ref YZTORSIONS , \ref ZXTORSIONS , and \ref ZYTORSIONS
- New command line tools:
  - \ref pesmd : Tool for performing Langevin dynamics on an energy landscape that is specified using a PLUMED input file
  - \ref pathtools 
- Other changes:
  - Sharing coordinates and applying force is now faster (in some cases these can result in much better scaling of the performances in parallel).
  - \ref COMMITTOR : new flag to use committor to keep track of the visited basins without stopping the simulation
  - \ref PBMETAD : multiple walkers using files (thanks to Marco De La Pierre).
  - \ref PBMETAD : adaptive Gaussian kernels
  - \ref PBMETAD : default names for GRID and FILE (useful with many collective variables) 
  - \ref METAD : BIASFACTOR=1 is allowed and performs unbiased sampling. HILLS file can be used
    to recover free energy also in this case.
  - \ref METAD : a RECT option is available that allows setting an array of bias factors, one for each replica.
  - \ref METAD : added options to perform Transition Tempered Metadynamics (thanks to James Dama)
  - \ref PATHMSD and \ref PROPERTYMAP now support alignment to a close structure (thanks to Jana Pazurikova)
  - PDB files with more than 100k atoms can now be read using [hybrid 36](http://cci.lbl.gov/hybrid_36/) format,
    see \issue{226}.
  - Added lepton support. Set env var `export PLUMED_USE_LEPTON=yes` to activate lepton as a matheval replacement
    in \ref MATHEVAL, \ref CUSTOM, and \ref switchingfunction "MATHEVAL switching function".
    Notice that in v2.5 matheval support will be dropped and all these keywords will use lepton.
    See \issue{244}.
  - When parsing constants, PLUMED uses lepton library. This allows to pass
    arguments such as `HEIGHT=exp(0.5)` (see \ref parsing-constants).
  - \ref CUSTOM function has been added as an alias to \ref MATHEVAL .
  - Trajectories read in \ref driver also support the usual replica convention, that is if
    trajectory with replica suffix is not found the driver will look for a trajectory without the replica suffix.
  - A new syntax (`@replicas:`) can be used to specify different arguments for different replicas (see \ref special-replica-syntax).
  - Internal molfile implementation has been updated to VMD 1.9.3.
  - Examples in the documentation now have syntax highlighting and links to the documentation of used actions.
  - \ref COORDINATIONNUMBER : Added option to have pairwise distance moments of coordination number in the multicolvar module
  - GROMACS patch updated to gromacs-2016.4
  - Implemented HREX for gromacs-2016.4.
  - Added patch for Quantum ESPRESSO 6.2 (thanks to Ralf Meyer).
  - Fixed a bug in \ref LOCAL_AVERAGE which appears when you use SPECIESA and SPECIESB keywords instead of just SPECIES
  - Added possibility to pass `--kt` from \ref driver.

Changes from version 2.3 which are relevant for developers:
  - A few fixes has been made to improve exception safety. Although we still cannot declare
    PLUMED totally exception safe (there are still many non-safe pointers around),
    this made it possible to add a regtest that actually tests erroneous cmd strings
    and erroneous inputs.
  - Due to the required c++11 support, travis-ci test on Ubuntu Precise has been removed.
  - `gettimeofdate` and `gettime` have been replaced with portable `chrono` classes introduced in c++11.
  - C++ exceptions are enabled by default.
  - A large number of loops have been changed to use the `auto` keyword in order to improve code readability.
  - Stack trace is not written upon error anymore, unless environment variable `PLUMED_STACK_TRACE` is set at runtime.
  - Fixed a potential bug using single precision system BLAS on a mac (notice that currently plumed only uses
    double precision, so it is harmless).
  - Added `--enable-rpath` option for autoconf (off by default).
  - Files related to changelog are now stored as `.md` files. This makes
    it possible to navigate them from github.
  - `configure.ac` has been simplified and improved in order to more easily probe C++ libraries.
  - added `plumed_custom_skip` function to regtests in order to skip specific tests based on specific conditions (e.g. OS).
  - environment variable `LDSO` has been renamed to `LDSHARED`, which is standard in the python community.
  - a `libplumedWrapper.a` library is installed as well, that is used in `--runtime` patching.
  - pkgconfig files are installed.
  - `plumed config makefile_conf` can be used to retrieve `Makefile.conf` file a posteriori.
  - Store `MPIEXEC` variable at configure time and use it later for running regtests. Notice that in case
    `MPIEXEC` is not specified regtests will be run using the command stored in env var `PLUMED_MPIRUN` or, if this is
    also not defined, using `mpirun`.
  - Added canonical Makefile targets `check` and `installcheck`. Notice that `check` runs checks with
    non-installed plumed whereas `installcheck` uses the installed one, including its correct program name if it
    was personalized (e.g. with suffixes). Notice that this modifies the previously available `check` target.
    
    
## Version 2.4.1 (Mar 2, 2018)

For users:
  - Fixed an important bug affecting RMSD calculations with compilers supporting OpenMP 4 (e.g.: intel compiler). Notice that this bug might potentially affect not only
    \ref RMSD variable, but also \ref PATHMSD variables using RMSD, \ref FIT_TO_TEMPLATE, \ref PCAVARS, and possibly other variables based on RMSD calculations and optimal alignments
    (see \issue{343}). Results might depend on the exact architecture and on how aggressive is the compiler. The bug is a consequence of some erroneous SIMD directives introduced in 2.4.0, so it does not affect PLUMED 2.3.x. 
  - Resolved a problem with \ref CS2BACKBONE and glycine atom names.
  - Module VES: Fixed a bug with basis functions that have a constant function different from 1 (e.g. scaled version of the Legendre basis functions, \ref BF_LEGENDRE) that was causing a time-dependent shift in the bias potential.
  - Module VES: In optimizers (\ref OPT_AVERAGED_SGD and \ref OPT_DUMMY) the output of quantities related to the instantaneous gradients are now off by default as these quantities are generally not useful for normal users, their output can instead by re-enabled by using the MONITOR_INSTANTANEOUS_GRADIENT keyword. Also added an keyword MONITOR_AVERAGE_GRADIENT that allows to monitor the averaged gradient and output quantities related to it. 
  - \ref RMSD variable and other collective variables using reference PDB files now crash when zero weights are passed (see \issue{247}).
  - Using \ref COM with \ref driver without passing masses now triggers an error instead of reporting NaNs (see \issue{251}).

For developers:
  - `plumed patch -p` command can be used twice without triggering an error. This will allow e.g. building again
    on MacPorts in cases where the build was interrupted. Notice that this only works for patches without special
    after/before patch/revert functions.

## Version 2.4.2 (Jul 2, 2018)

For users:
  - All fixes done in version 2.3.6. Notice that \issue{363} in version 2.4 also applies to \ref pathtools.
  - Additional residue names (without the prefix `D`) are now supported by \ref MOLINFO for DNA. See \issue{367}.
  - Solved an important bug appearing in NAMD interface. Notice that the bug was a regression introduced in 2.4.0. As consequence, versions <= 2.3 and versions >=2.4.2
    are expected to work correctly. See \issue{254}.
  - GROMACS patch for gromacs-2018.1.
  - \ref VimSyntax now highlights `__FILL__` strings.
  - \ref METAD and \ref PBMETAD give a warning when one restarts a simulation and the old hills file is not found. See \issue{366}.

For developers:
  - `LDSHARED` is now correctly taken into account when launching `./configure`.
  - Fixed installation with `--disable-shared`.
  - Cppcheck upgraded to 1.84.

## Version 2.4.3 (Oct 5, 2018)

For users:
  - All fixes done in version 2.3.7.
  - Module VES: Fixed a bug in TD_GRID for 2D grids where the grid spacing is not the same for both dimensions.
  - GROMACS patch for gromacs-2018.3.

## Version 2.4.4 (Dec 19, 2018)

For users:
  - Fixed some performances regression issue with OpenMP
  - Updated NAMD patches to version 2.12 and 2.13. Old patches have been removed.
  - GROMACS patch for gromacs-2018.4.
  - Fixed a thread safety issue using forces on \ref HISTOGRAM 
  - Fixed error message suggesting wrong actions (see \issue{421}).

For developers:
  - All fixed done in version 2.3.8
  - CPPCHECK updated to 1.85

## Version 2.4.5 (Apr 1, 2019)

For users:
  - Fixed an inconsistency in parsing of braces.
    It is now possible to pass individual options
    including spaces (e.g. with `FILE={/path with space/file}`). Notice 
    that this invalidates syntax such as `ATOMS={1}{2}{3}{4}`. See more
    at \issue{434}.
  - Fixed \ref simplemd so as to call "runFinalJobs" at the end of the simulation.
  - GROMACS patch for gromacs-2016.6.
  - GROMACS patch for gromacs-2018.6.
  - Added aliases for some actions/options containing dashes (`-`) in their name. This will improve
    backward compatibility when these actions/options will be removed (see \issue{449}).

## Version 2.4.6 (Jul 19, 2019)

For users:
  - Fixed a bug in \ref COORDINATIONNUMBER where derivatives were wrong when using R_POWER > 2, thanks to `@MoleOrbitalHybridAnalyst` for spotting and fixing
  - Fixed a bug in library search, possibly affecting linked blas/lapack on OSX (see \issue{476}).
  - Fixed a bug in \ref METAD with `TARGET` and `GRID_SPARSE` (see \issue{467}).

## Version 2.4.7 (Jan 27, 2020)

\plumednotmaintained

For users:
  - Fixed a bug with \ref CONVERT_TO_FES and periodic variables, see \issue{441} (backported from v2.5.3).
  - More robust backup for output files when running over multiple processes
  - Fixed a regression in the performances of GEOMETRY based flexible hills in \ref METAD and \ref PBMETAD
  - Fixed \issue{538}.
  - Fixed potential issue with VMD plugins from 1.9.4 (\issue{545}, thanks to Lixin Sun).
  - Module VES: Fixed an off-by-one bug in the output of target distribution averages. The bug only affects the output and does not affect results. The bug also affected the output of coefficients when using a bias cutoff. 
  - Module VES: Made sure that all relevant output files are written out at the final step when shutting down the simulation. This solves issues reported by @PabloPiaggi with restarting when there is a mismatch been the output of files and the number of MD steps. 


