summary="CoreFoundation Property List (.plist) and ISO 8601 date string parser"

longdesc="""Reads and writes CoreFoundation XML property lists (.plist files) using an 
interface similar to Cocoa's NSPropertyListSerialization.

Includes Cocoa-style Data and Date (datetime) classes. The Date class includes 
an ISO8601 string parser and implements NSDate reference-date methods."""

if __name__ == '__main__':

	from distutils.core import setup, Extension
	
	def readstuff(filename, default):
		result = default
		
		# i hate exceptions.
		try:
			foo = file(filename)
			try: 	 result = foo.read()
			finally: foo.close()
		except:
			import sys, traceback
			print >>sys.stderr, "Can't get %s of plistservices! Using %s. Exception info follows," % (filename, default)
			traceback.print_exc()
			
		return result
	
	
	version = readstuff('VERSION', '0').strip()
		
	setup(name="plistservices",
		  version=version,
		  description=summary,
		  long_description=longdesc,
		  author="Sarwat Khan",
		  author_email="python@sarwat.net",
		  url="http://sarwat.net/opensource/",
		  license="BSD-ish",
		  py_modules=["plistservices"])

