###########################################################################
#    Copyright (C) 2004 by John B. Cole, PhD
#    <jcole@aipl.arsusda.gov>
#
# Copyright: See COPYING file that comes with this distribution
###########################################################################

from distutils.core import setup
setup(name="PyPedal",
      version="2.0.0a7",
      summary="Tools for pedigree analysis",
      description="Tools for pedigree analysis",
      long_description="PyPedal provides an API that may be used to maniuplate pedigrees in a number of ways.  Key metrics include coefficients of inbreeding and relationship; effective founder and ancestor numbers; and expected inbreeding from a given mating.  If you have Graphviz and dotpy installed, PyPedal can be used to produce a graph from your pedigree.",
      packages=["PyPedal"],
      author="John B. Cole, PhD",
      author_email="jcole@aipl.arsusda.gov",
      url="http://pypedal.sourceforge.net/",
      license="GNU LGPL",
      platform="POSIX, Windows",
      classifiers=[
         'Development Status :: 3 - Alpha',
         'Environment :: Console',
         'Intended Audience :: Education',
         'Intended Audience :: Science/Research',
         'Natural Language :: English',
         'Operating System :: Microsoft :: Windows',
         'Operating System :: POSIX :: Linux',
         'Programming Language :: Python',
         'Topic :: Scientific/Engineering :: Information Analysis',
         'Topic :: Scientific/Engineering :: Mathematics',
      ],
)
