# This file auto-generated by tools/get-R-crs-test-vectors.R
# Using: R version 3.0.3 (2014-03-06) and package 'mgcv' version 1.7.28
import numpy as np
R_crs_test_x = np.array([1, -1.5, 2.25, -3.375, 5.0625, -7.59375, 11.390625, -17.0859375, 25.628906250000000000, -38.443359375000000000, 57.665039062500000000, -86.497558593750000000, 129.74633789062500000, -194.6195068359375, 291.92926025390625000, -437.89389038085937500, 656.84083557128906250, -985.26125335693359375, 1477.8918800354003906, -2216.8378200531005859, ])
R_crs_test_data = """
--BEGIN TEST CASE--
spline_type=cr
nb_knots=4
knots=None
absorb_cons=FALSE
output=np.array([-1.693557754132211208e-05, -1.9836972061171899575e-05, -1.4954358368392469422e-05, -2.088026100812221311e-05, -9.5355264085171175196e-06, -1.8699295604068575353e-05, 4.9022718833308546933e-06, 1.7974067511175931267e-05, 3.744122291002612696e-05, 0.0002988262983956019303, 0.00010718085083579747424, 0.001935560671294481172, 0.00024699248283329116715, 0.010566342124751632037, 0.00048044994314723433668, 0.053454984128479515748, 0.00065729103443297996496, 0.25076507420610638643, 0, 1, 0.35560680685948470314, 0.46359416252769836131, 0.30168882277557279581, 0.54466866236250932598, 0.18063664369405590948, 0.72711735964503432239, -0.089776348720933471514, 1.1356863997659447652, -0.68566908660007752641, 2.0361466894716735432, -1.9628257407671605428, 3.9650378336575471394, -4.523225924226894179, 7.8266636243390204086, -8.7985820993738865781, 14.246329329102128014, -12.037110654561336887, 18.944322912930825709, 0, 0, 0.6444562685323340645, 0.53647236902629924504, 0.69836999393477805498, 0.45539628464397530205, 0.81940601333710849641, 0.27293213874197075341, 1.0897461189737138731, -0.13572091900106228457, 1.6852766572444068949, -1.0365718798973906356, 2.9606222279687766097, -2.967335129700412466, 5.5120421008950604147, -6.8380635660933348774, 9.743925990387539926, -13.301405831788731149, 12.784702352769150124, -18.197306344378148424, 0, 0, -4.6139814277377641984e-05, -4.6694581936484837246e-05, -4.3862351982477081188e-05, -4.4066745476440737986e-05, -3.3121504755945730075e-05, -3.0799091401098394798e-05, 2.5327475336172373395e-05, 1.6545167606241587368e-05, 0.00035498813276064257764, 0.00012636412732133810903, 0.0020963319475481821674, 0.00036173537157081639762, 0.010936830849001568516, 0.00083359962956235762136, 0.054175659043200374843, 0.0016215185581219158321, 0.25175101075775591086, 0.0022183572412113072327, 1, 0, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=7
knots=None
absorb_cons=FALSE
output=np.array([-2.9605259404128104445e-07, 4.3004543792069181325e-07, -4.6506508782294522313e-07, 1.2225175036037286749e-06, -4.8490441759023038782e-07, 2.7062259965304665474e-06, 2.8104230735656565092e-07, -5.4449455566502238182e-06, 1.7542735683802410547e-06, -0.00011038827024139799939, 2.8120883750482203265e-06, -0.00053376130083573273665, -7.6784755538918750706e-07, 0.00061879177472234751789, -9.2078635815506674409e-06, 0.029574116402683980898, -1.6901017048743381161e-05, 0.21556638245963724576, 0, 1, 0.00010456869825724268133, -0.00015189629322606839636, 0.00016426557921581520349, -0.00043180524853199072667, 0.00017127302630398999017, -0.000955865732450367038, -9.9266916848531769006e-05, 0.0019305664182940607265, -0.00061962673904836988552, 0.042415216868389754579, -0.00099325736940550032363, 0.27732557133728741317, 0.00027121133522598855859, 1.1504608369631013076, 0.0032523082987030572759, 2.7821404636666882126, 0.0059696060348119403538, 4.1098324719022825136, 0, 0, -0.031642380707528651451, 0.046727930564370717681, -0.049706595580857972083, 0.14260551573254778845, -0.051827041873556585483, 0.44422176162356585838, 0.030038067097830360025, 1.2696071710389067455, 0.18749841492049976188, 2.6526069738107440621, 0.30055865997270758694, 3.4401400654673524038, -0.082068271523342908869, -0.89294447099362916909, -0.98414515128277502143, -10.707999025460104292, -1.8063966557448927208, -19.65451295888456329, 0, 0, 0.9404055233767310007, 1.0229997547271381109, 0.84839014691027592185, 0.9942253298077886603, 0.55270681506501917468, 0.71325376394101502875, -0.27008001161472772189, -0.36441609214674652861, -1.6858466263672904351, -2.2746949537899268101, -2.7024004611201863923, -3.6463202499480562579, 0.73789700429246496416, 0.99563659340566201816, 8.8487029815652924469, 11.939460983544531558, 16.241778413219694954, 21.914859168852931504, 0, 0, 0.091452250263845791256, -0.069826465452058242289, 0.20181123367547218472, -0.13689085681302756714, 0.50012121362724204499, -0.15708533369949770342, 1.2380919977577322655, 0.093217876961678852732, 2.4558884227495125785, 0.58186847095202909319, 3.1248015911458146832, 0.93273112726773044212, -0.80684053529361110524, -0.25468449792074498994, -9.6754590529148973843, -3.0541220021223365322, -17.759287695723489975, -5.6058354437652431201, 0, 0, -0.00032057317842933900735, 0.00025095691201626593508, -0.0006604553857512240455, 0.00049198690620599915858, -0.0011751018630891821651, 0.00056456602826813432217, 0.0020547291059278675364, -0.00033502584436379451204, 0.043190243671805170211, -0.002091240244288253107, 0.27856793393313283858, -0.0033522436217435750035, 1.1501216068412509763, 0.00091533825638770416853, 2.7780724886333088008, 0.010976540508122837117, 4.1023657110424904815, 0.02014742036749034293, 0, 0, 9.0759971803981566744e-07, -7.1050367876085636178e-07, 1.8698667331515860834e-06, -1.392902486538716717e-06, 3.3269224981118857968e-06, -1.5983868974364642471e-06, -5.7964722216058981582e-06, 9.4851778732840647118e-07, -0.00011258250904733756745, 5.9206732932833133743e-06, -0.00053727865043814320746, 9.4907982657877548258e-06, 0.00061975219556745361413, -2.5914854994384806915e-06, 0.029585633563949290115, -3.1076539587733474873e-05, 0.21558752218843252324, -5.7040932539508893209e-05, 1, 0, ]).reshape((20, 7, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=10
knots=None
absorb_cons=FALSE
output=np.array([1.9320747025477182898e-08, 4.8242814281426965595e-08, -1.2568948282371909281e-08, -7.8978523641721503504e-08, -3.5770522726027550527e-08, -7.01473863118866388e-07, 2.1638270976696590321e-08, 2.2109425903379564006e-06, 8.5370349850805669926e-08, 3.744561791897189516e-05, -3.2925418782971613435e-08, -7.9813891850179092256e-05, -1.991767035296446912e-07, -0.0021868285157625511929, 3.7614188014338205365e-08, 0.0021874060835819046644, 4.688717754303082178e-07, 0.15874967738905676473, 0, 1, -1.4544731165165144453e-06, -3.6317372379498608116e-06, 9.4619516292459995175e-07, 5.9455330204143990165e-06, 2.6928184298539113977e-06, 5.2807216744776855019e-05, -1.6289371928530509096e-06, -0.00016644059132742171966, -6.4267121060004543239e-06, -0.002818920227187673988, 2.4786379329293728427e-06, 0.0060407977628119044478, 1.4994097295422416361e-05, 0.20920617714101982787, -2.8316102474873858596e-06, 1.0967921747761912865, -3.5296843934527352639e-05, 2.0750595382021144175, 0, 0, 9.7994633378747003421e-05, 0.00024468706579685965685, -6.3749578484895432179e-05, -0.00040057827261335182721, -0.00018142772925296013898, -0.0035578683345143034648, 0.00010974909140496827962, 0.011347453981486406438, 0.00043299755045772883848, 0.2521011214081396723, -0.00016699739084748591402, 1.1986460188118959191, -0.0010102222245463542399, 2.0307158061521746184, 0.00019077878093656664284, -0.33272379892704945226, 0.0023781128997935555708, -4.1474987648643217852, 0, 0, -0.0066281488228501295526, -0.016550113319571305159, 0.0043118860597063267057, 0.027486913394933615296, 0.012271386183288513286, 0.32813715189346348566, -0.007423195392682361074, 1.293350915313034033, -0.029287034456989179121, 1.9521712704316960263, 0.011295348749219022086, -0.66799495509124628967, 0.068329285161611297283, -4.0409215143626093791, -0.012903871453880378511, 0.76312128325689243535, -0.16085050450109564246, 9.5125283792626493806, 0, 0, 0.14341751361350341121, 0.77593360542645228861, -0.090432986778547594375, 1.1259563994195789238, -0.25736721450922656063, 1.1109363559631879603, 0.15568633342939960928, -0.56801737059939128027, 0.61423561827887318554, -2.241022016113413784, -0.23689682657495314544, 0.86431165517469521475, -1.4330669354534046889, 5.2285058979714911231, 0.27063229881828543277, -0.9873946118959923135, 3.3735101868301691219, -12.308160541801825616, 0, 0, 0.88922814381914494497, 0.26150528401135941792, 1.052718109833140403, -0.16738921270899279059, 0.90250428645253855109, -0.47638032258407536634, -0.44193283907468589033, 0.28817153685428037457, -1.7435755898887204118, 1.1369348754708179516, 0.6724577863061328431, -0.43849014288054521948, 4.0679186503944446684, -2.652571308655904847, -0.76821964733539216397, 0.50093366421426255286, -9.5760809678860194794, 6.2442835778727587837, 0, 0, -0.026500124336832579092, -0.021442252392463622551, 0.033954742484493150023, 0.014552615451508882013, 0.34654423116839672137, 0.041415928368598843579, 1.2822161222240113787, -0.025053284450302942821, 1.9082407187462107068, -0.09884374129233876316, -0.65105193196742539019, 0.038121802028613864521, -3.9384275866202003158, 0.23061133742043829487, 0.74376547607607035317, -0.043550566156846479138, 9.271252622511015673, -0.54287045269119871271, 0, 0, 0.00039179415524385585289, 0.00031701546211065640812, -0.0004962026403406965408, -0.0002151548273865228544, -0.0038300099283937543392, -0.00061231858622874310843, 0.011512077618593902564, 0.00037040318349176827237, 0.25275061773382700991, 0.0014613667327948419179, 1.1983955227256271048, -0.00056361619411026103298, 2.0292004728153583137, -0.0034095000078439544229, -0.33243763075564392029, 0.00064387838566091657681, -4.1439315955146351911, 0.0080261310368032780238, 0, 0, -5.8151558545865533576e-06, -4.7052624338916936783e-06, 7.3648257648012915326e-06, 3.1934086748705229843e-06, 5.6846444389557634026e-05, 9.088262200756952661e-06, -0.00016888399711670137003, -5.4976630258790269937e-06, -0.0028285602953466680576, -2.1690153357751540543e-05, 0.0060445157197113750028, 8.3654030236365385289e-06, 0.20922866828696309871, 5.0605078372050556115e-05, 1.0967879273608196478, -9.5566845852699449579e-06, 2.0750065929362113692, -0.00011912684827902968556, 0, 0, 7.7246635846578622837e-08, 6.2503173239414331853e-08, -9.7831946065279388105e-08, -4.2420200453005213882e-08, -7.5512964720790736305e-07, -1.2072551420034312034e-07, 2.2433999968030079565e-06, 7.3029164546350807041e-08, 3.7573673443748081119e-05, 2.8812493074646954793e-07, -7.9863279978354456061e-05, -1.1112328839252804556e-07, -0.0021871272808178477895, -6.7222137441255028355e-07, 0.0021874625048639208952, 1.2694788454839182361e-07, 0.15875038069671990049, 1.5824422420772902814e-06, 1, 0, ]).reshape((20, 10, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=12
knots=None
absorb_cons=FALSE
output=np.array([-3.6802322454608713193e-09, -1.1576165417746612791e-08, 4.0903329323109361483e-09, 4.0685732923556337374e-08, 1.7703518712245050831e-09, 7.8790091688795366003e-08, -9.3409196093845724123e-09, -2.611905916838673793e-06, 3.0933985220706180644e-09, 5.5610182678566951338e-06, 1.6919855821268632348e-08, 0.00016301336905366541432, -1.4352199746873791695e-08, -0.00096630860312933643686, -2.1293612839737406843e-08, -0.0074687624866493825676, 3.8568109059678503697e-08, 0.11083787128447247783, 0, 1, 1.4460849968779115402e-07, 4.5486583496536781572e-07, -1.6072271234908852579e-07, -1.5986770411107210554e-06, -6.9562981611555798878e-08, -3.0959233519658970583e-06, 3.6703563262437939878e-07, 0.00010263042405151407538, -1.2154986136127495596e-07, -0.00021851080443170532329, -6.6483710865399255783e-07, -0.006405334542942880266, 5.6394540729725285131e-07, 0.039346935329722818042, 8.3669649095786947889e-07, 0.58363014399245827235, -1.5154685940796589346e-06, 1.5869193120902693739, 0, 0, -5.4865400297656400151e-06, -1.725790404504806206e-05, 6.09792368290666473e-06, 6.0654841172256407627e-05, 2.6392645247385444743e-06, 0.0001174613348200111455, -1.3925569348217424364e-05, -0.0038938646832389072101, 4.6116803743272812418e-06, 0.008333356501832860086, 2.5224350005560149737e-05, 0.3457041582444345118, -2.1396453586193263292e-05, 1.3943941859934374516, -3.1744806151200007029e-05, 1.0659241155872372087, 5.7497858861837635377e-05, -1.8607361322222011335, 0, 0, 0.00023256871331852414829, 0.00073154456479976239392, -0.00025848462913861898265, -0.0025710954976070178948, -0.00011187567233550075858, -0.0049790635547287236118, 0.00059029037024653681354, 0.20118319692573388702, -0.00019548432437836398673, 1.1583324452787904235, -0.0010692339057516754303, 1.5709796196933376589, 0.00090697336629712820011, -1.2050531219054301246, 0.0013456292455859321117, -1.7878746869280606191, -0.0024372743079464744345, 3.238292460253569427, 0, 0, -0.0096036016628270864243, -0.030208115694913360155, 0.010673763374229244122, 0.11304537553087100343, 0.0046197503419112585787, 0.84717528615215309529, -0.024375220124670693433, 1.6209052609300536041, 0.008072253382102512545, -0.43744451537192496904, 0.044152527520605257261, -2.3926752654369827233, -0.037452204143992279262, 2.0295771844456078625, -0.055565888790719414336, 3.0111781856549497682, 0.10064385386396751398, -5.4540039558593536029, 0, 0, 0.10357732090048776818, 0.85603572021517670976, -0.11294852267110891408, 1.0800087615333373581, -0.048885660842739625531, 0.2401585690492896441, 0.25793574452960393861, -1.2534276012546561319, -0.085419646489135220291, 0.4150930798449654624, -0.46721691129938069942, 2.2704203849822679473, 0.39631486857335096463, -1.9258749730998911964, 0.58799177288976445244, -2.8573206043806020915, -1.0650015567431445618, 5.1753290302415839719, 0, 0, 0.94933893888308096276, 0.20425894956750886844, 0.97636209569699528021, -0.2257137560392956932, 0.19529887869007700463, -0.097691991575737782694, -1.0167341121476407562, 0.51545291906204826482, 0.33670815416251220764, -0.17070067666802030137, 1.8416810448534708389, -0.93367563771983919096, -1.5621985497383736874, 0.79198660986818203433, -2.3177527963386914678, 1.1750293712615387243, 4.1980354999103974833, -2.1282748625244334306, 0, 0, -0.044595007867203530216, -0.03154770903003507182, 0.12905602059221518707, 0.036023951388023812969, 0.85410491166502156002, 0.015591657403950714977, 1.5843424307430495901, -0.082266367920763708299, -0.42533613529877184467, 0.027243855164596028628, -2.3264464741560830774, 0.14901478038204274412, 1.9733988782296159048, -0.12640118898597454966, 2.9278293524688816518, -0.18753487466867790889, -5.3030381750634045801, 0.33967300679089129645, 0, 0, 0.001079949373603220162, 0.00076398525832885994229, -0.0029588224413149436312, -0.00087238562334283919521, -0.0051468770632319233924, -0.000377580394132319148, 0.20206863248110379372, 0.0019922299995820589268, 1.1580392187922230463, -0.00065975959477697777422, 1.5693757688347129697, -0.0036086644319118939793, -1.2036926618559800062, 0.0030610351112528135301, -1.7858562430596849335, 0.0045414987038525046412, 3.234636548791644195, -0.0082258007893193495902, 0, 0, -2.5477139138140648842e-05, -1.8023214052146796125e-05, 6.9801726696616189999e-05, 2.058049242980996096e-05, 0.00012142023160711750383, 8.9075177709926672744e-06, -0.0039147530372612262053, -4.699879655023364312e-05, 0.0083402740223943259285, 1.5564421263354520723e-05, 0.34574199476944195153, 8.5132181268765064475e-05, 1.3943620913130563288, -7.2213030853402265731e-05, 1.0658764983780117941, -0.00010713872076029942911, -1.8606498854339041937, 0.00019405527365870157302, 0, 0, 6.7149986095353481289e-07, 4.7503707792034416037e-07, -1.8397611096343514486e-06, -5.4243915417817383743e-07, -3.2002678243831975437e-06, -2.3477506293900330442e-07, 0.00010318097750045069814, 1.2387452601072785849e-06, -0.00021869312922374677631, -4.1023078209430247345e-07, -0.00640633179860586148, -2.2438252417072174446e-06, 0.039347781247833550633, 1.9033157496282319598e-06, 0.58363139903719374324, 2.8238506569827991151e-06, 1.5869170388873774513, -5.1147065050188478719e-06, 0, 0, -1.7089420375974873326e-08, -1.2089516008577751082e-08, 4.6821232322022749866e-08, 1.3804873646549429766e-08, 8.1445619495631410706e-08, 5.9749375653827772664e-09, -2.6259172962527552498e-06, -3.1525603681672934994e-08, 5.5656583656398050473e-06, 1.0440220011988337053e-08, 0.00016303874883739764194, 5.7104513396781534087e-08, -0.00096633013142895208495, -4.8438674145699212406e-08, -0.0074687944270686538323, -7.1865943334113596723e-08, 0.11083792913663595425, 1.3016736807641509225e-07, 1, 0, ]).reshape((20, 12, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=4
knots=np.array([-2500, -150, 300, 1500.0000000000000000, ])
absorb_cons=FALSE
output=np.array([-0.0051418610449036764379, -0.0051207276560822079237, -0.0051517581620670691717, -0.0051036969019558836927, -0.0051724091286762859804, -0.0050616345732373531699, -0.0052108015793779615538, -0.0049476511776847470828, -0.00525764719160080711, -0.0045887810243909702562, -0.0051780211262217532009, -0.0032118234048454639452, -0.0042344880890217376918, 0.0033309098171163710467, -0.0002048781708894489937, 0.036873131791193267115, 0.0053670164361401782871, 0.19556964857406355929, 0.00027785197169554257113, 0.82912284340298503249, 0.65949448911253716332, 0.6654093842010145865, 0.65653556733089935005, 0.66984284447353759084, 0.64987461295218140744, 0.67980900603329297294, 0.63487206047522759533, 0.70218091452751663084, 0.60105778412747068451, 0.75218902517658670082, 0.52490094418674082544, 0.86229539201840321727, 0.35569403068909899446, 1.0895778496922625678, 0.014595118281322956924, 1.4713138143490975818, -0.3821845778229204238, 1.7530984807387750557, -0.019785804601727036839, 0.46986487896086814864, 0.35950128095327349431, 0.35338118891054576265, 0.36256112212690350116, 0.34879091185540550546, 0.36944502095300485456, 0.3384628569483467686, 0.38492806794448852781, 0.31523169436694697954, 0.41971361558839714867, 0.26307215994266325287, 0.49746707294522052312, 0.14713121281897215131, 0.66691371985704051006, -0.097089653687300894735, 0.9873402560545572193, -0.53105535871660392022, 1.2102463767433073727, -0.99135819513191647534, 0.044702741392222536398, -0.3124421698702265493, -0.013853909020907106964, -0.013669845455478047552, -0.013944931295735877447, -0.013530059426987159701, -0.014147224776509979491, -0.013210228408402318115, -0.014589326840338213628, -0.012464957716778975183, -0.015513752524267036478, -0.010672404094858929657, -0.017189996005739616169, -0.0062147814325298833885, -0.018373262457117778973, 0.004180894177922047858, -0.0017304961649907309174, 0.022868412576313085216, 0.16657118464347281384, 0.042690065819077735454, 0.97480521123780894399, 0.013454447506373390722, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=5
knots=np.array([-400, -50, 10, 50, 100, ])
absorb_cons=FALSE
output=np.array([-0.00093170433340244659687, -0.0012410506081968345274, -0.00078243418040293037045, -0.0014789118938009710238, -0.00046560203080319340248, -0.0020151841680895970881, 0.00010431589287147467922, -0.0030688678143442819739, 0.00055449747551044887423, -0.0028609656322684854333, -0.00014909864114985113439, 0.026923379556954812886, 0.00037005603844857983247, 0.24511712352852058072, 0.0023876748113693508323, 1.1555668732201982429, 0.0069273170504410850126, 3.402689781560706006, 0.017141512088352486159, 8.4587163253268489171, 0.084019186191167327671, 0.11446091282800011091, 0.069879045425061070418, 0.13908517998091646239, 0.040857714895860555715, 0.19963820957805075706, -0.009029120060764306635, 0.3576254481931359086, -0.047994837046959955285, 0.77395141822244861718, 0.012905315717303777676, 1.5659844614539342178, -0.032030405994604847775, 2.0431817208334850378, -0.20666651978408043244, -0.51809792415464139825, -0.59959777581040041294, -8.0018873070243543566, -1.4836931018696206674, -24.840413418481212204, 1.0495495283018867472, 1.0438716260482179266, 1.049399522569444354, 1.0346122703952109756, 1.0414030908228715244, 0.99920617535829048261, 0.98168936282733698651, 0.85586872666349445016, 0.66418975301951443946, 0.32605391435347208517, -0.11777757243608029392, -0.85263295720592457982, 0.29231857203837463555, -1.8526421434409372502, 1.8860972902309971477, 0.52133890068006216723, 5.472099406164398161, 8.051943344140203962, 13.540604167014549830, 24.995803341925523000, -0.15192966618287376268, -0.17994115928882439825, -0.13573193509615386065, -0.19726850771611939561, -0.093692687860718673609, -0.2254589026981791422, 0.031190848164371551277, -0.24103262443025505468, 0.43031985595064925487, -0.11127445668091072439, 1.0214738883945315706, 0.29750331491431342146, -1.0287095298822455103, 0.64642959712677627859, -6.6374375162553720386, -0.1819071733449817152, -19.257075485594906894, -2.8095088468476898669, -47.65126091660886232, -8.7216126122287835898, 0.019292656023222061468, 0.02284967102080309731, 0.017235801282051283617, 0.025049969233792938189, 0.011897484172789671297, 0.028629701929927506981, -0.0039554068238157324977, 0.030607317387968895062, -0.047069269398714280728, 0.014130089737258502702, 0.083547466965394667771, -0.037778198719277893136, 1.7680513078000272831, -0.082086298047844605263, 5.9556190709970859842, 0.023099323599362758808, 15.377646538190468561, 0.35676302817113519916, 36.577208339375580692, 1.1075063634576232108, ]).reshape((20, 5, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=7
knots=np.array([-1000, -500, -250, 0, 250, 500, 1000, ])
absorb_cons=FALSE
output=np.array([-4.3178765217391302305e-05, 6.5885993478260890537e-05, -9.6313081793478265121e-05, 0.00015008344269701090522, -0.00021248546106063178089, 0.00034663246069176721631, -0.00045706603540709121736, 0.00082099033067846731351, -0.00092573826895791448514, 0.0020071162494608137464, -0.0016063078222631245202, 0.0047785217809616390913, -0.0016924900384041397308, 0.0058508393862588175052, 0.00037271449492305578147, -0.023079518000319019372, -0.00039460853415255482939, 0.96024636175750266442, 0.0010388953913813049352, 4.2828168145345602014, 0.0006476814782608695956, -0.00098828990217391310055, 0.0014446962269021740039, -0.0022512516404551634157, 0.0031872819159094768759, -0.0051994869103765082446, 0.0068559905311063691277, -0.01231485496017700916, 0.013886074034368717928, -0.030106743741912203594, 0.024094617333946868887, -0.071677826714424588972, 0.02538735057606209683, -0.087762590793882266915, -0.0055907174238458371557, 0.77073211937350760703, 0.0059191280122883223325, 0.065812149128730040859, -0.015583430870719573377, -5.436090696106786524, -0.0031088710956521745793, 0.0047440075304347817733, -0.0069345418891304357392, 0.010808468249184780344, -0.015298953196365492127, 0.024985562378791605076, -0.032908754549310574589, 0.059430528454937264771, -0.066653155364969851604, 0.14814853819552065151, -0.11565416320294498453, 0.38547179702354089637, -0.12185928276509808144, 0.89303994817074205947, 0.026835443634460023205, 0.3158234170040984945, -0.028411814458983948584, -0.033037325841022327499, 0.07480046817945394666, 2.7299491962930431121, 0.99996527520000000333, 0.99992195380000004068, 0.99982468157500004047, 0.99960649719062499852, 0.99911787098710935773, 0.99802618626118166922, 0.9955959649107849474, 0.99021595070231704927, 0.97840786415926050967, 0.95284186025012007626, 0.89870074544754108281, 0.78829881686806935193, 0.57842205914062527761, 0.2362299420741153233, -0.10286920059876342171, -0.080364133358400105522, 0.1089119554261051559, 0.0088355638877152739563, -0.28673512802124018206, -0.73010269203186040077, 0.0031519622956521736561, -0.0046471747304347834143, 0.0071520025891304338586, -0.010320575886684784858, 0.016392005544802985134, -0.022542075546565051858, 0.038353001709637714323, -0.04736186631031753802, 0.093197128054721647961, -0.090485094976372942854, 0.23844273869784807229, -0.13266783181011393422, 0.6114558419262043909, -0.058789413728980027818, 0.96115953962745293016, 0.020964556528278284475, -0.40723600724543668194, -0.0023049297098387665911, 1.0721400439055068787, 0.19046157183439835214, -0.00065664547826086978963, 0.00096816140217391292219, -0.0014898486644021743334, 0.002150119976392662717, -0.0034132712039954154516, 0.0046962657388677176915, -0.0079705034644407205674, 0.0098670554813161497065, -0.019191613515453308236, 0.018851061453411026292, -0.047118889772279910766, 0.027639131627107058065, -0.098264441613631667294, 0.012247794526870834503, 0.1283332564542301879, -0.0043676159433913086874, 1.1341990151205716408, 0.00048019368954974300367, -2.1349300292885819985, -0.039679494132166315268, 4.3776365217391304853e-05, -6.4544093478260855155e-05, 9.93232442934782663e-05, -0.00014334133175951084961, 0.00022755141359969430562, -0.00031308438259118116136, 0.00053136689762938121937, -0.00065780369875441000935, 0.0012794409010302202311, -0.0012567374302274016227, 0.0031412593181519930102, -0.0018426087751404706099, 0.0065509627742421101121, -0.00081651963512472227127, -0.0082410361884569308111, 0.00029117439622608720607, 0.18701233167960798487, -3.2012912636649525446e-05, 2.2892691807041996022, 0.0026452996088110873087, ]).reshape((20, 7, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=4
knots=None
absorb_cons=TRUE
output=np.array([0.17237877473947216256, 0.16160585322933293528, 0.17775653635702576283, 0.15351565450517737355, 0.18982763251278575445, 0.13530235680671015563, 0.21678099966619068795, 0.094474101590757947333, 0.27612342080317897608, 0.004254035614190725817, 0.4030409383688886571, -0.19022791859524765257, 0.65608982528520065625, -0.58588986559744449245, 1.0712259966408619327, -1.27728761497709975, 1.342827694119810289, -1.9788260499202323661, -0.052195429016186831173, -0.97077694213337639706, 0.68714996318883114768, 0.60683822144440202617, 0.72724727397328958745, 0.54653827251673237075, 0.81726443453130048766, 0.41083008335212661821, 1.0183156414681064916, 0.10689042936382432691, 1.4611707976831045386, -0.56312355687140791538, 2.4093551078217010364, -1.9991227596244038889, 4.3052173449842321418, -4.8778668329561920558, 7.4441765017641099433, -9.6842706472508055526, 9.6670625693150959989, -13.322034134461750554, 0.012161980255413960134, 0.22619930950229019673, -0.010768222248548299166, -0.01771835491152162767, -0.0072960943160139245939, -0.022933439873231927647, 0.00050471399250212036977, -0.034662450006663660107, 0.017964357449119585514, -0.060912800432191181732, 0.056636870493901259049, -0.11877531418126709151, 0.14054140101632672799, -0.24279484616490168425, 0.3140184596633784353, -0.49144965505677373763, 0.63173409697146676312, -0.90678479147331569887, 1.0347141866437283841, -1.2221561304860752983, 0.99694564370894334093, -0.056807630788862507887, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=7
knots=None
absorb_cons=TRUE
output=np.array([-0.088612856492796668317, -0.10148345379387192777, -0.074820024844059834779, -0.097934158724637176974, -0.030963004348234846042, -0.058173986143542688598, 0.090101482080220576809, 0.10049075761090919823, 0.29596829876665797787, 0.41518677441788176541, 0.43034390532152527742, 0.83452635605264402496, -0.13348462782429343365, 0.98208889847295099962, -1.4362329672138189895, 0.92468785756571492129, -2.6216702734870915847, 0.6954743327776672368, -0.0022196047790754855691, -0.12327370541474826082, 0.24123862297275155964, 0.35840804363927752929, 0.18093342115646737778, 0.44250759269715284061, 0.043937153723061256327, 0.6202158021725746595, -0.24740540994207005365, 0.96645134975980595549, -0.72475992234705299833, 1.5060196314875564649, -1.0261673763863199405, 1.7262771004734287494, 0.32934388972170997034, -0.37505857126375657939, 3.4434877057227697428, -4.9947636565362447669, 6.275814996477087071, -9.1524782805583591028, 0.0068271591356862497413, 0.37917074789447108296, 0.35954055514606403365, 0.35954551446237459356, 0.35744096324407559351, 0.35584226884375003142, 0.34885947617865670223, 0.33862610062421411028, 0.32049681236018934261, 0.28089301373203690027, 0.25602145147051952323, 0.16597482970505655908, 0.12171945403305862998, 0.0018741765108557348514, -0.13785069799652086009, -0.10675519142579256715, -0.57612609827379823724, -0.22195090041542500647, -0.96232722728117126021, -0.44017455467682947701, -0.01453255272801050671, -0.80711739351329703229, 0.39138909874594340899, 0.2727563805116787754, 0.45531894883729062684, 0.19274617399836088683, 0.60538032158012156092, 0.036358318155975434538, 0.93314031181054180042, -0.23999550325584054211, 1.4531806967029836652, -0.67840171762003531608, 1.6665321594967388297, -0.95105942435581225514, -0.35463732068059222735, 0.31454920667339703044, -4.8088313747127671149, 3.2255742320619229524, -8.8757338424365990193, 5.937464168828833877, 0.0075040642903919140341, 0.41676510136746514057, -0.089133365834868971689, -0.10118952771068721874, -0.075725350737607874385, -0.097115177460207771643, -0.032342847263930989132, -0.056715061432944156861, 0.092352440078496370046, 0.098331113369192327256, 0.3400969886051333213, 0.37108103090272787083, 0.71036876576058238797, 0.55444750827998945386, 1.0162219858335352907, -0.16763759291903618243, 1.3370398275661443677, -1.8484727482821472488, 1.4719012302123679614, -3.3978810087925515049, -0.0022219907599747576801, -0.12340621941421109353, -0.013194863919370570376, -0.015072699772667915927, -0.011151244212216769591, -0.014503828881363881043, -0.0046275650331869689486, -0.0085121840139092009442, 0.013410603654954418931, 0.014660726583422474187, 0.044001710617309369722, 0.05545171716304433257, 0.063619527459568614436, 0.082887169332405197242, -0.019275003418586279108, -0.025046122964883565931, -0.18452246030655442, -0.27630735647963872159, -0.17524590664413686181, -0.50790642667837671009, 0.99966985744385294943, -0.01833564992966553106, ]).reshape((20, 6, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=10
knots=None
absorb_cons=TRUE
output=np.array([0.017741203875868801626, 0.059666517581418020144, -0.0073055449468428850998, 0.071233532376632907601, -0.061951321114274808532, 0.023459686026844089879, -0.15952965061095217281, -0.21534242305337428225, -0.20894123625115404441, -0.40851053368902323637, 0.088769309083260417026, 0.1702312769628678002, 0.44867980227835829732, 1.1139500668975872433, -0.14345767930218020214, 0.86682083739859494553, -1.1837156997359956634, -0.21597943647408635037, -0.017918712309548733702, -0.23789999499399971938, -0.0050889918235734665428, -0.017199613011022536063, 0.002072270281447358229, -0.021223643286449593581, 0.017930549906902432111, -0.010400764195970725601, 0.046747049525783831991, 0.07425318574607586708, 0.061514150450350559007, 0.37070324197740467387, -0.026117581474140658115, 1.1506456698664466742, -0.13217536320689113327, 1.766217994670280067, 0.042129159012710096222, -0.26549271162309995287, 0.34842176083555986832, -3.4777238134306913686, 0.0052384550413758917964, 0.06954899473750200678, 0.040717410233940966313, 0.14267724274658066808, -0.01518518709909348792, 0.21755481940124130058, -0.15305036931474685913, 0.39059745188013861306, -0.43311720487012722591, 0.71916259556541839437, -0.58682103919738470843, 0.86959977149390199624, 0.24816600986825945729, -0.22985936815572685643, 1.2655729988498243266, -1.6266494012894197052, -0.39570727271363553834, 0.14945216327392790712, -3.3194533089504827394, 3.3989844591011317831, -0.047815351859148348679, -0.63482641896460045849, 0.12003828098968173654, 0.69730715192779646472, -0.080805333880490451404, 1.032100885251629574, -0.17573134714242774623, 1.0800934656851248761, 0.36589399540256600796, -0.28448323213545234633, 0.88954585755350989995, -1.7064483114238784278, -0.35386353683003346493, 0.6479603434190704947, -2.0242657690367202861, 4.0363385548625183574, 0.45966058247434787853, -0.6843648579769759932, 4.9332279555632334578, -9.2892931271418373029, 0.023611216265584832746, 0.31347722617275158852, 0.88792799224608875974, 0.25713275781065136893, 1.0532535169725301127, -0.17260864810915746426, 0.90704417033506612444, -0.47809553851771402488, -0.43024289925585679217, 0.30393926379684116368, -1.7282652053936073955, 1.1666632610962044403, 0.66595310521671158277, -0.45052173959023528171, 4.0350412627641443208, -2.7188693891544946091, -0.75770752213855696588, 0.51778556938925135444, -9.4893428981139695821, 6.4121669845342363914, 0.0013130525053329394382, 0.01743290360653331969, 0.018394340893766202016, 0.12954185558052447313, 0.015467038664664091788, 0.1947806488224434196, 0.18978123265431517952, 0.10064263984709266586, 0.87856041959654240792, -0.56951570226238645844, 1.3795704170465219462, -1.1253701882691806713, -0.4264441361865796698, 0.45357497790875550558, -2.8031655399252684013, 2.5198958573805381178, 0.38077992198436172444, -0.6254498513067092702, 6.2761716348405380828, -6.3399143661490446888, -0.045339936718340946575, -0.60196126440255459666, -0.004758953821358206937, -0.017005411359244829855, 0.0016248940817804027534, -0.020892741105429570719, 0.014155429774586492792, -0.0074074070841472963028, 0.057823550154750644192, 0.062836648910594553041, 0.313405031875580109, 0.11923488274498127149, 1.1726262403941665191, -0.048228614408167384819, 1.8989517069621104639, -0.26605941795394616456, -0.29079224977894058135, 0.067405260889645518541, -3.8003055548041984046, 0.6731217514912637423, 0.0052018569797349914138, 0.069063096056237921472, 0.017736305328008575982, 0.059663635167637223133, -0.0072989048214304030199, 0.071228621002306605203, -0.061895289364833461221, 0.02341525749747295701, -0.15969206961095888664, -0.21517495710840772727, -0.21175703601763257167, -0.40570100515546192455, 0.094808655216413129097, 0.16419386720169948379, 0.65787987528453284458, 0.90476706770574533145, 0.95333742847376501395, -0.22997392252730572415, 0.8913620730776831147, -2.2910886491383859465, -0.017918169107386142797, -0.23789278310346156919, 0.0060750632566522310557, 0.020430784619126868273, -0.0025017991326720841194, 0.024387881029101547703, -0.021213459590422957535, 0.0080142623794636578399, -0.054619250223539139721, -0.073674968074426458453, -0.071500525070803497285, -0.13890622902065649646, 0.030313398118739860038, 0.056217781624179681554, 0.1514331690285295462, 0.30977852573253761292, -0.046930667126897918084, -0.078740760116175548267, -0.2465351039505715991, -0.78443722293869766471, 0.99386473410822107066, -0.081455614651688740269, ]).reshape((20, 9, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=12
knots=None
absorb_cons=TRUE
output=np.array([-0.10472685656120690745, -0.12767819762829035746, -0.076360123823526582232, -0.10958044510013424666, 0.0027880985603357523288, -0.00047490167664404706613, 0.06928482401745712782, 0.12032832514458154105, -0.15700287132688625635, -0.1737016309573724826, -0.34110464392275169354, -0.43703758617891158567, 0.21658232947898950482, 0.33207321984948795501, 0.31440967571649758305, 1.0125703207549268114, -0.77927839590651259982, 0.57499654812351752575, -0.03855715180341089815, -0.29753053676014623585, -0.045155067335396106842, -0.055061683622734447496, -0.032913973166337623377, -0.047180638471765484754, 0.0012046656812917998312, -8.5942102116568291834e-05, 0.029855775209106073798, 0.047937464934110683712, -0.067681928151560877271, -0.066458149628327731206, -0.14703046798660462935, 0.16005131398107033669, 0.09335066435731875778, 1.5205934362940900506, 0.13551522132064452997, 1.2508474777651827914, -0.33590194032153924963, -2.2969931440729616234, -0.016622640017795731193, -0.1282704446656750541, -0.15034574662694516478, -0.18284705677723475659, -0.11005017611978802627, -0.16012547886604538983, 0.0038970012572561371633, -0.0056574341249261998407, 0.10020869531895890137, 0.37404580513022472887, -0.22593678600553301905, 0.90889537861179725553, -0.49151450544890296079, 0.95180903084537338277, 0.31231202672612079496, -0.78416614637393700082, 0.4534081611517823962, -1.1711369929499528819, -1.1228952128467266647, 1.7833321983277987677, -0.05543814773678283625, -0.42779461349253811164, 0.021352229303511102015, 0.007531901115204664085, 0.033244696218130601051, 0.14543534382436593133, 0.0037956069961920194805, 0.8473147453077168878, -0.044854732714249959113, 1.5853682337831724869, 0.054480061579266131355, -0.38616534110945410774, 0.14497807394687750593, -2.2653864188032963867, -0.10147073278861845624, 1.9430514052120930746, -0.14850072666747962669, 2.8843894925937085816, 0.33098715709405579499, -5.1548937962780287947, 0.011396952652503542641, 0.087945848734329423735, -0.065952557774967432436, 0.64935218850878217989, -0.23655843353990058109, 0.90262481725902277141, -0.044372232611305732763, 0.23939481976571783117, 0.37009197410777977533, -1.0588087616813195435, -0.33957241343679639423, 0.13426223409097867711, -1.0193888969785738219, 1.5733219045695456817, 0.74691289987499476233, -1.4520157873552757, 1.0969502242749886722, -2.1629612193760392458, -2.3264786688505232348, 3.5372496286723378311, -0.062415510749811636826, -0.48163620876963536555, 0.8195140136919921714, 0.045981988292849676481, 0.88170239584467990923, -0.36155327574779005939, 0.19875523391830787756, -0.098276866020166997462, -0.93084557008965973512, 0.66449081424484612857, 0.14207954819710574834, -0.38575918922177282466, 1.418831177364036078, -1.467509312217160522, -1.2937127610296201841, 1.1548650229305499337, -1.9279955842607379157, 1.7067654635554521114, 3.232004184432778704, -3.3827058656451867158, -0.047797409383925140713, -0.36883400885657852131, -0.021262964105923369551, -0.0031022854611233788291, 0.1460681949195489493, 0.060436933823290558965, 0.85348373794725573838, 0.015696770625561979468, 1.5689066026927753761, -0.10905135306422376884, -0.39035761984884714826, 0.065894018981400556689, -2.2504521949512743539, 0.2449549909100549594, 1.9251468021185453861, -0.19161744080459083839, 2.8577824618961185088, -0.28309810920621092389, -5.1294237100882460467, 0.56511845971327800964, 0.0085901166188240788563, 0.066286587283785933233, -0.14931374206792483172, -0.18258953057237148343, -0.11261589846568037521, -0.15823359174408363481, -0.0011429154130191262681, -0.0010551192149562264085, 0.30156489541842562696, 0.17464289155956300159, 0.93257469826065064744, -0.24979099176207356092, 1.0795318316732362973, -0.62202008893514815213, -0.89266942187285236443, 0.42343196160757057278, -1.3343479845023715757, 0.62052301130682563368, 2.1155524024387766246, -1.4614021376163455201, -0.055370175087794709645, -0.42727009501042717554, -0.045179413406039932444, -0.055067758936182993612, -0.032853445083453579334, -0.047225270074522207597, 0.0013235626049733512782, -0.00019451554100623699175, 0.025957829199430799971, 0.051789330864583066338, -0.059352795367343585964, -0.074783156665720870726, 0.19867211632366271745, -0.18558562156573668589, 1.4877431595022336808, 0.12613921140813655342, 1.2014365403948221722, 0.18483406256944329149, -2.1966417328137768372, -0.43610504124242488455, -0.016624243563923207095, -0.1282828186071544585, -0.10472621487286955244, -0.1276780375015148794, -0.076361719159604879437, -0.10957926874689910557, 0.0027849647992298789088, -0.00047204001118300933926, 0.069387562012853995497, 0.1202268016798509892, -0.15722127080697423374, -0.17348334021941591576, -0.34750993698157911505, -0.4306340234217196361, 0.25592930937433366889, 0.29272786696227376391, 0.89803989341652912248, 0.42894253042841035128, 0.80764101265733667656, -1.0119267694495412968, -0.038557109538814519911, -0.29753021062070239555, -0.052405524507834276571, -0.063890551260129033184, -0.038210563318028127611, -0.054833362353974436643, 0.0013952838636999886825, -0.00023608614675063352537, 0.034667393120659889538, 0.060161039317539917459, -0.078558784282471219584, -0.086811135096279259948, -0.17052577031441601418, -0.21548879873646650807, 0.10741142530502149899, 0.14648050866337228304, 0.14986173697025292895, 0.21464206783358963371, -0.2791130852403586049, -0.50636714208926458802, 0.98070595851787800701, -0.14888461024604163208, ]).reshape((20, 11, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=4
knots=np.array([-2500, -150, 300, 1500.0000000000000000, ])
absorb_cons=TRUE
output=np.array([0.026705483244849264474, 0.029839625165101336945, 0.025137490946490849419, 0.032188537945938233698, 0.021607394654091297004, 0.037467894551815809911, 0.013655036980899055293, 0.049314030316796791942, -0.004274510570643489521, 0.07576300788030972122, -0.044664576703176542272, 0.1337724526334178321, -0.13422281221596993328, 0.251582066127820414, -0.31121876398729647617, 0.43612872129651875097, -0.47985225176217655152, 0.49291724756068344693, -0.081762536217311512776, -0.57008353784816034882, 0.10575886843256800118, 0.098523720643000009534, 0.10937645918695998448, 0.093097559739294566405, 0.11751580252413190708, 0.080890140328454290808, 0.13582591101899046948, 0.053438242334149517465, 0.17698108482519578355, -0.0081682818617542177903, 0.26907668054096511856, -0.14499960251139776268, 0.47046169477357585587, -0.43311804519238522593, 0.8566919676788534721, -0.94615480020651354653, 1.1710825622951557268, -1.4966789629626817693, 0.019850657594207062745, -0.7294516591807701511, -0.065495278981390098183, -0.065538150305470069257, -0.065472788689835886844, -0.065568482416232795607, -0.065419575517949940524, -0.065631137544391218719, -0.065286317209239316806, -0.065744866169428622937, -0.064914403751873434034, -0.065874953263984459273, -0.063671751390664124703, -0.065668915889071088898, -0.058354957302844213951, -0.064207225531959205567, -0.028319888642541334034, -0.061612158154530236032, 0.15860060924423530215, -0.060152247616144620401, 0.96974734313860999624, -0.071414854005294861605, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=5
knots=np.array([-400, -50, 10, 50, 100, ])
absorb_cons=TRUE
output=np.array([0.21482323419002713472, 0.24750397604597326739, 0.19883614002139288202, 0.27258973708238182221, 0.16379621347999451242, 0.33062932586024107451, 0.090229192760086424085, 0.46740970723200020442, -0.043673571594035724697, 0.78496238070321600055, -0.14225997541844798144, 1.352022453322457185, 0.3403195391608931919, 1.6947780812699095865, 1.6168904854104195756, -0.12774151466578054226, 4.4891751144718545774, -5.4563586958095688928, 10.951815529860082776, -17.445747353383097789, 0.78661625540292257064, 0.77643763922916775311, 0.79017886797586167624, 0.76625062041079372577, 0.79428060270008205013, 0.73589687070232667754, 0.78216715039058581915, 0.63518798334179016329, 0.65550344333732102342, 0.30392043723920803, 0.19412499069407199159, -0.42254129005404528208, -0.4561535986725677172, -1.1523051841355156366, -1.7794911913869626563, -0.26332862233794968043, -4.7570007749943510333, 2.9350973501194954629, -11.456397338110976492, 10.131555788148743247, 0.21540397689706236584, 0.19368025263260429947, 0.22641495625607274689, 0.1776489056064568528, 0.25155233513796670941, 0.14240007942952948028, 0.30993541465339075058, 0.067271686044363815382, 0.44245515455816608608, -0.080352654001592846433, 0.58572719290272645676, -0.30336068837952584465, 0.016951242449324648714, -0.3319833812262538153, -1.5163892893085060276, 0.9143206895602743467, -4.9664054857636248386, 4.3390336686705470726, -12.728941927787642996, 12.044637871668662399, -0.24478425848794690967, -0.24574753349402200797, -0.24311234670203171748, -0.24447893336440842948, -0.23629987575155153579, -0.23582487990744877004, -0.20434545124769434854, -0.19103328802457081315, -0.055793360625630179783, -0.0080996580588084746144, 0.39680666612040660368, 0.39418417396254185059, 1.016323619403686207, 0.62129681239849587904, 2.2740869262794469741, -0.76498115062552785037, 5.1040543667499091995, -4.782338947138994989, 11.471481107808449096, -13.821393989294298521, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cr
nb_knots=7
knots=np.array([-1000, -500, -250, 0, 250, 500, 1000, ])
absorb_cons=TRUE
output=np.array([0.18906235677058036426, 0.18778525841872689695, 0.18966313099776943574, 0.18676205783172145081, 0.19092371457093507137, 0.18426214279619892999, 0.19330747373751991369, 0.17770329603139525809, 0.19648166130871616564, 0.15897921699813499785, 0.19369977803300092445, 0.10544719310340035234, 0.15040730339948449323, 0.026126087939682636485, 0.014566423626603465513, 0.71038417591713942656, -0.0044258520659356658661, 0.37477303749040830061, 0.11191608928948779123, -3.5378245461949706652, -0.1717114269621455025, -0.1641796852631927095, -0.1753614922544594612, -0.15832977440814030579, -0.18329458477753993173, -0.14455385888762556368, -0.19975455127362412577, -0.11060689494904693553, -0.23004851008792162603, -0.021054716326888309186, -0.26742505651389464338, 0.22697177040482915955, -0.233733177660145508, 0.79112685520733139199, 0.0087978598061598800584, 0.36982567289124945731, -0.019154626403592486805, -0.30951045809435018263, -0.039292263384108856716, 1.0312889189371063914, 0.550395590305010729, 0.54949597448884435202, 0.55072323934346578689, 0.54860843215917232119, 0.55116651719216569472, 0.54595839995564021674, 0.5507105841767095944, 0.53682026836985941021, 0.54272290221675423272, 0.50167044456244525019, 0.49401178725604522057, 0.36566698512261336385, 0.28011631034896739001, -0.03551586186561946773, -0.15096545178713224877, 0.063629989613431983675, 0.133595751562454651, -0.72836523541381203994, -0.59095728594899554764, -5.2594893416580195122, -0.095090409079557833283, -0.1030766681400390461, -0.090988045895585706324, -0.10887508452680887128, -0.081496719465270400784, -0.12133034539926186579, -0.058865730473533696421, -0.14644031510302549237, -0.0020110794198277630838, -0.18907748512879404834, 0.15000794369741921042, -0.22502359947941463769, 0.5462684746707909822, -0.11817275982033918769, 0.95064928964895001329, 0.052430922211166117175, -0.40184197213040517838, -0.16340199015776293856, 1.0056597912908593617, -0.79932421729955860368, 0.03971313277885706039, 0.041414831889495302975, 0.038837883046586599289, 0.042648161751521966589, 0.036811186605924875459, 0.045290364726222026581, 0.031978640736114505305, 0.050580394866669355081, 0.019931365400903504337, 0.059364669508446515911, -0.010779243096346216579, 0.065589985310555209974, -0.071477633391997127954, 0.036649613012278252355, 0.13265213083724519683, -0.017297782300268411959, 1.1319824969476413035, 0.066678235503076957458, -2.1076119483122943699, 0.36704351417936742497, -0.098246537944137943277, -0.098542071754031859698, -0.098088618240313230068, -0.098745945231101361905, -0.097708943948828105852, -0.099149563571540588747, -0.096734808676916902992, -0.099784603436978008828, -0.093975228815392539139, -0.099897241328297553542, -0.085336692453571283412, -0.094243446676616243751, -0.058668216352278305947, -0.060228845196453252575, -0.018756415239227899883, 0.03177289587597233872, 0.19240899911984374326, -0.16120768980326213859, 2.2227564852817449648, -0.98762351160861328037, ]).reshape((20, 6, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=4
knots=None
absorb_cons=FALSE
output=np.array([-1.693557754132211208e-05, -1.9836972061171899575e-05, -1.4954358368392469422e-05, -2.088026100812221311e-05, -9.5355264085171175196e-06, -1.8699295604068575353e-05, 4.9022718833308546933e-06, 1.7974067511175931267e-05, 3.744122291002612696e-05, 0.0002988262983956019303, 0.00010718085083579747424, 0.001935560671294481172, 0.00024699248283329116715, 0.010566342124751632037, 0.00048044994314723433668, 0.053454984128479515748, 0.00065729103443297996496, 0.25076507420610638643, 0, 1, 0.35560680685948470314, 0.46359416252769836131, 0.30168882277557279581, 0.54466866236250932598, 0.18063664369405590948, 0.72711735964503432239, -0.089776348720933471514, 1.1356863997659447652, -0.68566908660007752641, 2.0361466894716735432, -1.9628257407671605428, 3.9650378336575471394, -4.523225924226894179, 7.8266636243390204086, -8.7985820993738865781, 14.246329329102128014, -12.037110654561336887, 18.944322912930825709, 0, 0, 0.6444562685323340645, 0.53647236902629924504, 0.69836999393477805498, 0.45539628464397530205, 0.81940601333710849641, 0.27293213874197075341, 1.0897461189737138731, -0.13572091900106228457, 1.6852766572444068949, -1.0365718798973906356, 2.9606222279687766097, -2.967335129700412466, 5.5120421008950604147, -6.8380635660933348774, 9.743925990387539926, -13.301405831788731149, 12.784702352769150124, -18.197306344378148424, 0, 0, -4.6139814277377641984e-05, -4.6694581936484837246e-05, -4.3862351982477081188e-05, -4.4066745476440737986e-05, -3.3121504755945730075e-05, -3.0799091401098394798e-05, 2.5327475336172373395e-05, 1.6545167606241587368e-05, 0.00035498813276064257764, 0.00012636412732133810903, 0.0020963319475481821674, 0.00036173537157081639762, 0.010936830849001568516, 0.00083359962956235762136, 0.054175659043200374843, 0.0016215185581219158321, 0.25175101075775591086, 0.0022183572412113072327, 1, 0, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=7
knots=None
absorb_cons=FALSE
output=np.array([-2.9605259404128104445e-07, 4.3004543792069181325e-07, -4.6506508782294522313e-07, 1.2225175036037286749e-06, -4.8490441759023038782e-07, 2.7062259965304665474e-06, 2.8104230735656565092e-07, -5.4449455566502238182e-06, 1.7542735683802410547e-06, -0.00011038827024139799939, 2.8120883750482203265e-06, -0.00053376130083573273665, -7.6784755538918750706e-07, 0.00061879177472234751789, -9.2078635815506674409e-06, 0.029574116402683980898, -1.6901017048743381161e-05, 0.21556638245963724576, 0, 1, 0.00010456869825724268133, -0.00015189629322606839636, 0.00016426557921581520349, -0.00043180524853199072667, 0.00017127302630398999017, -0.000955865732450367038, -9.9266916848531769006e-05, 0.0019305664182940607265, -0.00061962673904836988552, 0.042415216868389754579, -0.00099325736940550032363, 0.27732557133728741317, 0.00027121133522598855859, 1.1504608369631013076, 0.0032523082987030572759, 2.7821404636666882126, 0.0059696060348119403538, 4.1098324719022825136, 0, 0, -0.031642380707528651451, 0.046727930564370717681, -0.049706595580857972083, 0.14260551573254778845, -0.051827041873556585483, 0.44422176162356585838, 0.030038067097830360025, 1.2696071710389067455, 0.18749841492049976188, 2.6526069738107440621, 0.30055865997270758694, 3.4401400654673524038, -0.082068271523342908869, -0.89294447099362916909, -0.98414515128277502143, -10.707999025460104292, -1.8063966557448927208, -19.65451295888456329, 0, 0, 0.9404055233767310007, 1.0229997547271381109, 0.84839014691027592185, 0.9942253298077886603, 0.55270681506501917468, 0.71325376394101502875, -0.27008001161472772189, -0.36441609214674652861, -1.6858466263672904351, -2.2746949537899268101, -2.7024004611201863923, -3.6463202499480562579, 0.73789700429246496416, 0.99563659340566201816, 8.8487029815652924469, 11.939460983544531558, 16.241778413219694954, 21.914859168852931504, 0, 0, 0.091452250263845791256, -0.069826465452058242289, 0.20181123367547218472, -0.13689085681302756714, 0.50012121362724204499, -0.15708533369949770342, 1.2380919977577322655, 0.093217876961678852732, 2.4558884227495125785, 0.58186847095202909319, 3.1248015911458146832, 0.93273112726773044212, -0.80684053529361110524, -0.25468449792074498994, -9.6754590529148973843, -3.0541220021223365322, -17.759287695723489975, -5.6058354437652431201, 0, 0, -0.00032057317842933900735, 0.00025095691201626593508, -0.0006604553857512240455, 0.00049198690620599915858, -0.0011751018630891821651, 0.00056456602826813432217, 0.0020547291059278675364, -0.00033502584436379451204, 0.043190243671805170211, -0.002091240244288253107, 0.27856793393313283858, -0.0033522436217435750035, 1.1501216068412509763, 0.00091533825638770416853, 2.7780724886333088008, 0.010976540508122837117, 4.1023657110424904815, 0.02014742036749034293, 0, 0, 9.0759971803981566744e-07, -7.1050367876085636178e-07, 1.8698667331515860834e-06, -1.392902486538716717e-06, 3.3269224981118857968e-06, -1.5983868974364642471e-06, -5.7964722216058981582e-06, 9.4851778732840647118e-07, -0.00011258250904733756745, 5.9206732932833133743e-06, -0.00053727865043814320746, 9.4907982657877548258e-06, 0.00061975219556745361413, -2.5914854994384806915e-06, 0.029585633563949290115, -3.1076539587733474873e-05, 0.21558752218843252324, -5.7040932539508893209e-05, 1, 0, ]).reshape((20, 7, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=10
knots=None
absorb_cons=FALSE
output=np.array([1.9320747025477182898e-08, 4.8242814281426965595e-08, -1.2568948282371909281e-08, -7.8978523641721503504e-08, -3.5770522726027550527e-08, -7.01473863118866388e-07, 2.1638270976696590321e-08, 2.2109425903379564006e-06, 8.5370349850805669926e-08, 3.744561791897189516e-05, -3.2925418782971613435e-08, -7.9813891850179092256e-05, -1.991767035296446912e-07, -0.0021868285157625511929, 3.7614188014338205365e-08, 0.0021874060835819046644, 4.688717754303082178e-07, 0.15874967738905676473, 0, 1, -1.4544731165165144453e-06, -3.6317372379498608116e-06, 9.4619516292459995175e-07, 5.9455330204143990165e-06, 2.6928184298539113977e-06, 5.2807216744776855019e-05, -1.6289371928530509096e-06, -0.00016644059132742171966, -6.4267121060004543239e-06, -0.002818920227187673988, 2.4786379329293728427e-06, 0.0060407977628119044478, 1.4994097295422416361e-05, 0.20920617714101982787, -2.8316102474873858596e-06, 1.0967921747761912865, -3.5296843934527352639e-05, 2.0750595382021144175, 0, 0, 9.7994633378747003421e-05, 0.00024468706579685965685, -6.3749578484895432179e-05, -0.00040057827261335182721, -0.00018142772925296013898, -0.0035578683345143034648, 0.00010974909140496827962, 0.011347453981486406438, 0.00043299755045772883848, 0.2521011214081396723, -0.00016699739084748591402, 1.1986460188118959191, -0.0010102222245463542399, 2.0307158061521746184, 0.00019077878093656664284, -0.33272379892704945226, 0.0023781128997935555708, -4.1474987648643217852, 0, 0, -0.0066281488228501295526, -0.016550113319571305159, 0.0043118860597063267057, 0.027486913394933615296, 0.012271386183288513286, 0.32813715189346348566, -0.007423195392682361074, 1.293350915313034033, -0.029287034456989179121, 1.9521712704316960263, 0.011295348749219022086, -0.66799495509124628967, 0.068329285161611297283, -4.0409215143626093791, -0.012903871453880378511, 0.76312128325689243535, -0.16085050450109564246, 9.5125283792626493806, 0, 0, 0.14341751361350341121, 0.77593360542645228861, -0.090432986778547594375, 1.1259563994195789238, -0.25736721450922656063, 1.1109363559631879603, 0.15568633342939960928, -0.56801737059939128027, 0.61423561827887318554, -2.241022016113413784, -0.23689682657495314544, 0.86431165517469521475, -1.4330669354534046889, 5.2285058979714911231, 0.27063229881828543277, -0.9873946118959923135, 3.3735101868301691219, -12.308160541801825616, 0, 0, 0.88922814381914494497, 0.26150528401135941792, 1.052718109833140403, -0.16738921270899279059, 0.90250428645253855109, -0.47638032258407536634, -0.44193283907468589033, 0.28817153685428037457, -1.7435755898887204118, 1.1369348754708179516, 0.6724577863061328431, -0.43849014288054521948, 4.0679186503944446684, -2.652571308655904847, -0.76821964733539216397, 0.50093366421426255286, -9.5760809678860194794, 6.2442835778727587837, 0, 0, -0.026500124336832579092, -0.021442252392463622551, 0.033954742484493150023, 0.014552615451508882013, 0.34654423116839672137, 0.041415928368598843579, 1.2822161222240113787, -0.025053284450302942821, 1.9082407187462107068, -0.09884374129233876316, -0.65105193196742539019, 0.038121802028613864521, -3.9384275866202003158, 0.23061133742043829487, 0.74376547607607035317, -0.043550566156846479138, 9.271252622511015673, -0.54287045269119871271, 0, 0, 0.00039179415524385585289, 0.00031701546211065640812, -0.0004962026403406965408, -0.0002151548273865228544, -0.0038300099283937543392, -0.00061231858622874310843, 0.011512077618593902564, 0.00037040318349176827237, 0.25275061773382700991, 0.0014613667327948419179, 1.1983955227256271048, -0.00056361619411026103298, 2.0292004728153583137, -0.0034095000078439544229, -0.33243763075564392029, 0.00064387838566091657681, -4.1439315955146351911, 0.0080261310368032780238, 0, 0, -5.8151558545865533576e-06, -4.7052624338916936783e-06, 7.3648257648012915326e-06, 3.1934086748705229843e-06, 5.6846444389557634026e-05, 9.088262200756952661e-06, -0.00016888399711670137003, -5.4976630258790269937e-06, -0.0028285602953466680576, -2.1690153357751540543e-05, 0.0060445157197113750028, 8.3654030236365385289e-06, 0.20922866828696309871, 5.0605078372050556115e-05, 1.0967879273608196478, -9.5566845852699449579e-06, 2.0750065929362113692, -0.00011912684827902968556, 0, 0, 7.7246635846578622837e-08, 6.2503173239414331853e-08, -9.7831946065279388105e-08, -4.2420200453005213882e-08, -7.5512964720790736305e-07, -1.2072551420034312034e-07, 2.2433999968030079565e-06, 7.3029164546350807041e-08, 3.7573673443748081119e-05, 2.8812493074646954793e-07, -7.9863279978354456061e-05, -1.1112328839252804556e-07, -0.0021871272808178477895, -6.7222137441255028355e-07, 0.0021874625048639208952, 1.2694788454839182361e-07, 0.15875038069671990049, 1.5824422420772902814e-06, 1, 0, ]).reshape((20, 10, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=12
knots=None
absorb_cons=FALSE
output=np.array([-3.6802322454608713193e-09, -1.1576165417746612791e-08, 4.0903329323109361483e-09, 4.0685732923556337374e-08, 1.7703518712245050831e-09, 7.8790091688795366003e-08, -9.3409196093845724123e-09, -2.611905916838673793e-06, 3.0933985220706180644e-09, 5.5610182678566951338e-06, 1.6919855821268632348e-08, 0.00016301336905366541432, -1.4352199746873791695e-08, -0.00096630860312933643686, -2.1293612839737406843e-08, -0.0074687624866493825676, 3.8568109059678503697e-08, 0.11083787128447247783, 0, 1, 1.4460849968779115402e-07, 4.5486583496536781572e-07, -1.6072271234908852579e-07, -1.5986770411107210554e-06, -6.9562981611555798878e-08, -3.0959233519658970583e-06, 3.6703563262437939878e-07, 0.00010263042405151407538, -1.2154986136127495596e-07, -0.00021851080443170532329, -6.6483710865399255783e-07, -0.006405334542942880266, 5.6394540729725285131e-07, 0.039346935329722818042, 8.3669649095786947889e-07, 0.58363014399245827235, -1.5154685940796589346e-06, 1.5869193120902693739, 0, 0, -5.4865400297656400151e-06, -1.725790404504806206e-05, 6.09792368290666473e-06, 6.0654841172256407627e-05, 2.6392645247385444743e-06, 0.0001174613348200111455, -1.3925569348217424364e-05, -0.0038938646832389072101, 4.6116803743272812418e-06, 0.008333356501832860086, 2.5224350005560149737e-05, 0.3457041582444345118, -2.1396453586193263292e-05, 1.3943941859934374516, -3.1744806151200007029e-05, 1.0659241155872372087, 5.7497858861837635377e-05, -1.8607361322222011335, 0, 0, 0.00023256871331852414829, 0.00073154456479976239392, -0.00025848462913861898265, -0.0025710954976070178948, -0.00011187567233550075858, -0.0049790635547287236118, 0.00059029037024653681354, 0.20118319692573388702, -0.00019548432437836398673, 1.1583324452787904235, -0.0010692339057516754303, 1.5709796196933376589, 0.00090697336629712820011, -1.2050531219054301246, 0.0013456292455859321117, -1.7878746869280606191, -0.0024372743079464744345, 3.238292460253569427, 0, 0, -0.0096036016628270864243, -0.030208115694913360155, 0.010673763374229244122, 0.11304537553087100343, 0.0046197503419112585787, 0.84717528615215309529, -0.024375220124670693433, 1.6209052609300536041, 0.008072253382102512545, -0.43744451537192496904, 0.044152527520605257261, -2.3926752654369827233, -0.037452204143992279262, 2.0295771844456078625, -0.055565888790719414336, 3.0111781856549497682, 0.10064385386396751398, -5.4540039558593536029, 0, 0, 0.10357732090048776818, 0.85603572021517670976, -0.11294852267110891408, 1.0800087615333373581, -0.048885660842739625531, 0.2401585690492896441, 0.25793574452960393861, -1.2534276012546561319, -0.085419646489135220291, 0.4150930798449654624, -0.46721691129938069942, 2.2704203849822679473, 0.39631486857335096463, -1.9258749730998911964, 0.58799177288976445244, -2.8573206043806020915, -1.0650015567431445618, 5.1753290302415839719, 0, 0, 0.94933893888308096276, 0.20425894956750886844, 0.97636209569699528021, -0.2257137560392956932, 0.19529887869007700463, -0.097691991575737782694, -1.0167341121476407562, 0.51545291906204826482, 0.33670815416251220764, -0.17070067666802030137, 1.8416810448534708389, -0.93367563771983919096, -1.5621985497383736874, 0.79198660986818203433, -2.3177527963386914678, 1.1750293712615387243, 4.1980354999103974833, -2.1282748625244334306, 0, 0, -0.044595007867203530216, -0.03154770903003507182, 0.12905602059221518707, 0.036023951388023812969, 0.85410491166502156002, 0.015591657403950714977, 1.5843424307430495901, -0.082266367920763708299, -0.42533613529877184467, 0.027243855164596028628, -2.3264464741560830774, 0.14901478038204274412, 1.9733988782296159048, -0.12640118898597454966, 2.9278293524688816518, -0.18753487466867790889, -5.3030381750634045801, 0.33967300679089129645, 0, 0, 0.001079949373603220162, 0.00076398525832885994229, -0.0029588224413149436312, -0.00087238562334283919521, -0.0051468770632319233924, -0.000377580394132319148, 0.20206863248110379372, 0.0019922299995820589268, 1.1580392187922230463, -0.00065975959477697777422, 1.5693757688347129697, -0.0036086644319118939793, -1.2036926618559800062, 0.0030610351112528135301, -1.7858562430596849335, 0.0045414987038525046412, 3.234636548791644195, -0.0082258007893193495902, 0, 0, -2.5477139138140648842e-05, -1.8023214052146796125e-05, 6.9801726696616189999e-05, 2.058049242980996096e-05, 0.00012142023160711750383, 8.9075177709926672744e-06, -0.0039147530372612262053, -4.699879655023364312e-05, 0.0083402740223943259285, 1.5564421263354520723e-05, 0.34574199476944195153, 8.5132181268765064475e-05, 1.3943620913130563288, -7.2213030853402265731e-05, 1.0658764983780117941, -0.00010713872076029942911, -1.8606498854339041937, 0.00019405527365870157302, 0, 0, 6.7149986095353481289e-07, 4.7503707792034416037e-07, -1.8397611096343514486e-06, -5.4243915417817383743e-07, -3.2002678243831975437e-06, -2.3477506293900330442e-07, 0.00010318097750045069814, 1.2387452601072785849e-06, -0.00021869312922374677631, -4.1023078209430247345e-07, -0.00640633179860586148, -2.2438252417072174446e-06, 0.039347781247833550633, 1.9033157496282319598e-06, 0.58363139903719374324, 2.8238506569827991151e-06, 1.5869170388873774513, -5.1147065050188478719e-06, 0, 0, -1.7089420375974873326e-08, -1.2089516008577751082e-08, 4.6821232322022749866e-08, 1.3804873646549429766e-08, 8.1445619495631410706e-08, 5.9749375653827772664e-09, -2.6259172962527552498e-06, -3.1525603681672934994e-08, 5.5656583656398050473e-06, 1.0440220011988337053e-08, 0.00016303874883739764194, 5.7104513396781534087e-08, -0.00096633013142895208495, -4.8438674145699212406e-08, -0.0074687944270686538323, -7.1865943334113596723e-08, 0.11083792913663595425, 1.3016736807641509225e-07, 1, 0, ]).reshape((20, 12, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=4
knots=np.array([-2500, -150, 300, 1500.0000000000000000, ])
absorb_cons=FALSE
output=np.array([-0.0051418610449036764379, -0.0051207276560822079237, -0.0051517581620670691717, -0.0051036969019558836927, -0.0051724091286762859804, -0.0050616345732373531699, -0.0052108015793779615538, -0.0049476511776847470828, -0.00525764719160080711, -0.0045887810243909702562, -0.0051780211262217532009, -0.0032118234048454639452, -0.0042344880890217376918, 0.0033309098171163710467, -0.0002048781708894489937, 0.036873131791193267115, 0.0053670164361401782871, 0.19556964857406355929, 0.00027785197169554257113, 0.82912284340298503249, 0.65949448911253716332, 0.6654093842010145865, 0.65653556733089935005, 0.66984284447353759084, 0.64987461295218140744, 0.67980900603329297294, 0.63487206047522759533, 0.70218091452751663084, 0.60105778412747068451, 0.75218902517658670082, 0.52490094418674082544, 0.86229539201840321727, 0.35569403068909899446, 1.0895778496922625678, 0.014595118281322956924, 1.4713138143490975818, -0.3821845778229204238, 1.7530984807387750557, -0.019785804601727036839, 0.46986487896086814864, 0.35950128095327349431, 0.35338118891054576265, 0.36256112212690350116, 0.34879091185540550546, 0.36944502095300485456, 0.3384628569483467686, 0.38492806794448852781, 0.31523169436694697954, 0.41971361558839714867, 0.26307215994266325287, 0.49746707294522052312, 0.14713121281897215131, 0.66691371985704051006, -0.097089653687300894735, 0.9873402560545572193, -0.53105535871660392022, 1.2102463767433073727, -0.99135819513191647534, 0.044702741392222536398, -0.3124421698702265493, -0.013853909020907106964, -0.013669845455478047552, -0.013944931295735877447, -0.013530059426987159701, -0.014147224776509979491, -0.013210228408402318115, -0.014589326840338213628, -0.012464957716778975183, -0.015513752524267036478, -0.010672404094858929657, -0.017189996005739616169, -0.0062147814325298833885, -0.018373262457117778973, 0.004180894177922047858, -0.0017304961649907309174, 0.022868412576313085216, 0.16657118464347281384, 0.042690065819077735454, 0.97480521123780894399, 0.013454447506373390722, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=5
knots=np.array([-400, -50, 10, 50, 100, ])
absorb_cons=FALSE
output=np.array([-0.00093170433340244659687, -0.0012410506081968345274, -0.00078243418040293037045, -0.0014789118938009710238, -0.00046560203080319340248, -0.0020151841680895970881, 0.00010431589287147467922, -0.0030688678143442819739, 0.00055449747551044887423, -0.0028609656322684854333, -0.00014909864114985113439, 0.026923379556954812886, 0.00037005603844857983247, 0.24511712352852058072, 0.0023876748113693508323, 1.1555668732201982429, 0.0069273170504410850126, 3.402689781560706006, 0.017141512088352486159, 8.4587163253268489171, 0.084019186191167327671, 0.11446091282800011091, 0.069879045425061070418, 0.13908517998091646239, 0.040857714895860555715, 0.19963820957805075706, -0.009029120060764306635, 0.3576254481931359086, -0.047994837046959955285, 0.77395141822244861718, 0.012905315717303777676, 1.5659844614539342178, -0.032030405994604847775, 2.0431817208334850378, -0.20666651978408043244, -0.51809792415464139825, -0.59959777581040041294, -8.0018873070243543566, -1.4836931018696206674, -24.840413418481212204, 1.0495495283018867472, 1.0438716260482179266, 1.049399522569444354, 1.0346122703952109756, 1.0414030908228715244, 0.99920617535829048261, 0.98168936282733698651, 0.85586872666349445016, 0.66418975301951443946, 0.32605391435347208517, -0.11777757243608029392, -0.85263295720592457982, 0.29231857203837463555, -1.8526421434409372502, 1.8860972902309971477, 0.52133890068006216723, 5.472099406164398161, 8.051943344140203962, 13.540604167014549830, 24.995803341925523000, -0.15192966618287376268, -0.17994115928882439825, -0.13573193509615386065, -0.19726850771611939561, -0.093692687860718673609, -0.2254589026981791422, 0.031190848164371551277, -0.24103262443025505468, 0.43031985595064925487, -0.11127445668091072439, 1.0214738883945315706, 0.29750331491431342146, -1.0287095298822455103, 0.64642959712677627859, -6.6374375162553720386, -0.1819071733449817152, -19.257075485594906894, -2.8095088468476898669, -47.65126091660886232, -8.7216126122287835898, 0.019292656023222061468, 0.02284967102080309731, 0.017235801282051283617, 0.025049969233792938189, 0.011897484172789671297, 0.028629701929927506981, -0.0039554068238157324977, 0.030607317387968895062, -0.047069269398714280728, 0.014130089737258502702, 0.083547466965394667771, -0.037778198719277893136, 1.7680513078000272831, -0.082086298047844605263, 5.9556190709970859842, 0.023099323599362758808, 15.377646538190468561, 0.35676302817113519916, 36.577208339375580692, 1.1075063634576232108, ]).reshape((20, 5, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=7
knots=np.array([-1000, -500, -250, 0, 250, 500, 1000, ])
absorb_cons=FALSE
output=np.array([-4.3178765217391302305e-05, 6.5885993478260890537e-05, -9.6313081793478265121e-05, 0.00015008344269701090522, -0.00021248546106063178089, 0.00034663246069176721631, -0.00045706603540709121736, 0.00082099033067846731351, -0.00092573826895791448514, 0.0020071162494608137464, -0.0016063078222631245202, 0.0047785217809616390913, -0.0016924900384041397308, 0.0058508393862588175052, 0.00037271449492305578147, -0.023079518000319019372, -0.00039460853415255482939, 0.96024636175750266442, 0.0010388953913813049352, 4.2828168145345602014, 0.0006476814782608695956, -0.00098828990217391310055, 0.0014446962269021740039, -0.0022512516404551634157, 0.0031872819159094768759, -0.0051994869103765082446, 0.0068559905311063691277, -0.01231485496017700916, 0.013886074034368717928, -0.030106743741912203594, 0.024094617333946868887, -0.071677826714424588972, 0.02538735057606209683, -0.087762590793882266915, -0.0055907174238458371557, 0.77073211937350760703, 0.0059191280122883223325, 0.065812149128730040859, -0.015583430870719573377, -5.436090696106786524, -0.0031088710956521745793, 0.0047440075304347817733, -0.0069345418891304357392, 0.010808468249184780344, -0.015298953196365492127, 0.024985562378791605076, -0.032908754549310574589, 0.059430528454937264771, -0.066653155364969851604, 0.14814853819552065151, -0.11565416320294498453, 0.38547179702354089637, -0.12185928276509808144, 0.89303994817074205947, 0.026835443634460023205, 0.3158234170040984945, -0.028411814458983948584, -0.033037325841022327499, 0.07480046817945394666, 2.7299491962930431121, 0.99996527520000000333, 0.99992195380000004068, 0.99982468157500004047, 0.99960649719062499852, 0.99911787098710935773, 0.99802618626118166922, 0.9955959649107849474, 0.99021595070231704927, 0.97840786415926050967, 0.95284186025012007626, 0.89870074544754108281, 0.78829881686806935193, 0.57842205914062527761, 0.2362299420741153233, -0.10286920059876342171, -0.080364133358400105522, 0.1089119554261051559, 0.0088355638877152739563, -0.28673512802124018206, -0.73010269203186040077, 0.0031519622956521736561, -0.0046471747304347834143, 0.0071520025891304338586, -0.010320575886684784858, 0.016392005544802985134, -0.022542075546565051858, 0.038353001709637714323, -0.04736186631031753802, 0.093197128054721647961, -0.090485094976372942854, 0.23844273869784807229, -0.13266783181011393422, 0.6114558419262043909, -0.058789413728980027818, 0.96115953962745293016, 0.020964556528278284475, -0.40723600724543668194, -0.0023049297098387665911, 1.0721400439055068787, 0.19046157183439835214, -0.00065664547826086978963, 0.00096816140217391292219, -0.0014898486644021743334, 0.002150119976392662717, -0.0034132712039954154516, 0.0046962657388677176915, -0.0079705034644407205674, 0.0098670554813161497065, -0.019191613515453308236, 0.018851061453411026292, -0.047118889772279910766, 0.027639131627107058065, -0.098264441613631667294, 0.012247794526870834503, 0.1283332564542301879, -0.0043676159433913086874, 1.1341990151205716408, 0.00048019368954974300367, -2.1349300292885819985, -0.039679494132166315268, 4.3776365217391304853e-05, -6.4544093478260855155e-05, 9.93232442934782663e-05, -0.00014334133175951084961, 0.00022755141359969430562, -0.00031308438259118116136, 0.00053136689762938121937, -0.00065780369875441000935, 0.0012794409010302202311, -0.0012567374302274016227, 0.0031412593181519930102, -0.0018426087751404706099, 0.0065509627742421101121, -0.00081651963512472227127, -0.0082410361884569308111, 0.00029117439622608720607, 0.18701233167960798487, -3.2012912636649525446e-05, 2.2892691807041996022, 0.0026452996088110873087, ]).reshape((20, 7, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=4
knots=None
absorb_cons=TRUE
output=np.array([0.17237877473947216256, 0.16160585322933293528, 0.17775653635702576283, 0.15351565450517737355, 0.18982763251278575445, 0.13530235680671015563, 0.21678099966619068795, 0.094474101590757947333, 0.27612342080317897608, 0.004254035614190725817, 0.4030409383688886571, -0.19022791859524765257, 0.65608982528520065625, -0.58588986559744449245, 1.0712259966408619327, -1.27728761497709975, 1.342827694119810289, -1.9788260499202323661, -0.052195429016186831173, -0.97077694213337639706, 0.68714996318883114768, 0.60683822144440202617, 0.72724727397328958745, 0.54653827251673237075, 0.81726443453130048766, 0.41083008335212661821, 1.0183156414681064916, 0.10689042936382432691, 1.4611707976831045386, -0.56312355687140791538, 2.4093551078217010364, -1.9991227596244038889, 4.3052173449842321418, -4.8778668329561920558, 7.4441765017641099433, -9.6842706472508055526, 9.6670625693150959989, -13.322034134461750554, 0.012161980255413960134, 0.22619930950229019673, -0.010768222248548299166, -0.01771835491152162767, -0.0072960943160139245939, -0.022933439873231927647, 0.00050471399250212036977, -0.034662450006663660107, 0.017964357449119585514, -0.060912800432191181732, 0.056636870493901259049, -0.11877531418126709151, 0.14054140101632672799, -0.24279484616490168425, 0.3140184596633784353, -0.49144965505677373763, 0.63173409697146676312, -0.90678479147331569887, 1.0347141866437283841, -1.2221561304860752983, 0.99694564370894334093, -0.056807630788862507887, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=7
knots=None
absorb_cons=TRUE
output=np.array([-0.088612856492796668317, -0.10148345379387192777, -0.074820024844059834779, -0.097934158724637176974, -0.030963004348234846042, -0.058173986143542688598, 0.090101482080220576809, 0.10049075761090919823, 0.29596829876665797787, 0.41518677441788176541, 0.43034390532152527742, 0.83452635605264402496, -0.13348462782429343365, 0.98208889847295099962, -1.4362329672138189895, 0.92468785756571492129, -2.6216702734870915847, 0.6954743327776672368, -0.0022196047790754855691, -0.12327370541474826082, 0.24123862297275155964, 0.35840804363927752929, 0.18093342115646737778, 0.44250759269715284061, 0.043937153723061256327, 0.6202158021725746595, -0.24740540994207005365, 0.96645134975980595549, -0.72475992234705299833, 1.5060196314875564649, -1.0261673763863199405, 1.7262771004734287494, 0.32934388972170997034, -0.37505857126375657939, 3.4434877057227697428, -4.9947636565362447669, 6.275814996477087071, -9.1524782805583591028, 0.0068271591356862497413, 0.37917074789447108296, 0.35954055514606403365, 0.35954551446237459356, 0.35744096324407559351, 0.35584226884375003142, 0.34885947617865670223, 0.33862610062421411028, 0.32049681236018934261, 0.28089301373203690027, 0.25602145147051952323, 0.16597482970505655908, 0.12171945403305862998, 0.0018741765108557348514, -0.13785069799652086009, -0.10675519142579256715, -0.57612609827379823724, -0.22195090041542500647, -0.96232722728117126021, -0.44017455467682947701, -0.01453255272801050671, -0.80711739351329703229, 0.39138909874594340899, 0.2727563805116787754, 0.45531894883729062684, 0.19274617399836088683, 0.60538032158012156092, 0.036358318155975434538, 0.93314031181054180042, -0.23999550325584054211, 1.4531806967029836652, -0.67840171762003531608, 1.6665321594967388297, -0.95105942435581225514, -0.35463732068059222735, 0.31454920667339703044, -4.8088313747127671149, 3.2255742320619229524, -8.8757338424365990193, 5.937464168828833877, 0.0075040642903919140341, 0.41676510136746514057, -0.089133365834868971689, -0.10118952771068721874, -0.075725350737607874385, -0.097115177460207771643, -0.032342847263930989132, -0.056715061432944156861, 0.092352440078496370046, 0.098331113369192327256, 0.3400969886051333213, 0.37108103090272787083, 0.71036876576058238797, 0.55444750827998945386, 1.0162219858335352907, -0.16763759291903618243, 1.3370398275661443677, -1.8484727482821472488, 1.4719012302123679614, -3.3978810087925515049, -0.0022219907599747576801, -0.12340621941421109353, -0.013194863919370570376, -0.015072699772667915927, -0.011151244212216769591, -0.014503828881363881043, -0.0046275650331869689486, -0.0085121840139092009442, 0.013410603654954418931, 0.014660726583422474187, 0.044001710617309369722, 0.05545171716304433257, 0.063619527459568614436, 0.082887169332405197242, -0.019275003418586279108, -0.025046122964883565931, -0.18452246030655442, -0.27630735647963872159, -0.17524590664413686181, -0.50790642667837671009, 0.99966985744385294943, -0.01833564992966553106, ]).reshape((20, 6, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=10
knots=None
absorb_cons=TRUE
output=np.array([0.017741203875868801626, 0.059666517581418020144, -0.0073055449468428850998, 0.071233532376632907601, -0.061951321114274808532, 0.023459686026844089879, -0.15952965061095217281, -0.21534242305337428225, -0.20894123625115404441, -0.40851053368902323637, 0.088769309083260417026, 0.1702312769628678002, 0.44867980227835829732, 1.1139500668975872433, -0.14345767930218020214, 0.86682083739859494553, -1.1837156997359956634, -0.21597943647408635037, -0.017918712309548733702, -0.23789999499399971938, -0.0050889918235734665428, -0.017199613011022536063, 0.002072270281447358229, -0.021223643286449593581, 0.017930549906902432111, -0.010400764195970725601, 0.046747049525783831991, 0.07425318574607586708, 0.061514150450350559007, 0.37070324197740467387, -0.026117581474140658115, 1.1506456698664466742, -0.13217536320689113327, 1.766217994670280067, 0.042129159012710096222, -0.26549271162309995287, 0.34842176083555986832, -3.4777238134306913686, 0.0052384550413758917964, 0.06954899473750200678, 0.040717410233940966313, 0.14267724274658066808, -0.01518518709909348792, 0.21755481940124130058, -0.15305036931474685913, 0.39059745188013861306, -0.43311720487012722591, 0.71916259556541839437, -0.58682103919738470843, 0.86959977149390199624, 0.24816600986825945729, -0.22985936815572685643, 1.2655729988498243266, -1.6266494012894197052, -0.39570727271363553834, 0.14945216327392790712, -3.3194533089504827394, 3.3989844591011317831, -0.047815351859148348679, -0.63482641896460045849, 0.12003828098968173654, 0.69730715192779646472, -0.080805333880490451404, 1.032100885251629574, -0.17573134714242774623, 1.0800934656851248761, 0.36589399540256600796, -0.28448323213545234633, 0.88954585755350989995, -1.7064483114238784278, -0.35386353683003346493, 0.6479603434190704947, -2.0242657690367202861, 4.0363385548625183574, 0.45966058247434787853, -0.6843648579769759932, 4.9332279555632334578, -9.2892931271418373029, 0.023611216265584832746, 0.31347722617275158852, 0.88792799224608875974, 0.25713275781065136893, 1.0532535169725301127, -0.17260864810915746426, 0.90704417033506612444, -0.47809553851771402488, -0.43024289925585679217, 0.30393926379684116368, -1.7282652053936073955, 1.1666632610962044403, 0.66595310521671158277, -0.45052173959023528171, 4.0350412627641443208, -2.7188693891544946091, -0.75770752213855696588, 0.51778556938925135444, -9.4893428981139695821, 6.4121669845342363914, 0.0013130525053329394382, 0.01743290360653331969, 0.018394340893766202016, 0.12954185558052447313, 0.015467038664664091788, 0.1947806488224434196, 0.18978123265431517952, 0.10064263984709266586, 0.87856041959654240792, -0.56951570226238645844, 1.3795704170465219462, -1.1253701882691806713, -0.4264441361865796698, 0.45357497790875550558, -2.8031655399252684013, 2.5198958573805381178, 0.38077992198436172444, -0.6254498513067092702, 6.2761716348405380828, -6.3399143661490446888, -0.045339936718340946575, -0.60196126440255459666, -0.004758953821358206937, -0.017005411359244829855, 0.0016248940817804027534, -0.020892741105429570719, 0.014155429774586492792, -0.0074074070841472963028, 0.057823550154750644192, 0.062836648910594553041, 0.313405031875580109, 0.11923488274498127149, 1.1726262403941665191, -0.048228614408167384819, 1.8989517069621104639, -0.26605941795394616456, -0.29079224977894058135, 0.067405260889645518541, -3.8003055548041984046, 0.6731217514912637423, 0.0052018569797349914138, 0.069063096056237921472, 0.017736305328008575982, 0.059663635167637223133, -0.0072989048214304030199, 0.071228621002306605203, -0.061895289364833461221, 0.02341525749747295701, -0.15969206961095888664, -0.21517495710840772727, -0.21175703601763257167, -0.40570100515546192455, 0.094808655216413129097, 0.16419386720169948379, 0.65787987528453284458, 0.90476706770574533145, 0.95333742847376501395, -0.22997392252730572415, 0.8913620730776831147, -2.2910886491383859465, -0.017918169107386142797, -0.23789278310346156919, 0.0060750632566522310557, 0.020430784619126868273, -0.0025017991326720841194, 0.024387881029101547703, -0.021213459590422957535, 0.0080142623794636578399, -0.054619250223539139721, -0.073674968074426458453, -0.071500525070803497285, -0.13890622902065649646, 0.030313398118739860038, 0.056217781624179681554, 0.1514331690285295462, 0.30977852573253761292, -0.046930667126897918084, -0.078740760116175548267, -0.2465351039505715991, -0.78443722293869766471, 0.99386473410822107066, -0.081455614651688740269, ]).reshape((20, 9, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=12
knots=None
absorb_cons=TRUE
output=np.array([-0.10472685656120690745, -0.12767819762829035746, -0.076360123823526582232, -0.10958044510013424666, 0.0027880985603357523288, -0.00047490167664404706613, 0.06928482401745712782, 0.12032832514458154105, -0.15700287132688625635, -0.1737016309573724826, -0.34110464392275169354, -0.43703758617891158567, 0.21658232947898950482, 0.33207321984948795501, 0.31440967571649758305, 1.0125703207549268114, -0.77927839590651259982, 0.57499654812351752575, -0.03855715180341089815, -0.29753053676014623585, -0.045155067335396106842, -0.055061683622734447496, -0.032913973166337623377, -0.047180638471765484754, 0.0012046656812917998312, -8.5942102116568291834e-05, 0.029855775209106073798, 0.047937464934110683712, -0.067681928151560877271, -0.066458149628327731206, -0.14703046798660462935, 0.16005131398107033669, 0.09335066435731875778, 1.5205934362940900506, 0.13551522132064452997, 1.2508474777651827914, -0.33590194032153924963, -2.2969931440729616234, -0.016622640017795731193, -0.1282704446656750541, -0.15034574662694516478, -0.18284705677723475659, -0.11005017611978802627, -0.16012547886604538983, 0.0038970012572561371633, -0.0056574341249261998407, 0.10020869531895890137, 0.37404580513022472887, -0.22593678600553301905, 0.90889537861179725553, -0.49151450544890296079, 0.95180903084537338277, 0.31231202672612079496, -0.78416614637393700082, 0.4534081611517823962, -1.1711369929499528819, -1.1228952128467266647, 1.7833321983277987677, -0.05543814773678283625, -0.42779461349253811164, 0.021352229303511102015, 0.007531901115204664085, 0.033244696218130601051, 0.14543534382436593133, 0.0037956069961920194805, 0.8473147453077168878, -0.044854732714249959113, 1.5853682337831724869, 0.054480061579266131355, -0.38616534110945410774, 0.14497807394687750593, -2.2653864188032963867, -0.10147073278861845624, 1.9430514052120930746, -0.14850072666747962669, 2.8843894925937085816, 0.33098715709405579499, -5.1548937962780287947, 0.011396952652503542641, 0.087945848734329423735, -0.065952557774967432436, 0.64935218850878217989, -0.23655843353990058109, 0.90262481725902277141, -0.044372232611305732763, 0.23939481976571783117, 0.37009197410777977533, -1.0588087616813195435, -0.33957241343679639423, 0.13426223409097867711, -1.0193888969785738219, 1.5733219045695456817, 0.74691289987499476233, -1.4520157873552757, 1.0969502242749886722, -2.1629612193760392458, -2.3264786688505232348, 3.5372496286723378311, -0.062415510749811636826, -0.48163620876963536555, 0.8195140136919921714, 0.045981988292849676481, 0.88170239584467990923, -0.36155327574779005939, 0.19875523391830787756, -0.098276866020166997462, -0.93084557008965973512, 0.66449081424484612857, 0.14207954819710574834, -0.38575918922177282466, 1.418831177364036078, -1.467509312217160522, -1.2937127610296201841, 1.1548650229305499337, -1.9279955842607379157, 1.7067654635554521114, 3.232004184432778704, -3.3827058656451867158, -0.047797409383925140713, -0.36883400885657852131, -0.021262964105923369551, -0.0031022854611233788291, 0.1460681949195489493, 0.060436933823290558965, 0.85348373794725573838, 0.015696770625561979468, 1.5689066026927753761, -0.10905135306422376884, -0.39035761984884714826, 0.065894018981400556689, -2.2504521949512743539, 0.2449549909100549594, 1.9251468021185453861, -0.19161744080459083839, 2.8577824618961185088, -0.28309810920621092389, -5.1294237100882460467, 0.56511845971327800964, 0.0085901166188240788563, 0.066286587283785933233, -0.14931374206792483172, -0.18258953057237148343, -0.11261589846568037521, -0.15823359174408363481, -0.0011429154130191262681, -0.0010551192149562264085, 0.30156489541842562696, 0.17464289155956300159, 0.93257469826065064744, -0.24979099176207356092, 1.0795318316732362973, -0.62202008893514815213, -0.89266942187285236443, 0.42343196160757057278, -1.3343479845023715757, 0.62052301130682563368, 2.1155524024387766246, -1.4614021376163455201, -0.055370175087794709645, -0.42727009501042717554, -0.045179413406039932444, -0.055067758936182993612, -0.032853445083453579334, -0.047225270074522207597, 0.0013235626049733512782, -0.00019451554100623699175, 0.025957829199430799971, 0.051789330864583066338, -0.059352795367343585964, -0.074783156665720870726, 0.19867211632366271745, -0.18558562156573668589, 1.4877431595022336808, 0.12613921140813655342, 1.2014365403948221722, 0.18483406256944329149, -2.1966417328137768372, -0.43610504124242488455, -0.016624243563923207095, -0.1282828186071544585, -0.10472621487286955244, -0.1276780375015148794, -0.076361719159604879437, -0.10957926874689910557, 0.0027849647992298789088, -0.00047204001118300933926, 0.069387562012853995497, 0.1202268016798509892, -0.15722127080697423374, -0.17348334021941591576, -0.34750993698157911505, -0.4306340234217196361, 0.25592930937433366889, 0.29272786696227376391, 0.89803989341652912248, 0.42894253042841035128, 0.80764101265733667656, -1.0119267694495412968, -0.038557109538814519911, -0.29753021062070239555, -0.052405524507834276571, -0.063890551260129033184, -0.038210563318028127611, -0.054833362353974436643, 0.0013952838636999886825, -0.00023608614675063352537, 0.034667393120659889538, 0.060161039317539917459, -0.078558784282471219584, -0.086811135096279259948, -0.17052577031441601418, -0.21548879873646650807, 0.10741142530502149899, 0.14648050866337228304, 0.14986173697025292895, 0.21464206783358963371, -0.2791130852403586049, -0.50636714208926458802, 0.98070595851787800701, -0.14888461024604163208, ]).reshape((20, 11, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=4
knots=np.array([-2500, -150, 300, 1500.0000000000000000, ])
absorb_cons=TRUE
output=np.array([0.026705483244849264474, 0.029839625165101336945, 0.025137490946490849419, 0.032188537945938233698, 0.021607394654091297004, 0.037467894551815809911, 0.013655036980899055293, 0.049314030316796791942, -0.004274510570643489521, 0.07576300788030972122, -0.044664576703176542272, 0.1337724526334178321, -0.13422281221596993328, 0.251582066127820414, -0.31121876398729647617, 0.43612872129651875097, -0.47985225176217655152, 0.49291724756068344693, -0.081762536217311512776, -0.57008353784816034882, 0.10575886843256800118, 0.098523720643000009534, 0.10937645918695998448, 0.093097559739294566405, 0.11751580252413190708, 0.080890140328454290808, 0.13582591101899046948, 0.053438242334149517465, 0.17698108482519578355, -0.0081682818617542177903, 0.26907668054096511856, -0.14499960251139776268, 0.47046169477357585587, -0.43311804519238522593, 0.8566919676788534721, -0.94615480020651354653, 1.1710825622951557268, -1.4966789629626817693, 0.019850657594207062745, -0.7294516591807701511, -0.065495278981390098183, -0.065538150305470069257, -0.065472788689835886844, -0.065568482416232795607, -0.065419575517949940524, -0.065631137544391218719, -0.065286317209239316806, -0.065744866169428622937, -0.064914403751873434034, -0.065874953263984459273, -0.063671751390664124703, -0.065668915889071088898, -0.058354957302844213951, -0.064207225531959205567, -0.028319888642541334034, -0.061612158154530236032, 0.15860060924423530215, -0.060152247616144620401, 0.96974734313860999624, -0.071414854005294861605, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=5
knots=np.array([-400, -50, 10, 50, 100, ])
absorb_cons=TRUE
output=np.array([0.21482323419002713472, 0.24750397604597326739, 0.19883614002139288202, 0.27258973708238182221, 0.16379621347999451242, 0.33062932586024107451, 0.090229192760086424085, 0.46740970723200020442, -0.043673571594035724697, 0.78496238070321600055, -0.14225997541844798144, 1.352022453322457185, 0.3403195391608931919, 1.6947780812699095865, 1.6168904854104195756, -0.12774151466578054226, 4.4891751144718545774, -5.4563586958095688928, 10.951815529860082776, -17.445747353383097789, 0.78661625540292257064, 0.77643763922916775311, 0.79017886797586167624, 0.76625062041079372577, 0.79428060270008205013, 0.73589687070232667754, 0.78216715039058581915, 0.63518798334179016329, 0.65550344333732102342, 0.30392043723920803, 0.19412499069407199159, -0.42254129005404528208, -0.4561535986725677172, -1.1523051841355156366, -1.7794911913869626563, -0.26332862233794968043, -4.7570007749943510333, 2.9350973501194954629, -11.456397338110976492, 10.131555788148743247, 0.21540397689706236584, 0.19368025263260429947, 0.22641495625607274689, 0.1776489056064568528, 0.25155233513796670941, 0.14240007942952948028, 0.30993541465339075058, 0.067271686044363815382, 0.44245515455816608608, -0.080352654001592846433, 0.58572719290272645676, -0.30336068837952584465, 0.016951242449324648714, -0.3319833812262538153, -1.5163892893085060276, 0.9143206895602743467, -4.9664054857636248386, 4.3390336686705470726, -12.728941927787642996, 12.044637871668662399, -0.24478425848794690967, -0.24574753349402200797, -0.24311234670203171748, -0.24447893336440842948, -0.23629987575155153579, -0.23582487990744877004, -0.20434545124769434854, -0.19103328802457081315, -0.055793360625630179783, -0.0080996580588084746144, 0.39680666612040660368, 0.39418417396254185059, 1.016323619403686207, 0.62129681239849587904, 2.2740869262794469741, -0.76498115062552785037, 5.1040543667499091995, -4.782338947138994989, 11.471481107808449096, -13.821393989294298521, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cs
nb_knots=7
knots=np.array([-1000, -500, -250, 0, 250, 500, 1000, ])
absorb_cons=TRUE
output=np.array([0.18906235677058036426, 0.18778525841872689695, 0.18966313099776943574, 0.18676205783172145081, 0.19092371457093507137, 0.18426214279619892999, 0.19330747373751991369, 0.17770329603139525809, 0.19648166130871616564, 0.15897921699813499785, 0.19369977803300092445, 0.10544719310340035234, 0.15040730339948449323, 0.026126087939682636485, 0.014566423626603465513, 0.71038417591713942656, -0.0044258520659356658661, 0.37477303749040830061, 0.11191608928948779123, -3.5378245461949706652, -0.1717114269621455025, -0.1641796852631927095, -0.1753614922544594612, -0.15832977440814030579, -0.18329458477753993173, -0.14455385888762556368, -0.19975455127362412577, -0.11060689494904693553, -0.23004851008792162603, -0.021054716326888309186, -0.26742505651389464338, 0.22697177040482915955, -0.233733177660145508, 0.79112685520733139199, 0.0087978598061598800584, 0.36982567289124945731, -0.019154626403592486805, -0.30951045809435018263, -0.039292263384108856716, 1.0312889189371063914, 0.550395590305010729, 0.54949597448884435202, 0.55072323934346578689, 0.54860843215917232119, 0.55116651719216569472, 0.54595839995564021674, 0.5507105841767095944, 0.53682026836985941021, 0.54272290221675423272, 0.50167044456244525019, 0.49401178725604522057, 0.36566698512261336385, 0.28011631034896739001, -0.03551586186561946773, -0.15096545178713224877, 0.063629989613431983675, 0.133595751562454651, -0.72836523541381203994, -0.59095728594899554764, -5.2594893416580195122, -0.095090409079557833283, -0.1030766681400390461, -0.090988045895585706324, -0.10887508452680887128, -0.081496719465270400784, -0.12133034539926186579, -0.058865730473533696421, -0.14644031510302549237, -0.0020110794198277630838, -0.18907748512879404834, 0.15000794369741921042, -0.22502359947941463769, 0.5462684746707909822, -0.11817275982033918769, 0.95064928964895001329, 0.052430922211166117175, -0.40184197213040517838, -0.16340199015776293856, 1.0056597912908593617, -0.79932421729955860368, 0.03971313277885706039, 0.041414831889495302975, 0.038837883046586599289, 0.042648161751521966589, 0.036811186605924875459, 0.045290364726222026581, 0.031978640736114505305, 0.050580394866669355081, 0.019931365400903504337, 0.059364669508446515911, -0.010779243096346216579, 0.065589985310555209974, -0.071477633391997127954, 0.036649613012278252355, 0.13265213083724519683, -0.017297782300268411959, 1.1319824969476413035, 0.066678235503076957458, -2.1076119483122943699, 0.36704351417936742497, -0.098246537944137943277, -0.098542071754031859698, -0.098088618240313230068, -0.098745945231101361905, -0.097708943948828105852, -0.099149563571540588747, -0.096734808676916902992, -0.099784603436978008828, -0.093975228815392539139, -0.099897241328297553542, -0.085336692453571283412, -0.094243446676616243751, -0.058668216352278305947, -0.060228845196453252575, -0.018756415239227899883, 0.03177289587597233872, 0.19240899911984374326, -0.16120768980326213859, 2.2227564852817449648, -0.98762351160861328037, ]).reshape((20, 6, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=4
knots=None
absorb_cons=FALSE
output=np.array([-0.00011851815295720334641, -0.00012663567739435794201, -0.00010982693555193819436, -0.00012486657068400786952, -7.8574573747497574675e-05, -9.7456835655811038625e-05, 5.4155250158153698734e-05, 7.2018696214385270055e-05, 0.00068058583050101088829, 0.00094879940917660596233, 0.0037183147633434721069, 0.0053485055580019882915, 0.0183840295424396033, 0.02677749980087675008, 0.086329741280370991818, 0.12474145818684392872, 0.3626441834851739654, 0.49882426586368627808, 1, 0.99999999999999977796, 0.35563445619191813574, 0.46362413648379807718, 0.30171426160013936624, 0.54469854427884600856, 0.18065455579032740907, 0.72714127654712401583, -0.089788280381099649929, 1.1356676987661198375, -0.68581279037676712296, 2.0358855654123400036, -1.9635811732571735178, 3.963516193961472478, -4.5268166706294525881, 7.818994828526680152, -8.8143777554827753562, 14.211587381298102173, -12.092085343347227067, 18.821721967074164894, 0, 1.1102230246251565404e-16, 0.64448406196103913413, 0.53650249919359616069, 0.69839556533541258254, 0.45542632229183804826, 0.81942401878342008281, 0.27295618028853169124, 1.0897341251309387022, -0.13573971746233581825, 1.685132204546259338, -1.0368343648215159192, 2.9598628584938277974, -2.9688646995194716283, 5.5084326410870145807, -6.8457723283275555559, 9.7280480142024003953, -13.336328839484941966, 12.72944115986205027, -18.320546232937854114, -5.5511151231257827021e-17, 1.1102230246251565404e-16, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=7
knots=None
absorb_cons=FALSE
output=np.array([7.6647956129152551405e-07, -1.1550595444117308123e-07, 1.9331333022628060142e-06, 7.0074370880358996831e-07, 4.276544862176869743e-06, 3.9889844050692401989e-06, -8.8286906818606534835e-06, -1.1748087754222518581e-05, -0.00018052779655174404014, -0.00026002337472508241234, -0.00087512057847980513799, -0.0012887090681721327309, 0.0010150616469118238505, 0.0015068191039899082179, 0.047197284048099072407, 0.069183314412051222231, 0.31391535501834866295, 0.43677277426050831188, 1, 1, 0.00010414066623386542833, -0.00015235200709813872134, 0.00016280595673724983273, -0.00043421191677436572591, 0.00016730985750816495974, -0.00096382547591343699107, -9.0113367500726122014e-05, 0.0019506005877063976872, -0.00042706768120516621842, 0.042844970995241649092, -5.2132124969551940641e-05, 0.27943748664501288914, -0.00082303187571104372, 1.1480003233353344161, -0.045428857401670741378, 2.6726262314060083014, -0.26572750370216563498, 3.4985477308433670096, 2.2204460492503130808e-16, 0, -0.031639925468625686167, 0.046730544589411379675, -0.049698223025307776413, 0.14261932064706925316, -0.051804308700160631163, 0.44426741959012128191, 0.029985561329029603028, 1.2694922528331589184, 0.18639387492323189477, 2.6501418567322971853, 0.29516026175368154094, 3.4280258862936845432, -0.075791571757795037079, -0.87883069340180242079, -0.70490461473281773586, -10.07981330853315427, -0.24791206297674328596, -16.148116252431378825, -1.7763568394002504647e-15, 0, 0.9404004428081522704, 1.0229943455861092438, 0.84837282177641593073, 0.99419676362025177774, 0.5526597738396983317, 0.71315928497606728698, -0.26997136265236038044, -0.36417829458474493265, -1.6835610275209540454, -2.2695939445331143602, -2.6912296816355203433, -3.6212526616197560081, 0.7249087759092099903, 0.96643128272326350725, 8.270877054240102666, 10.639570935701080145, 13.016842606390081727, 14.65915427188926401, 0, 0, 0.091455790248830992617, -0.06982269652782702174, 0.20182330529950023856, -0.13687095276618752027, 0.50015399051603726122, -0.15701950364285152673, 1.2380162944797474811, 0.093052186884682086543, 2.454295887293517886, 0.57831424352675386835, 3.117018133244208844, 0.91526479748152955729, -0.79779073451863469213, -0.23433512959673663545, -9.2728475980951614588, -2.148398325632811634, -15.512250940383852438, -0.55028191775469181835, -3.5527136788005009294e-15, 0, -0.00032121473415268157747, 0.00025027386535885344336, -0.00066264314064781932364, 0.00048837967193203002999, -0.0011810420579453353648, 0.00055263556817129462322, 0.0020684489017660893928, -0.00030499763304578722534, 0.043478860781959838278, -0.001447103346453879405, 0.27997853934107919116, -0.00018679973229867273543, 1.1484815005960040679, -0.0027726021640539499913, 2.7051067319414512369, -0.15316884735317959354, 3.6951325456543355763, -0.89607660680706602285, 4.4408920985006261617e-16, 0, ]).reshape((20, 6, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=10
knots=None
absorb_cons=FALSE
output=np.array([1.7052675937596968357e-07, 2.1554130872244172271e-07, -1.8766481785820174288e-07, -2.5625876315796275659e-07, -1.3028476697477565147e-06, -1.8631355726629473538e-06, 3.6693095004218680534e-06, 5.3764688723538902118e-06, 6.0796641288638842218e-05, 8.9528552951850039502e-05, -0.00012887069103758740009, -0.00019001548651089925079, -0.0035275680979317425995, -0.0052024266625657657193, 0.0035256702065387685724, 0.0051982990643293265631, 0.2362999429577772037, 0.33323526570676581526, 0.99999999999999988898, 1, -1.5536971506019493448e-06, -3.7723308315471718504e-06, 1.0498525832867015351e-06, 6.1264614941971342081e-06, 3.3796481270836038393e-06, 5.4203738638415076344e-05, -3.5129100336125819986e-06, -0.0001705894910869632658, -3.7468155003797335172e-05, -0.0028884082386604389286, 6.8182896976374759469e-05, 0.0061884953395126701681, 0.0018130647206160395782, 0.21325100724817980247, -0.0017981230343969457908, 1.0927529255884664838, -0.10407530163420519731, 1.8409714784490120998, 0, -2.2204460492503130808e-16, 9.8228540403516947542e-05, 0.00024501849587308256306, -6.3993936608566740908e-05, -0.0004010047866267046901, -0.00018304683587852169481, -0.0035611604429654220016, 0.00011419029847733929632, 0.011357234442518585049, 0.00050617348630547251507, 0.25226492984599047098, -0.00032188615231765204967, 1.1982978420717516066, -0.0052489266241784434189, 2.0211806750240537411, 0.004422931600446426692, -0.32320182404955488664, 0.24763812678503760445, -3.5956683328958609636, 2.2204460492503130808e-16, 0, -0.0066286721449819972773, -0.016550854830837284648, 0.0043124327641686751103, 0.027487867638282981186, 0.012275008624007566552, 0.3281445173550811556, -0.0074331317422015865878, 1.2933290334062270688, -0.029450751586844299557, 1.9518047804513476429, 0.011641882663420602406, -0.66721597637483753829, 0.077812573766972065181, -4.01958848618877429, -0.02237250215454568425, 0.74181768967199701592, -0.70957277332229884426, 8.2779135644074397504, -8.8817841970012523234e-16, -1.7763568394002504647e-15, 0.14341792272585895951, 0.77593418511036460483, -0.090433414170275921995, 1.1259556534302141984, -0.25737004638880062179, 1.110930597939268516, 0.15569410127086877327, -0.56800026419801152855, 0.61436360579663806813, -2.2407355088743035054, -0.23716773295804302601, 0.86370268070518285697, -1.4404805919834702266, 5.2118285879993342391, 0.2780344963834942007, -0.97074031271066019144, 3.8024793557257794419, -11.342987956092152046, 0, 0, 0.88922860214889154484, 0.26150593343291061998, 1.0527176310249597435, -0.16739004844301930142, 0.90250111388972187321, -0.47638677331480472343, -0.44192413673958003129, 0.28819070120487033648, -1.7434322051050550328, 1.1372558503535050711, 0.67215428910723273859, -0.43917237872741754501, 4.0596131096953849138, -2.6712549469068491703, -0.75992694414757844257, 0.51959152341465042468, -9.0955055761811927084, 7.3255691971501466497, 0, 0, -0.026500878677340050649, -0.021443321240789712384, 0.033955530529363592285, 0.01455399094161052842, 0.34654945272048409688, 0.041426545282572141415, 1.2822017995143766278, -0.025084826033741181028, 1.9080047293712101286, -0.099372016748206934422, -0.65055242209998476177, 0.039244657655196912849, -3.9247579397546936697, 0.26136174203674272798, 0.7301169577862545168, -0.074258542407508620897, 8.480299193362036192, -2.3225008358095564631, -8.8817841970012523234e-16, -1.7763568394002504647e-15, 0.00039214456274060853838, 0.00031751196529807511858, -0.00049656870424369891313, -0.0002157937723172946836, -0.0038324354523821676718, -0.00061725037261922916041, 0.011518730827296382035, 0.00038505493185519946639, 0.25286023990754330493, 0.0017067621188927551389, 1.1981634895781139161, -0.0010852069418095661169, 2.0228506259066678652, -0.017693728679951309379, -0.32609759852778003042, 0.014908398163377523105, -3.7765166040071465048, 0.83470297192668896358, 4.4408920985006261617e-16, 0, -5.9639851815191078669e-06, -4.9161432965675507926e-06, 7.5203048707079762948e-06, 3.4647891244179194819e-06, 5.7876642390457017258e-05, 1.1182950401982235801e-05, -0.00017170982870512408684, -1.1720731503335203019e-05, -0.0028751203560827250441, -0.0001259174615164541705, 0.0061430676556425214963, 0.00022990175893332354118, 0.21192565237063318295, 0.0061175761298287428119, 1.0940951118875659187, -0.0060681567350964193963, 1.9189536363142121189, -0.35123535284248763588, 0, -4.4408920985006261617e-16, ]).reshape((20, 9, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=12
knots=None
absorb_cons=FALSE
output=np.array([-3.5802310279784754585e-08, -4.6262647978685225562e-08, 8.4108204760015214405e-08, 1.1691317515513621075e-07, 1.3383585568882782416e-07, 1.9334920179260735574e-07, -4.203667662871902566e-06, -6.1443325945584099136e-06, 8.870740522791627539e-06, 1.2991653852666520431e-05, 0.00025968489610813934136, 0.00038043548035123880531, -0.001538951033558028092, -0.002254678726504918268, -0.011894389332899407696, -0.017426311105119260403, 0.16787692522771835435, 0.2391755401848442153, 1, 1, 1.5979133269021421162e-07, 4.7768854385179628339e-07, -1.9425098428285929911e-07, -1.661723207394062299e-06, -1.2068855552733148196e-07, -3.2055922738442340194e-06, 1.9511133954906500148e-06, 0.00010616629891630242227, -3.4565252886977172405e-06, -0.00022600512710102375891, -9.8259384682155117077e-05, -0.0066248710130454744813, 0.00057889080026267934753, 0.040648127270414641243, 0.0044706215223907566636, 0.59368709533766184094, -0.057610288739808043768, 1.4572996890794969183, 0, 2.2204460492503130808e-16, -5.5109923531389489217e-06, -1.7294660575127571221e-05, 6.1519217837447675384e-06, 6.0756378562884462338e-05, 2.7216035102121806338e-06, 0.00011763795929723115457, -1.6476765274556428198e-05, -0.0038995592960682475339, 9.9827397529189624958e-06, 0.0083454262915318017102, 0.00018240275250513114397, 0.34605772709145571353, -0.00095280597828643811414, 1.3922985845928645965, -0.007230442437518780005, 1.0497271498165361425, 0.092837834238923916397, -1.6519805635559703383, 0, -4.4408920985006261617e-16, 0.00023261122232546074806, 0.00073160846398710190595, -0.00025857850183971374958, -0.0025712720147247018071, -0.00011201881409144995674, -0.0049793706065786738982, 0.00059472548275806631952, 0.20119309669405308072, -0.00020482161298259401474, 1.1583114626193435903, -0.0013424798341694420094, 1.5703649598779465535, 0.0025261771262702131455, -1.2014100351887648799, 0.013860165507571235721, -1.7597171609627610955, -0.16373073924917352917, 2.8753824912917806955, 0, 4.4408920985006261617e-16, -0.009603671354393113202, -0.030208220454698501978, 0.010673917274214628215, 0.11304566492258458221, 0.0046199850162510491813, 0.84717578954956962445, -0.024382491288093402493, 1.620889030714223189, 0.0080875614382544102482, -0.43741011526471584858, 0.044600501680212630007, -2.3916675588781384221, -0.040106814398597687155, 2.0236045109652547325, -0.076082896664545401899, 2.9650152140638748044, 0.36507708741878691638, -4.859029716718211489, 0, 0, 0.10357736791963742529, 0.85603579089397319191, -0.11294862650356479739, 1.0800085662880150039, -0.048885819171624864121, 0.24015822941969325321, 0.25794065020098305707, -1.2534166511355830931, -0.085429974450229081984, 0.41506987095643310681, -0.46751914821604279027, 2.269740510670964273, 0.39810586745371900896, -1.921845360279117898, 0.60183408291126982981, -2.8261756066203411741, -1.2434080193894079258, 4.7739148511542310871, 0, 0, 0.94933899366841034695, 0.20425903192036259926, 0.97636197471447405682, -0.22571398353340010878, 0.19529869420992360118, -0.097692387302149769068, -1.0167283962036961498, 0.5154656778185841004, 0.33669612032614604225, -0.17072771898201555274, 1.8413288872915176686, -0.93446780726201750245, -1.5601117305432461446, 0.7966817961552830063, -2.3016241440126483653, 1.2113186062078835636, 3.9901615392586013975, -2.5959908523544878989, -4.4408920985006261617e-16, -8.8817841970012523234e-16, -0.044595107940631317778, -0.031547859459583466046, 0.12905624158450940131, 0.036024366939322927106, 0.85410524864504355769, 0.015592380256197772501, 1.5843319897343188796, -0.082289673658138620671, -0.42531415373425501825, 0.02729325191154396979, -2.3258032067945428878, 0.15046179406667054002, 1.9695869973481714421, -0.13497763436486276412, 2.8983680069011104052, -0.25382247697616189264, -4.9233259421066879469, 1.1940247607627194615, 4.4408920985006261617e-16, 0, 0.0010800130290116449761, 0.00076408094461186495429, -0.0029589630116448285488, -0.00087264995012978460905, -0.0051470914118511394697, -0.00037804019106299111778, 0.20207527387121515527, 0.0020070544765826729347, 1.1580252366043886081, -0.00069118022426611653436, 1.5689665948166240383, -0.0045290910522769603844, -1.2012679739112754884, 0.0085164006815267589978, -1.7671162635968691301, 0.046706182018272840439, 2.9931065266471703623, -0.55166786071240503375, 0, 0, -2.5513815072961419693e-05, -1.8078345013767598096e-05, 6.9882718216176479414e-05, 2.0732787925975703258e-05, 0.00012154373149783886249, 9.1724360658872410822e-06, -0.0039185795650754015607, -5.5540121878291909925e-05, 0.0083483300512910106617, 3.366784700094217677e-05, 0.34597774598037167593, 0.00061544857656690001111, 1.3929650741667591873, -0.0032153965723222335815, 1.0550792027144637597, -0.024400898124765986463, -1.7214890573288510467, 0.31330563624629470532, 0, 0, 6.9427404324062452156e-07, 5.092710402106320213e-07, -1.8900533691006157141e-06, -6.37008124488906817e-07, -3.2769559589167800075e-06, -3.9927796023670766917e-07, 0.00010555708713181393625, 6.542541903472452638e-06, -0.00022369557760034113753, -1.1651681607648470274e-05, -0.0065527231879012725474, -0.00033154755847665279712, 0.040215268969781864383, 0.0019536854662268524074, 0.59033605648767484286, 0.015088206344919037616, 1.5005041340227291968, -0.19443397537829132382, -1.1102230246251565404e-16, 0, ]).reshape((20, 11, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=4
knots=np.array([-2500, -150, 300, 1500.0000000000000000, ])
absorb_cons=FALSE
output=np.array([-0.03303972668455883166, -0.032723631630874550069, -0.033194598680918049882, -0.032481019964223409313, -0.033535293013993730527, -0.031917861017270607316, -0.03426231263902488472, -0.030563998358814094963, -0.035695429397679306893, -0.027087023457207957261, -0.037865492526216820712, -0.017178820311233713308, -0.037086543898716496648, 0.014593291596970280055, -0.0029879266785189512179, 0.12551122978070125558, 0.23922654623041611499, 0.49782433286763683178, 0.98768627515810170081, 1.0869145050394330987, 0.66601437778113736776, 0.67187778857060287407, 0.663080503426190071, 0.67627141867934648101, 0.65647421427937902028, 0.68614414294517134252, 0.64158611076564242559, 0.70828643005086278084, 0.60798624557560698722, 0.7576791553065401752, 0.5320956270640739838, 0.865894348010412096, 0.36241579174811910935, 1.0862902782459773476, 0.015083764342983273232, 1.4407803230899152158, -0.4134231048981120149, 1.6325959428355898417, -0.025636829423459156496, 0.35643164379996317148, 0.36702534890342142226, 0.36084584306027167599, 0.37011409525472788173, 0.35620960128487694218, 0.37706107873461469637, 0.34577371807209933419, 0.39267620187338242443, 0.32227756830795128984, 0.42770918382207229191, 0.26940786815066769533, 0.50576986546214286466, 0.15128447230082164854, 0.6746707521505973526, -0.10088356984294755136, 0.98790416233553579595, -0.56629155287061583302, 1.1741965586676958999, -1.1304202757032262294, 0.037950554265357511197, -0.44334614883939615915, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=5
knots=np.array([-400, -50, 10, 50, 100, ])
absorb_cons=FALSE
output=np.array([0.015162953484350691347, 0.017003239050418700318, 0.01389317445221215086, 0.01781864311343593632, 0.010107471620559638215, 0.018108516505766211746, -0.0037108407090391832411, 0.013008750547323907898, -0.048928829481261350287, -0.0040236561643654800147, 0.092210640717886122042, 0.1378672467189187012, 1.5241189647343453828, 1.1908052000719462349, 1.3336312280306561462, 0.1631244792608173011, 1.8059790376981266213, -0.013880364847569600512, 0.0084813946159772030109, 1.4226717441894676242, 0.085563268199896264088, 0.11668451836115162346, 0.071115177265946433183, 0.14186260471454884002, 0.041497176936461224739, 0.20374514230967810668, -0.0090968367480324351104, 0.36464078885855299994, -0.046829263271134111135, 0.78133519562325359775, 0.0086505068072265829671, 1.4941773335338757178, 0.083794480856750619413, 1.5469438185966697397, 1.4536819883528222519, 0.01009019548322653316, 0.24373154263518609364, -0.026484165693594415025, 0.45865093019281244491, 1.3856971378298170716, 1.0470804297077640488, 1.0403159202859915133, 1.0474228585236060596, 1.0301709677530419551, 1.0403805448593048677, 0.99263889345454958679, 0.98179764669852209735, 0.84465069052528973792, 0.662325916413059268, 0.31424672127915465047, -0.11097382584830663144, -0.73780817614306393182, 0.10634636847011158522, -1.0591219159940026273, -0.97302313835893716742, -0.14685901225266156933, 0.065659678129581511286, 0.92642956346749238961, 0.738106497929031935, -0.90865791610827972846, -0.14780665139201115688, -0.17400367769756186487, -0.13243121024176468525, -0.18985221558102688411, -0.091985193416325716775, -0.21449255226999386359, 0.031010030758549505386, -0.22230022993116671515, 0.43343217633933617261, -0.091558260738042823723, 1.0101126783231939577, 0.10576359589026917973, -0.71425981406120730988, -0.67862710267461334723, -0.81429007802454078657, 0.97364433750861778538, -1.115370258462895503, 0.11393496707367145593, -0.20523882273782165231, -0.89971096591100430118, ]).reshape((20, 4, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=7
knots=np.array([-1000, -500, -250, 0, 250, 500, 1000, ])
absorb_cons=FALSE
output=np.array([1.0865454545429926135e-06, 2.4398181818138797716e-06, 5.4730227272719212013e-06, 1.2258383522732035908e-05, 2.7392640980115554039e-05, 6.0996505637431891467e-05, 0.0001350924767677991363, 0.00029670296713464952565, 0.00064309569467692253436, 0.0013643251258789318436, 0.0027908209016161266564, 0.0053380236469475778743, 0.0088335867924326759437, 0.0091533086384256254903, -0.014306039442788853755, -0.041433352007441685838, 0.31405170261824960631, 0.99790444618953877409, 0.027724626841434521496, 0.0068039590138881103284, 0.00064727402371540310524, -0.00098920483399211889264, 0.0014426438433794426357, -0.0022558485342761974701, 0.0031770096755419320253, -0.0052223605999905525765, 0.0068053308523184398438, -0.012426118572852515309, 0.013644913148864869917, -0.030618365664116811709, 0.023048059495840829414, -0.073679585582029943902, 0.022074755528899835111, -0.091195081533291866283, -0.0002259526328000187323, 0.78626962637629815855, -0.10027585488170688566, 0.03440373467483604647, 1.0473889505746853956, -0.065646799659779347946, -0.003108653786561336313, 0.0047444954940711828867, -0.0069334472845849707406, 0.010810919925889327445, -0.015293474668169363198, 0.024997761679919142108, -0.03288173605395704191, 0.059489869048364188431, -0.066524536226034367004, 0.14842140322069641289, -0.11509599902262178384, 0.38653940175293038939, -0.12009256540661154833, 0.89487060989842726055, 0.023974235745902267025, 0.30753674660261021145, 0.028225509751146779513, -0.016286171465612203635, -0.087188251557721807572, 0.95672514836045408071, 0.99996516654545464231, 0.99992170981818173647, 0.99982413427272720519, 0.99960527135227272844, 0.99911513172301125163, 0.99802008661061780703, 0.99558245566310810126, 0.99018628040560352499, 0.9783435545897927188, 0.95270542773753197352, 0.89842166335737938532, 0.7877650145033745499, 0.57753870046138200411, 0.23531461121027275052, -0.101438596654484528, -0.076220798157655950122, 0.080593293321039760624, 0.00045998670001021375875, 0.022032291428807804223, 0.12976646713984618664, 0.0031521796047431342204, -0.0046466867667984135259, 0.0071530971936759326843, -0.010318124209980239492, 0.01639748407299900651, -0.022529876245437452376, 0.03838002020499131639, -0.047302525716890531093, 0.093325747193657035417, -0.090212229951197098199, 0.23900090287817127299, -0.13160022708072441344, 0.61322255928469093789, -0.056958752001294875311, 0.958298331738895115, 0.012677886126789952859, -0.35059868303530600242, 0.01444622466557134513, -0.00094091415750929829898, -0.032059943389195363905, -0.00065705293280633844839, 0.00096724647035571764686, -0.0014919010479248961606, 0.0021455230825716264942, -0.0034235434443629607359, 0.0046733920492536690228, -0.008021163143228648984, 0.0097557918686406452924, -0.019432774400957149308, 0.018339439531206425116, -0.048165447610385929422, 0.025637372759501717012, -0.10157703666079390126, 0.0088153037874612247271, 0.13369802124527602194, 0.011169891059399323502, 1.0280040322265766584, -0.030928220764344298982, -0.0090167031296965738374, 0.004411168534786328102, ]).reshape((20, 6, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=4
knots=None
absorb_cons=TRUE
output=np.array([0.19511874223105002413, 0.19328136140945711974, 0.19603076753463616333, 0.19189278126562986371, 0.19806475922765381936, 0.18874078982063985377, 0.20253543882853958236, 0.18155709647843842891, 0.21199988818367701549, 0.16514182390533327371, 0.23031856584684334832, 0.12705798198206638694, 0.25709528872115156028, 0.036195691844765578993, 0.25138520448010354125, -0.18708237186262471896, -0.013972372776853255599, -0.70106203022920721146, -0.96214970344564842986, -0.96214970344564820781, 0.68403334135296989249, 0.60311193997153489388, 0.72443479807328026165, 0.54235372240853074732, 0.81513433908152477247, 0.40561204773518105826, 1.0177088251859824908, 0.099342480096702004411, 1.4639211866974952692, -0.57590399808120096292, 2.4193104627273829266, -2.0236042389889199455, 4.3297301577097133674, -4.928177533945309996, 7.4943452610127803126, -9.7886574066511276015, 9.753529003891806326, -13.510350272896850754, 0.23706294230926167055, 0.23706294230926180933, ]).reshape((20, 2, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=7
knots=None
absorb_cons=TRUE
output=np.array([-0.09996264143545301184, -0.11347888802625775984, -0.085118834474127241796, -0.10911447157987791412, -0.0376192915747680795, -0.064440162552667323848, 0.093968376147604365523, 0.11142321074687944193, 0.31776266530375074648, 0.45570604000055198179, 0.46380277431584160386, 0.89300636651257359055, -0.14510213799700033555, 0.96333821295332311418, -1.5132894536153895793, 0.82432258344543585249, -2.5988714669036583338, 0.92635413953045664393, -0.14134351039860873489, -0.14134351039860867938, 0.23834091756376188376, 0.35248629179932566835, 0.18039220953514537027, 0.43583938337484684489, 0.050144193047881382985, 0.61552699880967853829, -0.2237848683809608441, 0.97413442320198884161, -0.67208413897185625974, 1.5362399491838241161, -0.95632335803874857216, 1.7726129713790426123, 0.31347441526077174379, -0.38061109255151409636, 3.2553930274666940115, -5.093077784759170612, 6.0469258529758489473, -9.2083208514013143997, 0.38134573025237739063, 0.38134573025237838984, 0.36086943997122683525, 0.36667024194421360406, 0.35446911502732253441, 0.36478130178265055772, 0.33382084885464979873, 0.34553973621188488474, 0.27476295985860993421, 0.26982601949673939989, 0.15921647742368139067, 0.1214671481463027447, -0.0048407176404455702981, -0.067803846828875705133, -0.11067535403631012514, -0.10302868958722773141, -0.2301530127015978533, -0.064773144847515770617, -0.49542622407015213248, -0.23755670608026469015, -0.81858279646244769268, -0.81858279646244602734, 0.36026977248710895241, 0.23461157027634554906, 0.43091928395041323441, 0.1550818089508944897, 0.60166186948369282383, 0.013499889397706944794, 0.98534266394190206384, -0.20102910227880538274, 1.5995282267915371666, -0.53077336516331363736, 1.8709434423002264669, -0.7329934007992182643, -0.41020716027288028904, 0.26173115951276498814, -5.3296664149739436667, 2.8167844608879319956, -9.2446193976201840314, 6.3595195952585372723, 0.3796975489346396393, 0.37969754893464241485, -0.09342094101113124216, -0.10518600840242132988, -0.080006629364737152921, -0.10062511887211006423, -0.036336786815554571184, -0.058504221090871715016, 0.089578204326735660912, 0.10154568474713222825, 0.33951493212221051099, 0.38266890106103862434, 0.7115379830932434535, 0.57066292250314121226, 1.0142476918808467357, -0.17457778635418924607, 1.3394445526441309813, -1.8727860878377164955, 1.5244315420174636699, -3.2891836324660186364, -0.13150260109059599967, -0.13150260109059619396, ]).reshape((20, 5, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=10
knots=None
absorb_cons=TRUE
output=np.array([-0.010422589164110178037, 0.0456424386898241774, -0.037865479111961315717, 0.067665213698612183824, -0.082737354894918610504, 0.028116719037984471558, -0.13142165397961641515, -0.22684145450558812485, -0.14183761903259869963, -0.4397636102098926858, 0.038753040222973357543, 0.16687260126443773101, 0.24596836576748323799, 1.1496535841573791714, -0.11141233683909176899, 0.852150817442395625, -0.69719802631935023918, -0.16780336922215680073, -0.27375964350090231658, -0.27375964350090231658, 0.00075686991514895495502, -0.0026399619145559983374, 0.002329286728553797009, -0.0046772664281081481261, 0.0050464211301084280908, -0.0053347974019967861828, 0.0084202195193733477691, 0.025683527700154588219, 0.0094683775407149051856, 0.27987678132954318944, -0.0027668876775316930683, 1.1881421141921484352, -0.020680289816708941064, 1.9619971627400687453, 0.011350885804312933758, -0.30799503353642232462, 0.28512530049421225264, -3.4687076070237505832, 0.017302448352367463119, 0.017302448352367227197, -0.031423668563904168238, 0.092056168183617143042, -0.085784223470207240925, 0.18847060597276241167, -0.18459182127963985609, 0.39491427056812172802, -0.32011917407772511046, 0.75400611255752592044, -0.36683893574186782205, 0.9123381072270769776, 0.10368560537272084043, -0.284896787114018335, 0.65873659367957215771, -1.7915854614656305799, -0.28317998595666565853, 0.16934785893573317539, -2.1208025768458700355, 3.4983918640596205485, -0.65136227602061025355, -0.65136227602061058661, 0.15390547566386716949, 0.72999661431747953078, -0.052325183145307693766, 1.0578646982284642952, -0.17410117772396246916, 1.0826889596002884364, 0.28795108435587113416, -0.33988255901594949249, 0.75706886705991383035, -1.8010717324191700683, -0.27609951573452540252, 0.70199292810649616126, -1.6861943363558831166, 4.2694489532922874631, 0.3883483777323971653, -0.72860244126989648361, 4.3993879828572435287, -9.3213910982477266032, 0.27550705134905656424, 0.27550705134905634219, 0.88473558816481134848, 0.28118622960754013906, 1.0363915332292370497, -0.13821893333931381531, 0.86682756892064050103, -0.46428766146855998675, -0.49858487332948592252, 0.19046189397427254475, -1.804569129824072693, 0.94889775503965156922, 0.68883320796217106796, -0.36989366480027330297, 4.1648803055867107403, -2.2675263648363670477, -0.80718694983894612172, 0.41585628137205921107, -9.3512295591515375293, 6.4594889011881138075, -0.11803106422832626565, -0.11803106422832615463, -0.04700419996957900387, 0.068365309897369067049, -0.04054662542658848956, 0.14767281664377382433, 0.18375758144525122795, 0.096639366434089990499, 1.0236374391375679949, -0.47105831760443933609, 1.6290138304390200386, -0.95892121020674836451, -0.57444021027476643848, 0.35538961856435591358, -3.4443839310068100623, 2.1037278825342364819, 0.51445168623435322264, -0.5476416666229180219, 7.3133339883682770832, -6.2747526284605275038, -0.5386203650629584061, -0.53862036506295885019, -0.00033055953514735743511, 0.0034830998631877898263, -0.0031226317036678898596, 0.0044763982618290778723, -0.0095705473805210890259, 0.0013288993039827501352, 0.0024048160547256620945, -0.015334684583203243846, 0.24302632748633656856, -0.02859075483432030676, 1.2008463040646732978, 0.01005831734477347951, 2.0397829199332155881, 0.047246265215163486817, -0.33369939987991892316, -0.0017774801323981149429, -3.8176499659498723815, 0.69539341686864553083, -0.018985370198741847308, -0.01898537019874227405, -0.0098485472403549607912, 0.043107558972873410985, -0.035757108373310586558, 0.063906922484069789148, -0.078090074289757671622, 0.026516000447580879984, -0.12429507538278902756, -0.2141005094608952608, -0.13680420974781898336, -0.41275099307476753596, 0.042680600816607877634, 0.15199473312943939662, 0.44252834874998403514, 0.8905421952388906659, 0.99056537832665858545, -0.23331489131404251069, 1.3587540460951703647, -2.2485068612054024406, -0.25856375708606771369, -0.25856375708606793573, ]).reshape((20, 8, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=12
knots=None
absorb_cons=TRUE
output=np.array([-0.07766833740489995086, -0.10190625722373891637, -0.060810191651491825315, -0.095843436838280671175, -0.026956945198949221199, -0.02140480076346930674, -0.0044354303173668322216, 0.068142865158757101596, -0.10242235056407339444, -0.134962672377622106, -0.17923996606808398346, -0.32198261136183764508, 0.061769798735937714307, 0.22368036323142082011, 0.1062350870161039712, 0.86684951229524320748, -0.41431550373346520688, 0.82628193491032586593, -0.30550552892225468771, -0.30550552892225446566, -0.046843894383066776721, -0.061472670935691822725, -0.036665627178526026542, -0.057737114955866711274, -0.016253728913666141281, -0.012788703169830750381, -0.0026924622704371371611, 0.037130318979860681139, -0.061754253708923484423, -0.072908208132761248566, -0.10784991719446739011, 0.15587963325803569359, 0.035948683163131246732, 1.5026771080647596257, 0.054139137539069064065, 1.2144591386571002012, -0.12227506507632453225, -2.0325190387816292059, -0.18423666748038231011, -0.1842366674803827542, -0.10253186808225246696, -0.1341028859441055765, -0.080717296578839040078, -0.12938111733003612724, -0.035779041281597902258, -0.033296176820796892504, -0.0052764476269259964411, 0.29121358356235121922, -0.13571696227220694797, 0.9800391391797497187, -0.23836784885271891654, 1.1531098931327661283, 0.083488884262169646422, -0.95923704223174655059, 0.14850642088377782879, -1.3982914277816191895, -0.63569333679288853034, 2.040472414748102814, -0.40421944208659177367, -0.40421944208659132958, -0.014736324481430123495, -0.036942635828954392685, 0.0066553430184999587058, 0.1067120469886325973, 0.0028385673937536314362, 0.84576148428624664533, -0.024675731668667714308, 1.6253851750682712929, 0.0013193004864854235899, -0.44631406733607736914, 0.032762082318650569135, -2.4125076929166153761, -0.03606306801106605453, 2.0357000324722602791, -0.069357883037490283828, 2.9830669079191580728, 0.34150454252272821609, -4.9007299602670126859, -0.020189059463686463008, -0.020189059463686463008, -0.012482766482938594671, 0.70375642696389684172, -0.20381708316356489386, 0.93679207951689691392, -0.089167436412632875009, 0.2081777984642331214, 0.25130986547048167479, -1.1517493252694694927, -0.23847465841613846305, 0.21373269726886048869, -0.73521082895311973271, 1.7985010371260992112, 0.48954351921215394361, -1.6483400566813448673, 0.75390085346775681518, -2.4179886586261010173, -1.7764330770220631006, 3.8309842164304526158, -0.45651730144672891809, -0.45651730144672891809, 0.86855075539761661396, 0.098258969106073332234, 0.91310939823129155801, -0.32540547292490512588, 0.16725908432707276008, -0.11995362876401588492, -1.021344015679647832, 0.58623523352093998007, 0.23016332628828412021, -0.31087640693906454237, 1.6549915252178080127, -1.2624926460002787731, -1.4964629433416147819, 0.98706595992626866565, -2.1957720652086201163, 1.4954532454044999756, 3.619128405599101761, -3.2523549448400173034, -0.31777688966039602247, -0.31777688966039646656, -0.068946719872015810315, -0.063498950974957252269, 0.10999032024314105149, 0.0059748385118500793589, 0.84565340326272575577, 0.0088822808061620184272, 1.5829407256504981483, -0.060957945254261673707, -0.45742582387218383433, -0.014951096212291247606, -2.381969985853732652, 0.051586837169672689063, 1.9887723465897544362, -0.077591047241966609738, 2.9302744923046657455, -0.16817713282609225711, -5.0351646834625327642, 0.99618007435765298929, -0.095785966663044092018, -0.095785966663044536107, -0.092425948063627971774, -0.12192256208017497598, -0.076168790113220086191, -0.11625762092899732947, -0.037600709993932460162, -0.026143656852116337053, 0.19673306138614868321, 0.083917187234610293722, 1.0347219995539065351, -0.16290214117344051226, 1.3532959167438192161, -0.38419175563061558343, -1.1275995644118568251, 0.22887092989596394266, -1.6446009002954922185, 0.37556943100676937197, 2.5636651809434143345, -1.3113571002380715047, -0.36780147849154309903, -0.36780147849154309903, -0.052133443997911740886, -0.06838748447056271218, -0.040727650559123369789, -0.064279681235506633263, -0.017963836831353656442, -0.014349195077656596783, -0.0068956265034833194583, 0.045590399764175990049, -0.060364684525170013429, -0.090361397122777853408, 0.22579126263553786491, -0.21095860924503515021, 1.4340181609862545642, 0.11958124964793707956, 1.1233531600390498362, 0.15886424366674492537, -1.9608032079784090129, -0.11004527519600627861, -0.20496419199835186342, -0.20496419199835186342, -0.074397287283336693831, -0.097615070510572624074, -0.058251260498594206738, -0.091806644267701589812, -0.02582498595211388942, -0.020500802148151781035, -0.0041449721977959343849, 0.065178307797134571455, -0.098329868155822383602, -0.12907473963965984676, -0.17815101427258792088, -0.30240999889208236562, 0.098829510321402941342, 0.17727868088912610012, 0.68781535762400658474, 0.27674812243204571782, 1.1588192944220654379, -0.7988804231889805596, -0.29264110323919079182, -0.2926411032391906808, ]).reshape((20, 10, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=4
knots=np.array([-2500, -150, 300, 1500.0000000000000000, ])
absorb_cons=TRUE
output=np.array([0.12313452571054940565, 0.12624926449090670411, 0.12157389196350212868, 0.12857954187334583174, 0.11805461329003080762, 0.13380425540627891023, 0.11009731641023581816, 0.14546384037961754276, 0.092005873745000077424, 0.17117971635322848378, 0.050459076159657625937, 0.22605161337519041886, -0.04604552699950949235, 0.33036931836460758927, -0.26444093870479618014, 0.45978406857873022062, -0.66227507648797157014, 0.32946799433163242998, -0.92301557680450230237, -0.77049779143573060569, 0.15656827198639958199, 0.14932319431509266661, 0.16018937960169490897, 0.14388705697943621198, 0.1683330978621291607, 0.13164928933754893592, 0.18663507205881160744, 0.10408933274661898161, 0.22768017116328620464, 0.042040878816280137509, 0.31905484877266732102, -0.096761998947504118673, 0.51632342198274205902, -0.39392983963941236025, 0.87954141557829357279, -0.94659228313998333704, 1.0777246444382655444, -1.6356011142349877741, -0.30993435496630139525, -0.88022048471107694478, ]).reshape((20, 2, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=5
knots=np.array([-400, -50, 10, 50, 100, ])
absorb_cons=TRUE
output=np.array([-0.16508056690578271075, -0.14355192166054722702, -0.17398515944924686227, -0.12432844320614395983, -0.18919890928728577695, -0.072282554700368567557, -0.19674137112973341668, 0.081531091765042931763, -0.099155660656600808078, 0.52456028958996936407, 0.059704023721638257993, 1.2036951770569246367, -0.95698314791898375642, 0.59171921208541256032, 0.40429183055884826414, 0.021134682418438101997, -1.035862596202561825, -0.18547278101676506479, 0.17821896181573629314, 0.27778784312200943685, 0.84139218015539352091, 0.82675559954147825881, 0.84628382311749461575, 0.8117240601311839221, 0.85106220741071658686, 0.76611964233460772, 0.82780911632526033017, 0.61231966988832331467, 0.61938480406110207888, 0.10352707230517528558, -0.069077289581256251516, -0.9761893286926568436, -0.74775693930080122662, -1.843017028194991358, -1.8341942282567624822, -0.13779546922177127177, -0.98442590823258591115, 0.79595721424418131029, 0.50797292743971100837, -1.8178521254738027046, -0.057675412235671304206, -0.080422948680625480633, -0.044293406826563193335, -0.094130216309427472421, -0.0090271421596601793269, -0.11523330512953809668, 0.098486792744760950913, -0.12049430358370501193, 0.45224868955998115405, 0.00077770457813844623505, 0.99175389147792825106, 0.21022065027995529007, -0.33999735782244788762, -0.33512941632144105375, -0.43693056610772496029, 0.96967275251871798414, -0.65522965575463965049, 0.17110709302995569248, -0.10439580460326271238, -0.50130803865473083647, ]).reshape((20, 3, ), order="F")
--END TEST CASE--
--BEGIN TEST CASE--
spline_type=cc
nb_knots=7
knots=np.array([-1000, -500, -250, 0, 250, 500, 1000, ])
absorb_cons=TRUE
output=np.array([-0.10421720382140421679, -0.10591736328552885105, -0.10337614089781445303, -0.10720759929942245969, -0.10150561917996400729, -0.11015275422250632442, -0.097405901413871925909, -0.11694382088021060273, -0.088713078413449955595, -0.13250065888393972036, -0.07161679548265666162, -0.1625759820148384438, -0.043015722854652924112, -0.13320201735142009336, 0.0004329669515455780238, 0.78255062519422247114, -0.15088551365188454523, -0.085517465675143913839, 1.0298684606084522741, -0.098098415425510815391, -0.16366514384894217948, -0.15590949502662956871, -0.16741997729436150499, -0.14987919244601818902, -0.17557153836450387074, -0.13565965107884025986, -0.1924380512291224421, -0.10053567798805967959, -0.22324338128005483117, -0.0075691069598905688642, -0.26003599357502127365, 0.25043141090853648922, -0.21975165836638141381, 0.83055439613540549271, 0.024983098021001227257, 0.30184263751436557488, -0.049262209087217581627, -0.19989579226301767978, -0.11401362112954462058, 0.90703894735829693197, 0.15993324209937159752, 0.15937966275042819708, 0.16015824098241202011, 0.15887423467611411221, 0.16053993466300625625, 0.15746013438548811525, 0.16078344852210443849, 0.15293225108971789106, 0.15839019763395165152, 0.13656272051085360797, 0.14009527925573453389, 0.075647694069404219919, 0.05612209740148604159, -0.10118796678857061577, -0.096160226916063087921, -0.10601238997400461161, -0.32482262945752882199, -0.96018597065328126217, -0.11831810372893719618, -0.13019185052168549821, -0.080994950879331353844, -0.088844916921682309807, -0.07695736745600667561, -0.094535285708752150868, -0.067603724064711254171, -0.10672989998407718393, -0.045242921897107997442, -0.13117139070034619652, 0.011189913886947294372, -0.17196634533664997835, 0.16303832653371333472, -0.20293397921406119977, 0.56099155513187193289, -0.090666668944769990279, 0.95882707315240156554, 0.0096936222066400009462, -0.39120974264100472073, -0.081782976118326314308, -0.015000002474441720413, -0.058100318570304822219, -0.06971270937892765085, -0.068130345111184043017, -0.070517467540312656071, -0.066967604576931502591, -0.072359448172744492145, -0.064425671443484225365, -0.076646642438798442964, -0.059071504956647494233, -0.086837852317636618493, -0.048752380149832678924, -0.11050441917873819742, -0.032902936957473871704, -0.1444406050066643632, -0.018847223960927635827, 0.13413193485813351691, 0.0087208437439542339786, 0.9946764147081772478, -0.10989907326032234691, -0.020554346388292375064, -0.016958962471346181872, ]).reshape((20, 5, ), order="F")
--END TEST CASE--
"""
R_crs_num_tests = 42
