/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.1.0/LICENSE.txt
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.maplibregl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var maplibregl = {};
var modules = {};
function define(moduleName, _dependencies, moduleFactory) {
    modules[moduleName] = moduleFactory;

    // to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
    if (moduleName !== 'index') {
        return;
    }

    // we assume that when an index module is initializing then other modules are loaded already
    var workerBundleString = 'var sharedModule = {}; (' + modules.shared + ')(sharedModule); (' + modules.worker + ')(sharedModule);'

    var sharedModule = {};
    // the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
    // to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
    // we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
    modules.shared(sharedModule);
    modules.index(maplibregl, sharedModule);

    if (typeof window !== 'undefined') {
        maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' })));
    }

    return maplibregl;
};



define("shared",["exports"],(function(t){"use strict";function e(t,e,r,n){return new(r||(r=Promise))((function(i,s){function a(t){try{l(n.next(t));}catch(t){s(t);}}function o(t){try{l(n.throw(t));}catch(t){s(t);}}function l(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e);}))).then(a,o);}l((n=n.apply(t,e||[])).next());}))}function r(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var n,i;function s(){if(i)return n;function t(t,e){this.x=t,this.y=e;}return i=1,n=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),n=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=n,this},_rotateAround:function(t,e){var r=Math.cos(t),n=Math.sin(t),i=e.y+n*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-n*(this.y-e.y),this.y=i,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},n}"function"==typeof SuppressedError&&SuppressedError;var a,o,l=r(s()),u=function(){if(o)return a;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return o=1,a=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},a}(),c=r(u);let h,p;function f(){return null==h&&(h="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),h}function d(){if(null==p&&(p=!1,f())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let r=0;r<t*t;r++){const n=4*r;e.fillStyle=`rgb(${n},${n+1},${n+2})`,e.fillRect(r%t,Math.floor(r/t),1,1);}const r=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&r[e]!==e){p=!0;break}}}return p||!1}var y,m=1e-6,g="undefined"!=typeof Float32Array?Float32Array:Array;function x(){var t=new g(9);return g!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function v(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function b(){var t=new g(3);return g!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function w(t,e,r){var n=new g(3);return n[0]=t,n[1]=e,n[2]=r,n}function _(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3];return t[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*a,t[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*a,t[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*a,t[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*a,t}function S(){var t=new g(4);return g!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function A(){var t=new g(2);return g!=Float32Array&&(t[0]=0,t[1]=0),t}function k(t,e){var r=new g(2);return r[0]=t,r[1]=e,r}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)}),b(),y=new g(4),g!=Float32Array&&(y[0]=0,y[1]=0,y[2]=0,y[3]=0),b(),w(1,0,0),w(0,1,0),S(),S(),x(),A();const M=8192;function I(t,e,r){return e*(M/(t.tileSize*Math.pow(2,r-t.tileID.overscaledZ)))}function z(t,e){return (t%e+e)%e}function P(t,e,r){return t*(1-r)+e*r}function C(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function B(t,e,r,n){const i=new c(t,e,r,n);return t=>i.solve(t)}const V=B(.25,.1,.25,1);function E(t,e,r){return Math.min(r,Math.max(e,t))}function T(t,e,r){const n=r-e,i=((t-e)%n+n)%n+e;return i===e?r:i}function F(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let $=1;function L(t,e,r){const n={};for(const r in t)n[r]=e.call(this,t[r],r,t);return n}function O(t,e,r){const n={};for(const r in t)e.call(this,t[r],r,t)&&(n[r]=t[r]);return n}function D(t){return Array.isArray(t)?t.map(D):"object"==typeof t&&t?L(t,D):t}const R={};function j(t){R[t]||("undefined"!=typeof console&&console.warn(t),R[t]=!0);}function N(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function U(t){return "undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let q=null;function G(t){return "undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const Z="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function X(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const a=null==e?void 0:e.format;if(!a||!a.startsWith("BGR")&&!a.startsWith("RGB"))throw new Error(`Unrecognized format ${a}`);const o=a.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield e.copyTo(l,function(t,e,r,n,i){const s=4*Math.max(1,0),a=(Math.max(0,r)-r)*n*4+s,o=4*n,l=Math.max(0,e),u=Math.max(0,r);return {rect:{x:l,y:u,width:Math.min(t.width,e+n)-l,height:Math.min(t.height,r+i)-u},layout:[{offset:a,stride:o}]}}(t,r,n,i,s)),o)for(let t=0;t<l.length;t+=4){const e=l[t];l[t]=l[t+2],l[t+2]=e;}return l}finally{e.close();}}))}let K,H;function Y(t){return t/Math.PI*180}const J="AbortError";function W(){return new Error(J)}const Q={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function tt(t){return Q.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const et="global-dispatcher";class rt extends Error{constructor(t,e,r,n){super(`AJAXError: ${e} (${t}): ${r}`),this.status=t,this.statusText=e,this.url=r,this.body=n;}}const nt=()=>U(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,it=function(t,r){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const e=tt(t.url);if(e)return e(t,r);if(U(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:et},r)}if(!(/^file:/.test(n=t.url)||/^file:/.test(nt())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,r){return e(this,void 0,void 0,(function*(){const e=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:nt(),signal:r.signal});let n,i;"json"!==t.type||e.headers.has("Accept")||e.headers.set("Accept","application/json");try{n=yield fetch(e);}catch(e){throw new rt(0,e.message,t.url,new Blob)}if(!n.ok){const e=yield n.blob();throw new rt(n.status,n.statusText,t.url,e)}i="arrayBuffer"===t.type||"image"===t.type?n.arrayBuffer():"json"===t.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw W();return {data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(t,r);if(U(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:et},r)}var n;return function(t,e){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(i=t.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{n(new Error(s.statusText));},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response);}catch(t){return void n(t)}r({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")});}else {const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new rt(s.status,s.statusText,t.url,e));}},e.signal.addEventListener("abort",(()=>{s.abort(),n(W());})),s.send(t.body);}))}(t,r)};function st(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return !0;const e=new URL(t),r=window.location;return e.protocol===r.protocol&&e.host===r.host}function at(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function ot(t,e,r){if(r&&r[t]){const n=r[t].indexOf(e);-1!==n&&r[t].splice(n,1);}}class lt{constructor(t,e={}){F(this,e),this.type=t;}}class ut extends lt{constructor(t,e={}){super("error",F({error:t},e));}}class ct{on(t,e){return this._listeners=this._listeners||{},at(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e);}}}off(t,e){return ot(t,e,this._listeners),ot(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},at(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new lt(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of n)ot(r,e,this._oneTimeListeners),e.call(this,t);const i=this._eventedParent;i&&(F(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(t));}else t instanceof ut&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var ht={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const pt=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function ft(t,e){const r={};for(const e in t)"ref"!==e&&(r[e]=t[e]);return pt.forEach((t=>{t in e&&(r[t]=e[t]);})),r}function dt(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!dt(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!dt(t[r],e[r]))return !1;return !0}return t===e}function yt(t,e){t.push(e);}function mt(t,e,r){yt(r,{command:"addSource",args:[t,e[t]]});}function gt(t,e,r){yt(e,{command:"removeSource",args:[t]}),r[t]=!0;}function xt(t,e,r,n){gt(t,r,n),mt(t,e,r);}function vt(t,e,r){let n;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!dt(t[r][n],e[r][n]))return !1;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!dt(t[r][n],e[r][n]))return !1;return !0}function bt(t,e,r,n,i,s){t=t||{},e=e||{};for(const a in t)Object.prototype.hasOwnProperty.call(t,a)&&(dt(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));for(const a in e)Object.prototype.hasOwnProperty.call(e,a)&&!Object.prototype.hasOwnProperty.call(t,a)&&(dt(t[a],e[a])||r.push({command:s,args:[n,a,e[a],i]}));}function wt(t){return t.id}function _t(t,e){return t[e.id]=e,t}class St{constructor(t,e,r,n){this.message=(t?`${t}: `:"")+r,n&&(this.identifier=n),null!=e&&e.__line__&&(this.line=e.__line__);}}function At(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}class kt extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Mt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Mt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const It={kind:"null"},zt={kind:"number"},Pt={kind:"string"},Ct={kind:"boolean"},Bt={kind:"color"},Vt={kind:"projectionDefinition"},Et={kind:"object"},Tt={kind:"value"},Ft={kind:"collator"},$t={kind:"formatted"},Lt={kind:"padding"},Ot={kind:"resolvedImage"},Dt={kind:"variableAnchorOffsetCollection"};function Rt(t,e){return {kind:"array",itemType:t,N:e}}function jt(t){if("array"===t.kind){const e=jt(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const Nt=[It,zt,Pt,Ct,Bt,Vt,$t,Et,Rt(Tt),Lt,Ot,Dt];function Ut(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Ut(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of Nt)if(!Ut(t,e))return null}return `Expected ${jt(t)} but found ${jt(e)} instead.`}function qt(t,e){return e.some((e=>e.kind===t.kind))}function Gt(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function Zt(t,e){return "array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const Xt=.96422,Kt=.82521,Ht=4/29,Yt=6/29,Jt=3*Yt*Yt,Wt=Yt*Yt*Yt,Qt=Math.PI/180,te=180/Math.PI;function ee(t){return (t%=360)<0&&(t+=360),t}function re([t,e,r,n]){let i,s;const a=ie((.2225045*(t=ne(t))+.7168786*(e=ne(e))+.0606169*(r=ne(r)))/1);t===e&&e===r?i=s=a:(i=ie((.4360747*t+.3850649*e+.1430804*r)/Xt),s=ie((.0139322*t+.0971045*e+.7141733*r)/Kt));const o=116*a-16;return [o<0?0:o,500*(i-a),200*(a-s),n]}function ne(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function ie(t){return t>Wt?Math.pow(t,1/3):t/Jt+Ht}function se([t,e,r,n]){let i=(t+16)/116,s=isNaN(e)?i:i+e/500,a=isNaN(r)?i:i-r/200;return i=1*oe(i),s=Xt*oe(s),a=Kt*oe(a),[ae(3.1338561*s-1.6168667*i-.4906146*a),ae(-.9787684*s+1.9161415*i+.033454*a),ae(.0719453*s-.2289914*i+1.4052427*a),n]}function ae(t){return (t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function oe(t){return t>Yt?t*t*t:Jt*(t-Ht)}function le(t){return parseInt(t.padEnd(2,t),16)/255}function ue(t,e){return ce(e?t/100:t,0,1)}function ce(t,e,r){return Math.min(Math.max(e,t),r)}function he(t){return !t.some(Number.isNaN)}const pe={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function fe(t,e,r){return t+r*(e-t)}function de(t,e,r){return t.map(((t,n)=>fe(t,e[n],r)))}class ye{constructor(t,e,r,n=1,i=!0){this.r=t,this.g=e,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[t,e,r,n]));}static parse(t){if(t instanceof ye)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return [0,0,0,0];const e=pe[t];if(e){const[t,r,n]=e;return [t/255,r/255,n/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let r=1;return [le(t.slice(r,r+=e)),le(t.slice(r,r+=e)),le(t.slice(r,r+=e)),le(t.slice(r,r+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,r,n,i,s,a,o,l,u,c,h,p]=e,f=[i||" ",o||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const t=[n,a,u].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[ce(+r/e,0,1),ce(+s/e,0,1),ce(+l/e,0,1),h?ue(+h,p):1];if(he(t))return t}}return}}const r=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[t,e,n,i,s,a,o,l,u]=r,c=[n||" ",s||" ",o].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const t=[+e,ce(+i,0,100),ce(+a,0,100),l?ue(+l,u):1];if(he(t))return function([t,e,r,n]){function i(n){const i=(n+t/30)%12,s=e*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return t=ee(t),e/=100,r/=100,[i(0),i(8),i(4),n]}(t)}}}(t);return e?new ye(...e,!1):void 0}get rgb(){const{r:t,g:e,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[t/i,e/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,r,n,i]=re(t),s=Math.sqrt(r*r+n*n);return [Math.round(1e4*s)?ee(Math.atan2(n,r)*te):NaN,s,e,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",re(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,r,n]=this.rgb;return `rgba(${[t,e,r].map((t=>Math.round(255*t))).join(",")},${n})`}static interpolate(t,e,r,n="rgb"){switch(n){case "rgb":{const[n,i,s,a]=de(t.rgb,e.rgb,r);return new ye(n,i,s,a,!1)}case "hcl":{const[n,i,s,a]=t.hcl,[o,l,u,c]=e.hcl;let h,p;if(isNaN(n)||isNaN(o))isNaN(n)?isNaN(o)?h=NaN:(h=o,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else {let t=o-n;o>n&&t>180?t-=360:o<n&&n-o>180&&(t+=360),h=n+r*t;}const[f,d,y,m]=function([t,e,r,n]){return t=isNaN(t)?0:t*Qt,se([r,Math.cos(t)*e,Math.sin(t)*e,n])}([h,null!=p?p:fe(i,l,r),fe(s,u,r),fe(a,c,r)]);return new ye(f,d,y,m,!1)}case "lab":{const[n,i,s,a]=se(de(t.lab,e.lab,r));return new ye(n,i,s,a,!1)}}}}ye.black=new ye(0,0,0,1),ye.white=new ye(1,1,1,1),ye.transparent=new ye(0,0,0,0),ye.red=new ye(1,0,0,1);class me{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const ge=["bottom","center","top"];class xe{constructor(t,e,r,n,i,s){this.text=t,this.image=e,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s;}}class ve{constructor(t){this.sections=t;}static fromString(t){return new ve([new xe(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof ve?t:ve.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class be{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof be)return t;if("number"==typeof t)return new be([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]];}return new be(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){return new be(de(t.values,e.values,r))}}class we{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const _e=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Se{constructor(t){this.values=t.slice();}static parse(t){if(t instanceof Se)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const r=t[e],n=t[e+1];if("string"!=typeof r||!_e.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Se(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,r){const n=t.values,i=e.values;if(n.length!==i.length)throw new we(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<n.length;t+=2){if(n[t]!==i[t])throw new we(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${n[t]}, to[${t}]: ${i[t]}`);s.push(n[t]);const[e,a]=n[t+1],[o,l]=i[t+1];s.push([fe(e,o,r),fe(a,l,r)]);}return new Se(s)}}class Ae{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new Ae({name:t,available:!1}):null}}class ke{constructor(t,e,r){this.from=t,this.to=e,this.transition=r;}static interpolate(t,e,r){return new ke(t,e,r)}static parse(t){return t instanceof ke?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new ke(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new ke(t.from,t.to,t.transition):"string"==typeof t?new ke(t,t,1):void 0}}function Me(t,e,r,n){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[t,e,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[t,e,r,n]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Ie(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof ke||t instanceof ye||t instanceof me||t instanceof ve||t instanceof be||t instanceof Se||t instanceof Ae)return !0;if(Array.isArray(t)){for(const e of t)if(!Ie(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!Ie(t[e]))return !1;return !0}return !1}function ze(t){if(null===t)return It;if("string"==typeof t)return Pt;if("boolean"==typeof t)return Ct;if("number"==typeof t)return zt;if(t instanceof ye)return Bt;if(t instanceof ke)return Vt;if(t instanceof me)return Ft;if(t instanceof ve)return $t;if(t instanceof be)return Lt;if(t instanceof Se)return Dt;if(t instanceof Ae)return Ot;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=ze(e);if(r){if(r===t)continue;r=Tt;break}r=t;}return Rt(r||Tt,e)}return Et}function Pe(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof ye||t instanceof ke||t instanceof ve||t instanceof be||t instanceof Se||t instanceof Ae?t.toString():JSON.stringify(t)}class Ce{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Ie(t[1]))return e.error("invalid value");const r=t[1];let n=ze(r);const i=e.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new Ce(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}const Be={string:Pt,number:zt,boolean:Ct,object:Et};class Ve{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,n=1;const i=t[0];if("array"===i){let i,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in Be)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);i=Be[r],n++;}else i=Tt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],n++;}r=Rt(i,s);}else {if(!Be[i])throw new Error(`Types doesn't contain name = ${i}`);r=Be[i];}const s=[];for(;n<t.length;n++){const r=e.parse(t[n],n,Tt);if(!r)return null;s.push(r);}return new Ve(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!Ut(this.type,ze(r)))return r;if(e===this.args.length-1)throw new we(`Expected value to be of type ${jt(this.type)}, but found ${jt(ze(r))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Ee={"to-boolean":Ct,"to-color":Bt,"to-number":zt,"to-string":Pt};class Te{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(!Ee[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const n=Ee[r],i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],r,Tt);if(!n)return null;i.push(n);}return new Te(n,i)}evaluate(t){switch(this.type.kind){case "boolean":return Boolean(this.args[0].evaluate(t));case "color":{let e,r;for(const n of this.args){if(e=n.evaluate(t),r=null,e instanceof ye)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:Me(e[0],e[1],e[2],e[3]),!r))return new ye(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new we(r||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "padding":{let e;for(const r of this.args){e=r.evaluate(t);const n=be.parse(e);if(n)return n}throw new we(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "variableAnchorOffsetCollection":{let e;for(const r of this.args){e=r.evaluate(t);const n=Se.parse(e);if(n)return n}throw new we(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case "number":{let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const n=Number(e);if(!isNaN(n))return n}throw new we(`Could not convert ${JSON.stringify(e)} to number.`)}case "formatted":return ve.fromString(Pe(this.args[0].evaluate(t)));case "resolvedImage":return Ae.fromString(Pe(this.args[0].evaluate(t)));case "projectionDefinition":return this.args[0].evaluate(t);default:return Pe(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Fe=["Unknown","Point","LineString","Polygon"];class $e{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Fe[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=ye.parse(t)),e}}class Le{constructor(t,e,r=[],n,i=new Mt,s=[]){this.registry=t,this.path=r,this.key=r.map((t=>`[${t}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=e;}parse(t,e,r,n,i={}){return e?this.concat(e,r,n)._parse(t,i):this._parse(t,i)}_parse(t,e){function r(t,e,r){return "assert"===r?new Ve(e,[t]):"coerce"===r?new Te(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=t[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(t,this);if(!n)return null;if(this.expectedType){const t=this.expectedType,i=n.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==i.kind)if("projectionDefinition"!==t.kind||"string"!==i.kind&&"array"!==i.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==i.kind&&"string"!==i.kind)if("padding"!==t.kind||"value"!==i.kind&&"number"!==i.kind&&"array"!==i.kind)if("variableAnchorOffsetCollection"!==t.kind||"value"!==i.kind&&"array"!==i.kind){if(this.checkSubtype(t,i))return null}else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"coerce");else n=r(n,t,e.typeAnnotation||"assert");}if(!(n instanceof Ce)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const t=new $e;try{n=new Ce(n.type,n.evaluate(t));}catch(t){return this.error(t.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const n="number"==typeof t?this.path.concat(t):this.path,i=r?this.scope.concat(r):this.scope;return new Le(this.registry,this._isConstant,n,e||null,i,this.errors)}error(t,...e){const r=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new kt(r,t));}checkSubtype(t,e){const r=Ut(t,e);return r&&this.error(r),r}}class Oe{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let n=1;n<t.length-1;n+=2){const i=t[n];if("string"!=typeof i)return e.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return e.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=e.parse(t[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return n?new Oe(r,n):null}outputDefined(){return this.result.outputDefined()}}class De{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new De(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}}class Re{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,zt),n=e.parse(t[2],2,Rt(e.expectedType||Tt));return r&&n?new Re(n.type.itemType,r,n):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new we(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new we(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new we(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}}class je{constructor(t,e){this.type=Ct,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Tt),n=e.parse(t[2],2,Tt);return r&&n?qt(r.type,[Ct,Pt,zt,It,Tt])?new je(r,n):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${jt(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!Gt(e,["boolean","string","number","null"]))throw new we(`Expected first argument to be of type boolean, string, number or null, but found ${jt(ze(e))} instead.`);if(!Gt(r,["string","array"]))throw new we(`Expected second argument to be of type array or string, but found ${jt(ze(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}}class Ne{constructor(t,e,r){this.type=zt,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Tt),n=e.parse(t[2],2,Tt);if(!r||!n)return null;if(!qt(r.type,[Ct,Pt,zt,It,Tt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${jt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,zt);return i?new Ne(r,n,i):null}return new Ne(r,n)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!Gt(e,["boolean","string","number","null"]))throw new we(`Expected first argument to be of type boolean, string, number or null, but found ${jt(ze(e))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(t)),Gt(r,["string"])){const t=r.indexOf(e,n);return -1===t?-1:[...r.slice(0,t)].length}if(Gt(r,["array"]))return r.indexOf(e,n);throw new we(`Expected second argument to be of type array or string, but found ${jt(ze(r))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}}class Ue{constructor(t,e,r,n,i,s){this.inputType=t,this.type=e,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,n;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);const i={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,ze(t)))return null}else r=ze(t);if(void 0!==i[String(t)])return u.error("Branch labels must be unique.");i[String(t)]=s.length;}const c=e.parse(l,a,n);if(!c)return null;n=n||c.type,s.push(c);}const a=e.parse(t[1],1,Tt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,n);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new Ue(r,n,a,i,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (ze(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class qe{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n=[];for(let i=1;i<t.length-1;i+=2){const s=e.parse(t[i],i,Ct);if(!s)return null;const a=e.parse(t[i+1],i+1,r);if(!a)return null;n.push([s,a]),r=r||a.type;}const i=e.parse(t[t.length-1],t.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new qe(r,n,i)}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class Ge{constructor(t,e,r,n){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=n;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Tt),n=e.parse(t[2],2,zt);if(!r||!n)return null;if(!qt(r.type,[Rt(Tt),Pt,Tt]))return e.error(`Expected first argument to be of type array or string, but found ${jt(r.type)} instead`);if(4===t.length){const i=e.parse(t[3],3,zt);return i?new Ge(r.type,r,n,i):null}return new Ge(r.type,r,n)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);let n;if(this.endIndex&&(n=this.endIndex.evaluate(t)),Gt(e,["string"]))return [...e].slice(r,n).join("");if(Gt(e,["array"]))return e.slice(r,n);throw new we(`Expected first argument to be of type array or string, but found ${jt(ze(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}}function Ze(t,e){const r=t.length-1;let n,i,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),n=t[o],i=t[o+1],n<=e){if(o===r||e<i)return o;s=o+1;}else {if(!(n>e))throw new we("Input is not a number.");a=o-1;}return 0}class Xe{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,zt);if(!r)return null;const n=[];let i=null;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(n.length&&n[n.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new Xe(i,r,n)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;return n>=e[i-1]?r[i-1].evaluate(t):r[Ze(e,n)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function Ke(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var He,Ye,Je=function(){if(Ye)return He;function t(t,e,r,n){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(n-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=r,this.p2y=n;}return Ye=1,He=t,t.prototype={sampleCurveX:function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return ((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var r=t,n=0;n<8;n++){var i=this.sampleCurveX(r)-t;if(Math.abs(i)<e)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var a=0,o=1;for(r=t,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-t)<e));n++)t>i?a=r:o=r,r=.5*(o-a)+a;return r},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},He}(),We=Ke(Je);class Qe{constructor(t,e,r,n,i){this.type=t,this.operator=e,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,e,r,n){let i=0;if("exponential"===t.name)i=tr(e,t.base,r,n);else if("linear"===t.name)i=tr(e,1,r,n);else if("cubic-bezier"===t.name){const s=t.controlPoints;i=new We(s[0],s[1],s[2],s[3]).solve(tr(e,1,r,n));}return i}static parse(t,e){let[r,n,i,...s]=t;if(!Array.isArray(n)||0===n.length)return e.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const t=n[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:t};}else {if("cubic-bezier"!==n[0])return e.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const t=n.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(i=e.parse(i,2,zt),!i)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=Bt:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],n=s[t+1],i=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=e.parse(n,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return Zt(o,zt)||Zt(o,Vt)||Zt(o,Bt)||Zt(o,Lt)||Zt(o,Dt)||Zt(o,Rt(zt))?new Qe(o,r,n,i,a):e.error(`Type ${jt(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const n=this.input.evaluate(t);if(n<=e[0])return r[0].evaluate(t);const i=e.length;if(n>=e[i-1])return r[i-1].evaluate(t);const s=Ze(e,n),a=Qe.interpolationFactor(this.interpolation,n,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);switch(this.operator){case "interpolate":switch(this.type.kind){case "number":return fe(o,l,a);case "color":return ye.interpolate(o,l,a);case "padding":return be.interpolate(o,l,a);case "variableAnchorOffsetCollection":return Se.interpolate(o,l,a);case "array":return de(o,l,a);case "projectionDefinition":return ke.interpolate(o,l,a)}case "interpolate-hcl":return ye.interpolate(o,l,a,"hcl");case "interpolate-lab":return ye.interpolate(o,l,a,"lab")}}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function tr(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}const er={color:ye.interpolate,number:fe,padding:be.interpolate,variableAnchorOffsetCollection:Se.interpolate,array:de};class rr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r=null;const n=e.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of t.slice(1)){const t=e.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,i.push(t);}if(!r)throw new Error("No output type");const s=n&&i.some((t=>Ut(n,t.type)));return new rr(s?Tt:r,i)}evaluate(t){let e,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(t),r&&r instanceof Ae&&!r.available&&(e||(e=r.name),r=null,n===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function nr(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function ir(t,e,r,n){return 0===n.compare(e,r)}function sr(t,e,r){const n="=="!==t&&"!="!==t;return class i{constructor(t,e,r){this.type=Ct,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Tt);if(!s)return null;if(!nr(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${jt(s.type)}'.`);let a=e.parse(t[2],2,Tt);if(!a)return null;if(!nr(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${jt(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${jt(s.type)}' and '${jt(a.type)}'.`);n&&("value"===s.type.kind&&"value"!==a.type.kind?s=new Ve(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new Ve(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Ft),!o)return null}return new i(s,a,o)}evaluate(i){const s=this.lhs.evaluate(i),a=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const e=ze(s),r=ze(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new we(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const t=ze(s),r=ze(a);if("string"!==t.kind||"string"!==r.kind)return e(i,s,a)}return this.collator?r(i,s,a,this.collator.evaluate(i)):e(i,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}}}const ar=sr("==",(function(t,e,r){return e===r}),ir),or=sr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,n){return !ir(0,e,r,n)})),lr=sr("<",(function(t,e,r){return e<r}),(function(t,e,r,n){return n.compare(e,r)<0})),ur=sr(">",(function(t,e,r){return e>r}),(function(t,e,r,n){return n.compare(e,r)>0})),cr=sr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,n){return n.compare(e,r)<=0})),hr=sr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,n){return n.compare(e,r)>=0}));class pr{constructor(t,e,r){this.type=Ft,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const n=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Ct);if(!n)return null;const i=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Ct);if(!i)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Pt),!s)?null:new pr(n,i,s)}evaluate(t){return new me(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}}class fr{constructor(t,e,r,n,i){this.type=Pt,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,zt);if(!r)return null;const n=t[2];if("object"!=typeof n||Array.isArray(n))return e.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=e.parse(n.locale,1,Pt),!i))return null;let s=null;if(n.currency&&(s=e.parse(n.currency,1,Pt),!s))return null;let a=null;if(n["min-fraction-digits"]&&(a=e.parse(n["min-fraction-digits"],1,zt),!a))return null;let o=null;return n["max-fraction-digits"]&&(o=e.parse(n["max-fraction-digits"],1,zt),!o)?null:new fr(r,i,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}}class dr{constructor(t){this.type=$t,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,zt),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,Rt(Pt)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Bt),!a))return null;let o=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!ge.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(o=e.parse(s["vertical-align"],1,Pt),!o)return null}const l=n[n.length-1];l.scale=t,l.font=r,l.textColor=a,l.verticalAlign=o;}else {const s=e.parse(t[r],1,Tt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null});}}return new dr(n)}evaluate(t){return new ve(this.sections.map((e=>{const r=e.content.evaluate(t);return ze(r)===Ot?new xe("",r,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new xe(Pe(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign);}outputDefined(){return !1}}class yr{constructor(t){this.type=Ot,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Pt);return r?new yr(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=Ae.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}}class mr{constructor(t){this.type=zt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${jt(r.type)} instead.`):new mr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return [...e].length;if(Array.isArray(e))return e.length;throw new we(`Expected value to be of type string or array, but found ${jt(ze(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}}const gr=8192;function xr(t,e){const r=(180+t[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,i=Math.pow(2,e.z);return [Math.round(r*i*gr),Math.round(n*i*gr)]}function vr(t,e){const r=Math.pow(2,e.z);return [(i=(t[0]/gr+e.x)/r,360*i-180),(n=(t[1]/gr+e.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i;}function br(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function wr(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function _r(t,e,r){const n=t[0]-e[0],i=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return n*a-s*i==0&&n*s<=0&&i*a<=0}function Sr(t,e,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-i[1]*s[0]&&!(!Pr(t,e,r,n)||!Pr(r,n,t,e));var i,s;}function Ar(t,e,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Sr(t,e,n[r],n[r+1]))return !0;return !1}function kr(t,e,r=!1){let n=!1;for(const o of e)for(let e=0;e<o.length-1;e++){if(_r(t,o[e],o[e+1]))return r;(s=o[e])[1]>(i=t)[1]!=(a=o[e+1])[1]>i[1]&&i[0]<(a[0]-s[0])*(i[1]-s[1])/(a[1]-s[1])+s[0]&&(n=!n);}var i,s,a;return n}function Mr(t,e){for(const r of e)if(kr(t,r))return !0;return !1}function Ir(t,e){for(const r of t)if(!kr(r,e))return !1;for(let r=0;r<t.length-1;++r)if(Ar(t[r],t[r+1],e))return !1;return !0}function zr(t,e){for(const r of e)if(Ir(t,r))return !0;return !1}function Pr(t,e,r,n){const i=n[0]-r[0],s=n[1]-r[1],a=(t[0]-r[0])*s-i*(t[1]-r[1]),o=(e[0]-r[0])*s-i*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function Cr(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=[];for(let n=0;n<t[i].length;n++){const a=xr(t[i][n],r);br(e,a),s.push(a);}n.push(s);}return n}function Br(t,e,r){const n=[];for(let i=0;i<t.length;i++){const s=Cr(t[i],e,r);n.push(s);}return n}function Vr(t,e,r,n){if(t[0]<r[0]||t[0]>r[2]){const e=.5*n;let i=t[0]-r[0]>e?-n:r[0]-t[0]>e?n:0;0===i&&(i=t[0]-r[2]>e?-n:r[2]-t[0]>e?n:0),t[0]+=i;}br(e,t);}function Er(t,e,r,n){const i=Math.pow(2,n.z)*gr,s=[n.x*gr,n.y*gr],a=[];for(const n of t)for(const t of n){const n=[t.x+s[0],t.y+s[1]];Vr(n,e,r,i),a.push(n);}return a}function Tr(t,e,r,n){const i=Math.pow(2,n.z)*gr,s=[n.x*gr,n.y*gr],a=[];for(const r of t){const t=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];br(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=i/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const n of t)Vr(n,e,r,i);}var o;return a}class Fr{constructor(t,e){this.type=Ct,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ie(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const r of e.features){const{type:e,coordinates:n}=r.geometry;"Polygon"===e&&t.push(n),"MultiPolygon"===e&&t.push(...n);}if(t.length)return new Fr(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Fr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Fr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Cr(e.coordinates,n,i),a=Er(t.geometry(),r,n,i);if(!wr(r,n))return !1;for(const t of a)if(!kr(t,s))return !1}if("MultiPolygon"===e.type){const s=Br(e.coordinates,n,i),a=Er(t.geometry(),r,n,i);if(!wr(r,n))return !1;for(const t of a)if(!Mr(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=t.canonicalID();if("Polygon"===e.type){const s=Cr(e.coordinates,n,i),a=Tr(t.geometry(),r,n,i);if(!wr(r,n))return !1;for(const t of a)if(!Ir(t,s))return !1}if("MultiPolygon"===e.type){const s=Br(e.coordinates,n,i),a=Tr(t.geometry(),r,n,i);if(!wr(r,n))return !1;for(const t of a)if(!zr(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}let $r=class{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}};function Lr(t,e,r=0,n=t.length-1,i=Dr){for(;n>r;){if(n-r>600){const s=n-r+1,a=e-r+1,o=Math.log(s),l=.5*Math.exp(2*o/3),u=.5*Math.sqrt(o*l*(s-l)/s)*(a-s/2<0?-1:1);Lr(t,e,Math.max(r,Math.floor(e-a*l/s+u)),Math.min(n,Math.floor(e+(s-a)*l/s+u)),i);}const s=t[e];let a=r,o=n;for(Or(t,r,e),i(t[n],s)>0&&Or(t,r,n);a<o;){for(Or(t,a,o),a++,o--;i(t[a],s)<0;)a++;for(;i(t[o],s)>0;)o--;}0===i(t[r],s)?Or(t,r,o):(o++,Or(t,o,n)),o<=e&&(r=o+1),e<=o&&(n=o-1);}}function Or(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Dr(t,e){return t<e?-1:t>e?1:0}function Rr(t,e){if(t.length<=1)return [t];const r=[];let n,i;for(const e of t){const t=Nr(e);0!==t&&(e.area=Math.abs(t),void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e]):n.push(e));}if(n&&r.push(n),e>1)for(let t=0;t<r.length;t++)r[t].length<=e||(Lr(r[t],e,1,r[t].length-1,jr),r[t]=r[t].slice(0,e));return r}function jr(t,e){return e.area-t.area}function Nr(t){let e=0;for(let r,n,i=0,s=t.length,a=s-1;i<s;a=i++)r=t[i],n=t[a],e+=(n.x-r.x)*(r.y+n.y);return e}const Ur=1/298.257223563,qr=Ur*(2-Ur),Gr=Math.PI/180;class Zr{constructor(t){const e=6378.137*Gr*1e3,r=Math.cos(t*Gr),n=1/(1-qr*(1-r*r)),i=Math.sqrt(n);this.kx=e*i*r,this.ky=e*i*n*(1-qr);}distance(t,e){const r=this.wrap(t[0]-e[0])*this.kx,n=(t[1]-e[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(t,e){let r,n,i,s,a=1/0;for(let o=0;o<t.length-1;o++){let l=t[o][0],u=t[o][1],c=this.wrap(t[o+1][0]-l)*this.kx,h=(t[o+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(e[0]-l)*this.kx*c+(e[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=t[o+1][0],u=t[o+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(e[0]-l)*this.kx,h=(e[1]-u)*this.ky;const f=c*c+h*h;f<a&&(a=f,r=l,n=u,i=o,s=p);}return {point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function Xr(t,e){return e[0]-t[0]}function Kr(t){return t[1]-t[0]+1}function Hr(t,e){return t[1]>=t[0]&&t[1]<e}function Yr(t,e){if(t[0]>t[1])return [null,null];const r=Kr(t);if(e){if(2===r)return [t,null];const e=Math.floor(r/2);return [[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===r)return [t,null];const n=Math.floor(r/2)-1;return [[t[0],t[0]+n],[t[0]+n+1,t[1]]]}function Jr(t,e){if(!Hr(e,t.length))return [1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=e[0];n<=e[1];++n)br(r,t[n]);return r}function Wr(t){const e=[1/0,1/0,-1/0,-1/0];for(const r of t)for(const t of r)br(e,t);return e}function Qr(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function tn(t,e,r){if(!Qr(t)||!Qr(e))return NaN;let n=0,i=0;return t[2]<e[0]&&(n=e[0]-t[2]),t[0]>e[2]&&(n=t[0]-e[2]),t[1]>e[3]&&(i=t[1]-e[3]),t[3]<e[1]&&(i=e[1]-t[3]),r.distance([0,0],[n,i])}function en(t,e,r){const n=r.pointOnLine(e,t);return r.distance(t,n.point)}function rn(t,e,r,n,i){const s=Math.min(en(t,[r,n],i),en(e,[r,n],i)),a=Math.min(en(r,[t,e],i),en(n,[t,e],i));return Math.min(s,a)}function nn(t,e,r,n,i){if(!Hr(e,t.length)||!Hr(n,r.length))return 1/0;let s=1/0;for(let a=e[0];a<e[1];++a){const e=t[a],o=t[a+1];for(let t=n[0];t<n[1];++t){const n=r[t],a=r[t+1];if(Sr(e,o,n,a))return 0;s=Math.min(s,rn(e,o,n,a,i));}}return s}function sn(t,e,r,n,i){if(!Hr(e,t.length)||!Hr(n,r.length))return NaN;let s=1/0;for(let a=e[0];a<=e[1];++a)for(let e=n[0];e<=n[1];++e)if(s=Math.min(s,i.distance(t[a],r[e])),0===s)return s;return s}function an(t,e,r){if(kr(t,e,!0))return 0;let n=1/0;for(const i of e){const e=i[0],s=i[i.length-1];if(e!==s&&(n=Math.min(n,en(t,[s,e],r)),0===n))return n;const a=r.pointOnLine(i,t);if(n=Math.min(n,r.distance(t,a.point)),0===n)return n}return n}function on(t,e,r,n){if(!Hr(e,t.length))return NaN;for(let n=e[0];n<=e[1];++n)if(kr(t[n],r,!0))return 0;let i=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],a=t[s+1];for(const t of r)for(let r=0,s=t.length,o=s-1;r<s;o=r++){const s=t[o],l=t[r];if(Sr(e,a,s,l))return 0;i=Math.min(i,rn(e,a,s,l,n));}}return i}function ln(t,e){for(const r of t)for(const t of r)if(kr(t,e,!0))return !0;return !1}function un(t,e,r,n=1/0){const i=Wr(t),s=Wr(e);if(n!==1/0&&tn(i,s,r)>=n)return n;if(wr(i,s)){if(ln(t,e))return 0}else if(ln(e,t))return 0;let a=1/0;for(const n of t)for(let t=0,i=n.length,s=i-1;t<i;s=t++){const i=n[s],o=n[t];for(const t of e)for(let e=0,n=t.length,s=n-1;e<n;s=e++){const n=t[s],l=t[e];if(Sr(i,o,n,l))return 0;a=Math.min(a,rn(i,o,n,l,r));}}return a}function cn(t,e,r,n,i,s){if(!s)return;const a=tn(Jr(n,s),i,r);a<e&&t.push([a,s,[0,0]]);}function hn(t,e,r,n,i,s,a){if(!s||!a)return;const o=tn(Jr(n,s),Jr(i,a),r);o<e&&t.push([o,s,a]);}function pn(t,e,r,n,i=1/0){let s=Math.min(n.distance(t[0],r[0][0]),i);if(0===s)return s;const a=new $r([[0,[0,t.length-1],[0,0]]],Xr),o=Wr(r);for(;a.length>0;){const i=a.pop();if(i[0]>=s)continue;const l=i[1],u=e?50:100;if(Kr(l)<=u){if(!Hr(l,t.length))return NaN;if(e){const e=on(t,l,r,n);if(isNaN(e)||0===e)return e;s=Math.min(s,e);}else for(let e=l[0];e<=l[1];++e){const i=an(t[e],r,n);if(s=Math.min(s,i),0===s)return 0}}else {const r=Yr(l,e);cn(a,s,n,t,o,r[0]),cn(a,s,n,t,o,r[1]);}}return s}function fn(t,e,r,n,i,s=1/0){let a=Math.min(s,i.distance(t[0],r[0]));if(0===a)return a;const o=new $r([[0,[0,t.length-1],[0,r.length-1]]],Xr);for(;o.length>0;){const s=o.pop();if(s[0]>=a)continue;const l=s[1],u=s[2],c=e?50:100,h=n?50:100;if(Kr(l)<=c&&Kr(u)<=h){if(!Hr(l,t.length)&&Hr(u,r.length))return NaN;let s;if(e&&n)s=nn(t,l,r,u,i),a=Math.min(a,s);else if(e&&!n){const e=t.slice(l[0],l[1]+1);for(let t=u[0];t<=u[1];++t)if(s=en(r[t],e,i),a=Math.min(a,s),0===a)return a}else if(!e&&n){const e=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=en(t[r],e,i),a=Math.min(a,s),0===a)return a}else s=sn(t,l,r,u,i),a=Math.min(a,s);}else {const s=Yr(l,e),c=Yr(u,n);hn(o,a,i,t,r,s[0],c[0]),hn(o,a,i,t,r,s[0],c[1]),hn(o,a,i,t,r,s[1],c[0]),hn(o,a,i,t,r,s[1],c[1]);}}return a}function dn(t){return "MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class yn{constructor(t,e){this.type=zt,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Ie(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new yn(e,e.features.map((t=>dn(t.geometry))).flat());if("Feature"===e.type)return new yn(e,dn(e.geometry));if("type"in e&&"coordinates"in e)return new yn(e,dn(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>vr([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new Zr(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case "Point":s=Math.min(s,fn(n,!1,[t.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,fn(n,!1,t.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,pn(n,!1,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=t.geometry(),n=r.flat().map((e=>vr([e.x,e.y],t.canonical)));if(0===r.length)return NaN;const i=new Zr(n[0][1]);let s=1/0;for(const t of e){switch(t.type){case "Point":s=Math.min(s,fn(n,!0,[t.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,fn(n,!0,t.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,pn(n,!0,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const r=t.geometry();if(0===r.length||0===r[0].length)return NaN;const n=Rr(r,0).map((e=>e.map((e=>e.map((e=>vr([e.x,e.y],t.canonical))))))),i=new Zr(n[0][0][0][1]);let s=1/0;for(const t of e)for(const e of n){switch(t.type){case "Point":s=Math.min(s,pn([t.coordinates],!1,e,i,s));break;case "LineString":s=Math.min(s,pn(t.coordinates,!0,e,i,s));break;case "Polygon":s=Math.min(s,un(e,t.coordinates,i,s));}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return !0}}const mn={"==":ar,"!=":or,">":ur,"<":lr,">=":hr,"<=":cr,array:Ve,at:Re,boolean:Ve,case:qe,coalesce:rr,collator:pr,format:dr,image:yr,in:je,"index-of":Ne,interpolate:Qe,"interpolate-hcl":Qe,"interpolate-lab":Qe,length:mr,let:Oe,literal:Ce,match:Ue,number:Ve,"number-format":fr,object:Ve,slice:Ge,step:Xe,string:Ve,"to-boolean":Te,"to-color":Te,"to-number":Te,"to-string":Te,var:De,within:Fr,distance:yn};class gn{constructor(t,e,r,n){this.name=t,this.type=e,this._evaluate=r,this.args=n;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}static parse(t,e){const r=t[0],n=gn.definitions[r];if(!n)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,a=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let o=null;for(const[n,s]of a){o=new Le(e.registry,_n,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],i=Array.isArray(n)?n[e-1]:n.type,s=o.parse(r,1+a.length,i);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(n)&&n.length!==a.length)o.error(`Expected ${n.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(n)?n[t]:n.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new gn(r,i,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(jt).join(", ")})`:`(${jt(e.type)}...)`;var e;})).join(" | "),n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],1+n.length);if(!i)return null;n.push(jt(i.type));}e.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(t,e){gn.definitions=e;for(const r in e)t[r]=gn;}}function xn(t,[e,r,n,i]){e=e.evaluate(t),r=r.evaluate(t),n=n.evaluate(t);const s=i?i.evaluate(t):1,a=Me(e,r,n,s);if(a)throw new we(a);return new ye(e/255,r/255,n/255,s,!1)}function vn(t,e){return t in e}function bn(t,e){const r=e[t];return void 0===r?null:r}function wn(t){return {type:t}}function _n(t){if(t instanceof De)return _n(t.boundExpression);if(t instanceof gn&&"error"===t.name)return !1;if(t instanceof pr)return !1;if(t instanceof Fr)return !1;if(t instanceof yn)return !1;const e=t instanceof Te||t instanceof Ve;let r=!0;return t.eachChild((t=>{r=e?r&&_n(t):r&&t instanceof Ce;})),!!r&&Sn(t)&&kn(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function Sn(t){if(t instanceof gn){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof Fr)return !1;if(t instanceof yn)return !1;let e=!0;return t.eachChild((t=>{e&&!Sn(t)&&(e=!1);})),e}function An(t){if(t instanceof gn&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild((t=>{e&&!An(t)&&(e=!1);})),e}function kn(t,e){if(t instanceof gn&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild((t=>{r&&!kn(t,e)&&(r=!1);})),r}function Mn(t){return {result:"success",value:t}}function In(t){return {result:"error",value:t}}function zn(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Pn(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Cn(t){return !!t.expression&&t.expression.interpolated}function Bn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function Vn(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function En(t){return t}function Tn(t,e){const r="color"===e.type,n=t.stops&&"object"==typeof t.stops[0][0],i=n||!(n||void 0!==t.property),s=t.type||(Cn(e)?"exponential":"interval");if(r||"padding"===e.type){const n=r?ye.parse:be.parse;(t=At({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],n(t[1])]))),t.default=n(t.default?t.default:e.default);}if(t.colorSpace&&"rgb"!==(a=t.colorSpace)&&"hcl"!==a&&"lab"!==a)throw new Error(`Unknown color space: "${t.colorSpace}"`);var a;let o,l,u;if("exponential"===s)o=On;else if("interval"===s)o=Ln;else if("categorical"===s){o=$n,l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];u=typeof t.stops[0][0];}else {if("identity"!==s)throw new Error(`Unknown function type "${s}"`);o=Dn;}if(n){const r={},n=[];for(let e=0;e<t.stops.length;e++){const i=t.stops[e],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const t of n)i.push([r[t].zoom,Tn(r[t],e)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:Qe.interpolationFactor.bind(void 0,s),zoomStops:i.map((t=>t[0])),evaluate:({zoom:r},n)=>On({stops:i,base:t.base},e,r).evaluate(r,n)}}if(i){const r="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:Qe.interpolationFactor.bind(void 0,r),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:r})=>o(t,e,r,l,u)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[t.property]:void 0;return void 0===i?Fn(t.default,e.default):o(t,e,i,l,u)}}}function Fn(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function $n(t,e,r,n,i){return Fn(typeof r===i?n[r]:void 0,t.default,e.default)}function Ln(t,e,r){if("number"!==Bn(r))return Fn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const i=Ze(t.stops.map((t=>t[0])),r);return t.stops[i][1]}function On(t,e,r){const n=void 0!==t.base?t.base:1;if("number"!==Bn(r))return Fn(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const s=Ze(t.stops.map((t=>t[0])),r),a=function(t,e,r,n){const i=n-r,s=t-r;return 0===i?0:1===e?s/i:(Math.pow(e,s)-1)/(Math.pow(e,i)-1)}(r,n,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1],u=er[e.type]||En;return "function"==typeof o.evaluate?{evaluate(...e){const r=o.evaluate.apply(void 0,e),n=l.evaluate.apply(void 0,e);if(void 0!==r&&void 0!==n)return u(r,n,a,t.colorSpace)}}:u(o,l,a,t.colorSpace)}function Dn(t,e,r){switch(e.type){case "color":r=ye.parse(r);break;case "formatted":r=ve.fromString(r.toString());break;case "resolvedImage":r=Ae.fromString(r.toString());break;case "padding":r=be.parse(r);break;default:Bn(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0);}return Fn(r,t.default,e.default)}gn.register(mn,{error:[{kind:"error"},[Pt],(t,[e])=>{throw new we(e.evaluate(t))}],typeof:[Pt,[Tt],(t,[e])=>jt(ze(e.evaluate(t)))],"to-rgba":[Rt(zt,4),[Bt],(t,[e])=>{const[r,n,i,s]=e.evaluate(t).rgb;return [255*r,255*n,255*i,s]}],rgb:[Bt,[zt,zt,zt],xn],rgba:[Bt,[zt,zt,zt,zt],xn],has:{type:Ct,overloads:[[[Pt],(t,[e])=>vn(e.evaluate(t),t.properties())],[[Pt,Et],(t,[e,r])=>vn(e.evaluate(t),r.evaluate(t))]]},get:{type:Tt,overloads:[[[Pt],(t,[e])=>bn(e.evaluate(t),t.properties())],[[Pt,Et],(t,[e,r])=>bn(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Tt,[Pt],(t,[e])=>bn(e.evaluate(t),t.featureState||{})],properties:[Et,[],t=>t.properties()],"geometry-type":[Pt,[],t=>t.geometryType()],id:[Tt,[],t=>t.id()],zoom:[zt,[],t=>t.globals.zoom],"heatmap-density":[zt,[],t=>t.globals.heatmapDensity||0],"line-progress":[zt,[],t=>t.globals.lineProgress||0],accumulated:[Tt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[zt,wn(zt),(t,e)=>{let r=0;for(const n of e)r+=n.evaluate(t);return r}],"*":[zt,wn(zt),(t,e)=>{let r=1;for(const n of e)r*=n.evaluate(t);return r}],"-":{type:zt,overloads:[[[zt,zt],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[zt],(t,[e])=>-e.evaluate(t)]]},"/":[zt,[zt,zt],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[zt,[zt,zt],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[zt,[],()=>Math.LN2],pi:[zt,[],()=>Math.PI],e:[zt,[],()=>Math.E],"^":[zt,[zt,zt],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[zt,[zt],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[zt,[zt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[zt,[zt],(t,[e])=>Math.log(e.evaluate(t))],log2:[zt,[zt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[zt,[zt],(t,[e])=>Math.sin(e.evaluate(t))],cos:[zt,[zt],(t,[e])=>Math.cos(e.evaluate(t))],tan:[zt,[zt],(t,[e])=>Math.tan(e.evaluate(t))],asin:[zt,[zt],(t,[e])=>Math.asin(e.evaluate(t))],acos:[zt,[zt],(t,[e])=>Math.acos(e.evaluate(t))],atan:[zt,[zt],(t,[e])=>Math.atan(e.evaluate(t))],min:[zt,wn(zt),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[zt,wn(zt),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[zt,[zt],(t,[e])=>Math.abs(e.evaluate(t))],round:[zt,[zt],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[zt,[zt],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[zt,[zt],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Ct,[Pt,Tt],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Ct,[Tt],(t,[e])=>t.id()===e.value],"filter-type-==":[Ct,[Pt],(t,[e])=>t.geometryType()===e.value],"filter-<":[Ct,[Pt,Tt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Ct,[Tt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<n}],"filter->":[Ct,[Pt,Tt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Ct,[Tt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>n}],"filter-<=":[Ct,[Pt,Tt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Ct,[Tt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r<=n}],"filter->=":[Ct,[Pt,Tt],(t,[e,r])=>{const n=t.properties()[e.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Ct,[Tt],(t,[e])=>{const r=t.id(),n=e.value;return typeof r==typeof n&&r>=n}],"filter-has":[Ct,[Tt],(t,[e])=>e.value in t.properties()],"filter-has-id":[Ct,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Ct,[Rt(Pt)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Ct,[Rt(Tt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Ct,[Pt,Rt(Tt)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Ct,[Pt,Rt(Tt)],(t,[e,r])=>function(t,e,r,n){for(;r<=n;){const i=r+n>>1;if(e[i]===t)return !0;e[i]>t?n=i-1:r=i+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Ct,overloads:[[[Ct,Ct],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[wn(Ct),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Ct,overloads:[[[Ct,Ct],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[wn(Ct),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Ct,[Ct],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Ct,[Pt],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Pt,[Pt],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Pt,[Pt],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Pt,wn(Tt),(t,e)=>e.map((e=>Pe(e.evaluate(t)))).join("")],"resolved-locale":[Pt,[Ft],(t,[e])=>e.evaluate(t).resolvedLocale()]});class Rn{constructor(t,e){var r;this.expression=t,this._warningHistory={},this._evaluator=new $e,this._defaultValue=e?"color"===(r=e).type&&Vn(r.default)?new ye(0,0,0,0):"color"===r.type?ye.parse(r.default)||null:"padding"===r.type?be.parse(r.default)||null:"variableAnchorOffsetCollection"===r.type?Se.parse(r.default)||null:"projectionDefinition"===r.type?ke.parse(r.default)||null:void 0===r.default?null:r.default:null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,n,i,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new we(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function jn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in mn}function Nn(t,e){const r=new Le(mn,_n,[],e?function(t){const e={color:Bt,string:Pt,number:zt,enum:Pt,boolean:Ct,formatted:$t,padding:Lt,projectionDefinition:Vt,resolvedImage:Ot,variableAnchorOffsetCollection:Dt};return "array"===t.type?Rt(e[t.value]||Tt,t.length):e[t.type]}(e):void 0),n=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return n?Mn(new Rn(n,e)):In(r.errors)}class Un{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!An(e.expression);}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}}class qn{constructor(t,e,r,n){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!An(e.expression),this.interpolationType=n;}evaluateWithoutErrorHandling(t,e,r,n,i,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,n,i,s)}evaluate(t,e,r,n,i,s){return this._styleExpression.evaluate(t,e,r,n,i,s)}interpolationFactor(t,e,r){return this.interpolationType?Qe.interpolationFactor(this.interpolationType,t,e,r):0}}function Gn(t,e){const r=Nn(t,e);if("error"===r.result)return r;const n=r.value.expression,i=Sn(n);if(!i&&!zn(e))return In([new kt("","data expressions not supported")]);const s=kn(n,["zoom"]);if(!s&&!Pn(e))return In([new kt("","zoom expressions not supported")]);const a=Xn(n);return a||s?a instanceof kt?In([a]):a instanceof Qe&&!Cn(e)?In([new kt("",'"interpolate" expressions cannot be used with this property')]):Mn(a?new qn(i?"camera":"composite",r.value,a.labels,a instanceof Qe?a.interpolation:void 0):new Un(i?"constant":"source",r.value)):In([new kt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Zn{constructor(t,e){this._parameters=t,this._specification=e,At(this,Tn(this._parameters,this._specification));}static deserialize(t){return new Zn(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function Xn(t){let e=null;if(t instanceof Oe)e=Xn(t.result);else if(t instanceof rr){for(const r of t.args)if(e=Xn(r),e)break}else (t instanceof Xe||t instanceof Qe)&&t.input instanceof gn&&"zoom"===t.input.name&&(e=t);return e instanceof kt||t.eachChild((t=>{const r=Xn(t);r instanceof kt?e=r:!e&&r?e=new kt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&r&&e!==r&&(e=new kt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),e}function Kn(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case "has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case "in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case "!in":case "!has":case "none":return !1;case "==":case "!=":case ">":case ">=":case "<":case "<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case "any":case "all":for(const e of t.slice(1))if(!Kn(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const Hn={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function Yn(t){if(null==t)return {filter:()=>!0,needGeometry:!1};Kn(t)||(t=Qn(t));const e=Nn(t,Hn);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return {filter:(t,r,n)=>e.value.evaluate(t,r,{},n),needGeometry:Wn(t)}}function Jn(t,e){return t<e?-1:t>e?1:0}function Wn(t){if(!Array.isArray(t))return !1;if("within"===t[0]||"distance"===t[0])return !0;for(let e=1;e<t.length;e++)if(Wn(t[e]))return !0;return !1}function Qn(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?ti(t[1],t[2],"=="):"!="===e?ni(ti(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?ti(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(Qn))):"all"===e?["all"].concat(t.slice(1).map(Qn)):"none"===e?["all"].concat(t.slice(1).map(Qn).map(ni)):"in"===e?ei(t[1],t.slice(2)):"!in"===e?ni(ei(t[1],t.slice(2))):"has"===e?ri(t[1]):"!has"!==e||ni(ri(t[1]));var r;}function ti(t,e,r){switch(t){case "$type":return [`filter-type-${r}`,e];case "$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function ei(t,e){if(0===e.length)return !1;switch(t){case "$type":return ["filter-type-in",["literal",e]];case "$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(Jn)]]:["filter-in-small",t,["literal",e]]}}function ri(t){switch(t){case "$type":return !0;case "$id":return ["filter-has-id"];default:return ["filter-has",t]}}function ni(t){return ["!",t]}function ii(t){const e=typeof t;if("number"===e||"boolean"===e||"string"===e||null==t)return JSON.stringify(t);if(Array.isArray(t)){let e="[";for(const r of t)e+=`${ii(r)},`;return `${e}]`}const r=Object.keys(t).sort();let n="{";for(let e=0;e<r.length;e++)n+=`${JSON.stringify(r[e])}:${ii(t[r[e]])},`;return `${n}}`}function si(t){let e="";for(const r of pt)e+=`/${ii(t[r])}`;return e}function ai(t){const e=t.value;return e?[new St(t.key,e,"constants have been deprecated as of v8")]:[]}function oi(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function li(t){if(Array.isArray(t))return t.map(li);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=li(t[r]);return e}return oi(t)}function ui(t){const e=t.key,r=t.value,n=t.valueSpec||{},i=t.objectElementValidators||{},s=t.style,a=t.styleSpec,o=t.validateSpec;let l=[];const u=Bn(r);if("object"!==u)return [new St(e,r,`object expected, ${u} found`)];for(const t in r){const u=t.split(".")[0],c=n[u]||n["*"];let h;if(i[u])h=i[u];else if(n[u])h=o;else if(i["*"])h=i["*"];else {if(!n["*"]){l.push(new St(e,r[t],`unknown property "${t}"`));continue}h=o;}l=l.concat(h({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:c,style:s,styleSpec:a,object:r,objectKey:t,validateSpec:o},r));}for(const t in n)i[t]||n[t].required&&void 0===n[t].default&&void 0===r[t]&&l.push(new St(e,r,`missing required property "${t}"`));return l}function ci(t){const e=t.value,r=t.valueSpec,n=t.style,i=t.styleSpec,s=t.key,a=t.arrayElementValidator||t.validateSpec;if("array"!==Bn(e))return [new St(s,e,`array expected, ${Bn(e)} found`)];if(r.length&&e.length!==r.length)return [new St(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new St(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values};i.$version<7&&(o.function=r.function),"object"===Bn(r.value)&&(o=r.value);let l=[];for(let r=0;r<e.length;r++)l=l.concat(a({array:e,arrayIndex:r,value:e[r],valueSpec:o,validateSpec:t.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function hi(t){const e=t.key,r=t.value,n=t.valueSpec;let i=Bn(r);return "number"===i&&r!=r&&(i="NaN"),"number"!==i?[new St(e,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new St(e,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new St(e,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function pi(t){const e=t.valueSpec,r=oi(t.value.type);let n,i,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Bn(t.value.stops)&&"array"===Bn(t.value.stops[0])&&"object"===Bn(t.value.stops[0][0]),c=ui({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new St(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const n=t.value;return e=e.concat(ci({key:t.key,value:n,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Bn(n)&&0===n.length&&e.push(new St(t.key,n,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new St(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new St(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!Cn(t.valueSpec)&&c.push(new St(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!zn(t.valueSpec)?c.push(new St(t.key,t.value,"property functions not supported")):o&&!Pn(t.valueSpec)&&c.push(new St(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new St(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const n=t.value,o=t.key;if("array"!==Bn(n))return [new St(o,n,`array expected, ${Bn(n)} found`)];if(2!==n.length)return [new St(o,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Bn(n[0]))return [new St(o,n,`object expected, ${Bn(n[0])} found`)];if(void 0===n[0].zoom)return [new St(o,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new St(o,n,"object stop key must have value")];if(s&&s>oi(n[0].zoom))return [new St(o,n[0].zoom,"stop zoom values must appear in ascending order")];oi(n[0].zoom)!==s&&(s=oi(n[0].zoom),i=void 0,a={}),r=r.concat(ui({key:`${o}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:hi,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:n[0],valueSpec:{},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},n));return jn(li(n[1]))?r.concat([new St(`${o}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(t.validateSpec({key:`${o}[1]`,value:n[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Bn(t.value),l=oi(t.value),u=null!==t.value?t.value:s;if(n){if(o!==n)return [new St(t.key,u,`${o} stop domain type must match previous stop domain type ${n}`)]}else n=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new St(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let n=`number expected, ${o} found`;return zn(e)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new St(t.key,u,n)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==i&&l<i?[new St(t.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in a?[new St(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new St(t.key,u,`integer expected, found ${l}`)]}}function fi(t){const e=("property"===t.expressionContext?Gn:Nn)(li(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new St(`${t.key}${e.key}`,t.value,e.message)));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new St(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!An(r))return [new St(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!An(r))return [new St(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!kn(r,["zoom","feature-state"]))return [new St(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Sn(r))return [new St(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function di(t){const e=t.key,r=t.value,n=t.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(oi(r))&&i.push(new St(e,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(oi(r))&&i.push(new St(e,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function yi(t){return Kn(li(t.value))?fi(At({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):mi(t)}function mi(t){const e=t.value,r=t.key;if("array"!==Bn(e))return [new St(r,e,`array expected, ${Bn(e)} found`)];const n=t.styleSpec;let i,s=[];if(e.length<1)return [new St(r,e,"filter array must have at least 1 element")];switch(s=s.concat(di({key:`${r}[0]`,value:e[0],valueSpec:n.filter_operator,style:t.style,styleSpec:t.styleSpec})),oi(e[0])){case "<":case "<=":case ">":case ">=":e.length>=2&&"$type"===oi(e[1])&&s.push(new St(r,e,`"$type" cannot be use with operator "${e[0]}"`));case "==":case "!=":3!==e.length&&s.push(new St(r,e,`filter array for operator "${e[0]}" must have 3 elements`));case "in":case "!in":e.length>=2&&(i=Bn(e[1]),"string"!==i&&s.push(new St(`${r}[1]`,e[1],`string expected, ${i} found`)));for(let a=2;a<e.length;a++)i=Bn(e[a]),"$type"===oi(e[1])?s=s.concat(di({key:`${r}[${a}]`,value:e[a],valueSpec:n.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new St(`${r}[${a}]`,e[a],`string, number, or boolean expected, ${i} found`));break;case "any":case "all":case "none":for(let n=1;n<e.length;n++)s=s.concat(mi({key:`${r}[${n}]`,value:e[n],style:t.style,styleSpec:t.styleSpec}));break;case "has":case "!has":i=Bn(e[1]),2!==e.length?s.push(new St(r,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new St(`${r}[1]`,e[1],`string expected, ${i} found`));}return s}function gi(t,e){const r=t.key,n=t.validateSpec,i=t.style,s=t.styleSpec,a=t.value,o=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return [];const u=o.match(/^(.*)-transition$/);if("paint"===e&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:a,valueSpec:s.transition,style:i,styleSpec:s});const c=t.valueSpec||l[o];if(!c)return [new St(r,a,`unknown property "${o}"`)];let h;if("string"===Bn(a)&&zn(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(a)))return [new St(r,a,`"${o}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return "symbol"===t.layerType&&("text-field"===o&&i&&!i.glyphs&&p.push(new St(r,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===o&&Vn(li(a))&&"identity"===oi(a.type)&&p.push(new St(r,a,'"text-font" does not support identity functions'))),p.concat(n({key:t.key,value:a,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:o}))}function xi(t){return gi(t,"paint")}function vi(t){return gi(t,"layout")}function bi(t){let e=[];const r=t.value,n=t.key,i=t.style,s=t.styleSpec;r.type||r.ref||e.push(new St(n,r,'either "type" or "ref" is required'));let a=oi(r.type);const o=oi(r.ref);if(r.id){const s=oi(r.id);for(let a=0;a<t.arrayIndex;a++){const t=i.layers[a];oi(t.id)===s&&e.push(new St(n,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in r&&e.push(new St(n,r[t],`"${t}" is prohibited for ref layers`));})),i.layers.forEach((e=>{oi(e.id)===o&&(t=e);})),t?t.ref?e.push(new St(n,r.ref,"ref cannot reference another ref layer")):a=oi(t.type):e.push(new St(n,r.ref,`ref layer "${o}" not found`));}else if("background"!==a)if(r.source){const t=i.sources&&i.sources[r.source],s=t&&oi(t.type);t?"vector"===s&&"raster"===a?e.push(new St(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===a?e.push(new St(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==a?e.push(new St(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new St(n,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new St(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new St(n,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new St(n,r.source,`source "${r.source}" not found`));}else e.push(new St(n,r,'missing required property "source"'));return e=e.concat(ui({key:n,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:r,objectKey:"type"}),filter:yi,layout:t=>ui({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>vi(At({layerType:a},t))}}),paint:t=>ui({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>xi(At({layerType:a},t))}})}})),e}function wi(t){const e=t.value,r=t.key,n=Bn(e);return "string"!==n?[new St(r,e,`string expected, ${n} found`)]:[]}const _i={promoteId:function({key:t,value:e}){if("string"===Bn(e))return wi({key:t,value:e});{const r=[];for(const n in e)r.push(...wi({key:`${t}.${n}`,value:e[n]}));return r}}};function Si(t){const e=t.value,r=t.key,n=t.styleSpec,i=t.style,s=t.validateSpec;if(!e.type)return [new St(r,e,'"type" is required')];const a=oi(e.type);let o;switch(a){case "vector":case "raster":return o=ui({key:r,value:e,valueSpec:n[`source_${a.replace("-","_")}`],style:t.style,styleSpec:n,objectElementValidators:_i,validateSpec:s}),o;case "raster-dem":return o=function(t){var e;const r=null!==(e=t.sourceName)&&void 0!==e?e:"",n=t.value,i=t.styleSpec,s=i.source_raster_dem,a=t.style;let o=[];const l=Bn(n);if(void 0===n)return o;if("object"!==l)return o.push(new St("source_raster_dem",n,`object expected, ${l} found`)),o;const u="custom"===oi(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in n)!u&&c.includes(e)?o.push(new St(e,n[e],`In "${r}": "${e}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[e]?o=o.concat(t.validateSpec({key:e,value:n[e],valueSpec:s[e],validateSpec:t.validateSpec,style:a,styleSpec:i})):o.push(new St(e,n[e],`unknown property "${e}"`));return o}({sourceName:r,value:e,style:t.style,styleSpec:n,validateSpec:s}),o;case "geojson":if(o=ui({key:r,value:e,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:_i}),e.cluster)for(const t in e.clusterProperties){const[n,i]=e.clusterProperties[t],a="string"==typeof n?[n,["accumulated"],["get",t]]:n;o.push(...fi({key:`${r}.${t}.map`,value:i,validateSpec:s,expressionContext:"cluster-map"})),o.push(...fi({key:`${r}.${t}.reduce`,value:a,validateSpec:s,expressionContext:"cluster-reduce"}));}return o;case "video":return ui({key:r,value:e,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case "image":return ui({key:r,value:e,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case "canvas":return [new St(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return di({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:i,validateSpec:s,styleSpec:n})}}function Ai(t){const e=t.value,r=t.styleSpec,n=r.light,i=t.style;let s=[];const a=Bn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new St("light",e,`object expected, ${a} found`)]),s;for(const a in e){const o=a.match(/^(.*)-transition$/);s=s.concat(o&&n[o[1]]&&n[o[1]].transition?t.validateSpec({key:a,value:e[a],valueSpec:r.transition,validateSpec:t.validateSpec,style:i,styleSpec:r}):n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new St(a,e[a],`unknown property "${a}"`)]);}return s}function ki(t){const e=t.value,r=t.styleSpec,n=r.sky,i=t.style,s=Bn(e);if(void 0===e)return [];if("object"!==s)return [new St("sky",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new St(s,e[s],`unknown property "${s}"`)]);return a}function Mi(t){const e=t.value,r=t.styleSpec,n=r.terrain,i=t.style;let s=[];const a=Bn(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new St("terrain",e,`object expected, ${a} found`)]),s;for(const a in e)s=s.concat(n[a]?t.validateSpec({key:a,value:e[a],valueSpec:n[a],validateSpec:t.validateSpec,style:i,styleSpec:r}):[new St(a,e[a],`unknown property "${a}"`)]);return s}function Ii(t){let e=[];const r=t.value,n=t.key;if(Array.isArray(r)){const i=[],s=[];for(const a in r)r[a].id&&i.includes(r[a].id)&&e.push(new St(n,r,`all the sprites' ids must be unique, but ${r[a].id} is duplicated`)),i.push(r[a].id),r[a].url&&s.includes(r[a].url)&&e.push(new St(n,r,`all the sprites' URLs must be unique, but ${r[a].url} is duplicated`)),s.push(r[a].url),e=e.concat(ui({key:`${n}[${a}]`,value:r[a],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return wi({key:n,value:r})}const zi={"*":()=>[],array:ci,boolean:function(t){const e=t.value,r=t.key,n=Bn(e);return "boolean"!==n?[new St(r,e,`boolean expected, ${n} found`)]:[]},number:hi,color:function(t){const e=t.key,r=t.value,n=Bn(r);return "string"!==n?[new St(e,r,`color expected, ${n} found`)]:ye.parse(String(r))?[]:[new St(e,r,`color expected, "${r}" found`)]},constants:ai,enum:di,filter:yi,function:pi,layer:bi,object:ui,source:Si,light:Ai,sky:ki,terrain:Mi,projection:function(t){const e=t.value,r=t.styleSpec,n=r.projection,i=t.style,s=Bn(e);if(void 0===e)return [];if("object"!==s)return [new St("projection",e,`object expected, ${s} found`)];let a=[];for(const s in e)a=a.concat(n[s]?t.validateSpec({key:s,value:e[s],valueSpec:n[s],style:i,styleSpec:r}):[new St(s,e[s],`unknown property "${s}"`)]);return a},projectionDefinition:function(t){const e=t.key;let r=t.value;r=r instanceof String?r.valueOf():r;const n=Bn(r);return "array"!==n||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(r)||function(t){return !!["interpolate","step","literal"].includes(t[0])}(r)?["array","string"].includes(n)?[]:[new St(e,r,`projection expected, invalid type "${n}" found`)]:[new St(e,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:wi,formatted:function(t){return 0===wi(t).length?[]:fi(t)},resolvedImage:function(t){return 0===wi(t).length?[]:fi(t)},padding:function(t){const e=t.key,r=t.value;if("array"===Bn(r)){if(r.length<1||r.length>4)return [new St(e,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(t.validateSpec({key:`${e}[${s}]`,value:r[s],validateSpec:t.validateSpec,valueSpec:n}));return i}return hi({key:e,value:r,valueSpec:{}})},variableAnchorOffsetCollection:function(t){const e=t.key,r=t.value,n=Bn(r),i=t.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return [new St(e,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(di({key:`${e}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(ci({key:`${e}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:i}));return s},sprite:Ii};function Pi(t){const e=t.value,r=t.valueSpec,n=t.styleSpec;return t.validateSpec=Pi,r.expression&&Vn(oi(e))?pi(t):r.expression&&jn(li(e))?fi(t):r.type&&zi[r.type]?zi[r.type](t):ui(At({},t,{valueSpec:r.type?n[r.type]:r}))}function Ci(t){const e=t.value,r=t.key,n=wi(t);return n.length||(-1===e.indexOf("{fontstack}")&&n.push(new St(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&n.push(new St(r,e,'"glyphs" url must include a "{range}" token'))),n}function Bi(t,e=ht){let r=[];return r=r.concat(Pi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Pi,objectElementValidators:{glyphs:Ci,"*":()=>[]}})),t.constants&&(r=r.concat(ai({key:"constants",value:t.constants,style:t,styleSpec:e,validateSpec:Pi}))),Ei(r)}function Vi(t){return function(e){return t({...e,validateSpec:Pi})}}function Ei(t){return [].concat(t).sort(((t,e)=>t.line-e.line))}function Ti(t){return function(...e){return Ei(t.apply(this,e))}}Bi.source=Ti(Vi(Si)),Bi.sprite=Ti(Vi(Ii)),Bi.glyphs=Ti(Vi(Ci)),Bi.light=Ti(Vi(Ai)),Bi.sky=Ti(Vi(ki)),Bi.terrain=Ti(Vi(Mi)),Bi.layer=Ti(Vi(bi)),Bi.filter=Ti(Vi(yi)),Bi.paintProperty=Ti(Vi(xi)),Bi.layoutProperty=Ti(Vi(vi));const Fi=Bi,$i=Fi.light,Li=Fi.sky,Oi=Fi.paintProperty,Di=Fi.layoutProperty;function Ri(t,e){let r=!1;if(e&&e.length)for(const n of e)t.fire(new ut(new Error(n.message))),r=!0;return r}class ji{constructor(t,e,r){const n=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const i=new Int32Array(this.arrayBuffer);t=i[0],this.d=(e=i[1])+2*(r=i[2]);for(let t=0;t<this.d*this.d;t++){const e=i[3+t],r=i[3+t+1];n.push(e===r?null:i.subarray(e,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(let t=0;t<this.d*this.d;t++)n.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;const i=r/e*t;this.min=-i,this.max=t+i;}insert(t,e,r,n,i){this._forEachCell(e,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,r,n,i,s){this.cells[i].push(s);}query(t,e,r,n,i){const s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,r,n,this._queryCell,s,{},i),s}}_queryCell(t,e,r,n,i,s,a,o){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===a[h]){const l=4*h;(o?o(u[l+0],u[l+1],u[l+2],u[l+3]):t<=u[l+2]&&e<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(a[h]=!0,s.push(i[h])):a[h]=!1;}}}}_forEachCell(t,e,r,n,i,s,a,o){const l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,t,e,r,n,u,s,a,o))return}}_convertFromCellCoord(t){return (t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let r=0;for(let t=0;t<this.cells.length;t++)r+=this.cells[t].length;const n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=e;for(let e=0;e<t.length;e++){const r=t[e];n[3+e]=i,n.set(r,i),i+=r.length;}return n[3+t.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+t.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}}static deserialize(t){return new ji(t.buffer)}}const Ni={};function Ui(t,e,r={}){if(Ni[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Ni[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}Ui("Object",Object),Ui("TransferableGridIndex",ji),Ui("Color",ye),Ui("Error",Error),Ui("AJAXError",rt),Ui("ResolvedImage",Ae),Ui("StylePropertyFunction",Zn),Ui("StyleExpression",Rn,{omit:["_evaluator"]}),Ui("ZoomDependentExpression",qn),Ui("ZoomConstantExpression",Un),Ui("CompoundExpression",gn,{omit:["_evaluate"]});for(const t in mn)mn[t]._classRegistryKey||Ui(`Expression_${t}`,mn[t]);function qi(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Gi(t){return t.$name||t.constructor._classRegistryKey}function Zi(t){return !function(t){if(null===t||"object"!=typeof t)return !1;const e=Gi(t);return !(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||qi(t)||G(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function Xi(t,e){if(Zi(t))return (qi(t)||G(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const n of t)r.push(Xi(n,e));return r}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const r=Gi(t);if(!r)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!Ni[r])throw new Error(`${r} is not registered.`);const{klass:n}=Ni[r],i=n.serialize?n.serialize(t,e):{};if(n.serialize){if(e&&i===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const n in t){if(!t.hasOwnProperty(n))continue;if(Ni[r].omit.indexOf(n)>=0)continue;const s=t[n];i[n]=Ni[r].shallow.indexOf(n)>=0?s:Xi(s,e);}t instanceof Error&&(i.message=t.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==r&&(i.$name=r),i}function Ki(t){if(Zi(t))return t;if(Array.isArray(t))return t.map(Ki);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=Gi(t)||"Object";if(!Ni[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:r}=Ni[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const n=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const i=t[r];n[r]=Ni[e].shallow.indexOf(r)>=0?i:Ki(i);}return n}class Hi{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const Yi={"Latin-1 Supplement":t=>t>=128&&t<=255,"Hangul Jamo":t=>t>=4352&&t<=4607,Khmer:t=>t>=6016&&t<=6143,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Katakana:t=>t>=12448&&t<=12543,Kanbun:t=>t>=12688&&t<=12703,"CJK Strokes":t=>t>=12736&&t<=12783,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"Private Use Area":t=>t>=57344&&t<=63743,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function Ji(t){for(const e of t)if(ns(e.charCodeAt(0)))return !0;return !1}function Wi(t){for(const e of t)if(!es(e.charCodeAt(0)))return !1;return !0}function Qi(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}const ts=Qi(["Arab","Dupl","Mong","Ougr","Syrc"]);function es(t){return !ts.test(String.fromCodePoint(t))}const rs=Qi(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function ns(t){return !(746!==t&&747!==t&&(t<4352||!(Yi["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||Yi["CJK Compatibility"](t)||Yi["CJK Strokes"](t)||!(!Yi["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||Yi["Enclosed CJK Letters and Months"](t)||Yi["Ideographic Description Characters"](t)||Yi.Kanbun(t)||Yi.Katakana(t)&&12540!==t||!(!Yi["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!Yi["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||Yi["Vertical Forms"](t)||Yi["Yijing Hexagram Symbols"](t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||rs.test(String.fromCodePoint(t)))))}function is(t){return !(ns(t)||function(t){return !!(Yi["Latin-1 Supplement"](t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||Yi["General Punctuation"](t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||Yi["Letterlike Symbols"](t)||Yi["Number Forms"](t)||Yi["Miscellaneous Technical"](t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||Yi["Control Pictures"](t)&&9251!==t||Yi["Optical Character Recognition"](t)||Yi["Enclosed Alphanumerics"](t)||Yi["Geometric Shapes"](t)||Yi["Miscellaneous Symbols"](t)&&!(t>=9754&&t<=9759)||Yi["Miscellaneous Symbols and Arrows"](t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||Yi["CJK Symbols and Punctuation"](t)||Yi.Katakana(t)||Yi["Private Use Area"](t)||Yi["CJK Compatibility Forms"](t)||Yi["Small Form Variants"](t)||Yi["Halfwidth and Fullwidth Forms"](t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}const ss=Qi(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function as(t){return ss.test(String.fromCodePoint(t))}function os(t,e){return !(!e&&as(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||Yi.Khmer(t))}function ls(t){for(const e of t)if(as(e.charCodeAt(0)))return !0;return !1}const us=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{};}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL;}getState(){return {pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(us.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve();}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,r){return e(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const e=t.pluginURL,n=new Promise((t=>{this.loadScriptResolve=t;}));r(e);const i=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:e};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${e}`)}))}};class cs{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Hi,this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!os(r.charCodeAt(0),e))return !1;return !0}(t,"loaded"===us.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class hs{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(Vn(t))return new Zn(t,e);if(jn(t)){const r=Gn(t,e);if("error"===r.result)throw new Error(r.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return r.value}{let r=t;return "color"===e.type&&"string"==typeof t?r=ye.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?r=Se.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(r=ke.parse(t)):r=be.parse(t),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class ps{constructor(t){this.property=t,this.value=new hs(t,void 0);}transitioned(t,e){return new ds(this.property,this.value,e,F({},t.transition,this.transition),t.now)}untransitioned(){return new ds(this.property,this.value,null,{},0)}}class fs{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return D(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ps(this._values[t].property)),this._values[t].value=new hs(this._values[t].property,null===e?void 0:D(e));}getTransition(t){return D(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new ps(this._values[t].property)),this._values[t].transition=D(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const n=this.getTransition(e);void 0!==n&&(t[`${e}-transition`]=n);}return t}transitioned(t,e){const r=new ys(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(t,e._values[n]);return r}untransitioned(){const t=new ys(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class ds{constructor(t,e,r,n,i){this.property=t,this.value=e,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,t.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const n=t.now||0,i=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),i,C(a))}}return i}}class ys{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const n=new xs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class ms{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}hasValue(t){return void 0!==this._values[t].value}getValue(t){return D(this._values[t].value)}setValue(t,e){this._values[t]=new hs(this._values[t].property,null===e?void 0:D(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const n=new xs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(t,e,r);return n}}class gs{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,n){return this.property.evaluate(this.value,this.parameters,t,e,r,n)}}class xs{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class vs{constructor(t){this.specification=t;}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,r){const n=er[this.specification.type];return n?n(t,e,r):t}}class bs{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,n){return new gs(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,n)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new gs(this,{kind:"constant",value:void 0},t.parameters);const n=er[this.specification.type];if(n){const i=n(t.value.value,e.value.value,r);return new gs(this,{kind:"constant",value:i},t.parameters)}return t}evaluate(t,e,r,n,i,s){return "constant"===t.kind?t.value:t.evaluate(e,r,n,i,s)}}class ws extends bs{possiblyEvaluate(t,e,r,n){if(void 0===t.value)return new gs(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n),s="resolvedImage"===t.property.specification.type&&"string"!=typeof i?i.name:i,a=this._calculate(s,s,s,e);return new gs(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new gs(this,{kind:"constant",value:r},e)}return new gs(this,t.expression,e)}evaluate(t,e,r,n,i,s){if("source"===t.kind){const a=t.evaluate(e,r,n,i,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,n),t.evaluate({zoom:Math.floor(e.zoom)},r,n),t.evaluate({zoom:Math.floor(e.zoom)+1},r,n),e):t.value}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class _s{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){if(void 0!==t.value){if("constant"===t.expression.kind){const i=t.expression.evaluate(e,null,{},r,n);return this._calculate(i,i,i,e)}return this._calculate(t.expression.evaluate(new cs(Math.floor(e.zoom-1),e)),t.expression.evaluate(new cs(Math.floor(e.zoom),e)),t.expression.evaluate(new cs(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class Ss{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,n){return !!t.expression.evaluate(e,null,{},r,n)}interpolate(){return !1}}class As{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const n=this.defaultPropertyValues[e]=new hs(r,void 0),i=this.defaultTransitionablePropertyValues[e]=new ps(r);this.defaultTransitioningPropertyValues[e]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=n.possiblyEvaluate({});}}}Ui("DataDrivenProperty",bs),Ui("DataConstantProperty",vs),Ui("CrossFadedDataDrivenProperty",ws),Ui("CrossFadedProperty",_s),Ui("ColorRampProperty",Ss);const ks="-transition";class Ms extends ct{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new ms(e.layout)),e.paint)){this._transitionablePaint=new fs(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new xs(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Di,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return t.endsWith(ks)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Oi,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(t.endsWith(ks))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const r=this._transitionablePaint._values[t],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),O(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,r,n,i={}){return (!i||!1!==i.validate)&&Ri(this,t.call(Fi,{key:e,layerType:this.type,objectKey:r,value:n,styleSpec:ht,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof gs&&zn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const Is={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class zs{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class Ps{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function Cs(t,e=1){let r=0,n=0;return {members:t.map((t=>{const i=Is[t.type].BYTES_PER_ELEMENT,s=r=Bs(r,Math.max(e,i)),a=t.components||1;return n=Math.max(n,i),r+=i*a,{name:t.name,type:t.type,components:a,offset:s}})),size:Bs(r,Math.max(n,e)),alignment:e}}function Bs(t,e){return Math.ceil(t/e)*e}class Vs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.int16[n+0]=e,this.int16[n+1]=r,t}}Vs.prototype.bytesPerElement=4,Ui("StructArrayLayout2i4",Vs);class Es extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.int16[i+0]=e,this.int16[i+1]=r,this.int16[i+2]=n,t}}Es.prototype.bytesPerElement=6,Ui("StructArrayLayout3i6",Es);class Ts extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,t}}Ts.prototype.bytesPerElement=8,Ui("StructArrayLayout4i8",Ts);class Fs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}Fs.prototype.bytesPerElement=12,Ui("StructArrayLayout2i4i12",Fs);class $s extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=4*t,l=8*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=a,t}}$s.prototype.bytesPerElement=8,Ui("StructArrayLayout2i4ub8",$s);class Ls extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.float32[n+0]=e,this.float32[n+1]=r,t}}Ls.prototype.bytesPerElement=8,Ui("StructArrayLayout2f8",Ls);class Os extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,n,i,s,a,o,l,u)}emplace(t,e,r,n,i,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}Os.prototype.bytesPerElement=20,Ui("StructArrayLayout10ui20",Os);class Ds extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,n,i,s,a,o,l,u,c,h)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=12*t;return this.int16[f+0]=e,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=a,this.uint16[f+6]=o,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,t}}Ds.prototype.bytesPerElement=24,Ui("StructArrayLayout4i4ui4i24",Ds);class Rs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.float32[i+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Rs.prototype.bytesPerElement=12,Ui("StructArrayLayout3f12",Rs);class js extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}js.prototype.bytesPerElement=4,Ui("StructArrayLayout1ul4",js);class Ns extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l){const u=this.length;return this.resize(u+1),this.emplace(u,t,e,r,n,i,s,a,o,l)}emplace(t,e,r,n,i,s,a,o,l,u){const c=10*t,h=5*t;return this.int16[c+0]=e,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=a,this.uint32[h+3]=o,this.uint16[c+8]=l,this.uint16[c+9]=u,t}}Ns.prototype.bytesPerElement=20,Ui("StructArrayLayout6i1ul2ui20",Ns);class Us extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=n,this.int16[o+3]=i,this.int16[o+4]=s,this.int16[o+5]=a,t}}Us.prototype.bytesPerElement=12,Ui("StructArrayLayout2i2i2i12",Us);class qs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,n,i)}emplace(t,e,r,n,i,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=n,this.int16[o+6]=i,this.int16[o+7]=s,t}}qs.prototype.bytesPerElement=16,Ui("StructArrayLayout2f1f2i16",qs);class Gs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,n,i,s)}emplace(t,e,r,n,i,s,a){const o=16*t,l=4*t,u=8*t;return this.uint8[o+0]=e,this.uint8[o+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=a,t}}Gs.prototype.bytesPerElement=16,Ui("StructArrayLayout2ub2f2i16",Gs);class Zs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,this.uint16[i+2]=n,t}}Zs.prototype.bytesPerElement=6,Ui("StructArrayLayout3ui6",Zs);class Xs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}Xs.prototype.bytesPerElement=48,Ui("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Xs);class Ks extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I)}emplace(t,e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k,M,I,z){const P=32*t,C=16*t;return this.int16[P+0]=e,this.int16[P+1]=r,this.int16[P+2]=n,this.int16[P+3]=i,this.int16[P+4]=s,this.int16[P+5]=a,this.int16[P+6]=o,this.int16[P+7]=l,this.uint16[P+8]=u,this.uint16[P+9]=c,this.uint16[P+10]=h,this.uint16[P+11]=p,this.uint16[P+12]=f,this.uint16[P+13]=d,this.uint16[P+14]=y,this.uint16[P+15]=m,this.uint16[P+16]=g,this.uint16[P+17]=x,this.uint16[P+18]=v,this.uint16[P+19]=b,this.uint16[P+20]=w,this.uint16[P+21]=_,this.uint16[P+22]=S,this.uint32[C+12]=A,this.float32[C+13]=k,this.float32[C+14]=M,this.uint16[P+30]=I,this.uint16[P+31]=z,t}}Ks.prototype.bytesPerElement=64,Ui("StructArrayLayout8i15ui1ul2f2ui64",Ks);class Hs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Hs.prototype.bytesPerElement=4,Ui("StructArrayLayout1f4",Hs);class Ys extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=3*t;return this.uint16[6*t+0]=e,this.float32[i+1]=r,this.float32[i+2]=n,t}}Ys.prototype.bytesPerElement=12,Ui("StructArrayLayout1ui2f12",Ys);class Js extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r)}emplace(t,e,r,n){const i=4*t;return this.uint32[2*t+0]=e,this.uint16[i+2]=r,this.uint16[i+3]=n,t}}Js.prototype.bytesPerElement=8,Ui("StructArrayLayout1ul2ui8",Js);class Ws extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const n=2*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,t}}Ws.prototype.bytesPerElement=4,Ui("StructArrayLayout2ui4",Ws);class Qs extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}Qs.prototype.bytesPerElement=2,Ui("StructArrayLayout1ui2",Qs);class ta extends Ps{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r,n)}emplace(t,e,r,n,i){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,t}}ta.prototype.bytesPerElement=16,Ui("StructArrayLayout4f16",ta);class ea extends zs{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new l(this.anchorPointX,this.anchorPointY)}}ea.prototype.size=20;class ra extends Ns{get(t){return new ea(this,t)}}Ui("CollisionBoxArray",ra);class na extends zs{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}na.prototype.size=48;class ia extends Xs{get(t){return new na(this,t)}}Ui("PlacedSymbolArray",ia);class sa extends zs{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}sa.prototype.size=64;class aa extends Ks{get(t){return new sa(this,t)}}Ui("SymbolInstanceArray",aa);class oa extends Hs{getoffsetX(t){return this.float32[1*t+0]}}Ui("GlyphOffsetArray",oa);class la extends Es{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Ui("SymbolLineVertexArray",la);class ua extends zs{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}ua.prototype.size=12;class ca extends Ys{get(t){return new ua(this,t)}}Ui("TextAnchorOffsetArray",ca);class ha extends zs{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}ha.prototype.size=8;class pa extends Js{get(t){return new ha(this,t)}}Ui("FeatureIndexArray",pa);class fa extends Vs{}class da extends Vs{}class ya extends Vs{}class ma extends Fs{}class ga extends $s{}class xa extends Ls{}class va extends Os{}class ba extends Ds{}class wa extends Rs{}class _a extends js{}class Sa extends Us{}class Aa extends Gs{}class ka extends Zs{}class Ma extends Ws{}const Ia=Cs([{name:"a_pos",components:2,type:"Int16"}],4),{members:za}=Ia;class Pa{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t;}prepareSegment(t,e,r,n){const i=this.segments[this.segments.length-1];return t>Pa.MAX_VERTEX_ARRAY_LENGTH&&j(`Max vertices per segment is ${Pa.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${Pa.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+t>Pa.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(e,r,n):i}createNewSegment(t,e,r){const n={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(t,e,r){return this.prepareSegment(0,t,e,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0;}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,n){return new Pa([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function Ca(t,e){return 256*(t=E(Math.floor(t),0,255))+E(Math.floor(e),0,255)}Pa.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Ui("SegmentVector",Pa);const Ba=Cs([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var Va,Ea,Ta,Fa={exports:{}},$a={exports:{}},La={exports:{}},Oa=function(){if(Ta)return Fa.exports;Ta=1;var t=(Va||(Va=1,$a.exports=function(t,e){var r,n,i,s,a,o,l,u;for(n=t.length-(r=3&t.length),i=e,a=3432918353,o=461845907,u=0;u<n;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return i^=t.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),$a.exports),e=(Ea||(Ea=1,La.exports=function(t,e){for(var r,n=t.length,i=e^n,s=0;n>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&t.charCodeAt(s+2))<<16;case 2:i^=(255&t.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&t.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),La.exports);return Fa.exports=t,Fa.exports.murmur3=t,Fa.exports.murmur2=e,Fa.exports}(),Da=r(Oa);class Ra{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,n){this.ids.push(ja(t)),this.positions.push(e,r,n);}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=ja(t);let r=0,n=this.ids.length-1;for(;r<n;){const t=r+n>>1;this.ids[t]>=e?n=t:r=t+1;}const i=[];for(;this.ids[r]===e;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(t,e){const r=new Float64Array(t.ids),n=new Uint32Array(t.positions);return Na(r,n,0,r.length-1),e&&e.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(t){const e=new Ra;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function ja(t){const e=+t;return !isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:Da(String(t))}function Na(t,e,r,n){for(;r<n;){const i=t[r+n>>1];let s=r-1,a=n+1;for(;;){do{s++;}while(t[s]<i);do{a--;}while(t[a]>i);if(s>=a)break;Ua(t,s,a),Ua(e,3*s,3*a),Ua(e,3*s+1,3*a+1),Ua(e,3*s+2,3*a+2);}a-r<n-a?(Na(t,e,r,a),r=a+1):(Na(t,e,a+1,n),n=a);}}function Ua(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}Ui("FeaturePositionMap",Ra);class qa{constructor(t,e){this.gl=t.gl,this.location=e;}}class Ga extends qa{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class Za extends qa{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class Xa extends qa{constructor(t,e){super(t,e),this.current=ye.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const Ka=new Float32Array(16);function Ha(t){return [Ca(255*t.r,255*t.g),Ca(255*t.b,255*t.a)]}class Ya{constructor(t,e,r){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new Xa(t,e):new Ga(t,e)}}class Ja{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,n){const i="u_pattern_to"===n?this.patternTo:"u_pattern_from"===n?this.patternFrom:"u_pixel_ratio_to"===n?this.pixelRatioTo:"u_pixel_ratio_from"===n?this.pixelRatioFrom:null;i&&t.set(i);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new Za(t,e):new Ga(t,e)}}class Wa{constructor(t,e,r,n){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(t,e,r,n,i){const s=this.paintVertexArray.length,a=this.expression.evaluate(new cs(0),e,{},n,[],i);this.paintVertexArray.resize(t),this._setPaintValue(s,t,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:0},r,n);this._setPaintValue(t,e,i);}_setPaintValue(t,e,r){if("color"===this.type){const n=Ha(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Qa{constructor(t,e,r,n,i,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(t,e,r,n,i){const s=this.expression.evaluate(new cs(this.zoom),e,{},n,[],i),a=this.expression.evaluate(new cs(this.zoom+1),e,{},n,[],i),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,s,a);}updatePaintArray(t,e,r,n){const i=this.expression.evaluate({zoom:this.zoom},r,n),s=this.expression.evaluate({zoom:this.zoom+1},r,n);this._setPaintValue(t,e,i,s);}_setPaintValue(t,e,r,n){if("color"===this.type){const i=Ha(r),s=Ha(n);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,n=E(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(n);}getBinding(t,e,r){return new Ga(t,e)}}class to{constructor(t,e,r,n,i,s){this.expression=t,this.type=e,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i;}populatePaintArray(t,e,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(n,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,n,i){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],i);}_setPaintValues(t,e,r,n){if(!n||!r)return;const{min:i,mid:s,max:a}=r,o=n[i],l=n[s],u=n[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,Ba.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,Ba.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class eo{constructor(t,e,r){this.binders={},this._buffers=[];const n=[];for(const i in t.paint._values){if(!r(i))continue;const s=t.paint.get(i);if(!(s instanceof gs&&zn(s.property.specification)))continue;const a=no(i,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[i]=h?new Ja(o.value,a):new Ya(o.value,a,l),n.push(`/u_${i}`);else if("source"===o.kind||h){const r=io(i,l,"source");this.binders[i]=h?new to(o,l,u,e,r,t.id):new Wa(o,a,l,r),n.push(`/a_${i}`);}else {const t=io(i,l,"composite");this.binders[i]=new Qa(o,a,l,u,e,t),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof Wa||e instanceof Qa?e.maxValue:0}populatePaintArrays(t,e,r,n,i){for(const s in this.binders){const a=this.binders[s];(a instanceof Wa||a instanceof Qa||a instanceof to)&&a.populatePaintArray(t,e,r,n,i);}}setConstantPatternPositions(t,e){for(const r in this.binders){const n=this.binders[r];n instanceof Ja&&n.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,n,i){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Wa||l instanceof Qa||l instanceof to)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],i),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof Ya||r instanceof Ja)&&t.push(...r.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Wa||r instanceof Qa)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof to)for(let e=0;e<Ba.members.length;e++)t.push(Ba.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof Ya||r instanceof Ja||r instanceof Qa)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Ya||i instanceof Ja||i instanceof Qa)for(const s of i.uniformNames)if(e[s]){const a=i.getBinding(t,e[s],s);r.push({name:s,property:n,binding:a});}}return r}setUniforms(t,e,r,n){for(const{name:t,property:i,binding:s}of e)this.binders[i].setUniform(s,n,r.get(i),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof to){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof Wa||r instanceof Qa)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof Wa||r instanceof Qa||r instanceof to)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof Wa||e instanceof Qa||e instanceof to)&&e.destroy();}}}class ro{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const n of t)this.programConfigurations[n.id]=new eo(n,e,r);this.needsUpload=!1,this._featureMap=new Ra,this._bufferOffset=0;}populatePaintArrays(t,e,r,n,i,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,n,i,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(t,this._featureMap,e,i,n)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function no(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function io(t,e,r){const n={color:{source:Ls,composite:ta},number:{source:Hs,composite:Ls}},i=function(t){return {"line-pattern":{source:va,composite:va},"fill-pattern":{source:va,composite:va},"fill-extrusion-pattern":{source:va,composite:va}}[t]}(t);return i&&i[r]||n[e][r]}Ui("ConstantBinder",Ya),Ui("CrossFadedConstantBinder",Ja),Ui("SourceExpressionBinder",Wa),Ui("CrossFadedCompositeBinder",to),Ui("CompositeExpressionBinder",Qa),Ui("ProgramConfiguration",eo,{omit:["_buffers"]}),Ui("ProgramConfigurationSet",ro);const so=Math.pow(2,14)-1,ao=-so-1;function oo(t){const e=M/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const n=r[t];for(let t=0;t<n.length;t++){const r=n[t],i=Math.round(r.x*e),s=Math.round(r.y*e);r.x=E(i,ao,so),r.y=E(s,ao,so),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&j("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function lo(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?oo(t):[]}}const uo=-32768;function co(t,e,r,n,i){t.emplaceBack(uo+8*e+n,uo+8*r+i);}class ho{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new da,this.indexArray=new ka,this.segments=new Pa,this.programConfigurations=new ro(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){const n=this.layers[0],i=[];let s=null,a=!1,o="heatmap"===n.type;if("circle"===n.type){const t=n;s=t.layout.get("circle-sort-key"),a=!s.isConstant(),o=o||"map"===t.paint.get("circle-pitch-alignment");}const l=o?e.subdivisionGranularity.circle:1;for(const{feature:e,id:n,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=lo(e,t);if(!this.layers[0]._featureFilter.filter(new cs(this.zoom),u,r))continue;const c=a?s.evaluate(u,{},r):void 0,h={id:n,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:oo(e),patterns:{},sortKey:c};i.push(h);}a&&i.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:a}=n,o=t[s].feature;this.addFeature(n,i,s,r,l),e.featureIndex.insert(o,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,za),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const a=s.length;for(const r of e)for(const e of r){const r=e.x,n=e.y;if(r<0||r>=M||n<0||n>=M)continue;const i=this.segments.prepareSegment(a*a,this.layoutVertexArray,this.indexArray,t.sortKey),o=i.vertexLength;for(let t=0;t<a;t++)for(let e=0;e<a;e++)co(this.layoutVertexArray,r,n,s[e],s[t]);for(let t=0;t<a-1;t++)for(let e=0;e<a-1;e++){const r=o+t*a+e,n=o+(t+1)*a+e;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1);}i.vertexLength+=a*a,i.primitiveLength+=(a-1)*(a-1)*2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},n);}}function po(t,e){for(let r=0;r<t.length;r++)if(_o(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(_o(t,e[r]))return !0;return !!go(t,e)}function fo(t,e,r){return !!_o(t,e)||!!vo(e,t,r)}function yo(t,e){if(1===t.length)return wo(e,t[0]);for(let r=0;r<e.length;r++){const n=e[r];for(let e=0;e<n.length;e++)if(_o(t,n[e]))return !0}for(let r=0;r<t.length;r++)if(wo(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(go(t,e[r]))return !0;return !1}function mo(t,e,r){if(t.length>1){if(go(t,e))return !0;for(let n=0;n<e.length;n++)if(vo(e[n],t,r))return !0}for(let n=0;n<t.length;n++)if(vo(t[n],e,r))return !0;return !1}function go(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1];for(let t=0;t<e.length-1;t++)if(xo(n,i,e[t],e[t+1]))return !0}return !1}function xo(t,e,r,n){return N(t,r,n)!==N(e,r,n)&&N(t,e,r)!==N(t,e,n)}function vo(t,e,r){const n=r*r;if(1===e.length)return t.distSqr(e[0])<n;for(let r=1;r<e.length;r++)if(bo(t,e[r-1],e[r])<n)return !0;return !1}function bo(t,e,r){const n=e.distSqr(r);if(0===n)return t.distSqr(e);const i=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/n;return t.distSqr(i<0?e:i>1?r:r.sub(e)._mult(i)._add(e))}function wo(t,e){let r,n,i,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)n=r[t],i=r[a],n.y>e.y!=i.y>e.y&&e.x<(i.x-n.x)*(e.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function _o(t,e){let r=!1;for(let n=0,i=t.length-1;n<t.length;i=n++){const s=t[n],a=t[i];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function So(t,e,r){const n=r[0],i=r[2];if(t.x<n.x&&e.x<n.x||t.x>i.x&&e.x>i.x||t.y<n.y&&e.y<n.y||t.y>i.y&&e.y>i.y)return !1;const s=N(t,e,r[0]);return s!==N(t,e,r[1])||s!==N(t,e,r[2])||s!==N(t,e,r[3])}function Ao(t,e,r){const n=e.paint.get(t).value;return "constant"===n.kind?n.value:r.programConfigurations.get(e.id).getMaxValue(t)}function ko(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function Mo(t,e,r,n,i){if(!e[0]&&!e[1])return t;const s=l.convert(e)._mult(i);"viewport"===r&&s._rotate(-n);const a=[];for(let e=0;e<t.length;e++)a.push(t[e].sub(s));return a}let Io,zo;Ui("CircleBucket",ho,{omit:["layers"]});var Po={get paint(){return zo=zo||new As({"circle-radius":new bs(ht.paint_circle["circle-radius"]),"circle-color":new bs(ht.paint_circle["circle-color"]),"circle-blur":new bs(ht.paint_circle["circle-blur"]),"circle-opacity":new bs(ht.paint_circle["circle-opacity"]),"circle-translate":new vs(ht.paint_circle["circle-translate"]),"circle-translate-anchor":new vs(ht.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new vs(ht.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new vs(ht.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new bs(ht.paint_circle["circle-stroke-width"]),"circle-stroke-color":new bs(ht.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new bs(ht.paint_circle["circle-stroke-opacity"])})},get layout(){return Io=Io||new As({"circle-sort-key":new bs(ht.layout_circle["circle-sort-key"])})}};class Co extends Ms{constructor(t){super(t,Po);}createBucket(t){return new ho(t)}queryRadius(t){const e=t;return Ao("circle-radius",this,e)+Ao("circle-stroke-width",this,e)+ko(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,pixelPosMatrix:a}){const o=Mo(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),l=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),u="map"===this.paint.get("circle-pitch-alignment"),c=u?o:function(t,e){return t.map((t=>Bo(t,e)))}(o,a),h=u?l*s:l;for(const t of n)for(const e of t){const t=u?e:Bo(e,a);let r=h;const n=_([],[e.x,e.y,0,1],a);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?r*=n[3]/i.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(r*=i.cameraToCenterDistance/n[3]),fo(c,t,r))return !0}return !1}}function Bo(t,e){const r=_([],[t.x,t.y,0,1],e);return new l(r[0]/r[3],r[1]/r[3])}class Vo extends ho{}let Eo;Ui("HeatmapBucket",Vo,{omit:["layers"]});var To={get paint(){return Eo=Eo||new As({"heatmap-radius":new bs(ht.paint_heatmap["heatmap-radius"]),"heatmap-weight":new bs(ht.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new vs(ht.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Ss(ht.paint_heatmap["heatmap-color"]),"heatmap-opacity":new vs(ht.paint_heatmap["heatmap-opacity"])})}};function Fo(t,{width:e,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==e*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${e*r*n}`)}else i=new Uint8Array(e*r*n);return t.width=e,t.height=r,t.data=i,t}function $o(t,{width:e,height:r},n){if(e===t.width&&r===t.height)return;const i=Fo({},{width:e,height:r},n);Lo(t,i,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},n),t.width=e,t.height=r,t.data=i.data;}function Lo(t,e,r,n,i,s){if(0===i.width||0===i.height)return e;if(i.width>t.width||i.height>t.height||r.x>t.width-i.width||r.y>t.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>e.width||i.height>e.height||n.x>e.width-i.width||n.y>e.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;if(a===o)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((n.y+l)*e.width+n.x)*s;for(let t=0;t<i.width*s;t++)o[c+t]=a[u+t];}return e}class Oo{constructor(t,e){Fo(this,t,1,e);}resize(t){$o(this,t,1);}clone(){return new Oo({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Lo(t,e,r,n,i,1);}}class Do{constructor(t,e){Fo(this,t,4,e);}resize(t){$o(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new Do({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,n,i){Lo(t,e,r,n,i,4);}}function Ro(t){const e={},r=t.resolution||256,n=t.clips?t.clips.length:1,i=t.image||new Do({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(r,n,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);i.data[r+n+0]=Math.floor(255*a.r/a.a),i.data[r+n+1]=Math.floor(255*a.g/a.a),i.data[r+n+2]=Math.floor(255*a.b/a.a),i.data[r+n+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,i=0;e<n;++e,i+=4*r)for(let n=0,a=0;n<r;n++,a+=4){const o=n/(r-1),{start:l,end:u}=t.clips[e];s(i,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return i}Ui("AlphaImage",Oo),Ui("RGBAImage",Do);const jo="big-fb";class No extends Ms{createBucket(t){return new Vo(t)}constructor(t){super(t,To),this.heatmapFbos=new Map,this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=Ro({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbos.has(jo)&&this.heatmapFbos.delete(jo);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Uo;var qo={get paint(){return Uo=Uo||new As({"hillshade-illumination-direction":new vs(ht.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new vs(ht.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new vs(ht.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new vs(ht.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new vs(ht.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new vs(ht.paint_hillshade["hillshade-accent-color"])})}};class Go extends Ms{constructor(t){super(t,qo);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}const Zo=Cs([{name:"a_pos",components:2,type:"Int16"}],4),{members:Xo}=Zo;function Ko(t,e,r){const n=r.patternDependencies;let i=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(i=!0);const s=e.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function Ho(t,e,r,n,i){const s=i.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:n-1},r,{},i.availableImages),o=e.evaluate({zoom:n},r,{},i.availableImages),l=e.evaluate({zoom:n+1},r,{},i.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}function Yo(t,e,r,n,i){let s;if(i===function(t,e,r,n){let i=0;for(let s=e,a=r-n;s<r;s+=n)i+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return i}(t,e,r,n)>0)for(let i=e;i<r;i+=n)s=xl(i/n|0,t[i],t[i+1],s);else for(let i=r-n;i>=e;i-=n)s=xl(i/n|0,t[i],t[i+1],s);return s&&pl(s,s.next)&&(vl(s),s=s.next),s}function Jo(t,e){if(!t)return t;e||(e=t);let r,n=t;do{if(r=!1,n.steiner||!pl(n,n.next)&&0!==hl(n.prev,n,n.next))n=n.next;else {if(vl(n),n=e=n.prev,n===n.next)break;r=!0;}}while(r||n!==e);return e}function Wo(t,e,r,n,i,s,a){if(!t)return;!a&&s&&function(t,e,r,n){let i=t;do{0===i.z&&(i.z=al(i.x,i.y,e,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==t);i.prevZ.nextZ=null,i.prevZ=null,function(t){let e,r=1;do{let n,i=t;t=null;let s=null;for(e=0;i;){e++;let a=i,o=0;for(let t=0;t<r&&(o++,a=a.nextZ,a);t++);let l=r;for(;o>0||l>0&&a;)0!==o&&(0===l||!a||i.z<=a.z)?(n=i,i=i.nextZ,o--):(n=a,a=a.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;i=a;}s.nextZ=null,r*=2;}while(e>1)}(i);}(t,n,i,s);let o=t;for(;t.prev!==t.next;){const l=t.prev,u=t.next;if(s?tl(t,n,i,s):Qo(t))e.push(l.i,t.i,u.i),vl(t),t=u.next,o=u.next;else if((t=u)===o){a?1===a?Wo(t=el(Jo(t),e),e,r,n,i,s,2):2===a&&rl(t,e,r,n,i,s):Wo(Jo(t),e,r,n,i,s,1);break}}}function Qo(t){const e=t.prev,r=t,n=t.next;if(hl(e,r,n)>=0)return !1;const i=e.x,s=r.x,a=n.x,o=e.y,l=r.y,u=n.y,c=Math.min(i,s,a),h=Math.min(o,l,u),p=Math.max(i,s,a),f=Math.max(o,l,u);let d=n.next;for(;d!==e;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&ul(i,o,s,l,a,u,d.x,d.y)&&hl(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function tl(t,e,r,n){const i=t.prev,s=t,a=t.next;if(hl(i,s,a)>=0)return !1;const o=i.x,l=s.x,u=a.x,c=i.y,h=s.y,p=a.y,f=Math.min(o,l,u),d=Math.min(c,h,p),y=Math.max(o,l,u),m=Math.max(c,h,p),g=al(f,d,e,r,n),x=al(y,m,e,r,n);let v=t.prevZ,b=t.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&ul(o,c,l,h,u,p,v.x,v.y)&&hl(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&ul(o,c,l,h,u,p,b.x,b.y)&&hl(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==a&&ul(o,c,l,h,u,p,v.x,v.y)&&hl(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==a&&ul(o,c,l,h,u,p,b.x,b.y)&&hl(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function el(t,e){let r=t;do{const n=r.prev,i=r.next.next;!pl(n,i)&&fl(n,r,r.next,i)&&ml(n,i)&&ml(i,n)&&(e.push(n.i,r.i,i.i),vl(r),vl(r.next),r=t=i),r=r.next;}while(r!==t);return Jo(r)}function rl(t,e,r,n,i,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&cl(a,t)){let o=gl(a,t);return a=Jo(a,a.next),o=Jo(o,o.next),Wo(a,e,r,n,i,s,0),void Wo(o,e,r,n,i,s,0)}t=t.next;}a=a.next;}while(a!==t)}function nl(t,e){let r=t.x-e.x;return 0===r&&(r=t.y-e.y,0===r)&&(r=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),r}function il(t,e){const r=function(t,e){let r=e;const n=t.x,i=t.y;let s,a=-1/0;if(pl(t,r))return r;do{if(pl(t,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const t=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(t<=n&&t>a&&(a=t,s=r.x<r.next.x?r:r.next,t===n))return s}r=r.next;}while(r!==e);if(!s)return null;const o=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&ll(i<u?n:a,i,l,u,i<u?a:n,i,r.x,r.y)){const e=Math.abs(i-r.y)/(n-r.x);ml(r,t)&&(e<c||e===c&&(r.x>s.x||r.x===s.x&&sl(s,r)))&&(s=r,c=e);}r=r.next;}while(r!==o);return s}(t,e);if(!r)return e;const n=gl(r,t);return Jo(n,n.next),Jo(r,r.next)}function sl(t,e){return hl(t.prev,t,e.prev)<0&&hl(e.next,t,t.next)<0}function al(t,e,r,n,i){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-n)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function ol(t){let e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function ll(t,e,r,n,i,s,a,o){return (i-a)*(e-o)>=(t-a)*(s-o)&&(t-a)*(n-o)>=(r-a)*(e-o)&&(r-a)*(s-o)>=(i-a)*(n-o)}function ul(t,e,r,n,i,s,a,o){return !(t===a&&e===o)&&ll(t,e,r,n,i,s,a,o)}function cl(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&fl(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(ml(t,e)&&ml(e,t)&&function(t,e){let r=t,n=!1;const i=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==t);return n}(t,e)&&(hl(t.prev,t,e.prev)||hl(t,e.prev,e))||pl(t,e)&&hl(t.prev,t,t.next)>0&&hl(e.prev,e,e.next)>0)}function hl(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function pl(t,e){return t.x===e.x&&t.y===e.y}function fl(t,e,r,n){const i=yl(hl(t,e,r)),s=yl(hl(t,e,n)),a=yl(hl(r,n,t)),o=yl(hl(r,n,e));return i!==s&&a!==o||!(0!==i||!dl(t,r,e))||!(0!==s||!dl(t,n,e))||!(0!==a||!dl(r,t,n))||!(0!==o||!dl(r,e,n))}function dl(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function yl(t){return t>0?1:t<0?-1:0}function ml(t,e){return hl(t.prev,t,t.next)<0?hl(t,e,t.next)>=0&&hl(t,t.prev,e)>=0:hl(t,e,t.prev)<0||hl(t,t.next,e)<0}function gl(t,e){const r=bl(t.i,t.x,t.y),n=bl(e.i,e.x,e.y),i=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function xl(t,e,r,n){const i=bl(t,e,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function vl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function bl(t,e,r){return {i:t,x:e,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class wl{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e;}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class _l{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle;}}_l.noSubdivision=new _l({fill:new wl(0,0),line:new wl(0,0),tile:new wl(0,0),stencil:new wl(0,0),circle:1}),Ui("SubdivisionGranularityExpression",wl),Ui("SubdivisionGranularitySetting",_l);const Sl=-32768,Al=32767;class kl{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=M/t,this._canonical=e;}_getKey(t,e){return (t+=32768)<<16|(e+=32768)<<0}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(t),n=0|Math.round(e),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const r=[];for(let n=0;n<e.length;n+=3){const i=e[n],s=e[n+1],a=e[n+2],o=t[2*i],l=t[2*i+1];(t[2*s]-o)*(t[2*a+1]-l)-(t[2*s+1]-l)*(t[2*a]-o)>0?(r.push(i),r.push(a),r.push(s)):(r.push(i),r.push(s),r.push(a));}return r}(this._vertexBuffer,t);const e=[],r=t.length;for(let n=0;n<r;n+=3){const r=[t[n+0],t[n+1],t[n+2]],i=[this._vertexBuffer[2*t[n+0]+0],this._vertexBuffer[2*t[n+0]+1],this._vertexBuffer[2*t[n+1]+0],this._vertexBuffer[2*t[n+1]+1],this._vertexBuffer[2*t[n+2]+0],this._vertexBuffer[2*t[n+2]+1]];let s=1/0,a=1/0,o=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=i[2*t],r=i[2*t+1];s=Math.min(s,e),o=Math.max(o,e),a=Math.min(a,r),l=Math.max(l,r);}if(s===o||a===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(o/this._granularityCellSize),h=Math.floor(a/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let t=h;t<p;t++){const n=this._scanlineGenerateVertexRingForCellRow(t,i,r);zl(this._vertexBuffer,n,e);}else e.push(...r);}return e}_scanlineGenerateVertexRingForCellRow(t,e,r){const n=t*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const a=e[2*t],o=e[2*t+1],l=e[2*(t+1)%6],u=e[(2*(t+1)+1)%6],c=e[2*(t+2)%6],h=e[(2*(t+2)+1)%6],p=l-a,f=u-o,d=0===p,y=0===f,m=(n-o)/f,g=(i-o)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(o<n||o>i)){u>=n&&u<=i&&s.push(r[(t+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(a+p*x,o+f*x));const b=a+p*Math.max(x,0),w=a+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,a,o,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(a+p*v,o+f*v)),(y||u>=n&&u<=i)&&s.push(r[(t+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,a,o,l,u,c,h,w,n,i);}return s}_generateIntraEdgeVertices(t,e,r,n,i,s,a){const o=n-e,l=i-r,u=0===l,c=u?Math.min(e,n):Math.min(s,a),h=u?Math.max(e,n):Math.max(s,a),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?e<n:s<a)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;t.push(this._vertexToIndex(i,r+l*(i-e)/o));}}_generateInterEdgeVertices(t,e,r,n,i,s,a,o,l,u){const c=i-r,h=s-n,p=a-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,o)/this._granularityCellSize)-1,b=o<g;const w=0===p;if(w&&(a===l||a===u))return;if(w||y>=1||m<=0){const t=r-a,n=s+(e-s)*Math.min((l-a)/t,(u-a)/t);x=Math.floor(Math.min(n,o)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,o)/this._granularityCellSize)-1,b=o<n;}const _=c>0?u:l;if(b)for(let e=x;e<=v;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,_));else for(let e=v;e>=x;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,_));}_generateOutline(t){const e=[];for(const r of t){const t=Il(r,this._granularity,!0),n=this._pointArrayToIndices(t),i=[];for(let t=1;t<n.length;t++)i.push(n[t-1]),i.push(n[t]);e.push(i);}return e}_handlePoles(t){let e=!1,r=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(e||r)&&this._fillPoles(t,e,r);}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const r=t[e+1];r===Sl&&(t[e+1]=-32767),r===Al&&(t[e+1]=32766);}}_generatePoleQuad(t,e,r,n,i,s){n>i!=(s===Sl)?(t.push(e),t.push(r),t.push(this._vertexToIndex(n,s)),t.push(r),t.push(this._vertexToIndex(i,s)),t.push(this._vertexToIndex(n,s))):(t.push(r),t.push(e),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(i,s)),t.push(r),t.push(this._vertexToIndex(n,s)));}_fillPoles(t,e,r){const n=this._vertexBuffer,i=M,s=t.length;for(let a=2;a<s;a+=3){const s=t[a-2],o=t[a-1],l=t[a],u=n[2*s],c=n[2*s+1],h=n[2*o],p=n[2*o+1],f=n[2*l],d=n[2*l+1];e&&(0===c&&0===p&&this._generatePoleQuad(t,s,o,u,h,Sl),0===p&&0===d&&this._generatePoleQuad(t,o,l,h,f,Sl),0===d&&0===c&&this._generatePoleQuad(t,l,s,f,u,Sl)),r&&(c===i&&p===i&&this._generatePoleQuad(t,s,o,u,h,Al),p===i&&d===i&&this._generatePoleQuad(t,o,l,h,f,Al),d===i&&c===i&&this._generatePoleQuad(t,l,s,f,u,Al));}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1]);}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(t){const e=[],r=[];for(const n of t)if(0!==n.length){n!==t[0]&&e.push(r.length/2);for(let t=0;t<n.length;t++)r.push(n[t].x),r.push(n[t].y);}return {flattened:r,holeIndices:e}}(t);let i;this._initializeVertices(r);try{const t=function(t,e,r=2){const n=e&&e.length,i=n?e[0]*r:t.length;let s=Yo(t,0,i,r,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,u;if(n&&(s=function(t,e,r,n){const i=[];for(let r=0,s=e.length;r<s;r++){const a=Yo(t,e[r]*n,r<s-1?e[r+1]*n:t.length,n,!1);a===a.next&&(a.steiner=!0),i.push(ol(a));}i.sort(nl);for(let t=0;t<i.length;t++)r=il(i[t],r);return r}(t,e,s,r)),t.length>80*r){o=1/0,l=1/0;let e=-1/0,n=-1/0;for(let s=r;s<i;s+=r){const r=t[s],i=t[s+1];r<o&&(o=r),i<l&&(l=i),r>e&&(e=r),i>n&&(n=i);}u=Math.max(e-o,n-l),u=0!==u?32767/u:0;}return Wo(s,a,r,o,l,u,0),a}(r,n),e=this._convertIndices(r,t);i=this._subdivideTrianglesScanline(e);}catch(t){console.error(t);}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(t,e){const r=[];for(let n=0;n<e.length;n++)r.push(this._vertexToIndex(t[2*e[n]],t[2*e[n]+1]));return r}_pointArrayToIndices(t){const e=[];for(let r=0;r<t.length;r++){const n=t[r];e.push(this._vertexToIndex(n.x,n.y));}return e}}function Ml(t,e,r,n=!0){return new kl(r,e).subdividePolygonInternal(t,n)}function Il(t,e,r=!1){if(!t||t.length<1)return [];if(t.length<2)return [];const n=t[0],i=t[t.length-1],s=r&&(n.x!==i.x||n.y!==i.y);if(e<2)return s?[...t,t[0]]:[...t];const a=Math.floor(M/e),o=[];o.push(new l(t[0].x,t[0].y));const u=t.length,c=s?u:u-1;for(let e=0;e<c;e++){const r=t[e],n=e<u-1?t[e+1]:t[0],i=r.x,s=r.y,c=n.x,h=n.y,p=i!==c,f=s!==h;if(!p&&!f)continue;const d=c-i,y=h-s,m=Math.abs(d),g=Math.abs(y);let x=i,v=s;for(;;){const t=d>0?(Math.floor(x/a)+1)*a:(Math.ceil(x/a)-1)*a,e=y>0?(Math.floor(v/a)+1)*a:(Math.ceil(v/a)-1)*a,r=Math.abs(x-t),n=Math.abs(v-e),i=Math.abs(x-c),s=Math.abs(v-h),u=p?r/m:Number.POSITIVE_INFINITY,b=f?n/g:Number.POSITIVE_INFINITY;if((i<=r||!p)&&(s<=n||!f))break;if(u<b&&p||!f){x=t,v+=y*u;const e=new l(x,Math.round(v));o[o.length-1].x===e.x&&o[o.length-1].y===e.y||o.push(e);}else {x+=d*b,v=e;const t=new l(Math.round(x),v);o[o.length-1].x===t.x&&o[o.length-1].y===t.y||o.push(t);}}const b=new l(c,h);o[o.length-1].x===b.x&&o[o.length-1].y===b.y||o.push(b);}return o}function zl(t,e,r){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=t[2*e[0]];for(let r=1;r<e.length;r++){const s=t[2*e[r]];s<i&&(i=s,n=r);}const s=e.length;let a=n,o=(a+1)%s;for(;;){const n=a-1>=0?a-1:s-1,i=(o+1)%s,l=t[2*e[n]],u=t[2*e[i]],c=t[2*e[a]],h=t[2*e[a]+1],p=t[2*e[o]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else {const r=p-h,s=-(t[2*e[o]]-c),a=h<p?1:-1;((l-c)*r+(t[2*e[n]+1]-h)*s)*a>((u-c)*r+(t[2*e[i]+1]-h)*s)*a&&(f=!0);}if(f){const t=e[n],i=e[a],l=e[o];t!==i&&t!==l&&i!==l&&r.push(l,i,t),a--,a<0&&(a=s-1);}else {const t=e[i],n=e[a],l=e[o];t!==n&&t!==l&&n!==l&&r.push(l,n,t),o++,o>=s&&(o=0);}if(n===i)break}}function Pl(t,e,r,n,i,s,a,o,l){const u=i.length/2,c=a&&o&&l;if(u<Pa.MAX_VERTEX_ARRAY_LENGTH){const h=e.prepareSegment(u,r,n),p=h.vertexLength;for(let t=0;t<s.length;t+=3)n.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=a.prepareSegment(u,r,o),f=d.vertexLength,d.vertexLength+=u);for(let e=0;e<i.length;e+=2)t(i[e],i[e+1]);if(c)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)o.emplaceBack(f+e[t-1],f+e[t]);d.primitiveLength+=e.length/2;}}else !function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=a[p]<l,m=a[f]<l,g=a[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>Pa.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,y=!0,m=!0,g=!0,c=0);const x=Cl(a,n,s,o,p,y,u),v=Cl(a,n,s,o,f,m,u),b=Cl(a,n,s,o,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++;}}(e,r,n,i,s,t),c&&function(t,e,r,n,i,s){const a=[];for(let t=0;t<n.length/2;t++)a.push(-1);const o={count:0};let l=0,u=t.getOrCreateLatestSegment(e,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=a[i]<l,y=a[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>Pa.MAX_VERTEX_ARRAY_LENGTH&&(u=t.createNewSegment(e,r),l=o.count,d=!0,y=!0,c=0);const m=Cl(a,n,s,o,i,d,u),g=Cl(a,n,s,o,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++;}}}(a,r,o,i,l,t),e.forceNewSegmentOnNextPrepare(),null==a||a.forceNewSegmentOnNextPrepare();}function Cl(t,e,r,n,i,s,a){if(s){const s=n.count;return r(e[2*i],e[2*i+1]),t[i]=n.count,n.count++,a.vertexLength++,s}return t[i]}class Bl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new ya,this.indexArray=new ka,this.indexArray2=new Ma,this.programConfigurations=new ro(t.layers,t.zoom),this.segments=new Pa,this.segments2=new Pa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=Ko("fill",this.layers,e);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:a,id:o,index:l,sourceLayerIndex:u}of t){const t=this.layers[0]._featureFilter.needGeometry,c=lo(a,t);if(!this.layers[0]._featureFilter.filter(new cs(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,e.availableImages):void 0,p={id:o,properties:a.properties,type:a.type,sourceLayerIndex:u,index:l,geometry:t?c.geometry:oo(a),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=Ho("fill",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Xo),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,n,i,s){for(const t of Rr(e,500)){const e=Ml(t,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;Pl(((t,e)=>{r.emplaceBack(t,e);}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}}let Vl,El;Ui("FillBucket",Bl,{omit:["layers","patternFeatures"]});var Tl={get paint(){return El=El||new As({"fill-antialias":new vs(ht.paint_fill["fill-antialias"]),"fill-opacity":new bs(ht.paint_fill["fill-opacity"]),"fill-color":new bs(ht.paint_fill["fill-color"]),"fill-outline-color":new bs(ht.paint_fill["fill-outline-color"]),"fill-translate":new vs(ht.paint_fill["fill-translate"]),"fill-translate-anchor":new vs(ht.paint_fill["fill-translate-anchor"]),"fill-pattern":new ws(ht.paint_fill["fill-pattern"])})},get layout(){return Vl=Vl||new As({"fill-sort-key":new bs(ht.layout_fill["fill-sort-key"])})}};class Fl extends Ms{constructor(t){super(t,Tl);}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new Bl(t)}queryRadius(){return ko(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:r,pixelsToTileUnits:n}){return yo(Mo(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),e)}isTileClipped(){return !0}}const $l=Cs([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),Ll=Cs([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Ol}=$l;var Dl,Rl,jl,Nl,Ul,ql,Gl,Zl={};function Xl(){if(Rl)return Dl;Rl=1;var t=s();function e(t,e,n,i,s){this.properties={},this.extent=n,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=s,t.readFields(r,this,e);}function r(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var n=e._keys[t.readVarint()],i=e._values[t.readVarint()];e.properties[n]=i;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function n(t){for(var e,r,n=0,i=0,s=t.length,a=s-1;i<s;a=i++)n+=((r=t[a]).x-(e=t[i]).x)*(e.y+r.y);return n}return Dl=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var r,n=e.readVarint()+e.pos,i=1,s=0,a=0,o=0,l=[];e.pos<n;){if(s<=0){var u=e.readVarint();i=7&u,s=u>>3;}if(s--,1===i||2===i)a+=e.readSVarint(),o+=e.readSVarint(),1===i&&(r&&l.push(r),r=[]),r.push(new t(a,o));else {if(7!==i)throw new Error("unknown command "+i);r&&r.push(r[0].clone());}}return r&&l.push(r),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,n=0,i=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(n<=0){var c=t.readVarint();r=7&c,n=c>>3;}if(n--,1===r||2===r)(i+=t.readSVarint())<a&&(a=i),i>o&&(o=i),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},e.prototype.toGeoJSON=function(t,r,i){var s,a,o=this.extent*Math.pow(2,i),l=this.extent*t,u=this.extent*r,c=this.loadGeometry(),h=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+l)/o-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+u)/o)*Math.PI/180))-90];}}switch(this.type){case 1:var f=[];for(s=0;s<c.length;s++)f[s]=c[s][0];p(c=f);break;case 2:for(s=0;s<c.length;s++)p(c[s]);break;case 3:for(c=function(t){var e=t.length;if(e<=1)return [t];for(var r,i,s=[],a=0;a<e;a++){var o=n(t[a]);0!==o&&(void 0===i&&(i=o<0),i===o<0?(r&&s.push(r),r=[t[a]]):r.push(t[a]));}return r&&s.push(r),s}(c),s=0;s<c.length;s++)for(a=0;a<c[s].length;a++)p(c[s][a]);}1===c.length?c=c[0]:h="Multi"+h;var d={type:"Feature",geometry:{type:h,coordinates:c},properties:this.properties};return "id"in this&&(d.id=this.id),d},Dl}function Kl(){if(Nl)return jl;Nl=1;var t=Xl();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(r,this,e),this.length=this._features.length;}function r(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var n=t.readVarint()>>3;e=1===n?t.readString():2===n?t.readFloat():3===n?t.readDouble():4===n?t.readVarint64():5===n?t.readVarint():6===n?t.readSVarint():7===n?t.readBoolean():null;}return e}(r));}return jl=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var r=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,r,this.extent,this._keys,this._values)},jl}function Hl(){return Gl||(Gl=1,Zl.VectorTile=function(){if(ql)return Ul;ql=1;var t=Kl();function e(e,r,n){if(3===e){var i=new t(n,n.readVarint()+n.pos);i.length&&(r[i.name]=i);}}return Ul=function(t,r){this.layers=t.readFields(e,{},r);},Ul}(),Zl.VectorTileFeature=Xl(),Zl.VectorTileLayer=Kl()),Zl}var Yl=r(Hl());const Jl=Yl.VectorTileFeature.types,Wl=Math.pow(2,13);function Ql(t,e,r,n,i,s,a,o){t.emplaceBack(e,r,2*Math.floor(n*Wl)+a,i*Wl*2,s*Wl*2,Math.round(o));}class tu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new ma,this.centroidVertexArray=new fa,this.indexArray=new ka,this.programConfigurations=new ro(t.layers,t.zoom),this.segments=new Pa,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.features=[],this.hasPattern=Ko("fill-extrusion",this.layers,e);for(const{feature:n,id:i,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=lo(n,t);if(!this.layers[0]._featureFilter.filter(new cs(this.zoom),o,r))continue;const l={id:i,sourceLayerIndex:a,index:s,geometry:t?o.geometry:oo(n),properties:n.properties,type:n.type,patterns:{}};this.hasPattern?this.features.push(Ho("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{},e.subdivisionGranularity),e.featureIndex.insert(n,l.geometry,s,a,this.index,!0);}}addFeatures(t,e,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,e,r,t.subdivisionGranularity);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ol),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,Ll.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(t,e,r,n,i,s){for(const r of Rr(e,500)){const e={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(e,n,t,r,s);const a=this.layoutVertexArray.length-i,o=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<a;t++)this.centroidVertexArray.emplaceBack(o,l);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}processPolygon(t,e,r,n,i){if(n.length<1)return;if(nu(n[0]))return;for(const e of n)0!==e.length&&eu(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},a=i.fill.getGranularityForZoomLevel(e.z),o="Polygon"===Jl[r.type];for(const t of n){if(0===t.length)continue;if(nu(t))continue;const e=Il(t,a,o);this._generateSideFaces(e,s);}if(!o)return;const l=Ml(n,e,a,!1),u=this.layoutVertexArray;Pl(((t,e)=>{Ql(u,t,e,0,0,1,1,0);}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles);}_generateSideFaces(t,e){let r=0;for(let n=1;n<t.length;n++){const i=t[n],s=t[n-1];if(ru(i,s))continue;e.segment.vertexLength+4>Pa.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const a=i.sub(s)._perp()._unit(),o=s.dist(i);r+o>32768&&(r=0),Ql(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,0,r),Ql(this.layoutVertexArray,i.x,i.y,a.x,a.y,0,1,r),r+=o,Ql(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,0,r),Ql(this.layoutVertexArray,s.x,s.y,a.x,a.y,0,1,r);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2;}}}function eu(t,e){for(let r=0;r<e.length;r++){const n=e[r];r===e.length-1&&e[0].x===n.x&&e[0].y===n.y||(t.x+=n.x,t.y+=n.y,t.sampleCount++);}}function ru(t,e){return t.x===e.x&&(t.x<0||t.x>M)||t.y===e.y&&(t.y<0||t.y>M)}function nu(t){return t.every((t=>t.x<0))||t.every((t=>t.x>M))||t.every((t=>t.y<0))||t.every((t=>t.y>M))}let iu;Ui("FillExtrusionBucket",tu,{omit:["layers","features"]});var su={get paint(){return iu=iu||new As({"fill-extrusion-opacity":new vs(ht["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new bs(ht["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new vs(ht["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new vs(ht["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new ws(ht["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new bs(ht["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new bs(ht["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new vs(ht["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class au extends Ms{constructor(t){super(t,su);}createBucket(t){return new tu(t)}queryRadius(){return ko(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,pixelPosMatrix:a}){const o=Mo(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("fill-extrusion-height").evaluate(e,r),c=this.paint.get("fill-extrusion-base").evaluate(e,r),h=function(t,e,r){const n=[];for(const r of t){const t=[r.x,r.y,0,1];_(t,t,e),n.push(new l(t[0]/t[3],t[1]/t[3]));}return n}(o,a),p=function(t,e,r,n){const i=[],s=[],a=n[8]*e,o=n[9]*e,u=n[10]*e,c=n[11]*e,h=n[8]*r,p=n[9]*r,f=n[10]*r,d=n[11]*r;for(const e of t){const t=[],r=[];for(const i of e){const e=i.x,s=i.y,y=n[0]*e+n[4]*s+n[12],m=n[1]*e+n[5]*s+n[13],g=n[2]*e+n[6]*s+n[14],x=n[3]*e+n[7]*s+n[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,A=x+d,k=new l((y+a)/b,(m+o)/b);k.z=v/b,t.push(k);const M=new l(w/A,_/A);M.z=S/A,r.push(M);}i.push(t),s.push(r);}return [i,s]}(n,c,u,a);return function(t,e,r){let n=1/0;yo(r,e)&&(n=lu(r,e[0]));for(let i=0;i<e.length;i++){const s=e[i],a=t[i];for(let t=0;t<s.length-1;t++){const e=s[t],i=[e,s[t+1],a[t+1],a[t],e];po(r,i)&&(n=Math.min(n,lu(r,i)));}}return n!==1/0&&n}(p[0],p[1],h)}}function ou(t,e){return t.x*e.x+t.y*e.y}function lu(t,e){if(1===t.length){let r=0;const n=e[r++];let i;for(;!i||n.equals(i);)if(i=e[r++],!i)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=i.sub(n),l=s.sub(n),u=a.sub(n),c=ou(o,o),h=ou(o,l),p=ou(l,l),f=ou(u,o),d=ou(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}const uu=Cs([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:cu}=uu,hu=Cs([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:pu}=hu,fu=Yl.VectorTileFeature.types,du=Math.cos(Math.PI/180*37.5),yu=Math.pow(2,14)/.5;class mu{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={};})),this.layoutVertexArray=new ga,this.layoutVertexArray2=new xa,this.indexArray=new ka,this.programConfigurations=new ro(t.layers,t.zoom),this.segments=new Pa,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id));}populate(t,e,r){this.hasPattern=Ko("line",this.layers,e);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:e,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=lo(e,t);if(!this.layers[0]._featureFilter.filter(new cs(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:a,properties:e.properties,type:e.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:oo(e),patterns:{},sortKey:c};s.push(h);}i&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:a}=n;if(this.hasPattern){const t=Ho("line",this.layers,n,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(n,i,s,r,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,i,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,e,r,t.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,pu)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,cu),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,n,i,s){const a=this.layers[0].layout,o=a.get("line-join").evaluate(t,{}),l=a.get("line-cap"),u=a.get("line-miter-limit"),c=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,o,l,u,c,n,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,i,n);}addLine(t,e,r,n,i,s,a,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=Il(t,a?o.line.getGranularityForZoomLevel(a.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===fu[e.type];let u=t.length;for(;u>=2&&t[u-1].equals(t[u-2]);)u--;let c=0;for(;c<u-1&&t[c].equals(t[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?15*M/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=t[u-2],g=t[c].sub(f)._unit()._perp());for(let e=c;e<u;e++){if(y=e===u-1?l?t[c+1]:void 0:t[e+1],y&&t[e].equals(y))continue;g&&(m=g),f&&(d=f),f=t[e],g=y?y.sub(f)._unit()._perp():m,m=m||g;let a=m.add(g);0===a.x&&0===a.y||a._unit();const o=m.x*g.x+m.y*g.y,x=a.x*g.x+a.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<du&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&e>c){const t=f.dist(d);if(t>2*h){const e=f.sub(f.sub(d)._mult(h/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,m,0,0,p),d=e;}}const S=d&&y;let A=S?r:l?"butt":n;if(S&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),d&&this.updateDistance(d,f),"miter"===A)a._mult(v),this.addCurrentVertex(f,a,0,0,p);else if("flipbevel"===A){if(v>100)a=g.mult(-1);else {const t=v*m.add(g).mag()/m.sub(g).mag();a._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(f,a,0,0,p),this.addCurrentVertex(f,a.mult(-1),0,0,p);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(d&&this.addCurrentVertex(f,m,e,r,p),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+o*(o*(3.55645-1.43519*o)-3.2452))*t*t+(.848013+o*(.215638*o-1.06021)));}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p);}}y&&this.addCurrentVertex(f,g,-e,-r,p);}else if("butt"===A)this.addCurrentVertex(f,a,0,0,p);else if("square"===A){const t=d?1:-1;this.addCurrentVertex(f,a,t,t,p);}else "round"===A&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&e<u-1){const t=f.dist(y);if(t>2*h){const e=f.add(y.sub(f)._mult(h/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,g,0,0,p),f=e;}}}}addCurrentVertex(t,e,r,n,i,s=!1){const a=e.y*n-e.x,o=-e.y-e.x*n;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,i),this.addHalfVertex(t,a,o,s,!0,-n,i),this.distance>yu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,r,n,i,s));}addHalfVertex({x:t,y:e},r,n,i,s,a,o){const l=.5*(this.lineClips?this.scaledDistance*(yu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(i?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===a?0:a<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),o.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}let gu,xu;Ui("LineBucket",mu,{omit:["layers","patternFeatures"]});var vu={get paint(){return xu=xu||new As({"line-opacity":new bs(ht.paint_line["line-opacity"]),"line-color":new bs(ht.paint_line["line-color"]),"line-translate":new vs(ht.paint_line["line-translate"]),"line-translate-anchor":new vs(ht.paint_line["line-translate-anchor"]),"line-width":new bs(ht.paint_line["line-width"]),"line-gap-width":new bs(ht.paint_line["line-gap-width"]),"line-offset":new bs(ht.paint_line["line-offset"]),"line-blur":new bs(ht.paint_line["line-blur"]),"line-dasharray":new _s(ht.paint_line["line-dasharray"]),"line-pattern":new ws(ht.paint_line["line-pattern"]),"line-gradient":new Ss(ht.paint_line["line-gradient"])})},get layout(){return gu=gu||new As({"line-cap":new vs(ht.layout_line["line-cap"]),"line-join":new bs(ht.layout_line["line-join"]),"line-miter-limit":new vs(ht.layout_line["line-miter-limit"]),"line-round-limit":new vs(ht.layout_line["line-round-limit"]),"line-sort-key":new bs(ht.layout_line["line-sort-key"])})}};class bu extends bs{possiblyEvaluate(t,e){return e=new cs(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,n){return e=F({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,n)}}let wu;class _u extends Ms{constructor(t){super(t,vu),this.gradientVersion=0,wu||(wu=new bu(vu.paint.properties["line-width"].specification),wu.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof Xe,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=wu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new mu(t)}queryRadius(t){const e=t,r=Su(Ao("line-width",this,e),Ao("line-gap-width",this,e)),n=Ao("line-offset",this,e);return r/2+Math.abs(n)+ko(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s}){const a=Mo(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-i.bearingInRadians,s),o=s/2*Su(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[];for(let n=0;n<t.length;n++){const i=t[n],s=[];for(let t=0;t<i.length;t++){const r=i[t-1],n=i[t],a=i[t+1],o=0===t?new l(0,0):n.sub(r)._unit()._perp(),u=t===i.length-1?new l(0,0):a.sub(n)._unit()._perp(),c=o._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),s.push(c._mult(e)._add(n));}r.push(s);}return r}(n,u*s)),function(t,e,r){for(let n=0;n<e.length;n++){const i=e[n];if(t.length>=3)for(let e=0;e<i.length;e++)if(_o(t,i[e]))return !0;if(mo(t,i,r))return !0}return !1}(a,n,o)}isTileClipped(){return !0}}function Su(t,e){return e>0?e+2*t:t}const Au=Cs([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),ku=Cs([{name:"a_projected_pos",components:3,type:"Float32"}],4);Cs([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const Mu=Cs([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);Cs([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Iu=Cs([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),zu=Cs([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function Pu(t,e,r){return t.sections.forEach((t=>{t.text=function(t,e,r){const n=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?t=t.toLocaleUpperCase():"lowercase"===n&&(t=t.toLocaleLowerCase()),us.applyArabicShaping&&(t=us.applyArabicShaping(t)),t}(t.text,e,r);})),t}Cs([{name:"triangle",components:3,type:"Uint16"}]),Cs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),Cs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),Cs([{type:"Float32",name:"offsetX"}]),Cs([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),Cs([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const Cu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var Bu,Vu,Eu,Tu=24,Fu={};function $u(){return Bu||(Bu=1,Fu.read=function(t,e,r,n,i){var s,a,o=8*i-n-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?i-1:0,p=r?-1:1,f=t[e+h];for(h+=p,s=f&(1<<-c)-1,f>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=n;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,n),s-=u;}return (f?-1:1)*a*Math.pow(2,s-n)},Fu.write=function(t,e,r,n,i,s){var a,o,l,u=8*s-i-1,c=(1<<u)-1,h=c>>1,p=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=n?0:s-1,d=n?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,i),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;t[r+f]=255&o,f+=d,o/=256,i-=8);for(a=a<<i|o,u+=i;u>0;t[r+f]=255&a,f+=d,a/=256,u-=8);t[r+f-d]|=128*y;}),Fu}function Lu(){if(Eu)return Vu;Eu=1,Vu=e;var t=$u();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var r=4294967296,n=1/r,i="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function s(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function a(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function o(t,e,r){var n=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(n);for(var i=r.pos-1;i>=t;i--)r.buf[i+n]=r.buf[i];}function l(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function u(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function c(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function h(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function p(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function f(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function d(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function y(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function m(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function g(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function x(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function v(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var n=this.readVarint(),i=n>>3,s=this.pos;this.type=7&n,t(i,e,this),this.pos===s&&this.skip(n);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=v(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*r;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+v(this.buf,this.pos+4)*r;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,r,n=this.buf;return e=127&(r=n[this.pos++]),r<128?e:(e|=(127&(r=n[this.pos++]))<<7,r<128?e:(e|=(127&(r=n[this.pos++]))<<14,r<128?e:(e|=(127&(r=n[this.pos++]))<<21,r<128?e:function(t,e,r){var n,i,s=r.buf;if(n=(112&(i=s[r.pos++]))>>4,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<3,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<10,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<17,i<128)return a(t,n,e);if(n|=(127&(i=s[r.pos++]))<<24,i<128)return a(t,n,e);if(n|=(1&(i=s[r.pos++]))<<31,i<128)return a(t,n,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=n[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&i?function(t,e,r){return i.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var n="",i=e;i<r;){var s,a,o,l=t[i],u=null,c=l>239?4:l>223?3:l>191?2:1;if(i+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[i+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[i+2],128==(192&(s=t[i+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[i+2],o=t[i+3],128==(192&(s=t[i+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,n+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),n+=String.fromCharCode(u),i+=c;}return n}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,r){if(this.type!==e.Bytes)return t.push(this.readVarint(r));var n=s(this);for(t=t||[];this.pos<n;)t.push(this.readVarint(r));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readSFixed64());return t},skip:function(t){var r=7&t;if(r===e.Varint)for(;this.buf[this.pos++]>127;);else if(r===e.Bytes)this.pos=this.readVarint()+this.pos;else if(r===e.Fixed32)this.pos+=4;else {if(r!==e.Fixed64)throw new Error("Unimplemented type: "+r);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),x(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),x(this.buf,-1&t,this.pos),x(this.buf,Math.floor(t*n),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,n;if(t>=0?(r=t%4294967296|0,n=t/4294967296|0):(n=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,n=n+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(n,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var n,i,s=0;s<e.length;s++){if((n=e.charCodeAt(s))>55295&&n<57344){if(!i){n>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):i=n;continue}if(n<56320){t[r++]=239,t[r++]=191,t[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(t[r++]=239,t[r++]=191,t[r++]=189,i=null);n<128?t[r++]=n:(n<2048?t[r++]=n>>6|192:(n<65536?t[r++]=n>>12|224:(t[r++]=n>>18|240,t[r++]=n>>12&63|128),t[r++]=n>>6&63|128),t[r++]=63&n|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&o(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var n=this.pos-r;n>=128&&o(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;},writeMessage:function(t,r,n){this.writeTag(t,e.Bytes),this.writeRawMessage(r,n);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,u,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,c,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,h,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,f,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,d,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,y,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,m,e);},writeBytesField:function(t,r){this.writeTag(t,e.Bytes),this.writeBytes(r);},writeFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeFixed32(r);},writeSFixed32Field:function(t,r){this.writeTag(t,e.Fixed32),this.writeSFixed32(r);},writeFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeFixed64(r);},writeSFixed64Field:function(t,r){this.writeTag(t,e.Fixed64),this.writeSFixed64(r);},writeVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeVarint(r);},writeSVarintField:function(t,r){this.writeTag(t,e.Varint),this.writeSVarint(r);},writeStringField:function(t,r){this.writeTag(t,e.Bytes),this.writeString(r);},writeFloatField:function(t,r){this.writeTag(t,e.Fixed32),this.writeFloat(r);},writeDoubleField:function(t,r){this.writeTag(t,e.Fixed64),this.writeDouble(r);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}},Vu}var Ou=r(Lu());const Du=3;function Ru(t,e,r){1===t&&r.readMessage(ju,e);}function ju(t,e,r){if(3===t){const{id:t,bitmap:n,width:i,height:s,left:a,top:o,advance:l}=r.readMessage(Nu,{});e.push({id:t,bitmap:new Oo({width:i+2*Du,height:s+2*Du},n),metrics:{width:i,height:s,left:a,top:o,advance:l}});}}function Nu(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}const Uu=Du;function qu(t){let e=0,r=0;for(const n of t)e+=n.w*n.h,r=Math.max(r,n.w);t.sort(((t,e)=>e.h-t.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let i=0,s=0;for(const e of t)for(let t=n.length-1;t>=0;t--){const r=n[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),i=Math.max(i,e.x+e.w),e.w===r.w&&e.h===r.h){const e=n.pop();t<n.length&&(n[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(n.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:i,h:s,fill:e/(i*s)||0}}const Gu=1;class Zu{constructor(t,{pixelRatio:e,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:a,textFitHeight:o}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=a,this.textFitHeight=o;}get tl(){return [this.paddedRect.x+Gu,this.paddedRect.y+Gu]}get br(){return [this.paddedRect.x+this.paddedRect.w-Gu,this.paddedRect.y+this.paddedRect.h-Gu]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2*Gu)/this.pixelRatio,(this.paddedRect.h-2*Gu)/this.pixelRatio]}}class Xu{constructor(t,e){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(t,r,i),this.addImages(e,n,i);const{w:s,h:a}=qu(i),o=new Do({width:s||1,height:a||1});for(const e in t){const n=t[e],i=r[e].paddedRect;Do.copy(n.data,o,{x:0,y:0},{x:i.x+Gu,y:i.y+Gu},n.data);}for(const t in e){const r=e[t],i=n[t].paddedRect,s=i.x+Gu,a=i.y+Gu,l=r.data.width,u=r.data.height;Do.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),Do.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),Do.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),Do.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),Do.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=n;}addImages(t,e,r){for(const n in t){const i=t[n],s={x:0,y:0,w:i.data.width+2*Gu,h:i.data.height+2*Gu};r.push(s),e[n]=new Zu(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[n,i]=t.tl;r.update(e.data,void 0,{x:n,y:i});}}var Ku;Ui("ImagePosition",Zu),Ui("ImageAtlas",Xu),t.ai=void 0,(Ku=t.ai||(t.ai={}))[Ku.none=0]="none",Ku[Ku.horizontal=1]="horizontal",Ku[Ku.vertical=2]="vertical",Ku[Ku.horizontalOnly=3]="horizontalOnly";const Hu=-17;class Yu{constructor(){this.scale=1,this.fontStack="",this.imageName=null,this.verticalAlign="bottom";}static forText(t,e,r){const n=new Yu;return n.scale=t||1,n.fontStack=e,n.verticalAlign=r||"bottom",n}static forImage(t,e){const r=new Yu;return r.imageName=t,r.verticalAlign=e||"bottom",r}}class Ju{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Ju;for(let n=0;n<t.sections.length;n++){const i=t.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const n=t.charCodeAt(r+1)||null,i=t.charCodeAt(r-1)||null;e+=n&&is(n)&&!Cu[t[r+1]]||i&&is(i)&&!Cu[t[r-1]]||!Cu[t[r]]?t[r]:Cu[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&Qu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Qu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Ju;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((t,e)=>Math.max(t,this.sections[e].scale)),0)}getMaxImageSize(t){let e=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if(i.imageName){const n=t[i.imageName];if(!n)continue;const s=n.displaySize;e=Math.max(e,s[0]),r=Math.max(r,s[1]);}}return {maxImageWidth:e,maxImageHeight:r}}addTextSection(t,e){this.text+=t.text,this.sections.push(Yu.forText(t.scale,t.fontStack||e,t.verticalAlign));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void j("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Yu.forImage(e,t.verticalAlign)),this.sectionIndex.push(this.sections.length-1)):j("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Wu(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y){const m=Ju.fromFeature(e,s);let g;p===t.ai.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=us;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),oc(m,c,a,r,i,d));for(const e of t){const t=new Ju;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,oc(m,c,a,r,i,d));for(const e of t){const t=new Ju;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],n=t.text;let i=0;for(const n of e)r.push(t.substring(i,n)),i=n;return i<n.length&&r.push(t.substring(i,n.length)),r}(m,oc(m,c,a,r,i,d));const b=[],w={positionedLines:b,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(t,e,r,n,i,s,a,o,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===o?1:"left"===o?0:.5,g=Tu/h;let x=0;for(const a of i){a.trim();const i=a.getMaxScale(),o={positionedGlyphs:[],lineOffset:0};t.positionedLines[x]=o;const h=o.positionedGlyphs;let v=0;if(!a.length()){f+=s,++x;continue}const b=uc(n,a,g);for(let s=0;s<a.length();s++){const o=a.getSection(s),d=a.getSectionIndex(s),y=a.getCharCode(s),m=hc(l,c,y);let x;if(o.imageName){if(t.iconsInText=!0,o.scale=o.scale*g,x=fc(o,m,i,b,n),!x)continue;v=Math.max(v,x.imageOffset);}else if(x=pc(o,y,m,b,e,r),!x)continue;const{rect:w,metrics:_,baselineOffset:S}=x;h.push({glyph:y,imageName:o.imageName,x:p,y:f+S+Hu,vertical:m,scale:o.scale,fontStack:o.fontStack,sectionIndex:d,metrics:_,rect:w}),m?(t.verticalizable=!0,p+=(o.imageName?_.advance:Tu)*o.scale+u):p+=_.advance*o.scale+u;}0!==h.length&&(d=Math.max(p-u,d),dc(h,0,h.length-1,m)),p=0,o.lineOffset=Math.max(v,(i-1)*Tu);const w=s*i+v;f+=w,y=Math.max(w,y),++x;}const{horizontalAlign:v,verticalAlign:b}=lc(a);((function(t,e,r,n,i,s,a,o,l){const u=(e-r)*i;let c=0;c=s!==a?-o*n-Hu:-n*l*a+.5*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;}))(t.positionedLines,m,v,b,d,y,s,f,i.length),t.top+=-b*f,t.bottom=t.top+f,t.left+=-v*d,t.right=t.left+d;}(w,r,n,i,g,o,l,u,p,c,f,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const Qu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},tc={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},ec={40:!0};function rc(t,e,r,n,i,s){if(e.imageName){const t=n[e.imageName];return t?t.displaySize[0]*e.scale*Tu/s+i:0}{const n=r[e.fontStack],s=n&&n[t];return s?s.metrics.advance*e.scale+i:0}}function nc(t,e,r,n){const i=Math.pow(t-e,2);return n?t<e?i/2:2*i:i+Math.abs(r)*r}function ic(t,e,r){let n=0;return 10===t&&(n-=1e4),r&&(n+=150),40!==t&&65288!==t||(n+=50),41!==e&&65289!==e||(n+=50),n}function sc(t,e,r,n,i,s){let a=null,o=nc(e,r,i,s);for(const t of n){const n=nc(e-t.x,r,i,s)+t.badness;n<=o&&(a=t,o=n);}return {index:t,x:e,priorBreak:a,badness:o}}function ac(t){return t?ac(t.priorBreak).concat(t.index):[]}function oc(t,e,r,n,i,s){if(!t)return [];const a=[],o=function(t,e,r,n,i,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=rc(t.getCharCode(r),o,n,i,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,n,i,s),l=t.text.indexOf("​")>=0;let u=0;for(let r=0;r<t.length();r++){const h=t.getSection(r),p=t.getCharCode(r);if(Qu[p]||(u+=rc(p,h,n,i,e,s)),r<t.length()-1){const e=!((c=p)<11904)&&(!!Yi["CJK Compatibility Forms"](c)||!!Yi["CJK Compatibility"](c)||!!Yi["CJK Strokes"](c)||!!Yi["CJK Symbols and Punctuation"](c)||!!Yi["Enclosed CJK Letters and Months"](c)||!!Yi["Halfwidth and Fullwidth Forms"](c)||!!Yi["Ideographic Description Characters"](c)||!!Yi["Vertical Forms"](c)||rs.test(String.fromCodePoint(c)));(tc[p]||e||h.imageName||r!==t.length()-2&&ec[t.getCharCode(r+1)])&&a.push(sc(r+1,u,o,a,ic(p,t.getCharCode(r+1),e&&l),!1));}}var c;return ac(sc(t.length(),u,o,a,0,!0))}function lc(t){let e=.5,r=.5;switch(t){case "right":case "top-right":case "bottom-right":e=1;break;case "left":case "top-left":case "bottom-left":e=0;}switch(t){case "bottom":case "bottom-right":case "bottom-left":r=1;break;case "top":case "top-right":case "top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function uc(t,e,r){const n=e.getMaxScale()*Tu,{maxImageWidth:i,maxImageHeight:s}=e.getMaxImageSize(t),a=Math.max(n,s*r);return {verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:a}}function cc(t){switch(t){case "top":return 0;case "center":return .5;default:return 1}}function hc(e,r,n){return !(e===t.ai.horizontal||!r&&!ns(n)||r&&(Qu[n]||(i=n,/\p{sc=Arab}/u.test(String.fromCodePoint(i)))));var i;}function pc(t,e,r,n,i,s){const a=s[t.fontStack],o=function(t,e,r,n){if(t&&t.rect)return t;const i=e[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(a&&a[e],i,t,e);if(null===o)return null;let l;if(r)l=n.verticalLineContentWidth-t.scale*Tu;else {const e=cc(t.verticalAlign);l=(n.horizontalLineContentHeight-t.scale*Tu)*e;}return {rect:o.rect,metrics:o.metrics,baselineOffset:l}}function fc(t,e,r,n,i){const s=i[t.imageName];if(!s)return null;const a=s.paddedRect,o=s.displaySize,l={width:o[0],height:o[1],left:Gu,top:-3,advance:e?o[1]:o[0]};let u;if(e)u=n.verticalLineContentWidth-o[1]*t.scale;else {const e=cc(t.verticalAlign);u=(n.horizontalLineContentHeight-o[1]*t.scale)*e;}return {rect:a,metrics:l,baselineOffset:u,imageOffset:(e?o[0]:o[1])*t.scale-Tu*r}}function dc(t,e,r,n){if(0===n)return;const i=t[r],s=(t[r].x+i.metrics.advance*i.scale)*n;for(let n=e;n<=r;n++)t[n].x-=s;}function yc(t,e,r){const{horizontalAlign:n,verticalAlign:i}=lc(r),s=e[0]-t.displaySize[0]*n,a=e[1]-t.displaySize[1]*i;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function mc(t){var e,r;let n=t.left,i=t.top,s=t.right-n,a=t.bottom-i;const o=null!==(e=t.image.textFitWidth)&&void 0!==e?e:"stretchOrShrink",l=null!==(r=t.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(t.image.content[2]-t.image.content[0])/(t.image.content[3]-t.image.content[1]);if("proportional"===l){if("stretchOnly"===o&&s/a<u||"proportional"===o){const t=Math.ceil(a*u);n*=t/s,s=t;}}else if("proportional"===o&&"stretchOnly"===l&&0!==u&&s/a>u){const t=Math.ceil(s/u);i*=t/a,a=t;}return {x1:n,y1:i,x2:n+s,y2:i+a}}function gc(t,e,r,n,i,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-a.displaySize[0])/2,h=f+a.displaySize[0]);const d=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:f,collisionPadding:o}}const xc=255,vc=128,bc=xc*vc;function wc(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new cs(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:n}=r;let i=0;for(;i<e.length&&e[i]<=t;)i++;i=Math.max(0,i-1);let s=i;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[i],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:n}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new cs(a)),maxSize:r.evaluate(new cs(o)),interpolationType:n}}}function _c(t,e,r){let n="never";const i=t.get(e);return i?n=i:t.get(r)&&(n="always"),n}const Sc=Yl.VectorTileFeature.types,Ac=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function kc(t,e,r,n,i,s,a,o,l,u,c,h,p){const f=o?Math.min(bc,Math.round(o[0])):0,d=o?Math.min(bc,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*n),Math.round(32*i),s,a,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function Mc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Ic(t){for(const e of t.sections)if(ls(e.text))return !0;return !1}class zc{constructor(t){this.layoutVertexArray=new ba,this.indexArray=new ka,this.programConfigurations=t,this.segments=new Pa,this.dynamicLayoutVertexArray=new wa,this.opacityVertexArray=new _a,this.hasVisibleVertices=!1,this.placedSymbolArray=new ia;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Au.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,ku.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Ac,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}Ui("SymbolBuffers",zc);class Pc{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new Pa,this.collisionVertexArray=new Aa;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Mu.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}Ui("CollisionBuffers",Pc);class Cc{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=wc(this.zoom,r["text-size"]),this.iconSizeData=wc(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==_c(n,"text-overlap","text-allow-overlap")||"never"!==_c(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((e=>t.ai[e]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=e.sourceID;}createArrays(){this.text=new zc(new ro(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new zc(new ro(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new oa,this.lineVertexArray=new la,this.symbolInstances=new aa,this.textAnchorOffsets=new ca;}calculateGlyphDependencies(t,e,r,n,i){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||n)&&i){const r=Cu[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(e,r,n){const i=this.layers[0],s=i.layout,a=s.get("text-font"),o=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==o.value.kind||o.value.value instanceof ve&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new cs(this.zoom);for(const{feature:r,id:o,index:l,sourceLayerIndex:m}of e){const e=i._featureFilter.needGeometry,g=lo(r,e);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(e||(g.geometry=oo(r)),u){const t=i.getValueAndResolveTokens("text-field",g,n,d),e=ve.factory(t),r=this.hasRTLText=this.hasRTLText||Ic(e);(!r||"unavailable"===us.getRTLTextPluginStatus()||r&&us.isParsed())&&(x=Pu(e,i,g));}if(c){const t=i.getValueAndResolveTokens("icon-image",g,n,d);v=t instanceof Ae?t:Ae.fromString(t);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:o,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:Sc[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(t.ai.vertical)>=0;for(const t of x.sections)if(t.image)p[t.image.name]=!0;else {const n=Ji(x.toString()),i=t.fontStack||e,s=f[i]=f[i]||{};this.calculateGlyphDependencies(t.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(t){const e={},r={},n=[];let i=0;function s(e){n.push(t[e]),i++;}function a(t,e,i){const s=r[t];return delete r[t],r[e]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function o(t,r,i){const s=e[r];return delete e[r],e[t]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(t,e,r){const n=r?e[0][e[0].length-1]:e[0][0];return `${t}:${n.x}:${n.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in e&&r[f]!==e[d]){const t=o(f,d,h),i=a(f,d,n[t].geometry);delete e[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[t].geometry=null;}else f in r?a(f,d,h):d in e?o(f,d,h):(s(u),e[f]=i-1,r[d]=i-1);}return n.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey));}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),n=t.dist(e[t.segment]);const i={};for(let n=t.segment+1;n<e.length;n++)i[n]={x:e[n].x,y:e[n].y,tileUnitDistanceFromAnchor:r},n<e.length-1&&(r+=e[n+1].dist(e[n]));for(let r=t.segment||0;r>=0;r--)i[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=i[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(e,r,n,i,s,a,o,l,u,c,h,p){const f=e.indexArray,d=e.layoutVertexArray,y=e.segments.prepareSegment(4*r.length,d,f,this.canOverlap?a.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&o===t.ai.vertical?Math.PI/2:0,v=a.text&&a.text.sections;for(let t=0;t<r.length;t++){const{tl:i,tr:s,bl:o,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=r[t],A=y.vertexLength,k=w[1];kc(d,l.x,l.y,i.x,k+i.y,c.x,c.y,n,_,h.x,h.y,g,b),kc(d,l.x,l.y,s.x,k+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),kc(d,l.x,l.y,o.x,k+o.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),kc(d,l.x,l.y,u.x,k+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),Mc(e.dynamicLayoutVertexArray,l,x),f.emplaceBack(A,A+2,A+1),f.emplaceBack(A+1,A+2,A+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),t!==r.length-1&&S===r[t+1].sectionIndex||e.programConfigurations.populatePaintArrays(d.length,a,a.index,{},p,v&&v[S]);}e.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],o,0,!1,0,h);}_addCollisionDebugVertex(t,e,r,n,i,s){return e.emplaceBack(0,0),t.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,r,n,i,s,a){const o=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),u=o.vertexLength,c=i.layoutVertexArray,h=i.collisionVertexArray,p=a.anchorX,f=a.anchorY;this._addCollisionDebugVertex(c,h,s,p,f,new l(t,e)),this._addCollisionDebugVertex(c,h,s,p,f,new l(r,e)),this._addCollisionDebugVertex(c,h,s,p,f,new l(r,n)),this._addCollisionDebugVertex(c,h,s,p,f,new l(t,n)),o.vertexLength+=4;const d=i.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),o.primitiveLength+=4;}addDebugCollisionBoxes(t,e,r,n){for(let i=t;i<e;i++){const t=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,n?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Pc(Sa,Iu.members,Ma),this.iconCollisionBox=new Pc(Sa,Iu.members,Ma);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1);}}_deserializeCollisionBoxesForSymbol(t,e,r,n,i,s,a,o,l){const u={};for(let n=e;n<r;n++){const e=t.get(n);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=n;e<i;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),n=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<n;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),n=[],i=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);n.push(0|Math.round(e*a.anchorX+r*a.anchorY)),i.push(a.featureIndex);}return s.sort(((t,e)=>n[t]-n[e]||i[e]-i[t])),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let Bc,Vc;Ui("SymbolBucket",Cc,{omit:["layers","collisionBoxArray","features","compareText"]}),Cc.MAX_GLYPHS=65535,Cc.addDynamicAttributes=Mc;var Ec={get paint(){return Vc=Vc||new As({"icon-opacity":new bs(ht.paint_symbol["icon-opacity"]),"icon-color":new bs(ht.paint_symbol["icon-color"]),"icon-halo-color":new bs(ht.paint_symbol["icon-halo-color"]),"icon-halo-width":new bs(ht.paint_symbol["icon-halo-width"]),"icon-halo-blur":new bs(ht.paint_symbol["icon-halo-blur"]),"icon-translate":new vs(ht.paint_symbol["icon-translate"]),"icon-translate-anchor":new vs(ht.paint_symbol["icon-translate-anchor"]),"text-opacity":new bs(ht.paint_symbol["text-opacity"]),"text-color":new bs(ht.paint_symbol["text-color"],{runtimeType:Bt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new bs(ht.paint_symbol["text-halo-color"]),"text-halo-width":new bs(ht.paint_symbol["text-halo-width"]),"text-halo-blur":new bs(ht.paint_symbol["text-halo-blur"]),"text-translate":new vs(ht.paint_symbol["text-translate"]),"text-translate-anchor":new vs(ht.paint_symbol["text-translate-anchor"])})},get layout(){return Bc=Bc||new As({"symbol-placement":new vs(ht.layout_symbol["symbol-placement"]),"symbol-spacing":new vs(ht.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new vs(ht.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new bs(ht.layout_symbol["symbol-sort-key"]),"symbol-z-order":new vs(ht.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new vs(ht.layout_symbol["icon-allow-overlap"]),"icon-overlap":new vs(ht.layout_symbol["icon-overlap"]),"icon-ignore-placement":new vs(ht.layout_symbol["icon-ignore-placement"]),"icon-optional":new vs(ht.layout_symbol["icon-optional"]),"icon-rotation-alignment":new vs(ht.layout_symbol["icon-rotation-alignment"]),"icon-size":new bs(ht.layout_symbol["icon-size"]),"icon-text-fit":new vs(ht.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new vs(ht.layout_symbol["icon-text-fit-padding"]),"icon-image":new bs(ht.layout_symbol["icon-image"]),"icon-rotate":new bs(ht.layout_symbol["icon-rotate"]),"icon-padding":new bs(ht.layout_symbol["icon-padding"]),"icon-keep-upright":new vs(ht.layout_symbol["icon-keep-upright"]),"icon-offset":new bs(ht.layout_symbol["icon-offset"]),"icon-anchor":new bs(ht.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new vs(ht.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new vs(ht.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new vs(ht.layout_symbol["text-rotation-alignment"]),"text-field":new bs(ht.layout_symbol["text-field"]),"text-font":new bs(ht.layout_symbol["text-font"]),"text-size":new bs(ht.layout_symbol["text-size"]),"text-max-width":new bs(ht.layout_symbol["text-max-width"]),"text-line-height":new vs(ht.layout_symbol["text-line-height"]),"text-letter-spacing":new bs(ht.layout_symbol["text-letter-spacing"]),"text-justify":new bs(ht.layout_symbol["text-justify"]),"text-radial-offset":new bs(ht.layout_symbol["text-radial-offset"]),"text-variable-anchor":new vs(ht.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new bs(ht.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new bs(ht.layout_symbol["text-anchor"]),"text-max-angle":new vs(ht.layout_symbol["text-max-angle"]),"text-writing-mode":new vs(ht.layout_symbol["text-writing-mode"]),"text-rotate":new bs(ht.layout_symbol["text-rotate"]),"text-padding":new vs(ht.layout_symbol["text-padding"]),"text-keep-upright":new vs(ht.layout_symbol["text-keep-upright"]),"text-transform":new bs(ht.layout_symbol["text-transform"]),"text-offset":new bs(ht.layout_symbol["text-offset"]),"text-allow-overlap":new vs(ht.layout_symbol["text-allow-overlap"]),"text-overlap":new vs(ht.layout_symbol["text-overlap"]),"text-ignore-placement":new vs(ht.layout_symbol["text-ignore-placement"]),"text-optional":new vs(ht.layout_symbol["text-optional"])})}};class Tc{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:It,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Ui("FormatSectionOverride",Tc,{omit:["defaultValue"]});class Fc extends Ms{constructor(t){super(t,Ec);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,n){const i=this.layout.get(t).evaluate(e,{},r,n),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||jn(s.value)||!i?i:function(t,e){return e.replace(/{([^{}]+)}/g,((e,r)=>t&&r in t?String(t[r]):""))}(e.properties,i)}createBucket(t){return new Cc(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of Ec.paint.overridableProperties){if(!Fc.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Tc(e),n=new Rn(r,e.property.specification);let i=null;i="constant"===e.value.kind||"source"===e.value.kind?new Un("source",n):new qn("composite",n,e.value.zoomStops),this.paint._values[t]=new gs(e.property,i,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Fc.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),n=Ec.paint.properties[e];let i=!1;const s=t=>{for(const e of t)if(n.overrides&&n.overrides.hasOverride(e))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof ve)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{i||(e instanceof Ce&&ze(e.value)===$t?s(e.value.sections):e instanceof dr?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return i}}let $c;var Lc={get paint(){return $c=$c||new As({"background-color":new vs(ht.paint_background["background-color"]),"background-pattern":new _s(ht.paint_background["background-pattern"]),"background-opacity":new vs(ht.paint_background["background-opacity"])})}};class Oc extends Ms{constructor(t){super(t,Lc);}}let Dc;var Rc={get paint(){return Dc=Dc||new As({"raster-opacity":new vs(ht.paint_raster["raster-opacity"]),"raster-hue-rotate":new vs(ht.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new vs(ht.paint_raster["raster-brightness-min"]),"raster-brightness-max":new vs(ht.paint_raster["raster-brightness-max"]),"raster-saturation":new vs(ht.paint_raster["raster-saturation"]),"raster-contrast":new vs(ht.paint_raster["raster-contrast"]),"raster-resampling":new vs(ht.paint_raster["raster-resampling"]),"raster-fade-duration":new vs(ht.paint_raster["raster-fade-duration"])})}};class jc extends Ms{constructor(t){super(t,Rc);}}class Nc extends Ms{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);},this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}class Uc{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle();}),0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const qc=6371008.8;class Gc{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new Gc(T(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,n=t.lat*e,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((t.lng-this.lng)*e);return qc*Math.acos(Math.min(i,1))}static convert(t){if(t instanceof Gc)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new Gc(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new Gc(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const Zc=2*Math.PI*qc;function Xc(t){return Zc*Math.cos(t*Math.PI/180)}function Kc(t){return (180+t)/360}function Hc(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function Yc(t,e){return t/Xc(e)}function Jc(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function Wc(t,e){return t*Xc(Jc(e))}class Qc{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=Gc.convert(t);return new Qc(Kc(r.lng),Hc(r.lat),Yc(e,r.lat))}toLngLat(){return new Gc(360*this.x-180,Jc(this.y))}toAltitude(){return Wc(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Zc*(t=Jc(this.y),1/Math.cos(t*Math.PI/180));var t;}}function th(t,e,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [t*n-2*Math.PI*6378137/2,e*n-2*Math.PI*6378137/2]}class eh{constructor(t,e,r){if(!function(t,e,r){return !(t<0||t>25||r<0||r>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,r))throw new Error(`x=${e}, y=${r}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=r,this.key=ih(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,r){const n=(s=this.y,a=this.z,o=th(256*(i=this.x),256*(s=Math.pow(2,a)-s-1),a),l=th(256*(i+1),256*(s+1),a),o[0]+","+o[1]+","+l[0]+","+l[1]);var i,s,a,o,l;const u=function(t,e,r){let n,i="";for(let s=t;s>0;s--)n=1<<s-1,i+=(e&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new l((t.x*e-this.x)*M,(t.y*e-this.y)*M)}toString(){return `${this.z}/${this.x}/${this.y}`}}class rh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=ih(t,e.z,e.z,e.x,e.y);}}class nh{constructor(t,e,r,n,i){if(this.terrainRttPosMatrix32f=null,t<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${r}`);this.overscaledZ=t,this.wrap=e,this.canonical=new eh(r,+n,+i),this.key=ih(e,t,r,n,i);}clone(){return new nh(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new nh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new nh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-t;return t>this.canonical.z?ih(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):ih(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new nh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new nh(e,this.wrap,e,r,n),new nh(e,this.wrap,e,r+1,n),new nh(e,this.wrap,e,r,n+1),new nh(e,this.wrap,e,r+1,n+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new nh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new nh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new rh(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new Qc(t.x-this.wrap,t.y))}}function ih(t,e,r,n,i){(t*=2)<0&&(t=-1*t-1);const s=1<<r;return (s*s*t+s*i+n).toString(36)+r.toString(36)+e.toString(36)}Ui("CanonicalTileID",eh),Ui("OverscaledTileID",nh,{omit:["terrainRttPosMatrix32f"]});class sh{constructor(t,e,r,n=1,i=1,s=1,a=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void j(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const o=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),r){case "terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case "custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=a;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let t=0;t<o;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(o,t)]=this.data[this._idx(o-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,o)]=this.data[this._idx(t,o-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(o,-1)]=this.data[this._idx(o-1,0)],this.data[this._idx(-1,o)]=this.data[this._idx(0,o-1)],this.data[this._idx(o,o)]=this.data[this._idx(o-1,o-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<o;t++)for(let e=0;e<o;e++){const r=this.get(t,e);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(t,e){const r=new Uint8Array(this.data.buffer),n=4*this._idx(t,e);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return [this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}unpack(t,e,r){return t*this.redFactor+e*this.greenFactor+r*this.blueFactor-this.baseShift}getPixels(){return new Do({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let n=e*this.dim,i=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case -1:n=i-1;break;case 1:i=n+1;}switch(r){case -1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=n;r<i;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}}Ui("DEMData",sh);class ah{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class oh{constructor(t,e,r,n,i){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=n,this.properties=t.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}class lh{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new ji(M,16,0),this.grid3D=new ji(M,16,0),this.featureIndexArray=new pa,this.promoteId=e;}insert(t,e,r,n,i,s){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const o=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const r=e[t],n=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];n[0]=Math.min(n[0],e.x),n[1]=Math.min(n[1],e.y),n[2]=Math.max(n[2],e.x),n[3]=Math.max(n[3],e.y);}n[0]<M&&n[1]<M&&n[2]>=0&&n[3]>=0&&o.insert(a,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Yl.VectorTile(new Ou(this.rawTileData)).layers,this.sourceLayerCoder=new ah(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,n){this.loadVTLayers();const i=t.params,s=M/t.tileSize/t.scale,a=Yn(i.filter),o=t.queryGeometry,u=t.queryPadding*s,c=ch(o),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=ch(t.cameraQueryGeometry),f=this.grid3D.query(p.minX-u,p.minY-u,p.maxX+u,p.maxY+u,((e,r,n,i)=>function(t,e,r,n,i){for(const s of t)if(e<=s.x&&r<=s.y&&n>=s.x&&i>=s.y)return !0;const s=[new l(e,r),new l(e,i),new l(n,i),new l(n,r)];if(t.length>2)for(const e of s)if(_o(t,e))return !0;for(let e=0;e<t.length-1;e++)if(So(t[e],t[e+1],s))return !0;return !1}(t.cameraQueryGeometry,e-u,r-u,n+u,i+u)));for(const t of f)h.push(t);h.sort(hh);const d={};let y;for(let l=0;l<h.length;l++){const u=h[l];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,a,i.layers,i.availableImages,e,r,n,((e,r,n)=>(p||(p=oo(e)),r.queryIntersectsFeature({queryGeometry:o,feature:e,featureState:n,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:s,pixelPosMatrix:t.pixelPosMatrix}))));}return d}loadMatchingFeature(t,e,r,n,i,s,a,o,l,u,c){const h=this.bucketLayerIDs[e];if(s&&!h.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const t=lo(f,!0);if(!i.filter(new cs(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!i.filter(new cs(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let e=0;e<h.length;e++){const r=h[e];if(s&&!s.has(r))continue;const i=o[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||"_geojsonTileLayer",d));const y=F({},l[r]);y.paint=uh(y.paint,i.paint,f,p,a),y.layout=uh(y.layout,i.layout,f,p,a);const m=!c||c(f,i,p);if(!m)continue;const g=new oh(f,this.z,this.x,this.y,d);g.layer=y;let x=t[r];void 0===x&&(x=t[r]=[]),x.push({featureIndex:n,feature:g,intersectionZ:m});}}lookupSymbolFeatures(t,e,r,n,i,s,a,o){const l={};this.loadVTLayers();const u=Yn(i);for(const i of t)this.loadMatchingFeature(l,r,n,i,u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){var r;let n=t.id;return this.promoteId&&(n=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=t.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(t.properties.cluster_id))),n}}function uh(t,e,r,n,i){return L(t,((t,s)=>{const a=e instanceof xs?e.get(s):null;return a&&a.evaluate?a.evaluate(r,n,i):a}))}function ch(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return {minX:e,minY:r,maxX:n,maxY:i}}function hh(t,e){return e-t}function ph(t,e,r,n,i){const s=[];for(let a=0;a<t.length;a++){const o=t[a];let u;for(let t=0;t<o.length-1;t++){let a=o[t],c=o[t+1];a.x<e&&c.x<e||(a.x<e?a=new l(e,a.y+(e-a.x)/(c.x-a.x)*(c.y-a.y))._round():c.x<e&&(c=new l(e,a.y+(e-a.x)/(c.x-a.x)*(c.y-a.y))._round()),a.y<r&&c.y<r||(a.y<r?a=new l(a.x+(r-a.y)/(c.y-a.y)*(c.x-a.x),r)._round():c.y<r&&(c=new l(a.x+(r-a.y)/(c.y-a.y)*(c.x-a.x),r)._round()),a.x>=n&&c.x>=n||(a.x>=n?a=new l(n,a.y+(n-a.x)/(c.x-a.x)*(c.y-a.y))._round():c.x>=n&&(c=new l(n,a.y+(n-a.x)/(c.x-a.x)*(c.y-a.y))._round()),a.y>=i&&c.y>=i||(a.y>=i?a=new l(a.x+(i-a.y)/(c.y-a.y)*(c.x-a.x),i)._round():c.y>=i&&(c=new l(a.x+(i-a.y)/(c.y-a.y)*(c.x-a.x),i)._round()),u&&a.equals(u[u.length-1])||(u=[a],s.push(u)),u.push(c)))));}}return s}Ui("FeatureIndex",lh,{omit:["rawTileData","sourceLayerCoder"]});class fh extends l{constructor(t,e,r,n){super(t,e),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new fh(this.x,this.y,this.angle,this.segment)}}function dh(t,e,r,n,i){if(void 0===e.segment||0===r)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;a++,o+=e.dist(r);}return !0}function yh(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function mh(t,e,r){return t?.6*e*r:0}function gh(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function xh(t,e,r,n,i,s){const a=mh(r,i,s),o=gh(r,n)*s;let l=0;const u=yh(t)/2;for(let r=0;r<t.length-1;r++){const n=t[r],i=t[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=er.number(n.x,i.x,c),p=er.number(n.y,i.y,c),f=new fh(h,p,i.angleTo(n),r);return f._round(),!a||dh(t,f,o,a,e)?f:void 0}l+=s;}}function vh(t,e,r,n,i,s,a,o,l){const u=mh(n,s,a),c=gh(n,i),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),bh(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function bh(t,e,r,n,i,s,a,o,l){const u=s/2,c=yh(t);let h=0,p=e-r,f=[];for(let e=0;e<t.length-1;e++){const a=t[e],o=t[e+1],d=a.dist(o),y=o.angleTo(a);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=er.number(a.x,o.x,m),x=er.number(a.y,o.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new fh(g,x,y,e);r._round(),n&&!dh(t,r,s,n,i)||f.push(r);}}h+=d;}return o||f.length||a||(f=bh(t,h/2,r,n,i,s,a,!0,l)),f}Ui("Anchor",fh);const wh=Gu;function _h(t,e,r,n){const i=[],s=t.image,a=s.pixelRatio,o=s.paddedRect.w-2*wh,u=s.paddedRect.h-2*wh;let c={x1:t.left,y1:t.top,x2:t.right,y2:t.bottom};const h=s.stretchX||[[0,o]],p=s.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],d=h.reduce(f,0),y=p.reduce(f,0),m=o-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,A=0,k=g;if(s.content&&n){const e=s.content,r=e[2]-e[0],n=e[3]-e[1];(s.textFitWidth||s.textFitHeight)&&(c=mc(t)),x=Sh(h,0,e[0]),b=Sh(p,0,e[1]),v=Sh(h,e[0],e[2]),w=Sh(p,e[1],e[3]),_=e[0]-x,A=e[1]-b,S=r-v,k=n-w;}const M=c.x1,I=c.y1,z=c.x2-M,P=c.y2-I,C=(t,n,i,o)=>{const u=kh(t.stretch-x,v,z,M),c=Mh(t.fixed-_,S,t.stretch,d),h=kh(n.stretch-b,w,P,I),p=Mh(n.fixed-A,k,n.stretch,y),f=kh(i.stretch-x,v,z,M),m=Mh(i.fixed-_,S,i.stretch,d),g=kh(o.stretch-b,w,P,I),C=Mh(o.fixed-A,k,o.stretch,y),B=new l(u,h),V=new l(f,h),E=new l(f,g),T=new l(u,g),F=new l(c/a,p/a),$=new l(m/a,C/a),L=e*Math.PI/180;if(L){const t=Math.sin(L),e=Math.cos(L),r=[e,-t,t,e];B._matMult(r),V._matMult(r),T._matMult(r),E._matMult(r);}const O=t.stretch+t.fixed,D=n.stretch+n.fixed;return {tl:B,tr:V,bl:T,br:E,tex:{x:s.paddedRect.x+wh+O,y:s.paddedRect.y+wh+D,w:i.stretch+i.fixed-O,h:o.stretch+o.fixed-D},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:F,pixelOffsetBR:$,minFontScaleX:S/a/z,minFontScaleY:k/a/P,isSDF:r}};if(n&&(s.stretchX||s.stretchY)){const t=Ah(h,m,d),e=Ah(p,g,y);for(let r=0;r<t.length-1;r++){const n=t[r],s=t[r+1];for(let t=0;t<e.length-1;t++)i.push(C(n,e[t],s,e[t+1]));}}else i.push(C({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:o+1},{fixed:0,stretch:u+1}));return i}function Sh(t,e,r){let n=0;for(const i of t)n+=Math.max(e,Math.min(r,i[1]))-Math.max(e,Math.min(r,i[0]));return n}function Ah(t,e,r){const n=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=n[n.length-1];n.push({fixed:e-t.stretch,stretch:t.stretch}),n.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return n.push({fixed:e+wh,stretch:r}),n}function kh(t,e,r,n){return t/e*r+n}function Mh(t,e,r,n){return t-e*r/n}class Ih{constructor(t,e,r,n,i,s,a,o,u,c){var h;if(this.boxStartIndex=t.length,u){let t=s.top,e=s.bottom;const r=s.collisionPadding;r&&(t-=r[1],e+=r[3]);let n=e-t;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else {const u=(null===(h=s.image)||void 0===h?void 0:h.content)&&(s.image.textFitWidth||s.image.textFitHeight)?mc(s):{x1:s.left,y1:s.top,x2:s.right,y2:s.bottom};u.y1=u.y1*a-o[0],u.y2=u.y2*a+o[2],u.x1=u.x1*a-o[3],u.x2=u.x2*a+o[1];const p=s.collisionPadding;if(p&&(u.x1-=p[0]*a,u.y1-=p[1]*a,u.x2+=p[2]*a,u.y2+=p[3]*a),c){const t=new l(u.x1,u.y1),e=new l(u.x2,u.y1),r=new l(u.x1,u.y2),n=new l(u.x2,u.y2),i=c*Math.PI/180;t._rotate(i),e._rotate(i),r._rotate(i),n._rotate(i),u.x1=Math.min(t.x,e.x,r.x,n.x),u.x2=Math.max(t.x,e.x,r.x,n.x),u.y1=Math.min(t.y,e.y,r.y,n.y),u.y2=Math.max(t.y,e.y,r.y,n.y);}t.emplaceBack(e.x,e.y,u.x1,u.y1,u.x2,u.y2,r,n,i);}this.boxEndIndex=t.length;}}class zh{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this._up(this.length++);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return --this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,n=e[t];for(;t>0;){const i=t-1>>1,s=e[i];if(r(n,s)>=0)break;e[t]=s,t=i;}e[t]=n;}_down(t){const{data:e,compare:r}=this,n=this.length>>1,i=e[t];for(;t<n;){let n=1+(t<<1);const s=n+1;if(s<this.length&&r(e[s],e[n])<0&&(n=s),r(e[n],i)>=0)break;e[t]=e[n],t=n;}e[t]=i;}}function Ph(t,e=1,r=!1){let n=1/0,i=1/0,s=-1/0,a=-1/0;const o=t[0];for(let t=0;t<o.length;t++){const e=o[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<i)&&(i=e.y),(!t||e.x>s)&&(s=e.x),(!t||e.y>a)&&(a=e.y);}const u=Math.min(s-n,a-i);let c=u/2;const h=new zh([],Ch);if(0===u)return new l(n,i);for(let e=n;e<s;e+=u)for(let r=i;r<a;r+=u)h.push(new Bh(e+c,r+c,c,t));let p=function(t){let e=0,r=0,n=0;const i=t[0];for(let t=0,s=i.length,a=s-1;t<s;a=t++){const s=i[t],o=i[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,n+=(s.y+o.y)*l,e+=3*l;}return new Bh(r/e,n/e,0,t)}(t),f=h.length;for(;h.length;){const n=h.pop();(n.d>p.d||!p.d)&&(p=n,r&&console.log("found best %d after %d probes",Math.round(1e4*n.d)/1e4,f)),n.max-p.d<=e||(c=n.h/2,h.push(new Bh(n.p.x-c,n.p.y-c,c,t)),h.push(new Bh(n.p.x+c,n.p.y-c,c,t)),h.push(new Bh(n.p.x-c,n.p.y+c,c,t)),h.push(new Bh(n.p.x+c,n.p.y+c,c,t)),f+=4);}return r&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function Ch(t,e){return e.max-t.max}function Bh(t,e,r,n){this.p=new l(t,e),this.h=r,this.d=function(t,e){let r=!1,n=1/0;for(let i=0;i<e.length;i++){const s=e[i];for(let e=0,i=s.length,a=i-1;e<i;a=e++){const i=s[e],o=s[a];i.y>t.y!=o.y>t.y&&t.x<(o.x-i.x)*(t.y-i.y)/(o.y-i.y)+i.x&&(r=!r),n=Math.min(n,bo(t,i,o));}}return (r?1:-1)*Math.sqrt(n)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}var Vh;t.av=void 0,(Vh=t.av||(t.av={}))[Vh.center=1]="center",Vh[Vh.left=2]="left",Vh[Vh.right=3]="right",Vh[Vh.top=4]="top",Vh[Vh.bottom=5]="bottom",Vh[Vh["top-left"]=6]="top-left",Vh[Vh["top-right"]=7]="top-right",Vh[Vh["bottom-left"]=8]="bottom-left",Vh[Vh["bottom-right"]=9]="bottom-right";const Eh=7,Th=Number.POSITIVE_INFINITY;function Fh(t,e){return e[1]!==Th?function(t,e,r){let n=0,i=0;switch(e=Math.abs(e),r=Math.abs(r),t){case "top-right":case "top-left":case "top":i=r-Eh;break;case "bottom-right":case "bottom-left":case "bottom":i=-r+Eh;}switch(t){case "top-right":case "bottom-right":case "right":n=-e;break;case "top-left":case "bottom-left":case "left":n=e;}return [n,i]}(t,e[0],e[1]):function(t,e){let r=0,n=0;e<0&&(e=0);const i=e/Math.SQRT2;switch(t){case "top-right":case "top-left":n=i-Eh;break;case "bottom-right":case "bottom-left":n=-i+Eh;break;case "bottom":n=-e+Eh;break;case "top":n=e-Eh;}switch(t){case "top-right":case "bottom-right":r=-i;break;case "top-left":case "bottom-left":r=i;break;case "left":r=e;break;case "right":r=-e;}return [r,n]}(t,e[0])}function $h(t,e,r){var n;const i=t.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(e,{},r);if(s){const t=s.values,e=[];for(let r=0;r<t.length;r+=2){const n=e[r]=t[r],i=t[r+1].map((t=>t*Tu));n.startsWith("top")?i[1]-=Eh:n.startsWith("bottom")&&(i[1]+=Eh),e[r+1]=i;}return new Se(e)}const a=i.get("text-variable-anchor");if(a){let n;n=void 0!==t._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(e,{},r)*Tu,Th]:i.get("text-offset").evaluate(e,{},r).map((t=>t*Tu));const s=[];for(const t of a)s.push(t,Fh(t,n));return new Se(s)}return null}function Lh(t){switch(t){case "right":case "top-right":case "bottom-right":return "right";case "left":case "top-left":case "bottom-left":return "left"}return "center"}function Oh(e,r,n,i,s,a,o,l,u,c,h,p){let f=a.textMaxSize.evaluate(r,{});void 0===f&&(f=o);const d=e.layers[0].layout,y=d.get("icon-offset").evaluate(r,{},h),m=Rh(n.horizontal),g=o/24,x=e.tilePixelRatio*g,v=e.tilePixelRatio*f/24,b=e.tilePixelRatio*l,w=e.tilePixelRatio*d.get("symbol-spacing"),_=d.get("text-padding")*e.tilePixelRatio,S=function(t,e,r,n=1){const i=t.get("icon-padding").evaluate(e,{},r),s=i&&i.values;return [s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(d,r,h,e.tilePixelRatio),A=d.get("text-max-angle")/180*Math.PI,k="viewport"!==d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),I="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),z=d.get("symbol-placement"),P=w/2,C=d.get("icon-text-fit");let B;i&&"none"!==C&&(e.allowVerticalPlacement&&n.vertical&&(B=gc(i,n.vertical,C,d.get("icon-text-fit-padding"),y,g)),m&&(i=gc(i,m,C,d.get("icon-text-fit-padding"),y,g)));const V=h?p.line.getGranularityForZoomLevel(h.z):1,E=(l,p)=>{p.x<0||p.x>=M||p.y<0||p.y>=M||function(e,r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,k){const M=e.addToLineVertexArray(r,n);let I,z,P,C,B=0,V=0,E=0,T=0,F=-1,$=-1;const L={};let O=Da("");if(e.allowVerticalPlacement&&i.vertical){const t=l.layout.get("text-rotate").evaluate(w,{},A)+90;P=new Ih(u,r,c,h,p,i.vertical,f,d,y,t),o&&(C=new Ih(u,r,c,h,p,o,g,x,y,t));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),a=_h(s,n,S,i),f=o?_h(o,n,S,i):void 0;z=new Ih(u,r,c,h,p,s,g,x,!1,n),B=4*a.length;const d=e.iconSizeData;let y=null;"source"===d.kind?(y=[vc*l.layout.get("icon-size").evaluate(w,{})],y[0]>bc&&j(`${e.layerIds[0]}: Value for "icon-size" is >= ${xc}. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[vc*_.compositeIconSizes[0].evaluate(w,{},A),vc*_.compositeIconSizes[1].evaluate(w,{},A)],(y[0]>bc||y[1]>bc)&&j(`${e.layerIds[0]}: Value for "icon-size" is >= ${xc}. Reduce your "icon-size".`)),e.addSymbols(e.icon,a,y,b,v,w,t.ai.none,r,M.lineStartIndex,M.lineLength,-1,A),F=e.icon.placedSymbolArray.length-1,f&&(V=4*f.length,e.addSymbols(e.icon,f,y,b,v,w,t.ai.vertical,r,M.lineStartIndex,M.lineLength,-1,A),$=e.icon.placedSymbolArray.length-1);}const D=Object.keys(i.horizontal);for(const n of D){const s=i.horizontal[n];if(!I){O=Da(s.text);const t=l.layout.get("text-rotate").evaluate(w,{},A);I=new Ih(u,r,c,h,p,s,f,d,y,t);}const o=1===s.positionedLines.length;if(E+=Dh(e,r,s,a,l,y,w,m,M,i.vertical?t.ai.horizontal:t.ai.horizontalOnly,o?D:[n],L,F,_,A),o)break}i.vertical&&(T+=Dh(e,r,i.vertical,a,l,y,w,m,M,t.ai.vertical,["vertical"],L,$,_,A));const R=I?I.boxStartIndex:e.collisionBoxArray.length,N=I?I.boxEndIndex:e.collisionBoxArray.length,U=P?P.boxStartIndex:e.collisionBoxArray.length,q=P?P.boxEndIndex:e.collisionBoxArray.length,G=z?z.boxStartIndex:e.collisionBoxArray.length,Z=z?z.boxEndIndex:e.collisionBoxArray.length,X=C?C.boxStartIndex:e.collisionBoxArray.length,K=C?C.boxEndIndex:e.collisionBoxArray.length;let H=-1;const Y=(t,e)=>t&&t.circleDiameter?Math.max(t.circleDiameter,e):e;H=Y(I,H),H=Y(P,H),H=Y(z,H),H=Y(C,H);const J=H>-1?1:0;J&&(H*=k/Tu),e.glyphOffsetArray.length>=Cc.MAX_GLYPHS&&j("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&e.addToSortKeyRanges(e.symbolInstances.length,w.sortKey);const W=$h(l,w,A),[Q,tt]=function(e,r){const n=e.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];e.emplaceBack(t.av[i[r]],n[0],n[1]);}return [n,e.length]}(e.textAnchorOffsets,W);e.symbolInstances.emplaceBack(r.x,r.y,L.right>=0?L.right:-1,L.center>=0?L.center:-1,L.left>=0?L.left:-1,L.vertical||-1,F,$,O,R,N,U,q,G,Z,X,K,c,E,T,B,V,J,0,f,H,Q,tt);}(e,p,l,n,i,s,B,e.layers[0],e.collisionBoxArray,r.index,r.sourceLayerIndex,e.index,x,[_,_,_,_],k,u,b,S,I,y,r,a,c,h,o);};if("line"===z)for(const t of ph(r.geometry,0,0,M,M)){const r=Il(t,V),s=vh(r,w,A,n.vertical||m,i,24,v,e.overscaling,M);for(const t of s)m&&jh(e,m.text,P,t)||E(r,t);}else if("line-center"===z){for(const t of r.geometry)if(t.length>1){const e=Il(t,V),r=xh(e,A,n.vertical||m,i,24,v);r&&E(e,r);}}else if("Polygon"===r.type)for(const t of Rr(r.geometry,0)){const e=Ph(t,16);E(Il(t[0],V,!0),new fh(e.x,e.y,0));}else if("LineString"===r.type)for(const t of r.geometry){const e=Il(t,V);E(e,new fh(e[0].x,e[0].y,0));}else if("Point"===r.type)for(const t of r.geometry)for(const e of t)E([e],new fh(e.x,e.y,0));}function Dh(t,e,r,n,i,s,a,o,u,c,h,p,f,d,y){const m=function(t,e,r,n,i,s,a,o){const u=n.layout.get("text-rotate").evaluate(s,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const s=n.rect||{};let h=Uu+1,p=!0,f=1,d=0;const y=(i||o)&&n.vertical,m=n.metrics.advance*n.scale/2;if(o&&e.verticalizable&&(d=t.lineOffset/2-(n.imageName?-(Tu-n.metrics.width*n.scale)/2:(n.scale-1)*Tu)),n.imageName){const t=a[n.imageName];p=t.sdf,f=t.pixelRatio,h=Gu/f;}const g=i?[n.x+m,n.y]:[0,0];let x=i?[0,0]:[n.x+m+r[0],n.y+r[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=n.metrics.isDoubleResolution?2:1,w=(n.metrics.left-h)*n.scale-m+x[0],_=(-n.metrics.top-h)*n.scale+x[1],S=w+s.w/b*n.scale/f,A=_+s.h/b*n.scale/f,k=new l(w,_),M=new l(S,_),I=new l(w,A),z=new l(S,A);if(y){const t=new l(-m,m-Hu),e=-Math.PI/2,r=Tu/2-m,i=new l(5-Hu-r,-(n.imageName?r:0)),s=new l(...v);k._rotateAround(e,t)._add(i)._add(s),M._rotateAround(e,t)._add(i)._add(s),I._rotateAround(e,t)._add(i)._add(s),z._rotateAround(e,t)._add(i)._add(s);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];k._matMult(r),M._matMult(r),I._matMult(r),z._matMult(r);}const P=new l(0,0),C=new l(0,0);c.push({tl:k,tr:M,bl:I,br:z,tex:s,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:P,pixelOffsetBR:C,minFontScaleX:0,minFontScaleY:0});}return c}(0,r,o,i,s,a,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[vc*i.layout.get("text-size").evaluate(a,{})],x[0]>bc&&j(`${t.layerIds[0]}: Value for "text-size" is >= ${xc}. Reduce your "text-size".`)):"composite"===g.kind&&(x=[vc*d.compositeTextSizes[0].evaluate(a,{},y),vc*d.compositeTextSizes[1].evaluate(a,{},y)],(x[0]>bc||x[1]>bc)&&j(`${t.layerIds[0]}: Value for "text-size" is >= ${xc}. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,o,s,a,c,e,u.lineStartIndex,u.lineLength,f,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function Rh(t){for(const e in t)return t[e];return null}function jh(t,e,r,n){const i=t.compareText;if(e in i){const t=i[e];for(let e=t.length-1;e>=0;e--)if(n.dist(t[e])<r)return !0}else i[e]=[];return i[e].push(n),!1}const Nh=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Uh{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,r]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=Nh[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[a]=new Uint32Array(t,4,1);return new Uh(a,s,i,t)}constructor(t,e=64,r=Float64Array,n){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=r,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const i=Nh.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,a=t*this.IndexArrayType.BYTES_PER_ELEMENT,o=(8-a%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+a+o),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+a+o,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t);}add(t,e){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=t,this.coords[this._pos++]=e,r}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return qh(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:a}=this,o=[0,i.length-1,0],l=[];for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=a){for(let a=h;a<=c;a++){const o=s[2*a],u=s[2*a+1];o>=t&&o<=r&&u>=e&&u<=n&&l.push(i[a]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=t&&f<=r&&d>=e&&d<=n&&l.push(i[p]),(0===u?t<=f:e<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?r>=f:n>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return l}within(t,e,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,a=[0,n.length-1,0],o=[],l=r*r;for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)Kh(i[2*r],i[2*r+1],t,e)<=l&&o.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];Kh(f,d,t,e)<=l&&o.push(n[p]),(0===u?t-r<=f:e-r<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?t+r>=f:e+r>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return o}}function qh(t,e,r,n,i,s){if(i-n<=r)return;const a=n+i>>1;Gh(t,e,a,n,i,s),qh(t,e,r,n,a-1,1-s),qh(t,e,r,a+1,i,1-s);}function Gh(t,e,r,n,i,s){for(;i>n;){if(i-n>600){const a=i-n+1,o=r-n+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);Gh(t,e,r,Math.max(n,Math.floor(r-o*u/a+c)),Math.min(i,Math.floor(r+(a-o)*u/a+c)),s);}const a=e[2*r+s];let o=n,l=i;for(Zh(t,e,n,r),e[2*i+s]>a&&Zh(t,e,n,i);o<l;){for(Zh(t,e,o,l),o++,l--;e[2*o+s]<a;)o++;for(;e[2*l+s]>a;)l--;}e[2*n+s]===a?Zh(t,e,n,l):(l++,Zh(t,e,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function Zh(t,e,r,n){Xh(t,r,n),Xh(e,2*r,2*n),Xh(e,2*r+1,2*n+1);}function Xh(t,e,r){const n=t[e];t[e]=t[r],t[r]=n;}function Kh(t,e,r,n){const i=t-r,s=e-n;return i*i+s*s}var Hh;t.ce=void 0,(Hh=t.ce||(t.ce={})).create="create",Hh.load="load",Hh.fullLoad="fullLoad";let Yh=null,Jh=[];const Wh=1e3/60,Qh="loadTime",tp="fullLoadTime",ep={mark(t){performance.mark(t);},frame(t){const e=t;null!=Yh&&Jh.push(e-Yh),Yh=e;},clearMetrics(){Yh=null,Jh=[],performance.clearMeasures(Qh),performance.clearMeasures(tp);for(const e in t.ce)performance.clearMarks(t.ce[e]);},getPerformanceMetrics(){performance.measure(Qh,t.ce.create,t.ce.load),performance.measure(tp,t.ce.create,t.ce.fullLoad);const e=performance.getEntriesByName(Qh)[0].duration,r=performance.getEntriesByName(tp)[0].duration,n=Jh.length,i=1/(Jh.reduce(((t,e)=>t+e),0)/n/1e3),s=Jh.filter((t=>t>Wh)).reduce(((t,e)=>t+(e-Wh)/Wh),0);return {loadTime:e,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n}}};t.$=St,t.A=g,t.B=Li,t.C=function(t){if(null==q){const e=t.navigator?t.navigator.userAgent:null;q=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return q},t.D=vs,t.E=ct,t.F=class{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Uc((()=>this.process())),this.subscription=function(t,e,r,n){return t.addEventListener(e,r,!1),{unsubscribe:()=>{t.removeEventListener(e,r,!1);}}}(this.target,"message",(t=>this.receive(t))),this.globalScope=U(self)?t:window;}registerMessageHandler(t,e){this.messageHandlers[t]=e;}sendAsync(t,e){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10);this.resolveRejects[i]={resolve:r,reject:n},e&&e.signal.addEventListener("abort",(()=>{delete this.resolveRejects[i];const e={id:i,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e);}),{once:!0});const s=[],a=Object.assign(Object.assign({},t),{id:i,sourceMapId:this.mapId,origin:location.origin,data:Xi(t.data,s)});this.target.postMessage(a,{transfer:s});}))}receive(t){const e=t.data,r=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[r];const t=this.abortControllers[r];return delete this.abortControllers[r],void(t&&t.abort())}if(U(self)||e.mustQueue)return this.tasks[r]=e,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,e);}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e);}processTask(t,r){return e(this,void 0,void 0,(function*(){if("<response>"===r.type){const e=this.resolveRejects[t];if(delete this.resolveRejects[t],!e)return;return void(r.error?e.reject(Ki(r.error)):e.resolve(Ki(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const e=Ki(r.data),n=new AbortController;this.abortControllers[t]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,e,n);this.completeTask(t,null,i);}catch(e){this.completeTask(t,e);}}))}completeTask(t,e,r){const n=[];delete this.abortControllers[t];const i={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?Xi(e):null,data:Xi(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},t.G=et,t.H=function(){var t=new g(16);return g!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.I=Zu,t.J=function(t,e,r){var n,i,s,a,o,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],t[0]=n=e[0],t[1]=i,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=f,t[11]=d,t[12]=n*y+o*m+h*g+e[12],t[13]=i*y+l*m+p*g+e[13],t[14]=s*y+u*m+f*g+e[14],t[15]=a*y+c*m+d*g+e[15]),t},t.K=function(t,e,r){var n=r[0],i=r[1],s=r[2];return t[0]=e[0]*n,t[1]=e[1]*n,t[2]=e[2]*n,t[3]=e[3]*n,t[4]=e[4]*i,t[5]=e[5]*i,t[6]=e[6]*i,t[7]=e[7]*i,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.L=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*n+b*o+w*h+_*y,t[1]=v*i+b*l+w*p+_*m,t[2]=v*s+b*u+w*f+_*g,t[3]=v*a+b*c+w*d+_*x,t[4]=(v=r[4])*n+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*i+b*l+w*p+_*m,t[6]=v*s+b*u+w*f+_*g,t[7]=v*a+b*c+w*d+_*x,t[8]=(v=r[8])*n+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*i+b*l+w*p+_*m,t[10]=v*s+b*u+w*f+_*g,t[11]=v*a+b*c+w*d+_*x,t[12]=(v=r[12])*n+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*i+b*l+w*p+_*m,t[14]=v*s+b*u+w*f+_*g,t[15]=v*a+b*c+w*d+_*x,t},t.M=function(t,e){const r={};for(let n=0;n<e.length;n++){const i=e[n];i in t&&(r[i]=t[i]);}return r},t.N=Gc,t.O=Kc,t.P=l,t.Q=Hc,t.R=Do,t.S=nh,t.T=fs,t.U=f,t.V=d,t.W=X,t.X=M,t.Y=Qc,t.Z=eh,t._=e,t.a=Q,t.a$=function(){return new Float64Array(16)},t.a0=t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((r=>{e.onloadstart=()=>{r(e);};for(const r of t){const t=window.document.createElement("source");st(r)||(e.crossOrigin="Anonymous"),t.src=r,e.appendChild(t);}}))},t.a1=function(){return $++},t.a2=ra,t.a3=Cc,t.a4=Yn,t.a5=lo,t.a6=oh,t.a7=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,r,n,i)=>{const s=n||i;return e[r]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e},t.a8=function(t){return Math.log(t)/Math.LN2},t.a9=function(t){var e=t[0],r=t[1];return e*e+r*r},t.aA=Cs,t.aB=_l,t.aC=fa,t.aD=Pa,t.aE=ka,t.aF=85.051129,t.aG=function(t){return Math.pow(2,t)},t.aH=Yc,t.aI=T,t.aJ=Y,t.aK=Wc,t.aL=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t},t.aM=function(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},t.aN=function(t){var e=new g(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},t.aO=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t},t.aP=function(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t},t.aQ=function(t,e){var r=e[0],n=e[1],i=e[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t},t.aR=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=i*l-s*o,t[1]=s*a-n*l,t[2]=n*o-i*a,t},t.aS=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]},t.aT=rh,t.aU=ih,t.aV=function(t,e,r,n,i){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=i&&i!==1/0?(t[10]=(i+n)*(s=1/(n-i)),t[14]=2*i*n*s):(t[10]=-1,t[14]=-2*n),t},t.aW=function(t){var e=new g(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.aX=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i+u*n,t[1]=a*i+c*n,t[2]=o*i+h*n,t[3]=l*i+p*n,t[4]=u*i-s*n,t[5]=c*i-a*n,t[6]=h*i-o*n,t[7]=p*i-l*n,t},t.aY=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*i+u*n,t[5]=a*i+c*n,t[6]=o*i+h*n,t[7]=l*i+p*n,t[8]=u*i-s*n,t[9]=c*i-a*n,t[10]=h*i-o*n,t[11]=p*i-l*n,t},t.aZ=function(){const t=new Float32Array(16);return v(t),t},t.a_=function(){const t=new Float64Array(16);return v(t),t},t.aa=function(t){return t*Math.PI/180},t.ab=E,t.ac=function(t,e){const r=[];for(const n in t)n in e||r.push(n);return r},t.ad=A,t.ae=function(t){return Math.hypot(t[0],t[1])},t.af=function(t){return t[0]=0,t[1]=0,t},t.ag=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t},t.ah=function(t,e){let r=0,n=0;if("constant"===t.kind)n=t.layoutSize;else if("source"!==t.kind){const{interpolationType:i,minZoom:s,maxZoom:a}=t,o=i?E(Qe.interpolationFactor(i,e,s,a),0,1):0;"camera"===t.kind?n=er.number(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:n}},t.aj=function(t,{uSize:e,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===t.kind?n/vc:"composite"===t.kind?er.number(n/vc,i/vc,r):e},t.ak=Mc,t.al=_,t.am=function(t,e,r,n){const i=e.y-t.y,s=e.x-t.x,a=n.y-r.y,o=n.x-r.x,u=a*s-o*i;if(0===u)return null;const c=(o*(t.y-r.y)-a*(t.x-r.x))/u;return new l(t.x+c*s,t.y+c*i)},t.an=function(t,e){var r=e[0],n=e[1],i=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],f=e[11],d=e[12],y=e[13],m=e[14],g=e[15],x=r*o-n*a,v=r*l-i*a,b=r*u-s*a,w=n*l-i*o,_=n*u-s*o,S=i*u-s*l,A=c*y-h*d,k=c*m-p*d,M=c*g-f*d,I=h*m-p*y,z=h*g-f*y,P=p*g-f*m,C=x*P-v*z+b*I+w*M-_*k+S*A;return C?(t[0]=(o*P-l*z+u*I)*(C=1/C),t[1]=(i*z-n*P-s*I)*C,t[2]=(y*S-m*_+g*w)*C,t[3]=(p*_-h*S-f*w)*C,t[4]=(l*M-a*P-u*k)*C,t[5]=(r*P-i*M+s*k)*C,t[6]=(m*b-d*S-g*v)*C,t[7]=(c*S-p*b+f*v)*C,t[8]=(a*z-o*M+u*A)*C,t[9]=(n*M-r*z-s*A)*C,t[10]=(d*_-y*b+g*x)*C,t[11]=(h*b-c*_-f*x)*C,t[12]=(o*k-a*I-l*A)*C,t[13]=(r*I-n*k+i*A)*C,t[14]=(y*v-d*w-m*x)*C,t[15]=(c*w-h*v+p*x)*C,t):null},t.ao=ph,t.ap=po,t.aq=v,t.ar=function(t){let e=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of t)e=Math.min(e,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return [e,r,n,i]},t.as=Tu,t.at=I,t.au=function(t,e,r,n,i=!1){if(!r[0]&&!r[1])return [0,0];const s=i?"map"===n?-t.bearingInRadians:0:"viewport"===n?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);r=[r[0]*e-r[1]*t,r[0]*t+r[1]*e];}return [i?r[0]:I(e,r[0],t.zoom),i?r[1]:I(e,r[1],t.zoom)]},t.aw=_c,t.ax=Lh,t.ay=lc,t.az=Uh,t.b=G,t.b$=t=>"line"===t.type,t.b0=function(t,e,r){const n=new Float64Array(4);return function(t,e,r,n){var i=.5*Math.PI/180;e*=i,r*=i,n*=i;var s=Math.sin(e),a=Math.cos(e),o=Math.sin(r),l=Math.cos(r),u=Math.sin(n),c=Math.cos(n);t[0]=s*l*c-a*o*u,t[1]=a*o*c+s*l*u,t[2]=a*l*u-s*o*c,t[3]=a*l*c+s*o*u;}(n,t,e-90,r),n},t.b1=function(t,e,r,n){var i,s,a,o,l,u=e[0],c=e[1],h=e[2],p=e[3],f=r[0],d=r[1],y=r[2],g=r[3];return (s=u*f+c*d+h*y+p*g)<0&&(s=-s,f=-f,d=-d,y=-y,g=-g),1-s>m?(i=Math.acos(s),a=Math.sin(i),o=Math.sin((1-n)*i)/a,l=Math.sin(n*i)/a):(o=1-n,l=n),t[0]=o*u+l*f,t[1]=o*c+l*d,t[2]=o*h+l*y,t[3]=o*p+l*g,t},t.b2=function(t){const e=new Float64Array(9);var r,n,i,s,a,o,l,u,c,h,p,f,d,y,m,g,x,v;h=(i=(n=t)[0])*(l=i+i),p=(s=n[1])*l,d=(a=n[2])*l,y=a*(u=s+s),g=(o=n[3])*l,x=o*u,v=o*(c=a+a),(r=e)[0]=1-(f=s*u)-(m=a*c),r[3]=p-v,r[6]=d+x,r[1]=p+v,r[4]=1-h-m,r[7]=y-g,r[2]=d-x,r[5]=y+g,r[8]=1-h-f;const b=Y(-Math.asin(E(e[2],-1,1)));let w,_;return Math.hypot(e[5],e[8])<.001?(w=0,_=-Y(Math.atan2(e[3],e[4]))):(w=Y(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),_=Y(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:w,pitch:b+90,bearing:_}},t.b3=function(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing},t.b4=ye,t.b5=Ga,t.b6=Sl,t.b7=Al,t.b8=wl,t.b9=P,t.bA=L,t.bB=O,t.bC=class extends qa{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.bD=class extends qa{constructor(t,e){super(t,e),this.current=Ka;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.bE=Za,t.bF=Xa,t.bG=class extends qa{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.bH=class extends qa{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.bI=x,t.bJ=function(t,e){var r=Math.sin(e),n=Math.cos(e);return t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.bK=function(t,e,r){var n=e[0],i=e[1],s=e[2];return t[0]=n*r[0]+i*r[3]+s*r[6],t[1]=n*r[1]+i*r[4]+s*r[7],t[2]=n*r[2]+i*r[5]+s*r[8],t},t.bL=function(t,e,r,n,i,s,a){var o=1/(e-r),l=1/(n-i),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(i+n)*l,t[14]=(a+s)*u,t[15]=1,t},t.bM=class extends qs{},t.bN=zu,t.bO=class extends Zs{},t.bP=jo,t.bQ=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.bR=Ro,t.bS=function(t,e,r){var n=e[0],i=e[1],s=e[2],a=r[3]*n+r[7]*i+r[11]*s+r[15];return t[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/a,t[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/a,t},t.bT=class extends Ts{},t.bU=class extends Qs{},t.bV=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]&&t[4]===e[4]&&t[5]===e[5]&&t[6]===e[6]&&t[7]===e[7]&&t[8]===e[8]&&t[9]===e[9]&&t[10]===e[10]&&t[11]===e[11]&&t[12]===e[12]&&t[13]===e[13]&&t[14]===e[14]&&t[15]===e[15]},t.bW=function(t,e){var r=t[0],n=t[1],i=t[2],s=t[3],a=t[4],o=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],y=t[13],g=t[14],x=t[15],v=e[0],b=e[1],w=e[2],_=e[3],S=e[4],A=e[5],k=e[6],M=e[7],I=e[8],z=e[9],P=e[10],C=e[11],B=e[12],V=e[13],E=e[14],T=e[15];return Math.abs(r-v)<=m*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=m*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(i-w)<=m*Math.max(1,Math.abs(i),Math.abs(w))&&Math.abs(s-_)<=m*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(a-S)<=m*Math.max(1,Math.abs(a),Math.abs(S))&&Math.abs(o-A)<=m*Math.max(1,Math.abs(o),Math.abs(A))&&Math.abs(l-k)<=m*Math.max(1,Math.abs(l),Math.abs(k))&&Math.abs(u-M)<=m*Math.max(1,Math.abs(u),Math.abs(M))&&Math.abs(c-I)<=m*Math.max(1,Math.abs(c),Math.abs(I))&&Math.abs(h-z)<=m*Math.max(1,Math.abs(h),Math.abs(z))&&Math.abs(p-P)<=m*Math.max(1,Math.abs(p),Math.abs(P))&&Math.abs(f-C)<=m*Math.max(1,Math.abs(f),Math.abs(C))&&Math.abs(d-B)<=m*Math.max(1,Math.abs(d),Math.abs(B))&&Math.abs(y-V)<=m*Math.max(1,Math.abs(y),Math.abs(V))&&Math.abs(g-E)<=m*Math.max(1,Math.abs(g),Math.abs(E))&&Math.abs(x-T)<=m*Math.max(1,Math.abs(x),Math.abs(T))},t.bX=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.bY=t=>"symbol"===t.type,t.bZ=t=>"circle"===t.type,t.b_=t=>"heatmap"===t.type,t.ba=C,t.bb=ke,t.bc=function(t,e,r,n,i){return P(n,i,E((t-e)/(r-e),0,1))},t.bd=z,t.be=function(){return new Float64Array(4)},t.bf=function(){return new Float64Array(3)},t.bg=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bh=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bi=function(t,e,r,n){var i=[],s=[];return i[0]=e[0]-r[0],i[1]=e[1]-r[1],i[2]=e[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),t[0]=s[0]+r[0],t[1]=s[1]+r[1],t[2]=s[2]+r[2],t},t.bj=function(t,e,r){var n=Math.sin(r),i=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*i-u*n,t[1]=a*i-c*n,t[2]=o*i-h*n,t[3]=l*i-p*n,t[8]=s*n+u*i,t[9]=a*n+c*i,t[10]=o*n+h*i,t[11]=l*n+p*i,t},t.bk=function(t,e){const r=z(t,360),n=z(e,360),i=n-r,s=n>r?i-360:i+360;return Math.abs(i)<Math.abs(s)?i:s},t.bl=function(t){return t[0]=0,t[1]=0,t[2]=0,t},t.bm=function(t,e,r,n){const i=Math.sqrt(t*t+e*e),s=Math.sqrt(r*r+n*n);t/=i,e/=i,r/=s,n/=s;const a=Math.acos(t*r+e*n);return -e*r+t*n>0?a:-a},t.bn=function(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]},t.bo=qc,t.bp=function(t,e){const r=z(t,2*Math.PI),n=z(e,2*Math.PI);return Math.min(Math.abs(r-n),Math.abs(r-n+2*Math.PI),Math.abs(r-n-2*Math.PI))},t.bq=function(t){return Math.hypot(t[0],t[1],t[2])},t.br=function(){const t={},e=ht.$version;for(const r in ht.$root){const n=ht.$root[r];if(n.required){let i=null;i="version"===r?e:"array"===n.type?[]:{},null!=i&&(t[r]=i);}}return t},t.bs=Hi,t.bt=nt,t.bu=function(t){t=t.slice();const e=Object.create(null);for(let r=0;r<t.length;r++)e[t[r].id]=t[r];for(let r=0;r<t.length;r++)"ref"in t[r]&&(t[r]=ft(t[r],e[t[r].ref]));return t},t.bv=function(t){if("custom"===t.type)return new Nc(t);switch(t.type){case "background":return new Oc(t);case "circle":return new Co(t);case "fill":return new Fl(t);case "fill-extrusion":return new au(t);case "heatmap":return new No(t);case "hillshade":return new Go(t);case "line":return new _u(t);case "raster":return new jc(t);case "symbol":return new Fc(t)}},t.bw=D,t.bx=function(t,e){if(!t)return [{command:"setStyle",args:[e]}];let r=[];try{if(!dt(t.version,e.version))return [{command:"setStyle",args:[e]}];dt(t.center,e.center)||r.push({command:"setCenter",args:[e.center]}),dt(t.centerAltitude,e.centerAltitude)||r.push({command:"setCenterAltitude",args:[e.centerAltitude]}),dt(t.zoom,e.zoom)||r.push({command:"setZoom",args:[e.zoom]}),dt(t.bearing,e.bearing)||r.push({command:"setBearing",args:[e.bearing]}),dt(t.pitch,e.pitch)||r.push({command:"setPitch",args:[e.pitch]}),dt(t.roll,e.roll)||r.push({command:"setRoll",args:[e.roll]}),dt(t.sprite,e.sprite)||r.push({command:"setSprite",args:[e.sprite]}),dt(t.glyphs,e.glyphs)||r.push({command:"setGlyphs",args:[e.glyphs]}),dt(t.transition,e.transition)||r.push({command:"setTransition",args:[e.transition]}),dt(t.light,e.light)||r.push({command:"setLight",args:[e.light]}),dt(t.terrain,e.terrain)||r.push({command:"setTerrain",args:[e.terrain]}),dt(t.sky,e.sky)||r.push({command:"setSky",args:[e.sky]}),dt(t.projection,e.projection)||r.push({command:"setProjection",args:[e.projection]});const n={},i=[];!function(t,e,r,n){let i;for(i in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)||gt(i,r,n));for(i in e)Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)?dt(t[i],e[i])||("geojson"===t[i].type&&"geojson"===e[i].type&&vt(t,e,i)?yt(r,{command:"setGeoJSONSourceData",args:[i,e[i].data]}):xt(i,e,r,n)):mt(i,e,r));}(t.sources,e.sources,i,n);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&n[t.source]?r.push({command:"removeLayer",args:[t.id]}):s.push(t);})),r=r.concat(i),function(t,e,r){e=e||[];const n=(t=t||[]).map(wt),i=e.map(wt),s=t.reduce(_t,{}),a=e.reduce(_t,{}),o=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let t=0,e=0;t<n.length;t++)u=n[t],Object.prototype.hasOwnProperty.call(a,u)?e++:(yt(r,{command:"removeLayer",args:[u]}),o.splice(o.indexOf(u,e),1));for(let t=0,e=0;t<i.length;t++)u=i[i.length-1-t],o[o.length-1-t]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(yt(r,{command:"removeLayer",args:[u]}),o.splice(o.lastIndexOf(u,o.length-e),1)):e++,p=o[o.length-t],yt(r,{command:"addLayer",args:[a[u],p]}),o.splice(o.length-t,0,u),l[u]=!0);for(let t=0;t<i.length;t++)if(u=i[t],c=s[u],h=a[u],!l[u]&&!dt(c,h))if(dt(c.source,h.source)&&dt(c["source-layer"],h["source-layer"])&&dt(c.type,h.type)){for(f in bt(c.layout,h.layout,r,u,null,"setLayoutProperty"),bt(c.paint,h.paint,r,u,null,"setPaintProperty"),dt(c.filter,h.filter)||yt(r,{command:"setFilter",args:[u,h.filter]}),dt(c.minzoom,h.minzoom)&&dt(c.maxzoom,h.maxzoom)||yt(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?bt(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):dt(c[f],h[f])||yt(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?bt(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):dt(c[f],h[f])||yt(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else yt(r,{command:"removeLayer",args:[u]}),p=o[o.lastIndexOf(u)+1],yt(r,{command:"addLayer",args:[h,p]});}(s,e.layers,r);}catch(t){console.warn("Unable to compute style diff:",t),r=[{command:"setStyle",args:[e]}];}return r},t.by=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.bz=function t(e,r){if(Array.isArray(e)){if(!Array.isArray(r)||e.length!==r.length)return !1;for(let n=0;n<e.length;n++)if(!t(e[n],r[n]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==r){if("object"!=typeof r)return !1;if(Object.keys(e).length!==Object.keys(r).length)return !1;for(const n in e)if(!t(e[n],r[n]))return !1;return !0}return e===r},t.c=W,t.c0=t=>"fill"===t.type,t.c1=t=>"fill-extrusion"===t.type,t.c2=t=>"hillshade"===t.type,t.c3=t=>"raster"===t.type,t.c4=t=>"background"===t.type,t.c5=t=>"custom"===t.type,t.c6=B,t.c7=function(t,e,r){const n=k(e.x-r.x,e.y-r.y),i=k(t.x-r.x,t.y-r.y);var s,a;return Y(Math.atan2(n[0]*i[1]-n[1]*i[0],(s=n)[0]*(a=i)[0]+s[1]*a[1]))},t.c8=V,t.c9=function(t,e,r){var n=e[0],i=e[1];return t[0]=r[0]*n+r[4]*i+r[12],t[1]=r[1]*n+r[5]*i+r[13],t},t.cA=Lu,t.cB=Nn,t.cC=us,t.ca=function(t,e){const{x:r,y:n}=Qc.fromLngLat(e);return !(t<0||t>25||n<0||n>=1||r<0||r>=1)},t.cb=function(t,e){return t[0]=e[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.cc=class extends Es{},t.cd=ep,t.cf=function(t){return t.message===J},t.cg=rt,t.ch=function(t,e){Q.REGISTERED_PROTOCOLS[t]=e;},t.ci=function(t){delete Q.REGISTERED_PROTOCOLS[t];},t.cj=function(t,e){const r={};for(let n=0;n<t.length;n++){const i=e&&e[t[n].id]||si(t[n]);e&&(e[t[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(t[n]);}const n=[];for(const t in r)n.push(r[t]);return n},t.ck=Ui,t.cl=ah,t.cm=lh,t.cn=Xu,t.co=function(e){e.bucket.createArrays(),e.bucket.tilePixelRatio=M/(512*e.bucket.overscaling),e.bucket.compareText={},e.bucket.iconsNeedLinear=!1;const r=e.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new cs(e.bucket.zoom+1),e.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new cs(e.bucket.zoom+1),e.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new cs(18))};if("composite"===e.bucket.textSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new cs(t),e.canonical),i["text-size"].possiblyEvaluate(new cs(r),e.canonical)];}if("composite"===e.bucket.iconSizeData.kind){const{minZoom:t,maxZoom:r}=e.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new cs(t),e.canonical),i["icon-size"].possiblyEvaluate(new cs(r),e.canonical)];}const a=n.get("text-line-height")*Tu,o="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of e.bucket.features){const c=n.get("text-font").evaluate(i,{},e.canonical).join(","),h=u.evaluate(i,{},e.canonical),p=s.layoutTextSize.evaluate(i,{},e.canonical),f=s.layoutIconSize.evaluate(i,{},e.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},e.canonical)*Tu,f=Wi(s)?u:0,m=n.get("text-anchor").evaluate(i,{},e.canonical),x=$h(r,i,e.canonical);if(!x){const t=n.get("text-radial-offset").evaluate(i,{},e.canonical);g=t?Fh(m,[t*Tu,Th]):n.get("text-offset").evaluate(i,{},e.canonical).map((t=>t*Tu));}let v=o?"center":n.get("text-justify").evaluate(i,{},e.canonical);const b="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},e.canonical)*Tu:1/0,w=()=>{e.bucket.allowVerticalPlacement&&Ji(s)&&(d.vertical=Wu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,"left",f,g,t.ai.vertical,!0,p,h));};if(!o&&x){const r=new Set;if("auto"===v)for(let t=0;t<x.values.length;t+=2)r.add(Lh(x.values[t]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else {const r=Wu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,"center",i,f,g,t.ai.horizontal,!1,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}w();}else {"auto"===v&&(v=Lh(m));const r=Wu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.ai.horizontal,!1,p,h);r&&(d.horizontal[v]=r),w(),Ji(s)&&o&&l&&(d.vertical=Wu(y,e.glyphMap,e.glyphPositions,e.imagePositions,c,b,a,m,v,f,g,t.ai.vertical,!1,p,h));}}let x=!1;if(i.icon&&i.icon.name){const t=e.imageMap[i.icon.name];t&&(m=yc(e.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},e.canonical),n.get("icon-anchor").evaluate(i,{},e.canonical)),x=!!t.sdf,void 0===e.bucket.sdfIcons?e.bucket.sdfIcons=x:e.bucket.sdfIcons!==x&&j("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(t.pixelRatio!==e.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(e.bucket.iconsNeedLinear=!0));}const v=Rh(d.horizontal)||d.vertical;e.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&Oh(e.bucket,i,d,m,e.imageMap,s,p,f,g,x,e.canonical,e.subdivisionGranularity);}e.showCollisionBoxes&&e.bucket.generateCollisionDebugBuffers();},t.cp=mu,t.cq=Bl,t.cr=tu,t.cs=Yl,t.ct=Ou,t.cu=class{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let t=performance.getEntriesByName(this._marks.measure);return 0===t.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),t=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),t}},t.cv=function(t,r,n,i,s){return e(this,void 0,void 0,(function*(){if(d())try{return yield X(t,r,n,i,s)}catch(t){}return function(t,e,r,n,i){const s=t.width,a=t.height;K&&H||(K=new OffscreenCanvas(s,a),H=K.getContext("2d",{willReadFrequently:!0})),K.width=s,K.height=a,H.drawImage(t,0,0,s,a);const o=H.getImageData(e,r,n,i);return H.clearRect(0,0,s,a),o.data}(t,r,n,i,s)}))},t.cw=sh,t.cx=r,t.cy=s,t.cz=Hl,t.d=t=>e(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})),t.e=F,t.f=t=>new Promise(((e,r)=>{const n=new Image;n.onload=()=>{e(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame((()=>{n.src=Z;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(t)],{type:"image/png"});n.src=t.byteLength?URL.createObjectURL(i):Z;})),t.g=tt,t.h=(t,e)=>it(F(t,{type:"json"}),e),t.i=U,t.j=ut,t.k=lt,t.l=(t,e)=>it(F(t,{type:"arrayBuffer"}),e),t.m=it,t.n=function(t){return new Ou(t).readFields(Ru,[])},t.o=Oo,t.p=qu,t.q=As,t.r=$i,t.s=st,t.t=Ri,t.u=Fi,t.v=ht,t.w=j,t.x=function([t,e,r]){return e+=90,e*=Math.PI/180,r*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(r),y:t*Math.sin(e)*Math.sin(r),z:t*Math.cos(r)}},t.y=er,t.z=cs;}));

define("worker",["./shared"],(function(e){"use strict";class t{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,o){for(const o of t){this._layerConfigs[o.id]=o;const t=this._layers[o.id]=e.bv(o);t._featureFilter=e.a4(t.filter),this.keyCache[o.id]&&delete this.keyCache[o.id];}for(const e of o)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const i=e.cj(Object.values(this._layerConfigs),this.keyCache);for(const e of i){const t=e.map((e=>this._layers[e.id])),o=t[0];if("none"===o.visibility)continue;const i=o.source||"";let r=this.familiesBySource[i];r||(r=this.familiesBySource[i]={});const s=o.sourceLayer||"_geojsonTileLayer";let n=r[s];n||(n=r[s]=[]),n.push(t);}}}class o{constructor(t){const o={},i=[];for(const e in t){const r=t[e],s=o[e]={};for(const e in r){const t=r[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const o={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};i.push(o),s[e]={rect:o,metrics:t.metrics};}}const{w:r,h:s}=e.p(i),n=new e.o({width:r||1,height:s||1});for(const i in t){const r=t[i];for(const t in r){const s=r[+t];if(!s||0===s.bitmap.width||0===s.bitmap.height)continue;const a=o[i][t].rect;e.o.copy(s.bitmap,n,{x:0,y:0},{x:a.x+1,y:a.y+1},s.bitmap);}}this.image=n,this.positions=o;}}e.ck("GlyphAtlas",o);class i{constructor(t){this.tileID=new e.S(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[];}parse(t,i,s,n,a){return e._(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.a2;const l=new e.cl(Object.keys(t.layers).sort()),c=new e.cm(this.tileID,this.promoteId);c.bucketLayerIDs=[];const u={},h={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:s,subdivisionGranularity:a},d=i.familiesBySource[this.source];for(const o in d){const i=t.layers[o];if(!i)continue;1===i.version&&e.w(`Vector tile source "${this.source}" layer "${o}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const n=l.encode(o),a=[];for(let e=0;e<i.length;e++){const t=i.feature(e),r=c.getId(t,o);a.push({feature:t,id:r,index:e,sourceLayerIndex:n});}for(const t of d[o]){const o=t[0];o.source!==this.source&&e.w(`layer.source = ${o.source} does not equal this.source = ${this.source}`),o.minzoom&&this.zoom<Math.floor(o.minzoom)||o.maxzoom&&this.zoom>=o.maxzoom||"none"!==o.visibility&&(r(t,this.zoom,s),(u[o.id]=o.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:n,sourceID:this.source})).populate(a,h,this.tileID.canonical),c.bucketLayerIDs.push(t.map((e=>e.id))));}}const f=e.bA(h.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let g=Promise.resolve({});if(Object.keys(f).length){const e=new AbortController;this.inFlightDependencies.push(e),g=n.sendAsync({type:"GG",data:{stacks:f,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const p=Object.keys(h.iconDependencies);let m=Promise.resolve({});if(p.length){const e=new AbortController;this.inFlightDependencies.push(e),m=n.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e);}const y=Object.keys(h.patternDependencies);let v=Promise.resolve({});if(y.length){const e=new AbortController;this.inFlightDependencies.push(e),v=n.sendAsync({type:"GI",data:{icons:y,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const[w,x,_]=yield Promise.all([g,m,v]),b=new o(w),M=new e.cn(x,_);for(const t in u){const o=u[t];o instanceof e.a3?(r(o.layers,this.zoom,s),e.co({bucket:o,glyphMap:w,glyphPositions:b.positions,imageMap:x,imagePositions:M.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:h.subdivisionGranularity})):o.hasPattern&&(o instanceof e.cp||o instanceof e.cq||o instanceof e.cr)&&(r(o.layers,this.zoom,s),o.addFeatures(h,this.tileID.canonical,M.patternPositions));}return this.status="done",{buckets:Object.values(u).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:b.image,imageAtlas:M,glyphMap:this.returnDependencies?w:null,iconMap:this.returnDependencies?x:null,glyphPositions:this.returnDependencies?b.positions:null}}))}}function r(t,o,i){const r=new e.z(o);for(const e of t)e.recalculate(r,i);}class s{constructor(e,t,o){this.actor=e,this.layerIndex=t,this.availableImages=o,this.fetching={},this.loading={},this.loaded={};}loadVectorTile(t,o){return e._(this,void 0,void 0,(function*(){const i=yield e.l(t.request,o);try{return {vectorTile:new e.cs.VectorTile(new e.ct(i.data)),rawData:i.data,cacheControl:i.cacheControl,expires:i.expires}}catch(e){const o=new Uint8Array(i.data);let r=`Unable to parse the tile at ${t.request.url}, `;throw r+=31===o[0]&&139===o[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.message}`,new Error(r)}}))}loadTile(t){return e._(this,void 0,void 0,(function*(){const o=t.uid,r=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.cu(t.request),s=new i(t);this.loading[o]=s;const n=new AbortController;s.abort=n;try{const i=yield this.loadVectorTile(t,n);if(delete this.loading[o],!i)return null;const a=i.rawData,l={};i.expires&&(l.expires=i.expires),i.cacheControl&&(l.cacheControl=i.cacheControl);const c={};if(r){const e=r.finish();e&&(c.resourceTiming=JSON.parse(JSON.stringify(e)));}s.vectorTile=i.vectorTile;const u=s.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);this.loaded[o]=s,this.fetching[o]={rawTileData:a,cacheControl:l,resourceTiming:c};try{const t=yield u;return e.e({rawTileData:a.slice(0)},t,l,c)}finally{delete this.fetching[o];}}catch(e){throw delete this.loading[o],s.status="done",this.loaded[o]=s,e}}))}reloadTile(t){return e._(this,void 0,void 0,(function*(){const o=t.uid;if(!this.loaded||!this.loaded[o])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const i=this.loaded[o];if(i.showCollisionBoxes=t.showCollisionBoxes,"parsing"===i.status){const r=yield i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);let s;if(this.fetching[o]){const{rawTileData:t,cacheControl:i,resourceTiming:n}=this.fetching[o];delete this.fetching[o],s=e.e({rawTileData:t.slice(0)},r,i,n);}else s=r;return s}if("done"===i.status&&i.vectorTile)return i.parse(i.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity)}))}abortTile(t){return e._(this,void 0,void 0,(function*(){const e=this.loading,o=t.uid;e&&e[o]&&e[o].abort&&(e[o].abort.abort(),delete e[o]);}))}removeTile(t){return e._(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];}))}}class n{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:o,encoding:i,rawImageData:r,redFactor:s,greenFactor:n,blueFactor:a,baseShift:l}=t,c=r.width+2,u=r.height+2,h=e.b(r)?new e.R({width:c,height:u},yield e.cv(r,-1,-1,c,u)):r,d=new e.cw(o,h,i,s,n,a,l);return this.loaded=this.loaded||{},this.loaded[o]=d,d}))}removeTile(e){const t=this.loaded,o=e.uid;t&&t[o]&&delete t[o];}}var a,l,c=function(){if(l)return a;function e(e,o){if(0!==e.length){t(e[0],o);for(var i=1;i<e.length;i++)t(e[i],!o);}}function t(e,t){for(var o=0,i=0,r=0,s=e.length,n=s-1;r<s;n=r++){var a=(e[r][0]-e[n][0])*(e[n][1]+e[r][1]),l=o+a;i+=Math.abs(o)>=Math.abs(a)?o-l+a:a-l+o,o=l;}o+i>=0!=!!t&&e.reverse();}return l=1,a=function t(o,i){var r,s=o&&o.type;if("FeatureCollection"===s)for(r=0;r<o.features.length;r++)t(o.features[r],i);else if("GeometryCollection"===s)for(r=0;r<o.geometries.length;r++)t(o.geometries[r],i);else if("Feature"===s)t(o.geometry,i);else if("Polygon"===s)e(o.coordinates,i);else if("MultiPolygon"===s)for(r=0;r<o.coordinates.length;r++)e(o.coordinates[r],i);return o}}(),u=e.cx(c);const h=e.cs.VectorTileFeature.prototype.toGeoJSON;class d{constructor(t){this._feature=t,this.extent=e.X,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const o of this._feature.geometry)t.push([new e.P(o[0],o[1])]);return t}{const t=[];for(const o of this._feature.geometry){const i=[];for(const t of o)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}toGeoJSON(e,t,o){return h.call(this,e,t,o)}}class f{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.X,this.length=t.length,this._features=t;}feature(e){return new d(this._features[e])}}var g,p,m,y={exports:{}},v=function(){if(m)return y.exports;m=1;var t=e.cA(),o=function(){if(p)return g;p=1;var t=e.cy(),o=e.cz().VectorTileFeature;function i(e,t){this.options=t||{},this.features=e,this.length=e.length;}function r(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}return g=i,i.prototype.feature=function(e){return new r(this.features[e],this.options.extent)},r.prototype.loadGeometry=function(){var e=this.rawGeometry;this.geometry=[];for(var o=0;o<e.length;o++){for(var i=e[o],r=[],s=0;s<i.length;s++)r.push(new t(i[s][0],i[s][1]));this.geometry.push(r);}return this.geometry},r.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,o=-1/0,i=1/0,r=-1/0,s=0;s<e.length;s++)for(var n=e[s],a=0;a<n.length;a++){var l=n[a];t=Math.min(t,l.x),o=Math.max(o,l.x),i=Math.min(i,l.y),r=Math.max(r,l.y);}return [t,i,o,r]},r.prototype.toGeoJSON=o.prototype.toGeoJSON,g}();function i(e){var o=new t;return function(e,t){for(var o in e.layers)t.writeMessage(3,r,e.layers[o]);}(e,o),o.finish()}function r(e,t){var o;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var i={keys:[],values:[],keycache:{},valuecache:{}};for(o=0;o<e.length;o++)i.feature=e.feature(o),t.writeMessage(2,s,i);var r=i.keys;for(o=0;o<r.length;o++)t.writeStringField(3,r[o]);var n=i.values;for(o=0;o<n.length;o++)t.writeMessage(4,u,n[o]);}function s(e,t){var o=e.feature;void 0!==o.id&&t.writeVarintField(1,o.id),t.writeMessage(2,n,e),t.writeVarintField(3,o.type),t.writeMessage(4,c,o);}function n(e,t){var o=e.feature,i=e.keys,r=e.values,s=e.keycache,n=e.valuecache;for(var a in o.properties){var l=o.properties[a],c=s[a];if(null!==l){void 0===c&&(i.push(a),s[a]=c=i.length-1),t.writeVarint(c);var u=typeof l;"string"!==u&&"boolean"!==u&&"number"!==u&&(l=JSON.stringify(l));var h=u+":"+l,d=n[h];void 0===d&&(r.push(l),n[h]=d=r.length-1),t.writeVarint(d);}}}function a(e,t){return (t<<3)+(7&e)}function l(e){return e<<1^e>>31}function c(e,t){for(var o=e.loadGeometry(),i=e.type,r=0,s=0,n=o.length,c=0;c<n;c++){var u=o[c],h=1;1===i&&(h=u.length),t.writeVarint(a(1,h));for(var d=3===i?u.length-1:u.length,f=0;f<d;f++){1===f&&1!==i&&t.writeVarint(a(2,d-1));var g=u[f].x-r,p=u[f].y-s;t.writeVarint(l(g)),t.writeVarint(l(p)),r+=g,s+=p;}3===i&&t.writeVarint(a(7,1));}}function u(e,t){var o=typeof e;"string"===o?t.writeStringField(1,e):"boolean"===o?t.writeBooleanField(7,e):"number"===o&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}return y.exports=i,y.exports.fromVectorTileJs=i,y.exports.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var s in e)r[s]=new o(e[s].features,t),r[s].name=s,r[s].version=t.version,r[s].extent=t.extent;return i({layers:r})},y.exports.GeoJSONWrapper=o,y.exports}(),w=e.cx(v);const x={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},_=Math.fround||(b=new Float32Array(1),e=>(b[0]=+e,b[0]));var b;const M=3,S=5,I=6;class P{constructor(e){this.options=Object.assign(Object.create(x),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:o,maxZoom:i}=this.options;t&&console.time("total time");const r=`prepare ${e.length} points`;t&&console.time(r),this.points=e;const s=[];for(let t=0;t<e.length;t++){const o=e[t];if(!o.geometry)continue;const[i,r]=o.geometry.coordinates,n=_(D(i)),a=_(C(r));s.push(n,a,1/0,t,-1,1),this.options.reduce&&s.push(0);}let n=this.trees[i+1]=this._createTree(s);t&&console.timeEnd(r);for(let e=i;e>=o;e--){const o=+Date.now();n=this.trees[e]=this._createTree(this._cluster(n,e)),t&&console.log("z%d: %d clusters in %dms",e,n.numItems,+Date.now()-o);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let o=((e[0]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[1]));let r=180===e[2]?180:((e[2]+180)%360+360)%360-180;const s=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)o=-180,r=180;else if(o>r){const e=this.getClusters([o,i,180,s],t),n=this.getClusters([-180,i,r,s],t);return e.concat(n)}const n=this.trees[this._limitZoom(t)],a=n.range(D(o),C(s),D(r),C(i)),l=n.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+S]>1?k(l,t,this.clusterProps):this.points[l[t+M]]);}return c}getChildren(e){const t=this._getOriginId(e),o=this._getOriginZoom(e),i="No cluster with the specified id.",r=this.trees[o];if(!r)throw new Error(i);const s=r.data;if(t*this.stride>=s.length)throw new Error(i);const n=this.options.radius/(this.options.extent*Math.pow(2,o-1)),a=r.within(s[t*this.stride],s[t*this.stride+1],n),l=[];for(const t of a){const o=t*this.stride;s[o+4]===e&&l.push(s[o+S]>1?k(s,o,this.clusterProps):this.points[s[o+M]]);}if(0===l.length)throw new Error(i);return l}getLeaves(e,t,o){const i=[];return this._appendLeaves(i,e,t=t||10,o=o||0,0),i}getTile(e,t,o){const i=this.trees[this._limitZoom(e)],r=Math.pow(2,e),{extent:s,radius:n}=this.options,a=n/s,l=(o-a)/r,c=(o+1+a)/r,u={features:[]};return this._addTileFeatures(i.range((t-a)/r,l,(t+1+a)/r,c),i.data,t,o,r,u),0===t&&this._addTileFeatures(i.range(1-a/r,l,1,c),i.data,r,o,r,u),t===r-1&&this._addTileFeatures(i.range(0,l,a/r,c),i.data,-1,o,r,u),u.features.length?u:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const o=this.getChildren(e);if(t++,1!==o.length)break;e=o[0].properties.cluster_id;}return t}_appendLeaves(e,t,o,i,r){const s=this.getChildren(t);for(const t of s){const s=t.properties;if(s&&s.cluster?r+s.point_count<=i?r+=s.point_count:r=this._appendLeaves(e,s.cluster_id,o,i,r):r<i?r++:e.push(t),e.length===o)break}return r}_createTree(t){const o=new e.az(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)o.add(t[e],t[e+1]);return o.finish(),o.data=t,o}_addTileFeatures(e,t,o,i,r,s){for(const n of e){const e=n*this.stride,a=t[e+S]>1;let l,c,u;if(a)l=T(t,e,this.clusterProps),c=t[e],u=t[e+1];else {const o=this.points[t[e+M]];l=o.properties;const[i,r]=o.geometry.coordinates;c=D(i),u=C(r);}const h={type:1,geometry:[[Math.round(this.options.extent*(c*r-o)),Math.round(this.options.extent*(u*r-i))]],tags:l};let d;d=a||this.options.generateId?t[e+M]:this.points[t[e+M]].id,void 0!==d&&(h.id=d),s.features.push(h);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:o,extent:i,reduce:r,minPoints:s}=this.options,n=o/(i*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let o=0;o<a.length;o+=c){if(a[o+2]<=t)continue;a[o+2]=t;const i=a[o],u=a[o+1],h=e.within(a[o],a[o+1],n),d=a[o+S];let f=d;for(const e of h){const o=e*c;a[o+2]>t&&(f+=a[o+S]);}if(f>d&&f>=s){let e,s=i*d,n=u*d,g=-1;const p=((o/c|0)<<5)+(t+1)+this.points.length;for(const i of h){const l=i*c;if(a[l+2]<=t)continue;a[l+2]=t;const u=a[l+S];s+=a[l]*u,n+=a[l+1]*u,a[l+4]=p,r&&(e||(e=this._map(a,o,!0),g=this.clusterProps.length,this.clusterProps.push(e)),r(e,this._map(a,l)));}a[o+4]=p,l.push(s/f,n/f,1/0,p,-1,f),r&&l.push(g);}else {for(let e=0;e<c;e++)l.push(a[o+e]);if(f>1)for(const e of h){const o=e*c;if(!(a[o+2]<=t)){a[o+2]=t;for(let e=0;e<c;e++)l.push(a[o+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,o){if(e[t+S]>1){const i=this.clusterProps[e[t+I]];return o?Object.assign({},i):i}const i=this.points[e[t+M]].properties,r=this.options.map(i);return o&&r===i?Object.assign({},r):r}}function k(e,t,o){return {type:"Feature",id:e[t+M],properties:T(e,t,o),geometry:{type:"Point",coordinates:[(i=e[t],360*(i-.5)),O(e[t+1])]}};var i;}function T(e,t,o){const i=e[t+S],r=i>=1e4?`${Math.round(i/1e3)}k`:i>=1e3?Math.round(i/100)/10+"k":i,s=e[t+I],n=-1===s?{}:Object.assign({},o[s]);return Object.assign(n,{cluster:!0,cluster_id:e[t+M],point_count:i,point_count_abbreviated:r})}function D(e){return e/360+.5}function C(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function O(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function L(e,t,o,i){let r=i;const s=t+(o-t>>1);let n,a=o-t;const l=e[t],c=e[t+1],u=e[o],h=e[o+1];for(let i=t+3;i<o;i+=3){const t=F(e[i],e[i+1],l,c,u,h);if(t>r)n=i,r=t;else if(t===r){const e=Math.abs(i-s);e<a&&(n=i,a=e);}}r>i&&(n-t>3&&L(e,t,n,i),e[n+2]=r,o-n>3&&L(e,n,o,i));}function F(e,t,o,i,r,s){let n=r-o,a=s-i;if(0!==n||0!==a){const l=((e-o)*n+(t-i)*a)/(n*n+a*a);l>1?(o=r,i=s):l>0&&(o+=n*l,i+=a*l);}return n=e-o,a=t-i,n*n+a*a}function z(e,t,o,i){const r={id:null==e?null:e,type:t,geometry:o,tags:i,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)G(r,o);else if("Polygon"===t)G(r,o[0]);else if("MultiLineString"===t)for(const e of o)G(r,e);else if("MultiPolygon"===t)for(const e of o)G(r,e[0]);return r}function G(e,t){for(let o=0;o<t.length;o+=3)e.minX=Math.min(e.minX,t[o]),e.minY=Math.min(e.minY,t[o+1]),e.maxX=Math.max(e.maxX,t[o]),e.maxY=Math.max(e.maxY,t[o+1]);}function A(e,t,o,i){if(!t.geometry)return;const r=t.geometry.coordinates;if(r&&0===r.length)return;const s=t.geometry.type,n=Math.pow(o.tolerance/((1<<o.maxZoom)*o.extent),2);let a=[],l=t.id;if(o.promoteId?l=t.properties[o.promoteId]:o.generateId&&(l=i||0),"Point"===s)j(r,a);else if("MultiPoint"===s)for(const e of r)j(e,a);else if("LineString"===s)E(r,a,n,!1);else if("MultiLineString"===s){if(o.lineMetrics){for(const o of r)a=[],E(o,a,n,!1),e.push(z(l,"LineString",a,t.properties));return}Z(r,a,n,!1);}else if("Polygon"===s)Z(r,a,n,!0);else {if("MultiPolygon"!==s){if("GeometryCollection"===s){for(const r of t.geometry.geometries)A(e,{id:l,geometry:r,properties:t.properties},o,i);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of r){const t=[];Z(e,t,n,!0),a.push(t);}}e.push(z(l,s,a,t.properties));}function j(e,t){t.push(N(e[0]),J(e[1]),0);}function E(e,t,o,i){let r,s,n=0;for(let o=0;o<e.length;o++){const a=N(e[o][0]),l=J(e[o][1]);t.push(a,l,0),o>0&&(n+=i?(r*l-a*s)/2:Math.sqrt(Math.pow(a-r,2)+Math.pow(l-s,2))),r=a,s=l;}const a=t.length-3;t[2]=1,L(t,0,a,o),t[a+2]=1,t.size=Math.abs(n),t.start=0,t.end=t.size;}function Z(e,t,o,i){for(let r=0;r<e.length;r++){const s=[];E(e[r],s,o,i),t.push(s);}}function N(e){return e/360+.5}function J(e){const t=Math.sin(e*Math.PI/180),o=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return o<0?0:o>1?1:o}function W(e,t,o,i,r,s,n,a){if(i/=t,s>=(o/=t)&&n<i)return e;if(n<o||s>=i)return null;const l=[];for(const t of e){const e=t.geometry;let s=t.type;const n=0===r?t.minX:t.minY,c=0===r?t.maxX:t.maxY;if(n>=o&&c<i){l.push(t);continue}if(c<o||n>=i)continue;let u=[];if("Point"===s||"MultiPoint"===s)R(e,u,o,i,r);else if("LineString"===s)Y(e,u,o,i,r,!1,a.lineMetrics);else if("MultiLineString"===s)X(e,u,o,i,r,!1);else if("Polygon"===s)X(e,u,o,i,r,!0);else if("MultiPolygon"===s)for(const t of e){const e=[];X(t,e,o,i,r,!0),e.length&&u.push(e);}if(u.length){if(a.lineMetrics&&"LineString"===s){for(const e of u)l.push(z(t.id,s,e,t.tags));continue}"LineString"!==s&&"MultiLineString"!==s||(1===u.length?(s="LineString",u=u[0]):s="MultiLineString"),"Point"!==s&&"MultiPoint"!==s||(s=3===u.length?"Point":"MultiPoint"),l.push(z(t.id,s,u,t.tags));}}return l.length?l:null}function R(e,t,o,i,r){for(let s=0;s<e.length;s+=3){const n=e[s+r];n>=o&&n<=i&&q(t,e[s],e[s+1],e[s+2]);}}function Y(e,t,o,i,r,s,n){let a=V(e);const l=0===r?B:H;let c,u,h=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],g=e[d+1],p=e[d+2],m=e[d+3],y=e[d+4],v=0===r?f:g,w=0===r?m:y;let x=!1;n&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(g-y,2))),v<o?w>o&&(u=l(a,f,g,m,y,o),n&&(a.start=h+c*u)):v>i?w<i&&(u=l(a,f,g,m,y,i),n&&(a.start=h+c*u)):q(a,f,g,p),w<o&&v>=o&&(u=l(a,f,g,m,y,o),x=!0),w>i&&v<=i&&(u=l(a,f,g,m,y,i),x=!0),!s&&x&&(n&&(a.end=h+c*u),t.push(a),a=V(e)),n&&(h+=c);}let d=e.length-3;const f=e[d],g=e[d+1],p=0===r?f:g;p>=o&&p<=i&&q(a,f,g,e[d+2]),d=a.length-3,s&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&q(a,a[0],a[1],a[2]),a.length&&t.push(a);}function V(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function X(e,t,o,i,r,s){for(const n of e)Y(n,t,o,i,r,s,!1);}function q(e,t,o,i){e.push(t,o,i);}function B(e,t,o,i,r,s){const n=(s-t)/(i-t);return q(e,s,o+(r-o)*n,1),n}function H(e,t,o,i,r,s){const n=(s-o)/(r-o);return q(e,t+(i-t)*n,s,1),n}function $(e,t){const o=[];for(let i=0;i<e.length;i++){const r=e[i],s=r.type;let n;if("Point"===s||"MultiPoint"===s||"LineString"===s)n=U(r.geometry,t);else if("MultiLineString"===s||"Polygon"===s){n=[];for(const e of r.geometry)n.push(U(e,t));}else if("MultiPolygon"===s){n=[];for(const e of r.geometry){const o=[];for(const i of e)o.push(U(i,t));n.push(o);}}o.push(z(r.id,s,n,r.tags));}return o}function U(e,t){const o=[];o.size=e.size,void 0!==e.start&&(o.start=e.start,o.end=e.end);for(let i=0;i<e.length;i+=3)o.push(e[i]+t,e[i+1],e[i+2]);return o}function K(e,t){if(e.transformed)return e;const o=1<<e.z,i=e.x,r=e.y;for(const s of e.features){const e=s.geometry,n=s.type;if(s.geometry=[],1===n)for(let n=0;n<e.length;n+=2)s.geometry.push(Q(e[n],e[n+1],t,o,i,r));else for(let n=0;n<e.length;n++){const a=[];for(let s=0;s<e[n].length;s+=2)a.push(Q(e[n][s],e[n][s+1],t,o,i,r));s.geometry.push(a);}}return e.transformed=!0,e}function Q(e,t,o,i,r,s){return [Math.round(o*(e*i-r)),Math.round(o*(t*i-s))]}function ee(e,t,o,i,r){const s=t===r.maxZoom?0:r.tolerance/((1<<t)*r.extent),n={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:o,y:i,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)te(n,t,s,r);return n}function te(e,t,o,i){const r=t.geometry,s=t.type,n=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===s||"MultiPoint"===s)for(let t=0;t<r.length;t+=3)n.push(r[t],r[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===s)oe(n,r,e,o,!1,!1);else if("MultiLineString"===s||"Polygon"===s)for(let t=0;t<r.length;t++)oe(n,r[t],e,o,"Polygon"===s,0===t);else if("MultiPolygon"===s)for(let t=0;t<r.length;t++){const i=r[t];for(let t=0;t<i.length;t++)oe(n,i[t],e,o,!0,0===t);}if(n.length){let o=t.tags||null;if("LineString"===s&&i.lineMetrics){o={};for(const e in t.tags)o[e]=t.tags[e];o.mapbox_clip_start=r.start/r.size,o.mapbox_clip_end=r.end/r.size;}const a={geometry:n,type:"Polygon"===s||"MultiPolygon"===s?3:"LineString"===s||"MultiLineString"===s?2:1,tags:o};null!==t.id&&(a.id=t.id),e.features.push(a);}}function oe(e,t,o,i,r,s){const n=i*i;if(i>0&&t.size<(r?n:i))return void(o.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===i||t[e+2]>n)&&(o.numSimplified++,a.push(t[e],t[e+1])),o.numPoints++;r&&function(e,t){let o=0;for(let t=0,i=e.length,r=i-2;t<i;r=t,t+=2)o+=(e[t]-e[r])*(e[t+1]+e[r+1]);if(o>0===t)for(let t=0,o=e.length;t<o/2;t+=2){const i=e[t],r=e[t+1];e[t]=e[o-2-t],e[t+1]=e[o-1-t],e[o-2-t]=i,e[o-1-t]=r;}}(a,s),e.push(a);}const ie={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class re{constructor(e,t){const o=(t=this.options=function(e,t){for(const o in t)e[o]=t[o];return e}(Object.create(ie),t)).debug;if(o&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let i=function(e,t){const o=[];if("FeatureCollection"===e.type)for(let i=0;i<e.features.length;i++)A(o,e.features[i],t,i);else A(o,"Feature"===e.type?e:{geometry:e},t);return o}(e,t);this.tiles={},this.tileCoords=[],o&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),i=function(e,t){const o=t.buffer/t.extent;let i=e;const r=W(e,1,-1-o,o,0,-1,2,t),s=W(e,1,1-o,2+o,0,-1,2,t);return (r||s)&&(i=W(e,1,-o,1+o,0,-1,2,t)||[],r&&(i=$(r,1).concat(i)),s&&(i=i.concat($(s,-1)))),i}(i,t),i.length&&this.splitTile(i,0,0,0),o&&(i.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,o,i,r,s,n){const a=[e,t,o,i],l=this.options,c=l.debug;for(;a.length;){i=a.pop(),o=a.pop(),t=a.pop(),e=a.pop();const u=1<<t,h=se(t,o,i);let d=this.tiles[h];if(!d&&(c>1&&console.time("creation"),d=this.tiles[h]=ee(e,t,o,i,l),this.tileCoords.push({z:t,x:o,y:i}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,o,i,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==r){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===r)continue;if(null!=r){const e=r-t;if(o!==s>>e||i!==n>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,g=.5-f,p=.5+f,m=1+f;let y=null,v=null,w=null,x=null,_=W(e,u,o-f,o+p,0,d.minX,d.maxX,l),b=W(e,u,o+g,o+m,0,d.minX,d.maxX,l);e=null,_&&(y=W(_,u,i-f,i+p,1,d.minY,d.maxY,l),v=W(_,u,i+g,i+m,1,d.minY,d.maxY,l),_=null),b&&(w=W(b,u,i-f,i+p,1,d.minY,d.maxY,l),x=W(b,u,i+g,i+m,1,d.minY,d.maxY,l),b=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*o,2*i),a.push(v||[],t+1,2*o,2*i+1),a.push(w||[],t+1,2*o+1,2*i),a.push(x||[],t+1,2*o+1,2*i+1);}}getTile(e,t,o){e=+e,t=+t,o=+o;const i=this.options,{extent:r,debug:s}=i;if(e<0||e>24)return null;const n=1<<e,a=se(e,t=t+n&n-1,o);if(this.tiles[a])return K(this.tiles[a],r);s>1&&console.log("drilling down to z%d-%d-%d",e,t,o);let l,c=e,u=t,h=o;for(;!l&&c>0;)c--,u>>=1,h>>=1,l=this.tiles[se(c,u,h)];return l&&l.source?(s>1&&(console.log("found parent tile z%d-%d-%d",c,u,h),console.time("drilling down")),this.splitTile(l.source,c,u,h,e,t,o),s>1&&console.timeEnd("drilling down"),this.tiles[a]?K(this.tiles[a],r):null):null}}function se(e,t,o){return 32*((1<<e)*o+t)+e}function ne(e,t){return t?e.properties[t]:e.id}function ae(e,t){if(null==e)return !0;if("Feature"===e.type)return null!=ne(e,t);if("FeatureCollection"===e.type){const o=new Set;for(const i of e.features){const e=ne(i,t);if(null==e)return !1;if(o.has(e))return !1;o.add(e);}return !0}return !1}function le(e,t){const o=new Map;if(null==e);else if("Feature"===e.type)o.set(ne(e,t),e);else for(const i of e.features)o.set(ne(i,t),i);return o}class ce extends s{constructor(){super(...arguments),this._dataUpdateable=new Map;}loadVectorTile(t,o){return e._(this,void 0,void 0,(function*(){const e=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const o=this._geoJSONIndex.getTile(e.z,e.x,e.y);if(!o)return null;const i=new f(o.features);let r=w(i);return 0===r.byteOffset&&r.byteLength===r.buffer.byteLength||(r=new Uint8Array(r)),{vectorTile:i,rawData:r.buffer}}))}loadData(t){return e._(this,void 0,void 0,(function*(){var o;null===(o=this._pendingRequest)||void 0===o||o.abort();const i=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.cu(t.request);this._pendingRequest=new AbortController;try{this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest),this._geoJSONIndex=t.cluster?new P(function({superclusterOptions:t,clusterProperties:o}){if(!o||!t)return t;const i={},r={},s={accumulated:null,zoom:0},n={properties:null},a=Object.keys(o);for(const t of a){const[s,n]=o[t],a=e.cB(n),l=e.cB("string"==typeof s?[s,["accumulated"],["get",t]]:s);i[t]=a.value,r[t]=l.value;}return t.map=e=>{n.properties=e;const t={};for(const e of a)t[e]=i[e].evaluate(s,n);return t},t.reduce=(e,t)=>{n.properties=t;for(const t of a)s.accumulated=e[t],e[t]=r[t].evaluate(s,n);},t}(t)).load((yield this._pendingData).features):(r=yield this._pendingData,new re(r,t.geojsonVtOptions)),this.loaded={};const o={};if(i){const e=i.finish();e&&(o.resourceTiming={},o.resourceTiming[t.source]=JSON.parse(JSON.stringify(e)));}return o}catch(t){if(delete this._pendingRequest,e.cf(t))return {abandoned:!0};throw t}var r;}))}getData(){return e._(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadAndProcessGeoJSON(t,o){return e._(this,void 0,void 0,(function*(){let i=yield this.loadGeoJSON(t,o);if(delete this._pendingRequest,"object"!=typeof i)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(u(i,!0),t.filter){const o=e.cB(t.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===o.result)throw new Error(o.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const r=i.features.filter((e=>o.value.evaluate({zoom:0},e)));i={type:"FeatureCollection",features:r};}return i}))}loadGeoJSON(t,o){return e._(this,void 0,void 0,(function*(){const{promoteId:i}=t;if(t.request){const r=yield e.h(t.request,o);return this._dataUpdateable=ae(r.data,i)?le(r.data,i):void 0,r.data}if("string"==typeof t.data)try{const e=JSON.parse(t.data);return this._dataUpdateable=ae(e,i)?le(e,i):void 0,e}catch(e){throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`)}if(!t.dataDiff)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${t.source}`);return function(e,t,o){var i,r,s,n;if(t.removeAll&&e.clear(),t.remove)for(const o of t.remove)e.delete(o);if(t.add)for(const i of t.add){const t=ne(i,o);null!=t&&e.set(t,i);}if(t.update)for(const o of t.update){let t=e.get(o.id);if(null==t)continue;const a=!o.removeAllProperties&&((null===(i=o.removeProperties)||void 0===i?void 0:i.length)>0||(null===(r=o.addOrUpdateProperties)||void 0===r?void 0:r.length)>0);if((o.newGeometry||o.removeAllProperties||a)&&(t=Object.assign({},t),e.set(o.id,t),a&&(t.properties=Object.assign({},t.properties))),o.newGeometry&&(t.geometry=o.newGeometry),o.removeAllProperties)t.properties={};else if((null===(s=o.removeProperties)||void 0===s?void 0:s.length)>0)for(const e of o.removeProperties)Object.prototype.hasOwnProperty.call(t.properties,e)&&delete t.properties[e];if((null===(n=o.addOrUpdateProperties)||void 0===n?void 0:n.length)>0)for(const{key:e,value:i}of o.addOrUpdateProperties)t.properties[e]=i;}}(this._dataUpdateable,t.dataDiff,i),{type:"FeatureCollection",features:Array.from(this._dataUpdateable.values())}}))}removeSource(t){return e._(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort();}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}class ue{constructor(t){this.self=t,this.actor=new e.F(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.ch,this.self.removeProtocol=e.ci,this.self.registerRTLTextPlugin=t=>{e.cC.setMethods(t);},this.actor.registerMessageHandler("LDT",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("RDT",((t,o)=>e._(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,o.source).removeTile(o);})))),this.actor.registerMessageHandler("GCEZ",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterExpansionZoom(o)})))),this.actor.registerMessageHandler("GCC",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterChildren(o)})))),this.actor.registerMessageHandler("GCL",((t,o)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,o.type,o.source).getClusterLeaves(o)})))),this.actor.registerMessageHandler("LD",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("GD",((e,t)=>this._getWorkerSource(e,t.type,t.source).getData())),this.actor.registerMessageHandler("LT",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("RT",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("AT",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("RMT",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("RS",((t,o)=>e._(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][o.type]||!this.workerSources[t][o.type][o.source])return;const e=this.workerSources[t][o.type][o.source];delete this.workerSources[t][o.type][o.source],void 0!==e.removeSource&&e.removeSource(o);})))),this.actor.registerMessageHandler("RM",(t=>e._(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t];})))),this.actor.registerMessageHandler("SR",((t,o)=>e._(this,void 0,void 0,(function*(){this.referrer=o;})))),this.actor.registerMessageHandler("SRPS",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("IS",((t,o)=>e._(this,void 0,void 0,(function*(){this.self.importScripts(o);})))),this.actor.registerMessageHandler("SI",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("UL",((t,o)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(o.layers,o.removedIds);})))),this.actor.registerMessageHandler("SL",((t,o)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(o);}))));}_setImages(t,o){return e._(this,void 0,void 0,(function*(){this.availableImages[t]=o;for(const e in this.workerSources[t]){const i=this.workerSources[t][e];for(const e in i)i[e].availableImages=o;}}))}_syncRTLPluginState(t,o){return e._(this,void 0,void 0,(function*(){return yield e.cC.syncState(o,this.self.importScripts)}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let o=this.layerIndexes[e];return o||(o=this.layerIndexes[e]=new t),o}_getWorkerSource(e,t,o){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][o]){const i={sendAsync:(t,o)=>(t.targetMapId=e,this.actor.sendAsync(t,o))};switch(t){case "vector":this.workerSources[e][t][o]=new s(i,this._getLayerIndex(e),this._getAvailableImages(e));break;case "geojson":this.workerSources[e][t][o]=new ce(i,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][o]=new this.externalWorkerSourceTypes[t](i,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][o]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new n),this.demWorkerSources[e][t]}}return e.i(self)&&(self.worker=new ue(self)),ue}));

define("index",["exports","./shared"],(function(e,t){"use strict";var i="5.1.0";function r(){var e=new t.A(4);return t.A!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e}let o,s;const a={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frame(e,i,r){const o=requestAnimationFrame(i);e.signal.addEventListener("abort",(()=>{cancelAnimationFrame(o),r(t.c());}));},frameAsync(e){return new Promise(((t,i)=>{this.frame(e,t,i);}))},getImageData(e,t=0){return this.getImageCanvasContext(e).getImageData(-t,-t,e.width+2*t,e.height+2*t)},getImageCanvasContext(e){const t=window.document.createElement("canvas"),i=t.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0,e.width,e.height),i},resolveURL:e=>(o||(o=document.createElement("a")),o.href=e,o.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return !!matchMedia&&(null==s&&(s=matchMedia("(prefers-reduced-motion: reduce)")),s.matches)}};class n{static testProp(e){if(!n.docStyle)return e[0];for(let t=0;t<e.length;t++)if(e[t]in n.docStyle)return e[t];return e[0]}static create(e,t,i){const r=window.document.createElement(e);return void 0!==t&&(r.className=t),i&&i.appendChild(r),r}static createNS(e,t){return window.document.createElementNS(e,t)}static disableDrag(){n.docStyle&&n.selectProp&&(n.userSelect=n.docStyle[n.selectProp],n.docStyle[n.selectProp]="none");}static enableDrag(){n.docStyle&&n.selectProp&&(n.docStyle[n.selectProp]=n.userSelect);}static setTransform(e,t){e.style[n.transformProp]=t;}static addEventListener(e,t,i,r={}){e.addEventListener(t,i,"passive"in r?r:r.capture);}static removeEventListener(e,t,i,r={}){e.removeEventListener(t,i,"passive"in r?r:r.capture);}static suppressClickInternal(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",n.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",n.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",n.suppressClickInternal,!0);}),0);}static getScale(e){const t=e.getBoundingClientRect();return {x:t.width/e.offsetWidth||1,y:t.height/e.offsetHeight||1,boundingClientRect:t}}static getPoint(e,i,r){const o=i.boundingClientRect;return new t.P((r.clientX-o.left)/i.x-e.clientLeft,(r.clientY-o.top)/i.y-e.clientTop)}static mousePos(e,t){const i=n.getScale(e);return n.getPoint(e,i,t)}static touchPos(e,t){const i=[],r=n.getScale(e);for(let o=0;o<t.length;o++)i.push(n.getPoint(e,r,t[o]));return i}static mouseButton(e){return e.button}static remove(e){e.parentNode&&e.parentNode.removeChild(e);}static sanitize(e){const t=(new DOMParser).parseFromString(e,"text/html").body||document.createElement("body"),i=t.querySelectorAll("script");for(const e of i)e.remove();return n.clean(t),t.innerHTML}static isPossiblyDangerous(e,t){const i=t.replace(/\s+/g,"").toLowerCase();return !(!["src","href","xlink:href"].includes(e)||!i.includes("javascript:")&&!i.includes("data:"))||!!e.startsWith("on")||void 0}static clean(e){const t=e.children;for(const e of t)n.removeAttributes(e),n.clean(e);}static removeAttributes(e){for(const{name:t,value:i}of e.attributes)n.isPossiblyDangerous(t,i)&&e.removeAttribute(t);}}n.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,n.selectProp=n.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),n.transformProp=n.testProp(["transform","WebkitTransform"]);const l={supported:!1,testSupport:function(e){!u&&h&&(d?_(e):c=e);}};let c,h,u=!1,d=!1;function _(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,h),e.isContextLost())return;l.supported=!0;}catch(e){}e.deleteTexture(t),u=!0;}var p;"undefined"!=typeof document&&(h=document.createElement("img"),h.onload=()=>{c&&_(c),c=null,d=!0;},h.onerror=()=>{u=!0,c=null;},h.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(e){let i,r,o,s;e.resetRequestQueue=()=>{i=[],r=0,o=0,s={};},e.addThrottleControl=e=>{const t=o++;return s[t]=e,t},e.removeThrottleControl=e=>{delete s[e],n();},e.getImage=(e,r,o=!0)=>new Promise(((s,a)=>{l.supported&&(e.headers||(e.headers={}),e.headers.accept="image/webp,*/*"),t.e(e,{type:"image"}),i.push({abortController:r,requestParameters:e,supportImageRefresh:o,state:"queued",onError:e=>{a(e);},onSuccess:e=>{s(e);}}),n();}));const a=e=>t._(this,void 0,void 0,(function*(){e.state="running";const{requestParameters:i,supportImageRefresh:o,onError:s,onSuccess:a,abortController:l}=e,h=!1===o&&!t.i(self)&&!t.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce(((e,t)=>e&&"accept"===t),!0));r++;const u=h?c(i,l):t.m(i,l);try{const i=yield u;delete e.abortController,e.state="completed",i.data instanceof HTMLImageElement||t.b(i.data)?a(i):i.data&&a({data:yield(d=i.data,"function"==typeof createImageBitmap?t.d(d):t.f(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(t){delete e.abortController,s(t);}finally{r--,n();}var d;})),n=()=>{const e=(()=>{for(const e of Object.keys(s))if(s[e]())return !0;return !1})()?t.a.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:t.a.MAX_PARALLEL_IMAGE_REQUESTS;for(let t=r;t<e&&i.length>0;t++){const e=i.shift();e.abortController.signal.aborted?t--:a(e);}},c=(e,i)=>new Promise(((r,o)=>{const s=new Image,a=e.url,n=e.credentials;n&&"include"===n?s.crossOrigin="use-credentials":(n&&"same-origin"===n||!t.s(a))&&(s.crossOrigin="anonymous"),i.signal.addEventListener("abort",(()=>{s.src="",o(t.c());})),s.fetchPriority="high",s.onload=()=>{s.onerror=s.onload=null,r({data:s});},s.onerror=()=>{s.onerror=s.onload=null,i.signal.aborted||o(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},s.src=a;}));}(p||(p={})),p.resetRequestQueue();class m{constructor(e){this._transformRequestFn=e;}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}setTransformRequest(e){this._transformRequestFn=e;}}function f(e){const t=[];if("string"==typeof e)t.push({id:"default",url:e});else if(e&&e.length>0){const i=[];for(const{id:r,url:o}of e){const e=`${r}${o}`;-1===i.indexOf(e)&&(i.push(e),t.push({id:r,url:o}));}}return t}function g(e,t,i){try{const r=new URL(e);return r.pathname+=`${t}${i}`,r.toString()}catch(t){throw new Error(`Invalid sprite URL "${e}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}class v{constructor(e,t,i,r){this.context=e,this.format=i,this.texture=e.gl.createTexture(),this.update(t,r);}update(e,i,r){const{width:o,height:s}=e,a=!(this.size&&this.size[0]===o&&this.size[1]===s||r),{context:n}=this,{gl:l}=n;if(this.useMipmap=Boolean(i&&i.useMipmap),l.bindTexture(l.TEXTURE_2D,this.texture),n.pixelStoreUnpackFlipY.set(!1),n.pixelStoreUnpack.set(1),n.pixelStoreUnpackPremultiplyAlpha.set(this.format===l.RGBA&&(!i||!1!==i.premultiply)),a)this.size=[o,s],e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||t.b(e)?l.texImage2D(l.TEXTURE_2D,0,this.format,this.format,l.UNSIGNED_BYTE,e):l.texImage2D(l.TEXTURE_2D,0,this.format,o,s,0,this.format,l.UNSIGNED_BYTE,e.data);else {const{x:i,y:a}=r||{x:0,y:0};e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||t.b(e)?l.texSubImage2D(l.TEXTURE_2D,0,i,a,l.RGBA,l.UNSIGNED_BYTE,e):l.texSubImage2D(l.TEXTURE_2D,0,i,a,o,s,l.RGBA,l.UNSIGNED_BYTE,e.data);}this.useMipmap&&this.isSizePowerOfTwo()&&l.generateMipmap(l.TEXTURE_2D);}bind(e,t,i){const{context:r}=this,{gl:o}=r;o.bindTexture(o.TEXTURE_2D,this.texture),i!==o.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=o.LINEAR),e!==this.filter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,e),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,i||e),this.filter=e),t!==this.wrap&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,t),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,t),this.wrap=t);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:e}=this.context;e.deleteTexture(this.texture),this.texture=null;}}function x(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class b extends t.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,promiseResolve:t}of this.requestors)t(this._getImagesForIds(e));this.requestors=[];}}getImage(e){const i=this.images[e];if(i&&!i.data&&i.spriteData){const e=i.spriteData;i.data=new t.R({width:e.width,height:e.height},e.context.getImageData(e.x,e.y,e.width,e.height).data),i.spriteData=null;}return i}addImage(e,t){if(this.images[e])throw new Error(`Image id ${e} already exist, use updateImage instead`);this._validate(e,t)&&(this.images[e]=t);}_validate(e,i){let r=!0;const o=i.data||i.spriteData;return this._validateStretch(i.stretchX,o&&o.width)||(this.fire(new t.j(new Error(`Image "${e}" has invalid "stretchX" value`))),r=!1),this._validateStretch(i.stretchY,o&&o.height)||(this.fire(new t.j(new Error(`Image "${e}" has invalid "stretchY" value`))),r=!1),this._validateContent(i.content,i)||(this.fire(new t.j(new Error(`Image "${e}" has invalid "content" value`))),r=!1),r}_validateStretch(e,t){if(!e)return !0;let i=0;for(const r of e){if(r[0]<i||r[1]<r[0]||t<r[1])return !1;i=r[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;const i=t.spriteData,r=i&&i.width||t.data.width,o=i&&i.height||t.data.height;return !(e[0]<0||r<e[0]||e[1]<0||o<e[1]||e[2]<0||r<e[2]||e[3]<0||o<e[3]||e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i=!0){const r=this.getImage(e);if(i&&(r.data.width!==t.data.width||r.data.height!==t.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${t.data.width}x${t.data.height}).`);t.version=r.version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e){return new Promise(((t,i)=>{let r=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(r=!1);this.isLoaded()||r?t(this._getImagesForIds(e)):this.requestors.push({ids:e,promiseResolve:t});}))}_getImagesForIds(e){const i={};for(const r of e){let e=this.getImage(r);e||(this.fire(new t.k("styleimagemissing",{id:r})),e=this.getImage(r)),e?i[r]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,textFitWidth:e.textFitWidth,textFitHeight:e.textFitHeight,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.w(`Image "${r}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(e){const i=this.patterns[e],r=this.getImage(e);if(!r)return null;if(i&&i.position.version===r.version)return i.position;if(i)i.position.version=r.version;else {const i={w:r.data.width+2,h:r.data.height+2,x:0,y:0},o=new t.I(i,r);this.patterns[e]={bin:i,position:o};}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const t=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new v(e,this.atlasImage,t.RGBA),this.atlasTexture.bind(t.LINEAR,t.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:r}=t.p(e),o=this.atlasImage;o.resize({width:i||1,height:r||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],r=i.x+1,s=i.y+1,a=this.getImage(e).data,n=a.width,l=a.height;t.R.copy(a,o,{x:0,y:0},{x:r,y:s},{width:n,height:l}),t.R.copy(a,o,{x:0,y:l-1},{x:r,y:s-1},{width:n,height:1}),t.R.copy(a,o,{x:0,y:0},{x:r,y:s+l},{width:n,height:1}),t.R.copy(a,o,{x:n-1,y:0},{x:r-1,y:s},{width:1,height:l}),t.R.copy(a,o,{x:0,y:0},{x:r+n,y:s},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const i of e){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const e=this.getImage(i);e||t.w(`Image with ID: "${i}" was not found`),x(e)&&this.updateImage(i,e);}}}const y=1e20;function w(e,t,i,r,o,s,a,n,l){for(let c=t;c<t+r;c++)T(e,i*s+c,s,o,a,n,l);for(let c=i;c<i+o;c++)T(e,c*s+t,1,r,a,n,l);}function T(e,t,i,r,o,s,a){s[0]=0,a[0]=-1e20,a[1]=y,o[0]=e[t];for(let n=1,l=0,c=0;n<r;n++){o[n]=e[t+n*i];const r=n*n;do{const e=s[l];c=(o[n]-o[e]+r-e*e)/(n-e)/2;}while(c<=a[l]&&--l>-1);l++,s[l]=n,a[l]=c,a[l+1]=y;}for(let n=0,l=0;n<r;n++){for(;a[l+1]<n;)l++;const r=s[l],c=n-r;e[t+n*i]=o[r]+c*c;}}class P{constructor(e,t){this.requestManager=e,this.localIdeographFontFamily=t,this.entries={};}setURL(e){this.url=e;}getGlyphs(e){return t._(this,void 0,void 0,(function*(){const t=[];for(const i in e)for(const r of e[i])t.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(t),r={};for(const{stack:e,id:t,glyph:o}of i)r[e]||(r[e]={}),r[e][t]=o&&{id:o.id,bitmap:o.bitmap.clone(),metrics:o.metrics};return r}))}_getAndCacheGlyphsPromise(e,i){return t._(this,void 0,void 0,(function*(){let t=this.entries[e];t||(t=this.entries[e]={glyphs:{},requests:{},ranges:{}});let r=t.glyphs[i];if(void 0!==r)return {stack:e,id:i,glyph:r};if(r=this._tinySDF(t,e,i),r)return t.glyphs[i]=r,{stack:e,id:i,glyph:r};const o=Math.floor(i/256);if(256*o>65535)throw new Error("glyphs > 65535 not supported");if(t.ranges[o])return {stack:e,id:i,glyph:r};if(!this.url)throw new Error("glyphsUrl is not set");if(!t.requests[o]){const i=P.loadGlyphRange(e,o,this.url,this.requestManager);t.requests[o]=i;}const s=yield t.requests[o];for(const e in s)this._doesCharSupportLocalGlyph(+e)||(t.glyphs[+e]=s[+e]);return t.ranges[o]=!0,{stack:e,id:i,glyph:s[i]||null}}))}_doesCharSupportLocalGlyph(e){return !!this.localIdeographFontFamily&&/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(e))}_tinySDF(e,i,r){const o=this.localIdeographFontFamily;if(!o)return;if(!this._doesCharSupportLocalGlyph(r))return;let s=e.tinySDF;if(!s){let t="400";/bold/i.test(i)?t="900":/medium/i.test(i)?t="500":/light/i.test(i)&&(t="200"),s=e.tinySDF=new P.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:o,fontWeight:t});}const a=s.draw(String.fromCharCode(r));return {id:r,bitmap:new t.o({width:a.width||60,height:a.height||60},a.data),metrics:{width:a.glyphWidth/2||24,height:a.glyphHeight/2||24,left:a.glyphLeft/2+.5||0,top:a.glyphTop/2-27.5||-8,advance:a.glyphAdvance/2||24,isDoubleResolution:!0}}}}P.loadGlyphRange=function(e,i,r,o){return t._(this,void 0,void 0,(function*(){const s=256*i,a=s+255,n=o.transformRequest(r.replace("{fontstack}",e).replace("{range}",`${s}-${a}`),"Glyphs"),l=yield t.l(n,new AbortController);if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${s}-${a}`);const c={};for(const e of t.n(l.data))c[e.id]=e;return c}))},P.TinySDF=class{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:r=.25,fontFamily:o="sans-serif",fontWeight:s="normal",fontStyle:a="normal"}={}){this.buffer=t,this.cutoff=r,this.radius=i;const n=this.size=e+4*t,l=this._createCanvas(n),c=this.ctx=l.getContext("2d",{willReadFrequently:!0});c.font=`${a} ${s} ${e}px ${o}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(n*n),this.gridInner=new Float64Array(n*n),this.f=new Float64Array(n),this.z=new Float64Array(n+1),this.v=new Uint16Array(n);}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:o,actualBoundingBoxRight:s}=this.ctx.measureText(e),a=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-o))),l=Math.min(this.size-this.buffer,a+Math.ceil(r)),c=n+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),_={data:d,width:c,height:h,glyphWidth:n,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:t};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;p.clearRect(m,m,n,l),p.fillText(e,m,m+a);const v=p.getImageData(m,m,n,l);g.fill(y,0,u),f.fill(0,0,u);for(let e=0;e<l;e++)for(let t=0;t<n;t++){const i=v.data[4*(e*n+t)+3]/255;if(0===i)continue;const r=(e+m)*c+t+m;if(1===i)g[r]=0,f[r]=y;else {const e=.5-i;g[r]=e>0?e*e:0,f[r]=e<0?e*e:0;}}w(g,0,0,c,h,c,this.f,this.v,this.z),w(f,m,m,n,l,c,this.f,this.v,this.z);for(let e=0;e<u;e++){const t=Math.sqrt(g[e])-Math.sqrt(f[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff));}return _}};class C{constructor(){this.specification=t.v.light.position;}possiblyEvaluate(e,i){return t.x(e.expression.evaluate(i))}interpolate(e,i,r){return {x:t.y.number(e.x,i.x,r),y:t.y.number(e.y,i.y,r),z:t.y.number(e.z,i.z,r)}}}let I;class E extends t.E{constructor(e){super(),I=I||new t.q({anchor:new t.D(t.v.light.anchor),position:new C,color:new t.D(t.v.light.color),intensity:new t.D(t.v.light.intensity)}),this._transitionable=new t.T(I),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,i={}){if(!this._validate(t.r,e,i))for(const t in e){const i=e[t];t.endsWith("-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,r){return (!r||!1!==r.validate)&&t.t(this,e.call(t.u,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.v}))}}const M=new t.q({"sky-color":new t.D(t.v.sky["sky-color"]),"horizon-color":new t.D(t.v.sky["horizon-color"]),"fog-color":new t.D(t.v.sky["fog-color"]),"fog-ground-blend":new t.D(t.v.sky["fog-ground-blend"]),"horizon-fog-blend":new t.D(t.v.sky["horizon-fog-blend"]),"sky-horizon-blend":new t.D(t.v.sky["sky-horizon-blend"]),"atmosphere-blend":new t.D(t.v.sky["atmosphere-blend"])});class S extends t.E{constructor(e){super(),this._transitionable=new t.T(M),this.setSky(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.z(0));}setSky(e,i={}){if(!this._validate(t.B,e,i)){e||(e={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const t in e){const i=e[t];t.endsWith("-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i);}}}getSky(){return this._transitionable.serialize()}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,r={}){return !1!==(null==r?void 0:r.validate)&&t.t(this,e.call(t.u,t.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.v})))}calculateFogBlendOpacity(e){return e<60?0:e<70?(e-60)/10:1}}class R{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i]}getDashRanges(e,t,i){const r=[];let o=e.length%2==1?-e[e.length-1]*i:0,s=e[0]*i,a=!0;r.push({left:o,right:s,isDash:a,zeroLength:0===e[0]});let n=e[0];for(let t=1;t<e.length;t++){a=!a;const l=e[t];o=n*i,n+=l,s=n*i,r.push({left:o,right:s,isDash:a,zeroLength:0===l});}return r}addRoundDash(e,t,i){const r=t/2;for(let t=-i;t<=i;t++){const o=this.width*(this.nextRow+i+t);let s=0,a=e[s];for(let n=0;n<this.width;n++){n/a.right>1&&(a=e[++s]);const l=Math.abs(n-a.left),c=Math.abs(n-a.right),h=Math.min(l,c);let u;const d=t/i*(r+1);if(a.isDash){const e=r-Math.abs(d);u=Math.sqrt(h*h+e*e);}else u=r-Math.sqrt(h*h+d*d);this.data[o+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],r=e[t+1];i.zeroLength?e.splice(t,1):r&&r.isDash===i.isDash&&(r.left=i.left,e.splice(t,1));}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const r=this.width*this.nextRow;let o=0,s=e[o];for(let t=0;t<this.width;t++){t/s.right>1&&(s=e[++o]);const i=Math.abs(t-s.left),a=Math.abs(t-s.right),n=Math.min(i,a);this.data[r+t]=Math.max(0,Math.min(255,(s.isDash?n:-n)+128));}}addDash(e,i){const r=i?7:0,o=2*r+1;if(this.nextRow+o>this.height)return t.w("LineAtlas out of space"),null;let s=0;for(let t=0;t<e.length;t++)s+=e[t];if(0!==s){const t=this.width/s,o=this.getDashRanges(e,this.width,t);i?this.addRoundDash(o,t,r):this.addRegularDash(o);}const a={y:(this.nextRow+r+.5)/this.height,height:2*r/this.height,width:s};return this.nextRow+=o,this.dirty=!0,a}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data));}}const D="maplibre_preloaded_worker_pool";class z{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<z.workerCount;)this.workers.push(new Worker(t.a.WORKER_URL));return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[D]}numActive(){return Object.keys(this.active).length}}const A=Math.floor(a.hardwareConcurrency/2);let L,k;function F(){return L||(L=new z),L}z.workerCount=t.C(globalThis)?Math.max(Math.min(A,3),1):1;class B{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=i;const r=this.workerPool.acquire(i);for(let e=0;e<r.length;e++){const o=new t.F(r[e],i);o.name=`Worker ${e}`,this.actors.push(o);}if(!this.actors.length)throw new Error("No actors found")}broadcast(e,t){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:e,data:t}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(e=!0){this.actors.forEach((e=>{e.remove();})),this.actors=[],e&&this.workerPool.release(this.id);}registerMessageHandler(e,t){for(const i of this.actors)i.registerMessageHandler(e,t);}}function j(){return k||(k=new B(F(),t.G),k.registerMessageHandler("GR",((e,i,r)=>t.m(i,r)))),k}function O(e,i){const r=t.H();return t.J(r,r,[1,1,0]),t.K(r,r,[.5*e.width,.5*e.height,1]),e.calculatePosMatrix?t.L(r,r,e.calculatePosMatrix(i.toUnwrapped())):r}function N(e,t,i,r,o,s){var a;const n=function(e,t,i){if(e)for(const r of e){const e=t[r];if(e&&e.source===i&&"fill-extrusion"===e.type)return !0}else for(const e in t){const r=t[e];if(r.source===i&&"fill-extrusion"===r.type)return !0}return !1}(null!==(a=null==o?void 0:o.layers)&&void 0!==a?a:null,t,e.id),l=s.maxPitchScaleFactor(),c=e.tilesIn(r,l,n);c.sort(Z);const h=[];for(const r of c)h.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(t,i,e._state,r.queryGeometry,r.cameraQueryGeometry,r.scale,o,s,l,O(e.transform,r.tileID))});return function(e,t){for(const i in e)for(const r of e[i])G(r,t);return e}(function(e){const t={},i={};for(const r of e){const e=r.queryResults,o=r.wrappedTileID,s=i[o]=i[o]||{};for(const i in e){const r=e[i],o=s[i]=s[i]||{},a=t[i]=t[i]||[];for(const e of r)o[e.featureIndex]||(o[e.featureIndex]=!0,a.push(e));}}return t}(h),e)}function Z(e,t){const i=e.tileID,r=t.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function G(e,t){const i=e.feature,r=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r;}function U(e,i,r){return t._(this,void 0,void 0,(function*(){let o=e;if(e.url?o=(yield t.h(i.transformRequest(e.url,"Source"),r)).data:yield a.frameAsync(r),!o)return null;const s=t.M(t.e(o,e),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return "vector_layers"in o&&o.vector_layers&&(s.vectorLayerIds=o.vector_layers.map((e=>e.id))),s}))}class V{constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):Array.isArray(e)&&(4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1])));}setNorthEast(e){return this._ne=e instanceof t.N?new t.N(e.lng,e.lat):t.N.convert(e),this}setSouthWest(e){return this._sw=e instanceof t.N?new t.N(e.lng,e.lat):t.N.convert(e),this}extend(e){const i=this._sw,r=this._ne;let o,s;if(e instanceof t.N)o=e,s=e;else {if(!(e instanceof V))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend(V.convert(e)):this.extend(t.N.convert(e)):e&&("lng"in e||"lon"in e)&&"lat"in e?this.extend(t.N.convert(e)):this;if(o=e._sw,s=e._ne,!o||!s)return this}return i||r?(i.lng=Math.min(o.lng,i.lng),i.lat=Math.min(o.lat,i.lat),r.lng=Math.max(s.lng,r.lng),r.lat=Math.max(s.lat,r.lat)):(this._sw=new t.N(o.lng,o.lat),this._ne=new t.N(s.lng,s.lat)),this}getCenter(){return new t.N((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new t.N(this.getWest(),this.getNorth())}getSouthEast(){return new t.N(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(e){const{lng:i,lat:r}=t.N.convert(e);let o=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(o=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&o}static convert(e){return e instanceof V?e:e?new V(e):e}static fromLngLat(e,i=0){const r=360*i/40075017,o=r/Math.cos(Math.PI/180*e.lat);return new V(new t.N(e.lng-o,e.lat-r),new t.N(e.lng+o,e.lat+r))}adjustAntiMeridian(){const e=new t.N(this._sw.lng,this._sw.lat),i=new t.N(this._ne.lng,this._ne.lat);return new V(e,e.lng>i.lng?new t.N(i.lng+360,i.lat):i)}}class q{constructor(e,t,i){this.bounds=V.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const i=Math.pow(2,e.z),r=Math.floor(t.O(this.bounds.getWest())*i),o=Math.floor(t.Q(this.bounds.getNorth())*i),s=Math.ceil(t.O(this.bounds.getEast())*i),a=Math.ceil(t.Q(this.bounds.getSouth())*i);return e.x>=r&&e.x<s&&e.y>=o&&e.y<a}}class H extends t.E{constructor(e,i,r,o){if(super(),this.id=e,this.dispatcher=r,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.e(this,t.M(i,["url","scheme","tileSize","promoteId"])),this._options=t.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(o);}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.k("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield U(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),e&&(t.e(this,e),e.bounds&&(this.tileBounds=new q(e.bounds,this.minzoom,this.maxzoom)),this.fire(new t.k("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.k("data",{dataType:"source",sourceDataType:"content"})));}catch(e){this._tileJSONRequest=null,this.fire(new t.j(e));}}))}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.abort(),e(),this.load();}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return t.e({},this._options)}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(t,"Tile"),uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(e.actor&&"expired"!==e.state){if("loading"===e.state)return new Promise(((t,i)=>{e.reloadPromise={resolve:t,reject:i};}))}else e.actor=this.dispatcher.getActor(),r="LT";e.abortController=new AbortController;try{const t=yield e.actor.sendAsync({type:r,data:i},e.abortController);if(delete e.abortController,e.aborted)return;this._afterTileLoadWorkerResponse(e,t);}catch(t){if(delete e.abortController,e.aborted)return;if(t&&404!==t.status)throw t;this._afterTileLoadWorkerResponse(e,null);}}))}_afterTileLoadWorkerResponse(e,t){if(t&&t.resourceTiming&&(e.resourceTiming=t.resourceTiming),t&&this.map._refreshExpiredTiles&&e.setExpiryData(t),e.loadVectorData(t,this.map.painter),e.reloadPromise){const t=e.reloadPromise;e.reloadPromise=null,this.loadTile(e).then(t.resolve).catch(t.reject);}}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.actor&&(yield e.actor.sendAsync({type:"AT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),e.actor&&(yield e.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}hasTransition(){return !1}}class W extends t.E{constructor(e,i,r,o){super(),this.id=e,this.dispatcher=r,this.setEventedParent(o),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.e({type:"raster"},i),t.e(this,t.M(i,["url","scheme","tileSize"]));}load(){return t._(this,arguments,void 0,(function*(e=!1){this._loaded=!1,this.fire(new t.k("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const i=yield U(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,i&&(t.e(this,i),i.bounds&&(this.tileBounds=new q(i.bounds,this.minzoom,this.maxzoom)),this.fire(new t.k("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.k("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:e})));}catch(e){this._tileJSONRequest=null,this.fire(new t.j(e));}}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(e){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),e(),this.load(!0);}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}serialize(){return t.e({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);e.abortController=new AbortController;try{const i=yield p.getImage(this.map._requestManager.transformRequest(t,"Tile"),e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const t=this.map.painter.context,r=t.gl,o=i.data;e.texture=this.map.painter.getTileTexture(o.width),e.texture?e.texture.update(o,{useMipmap:!0}):(e.texture=new v(t,o,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),e.state="loaded";}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController);}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.texture&&this.map.painter.saveTileTexture(e.texture);}))}hasTransition(){return !1}}class X extends W{constructor(e,i,r,o){super(e,i,r,o),this.type="raster-dem",this.maxzoom=22,this._options=t.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),r=this.map._requestManager.transformRequest(i,"Tile");e.neighboringTiles=this._getNeighboringTiles(e.tileID),e.abortController=new AbortController;try{const i=yield p.getImage(r,e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){const r=i.data;this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const o=t.b(r)&&t.U()?r:yield this.readImageNow(r),s={type:this.type,uid:e.uid,source:this.id,rawImageData:o,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!e.actor||"expired"===e.state){e.actor=this.dispatcher.getActor();const t=yield e.actor.sendAsync({type:"LDT",data:s});e.dem=t,e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0,e.state="loaded";}}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}readImageNow(e){return t._(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&t.V()){const i=e.width+2,r=e.height+2;try{return new t.R({width:i,height:r},yield t.W(e,-1,-1,i,r))}catch(e){}}return a.getImageData(e,1)}))}_getNeighboringTiles(e){const i=e.canonical,r=Math.pow(2,i.z),o=(i.x-1+r)%r,s=0===i.x?e.wrap-1:e.wrap,a=(i.x+1+r)%r,n=i.x+1===r?e.wrap+1:e.wrap,l={};return l[new t.S(e.overscaledZ,s,i.z,o,i.y).key]={backfilled:!1},l[new t.S(e.overscaledZ,n,i.z,a,i.y).key]={backfilled:!1},i.y>0&&(l[new t.S(e.overscaledZ,s,i.z,o,i.y-1).key]={backfilled:!1},l[new t.S(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.S(e.overscaledZ,n,i.z,a,i.y-1).key]={backfilled:!1}),i.y+1<r&&(l[new t.S(e.overscaledZ,s,i.z,o,i.y+1).key]={backfilled:!1},l[new t.S(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.S(e.overscaledZ,n,i.z,a,i.y+1).key]={backfilled:!1}),l}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded",e.actor&&(yield e.actor.sendAsync({type:"RDT",data:{type:this.type,uid:e.uid,source:this.id}}));}))}}class $ extends t.E{constructor(e,i,r,o){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._pendingLoads=0,this.actor=r.getActor(),this.setEventedParent(o),this._data=i.data,this._options=t.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId,void 0!==i.clusterMaxZoom&&this.maxzoom<=i.clusterMaxZoom&&t.w(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${i.clusterMaxZoom}".`),this.workerOptions=t.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==i.buffer?i.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==i.tolerance?i.tolerance:.375),extent:t.X,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.X,radius:this._pixelsToTileUnits(i.clusterRadius||50),log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}_pixelsToTileUnits(e){return e*(t.X/this.tileSize)}load(){return t._(this,void 0,void 0,(function*(){yield this._updateWorkerData();}))}onAdd(e){this.map=e,this.load();}setData(e){return this._data=e,this._updateWorkerData(),this}updateData(e){return this._updateWorkerData(e),this}getData(){return t._(this,void 0,void 0,(function*(){const e=t.e({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:e})}))}setClusterOptions(e){return this.workerOptions.cluster=e.cluster,e&&(void 0!==e.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(e.clusterRadius)),void 0!==e.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=e.clusterMaxZoom)),this._updateWorkerData(),this}getClusterExpansionZoom(e){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:e,source:this.id}})}getClusterChildren(e){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:e,source:this.id}})}getClusterLeaves(e,t,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:e,limit:t,offset:i}})}_updateWorkerData(e){return t._(this,void 0,void 0,(function*(){const i=t.e({type:this.type},this.workerOptions);e?i.dataDiff=e:"string"==typeof this._data?(i.request=this.map._requestManager.transformRequest(a.resolveURL(this._data),"Source"),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(this._data),this._pendingLoads++,this.fire(new t.k("dataloading",{dataType:"source"}));try{const e=yield this.actor.sendAsync({type:"LD",data:i});if(this._pendingLoads--,this._removed||e.abandoned)return void this.fire(new t.k("dataabort",{dataType:"source"}));let r=null;e.resourceTiming&&e.resourceTiming[this.id]&&(r=e.resourceTiming[this.id].slice(0));const o={dataType:"source"};this._collectResourceTiming&&r&&r.length>0&&t.e(o,{resourceTiming:r}),this.fire(new t.k("data",Object.assign(Object.assign({},o),{sourceDataType:"metadata"}))),this.fire(new t.k("data",Object.assign(Object.assign({},o),{sourceDataType:"content"})));}catch(e){if(this._pendingLoads--,this._removed)return void this.fire(new t.k("dataabort",{dataType:"source"}));this.fire(new t.j(e));}}))}loaded(){return 0===this._pendingLoads}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.actor?"RT":"LT";e.actor=this.actor;const i={type:this.type,uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};e.abortController=new AbortController;const r=yield this.actor.sendAsync({type:t,data:i},e.abortController);delete e.abortController,e.unloadVectorData(),e.aborted||e.loadVectorData(r,this.map.painter,"RT"===t);}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.aborted=!0;}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}});}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}});}serialize(){return t.e({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}}class K extends t.E{constructor(e,t,i,r){super(),this.flippedWindingOrder=!1,this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=t;}load(e){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.k("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const t=yield p.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,t&&t.data&&(this.image=t.data,e&&(this.coordinates=e),this._finishLoading());}catch(e){this._request=null,this._loaded=!0,this.fire(new t.j(e));}}))}loaded(){return this._loaded}updateImage(e){return e.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=e.url,this.load(e.coordinates).finally((()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.k("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(e){this.coordinates=e;const i=e.map(t.Y.fromLngLat);var r;return this.tileID=function(e){let i=1/0,r=1/0,o=-1/0,s=-1/0;for(const t of e)i=Math.min(i,t.x),r=Math.min(r,t.y),o=Math.max(o,t.x),s=Math.max(s,t.y);const a=Math.max(o-i,s-r),n=Math.max(0,Math.floor(-Math.log(a)/Math.LN2)),l=Math.pow(2,n);return new t.Z(n,Math.floor((i+o)/2*l),Math.floor((r+s)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=i.map((e=>this.tileID.getTilePoint(e)._round())),this.flippedWindingOrder=((r=this.tileCoords)[1].x-r[0].x)*(r[2].y-r[0].y)-(r[1].y-r[0].y)*(r[2].x-r[0].x)<0,this.fire(new t.k("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.texture||(this.texture=new v(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0);}r&&this.fire(new t.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(e){return t._(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={}):e.state="errored";}))}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}class Y extends K{constructor(e,t,i,r){super(e,t,i,r),this.roundZoom=!0,this.type="video",this.options=t;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1;const e=this.options;this.urls=[];for(const t of e.urls)this.urls.push(this.map._requestManager.transformRequest(t,"Source").url);try{const e=yield t.a0(this.urls);if(this._loaded=!0,!e)return;this.video=e,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading();}catch(e){this.fire(new t.j(e));}}))}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.j(new t.$(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new v(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0);}r&&this.fire(new t.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class J extends K{constructor(e,i,r,o){super(e,i,r,o),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new t.j(new t.$(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.j(new t.$(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.j(new t.$(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new t.j(new t.$(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.j(new t.$(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.j(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}))}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,r=i.gl;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new v(i,this.canvas,r.RGBA,{premultiply:!0});let o=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,o=!0);}o&&this.fire(new t.k("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}}const Q={},ee=e=>{switch(e){case "geojson":return $;case "image":return K;case "raster":return W;case "raster-dem":return X;case "vector":return H;case "video":return Y;case "canvas":return J}return Q[e]},te="RTLPluginLoaded";class ie extends t.E{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=j();}_syncState(e){return this.status=e,this.dispatcher.broadcast("SRPS",{pluginStatus:e,pluginURL:this.url}).catch((e=>{throw this.status="error",e}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null;}setRTLTextPlugin(e){return t._(this,arguments,void 0,(function*(e,t=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=a.resolveURL(e),!this.url)throw new Error(`requested url ${e} is invalid`);if("unavailable"===this.status){if(!t)return this._requestImport();this.status="deferred",this._syncState(this.status);}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return t._(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new t.k(te));}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport();}}let re=null;function oe(){return re||(re=new ie),re}class se{constructor(e,i){this.timeAdded=0,this.fadeEndTime=0,this.tileID=e,this.uid=t.a1(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(e){const t=e+this.timeAdded;t<this.fadeEndTime||(this.fadeEndTime=t);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(e){this.demTexture&&e.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(e,i,r){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const r of e){const e=r.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){r.layers=e,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.id]=r;}}return i}(e.buckets,null==i?void 0:i.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.a3){if(this.hasSymbolBuckets=!0,!r)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.a3&&i.hasRTLText){this.hasRTLText=!0,oe().lazyLoad();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(e).queryRadius(t));}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage);}else this.collisionBoxArray=new t.a2;}unloadVectorData(){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(e){return this.buckets[e.id]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e);}const t=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new v(e,this.imageAtlas.image,t.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new v(e,this.glyphAtlasImage,t.ALPHA),this.glyphAtlasImage=null);}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture);}queryRenderedFeatures(e,t,i,r,o,s,a,n,l,c){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:o,scale:s,tileSize:this.tileSize,pixelPosMatrix:c,transform:n,params:a,queryPadding:this.queryPadding*l},e,t,i):{}}querySourceFeatures(e,i){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const o=r.loadVTLayers(),s=i&&i.sourceLayer?i.sourceLayer:"",a=o._geojsonTileLayer||o[s];if(!a)return;const n=t.a4(i&&i.filter),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<a.length;i++){const o=a.feature(i);if(n.needGeometry){const e=t.a5(o,!0);if(!n.filter(new t.z(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!n.filter(new t.z(this.tileID.overscaledZ),o))continue;const d=r.getId(o,s),_=new t.a6(o,l,c,h,d);_.tile=u,e.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const i=this.expirationTime;if(e.cacheControl){const i=t.a7(e.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const r=this.expirationTime-i;r?this.expirationTime=e+Math.max(r,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,t){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!t.style.hasLayer(r))continue;const o=this.buckets[r],s=o.layers[0].sourceLayer||"_geojsonTileLayer",a=i[s],n=e[s];if(!a||!n||0===Object.keys(n).length)continue;o.update(n,a,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=t&&t.style&&t.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(o)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<a.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(e){this.symbolFadeHoldUntil=a.now()+e;}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}}class ae{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const r=e.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const o={value:t,timeout:void 0};if(void 0!==i&&(o.timeout=setTimeout((()=>{this.remove(e,o);}),i)),this.data[r].push(o),this.order.push(r),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,r=void 0===t?0:this.data[i].indexOf(t),o=this.data[i][r];return this.data[i].splice(r,1),o.timeout&&clearTimeout(o.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(o.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const i in this.data)for(const r of this.data[i])e(r.value)||t.push(r);for(const e of t)this.remove(e.value.tileID,e);}}class ne{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(e,i,r){const o=String(i);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][o]=this.stateChanges[e][o]||{},t.e(this.stateChanges[e][o],r),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==o&&(this.deletedStates[e][t]=null);}else if(this.deletedStates[e]&&null===this.deletedStates[e][o]){this.deletedStates[e][o]={};for(const t in this.state[e][o])r[t]||(this.deletedStates[e][o][t]=null);}else for(const t in r)this.deletedStates[e]&&this.deletedStates[e][o]&&null===this.deletedStates[e][o][t]&&delete this.deletedStates[e][o][t];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const r=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][r]&&(this.deletedStates[e][r]=this.deletedStates[e][r]||{},this.deletedStates[e][r][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][r])for(i in this.deletedStates[e][r]={},this.stateChanges[e][r])this.deletedStates[e][r][i]=null;else this.deletedStates[e][r]=null;else this.deletedStates[e]=null;}getState(e,i){const r=String(i),o=t.e({},(this.state[e]||{})[r],(this.stateChanges[e]||{})[r]);if(null===this.deletedStates[e])return {};if(this.deletedStates[e]){const t=this.deletedStates[e][i];if(null===t)return {};for(const e in t)delete o[e];}return o}initializeTileState(e,t){e.setFeatureState(this.state,t);}coalesceChanges(e,i){const r={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const i={};for(const r in this.stateChanges[e])this.state[e][r]||(this.state[e][r]={}),t.e(this.state[e][r],this.stateChanges[e][r]),i[r]=this.state[e][r];r[e]=i;}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const i={};if(null===this.deletedStates[e])for(const t in this.state[e])i[t]={},this.state[e][t]={};else for(const t in this.deletedStates[e]){if(null===this.deletedStates[e][t])this.state[e][t]={};else for(const i of Object.keys(this.deletedStates[e][t]))delete this.state[e][t][i];i[t]=this.state[e][t];}r[e]=r[e]||{},t.e(r[e],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const t in e)e[t].setFeatureState(r,i);}}function le(e,t,i){const r=t.intersectsFrustum(e);if(!i)return r;const o=t.intersectsPlane(i);return 0===r||0===o?0:2===r&&2===o?2:1}function ce(e,i,r,o,s){let a=e;const n=Math.atan(i/r),l=Math.hypot(i,r);return a=e+t.a8(o/l/Math.max(.5,Math.cos(t.aa(s/2)))),a+=1*t.a8(Math.cos(n))/2,a+=t.ab(e-a,-0,0),a}function he(e,i){const r=(i.roundZoom?Math.round:Math.floor)(e.zoom+t.a8(e.tileSize/i.tileSize));return Math.max(0,r)}function ue(e,i){const r=e.getCameraFrustum(),o=e.getClippingPlane(),s=e.screenPointToMercatorCoordinate(e.getCameraPoint()),a=t.Y.fromLngLat(e.center,e.elevation);s.z=a.z+Math.cos(e.pitchInRadians)*e.cameraToCenterDistance/e.worldSize;const n=e.getCoveringTilesDetailsProvider(),l=n.allowVariableZoom(e,i),c=he(e,i),h=i.minzoom||0,u=void 0!==i.maxzoom?i.maxzoom:e.maxZoom,d=Math.min(Math.max(0,c),u),_=Math.pow(2,d),p=[_*s.x,_*s.y,0],m=[_*a.x,_*a.y,0],f=Math.hypot(a.x-s.x,a.y-s.y),g=Math.abs(a.z-s.z),v=Math.hypot(f,g),x=e=>({zoom:0,x:0,y:0,wrap:e,fullyVisible:!1}),b=[],y=[];if(e.renderWorldCopies&&n.allowWorldCopies())for(let e=1;e<=3;e++)b.push(x(-e)),b.push(x(e));for(b.push(x(0));b.length>0;){const _=b.pop(),f=_.x,x=_.y;let w=_.fullyVisible;const T={x:f,y:x,z:_.zoom},P=n.getTileAABB(T,_.wrap,e.elevation,i);if(!w){const e=le(r,P,o);if(0===e)continue;w=2===e;}const C=n.distanceToTile2d(s.x,s.y,T,P);let I=c;l&&(I=(i.calculateTileZoom||ce)(e.zoom+t.a8(e.tileSize/i.tileSize),C,g,v,e.fov)),I=(i.roundZoom?Math.round:Math.floor)(I),I=Math.max(0,I);const E=Math.min(I,u);if(_.wrap=n.getWrap(a,T,_.wrap),_.zoom>=E){if(_.zoom<h)continue;const e=d-_.zoom,r=p[0]-.5-(f<<e),o=p[1]-.5-(x<<e),s=i.reparseOverscaled?Math.max(_.zoom,I):_.zoom;y.push({tileID:new t.S(_.zoom===u?s:_.zoom,_.wrap,_.zoom,f,x),distanceSq:t.a9([m[0]-.5-f,m[1]-.5-x]),tileDistanceToCamera:Math.sqrt(r*r+o*o)});}else for(let e=0;e<4;e++)b.push({zoom:_.zoom+1,x:(f<<1)+e%2,y:(x<<1)+(e>>1),wrap:_.wrap,fullyVisible:w});}return y.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}class de extends t.E{constructor(e,t,i){super(),this.id=e,this.dispatcher=i,this.on("data",(e=>this._dataHandler(e))),this.on("dataloading",(()=>{this._sourceErrored=!1;})),this.on("error",(()=>{this._sourceErrored=this._source.loaded();})),this._source=((e,t,i,r)=>{const o=new(ee(t.type))(e,t,i,r);if(o.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${o.id}`);return o})(e,t,i,this),this._tiles={},this._cache=new ae(0,(e=>this._unloadTile(e))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new ne,this._didEmitContent=!1,this._updated=!1;}onAdd(e){this.map=e,this._maxTileCacheSize=e?e._maxTileCacheSize:null,this._maxTileCacheZoomLevels=e?e._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(e);}onRemove(e){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(e);}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return !0;if(!this._updated)return !1;for(const e in this._tiles){const t=this._tiles[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform,this.terrain);}_loadTile(e,i,r){return t._(this,void 0,void 0,(function*(){try{yield this._source.loadTile(e),this._tileLoaded(e,i,r);}catch(i){e.state="errored",404!==i.status?this._source.fire(new t.j(i,{tile:e})):this.update(this.transform,this.terrain);}}))}_unloadTile(e){this._source.unloadTile&&this._source.unloadTile(e);}_abortTile(e){this._source.abortTile&&this._source.abortTile(e),this._source.fire(new t.k("dataabort",{tile:e,coord:e.tileID,dataType:"source"}));}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager);}}getIds(){return Object.values(this._tiles).map((e=>e.tileID)).sort(_e).map((e=>e.key))}getRenderableIds(e){const i=[];for(const t in this._tiles)this._isIdRenderable(t,e)&&i.push(this._tiles[t]);return e?i.sort(((e,i)=>{const r=e.tileID,o=i.tileID,s=new t.P(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians),a=new t.P(o.canonical.x,o.canonical.y)._rotate(-this.transform.bearingInRadians);return r.overscaledZ-o.overscaledZ||a.y-s.y||a.x-s.x})).map((e=>e.tileID.key)):i.map((e=>e.tileID)).sort(_e).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return !!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())}reload(e){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)(e||"errored"!==this._tiles[t].state)&&this._reloadTile(t,"reloading");}}_reloadTile(e,i){return t._(this,void 0,void 0,(function*(){const t=this._tiles[e];t&&("loading"!==t.state&&(t.state=i),yield this._loadTile(t,e,i));}))}_tileLoaded(e,i,r){e.timeAdded=a.now(),"expired"===r&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(i,e),"raster-dem"===this.getSource().type&&e.dem&&this._backfillDEM(e),this._state.initializeTileState(e,this.map?this.map.painter:null),e.aborted||this._source.fire(new t.k("data",{dataType:"source",tile:e,coord:e.tileID}));}_backfillDEM(e){const t=this.getRenderableIds();for(let r=0;r<t.length;r++){const o=t[r];if(e.neighboringTiles&&e.neighboringTiles[o]){const t=this.getTileByID(o);i(e,t),i(t,e);}}function i(e,t){e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const r=t.tileID.canonical.y-e.tileID.canonical.y,o=Math.pow(2,e.tileID.canonical.z),s=t.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+o)?i+=o:1===Math.abs(i-o)&&(i-=o)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,r),e.neighboringTiles&&e.neighboringTiles[s]&&(e.neighboringTiles[s].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,r){for(const o in this._tiles){let s=this._tiles[o];if(r[o]||!s.hasData()||s.tileID.overscaledZ<=t||s.tileID.overscaledZ>i)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>t+1;){const e=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[e.key],s&&s.hasData()&&(a=e);}let n=a;for(;n.overscaledZ>t;)if(n=n.scaledTo(n.overscaledZ-1),e[n.key]||e[n.canonical.key]){r[a.key]=a;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),r=this._getLoadedTile(t);if(r)return r}}findLoadedSibling(e){return this._getLoadedTile(e)}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(e.wrapped().key)}updateCacheSize(e){const i=Math.ceil(e.width/this._source.tileSize)+1,r=Math.ceil(e.height/this._source.tileSize)+1,o=Math.floor(i*r*(null===this._maxTileCacheZoomLevels?t.a.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),s="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,o):o;this._cache.setMaxSize(s);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),e[r.tileID.key]=r;}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(e,this._tiles[e]);}}_updateCoveredAndRetainedTiles(e,t,i,r,o,s){const n={},l={},c=Object.keys(e),h=a.now();for(const i of c){const r=e[i],o=this._tiles[i];if(!o||0!==o.fadeEndTime&&o.fadeEndTime<=h)continue;const s=this.findLoadedParent(r,t),a=this.findLoadedSibling(r),c=s||a||null;c&&(this._addTile(c.tileID),n[c.tileID.key]=c.tileID),l[i]=r;}this._retainLoadedChildren(l,r,i,e);for(const t in n)e[t]||(this._coveredTiles[t]=!0,e[t]=n[t]);if(s){const t={},i={};for(const e of o)this._tiles[e.key].hasData()?t[e.key]=e:i[e.key]=e;for(const r in i){const o=i[r].children(this._source.maxzoom);this._tiles[o[0].key]&&this._tiles[o[1].key]&&this._tiles[o[2].key]&&this._tiles[o[3].key]&&(t[o[0].key]=e[o[0].key]=o[0],t[o[1].key]=e[o[1].key]=o[1],t[o[2].key]=e[o[2].key]=o[2],t[o[3].key]=e[o[3].key]=o[3],delete i[r]);}for(const r in i){const o=i[r],s=this.findLoadedParent(o,this._source.minzoom),a=this.findLoadedSibling(o),n=s||a||null;if(n){t[n.tileID.key]=e[n.tileID.key]=n.tileID;for(const e in t)t[e].isChildOf(n.tileID)&&delete t[e];}}for(const e in this._tiles)t[e]||(this._coveredTiles[e]=!0);}}update(e,i){if(!this._sourceLoaded||this._paused)return;let r;this.transform=e,this.terrain=i,this.updateCacheSize(e),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?r=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new t.S(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(r=ue(e,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:i,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(r=r.filter((e=>this._source.hasTile(e))))):r=[];const o=he(e,this._source),s=Math.max(o-de.maxOverzooming,this._source.minzoom),a=Math.max(o+de.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const e={};for(const t of r)if(t.canonical.z>this._source.minzoom){const i=t.scaledTo(t.canonical.z-1);e[i.key]=i;const r=t.scaledTo(Math.max(this._source.minzoom,Math.min(t.canonical.z,5)));e[r.key]=r;}r=r.concat(Object.values(e));}const n=0===r.length&&!this._updated&&this._didEmitContent;this._updated=!0,n&&this.fire(new t.k("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const l=this._updateRetainedTiles(r,o);pe(this._source.type)&&this._updateCoveredAndRetainedTiles(l,s,a,o,r,i);for(const e in l)this._tiles[e].clearFadeHold();const c=t.ac(this._tiles,l);for(const e of c){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(e);}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache();}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(e);}_updateRetainedTiles(e,t){var i;const r={},o={},s=Math.max(t-de.maxOverzooming,this._source.minzoom),a=Math.max(t+de.maxUnderzooming,this._source.minzoom),n={};for(const i of e){const e=this._addTile(i);r[i.key]=i,e.hasData()||t<this._source.maxzoom&&(n[i.key]=i);}this._retainLoadedChildren(n,t,a,r);for(const a of e){let e=this._tiles[a.key];if(e.hasData())continue;if(t+1>this._source.maxzoom){const e=a.children(this._source.maxzoom)[0],t=this.getTile(e);if(t&&t.hasData()){r[e.key]=e;continue}}else {const e=a.children(this._source.maxzoom);if(r[e[0].key]&&r[e[1].key]&&r[e[2].key]&&r[e[3].key])continue}let n=e.wasRequested();for(let t=a.overscaledZ-1;t>=s;--t){const s=a.scaledTo(t);if(o[s.key])break;if(o[s.key]=!0,e=this.getTile(s),!e&&n&&(e=this._addTile(s)),e){const t=e.hasData();if((t||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||n)&&(r[s.key]=s),n=e.wasRequested(),t)break}}}return r}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,r=this._tiles[e].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}t.push(r.key);const e=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;r=e;}for(const e of t)this._loadedParentTiles[e]=i;}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const e in this._tiles){const t=this._tiles[e].tileID,i=this._getLoadedTile(t);this._loadedSiblingTiles[t.key]=i;}}_addTile(e){let i=this._tiles[e.key];if(i)return i;i=this._cache.getAndRemove(e),i&&(this._setTileReloadTimer(e.key,i),i.tileID=e,this._state.initializeTileState(i,this.map?this.map.painter:null),this._cacheTimers[e.key]&&(clearTimeout(this._cacheTimers[e.key]),delete this._cacheTimers[e.key],this._setTileReloadTimer(e.key,i)));const r=i;return i||(i=new se(e,this._source.tileSize*e.overscaleFactor()),this._loadTile(i,e.key,i.state)),i.uses++,this._tiles[e.key]=i,r||this._source.fire(new t.k("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}_dataHandler(e){const t=e.sourceDataType;"source"===e.dataType&&"metadata"===t&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===t&&(this.reload(e.sourceDataChanged),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0);}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(e);this._cache.reset();}tilesIn(e,i,r){const o=[],s=this.transform;if(!s)return o;const a=r?s.getCameraQueryGeometry(e):e,n=e.map((e=>s.screenPointToMercatorCoordinate(e,this.terrain))),l=a.map((e=>s.screenPointToMercatorCoordinate(e,this.terrain))),c=this.getIds();let h=1/0,u=1/0,d=-1/0,_=-1/0;for(const e of l)h=Math.min(h,e.x),u=Math.min(u,e.y),d=Math.max(d,e.x),_=Math.max(_,e.y);for(let e=0;e<c.length;e++){const r=this._tiles[c[e]];if(r.holdingForFade())continue;const a=r.tileID,p=Math.pow(2,s.zoom-r.tileID.overscaledZ),m=i*r.queryPadding*t.X/r.tileSize/p,f=[a.getTilePoint(new t.Y(h,u)),a.getTilePoint(new t.Y(d,_))];if(f[0].x-m<t.X&&f[0].y-m<t.X&&f[1].x+m>=0&&f[1].y+m>=0){const e=n.map((e=>a.getTilePoint(e))),t=l.map((e=>a.getTilePoint(e)));o.push({tile:r,tileID:a,queryGeometry:e,cameraQueryGeometry:t,scale:p});}}return o}getVisibleCoordinates(e){const t=this.getRenderableIds(e).map((e=>this._tiles[e].tileID));return this.transform&&this.transform.populateCache(t),t}hasTransition(){if(this._source.hasTransition())return !0;if(pe(this._source.type)){const e=a.now();for(const t in this._tiles)if(this._tiles[t].fadeEndTime>=e)return !0}return !1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i);}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i);}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const r=this._tiles[e];r&&r.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}}function _e(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),r=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||r-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function pe(e){return "raster"===e||"image"===e||"video"===e}de.maxOverzooming=10,de.maxUnderzooming=3;class me{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(e){if(1===this.points.length)return this.points[0];e=t.ab(e,0,1);let i=1,r=this._distances[i];const o=e*this.paddedLength+this.padding;for(;r<o&&i<this._distances.length;)r=this._distances[++i];const s=i-1,a=this._distances[s],n=r-a,l=n>0?(o-a)/n:0;return this.points[s].mult(1-l).add(this.points[i].mult(l))}}function fe(e,t){let i=!0;return "always"===e||"never"!==e&&"never"!==t||(i=!1),i}class ge{constructor(e,t,i){const r=this.boxCells=[],o=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)r.push([]),o.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,r,o){this._forEachCell(t,i,r,o,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(o);}insertCircle(e,t,i,r){this._forEachCell(t-r,i-r,t+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(r);}_insertBoxCell(e,t,i,r,o,s){this.boxCells[o].push(s);}_insertCircleCell(e,t,i,r,o,s){this.circleCells[o].push(s);}_query(e,t,i,r,o,s,a){if(i<0||e>this.width||r<0||t>this.height)return [];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=r){if(o)return [{key:null,x1:e,y1:t,x2:i,y2:r}];for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],r=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-r,y1:i-r,x2:t+r,y2:i+r});}}else this._forEachCell(e,t,i,r,this._queryCell,n,{hitTest:o,overlapMode:s,seenUids:{box:{},circle:{}}},a);return n}query(e,t,i,r){return this._query(e,t,i,r,!1,null)}hitTest(e,t,i,r,o,s){return this._query(e,t,i,r,!0,o,s).length>0}hitTestCircle(e,t,i,r,o){const s=e-i,a=e+i,n=t-i,l=t+i;if(a<0||s>this.width||l<0||n>this.height)return !1;const c=[];return this._forEachCell(s,n,a,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},o),c.length>0}_queryCell(e,t,i,r,o,s,a,n){const{seenUids:l,hitTest:c,overlapMode:h}=a,u=this.boxCells[o];if(null!==u){const o=this.bboxes;for(const a of u)if(!l.box[a]){l.box[a]=!0;const u=4*a,d=this.boxKeys[a];if(e<=o[u+2]&&t<=o[u+3]&&i>=o[u+0]&&r>=o[u+1]&&(!n||n(d))&&(!c||!fe(h,d.overlapMode))&&(s.push({key:d,x1:o[u],y1:o[u+1],x2:o[u+2],y2:o[u+3]}),c))return !0}}const d=this.circleCells[o];if(null!==d){const o=this.circles;for(const a of d)if(!l.circle[a]){l.circle[a]=!0;const u=3*a,d=this.circleKeys[a];if(this._circleAndRectCollide(o[u],o[u+1],o[u+2],e,t,i,r)&&(!n||n(d))&&(!c||!fe(h,d.overlapMode))){const e=o[u],t=o[u+1],i=o[u+2];if(s.push({key:d,x1:e-i,y1:t-i,x2:e+i,y2:t+i}),c)return !0}}}return !1}_queryCellCircle(e,t,i,r,o,s,a,n){const{circle:l,seenUids:c,overlapMode:h}=a,u=this.boxCells[o];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t,r=this.boxKeys[t];if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!n||n(r))&&!fe(h,r.overlapMode))return s.push(!0),!0}}const d=this.circleCells[o];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t,r=this.circleKeys[t];if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!n||n(r))&&!fe(h,r.overlapMode))return s.push(!0),!0}}}_forEachCell(e,t,i,r,o,s,a,n){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(o.call(this,e,t,i,r,this.xCellCount*l+d,s,a,n))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,r,o,s){const a=r-e,n=o-t,l=i+s;return l*l>a*a+n*n}_circleAndRectCollide(e,t,i,r,o,s,a){const n=(s-r)/2,l=Math.abs(e-(r+n));if(l>n+i)return !1;const c=(a-o)/2,h=Math.abs(t-(o+c));if(h>c+i)return !1;if(l<=n||h<=c)return !0;const u=l-n,d=h-c;return u*u+d*d<=i*i}}function ve(e,i,o){const s=t.H();if(!e){const{vecSouth:e,vecEast:t}=be(i),o=r();o[0]=t[0],o[1]=t[1],o[2]=e[0],o[3]=e[1],a=o,(d=(l=(n=o)[0])*(u=n[3])-(h=n[2])*(c=n[1]))&&(a[0]=u*(d=1/d),a[1]=-c*d,a[2]=-h*d,a[3]=l*d),s[0]=o[0],s[1]=o[1],s[4]=o[2],s[5]=o[3];}var a,n,l,c,h,u,d;return t.K(s,s,[1/o,1/o,1]),s}function xe(e,i,r,o){if(e){const e=t.H();if(!i){const{vecSouth:t,vecEast:i}=be(r);e[0]=i[0],e[1]=i[1],e[4]=t[0],e[5]=t[1];}return t.K(e,e,[o,o,1]),e}return r.pixelsToClipSpaceMatrix}function be(e){const i=Math.cos(e.rollInRadians),r=Math.sin(e.rollInRadians),o=Math.cos(e.pitchInRadians),s=Math.cos(e.bearingInRadians),a=Math.sin(e.bearingInRadians),n=t.ad();n[0]=-s*o*r-a*i,n[1]=-a*o*r+s*i;const l=t.ae(n);l<1e-9?t.af(n):t.ag(n,n,1/l);const c=t.ad();c[0]=s*o*i-a*r,c[1]=a*o*i+s*r;const h=t.ae(c);return h<1e-9?t.af(c):t.ag(c,c,1/h),{vecEast:c,vecSouth:n}}function ye(e,i,r,o){let s;o?(s=[e,i,o(e,i),1],t.al(s,s,r)):(s=[e,i,0,1],je(s,s,r));const a=s[3];return {point:new t.P(s[0]/a,s[1]/a),signedDistanceFromCamera:a,isOccluded:!1}}function we(e,t){return .5+e/t*.5}function Te(e,t){return e.x>=-t[0]&&e.x<=t[0]&&e.y>=-t[1]&&e.y<=t[1]}function Pe(e,i,r,o,s,a,n,l,c,h,u,d,_){const p=r?e.textSizeData:e.iconSizeData,m=t.ah(p,i.transform.zoom),f=[256/i.width*2+1,256/i.height*2+1],g=r?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;g.clear();const v=e.lineVertexArray,x=r?e.text.placedSymbolArray:e.icon.placedSymbolArray,b=i.transform.width/i.transform.height;let y=!1;for(let r=0;r<x.length;r++){const w=x.get(r);if(w.hidden||w.writingMode===t.ai.vertical&&!y){Be(w.numGlyphs,g);continue}y=!1;const T=new t.P(w.anchorX,w.anchorY),P={getElevation:_,pitchedLabelPlaneMatrix:o,lineVertexArray:v,pitchWithMap:a,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:i.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:d},C=ze(w.anchorX,w.anchorY,P);if(!Te(C.point,f)){Be(w.numGlyphs,g);continue}const I=we(i.transform.cameraToCenterDistance,C.signedDistanceFromCamera),E=t.aj(p,m,w),M=a?E*i.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/I:E*I,S=Ee({projectionContext:P,pitchedLabelPlaneMatrixInverse:s,symbol:w,fontSize:M,flip:!1,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:b,rotateToLine:l});y=S.useVertical,(S.notEnoughRoom||y||S.needsFlipping&&Ee({projectionContext:P,pitchedLabelPlaneMatrixInverse:s,symbol:w,fontSize:M,flip:!0,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:b,rotateToLine:l}).notEnoughRoom)&&Be(w.numGlyphs,g);}r?e.text.dynamicLayoutVertexBuffer.updateData(g):e.icon.dynamicLayoutVertexBuffer.updateData(g);}function Ce(e,t,i,r,o,s,a,n){const l=s.glyphStartIndex+s.numGlyphs,c=s.lineStartIndex,h=s.lineStartIndex+s.lineLength,u=t.getoffsetX(s.glyphStartIndex),d=t.getoffsetX(l-1),_=ke(e*u,i,r,o,s.segment,c,h,n,a);if(!_)return null;const p=ke(e*d,i,r,o,s.segment,c,h,n,a);return p?n.projectionCache.anyProjectionOccluded?null:{first:_,last:p}:null}function Ie(e,i,r,o){return e===t.ai.horizontal&&Math.abs(r.y-i.y)>Math.abs(r.x-i.x)*o?{useVertical:!0}:(e===t.ai.vertical?i.y<r.y:i.x>r.x)?{needsFlipping:!0}:null}function Ee(e){const{projectionContext:i,pitchedLabelPlaneMatrixInverse:r,symbol:o,fontSize:s,flip:a,keepUpright:n,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=e,d=s/24,_=o.lineOffsetX*d,p=o.lineOffsetY*d;let m;if(o.numGlyphs>1){const e=o.glyphStartIndex+o.numGlyphs,t=o.lineStartIndex,s=o.lineStartIndex+o.lineLength,c=Ce(d,l,_,p,a,o,u,i);if(!c)return {notEnoughRoom:!0};const f=De(c.first.point.x,c.first.point.y,i,r),g=De(c.last.point.x,c.last.point.y,i,r);if(n&&!a){const e=Ie(o.writingMode,f,g,h);if(e)return e}m=[c.first];for(let r=o.glyphStartIndex+1;r<e-1;r++)m.push(ke(d*l.getoffsetX(r),_,p,a,o.segment,t,s,i,u));m.push(c.last);}else {if(n&&!a){const e=Re(i.tileAnchorPoint.x,i.tileAnchorPoint.y,i).point,s=o.lineStartIndex+o.segment+1,a=new t.P(i.lineVertexArray.getx(s),i.lineVertexArray.gety(s)),n=Re(a.x,a.y,i),l=n.signedDistanceFromCamera>0?n.point:Me(i.tileAnchorPoint,a,e,1,i),c=De(e.x,e.y,i,r),u=De(l.x,l.y,i,r),d=Ie(o.writingMode,c,u,h);if(d)return d}const e=ke(d*l.getoffsetX(o.glyphStartIndex),_,p,a,o.segment,o.lineStartIndex,o.lineStartIndex+o.lineLength,i,u);if(!e||i.projectionCache.anyProjectionOccluded)return {notEnoughRoom:!0};m=[e];}for(const e of m)t.ak(c,e.point,e.angle);return {}}function Me(e,t,i,r,o){const s=e.add(e.sub(t)._unit()),a=Re(s.x,s.y,o).point,n=i.sub(a);return i.add(n._mult(r/n.mag()))}function Se(e,i,r){const o=i.projectionCache;if(o.projections[e])return o.projections[e];const s=new t.P(i.lineVertexArray.getx(e),i.lineVertexArray.gety(e)),a=Re(s.x,s.y,i);if(a.signedDistanceFromCamera>0)return o.projections[e]=a.point,o.anyProjectionOccluded=o.anyProjectionOccluded||a.isOccluded,a.point;const n=e-r.direction;return Me(0===r.distanceFromAnchor?i.tileAnchorPoint:new t.P(i.lineVertexArray.getx(n),i.lineVertexArray.gety(n)),s,r.previousVertex,r.absOffsetX-r.distanceFromAnchor+1,i)}function Re(e,t,i){const r=e+i.translation[0],o=t+i.translation[1];let s;return i.pitchWithMap?(s=ye(r,o,i.pitchedLabelPlaneMatrix,i.getElevation),s.isOccluded=!1):(s=i.transform.projectTileCoordinates(r,o,i.unwrappedTileID,i.getElevation),s.point.x=(.5*s.point.x+.5)*i.width,s.point.y=(.5*-s.point.y+.5)*i.height),s}function De(e,i,r,o){if(r.pitchWithMap){const s=[e,i,0,1];return t.al(s,s,o),r.transform.projectTileCoordinates(s[0]/s[3],s[1]/s[3],r.unwrappedTileID,r.getElevation).point}return {x:e/r.width*2-1,y:i/r.height*2-1}}function ze(e,t,i){return i.transform.projectTileCoordinates(e,t,i.unwrappedTileID,i.getElevation)}function Ae(e,t,i){return e._unit()._perp()._mult(t*i)}function Le(e,i,r,o,s,a,n,l,c){if(l.projectionCache.offsets[e])return l.projectionCache.offsets[e];const h=r.add(i);if(e+c.direction<o||e+c.direction>=s)return l.projectionCache.offsets[e]=h,h;const u=Se(e+c.direction,l,c),d=Ae(u.sub(r),n,c.direction),_=r.add(d),p=u.add(d);return l.projectionCache.offsets[e]=t.am(a,h,_,p)||h,l.projectionCache.offsets[e]}function ke(e,t,i,r,o,s,a,n,l){const c=r?e-t:e+t;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let d,_=h>0?s+o:s+o+1;n.projectionCache.cachedAnchorPoint?d=n.projectionCache.cachedAnchorPoint:(d=Re(n.tileAnchorPoint.x,n.tileAnchorPoint.y,n).point,n.projectionCache.cachedAnchorPoint=d);let p,m,f=d,g=d,v=0,x=0;const b=Math.abs(c),y=[];let w;for(;v+x<=b;){if(_+=h,_<s||_>=a)return null;v+=x,g=f,m=p;const e={absOffsetX:b,direction:h,distanceFromAnchor:v,previousVertex:g};if(f=Se(_,n,e),0===i)y.push(g),w=f.sub(g);else {let t;const r=f.sub(g);t=0===r.mag()?Ae(Se(_+h,n,e).sub(f),i,h):Ae(r,i,h),m||(m=g.add(t)),p=Le(_,t,f,s,a,m,i,n,e),y.push(m),w=p.sub(m);}x=w.mag();}const T=w._mult((b-v)/x)._add(m||g),P=u+Math.atan2(f.y-g.y,f.x-g.x);return y.push(T),{point:T,angle:l?P:0,path:y}}const Fe=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function Be(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(Fe,3*e);}}function je(e,t,i){const r=t[0],o=t[1];return e[0]=i[0]*r+i[4]*o+i[12],e[1]=i[1]*r+i[5]*o+i[13],e[3]=i[3]*r+i[7]*o+i[15],e}const Oe=100;class Ne{constructor(e,t=new ge(e.width+200,e.height+200,25),i=new ge(e.width+200,e.height+200,25)){this.transform=e,this.grid=t,this.ignoredGrid=i,this.pitchFactor=Math.cos(e.pitch*Math.PI/180)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+Oe,this.screenBottomBoundary=e.height+Oe,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.perspectiveRatioCutoff=.6;}placeCollisionBox(e,t,i,r,o,s,a,n,l,c,h,u){const d=this.projectAndGetPerspectiveRatio(e.anchorPointX+n[0],e.anchorPointY+n[1],o,c,u),_=i*d.perspectiveRatio;let p;if(s||a)p=this._projectCollisionBox(e,_,r,o,s,a,n,d,c,h,u);else {const t=d.x+(h?h.x*_:0),i=d.y+(h?h.y*_:0);p={allPointsOccluded:!1,box:[t+e.x1*_,i+e.y1*_,t+e.x2*_,i+e.y2*_]};}const[m,f,g,v]=p.box,x=s?p.allPointsOccluded:d.isOccluded;let b=x;return b||(b=d.perspectiveRatio<this.perspectiveRatioCutoff),b||(b=!this.isInsideGrid(m,f,g,v)),b||"always"!==t&&this.grid.hitTest(m,f,g,v,t,l)?{box:[m,f,g,v],placeable:!1,offscreen:!1,occluded:x}:{box:[m,f,g,v],placeable:!0,offscreen:this.isOffscreen(m,f,g,v),occluded:x}}placeCollisionCircles(e,i,r,o,s,a,n,l,c,h,u,d,_,p){const m=[],f=new t.P(i.anchorX,i.anchorY),g=this.getPerspectiveRatio(f.x,f.y,a,p),v=(c?s*this.transform.getPitchedTextCorrection(i.anchorX,i.anchorY,a)/g:s*g)/t.as,x={getElevation:p,pitchedLabelPlaneMatrix:n,lineVertexArray:r,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:f,unwrappedTileID:a,width:this.transform.width,height:this.transform.height,translation:_},b=Ce(v,o,i.lineOffsetX*v,i.lineOffsetY*v,!1,i,!1,x);let y=!1,w=!1,T=!0;if(b){const i=.5*u*g+d,r=new t.P(-100,-100),o=new t.P(this.screenRightBoundary,this.screenBottomBoundary),s=new me,a=b.first,n=b.last;let _=[];for(let e=a.path.length-1;e>=1;e--)_.push(a.path[e]);for(let e=1;e<n.path.length;e++)_.push(n.path[e]);const p=2.5*i;if(c){const e=this.projectPathToScreenSpace(_,x);_=e.some((e=>e.signedDistanceFromCamera<=0))?[]:e.map((e=>e.point));}let f=[];if(_.length>0){const e=_[0].clone(),i=_[0].clone();for(let t=1;t<_.length;t++)e.x=Math.min(e.x,_[t].x),e.y=Math.min(e.y,_[t].y),i.x=Math.max(i.x,_[t].x),i.y=Math.max(i.y,_[t].y);f=e.x>=r.x&&i.x<=o.x&&e.y>=r.y&&i.y<=o.y?[_]:i.x<r.x||e.x>o.x||i.y<r.y||e.y>o.y?[]:t.ao([_],r.x,r.y,o.x,o.y);}for(const t of f){s.reset(t,.25*i);let r=0;r=s.length<=.5*i?1:Math.ceil(s.paddedLength/p)+1;for(let t=0;t<r;t++){const o=t/Math.max(r-1,1),a=s.lerp(o),n=a.x+Oe,c=a.y+Oe;m.push(n,c,i,0);const u=n-i,d=c-i,_=n+i,p=c+i;if(T=T&&this.isOffscreen(u,d,_,p),w=w||this.isInsideGrid(u,d,_,p),"always"!==e&&this.grid.hitTestCircle(n,c,i,e,h)&&(y=!0,!l))return {circles:[],offscreen:!1,collisionDetected:y}}}}return {circles:!l&&y||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:y}}projectPathToScreenSpace(e,i){const r=function(e,i){const r=t.H();return t.an(r,i.pitchedLabelPlaneMatrix),e.map((e=>{const t=ye(e.x,e.y,r,i.getElevation),o=i.transform.projectTileCoordinates(t.point.x,t.point.y,i.unwrappedTileID,i.getElevation);return o.point.x=(.5*o.point.x+.5)*i.width,o.point.y=(.5*-o.point.y+.5)*i.height,o}))}(e,i);return function(e){let t=0,i=0,r=0,o=0;for(let s=0;s<e.length;s++)e[s].isOccluded?(r=s+1,o=0):(o++,o>i&&(i=o,t=r));return e.slice(t,t+i)}(r)}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let r=1/0,o=1/0,s=-1/0,a=-1/0;for(const n of e){const e=new t.P(n.x+Oe,n.y+Oe);r=Math.min(r,e.x),o=Math.min(o,e.y),s=Math.max(s,e.x),a=Math.max(a,e.y),i.push(e);}const n=this.grid.query(r,o,s,a).concat(this.ignoredGrid.query(r,o,s,a)),l={},c={};for(const e of n){const r=e.key;if(void 0===l[r.bucketInstanceId]&&(l[r.bucketInstanceId]={}),l[r.bucketInstanceId][r.featureIndex])continue;const o=[new t.P(e.x1,e.y1),new t.P(e.x2,e.y1),new t.P(e.x2,e.y2),new t.P(e.x1,e.y2)];t.ap(i,o)&&(l[r.bucketInstanceId][r.featureIndex]=!0,void 0===c[r.bucketInstanceId]&&(c[r.bucketInstanceId]=[]),c[r.bucketInstanceId].push(r.featureIndex));}return c}insertCollisionBox(e,t,i,r,o,s){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:o,collisionGroupID:s,overlapMode:t},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,r,o,s){const a=i?this.ignoredGrid:this.grid,n={bucketInstanceId:r,featureIndex:o,collisionGroupID:s,overlapMode:t};for(let t=0;t<e.length;t+=4)a.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(e,i,r,o,s){if(s){let r;o?(r=[e,i,o(e,i),1],t.al(r,r,s)):(r=[e,i,0,1],je(r,r,s));const a=r[3];return {x:(r[0]/a+1)/2*this.transform.width+Oe,y:(-r[1]/a+1)/2*this.transform.height+Oe,perspectiveRatio:.5+this.transform.cameraToCenterDistance/a*.5,isOccluded:!1,signedDistanceFromCamera:a}}{const t=this.transform.projectTileCoordinates(e,i,r,o);return {x:(t.point.x+1)/2*this.transform.width+Oe,y:(1-t.point.y)/2*this.transform.height+Oe,perspectiveRatio:.5+this.transform.cameraToCenterDistance/t.signedDistanceFromCamera*.5,isOccluded:t.isOccluded,signedDistanceFromCamera:t.signedDistanceFromCamera}}}getPerspectiveRatio(e,t,i,r){const o=this.transform.projectTileCoordinates(e,t,i,r);return .5+this.transform.cameraToCenterDistance/o.signedDistanceFromCamera*.5}isOffscreen(e,t,i,r){return i<Oe||e>=this.screenRightBoundary||r<Oe||t>this.screenBottomBoundary}isInsideGrid(e,t,i,r){return i>=0&&e<this.gridRightBoundary&&r>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=t.aq([]);return t.J(e,e,[-100,-100,0]),e}_projectCollisionBox(e,i,r,o,s,a,n,l,c,h,u){let d=1,_=0,p=0,m=1;const f=e.anchorPointX+n[0],g=e.anchorPointY+n[1];if(a&&!s){const e=this.projectAndGetPerspectiveRatio(f+1,g,o,c,u),t=e.x-l.x,i=Math.atan((e.y-l.y)/t)+(t<0?Math.PI:0),r=Math.sin(i),s=Math.cos(i);d=s,_=r,p=-r,m=s;}else if(!a&&s){const e=be(this.transform);d=e.vecEast[0],_=e.vecEast[1],p=e.vecSouth[0],m=e.vecSouth[1];}let v=l.x,x=l.y,b=i;s&&(v=f,x=g,b=Math.pow(2,-(this.transform.zoom-r.overscaledZ)),b*=this.transform.getPitchedTextCorrection(f,g,o),h||(b*=t.ab(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(v+=d*h.x*b+p*h.y*b,x+=_*h.x*b+m*h.y*b);const y=e.x1*b,w=e.x2*b,T=(y+w)/2,P=e.y1*b,C=e.y2*b,I=(P+C)/2,E=[{offsetX:y,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:I},{offsetX:w,offsetY:C},{offsetX:T,offsetY:C},{offsetX:y,offsetY:C},{offsetX:y,offsetY:I}];let M=[];for(const{offsetX:e,offsetY:i}of E)M.push(new t.P(v+d*e+p*i,x+_*e+m*i));let S=!1;if(s){const e=M.map((e=>this.projectAndGetPerspectiveRatio(e.x,e.y,o,c,u)));S=e.some((e=>!e.isOccluded)),M=e.map((e=>new t.P(e.x,e.y)));}else S=!0;return {box:t.ar(M),allPointsOccluded:!S}}}class Ze{constructor(e,t,i,r){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):r&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class Ge{constructor(e,t,i,r,o){this.text=new Ze(e?e.text:null,t,i,o),this.icon=new Ze(e?e.icon:null,t,r,o);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Ue{constructor(e,t,i){this.text=e,this.icon=t,this.skipFade=i;}}class Ve{constructor(e,t,i,r,o){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=o;}}class qe{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function He(e,i,r,o,s){const{horizontalAlign:a,verticalAlign:n}=t.ay(e);return new t.P(-(a-.5)*i+o[0]*s,-(n-.5)*r+o[1]*s)}class We{constructor(e,t,i,r,o){this.transform=e.clone(),this.terrain=t,this.collisionIndex=new Ne(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new qe(r),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}_getTerrainElevationFunc(e){const t=this.terrain;return t?(i,r)=>t.getElevation(e,i,r):null}getBucketParts(e,i,r,o){const s=r.getBucket(i),a=r.latestFeatureIndex;if(!s||!a||i.id!==s.layerIds[0])return;const n=r.collisionBoxArray,l=s.layers[0].layout,c=s.layers[0].paint,h=Math.pow(2,this.transform.zoom-r.tileID.overscaledZ),u=r.tileSize/t.X,d=r.tileID.toUnwrapped(),_="map"===l.get("text-rotation-alignment"),p=t.at(r,1,this.transform.zoom),m=t.au(this.collisionIndex.transform,r,c.get("text-translate"),c.get("text-translate-anchor")),f=t.au(this.collisionIndex.transform,r,c.get("icon-translate"),c.get("icon-translate-anchor")),g=ve(_,this.transform,p);this.retainedQueryData[s.bucketInstanceId]=new Ve(s.bucketInstanceId,a,s.sourceLayerIndex,s.index,r.tileID);const v={bucket:s,layout:l,translationText:m,translationIcon:f,unwrappedTileID:d,pitchedLabelPlaneMatrix:g,scale:h,textPixelRatio:u,holdingForFade:r.holdingForFade(),collisionBoxArray:n,partiallyEvaluatedTextSize:t.ah(s.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(s.sourceID)};if(o)for(const t of s.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:o}=t;e.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:o,parameters:v});}else e.push({symbolInstanceStart:0,symbolInstanceEnd:s.symbolInstances.length,parameters:v});}attemptAnchorPlacement(e,i,r,o,s,a,n,l,c,h,u,d,_,p,m,f,g,v,x,b){const y=t.av[e.textAnchor],w=[e.textOffset0,e.textOffset1],T=He(y,r,o,w,s),P=this.collisionIndex.placeCollisionBox(i,d,l,c,h,n,a,f,u.predicate,x,T,b);if((!v||this.collisionIndex.placeCollisionBox(v,d,l,c,h,n,a,g,u.predicate,x,T,b).placeable)&&P.placeable){let e;if(this.prevPlacement&&this.prevPlacement.variableOffsets[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID].text&&(e=this.prevPlacement.variableOffsets[_.crossTileID].anchor),0===_.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[_.crossTileID]={textOffset:w,width:r,height:o,anchor:y,textBoxScale:s,prevAnchor:e},this.markUsedJustification(p,y,_,m),p.allowVerticalPlacement&&(this.markUsedOrientation(p,m,_),this.placedOrientations[_.crossTileID]=m),{shift:T,placedGlyphBoxes:P}}}placeLayerBucketPart(e,i,r){const{bucket:o,layout:s,translationText:a,translationIcon:n,unwrappedTileID:l,pitchedLabelPlaneMatrix:c,textPixelRatio:h,holdingForFade:u,collisionBoxArray:d,partiallyEvaluatedTextSize:_,collisionGroup:p}=e.parameters,m=s.get("text-optional"),f=s.get("icon-optional"),g=t.aw(s,"text-overlap","text-allow-overlap"),v="always"===g,x=t.aw(s,"icon-overlap","icon-allow-overlap"),b="always"===x,y="map"===s.get("text-rotation-alignment"),w="map"===s.get("text-pitch-alignment"),T="none"!==s.get("icon-text-fit"),P="viewport-y"===s.get("symbol-z-order"),C=v&&(b||!o.hasIconData()||f),I=b&&(v||!o.hasTextData()||m);!o.collisionArrays&&d&&o.deserializeCollisionBoxes(d);const E=this.retainedQueryData[o.bucketInstanceId].tileID,M=this._getTerrainElevationFunc(E),S=this.transform.getFastPathSimpleProjectionMatrix(E),R=(e,d,b)=>{var P,R;if(i[e.crossTileID])return;if(u)return void(this.placements[e.crossTileID]=new Ue(!1,!1,!1));let D=!1,z=!1,A=!0,L=null,k={box:null,placeable:!1,offscreen:null,occluded:!1},F={box:null,placeable:!1,offscreen:null},B=null,j=null,O=null,N=0,Z=0,G=0;d.textFeatureIndex?N=d.textFeatureIndex:e.useRuntimeCollisionCircles&&(N=e.featureIndex),d.verticalTextFeatureIndex&&(Z=d.verticalTextFeatureIndex);const U=d.textBox;if(U){const i=i=>{let r=t.ai.horizontal;if(o.allowVerticalPlacement&&!i&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,r=t,this.markUsedOrientation(o,r,e));}return r},s=(i,r)=>{if(o.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&d.verticalTextBox){for(const e of o.writingModes)if(e===t.ai.vertical?(k=r(),F=k):k=i(),k&&k.placeable)break}else k=i();},c=e.textAnchorOffsetStartIndex,u=e.textAnchorOffsetEndIndex;if(u===c){const r=(t,i)=>{const r=this.collisionIndex.placeCollisionBox(t,g,h,E,l,w,y,a,p.predicate,M,void 0,S);return r&&r.placeable&&(this.markUsedOrientation(o,i,e),this.placedOrientations[e.crossTileID]=i),r};s((()=>r(U,t.ai.horizontal)),(()=>{const i=d.verticalTextBox;return o.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&i?r(i,t.ai.vertical):{box:null,offscreen:null}})),i(k&&k.placeable);}else {let _=t.av[null===(R=null===(P=this.prevPlacement)||void 0===P?void 0:P.variableOffsets[e.crossTileID])||void 0===R?void 0:R.anchor];const m=(t,i,s)=>{const d=t.x2-t.x1,m=t.y2-t.y1,f=e.textBoxScale,v=T&&"never"===x?i:null;let b=null,P="never"===g?1:2,C="never";_&&P++;for(let i=0;i<P;i++){for(let i=c;i<u;i++){const r=o.textAnchorOffsets.get(i);if(_&&r.textAnchor!==_)continue;const c=this.attemptAnchorPlacement(r,t,d,m,f,y,w,h,E,l,p,C,e,o,s,a,n,v,M);if(c&&(b=c.placedGlyphBoxes,b&&b.placeable))return D=!0,L=c.shift,b}_?_=null:C=g;}return r&&!b&&(b={box:this.collisionIndex.placeCollisionBox(U,"always",h,E,l,w,y,a,p.predicate,M,void 0,S).box,offscreen:!1,placeable:!1,occluded:!1}),b};s((()=>m(U,d.iconBox,t.ai.horizontal)),(()=>{const i=d.verticalTextBox;return o.allowVerticalPlacement&&(!k||!k.placeable)&&e.numVerticalGlyphVertices>0&&i?m(i,d.verticalIconBox,t.ai.vertical):{box:null,occluded:!0,offscreen:null}})),k&&(D=k.placeable,A=k.offscreen);const f=i(k&&k.placeable);if(!D&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(o,t.anchor,e,f));}}}if(B=k,D=B&&B.placeable,A=B&&B.offscreen,e.useRuntimeCollisionCircles){const i=o.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),n=t.aj(o.textSizeData,_,i),h=s.get("text-padding");j=this.collisionIndex.placeCollisionCircles(g,i,o.lineVertexArray,o.glyphOffsetArray,n,l,c,r,w,p.predicate,e.collisionCircleDiameter,h,a,M),j.circles.length&&j.collisionDetected&&!r&&t.w("Collisions detected, but collision boxes are not shown"),D=v||j.circles.length>0&&!j.collisionDetected,A=A&&j.offscreen;}if(d.iconFeatureIndex&&(G=d.iconFeatureIndex),d.iconBox){const e=e=>this.collisionIndex.placeCollisionBox(e,x,h,E,l,w,y,n,p.predicate,M,T&&L?L:void 0,S);F&&F.placeable&&d.verticalIconBox?(O=e(d.verticalIconBox),z=O.placeable):(O=e(d.iconBox),z=O.placeable),A=A&&O.offscreen;}const V=m||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,q=f||0===e.numIconVertices;V||q?q?V||(z=z&&D):D=z&&D:z=D=z&&D;const H=z&&O.placeable;if(D&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,g,s.get("text-ignore-placement"),o.bucketInstanceId,F&&F.placeable&&Z?Z:N,p.ID),H&&this.collisionIndex.insertCollisionBox(O.box,x,s.get("icon-ignore-placement"),o.bucketInstanceId,G,p.ID),j&&D&&this.collisionIndex.insertCollisionCircles(j.circles,g,s.get("text-ignore-placement"),o.bucketInstanceId,N,p.ID),r&&this.storeCollisionData(o.bucketInstanceId,b,d,B,O,j),0===e.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===o.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[e.crossTileID]=new Ue((D||C)&&!(null==B?void 0:B.occluded),(z||I)&&!(null==O?void 0:O.occluded),A||o.justReloaded),i[e.crossTileID]=!0;};if(P){if(0!==e.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const t=o.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let e=t.length-1;e>=0;--e){const i=t[e];R(o.symbolInstances.get(i),o.collisionArrays[i],i);}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)R(o.symbolInstances.get(t),o.collisionArrays[t],t);o.justReloaded=!1;}storeCollisionData(e,t,i,r,o,s){if(i.textBox||i.iconBox){let s,a;this.collisionBoxArrays.has(e)?s=this.collisionBoxArrays.get(e):(s=new Map,this.collisionBoxArrays.set(e,s)),s.has(t)?a=s.get(t):(a={text:null,icon:null},s.set(t,a)),i.textBox&&(a.text=r.box),i.iconBox&&(a.icon=o.box);}if(s){let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=[]);for(let e=0;e<s.circles.length;e+=4)t.push(s.circles[e+0]-Oe),t.push(s.circles[e+1]-Oe),t.push(s.circles[e+2]),t.push(s.collisionDetected?1:0);}}markUsedJustification(e,i,r,o){let s;s=o===t.ai.vertical?r.verticalPlacedTextSymbolIndex:{left:r.leftJustifiedTextSymbolIndex,center:r.centerJustifiedTextSymbolIndex,right:r.rightJustifiedTextSymbolIndex}[t.ax(i)];const a=[r.leftJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.rightJustifiedTextSymbolIndex,r.verticalPlacedTextSymbolIndex];for(const t of a)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=s>=0&&t!==s?0:r.crossTileID);}markUsedOrientation(e,i,r){const o=i===t.ai.horizontal||i===t.ai.horizontalOnly?i:0,s=i===t.ai.vertical?i:0,a=[r.leftJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.rightJustifiedTextSymbolIndex];for(const t of a)e.text.placedSymbolArray.get(t).placedOrientation=o;r.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).placedOrientation=s);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const r=t?t.symbolFadeChange(e):1,o=t?t.opacities:{},s=t?t.variableOffsets:{},a=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],s=o[e];s?(this.opacities[e]=new Ge(s,r,t.text,t.icon),i=i||t.text!==s.text.placed||t.icon!==s.icon.placed):(this.opacities[e]=new Ge(null,r,t.text,t.icon,t.skipFade),i=i||t.text||t.icon);}for(const e in o){const t=o[e];if(!this.opacities[e]){const o=new Ge(t,r,!1,!1);o.isHidden()||(this.opacities[e]=o,i=i||t.text.placed||t.icon.placed);}}for(const e in s)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=s[e]);for(const e in a)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=a[e]);if(t&&void 0===t.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,r.tileID,i,r.collisionBoxArray);}}updateBucketOpacities(e,i,r,o){e.hasTextData()&&(e.text.opacityVertexArray.clear(),e.text.hasVisibleVertices=!1),e.hasIconData()&&(e.icon.opacityVertexArray.clear(),e.icon.hasVisibleVertices=!1),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const s=e.layers[0],a=s.layout,n=new Ge(null,0,!1,!1,!0),l=a.get("text-allow-overlap"),c=a.get("icon-allow-overlap"),h=s._unevaluatedLayout.hasValue("text-variable-anchor")||s._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===a.get("text-rotation-alignment"),d="map"===a.get("text-pitch-alignment"),_="none"!==a.get("icon-text-fit"),p=new Ge(null,0,l&&(c||!e.hasIconData()||a.get("icon-optional")),c&&(l||!e.hasTextData()||a.get("text-optional")),!0);!e.collisionArrays&&o&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(o);const m=(e,t,i)=>{for(let r=0;r<t/4;r++)e.opacityVertexArray.emplaceBack(i);e.hasVisibleVertices=e.hasVisibleVertices||i!==rt;},f=this.collisionBoxArrays.get(e.bucketInstanceId);for(let i=0;i<e.symbolInstances.length;i++){const o=e.symbolInstances.get(i),{numHorizontalGlyphVertices:s,numVerticalGlyphVertices:a,crossTileID:l}=o;let c=this.opacities[l];r[l]?c=n:c||(c=p,this.opacities[l]=c),r[l]=!0;const g=o.numIconVertices>0,v=this.placedOrientations[o.crossTileID],x=v===t.ai.vertical,b=v===t.ai.horizontal||v===t.ai.horizontalOnly;if(s>0||a>0){const t=it(c.text);m(e.text,s,x?rt:t),m(e.text,a,b?rt:t);const i=c.text.isHidden();[o.rightJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.leftJustifiedTextSymbolIndex].forEach((t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||x?1:0);})),o.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(o.verticalPlacedTextSymbolIndex).hidden=i||b?1:0);const r=this.variableOffsets[o.crossTileID];r&&this.markUsedJustification(e,r.anchor,o,v);const n=this.placedOrientations[o.crossTileID];n&&(this.markUsedJustification(e,"left",o,n),this.markUsedOrientation(e,n,o));}if(g){const t=it(c.icon),i=!(_&&o.verticalPlacedIconSymbolIndex&&x);o.placedIconSymbolIndex>=0&&(m(e.icon,o.numIconVertices,i?t:rt),e.icon.placedSymbolArray.get(o.placedIconSymbolIndex).hidden=c.icon.isHidden()),o.verticalPlacedIconSymbolIndex>=0&&(m(e.icon,o.numVerticalIconVertices,i?rt:t),e.icon.placedSymbolArray.get(o.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden());}const y=f&&f.has(i)?f.get(i):{text:null,icon:null};if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const r=e.collisionArrays[i];if(r){let i=new t.P(0,0);if(r.textBox||r.verticalTextBox){let t=!0;if(h){const e=this.variableOffsets[l];e?(i=He(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),u&&i._rotate(d?-this.transform.bearingInRadians:this.transform.bearingInRadians)):t=!1;}if(r.textBox||r.verticalTextBox){let o;r.textBox&&(o=x),r.verticalTextBox&&(o=b),Xe(e.textCollisionBox.collisionVertexArray,c.text.placed,!t||o,y.text,i.x,i.y);}}if(r.iconBox||r.verticalIconBox){const t=Boolean(!b&&r.verticalIconBox);let o;r.iconBox&&(o=t),r.verticalIconBox&&(o=!t),Xe(e.iconCollisionBox.collisionVertexArray,c.icon.placed,o,y.icon,_?i.x:0,_?i.y:0);}}}}if(e.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.text.opacityVertexArray.length!==e.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${e.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${e.text.layoutVertexArray.length}) / 4`);if(e.icon.opacityVertexArray.length!==e.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${e.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${e.icon.layoutVertexArray.length}) / 4`);e.bucketInstanceId in this.collisionCircleArrays&&(e.collisionCircleArray=this.collisionCircleArrays[e.bucketInstanceId],delete this.collisionCircleArrays[e.bucketInstanceId]);}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function Xe(e,t,i,r,o,s){r&&0!==r.length||(r=[0,0,0,0]);const a=r[0]-Oe,n=r[1]-Oe,l=r[2]-Oe,c=r[3]-Oe;e.emplaceBack(t?1:0,i?1:0,o||0,s||0,a,n),e.emplaceBack(t?1:0,i?1:0,o||0,s||0,l,n),e.emplaceBack(t?1:0,i?1:0,o||0,s||0,l,c),e.emplaceBack(t?1:0,i?1:0,o||0,s||0,a,c);}const $e=Math.pow(2,25),Ke=Math.pow(2,24),Ye=Math.pow(2,17),Je=Math.pow(2,16),Qe=Math.pow(2,9),et=Math.pow(2,8),tt=Math.pow(2,1);function it(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*$e+t*Ke+i*Ye+t*Je+i*Qe+t*et+i*tt+t}const rt=0;class ot{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&!e.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,r,o){const s=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(s,r,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,o())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,s.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<s.length;)if(t.placeLayerBucketPart(s[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,o())return !0;return !1}}class st{constructor(e,t,i,r,o,s,a,n){this.placement=new We(e,t,s,a,n),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(e,t,i){const r=a.now(),o=()=>!this._forceFullPlacement&&a.now()-r>2;for(;this._currentPlacementIndex>=0;){const r=t[e[this._currentPlacementIndex]],s=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=s)&&(!r.maxzoom||r.maxzoom>s)){if(this._inProgressLayer||(this._inProgressLayer=new ot(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,o))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const at=512/t.X/2;class nt{constructor(e,i,r){this.tileID=e,this.bucketInstanceId=r,this._symbolsByKey={};const o=new Map;for(let e=0;e<i.length;e++){const t=i.get(e),r=t.key,s=o.get(r);s?s.push(t):o.set(r,[t]);}for(const[e,i]of o){const r={positions:i.map((e=>({x:Math.floor(e.anchorX*at),y:Math.floor(e.anchorY*at)}))),crossTileIDs:i.map((e=>e.crossTileID))};if(r.positions.length>128){const e=new t.az(r.positions.length,16,Uint16Array);for(const{x:t,y:i}of r.positions)e.add(t,i);e.finish(),delete r.positions,r.index=e;}this._symbolsByKey[e]=r;}}getScaledCoordinates(e,i){const{x:r,y:o,z:s}=this.tileID.canonical,{x:a,y:n,z:l}=i.canonical,c=at/Math.pow(2,l-s),h=(n*t.X+e.anchorY)*c,u=o*t.X*at;return {x:Math.floor((a*t.X+e.anchorX)*c-r*t.X*at),y:Math.floor(h-u)}}findMatches(e,t,i){const r=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let o=0;o<e.length;o++){const s=e.get(o);if(s.crossTileID)continue;const a=this._symbolsByKey[s.key];if(!a)continue;const n=this.getScaledCoordinates(s,t);if(a.index){const e=a.index.range(n.x-r,n.y-r,n.x+r,n.y+r).sort();for(const t of e){const e=a.crossTileIDs[t];if(!i[e]){i[e]=!0,s.crossTileID=e;break}}}else if(a.positions)for(let e=0;e<a.positions.length;e++){const t=a.positions[e],o=a.crossTileIDs[e];if(Math.abs(t.x-n.x)<=r&&Math.abs(t.y-n.y)<=r&&!i[o]){i[o]=!0,s.crossTileID=o;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:e})=>e))}}class lt{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class ct{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],r={};for(const e in i){const o=i[e];o.tileID=o.tileID.unwrapTo(o.tileID.wrap+t),r[o.tileID.key]=o;}this.indexes[e]=r;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const r=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const o=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in o){const s=o[i];s.tileID.isChildOf(e)&&s.findMatches(t.symbolInstances,e,r);}else {const s=o[e.scaledTo(Number(i)).key];s&&s.findMatches(t.symbolInstances,e,r);}}for(let e=0;e<t.symbolInstances.length;e++){const o=t.symbolInstances.get(e);o.crossTileID||(o.crossTileID=i.generate(),r[o.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new nt(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.getCrossTileIDsLists())for(const t of i)delete this.usedCrossTileIDs[e][t];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const r=this.indexes[i];for(const o in r)e[r[o].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[o]),delete r[o],t=!0);}return t}}class ht{constructor(){this.layerIndexes={},this.crossTileIDs=new lt,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i){let r=this.layerIndexes[e.id];void 0===r&&(r=this.layerIndexes[e.id]=new ct);let o=!1;const s={};r.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,t,this.crossTileIDs)&&(o=!0),s[t.bucketInstanceId]=!0);}return r.removeStaleBuckets(s)&&(o=!0),o}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}var ut="void main() {fragColor=vec4(1.0);}";const dt={prelude:_t("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:_t("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:_t("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:_t("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:_t("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:_t("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:_t(ut,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:_t("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:_t("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:_t("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:_t("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:_t("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:_t(ut,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:_t("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:_t("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:_t("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:_t("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:_t("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:_t("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:_t("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))/pow(2.0,exaggeration+(19.2562-u_zoom));fragColor=clamp(vec4(deriv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:_t("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;\n#define PI 3.141592653589793\nvoid main() {vec4 pixel=texture(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:_t("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:_t("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:_t("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:_t("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:_t("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:_t("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:_t("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:_t("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:_t("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:_t("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:_t("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:_t("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:_t("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:_t("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function _t(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=t.match(/in ([\w]+) ([\w]+)/g),o=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),a=s?s.concat(o):o,n={};return {fragmentSource:e=e.replace(i,((e,t,i,r,o)=>(n[o]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${o}\nin ${i} ${r} ${o};\n#else\nuniform ${i} ${r} u_${o};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${o}\n    ${i} ${r} ${o} = u_${o};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,r,o)=>{const s="float"===r?"vec2":"vec4",a=o.match(/color/)?"color":s;return n[o]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${o}\nuniform lowp float u_${o}_t;\nin ${i} ${s} a_${o};\nout ${i} ${r} ${o};\n#else\nuniform ${i} ${r} u_${o};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${o}\n    ${o} = a_${o};\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${o}\n    ${o} = unpack_mix_${a}(a_${o}, u_${o}_t);\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${o}\nuniform lowp float u_${o}_t;\nin ${i} ${s} a_${o};\n#else\nuniform ${i} ${r} u_${o};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${o}\n    ${i} ${r} ${o} = a_${o};\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${o}\n    ${i} ${r} ${o} = unpack_mix_${a}(a_${o}, u_${o}_t);\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`})),staticAttributes:r,staticUniforms:a}}class pt{constructor(e,t,i){this.vertexBuffer=e,this.indexBuffer=t,this.segments=i;}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null;}}var mt=t.aA([{name:"a_pos",type:"Int16",components:2}]);const ft="#define PROJECTION_MERCATOR",gt="mercator";class vt{constructor(){this._cachedMesh=null;}get name(){return "mercator"}get useSubdivision(){return !1}get shaderVariantName(){return gt}get shaderDefine(){return ft}get shaderPreludeCode(){return dt.projectionMercator}get vertexShaderPreludeCode(){return dt.projectionMercator.vertexSource}get subdivisionGranularity(){return t.aB.noSubdivision}get useGlobeControls(){return !1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(e){}getMeshFromTileID(e,i,r,o,s){if(this._cachedMesh)return this._cachedMesh;const a=new t.aC;a.emplaceBack(0,0),a.emplaceBack(t.X,0),a.emplaceBack(0,t.X),a.emplaceBack(t.X,t.X);const n=e.createVertexBuffer(a,mt.members),l=t.aD.simpleSegment(0,0,4,2),c=new t.aE;c.emplaceBack(1,0,2),c.emplaceBack(1,2,3);const h=e.createIndexBuffer(c);return this._cachedMesh=new pt(n,h,l),this._cachedMesh}recalculate(){}hasTransition(){return !1}setErrorQueryLatitudeDegrees(e){}}function xt(e,i){const r=t.ab(i.lat,-85.051129,t.aF);return new t.P(t.O(i.lng)*e,t.Q(r)*e)}function bt(e,i){return new t.Y(i.x/e,i.y/e).toLngLat()}function yt(e){return e.cameraToCenterDistance*Math.min(.85*Math.tan(t.aa(90-e.pitch)),Math.tan(t.aa(89.25-e.pitch)))}function wt(e,i){const r=e.canonical,o=i/t.aG(r.z),s=r.x+Math.pow(2,r.z)*e.wrap,a=t.aq(new Float64Array(16));return t.J(a,a,[s*o,r.y*o,0]),t.K(a,a,[o/t.X,o/t.X,1]),a}function Tt(e,i,r,o,s){const a=t.Y.fromLngLat(e,i),n=s*t.aH(1,e.lat),l=n*Math.cos(t.aa(r)),c=Math.sqrt(n*n-l*l),h=c*Math.sin(t.aa(-o)),u=c*Math.cos(t.aa(-o));return new t.Y(a.x+h,a.y+u,a.z+l)}class Pt{constructor(e=0,t=0,i=0,r=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=r;}interpolate(e,i,r){return null!=i.top&&null!=e.top&&(this.top=t.y.number(e.top,i.top,r)),null!=i.bottom&&null!=e.bottom&&(this.bottom=t.y.number(e.bottom,i.bottom,r)),null!=i.left&&null!=e.left&&(this.left=t.y.number(e.left,i.left,r)),null!=i.right&&null!=e.right&&(this.right=t.y.number(e.right,i.right,r)),this}getCenter(e,i){const r=t.ab((this.left+e-this.right)/2,0,e),o=t.ab((this.top+i-this.bottom)/2,0,i);return new t.P(r,o)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Pt(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Ct(e,t){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}function It(e){return Math.max(0,Math.floor(e))}class Et{constructor(e,i,r,o,s,a){this._callbacks=e,this._tileSize=512,this._renderWorldCopies=void 0===a||!!a,this._minZoom=i||0,this._maxZoom=r||22,this._minPitch=null==o?0:o,this._maxPitch=null==s?60:s,this.setMaxBounds(),this._width=0,this._height=0,this._center=new t.N(0,0),this._elevation=0,this._zoom=0,this._tileZoom=It(this._zoom),this._scale=t.aG(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new Pt,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0;}apply(e,i,r){this._latRange=e.latRange,this._lngRange=e.lngRange,this._width=e.width,this._height=e.height,this._center=e.center,this._elevation=e.elevation,this._minElevationForCurrentTile=e.minElevationForCurrentTile,this._zoom=e.zoom,this._tileZoom=It(this._zoom),this._scale=t.aG(this._zoom),this._bearingInRadians=e.bearingInRadians,this._fovInRadians=e.fovInRadians,this._pitchInRadians=e.pitchInRadians,this._rollInRadians=e.rollInRadians,this._unmodified=e.unmodified,this._edgeInsets=new Pt(e.padding.top,e.padding.bottom,e.padding.left,e.padding.right),this._minZoom=e.minZoom,this._maxZoom=e.maxZoom,this._minPitch=e.minPitch,this._maxPitch=e.maxPitch,this._renderWorldCopies=e.renderWorldCopies,this._cameraToCenterDistance=e.cameraToCenterDistance,this._nearZ=e.nearZ,this._farZ=e.farZ,this._autoCalculateNearFarZ=!r&&e.autoCalculateNearFarZ,i&&this._constrain(),this._calcMatrices();}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(e){this._minElevationForCurrentTile=e;}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(e){this._minZoom!==e&&(this._minZoom=e,this.setZoom(this.getConstrained(this._center,this.zoom).zoom));}get maxZoom(){return this._maxZoom}setMaxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.setZoom(this.getConstrained(this._center,this.zoom).zoom));}get minPitch(){return this._minPitch}setMinPitch(e){this._minPitch!==e&&(this._minPitch=e,this.setPitch(Math.max(this.pitch,e)));}get maxPitch(){return this._maxPitch}setMaxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.setPitch(Math.min(this.pitch,e)));}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new t.P(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(e){const i=t.aI(e,-180,180)*Math.PI/180;var o,s,a,n,l,c,h,u,d;this._bearingInRadians!==i&&(this._unmodified=!1,this._bearingInRadians=i,this._calcMatrices(),this._rotationMatrix=r(),o=this._rotationMatrix,a=-this._bearingInRadians,n=(s=this._rotationMatrix)[0],l=s[1],c=s[2],h=s[3],u=Math.sin(a),d=Math.cos(a),o[0]=n*d+c*u,o[1]=l*d+h*u,o[2]=n*-u+c*d,o[3]=l*-u+h*d);}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(e){const i=t.ab(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==i&&(this._unmodified=!1,this._pitchInRadians=i,this._calcMatrices());}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(e){const t=e/180*Math.PI;this._rollInRadians!==t&&(this._unmodified=!1,this._rollInRadians=t,this._calcMatrices());}get fovInRadians(){return this._fovInRadians}get fov(){return t.aJ(this._fovInRadians)}setFov(e){e=t.ab(e,.1,150),this.fov!==e&&(this._unmodified=!1,this._fovInRadians=t.aa(e),this._calcMatrices());}get zoom(){return this._zoom}setZoom(e){const i=this.getConstrained(this._center,e).zoom;this._zoom!==i&&(this._unmodified=!1,this._zoom=i,this._tileZoom=Math.max(0,Math.floor(i)),this._scale=t.aG(i),this._constrain(),this._calcMatrices());}get center(){return this._center}setCenter(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._constrain(),this._calcMatrices());}get elevation(){return this._elevation}setElevation(e){e!==this._elevation&&(this._elevation=e,this._constrain(),this._calcMatrices());}get padding(){return this._edgeInsets.toJSON()}setPadding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(e,t){this._autoCalculateNearFarZ=!1,this._nearZ=e,this._farZ=t,this._calcMatrices();}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices();}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}resize(e,t,i=!0){this._width=e,this._height=t,i&&this._constrain(),this._calcMatrices();}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new V([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(e){e?(this._lngRange=[e.getWest(),e.getEast()],this._latRange=[e.getSouth(),e.getNorth()],this._constrain()):(this._lngRange=null,this._latRange=[-85.051129,t.aF]);}getConstrained(e,t){return this._callbacks.getConstrained(e,t)}getCameraQueryGeometry(e,i){if(1===i.length)return [i[0],e];{let r=e.x,o=e.y,s=e.x,a=e.y;for(const e of i)r=Math.min(r,e.x),o=Math.min(o,e.y),s=Math.max(s,e.x),a=Math.max(a,e.y);return [new t.P(r,o),new t.P(s,o),new t.P(s,a),new t.P(r,a),new t.P(r,o)]}}_constrain(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const e=this._unmodified,{center:t,zoom:i}=this.getConstrained(this.center,this.zoom);this.setCenter(t),this.setZoom(i),this._unmodified=e,this._constraining=!1;}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let e=t.aq(new Float64Array(16));t.K(e,e,[this._width/2,-this._height/2,1]),t.J(e,e,[1,-1,0]),this._clipSpaceToPixelsMatrix=e,e=t.aq(new Float64Array(16)),t.K(e,e,[1,-1,1]),t.J(e,e,[-1,-1,0]),t.K(e,e,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=e,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height;}this._callbacks.calcMatrices();}calculateCenterFromCameraLngLatAlt(e,i,r,o){const s=void 0!==r?r:this.bearing,a=o=void 0!==o?o:this.pitch,n=t.Y.fromLngLat(e,i),l=-Math.cos(t.aa(a)),c=Math.sin(t.aa(a)),h=c*Math.sin(t.aa(s)),u=-c*Math.cos(t.aa(s));let d=this.elevation;const _=i-d;let p;l*_>=0||Math.abs(l)<.1?(p=1e4,d=i+p*l):p=-_/l;let m,f,g=t.aK(1,n.y),v=0;do{if(v+=1,v>10)break;f=p/g,m=new t.Y(n.x+h*f,n.y+u*f),g=1/m.meterInMercatorCoordinateUnits();}while(Math.abs(p-f*g)>1e-12);return {center:m.toLngLat(),elevation:d,zoom:t.a8(this.height/2/Math.tan(this.fovInRadians/2)/f/this.tileSize)}}recalculateZoomAndCenter(e){if(this.elevation-e==0)return;const i=t.aH(1,this.center.lat)*this.worldSize,r=this.cameraToCenterDistance/i,o=t.Y.fromLngLat(this.center,this.elevation),s=Tt(this.center,this.elevation,this.pitch,this.bearing,r);this._elevation=e;const a=this.calculateCenterFromCameraLngLatAlt(s.toLngLat(),t.aK(s.z,o.y),this.bearing,this.pitch);this._elevation=a.elevation,this._center=a.center,this.setZoom(a.zoom);}getCameraPoint(){const e=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new t.P(e*Math.sin(this.rollInRadians),e*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const e=t.aH(1,this.center.lat)*this.worldSize;return Tt(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/e).toLngLat()}getMercatorTileCoordinates(e){if(!e)return [0,0,1,1];const i=e.canonical.z>=0?1<<e.canonical.z:Math.pow(2,e.canonical.z);return [e.canonical.x/i,e.canonical.y/i,1/i/t.X,1/i/t.X]}}class Mt{constructor(e,i){this.min=e,this.max=i,this.center=t.aL([],t.aM([],this.min,this.max),.5);}quadrant(e){const i=[e%2==0,e<2],r=t.aN(this.min),o=t.aN(this.max);for(let e=0;e<i.length;e++)r[e]=i[e]?this.min[e]:this.center[e],o[e]=i[e]?this.center[e]:this.max[e];return o[2]=this.max[2],new Mt(r,o)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}intersectsFrustum(e){let t=!0;for(let i=0;i<e.planes.length;i++){const r=this.intersectsPlane(e.planes[i]);if(0===r)return 0;1===r&&(t=!1);}return t?2:e.aabb.min[0]>this.max[0]||e.aabb.min[1]>this.max[1]||e.aabb.min[2]>this.max[2]||e.aabb.max[0]<this.min[0]||e.aabb.max[1]<this.min[1]||e.aabb.max[2]<this.min[2]?0:1}intersectsPlane(e){let t=e[3],i=e[3];for(let r=0;r<3;r++)e[r]>0?(t+=e[r]*this.min[r],i+=e[r]*this.max[r]):(i+=e[r]*this.min[r],t+=e[r]*this.max[r]);return t>=0?2:i<0?0:1}}class St{distanceToTile2d(e,t,i,r){const o=r.distanceX([e,t]),s=r.distanceY([e,t]);return Math.hypot(o,s)}getWrap(e,t,i){return i}getTileAABB(e,i,r,o){var s,a;let n=r,l=r;if(o.terrain){const c=new t.S(e.z,i,e.z,e.x,e.y),h=o.terrain.getMinMaxElevation(c);n=null!==(s=h.minElevation)&&void 0!==s?s:r,l=null!==(a=h.maxElevation)&&void 0!==a?a:r;}const c=1<<e.z;return new Mt([i+e.x/c,e.y/c,n],[i+(e.x+1)/c,(e.y+1)/c,l])}allowVariableZoom(e,i){const r=e.fov*(Math.abs(Math.cos(e.rollInRadians))*e.height+Math.abs(Math.sin(e.rollInRadians))*e.width)/e.height,o=t.ab(78.5-r/2,0,60);return !!i.terrain||e.pitch>o||e.padding.top>=.1}allowWorldCopies(){return !0}recalculateCache(){}}class Rt{constructor(e,t,i){this.points=e,this.planes=t,this.aabb=i;}static fromInvProjectionMatrix(e,i=1,r=0){const o=Math.pow(2,r),s=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((r=>{const s=1/(r=t.al([],r,e))[3]/i*o;return t.aO(r,r,[s,s,1/r[3],s])})),a=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((e=>{const i=t.aP([],s[e[0]],s[e[1]]),r=t.aP([],s[e[2]],s[e[1]]),o=t.aQ([],t.aR([],i,r)),a=-t.aS(o,s[e[1]]);return o.concat(a)})),n=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],l=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const e of s)for(let t=0;t<3;t++)n[t]=Math.min(n[t],e[t]),l[t]=Math.max(l[t],e[t]);return new Rt(s,a,new Mt(n,l))}}class Dt{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e,t){}constructor(e,t,i,r,o){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this._helper=new Et({calcMatrices:()=>{this._calcMatrices();},getConstrained:(e,t)=>this.getConstrained(e,t)},e,t,i,r,o),this._coveringTilesDetailsProvider=new St;}clone(){const e=new Dt;return e.apply(this),e}apply(e,t,i){this._helper.apply(e,t,i);}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(e){const i=[new t.aT(0,e)];if(this._helper._renderWorldCopies){const r=this.screenPointToMercatorCoordinate(new t.P(0,0)),o=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,0)),s=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,this._helper._height)),a=this.screenPointToMercatorCoordinate(new t.P(0,this._helper._height)),n=Math.floor(Math.min(r.x,o.x,s.x,a.x)),l=Math.floor(Math.max(r.x,o.x,s.x,a.x)),c=1;for(let r=n-c;r<=l+c;r++)0!==r&&i.push(new t.aT(r,e));}return i}getCameraFrustum(){return Rt.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){const t=this.screenPointToLocation(this.centerPoint,e),i=e?e.getElevationForLngLatZoom(t,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i);}setLocationAtPoint(e,i){const r=t.aH(this.elevation,this.center.lat),o=this.screenPointToMercatorCoordinateAtZ(i,r),s=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,r),a=t.Y.fromLngLat(e),n=new t.Y(a.x-(o.x-s.x),a.y-(o.y-s.y));this.setCenter(null==n?void 0:n.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap());}locationToScreenPoint(e,i){return i?this.coordinatePoint(t.Y.fromLngLat(e),i.getElevationForLngLatZoom(e,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(t.Y.fromLngLat(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(e,t){if(t){const i=t.pointCoordinate(e);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(e)}screenPointToMercatorCoordinateAtZ(e,i){const r=i||0,o=[e.x,e.y,0,1],s=[e.x,e.y,1,1];t.al(o,o,this._pixelMatrixInverse),t.al(s,s,this._pixelMatrixInverse);const a=o[3],n=s[3],l=o[1]/a,c=s[1]/n,h=o[2]/a,u=s[2]/n,d=h===u?0:(r-h)/(u-h);return new t.Y(t.y.number(o[0]/a,s[0]/n,d)/this.worldSize,t.y.number(l,c,d)/this.worldSize,r)}coordinatePoint(e,i=0,r=this._pixelMatrix){const o=[e.x*this.worldSize,e.y*this.worldSize,i,1];return t.al(o,o,r),new t.P(o[0]/o[3],o[1]/o[3])}getBounds(){const e=Math.max(0,this._helper._height/2-yt(this));return (new V).extend(this.screenPointToLocation(new t.P(0,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new t.P(0,this._helper._height)))}isPointOnMapSurface(e,t){return t?null!=t.pointCoordinate(e):e.y>this.height/2-yt(this)}calculatePosMatrix(e,i=!1,r){var o;const s=null!==(o=e.key)&&void 0!==o?o:t.aU(e.wrap,e.canonical.z,e.canonical.z,e.canonical.x,e.canonical.y),a=i?this._alignedPosMatrixCache:this._posMatrixCache;if(a.has(s)){const e=a.get(s);return r?e.f32:e.f64}const n=wt(e,this.worldSize);t.L(n,i?this._alignedProjMatrix:this._viewProjMatrix,n);const l={f64:n,f32:new Float32Array(n)};return a.set(s,l),r?l.f32:l.f64}calculateFogMatrix(e){const i=e.key,r=this._fogMatrixCacheF32;if(r.has(i))return r.get(i);const o=wt(e,this.worldSize);return t.L(o,this._fogMatrix,o),r.set(i,new Float32Array(o)),r.get(i)}getConstrained(e,i){i=t.ab(+i,this.minZoom,this.maxZoom);const r={center:new t.N(e.lng,e.lat),zoom:i};let o=this._helper._lngRange;this._helper._renderWorldCopies||null!==o||(o=[-179.9999999999,180-1e-10]);const s=this.tileSize*t.aG(r.zoom);let a=0,n=s,l=0,c=s,h=0,u=0;const{x:d,y:_}=this.size;if(this._helper._latRange){const e=this._helper._latRange;a=t.Q(e[1])*s,n=t.Q(e[0])*s,n-a<_&&(h=_/(n-a));}o&&(l=t.aI(t.O(o[0])*s,0,s),c=t.aI(t.O(o[1])*s,0,s),c<l&&(c+=s),c-l<d&&(u=d/(c-l)));const{x:p,y:m}=xt(s,e);let f,g;const v=Math.max(u||0,h||0);if(v){const e=new t.P(u?(c+l)/2:p,h?(n+a)/2:m);return r.center=bt(s,e).wrap(),r.zoom+=t.a8(v),r}if(this._helper._latRange){const e=_/2;m-e<a&&(g=a+e),m+e>n&&(g=n-e);}if(o){const e=(l+c)/2;let i=p;this._helper._renderWorldCopies&&(i=t.aI(p,e-s/2,e+s/2));const r=d/2;i-r<l&&(f=l+r),i+r>c&&(f=c-r);}if(void 0!==f||void 0!==g){const e=new t.P(null!=f?f:p,null!=g?g:m);r.center=bt(s,e).wrap();}return r}calculateCenterFromCameraLngLatAlt(e,t,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,r)}_calculateNearFarZIfNeeded(e,i,r){if(!this._helper.autoCalculateNearFarZ)return;const o=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),s=e-o*this._helper._pixelPerMeter/Math.cos(i),a=o<0?s:e,n=Math.PI/2+this.pitchInRadians,l=t.aa(this.fov)*(Math.abs(Math.cos(t.aa(this.roll)))*this.height+Math.abs(Math.sin(t.aa(this.roll)))*this.width)/this.height*(.5+r.y/this.height),c=Math.sin(l)*a/Math.sin(t.ab(Math.PI-n-l,.01,Math.PI-.01)),h=yt(this),u=Math.atan(h/this._helper.cameraToCenterDistance),d=t.aa(.75),_=u>d?2*u*(.5+r.y/(2*h)):d,p=Math.sin(_)*a/Math.sin(t.ab(Math.PI-n-_,.01,Math.PI-.01)),m=Math.min(c,p);this._helper._farZ=1.01*(Math.cos(Math.PI/2-i)*m+a),this._helper._nearZ=this._helper._height/50;}_calcMatrices(){if(!this._helper._height)return;const e=this.centerOffset,i=xt(this.worldSize,this.center),r=i.x,o=i.y;this._helper._pixelPerMeter=t.aH(1,this.center.lat)*this.worldSize;const s=t.aa(Math.min(this.pitch,89.25)),a=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(s));let n;this._calculateNearFarZIfNeeded(a,s,e),n=new Float64Array(16),t.aV(n,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),t.an(this._invProjMatrix,n),n[8]=2*-e.x/this._helper._width,n[9]=2*e.y/this._helper._height,this._projectionMatrix=t.aW(n),t.K(n,n,[1,-1,1]),t.J(n,n,[0,0,-this._helper.cameraToCenterDistance]),t.aX(n,n,-this.rollInRadians),t.aY(n,n,this.pitchInRadians),t.aX(n,n,-this.bearingInRadians),t.J(n,n,[-r,-o,0]),this._mercatorMatrix=t.K([],n,[this.worldSize,this.worldSize,this.worldSize]),t.K(n,n,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=t.L(new Float64Array(16),this.clipSpaceToPixelsMatrix,n),t.J(n,n,[0,0,-this.elevation]),this._viewProjMatrix=n,this._invViewProjMatrix=t.an([],n);const l=[0,0,-1,1];t.al(l,l,this._invViewProjMatrix),this._cameraPosition=[l[0]/l[3],l[1]/l[3],l[2]/l[3]],this._fogMatrix=new Float64Array(16),t.aV(this._fogMatrix,this.fovInRadians,this.width/this.height,a,this._helper._farZ),this._fogMatrix[8]=2*-e.x/this.width,this._fogMatrix[9]=2*e.y/this.height,t.K(this._fogMatrix,this._fogMatrix,[1,-1,1]),t.J(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),t.aX(this._fogMatrix,this._fogMatrix,-this.rollInRadians),t.aY(this._fogMatrix,this._fogMatrix,this.pitchInRadians),t.aX(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),t.J(this._fogMatrix,this._fogMatrix,[-r,-o,0]),t.K(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),t.J(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=t.L(new Float64Array(16),this.clipSpaceToPixelsMatrix,n);const c=this._helper._width%2/2,h=this._helper._height%2/2,u=Math.cos(this.bearingInRadians),d=Math.sin(-this.bearingInRadians),_=r-Math.round(r)+u*c+d*h,p=o-Math.round(o)+u*h+d*c,m=new Float64Array(n);if(t.J(m,m,[_>.5?_-1:_,p>.5?p-1:p,0]),this._alignedProjMatrix=m,n=t.an(new Float64Array(16),this._pixelMatrix),!n)throw new Error("failed to invert matrix");this._pixelMatrixInverse=n,this._clearMatrixCaches();}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear();}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const e=this.screenPointToMercatorCoordinate(new t.P(0,0)),i=[e.x*this.worldSize,e.y*this.worldSize,0,1];return t.al(i,i,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const e=t.aH(1,this.center.lat)*this.worldSize;return Tt(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/e).toLngLat()}lngLatToCameraDepth(e,i){const r=t.Y.fromLngLat(e),o=[r.x*this.worldSize,r.y*this.worldSize,i,1];return t.al(o,o,this._viewProjMatrix),o[2]/o[3]}getProjectionData(e){const{overscaledTileID:i,aligned:r,applyTerrainMatrix:o}=e,s=this._helper.getMercatorTileCoordinates(i),a=i?this.calculatePosMatrix(i,r,!0):null;let n;return n=i&&i.terrainRttPosMatrix32f&&o?i.terrainRttPosMatrix32f:a||t.aZ(),{mainMatrix:n,tileMercatorCoords:s,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:n}}isLocationOccluded(e){return !1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(e,t,i){return 1}transformLightDirection(e){return t.aN(e)}getRayDirectionFromPixel(e){throw new Error("Not implemented.")}projectTileCoordinates(e,i,r,o){const s=this.calculatePosMatrix(r);let a;o?(a=[e,i,o(e,i),1],t.al(a,a,s)):(a=[e,i,0,1],je(a,a,s));const n=a[3];return {point:new t.P(a[0]/n,a[1]/n),signedDistanceFromCamera:n,isOccluded:!1}}populateCache(e){for(const t of e)this.calculatePosMatrix(t);}getMatrixForModel(e,i){const r=t.Y.fromLngLat(e,i),o=r.meterInMercatorCoordinateUnits(),s=t.a_();return t.J(s,s,[r.x,r.y,r.z]),t.aX(s,s,Math.PI),t.aY(s,s,Math.PI/2),t.K(s,s,[-o,o,o]),s}getProjectionDataForCustomLayer(e=!0){const i=new t.S(0,0,0,0,0),r=this.getProjectionData({overscaledTileID:i,applyGlobeMatrix:e}),o=wt(i,this.worldSize);t.L(o,this._viewProjMatrix,o),r.tileMercatorCoords=[0,0,1,1];const s=[t.X,t.X,this.worldSize/this._helper.pixelsPerMeter],a=t.a$();return t.K(a,o,s),r.fallbackMatrix=a,r.mainMatrix=a,r}getFastPathSimpleProjectionMatrix(e){return this.calculatePosMatrix(e)}}function zt(){t.w("Map cannot fit within canvas with the given bounds, padding, and/or offset.");}function At(e){if(e.useSlerp)if(e.k<1){const i=t.b0(e.startEulerAngles.roll,e.startEulerAngles.pitch,e.startEulerAngles.bearing),r=t.b0(e.endEulerAngles.roll,e.endEulerAngles.pitch,e.endEulerAngles.bearing),o=new Float64Array(4);t.b1(o,i,r,e.k);const s=t.b2(o);e.tr.setRoll(s.roll),e.tr.setPitch(s.pitch),e.tr.setBearing(s.bearing);}else e.tr.setRoll(e.endEulerAngles.roll),e.tr.setPitch(e.endEulerAngles.pitch),e.tr.setBearing(e.endEulerAngles.bearing);else e.tr.setRoll(t.y.number(e.startEulerAngles.roll,e.endEulerAngles.roll,e.k)),e.tr.setPitch(t.y.number(e.startEulerAngles.pitch,e.endEulerAngles.pitch,e.k)),e.tr.setBearing(t.y.number(e.startEulerAngles.bearing,e.endEulerAngles.bearing,e.k));}function Lt(e,i,r,o,s){const a=s.padding,n=xt(s.worldSize,r.getNorthWest()),l=xt(s.worldSize,r.getNorthEast()),c=xt(s.worldSize,r.getSouthEast()),h=xt(s.worldSize,r.getSouthWest()),u=t.aa(-o),d=n.rotate(u),_=l.rotate(u),p=c.rotate(u),m=h.rotate(u),f=new t.P(Math.max(d.x,_.x,m.x,p.x),Math.max(d.y,_.y,m.y,p.y)),g=new t.P(Math.min(d.x,_.x,m.x,p.x),Math.min(d.y,_.y,m.y,p.y)),v=f.sub(g),x=(s.width-(a.left+a.right+i.left+i.right))/v.x,b=(s.height-(a.top+a.bottom+i.top+i.bottom))/v.y;if(b<0||x<0)return void zt();const y=Math.min(t.a8(s.scale*Math.min(x,b)),e.maxZoom),w=t.P.convert(e.offset),T=new t.P((i.left-i.right)/2,(i.top-i.bottom)/2).rotate(t.aa(o)),P=w.add(T).mult(s.scale/t.aG(y));return {center:bt(s.worldSize,n.add(c).div(2).sub(P)),zoom:y,bearing:o}}class kt{get useGlobeControls(){return !1}handlePanInertia(e,t){return {easingOffset:e,easingCenter:t.center}}handleMapControlsRollPitchBearingZoom(e,t){e.bearingDelta&&t.setBearing(t.bearing+e.bearingDelta),e.pitchDelta&&t.setPitch(t.pitch+e.pitchDelta),e.rollDelta&&t.setRoll(t.roll+e.rollDelta),e.zoomDelta&&t.setZoom(t.zoom+e.zoomDelta);}handleMapControlsPan(e,t,i){e.around.distSqr(t.centerPoint)<.01||t.setLocationAtPoint(i,e.around);}cameraForBoxAndBearing(e,t,i,r,o){return Lt(e,t,i,r,o)}handleJumpToCenterZoom(e,i){e.zoom!==(void 0!==i.zoom?+i.zoom:e.zoom)&&e.setZoom(+i.zoom),void 0!==i.center&&e.setCenter(t.N.convert(i.center));}handleEaseTo(e,i){const r=e.zoom,o=e.padding,s={roll:e.roll,pitch:e.pitch,bearing:e.bearing},a={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},n=void 0!==i.zoom,l=!e.isPaddingEqual(i.padding);let c=!1;const h=n?+i.zoom:e.zoom;let u=e.centerPoint.add(i.offsetAsPoint);const d=e.screenPointToLocation(u),{center:_,zoom:p}=e.getConstrained(t.N.convert(i.center||d),null!=h?h:r);Ct(e,_);const m=xt(e.worldSize,d),f=xt(e.worldSize,_).sub(m),g=t.aG(p-r);return c=p!==r,{easeFunc:n=>{if(c&&e.setZoom(t.y.number(r,p,n)),t.b3(s,a)||At({startEulerAngles:s,endEulerAngles:a,tr:e,k:n,useSlerp:s.roll!=a.roll}),l&&(e.interpolatePadding(o,i.padding,n),u=e.centerPoint.add(i.offsetAsPoint)),i.around)e.setLocationAtPoint(i.around,i.aroundPoint);else {const i=t.aG(e.zoom-r),o=p>r?Math.min(2,g):Math.max(.5,g),s=Math.pow(o,1-n),a=bt(e.worldSize,m.add(f.mult(n*s)).mult(i));e.setLocationAtPoint(e.renderWorldCopies?a.wrap():a,u);}},isZooming:c,elevationCenter:_}}handleFlyTo(e,i){const r=void 0!==i.zoom,o=e.zoom,s=e.getConstrained(t.N.convert(i.center||i.locationAtOffset),r?+i.zoom:o),a=s.center,n=s.zoom;Ct(e,a);const l=xt(e.worldSize,i.locationAtOffset),c=xt(e.worldSize,a).sub(l),h=c.mag(),u=t.aG(n-o);let d;if(void 0!==i.minZoom){const r=Math.min(+i.minZoom,o,n),s=e.getConstrained(a,r).zoom;d=t.aG(s-o);}return {easeFunc:(i,r,s,h)=>{e.setZoom(1===i?n:o+t.a8(r));const u=1===i?a:bt(e.worldSize,l.add(c.mult(s)).mult(r));e.setLocationAtPoint(e.renderWorldCopies?u.wrap():u,h);},scaleOfZoom:u,targetCenter:a,scaleOfMinZoom:d,pixelPathLength:h}}}class Ft{constructor(e,t,i){this.blendFunction=e,this.blendColor=t,this.mask=i;}}Ft.Replace=[1,0],Ft.disabled=new Ft(Ft.Replace,t.b4.transparent,[!1,!1,!1,!1]),Ft.unblended=new Ft(Ft.Replace,t.b4.transparent,[!0,!0,!0,!0]),Ft.alphaBlended=new Ft([1,771],t.b4.transparent,[!0,!0,!0,!0]);const Bt=2305;class jt{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}jt.disabled=new jt(!1,1029,Bt),jt.backCCW=new jt(!0,1029,Bt),jt.frontCCW=new jt(!0,1028,Bt);class Ot{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Ot.ReadOnly=!1,Ot.ReadWrite=!0,Ot.disabled=new Ot(519,Ot.ReadOnly,[0,1]);const Nt=7680;class Zt{constructor(e,t,i,r,o,s){this.test=e,this.ref=t,this.mask=i,this.fail=r,this.depthFail=o,this.pass=s;}}Zt.disabled=new Zt({func:519,mask:0},0,0,Nt,Nt,Nt);const Gt=new WeakMap;function Ut(e){var t;if(Gt.has(e))return Gt.get(e);{const i=null===(t=e.getParameter(e.VERSION))||void 0===t?void 0:t.startsWith("WebGL 2.0");return Gt.set(e,i),i}}class Vt{get awaitingQuery(){return !!this._readbackQueue}constructor(e){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=e;const i=e.context,r=i.gl;this._texFormat=r.RGBA,this._texType=r.UNSIGNED_BYTE;const o=new t.aC;o.emplaceBack(-1,-1),o.emplaceBack(2,-1),o.emplaceBack(-1,2);const s=new t.aE;s.emplaceBack(0,1,2),this._fullscreenTriangle=new pt(i.createVertexBuffer(o,mt.members),i.createIndexBuffer(s),t.aD.simpleSegment(0,0,o.length,s.length)),this._resultBuffer=new Uint8Array(4),i.activeTexture.set(r.TEXTURE1);const a=r.createTexture();r.bindTexture(r.TEXTURE_2D,a),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,r.CLAMP_TO_EDGE),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,r.CLAMP_TO_EDGE),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,r.NEAREST),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,r.NEAREST),r.texImage2D(r.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=i.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(a),Ut(r)&&(this._pbo=r.createBuffer(),r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.bufferData(r.PIXEL_PACK_BUFFER,4,r.STREAM_READ),r.bindBuffer(r.PIXEL_PACK_BUFFER,null));}destroy(){const e=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),e.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null;}updateErrorLoop(e,t){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(e,t),this._updateCount++,this._measuredError}_bindFramebuffer(){const e=this._cachedRenderContext.context,t=e.gl;e.activeTexture.set(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,this._fbo.colorAttachment.get()),e.bindFramebuffer.set(this._fbo.framebuffer);}_renderErrorTexture(e,i){const r=this._cachedRenderContext.context,o=r.gl;if(this._bindFramebuffer(),r.viewport.set([0,0,this._texWidth,this._texHeight]),r.clear({color:t.b4.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(r,o.TRIANGLES,Ot.disabled,Zt.disabled,Ft.unblended,jt.disabled,((e,t)=>({u_input:e,u_output_expected:t}))(e,i),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&Ut(o)){o.bindBuffer(o.PIXEL_PACK_BUFFER,this._pbo),o.readBuffer(o.COLOR_ATTACHMENT0),o.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),o.bindBuffer(o.PIXEL_PACK_BUFFER,null);const e=o.fenceSync(o.SYNC_GPU_COMMANDS_COMPLETE,0);o.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:e};}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null};}_tryReadback(){const e=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&Ut(e)){const i=e.clientWaitSync(this._readbackQueue.sync,0,0);if(i===e.WAIT_FAILED)return t.w("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(i===e.TIMEOUT_EXPIRED)return;e.bindBuffer(e.PIXEL_PACK_BUFFER,this._pbo),e.getBufferSubData(e.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),e.bindBuffer(e.PIXEL_PACK_BUFFER,null);}else this._bindFramebuffer(),e.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=Vt._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount;}static _parseRGBA8float(e){let t=0;return t+=e[0]/256,t+=e[1]/65536,t+=e[2]/16777216,e[3]<127&&(t=-t),t/128}}const qt=t.X/128;function Ht(e,i){const r=void 0!==e.granularity?Math.max(e.granularity,1):1,o=r+(e.generateBorders?2:0),s=r+(e.extendToNorthPole||e.generateBorders?1:0)+(e.extendToSouthPole||e.generateBorders?1:0),a=o+1,n=s+1,l=e.generateBorders?-1:0,c=e.generateBorders||e.extendToNorthPole?-1:0,h=r+(e.generateBorders?1:0),u=r+(e.generateBorders||e.extendToSouthPole?1:0),d=a*n,_=o*s*6,p=a*n>65536;if(p&&"16bit"===i)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const m=p||"32bit"===i,f=new Int16Array(2*d);let g=0;for(let i=c;i<=u;i++)for(let o=l;o<=h;o++){let s=o/r*t.X;-1===o&&(s=-64),o===r+1&&(s=t.X+qt);let a=i/r*t.X;-1===i&&(a=e.extendToNorthPole?t.b6:-64),i===r+1&&(a=e.extendToSouthPole?t.b7:t.X+qt),f[g++]=s,f[g++]=a;}const v=m?new Uint32Array(_):new Uint16Array(_);let x=0;for(let e=0;e<s;e++)for(let t=0;t<o;t++){const i=t+1+e*a,r=t+(e+1)*a,o=t+1+(e+1)*a;v[x++]=t+e*a,v[x++]=r,v[x++]=i,v[x++]=i,v[x++]=r,v[x++]=o;}return {vertices:f.buffer.slice(0),indices:v.buffer.slice(0),uses32bitIndices:m}}const Wt=new t.aB({fill:new t.b8(128,2),line:new t.b8(512,0),tile:new t.b8(128,32),stencil:new t.b8(128,1),circle:3});class Xt{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3;}get name(){return "vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return !0}get shaderVariantName(){return "globe"}get shaderDefine(){return "#define GLOBE"}get shaderPreludeCode(){return dt.projectionGlobe}get vertexShaderPreludeCode(){return dt.projectionMercator.vertexSource}get subdivisionGranularity(){return Wt}get useGlobeControls(){return !0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy();}updateGPUdependent(e){this._errorMeasurement||(this._errorMeasurement=new Vt(e));const i=t.Q(this._errorQueryLatitudeDegrees),r=2*Math.atan(Math.exp(Math.PI-i*Math.PI*2))-.5*Math.PI,o=this._errorMeasurement.updateErrorLoop(i,r),s=a.now();o!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=o,this._errorMeasurementLastChangeTime=s);const n=Math.min(Math.max((s-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=t.b9(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,t.ba(n));}_getMeshKey(e){return `${e.granularity.toString(36)}_${e.generateBorders?"b":""}${e.extendToNorthPole?"n":""}${e.extendToSouthPole?"s":""}`}getMeshFromTileID(e,t,i,r,o){const s=("stencil"===o?Wt.stencil:Wt.tile).getGranularityForZoomLevel(t.z);return this._getMesh(e,{granularity:s,generateBorders:i,extendToNorthPole:0===t.y&&r,extendToSouthPole:t.y===(1<<t.z)-1&&r})}_getMesh(e,i){const r=this._getMeshKey(i);if(r in this._tileMeshCache)return this._tileMeshCache[r];const o=function(e,i){const r=Ht(i,"16bit"),o=t.aC.deserialize({arrayBuffer:r.vertices,length:r.vertices.byteLength/2/2}),s=t.aE.deserialize({arrayBuffer:r.indices,length:r.indices.byteLength/2/3});return new pt(e.createVertexBuffer(o,mt.members),e.createIndexBuffer(s),t.aD.simpleSegment(0,0,o.length,s.length))}(e,i);return this._tileMeshCache[r]=o,o}recalculate(e){}hasTransition(){const e=a.now();let t=!1;return t=t||(e-this._errorMeasurementLastChangeTime)/1e3<.7,t=t||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,t}setErrorQueryLatitudeDegrees(e){this._errorQueryLatitudeDegrees=e;}}const $t=new t.q({type:new t.D(t.v.projection.type)});class Kt extends t.E{constructor(e){super(),this._transitionable=new t.T($t),this.setProjection(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.z(0)),this._mercatorProjection=new vt,this._verticalPerspectiveProjection=new Xt;}get transitionState(){const e=this.properties.get("type");if("string"==typeof e&&"mercator"===e)return 0;if("string"==typeof e&&"vertical-perspective"===e)return 1;if(e instanceof t.bb){if("vertical-perspective"===e.from&&"mercator"===e.to)return 1-e.transition;if("mercator"===e.from&&"vertical-perspective"===e.to)return e.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return "globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy();}updateGPUdependent(e){this._mercatorProjection.updateGPUdependent(e),this._verticalPerspectiveProjection.updateGPUdependent(e);}getMeshFromTileID(e,t,i,r,o){return this.currentProjection.getMeshFromTileID(e,t,i,r,o)}setProjection(e){this._transitionable.setValue("type",(null==e?void 0:e.type)||"mercator");}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}setErrorQueryLatitudeDegrees(e){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(e),this._mercatorProjection.setErrorQueryLatitudeDegrees(e);}}function Yt(e){const t=ei(e.worldSize,e.center.lat);return 2*Math.PI*t}function Jt(e,i,r,o,s){const a=1/(1<<s),n=i/t.X*a+o*a,l=t.bd((e/t.X*a+r*a)*Math.PI*2+Math.PI,2*Math.PI),c=2*Math.atan(Math.exp(Math.PI-n*Math.PI*2))-.5*Math.PI,h=Math.cos(c),u=new Float64Array(3);return u[0]=Math.sin(l)*h,u[1]=Math.sin(c),u[2]=Math.cos(l)*h,u}function Qt(e){return function(e,t){const i=Math.cos(t),r=new Float64Array(3);return r[0]=Math.sin(e)*i,r[1]=Math.sin(t),r[2]=Math.cos(e)*i,r}(e.lng*Math.PI/180,e.lat*Math.PI/180)}function ei(e,t){return e/(2*Math.PI)/Math.cos(t*Math.PI/180)}function ti(e){const i=Math.asin(e[1])/Math.PI*180,r=Math.sqrt(e[0]*e[0]+e[2]*e[2]);if(r>1e-6){const o=e[0]/r,s=Math.acos(e[2]/r),a=(o>0?s:-s)/Math.PI*180;return new t.N(t.aI(a,-180,180),i)}return new t.N(0,i)}function ii(e){return Math.cos(e*Math.PI/180)}function ri(e,i){const r=ii(e),o=ii(i);return t.a8(o/r)}function oi(e,i){const r=e.rotate(i.bearingInRadians),o=i.zoom+ri(i.center.lat,0),s=t.b9(1/ii(i.center.lat),1/ii(Math.min(Math.abs(i.center.lat),60)),t.bc(o,7,3,0,1)),a=360/Yt({worldSize:i.worldSize,center:{lat:i.center.lat}});return new t.N(i.center.lng-r.x*a*s,t.ab(i.center.lat+r.y*a,-85.051129,t.aF))}function si(e){const t=.5*e,i=Math.sin(t),r=Math.cos(t);return Math.log(i+r)-Math.log(r-i)}function ai(e,i,r,o){const s=e.lat+r*o;if(Math.abs(r)>1){const a=(Math.sign(e.lat+r)!==Math.sign(e.lat)?-Math.abs(e.lat):Math.abs(e.lat))*Math.PI/180,n=Math.abs(e.lat+r)*Math.PI/180,l=si(a+o*(n-a)),c=si(a),h=si(n);return new t.N(e.lng+i*((l-c)/(h-c)),s)}return new t.N(e.lng+i*o,s)}class ni{constructor(e){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._aabbFactory=e;}recalculateCache(){if(!this._hadAnyChanges)return;const e=this._cachePrevious;this._cachePrevious=this._cache,this._cache=e,this._cache.clear(),this._hadAnyChanges=!1;}getTileAABB(e,t,i,r){const o=`${e.z}_${e.x}_${e.y}`,s=this._cache.get(o);if(s)return s;const a=this._cachePrevious.get(o);if(a)return this._cache.set(o,a),a;const n=this._aabbFactory(e,t,i,r);return this._cache.set(o,n),this._hadAnyChanges=!0,n}}function li(e,t,i){const r=e-t;return r<0?-r:Math.max(0,r-i)}function ci(e,t,i,r,o){const s=e-i;let a;return a=s<0?Math.min(-s,1+s-o):s>1?Math.min(Math.max(s-o,0),1-s):0,Math.max(a,li(t,r,o))}class hi{constructor(){this._aabbCache=new ni(this._computeTileAABB);}recalculateCache(){this._aabbCache.recalculateCache();}distanceToTile2d(e,t,i,r){const o=1<<i.z,s=1/o,a=i.x/o,n=i.y/o;let l=2;return l=Math.min(l,ci(e,t,a,n,s)),l=Math.min(l,ci(e,t,a+.5,-n-s,s)),l=Math.min(l,ci(e,t,a+.5,2-n-s,s)),l}getWrap(e,t,i){const r=1<<t.z,o=1/r,s=t.x/r,a=li(e.x,s,o),n=li(e.x,s-1,o),l=li(e.x,s+1,o),c=Math.min(a,n,l);return c===l?1:c===n?-1:0}allowVariableZoom(e,t){return he(e,t)>4}allowWorldCopies(){return !1}getTileAABB(e,t,i,r){return this._aabbCache.getTileAABB(e,t,i,r)}_computeTileAABB(e,i,r,o){if(e.z<=0)return new Mt([-1,-1,-1],[1,1,1]);if(1===e.z)return new Mt([0===e.x?-1:0,0===e.y?0:-1,-1],[0===e.x?0:1,0===e.y?1:0,1]);{const i=[Jt(0,0,e.x,e.y,e.z),Jt(t.X,0,e.x,e.y,e.z),Jt(t.X,t.X,e.x,e.y,e.z),Jt(0,t.X,e.x,e.y,e.z)],r=[1,1,1],o=[-1,-1,-1];for(const e of i)for(let t=0;t<3;t++)r[t]=Math.min(r[t],e[t]),o[t]=Math.max(o[t],e[t]);if(0===e.y||e.y===(1<<e.z)-1){const t=[0,0===e.y?1:-1,0];for(let e=0;e<3;e++)r[e]=Math.min(r[e],t[e]),o[e]=Math.max(o[e],t[e]);}return new Mt(r,o)}}}class ui{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t){this._helper.resize(e,t);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e){}constructor(){this._cachedClippingPlane=t.be(),this._projectionMatrix=t.a_(),this._globeViewProjMatrix32f=t.aZ(),this._globeViewProjMatrixNoCorrection=t.a_(),this._globeViewProjMatrixNoCorrectionInverted=t.a_(),this._globeProjMatrixInverted=t.a_(),this._cameraPosition=t.bf(),this._globeLatitudeErrorCorrectionRadians=0,this._helper=new Et({calcMatrices:()=>{this._calcMatrices();},getConstrained:(e,t)=>this.getConstrained(e,t)}),this._coveringTilesDetailsProvider=new hi;}clone(){const e=new ui;return e.apply(this),e}apply(e,t){this._globeLatitudeErrorCorrectionRadians=t||0,this._helper.apply(e);}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const e=t.bf();return e[0]=this._cameraPosition[0],e[1]=this._cameraPosition[1],e[2]=this._cameraPosition[2],e}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(e){const{overscaledTileID:t,applyGlobeMatrix:i}=e,r=this._helper.getMercatorTileCoordinates(t);return {mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:r,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(e){const i=this.pitchInRadians,r=this.cameraToCenterDistance/e,o=Math.sin(i)*r,s=Math.cos(i)*r+1,a=1/Math.sqrt(o*o+s*s)*1;let n=-o,l=s;const c=Math.sqrt(n*n+l*l);n/=c,l/=c;const h=[0,n,l];return t.bg(h,h,[0,0,0],-this.bearingInRadians),t.bh(h,h,[0,0,0],-1*this.center.lat*Math.PI/180),t.bi(h,h,[0,0,0],this.center.lng*Math.PI/180),t.aL(h,h,.25),[...h,.25*-a]}isLocationOccluded(e){return !this.isSurfacePointVisible(Qt(e))}transformLightDirection(e){const i=this._helper._center.lng*Math.PI/180,r=this._helper._center.lat*Math.PI/180,o=Math.cos(r),s=[Math.sin(i)*o,Math.sin(r),Math.cos(i)*o],a=[s[2],0,-s[0]],n=[0,0,0];t.aR(n,a,s),t.aQ(a,a),t.aQ(n,n);const l=[0,0,0];return t.aQ(l,[a[0]*e[0]+n[0]*e[1]+s[0]*e[2],a[1]*e[0]+n[1]*e[1]+s[1]*e[2],a[2]*e[0]+n[2]*e[1]+s[2]*e[2]]),l}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(e,i,r){const o=function(e,i,r){const o=1/(1<<r.z);return new t.Y(e/t.X*o+r.x*o,i/t.X*o+r.y*o)}(e,i,r.canonical),s=(a=o.y,[t.bd(o.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-a*Math.PI*2))-.5*Math.PI]);var a;return this.getCircleRadiusCorrection()/Math.cos(s[1])}projectTileCoordinates(e,i,r,o){const s=r.canonical,a=Jt(e,i,s.x,s.y,s.z),n=1+(o?o(e,i):0)/t.bo,l=[a[0]*n,a[1]*n,a[2]*n,1];t.al(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*a[0]+c[1]*a[1]+c[2]*a[2]+c[3]<0;return {point:new t.P(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const e=ei(this.worldSize,this.center.lat),i=t.a$(),r=t.a$();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*e),t.aV(i,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const o=this.centerOffset;i[8]=2*-o.x/this._helper._width,i[9]=2*o.y/this._helper._height,this._projectionMatrix=t.aW(i),this._globeProjMatrixInverted=t.a$(),t.an(this._globeProjMatrixInverted,i),t.J(i,i,[0,0,-this.cameraToCenterDistance]),t.aX(i,i,this.rollInRadians),t.aY(i,i,-this.pitchInRadians),t.aX(i,i,this.bearingInRadians),t.J(i,i,[0,0,-e]);const s=t.bf();s[0]=e,s[1]=e,s[2]=e,t.aY(r,i,this.center.lat*Math.PI/180),t.bj(r,r,-this.center.lng*Math.PI/180),t.K(r,r,s),this._globeViewProjMatrixNoCorrection=r,t.aY(i,i,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),t.bj(i,i,-this.center.lng*Math.PI/180),t.K(i,i,s),this._globeViewProjMatrix32f=new Float32Array(i),this._globeViewProjMatrixNoCorrectionInverted=t.a$(),t.an(this._globeViewProjMatrixNoCorrectionInverted,r);const a=t.bf();this._cameraPosition=t.bf(),this._cameraPosition[2]=this.cameraToCenterDistance/e,t.bg(this._cameraPosition,this._cameraPosition,a,-this.rollInRadians),t.bh(this._cameraPosition,this._cameraPosition,a,this.pitchInRadians),t.bg(this._cameraPosition,this._cameraPosition,a,-this.bearingInRadians),t.aM(this._cameraPosition,this._cameraPosition,[0,0,1]),t.bh(this._cameraPosition,this._cameraPosition,a,-this.center.lat*Math.PI/180),t.bi(this._cameraPosition,this._cameraPosition,a,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(e);const n=t.aW(this._globeViewProjMatrixNoCorrectionInverted);t.K(n,n,[1,1,-1]),this._cachedFrustum=Rt.fromInvProjectionMatrix(n);}calculateFogMatrix(e){t.w("calculateFogMatrix is not supported on globe projection.");const i=t.a$();return t.aq(i),i}getVisibleUnwrappedCoordinates(e){return [new t.aT(0,e)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){e&&t.w("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0);}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,i){if(!this._globeViewProjMatrixNoCorrection)return 1;const r=Qt(e);t.aL(r,r,1+i/t.bo);const o=t.be();return t.al(o,[r[0],r[1],r[2],1],this._globeViewProjMatrixNoCorrection),o[2]/o[3]}populateCache(e){}getBounds(){const e=.5*this.width,i=.5*this.height,r=[new t.P(0,0),new t.P(e,0),new t.P(this.width,0),new t.P(this.width,i),new t.P(this.width,this.height),new t.P(e,this.height),new t.P(0,this.height),new t.P(0,i)],o=[];for(const e of r)o.push(this.unprojectScreenPoint(e));let s=0,a=0,n=0,l=0;const c=this.center;for(const e of o){const i=t.bk(c.lng,e.lng),r=t.bk(c.lat,e.lat);i<a&&(a=i),i>s&&(s=i),r<l&&(l=r),r>n&&(n=r);}const h=[c.lng+a,c.lat+l,c.lng+s,c.lat+n];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new V(h)}getConstrained(e,i){const r=t.ab(e.lat,-85.051129,t.aF),o=t.ab(+i,this.minZoom+ri(0,r),this.maxZoom);return {center:new t.N(e.lng,r),zoom:o}}calculateCenterFromCameraLngLatAlt(e,t,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,r)}setLocationAtPoint(e,i){const r=Qt(this.unprojectScreenPoint(i)),o=Qt(e),s=t.bf();t.bl(s);const a=t.bf();t.bi(a,r,s,-this.center.lng*Math.PI/180),t.bh(a,a,s,this.center.lat*Math.PI/180);const n=o[0]*o[0]+o[2]*o[2],l=a[0]*a[0];if(n<l)return;const c=Math.sqrt(n-l),h=-c,u=t.bm(o[0],o[2],a[0],c),d=t.bm(o[0],o[2],a[0],h),_=t.bf();t.bi(_,o,s,-u);const p=t.bm(_[1],_[2],a[1],a[2]),m=t.bf();t.bi(m,o,s,-d);const f=t.bm(m[1],m[2],a[1],a[2]),g=.5*Math.PI,v=p>=-g&&p<=g,x=f>=-g&&f<=g;let b,y;if(v&&x){const e=this.center.lng*Math.PI/180,i=this.center.lat*Math.PI/180;t.bp(u,e)+t.bp(p,i)<t.bp(d,e)+t.bp(f,i)?(b=u,y=p):(b=d,y=f);}else if(v)b=u,y=p;else {if(!x)return;b=d,y=f;}const w=b/Math.PI*180,T=y/Math.PI*180,P=this.center.lat;this.setCenter(new t.N(w,t.ab(T,-90,90))),this.setZoom(this.zoom+ri(P,this.center.lat));}locationToScreenPoint(e,i){const r=Qt(e);if(i){const o=i.getElevationForLngLatZoom(e,this._helper._tileZoom);t.aL(r,r,1+o/t.bo);}return this._projectSurfacePointToScreen(r)}_projectSurfacePointToScreen(e){const i=t.be();return t.al(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],new t.P((.5*i[0]+.5)*this.width,(.5*-i[1]+.5)*this.height)}screenPointToMercatorCoordinate(e,i){if(i){const t=i.pointCoordinate(e);if(t)return t}return t.Y.fromLngLat(this.unprojectScreenPoint(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(e,t){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(e);return !!this.rayPlanetIntersection(i,r)}getRayDirectionFromPixel(e){const i=t.be();i[0]=e.x/this.width*2-1,i[1]=-1*(e.y/this.height*2-1),i[2]=1,i[3]=1,t.al(i,i,this._globeViewProjMatrixNoCorrectionInverted),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3];const r=t.bf();r[0]=i[0]-this._cameraPosition[0],r[1]=i[1]-this._cameraPosition[1],r[2]=i[2]-this._cameraPosition[2];const o=t.bf();return t.aQ(o,r),o}isSurfacePointVisible(e){const t=this._cachedClippingPlane;return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0}isSurfacePointOnScreen(e){if(!this.isSurfacePointVisible(e))return !1;const i=t.be();return t.al(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3],i[0]>-1&&i[0]<1&&i[1]>-1&&i[1]<1&&i[2]>-1&&i[2]<1}rayPlanetIntersection(e,i){const r=t.aS(e,i),o=t.bf(),s=t.bf();t.aL(s,i,r),t.aP(o,e,s);const a=1-t.aS(o,o);if(a<0)return null;const n=t.aS(e,e)-1,l=-r+(r<0?1:-1)*Math.sqrt(a),c=n/l,h=l;return {tMin:Math.min(c,h),tMax:Math.max(c,h)}}unprojectScreenPoint(e){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(e),o=this.rayPlanetIntersection(i,r);if(o){const e=t.bf();t.aM(e,i,[r[0]*o.tMin,r[1]*o.tMin,r[2]*o.tMin]);const s=t.bf();return t.aQ(s,e),ti(s)}const s=this._cachedClippingPlane[0]*r[0]+this._cachedClippingPlane[1]*r[1]+this._cachedClippingPlane[2]*r[2],a=-t.bn(this._cachedClippingPlane,i)/s,n=t.bf();if(a>0)t.aM(n,i,[r[0]*a,r[1]*a,r[2]*a]);else {const e=t.bf();t.aM(e,i,[2*r[0],2*r[1],2*r[2]]);const o=t.bn(this._cachedClippingPlane,e);t.aP(n,e,[this._cachedClippingPlane[0]*o,this._cachedClippingPlane[1]*o,this._cachedClippingPlane[2]*o]);}const l=t.bf();return t.aQ(l,n),ti(l)}getMatrixForModel(e,i){const r=t.N.convert(e),o=1/t.bo,s=t.a_();return t.bj(s,s,r.lng/180*Math.PI),t.aY(s,s,-r.lat/180*Math.PI),t.J(s,s,[0,0,1+i/t.bo]),t.aY(s,s,.5*Math.PI),t.K(s,s,[o,o,o]),s}getProjectionDataForCustomLayer(e=!0){const i=this.getProjectionData({overscaledTileID:new t.S(0,0,0,0,0),applyGlobeMatrix:e});return i.tileMercatorCoords=[0,0,1,1],i}getFastPathSimpleProjectionMatrix(e){}}class di{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(e,t){this._globeness=e,this._globeLatitudeErrorCorrectionRadians=t,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().recalculateCache(),this._mercatorTransform.getCoveringTilesDetailsProvider().recalculateCache();}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this._helper=new Et({calcMatrices:()=>{this._calcMatrices();},getConstrained:(e,t)=>this.getConstrained(e,t)}),this._globeness=1,this._mercatorTransform=new Dt,this._verticalPerspectiveTransform=new ui;}clone(){const e=new di;return e._globeness=this._globeness,e._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,e.apply(this),e}apply(e){this._helper.apply(e),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians);}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(e){const t=this._mercatorTransform.getProjectionData(e),i=this._verticalPerspectiveTransform.getProjectionData(e);return {mainMatrix:this.isGlobeRendering?i.mainMatrix:t.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:e.applyGlobeMatrix?this._globeness:0,fallbackMatrix:t.fallbackMatrix}}isLocationOccluded(e){return this.currentTransform.isLocationOccluded(e)}transformLightDirection(e){return this.currentTransform.transformLightDirection(e)}getPixelScale(){return t.b9(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return t.b9(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(e,i,r){const o=this._mercatorTransform.getPitchedTextCorrection(e,i,r),s=this._verticalPerspectiveTransform.getPitchedTextCorrection(e,i,r);return t.b9(o,s,this._globeness)}projectTileCoordinates(e,t,i,r){return this.currentTransform.projectTileCoordinates(e,t,i,r)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ);}calculateFogMatrix(e){return this.currentTransform.calculateFogMatrix(e)}getVisibleUnwrappedCoordinates(e){return this.currentTransform.getVisibleUnwrappedCoordinates(e)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(e){this._mercatorTransform.recalculateZoomAndCenter(e),this._verticalPerspectiveTransform.recalculateZoomAndCenter(e);}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,t){return this.currentTransform.lngLatToCameraDepth(e,t)}populateCache(e){this._mercatorTransform.populateCache(e),this._verticalPerspectiveTransform.populateCache(e);}getBounds(){return this.currentTransform.getBounds()}getConstrained(e,t){return this.currentTransform.getConstrained(e,t)}calculateCenterFromCameraLngLatAlt(e,t,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,r)}setLocationAtPoint(e,t){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(e,t),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(e,t),this.apply(this._verticalPerspectiveTransform);}locationToScreenPoint(e,t){return this.currentTransform.locationToScreenPoint(e,t)}screenPointToMercatorCoordinate(e,t){return this.currentTransform.screenPointToMercatorCoordinate(e,t)}screenPointToLocation(e,t){return this.currentTransform.screenPointToLocation(e,t)}isPointOnMapSurface(e,t){return this.currentTransform.isPointOnMapSurface(e,t)}getRayDirectionFromPixel(e){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(e)}getMatrixForModel(e,t){return this.currentTransform.getMatrixForModel(e,t)}getProjectionDataForCustomLayer(e=!0){const t=this._mercatorTransform.getProjectionDataForCustomLayer(e);if(!this.isGlobeRendering)return t;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(e);return i.fallbackMatrix=t.mainMatrix,i}getFastPathSimpleProjectionMatrix(e){return this.currentTransform.getFastPathSimpleProjectionMatrix(e)}}class _i{get useGlobeControls(){return !0}handlePanInertia(e,i){const r=oi(e,i);return Math.abs(r.lng-i.center.lng)>180&&(r.lng=i.center.lng+179.5*Math.sign(r.lng-i.center.lng)),{easingCenter:r,easingOffset:new t.P(0,0)}}handleMapControlsRollPitchBearingZoom(e,i){const r=e.around,o=i.screenPointToLocation(r);e.bearingDelta&&i.setBearing(i.bearing+e.bearingDelta),e.pitchDelta&&i.setPitch(i.pitch+e.pitchDelta),e.rollDelta&&i.setRoll(i.roll+e.rollDelta);const s=i.zoom;e.zoomDelta&&i.setZoom(i.zoom+e.zoomDelta);const a=i.zoom-s;if(0===a)return;const n=t.bk(i.center.lng,o.lng),l=n/(Math.abs(n/180)+1),c=t.bk(i.center.lat,o.lat),h=i.getRayDirectionFromPixel(r),u=i.cameraPosition,d=-1*t.aS(u,h),_=t.bf();t.aM(_,u,[h[0]*d,h[1]*d,h[2]*d]);const p=t.bq(_)-1,m=Math.exp(.5*-Math.max(p-.3,0)),f=ei(i.worldSize,i.center.lat)/Math.min(i.width,i.height),g=t.bc(f,.9,.5,1,.25),v=(1-t.aG(-a))*Math.min(m,g),x=i.center.lat,b=i.zoom,y=new t.N(i.center.lng+l*v,t.ab(i.center.lat+c*v,-85.051129,t.aF));i.setLocationAtPoint(o,r);const w=i.center,T=t.bc(Math.abs(n),45,85,0,1),P=t.bc(f,.75,.35,0,1),C=Math.pow(Math.max(T,P),.25),I=t.bk(w.lng,y.lng),E=t.bk(w.lat,y.lat);i.setCenter(new t.N(w.lng+I*C,w.lat+E*C).wrap()),i.setZoom(b+ri(x,i.center.lat));}handleMapControlsPan(e,t,i){if(!e.panDelta)return;const r=t.center.lat,o=t.zoom;t.setCenter(oi(e.panDelta,t).wrap()),t.setZoom(o+ri(r,t.center.lat));}cameraForBoxAndBearing(e,i,r,o,s){const a=Lt(e,i,r,o,s),n=i.left/s.width*2-1,l=(s.width-i.right)/s.width*2-1,c=i.top/s.height*-2+1,h=(s.height-i.bottom)/s.height*-2+1,u=t.bk(r.getWest(),r.getEast())<0,d=u?r.getEast():r.getWest(),_=u?r.getWest():r.getEast(),p=Math.max(r.getNorth(),r.getSouth()),m=Math.min(r.getNorth(),r.getSouth()),f=d+.5*t.bk(d,_),g=p+.5*t.bk(p,m),v=s.clone();v.setCenter(a.center),v.setBearing(a.bearing),v.setPitch(0),v.setRoll(0),v.setZoom(a.zoom);const x=v.modelViewProjectionMatrix,b=[Qt(r.getNorthWest()),Qt(r.getNorthEast()),Qt(r.getSouthWest()),Qt(r.getSouthEast()),Qt(new t.N(_,g)),Qt(new t.N(d,g)),Qt(new t.N(f,p)),Qt(new t.N(f,m))],y=Qt(a.center);let w=Number.POSITIVE_INFINITY;for(const e of b)n<0&&(w=_i.getLesserNonNegativeNonNull(w,_i.solveVectorScale(e,y,x,"x",n))),l>0&&(w=_i.getLesserNonNegativeNonNull(w,_i.solveVectorScale(e,y,x,"x",l))),c>0&&(w=_i.getLesserNonNegativeNonNull(w,_i.solveVectorScale(e,y,x,"y",c))),h<0&&(w=_i.getLesserNonNegativeNonNull(w,_i.solveVectorScale(e,y,x,"y",h)));if(Number.isFinite(w)&&0!==w)return a.zoom=v.zoom+t.a8(w),a;zt();}handleJumpToCenterZoom(e,i){const r=e.center.lat,o=e.getConstrained(i.center?t.N.convert(i.center):e.center,e.zoom).center;e.setCenter(o.wrap());const s=void 0!==i.zoom?+i.zoom:e.zoom+ri(r,o.lat);e.zoom!==s&&e.setZoom(s);}handleEaseTo(e,i){const r=e.zoom,o=e.center,s=e.padding,a={roll:e.roll,pitch:e.pitch,bearing:e.bearing},n={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},l=void 0!==i.zoom,c=!e.isPaddingEqual(i.padding);let h=!1;const u=i.center?t.N.convert(i.center):o,d=e.getConstrained(u,r).center;Ct(e,d);const _=e.clone();_.setCenter(d),_.setZoom(l?+i.zoom:r+ri(o.lat,u.lat)),_.setBearing(i.bearing);const p=new t.P(t.ab(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.ab(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));_.setLocationAtPoint(d,p);const m=(i.offset&&i.offsetAsPoint.mag())>0?_.center:d,f=l?+i.zoom:r+ri(o.lat,m.lat),g=r+ri(o.lat,0),v=f+ri(m.lat,0),x=t.bk(o.lng,m.lng),b=t.bk(o.lat,m.lat),y=t.aG(v-g);return h=f!==r,{easeFunc:r=>{if(t.b3(a,n)||At({startEulerAngles:a,endEulerAngles:n,tr:e,k:r,useSlerp:a.roll!=n.roll}),c&&e.interpolatePadding(s,i.padding,r),i.around)t.w("Easing around a point is not supported under globe projection."),e.setLocationAtPoint(i.around,i.aroundPoint);else {const t=v>g?Math.min(2,y):Math.max(.5,y),i=Math.pow(t,1-r),s=ai(o,x,b,r*i);e.setCenter(s.wrap());}if(h){const i=t.y.number(g,v,r)+ri(0,e.center.lat);e.setZoom(i);}},isZooming:h,elevationCenter:m}}handleFlyTo(e,i){const r=void 0!==i.zoom,o=e.center,s=e.zoom,a=!e.isPaddingEqual(i.padding),n=e.getConstrained(t.N.convert(i.center||i.locationAtOffset),s).center,l=r?+i.zoom:e.zoom+ri(e.center.lat,n.lat),c=e.clone();c.setCenter(n),a&&c.setPadding(i.padding),c.setZoom(l),c.setBearing(i.bearing);const h=new t.P(t.ab(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.ab(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));c.setLocationAtPoint(n,h);const u=c.center;Ct(e,u);const d=function(e,i,r){const o=Qt(i),s=Qt(r),a=t.aS(o,s),n=Math.acos(a),l=Yt(e);return n/(2*Math.PI)*l}(e,o,u),_=s+ri(o.lat,0),p=l+ri(u.lat,0),m=t.aG(p-_);let f;if("number"==typeof i.minZoom){const r=+i.minZoom+ri(u.lat,0),o=Math.min(r,_,p)+ri(0,u.lat),s=e.getConstrained(u,o).zoom+ri(u.lat,0);f=t.aG(s-_);}const g=t.bk(o.lng,u.lng),v=t.bk(o.lat,u.lat);return {easeFunc:(i,r,s,a)=>{const n=ai(o,g,v,s),c=1===i?u:n;e.setCenter(c.wrap());const h=_+t.a8(r);e.setZoom(1===i?l:h+ri(0,c.lat));},scaleOfZoom:m,targetCenter:u,scaleOfMinZoom:f,pixelPathLength:d}}static solveVectorScale(e,t,i,r,o){const s="x"===r?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],a=[i[3],i[7],i[11],i[15]],n=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],l=e[0]*a[0]+e[1]*a[1]+e[2]*a[2],c=t[0]*s[0]+t[1]*s[1]+t[2]*s[2],h=t[0]*a[0]+t[1]*a[1]+t[2]*a[2];return c+o*l===n+o*h||a[3]*(n-c)+s[3]*(h-l)+n*h==c*l?null:(c+s[3]-o*h-o*a[3])/(c-n-o*h+o*l)}static getLesserNonNegativeNonNull(e,t){return null!==t&&t>=0&&t<e?t:e}}class pi{constructor(e){this._globe=e,this._mercatorCameraHelper=new kt,this._verticalPerspectiveCameraHelper=new _i;}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(e,t){return this.currentHelper.handlePanInertia(e,t)}handleMapControlsRollPitchBearingZoom(e,t){return this.currentHelper.handleMapControlsRollPitchBearingZoom(e,t)}handleMapControlsPan(e,t,i){this.currentHelper.handleMapControlsPan(e,t,i);}cameraForBoxAndBearing(e,t,i,r,o){return this.currentHelper.cameraForBoxAndBearing(e,t,i,r,o)}handleJumpToCenterZoom(e,t){this.currentHelper.handleJumpToCenterZoom(e,t);}handleEaseTo(e,t){return this.currentHelper.handleEaseTo(e,t)}handleFlyTo(e,t){return this.currentHelper.handleFlyTo(e,t)}}const mi=(e,i)=>t.t(e,i&&i.filter((e=>"source.canvas"!==e.identifier))),fi=t.br();class gi extends t.E{constructor(e,i={}){super(),this._rtlPluginLoaded=()=>{for(const e in this.sourceCaches){const t=this.sourceCaches[e].getSource().type;"vector"!==t&&"geojson"!==t||this.sourceCaches[e].reload();}},this.map=e,this.dispatcher=new B(F(),e._getMapId()),this.dispatcher.registerMessageHandler("GG",((e,t)=>this.getGlyphs(e,t))),this.dispatcher.registerMessageHandler("GI",((e,t)=>this.getImages(e,t))),this.imageManager=new b,this.imageManager.setEventedParent(this),this.glyphManager=new P(e._requestManager,i.localIdeographFontFamily),this.lineAtlas=new R(256,512),this.crossTileSymbolIndex=new ht,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new t.bs,this._loaded=!1,this._availableImages=[],this._resetUpdates(),this.dispatcher.broadcast("SR",t.bt()),oe().on(te,this._rtlPluginLoaded),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.sourceCaches[e.sourceId];if(!t)return;const i=t.getSource();if(i&&i.vectorLayerIds)for(const e in this._layers){const t=this._layers[e];t.source===i.id&&this._validateLayer(t);}}));}loadURL(e,i={},r){this.fire(new t.k("dataloading",{dataType:"style"})),i.validate="boolean"!=typeof i.validate||i.validate;const o=this.map._requestManager.transformRequest(e,"Style");this._loadStyleRequest=new AbortController;const s=this._loadStyleRequest;t.h(o,this._loadStyleRequest).then((e=>{this._loadStyleRequest=null,this._load(e.data,i,r);})).catch((e=>{this._loadStyleRequest=null,e&&!s.signal.aborted&&this.fire(new t.j(e));}));}loadJSON(e,i={},r){this.fire(new t.k("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,a.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,i.validate=!1!==i.validate,this._load(e,i,r);})).catch((()=>{}));}loadEmpty(){this.fire(new t.k("dataloading",{dataType:"style"})),this._load(fi,{validate:!1});}_load(e,i,r){var o,s;const a=i.transformStyle?i.transformStyle(r,e):e;if(!i.validate||!mi(this,t.u(a))){this._loaded=!0,this.stylesheet=a;for(const e in a.sources)this.addSource(e,a.sources[e],{validate:!1});a.sprite?this._loadSprite(a.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(a.glyphs),this._createLayers(),this.light=new E(this.stylesheet.light),this._setProjectionInternal((null===(o=this.stylesheet.projection)||void 0===o?void 0:o.type)||"mercator"),this.sky=new S(this.stylesheet.sky),this.map.setTerrain(null!==(s=this.stylesheet.terrain)&&void 0!==s?s:null),this.fire(new t.k("data",{dataType:"style"})),this.fire(new t.k("style.load"));}}_createLayers(){const e=t.bu(this.stylesheet.layers);this.dispatcher.broadcast("SL",e),this._order=e.map((e=>e.id)),this._layers={},this._serializedLayers=null;for(const i of e){const e=t.bv(i);e.setEventedParent(this,{layer:{id:i.id}}),this._layers[i.id]=e;}}_loadSprite(e,i=!1,r=void 0){let o;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(e,i,r,o){return t._(this,void 0,void 0,(function*(){const s=f(e),n=r>1?"@2x":"",l={},c={};for(const{id:e,url:r}of s){const s=i.transformRequest(g(r,n,".json"),"SpriteJSON");l[e]=t.h(s,o);const a=i.transformRequest(g(r,n,".png"),"SpriteImage");c[e]=p.getImage(a,o);}return yield Promise.all([...Object.values(l),...Object.values(c)]),function(e,i){return t._(this,void 0,void 0,(function*(){const t={};for(const r in e){t[r]={};const o=a.getImageCanvasContext((yield i[r]).data),s=(yield e[r]).data;for(const e in s){const{width:i,height:a,x:n,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m}=s[e];t[r][e]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m,spriteData:{width:i,height:a,x:n,y:l,context:o}};}}return t}))}(l,c)}))}(e,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((e=>{if(this._spriteRequest=null,e)for(const t in e){this._spritesImagesIds[t]=[];const r=this._spritesImagesIds[t]?this._spritesImagesIds[t].filter((t=>!(t in e))):[];for(const e of r)this.imageManager.removeImage(e),this._changedImages[e]=!0;for(const r in e[t]){const o="default"===t?r:`${t}:${r}`;this._spritesImagesIds[t].push(o),o in this.imageManager.images?this.imageManager.updateImage(o,e[t][r],!1):this.imageManager.addImage(o,e[t][r]),i&&(this._changedImages[o]=!0);}}})).catch((e=>{this._spriteRequest=null,o=e,this.fire(new t.j(o));})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),i&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.k("data",{dataType:"style"})),r&&r(o);}));}_unloadSprite(){for(const e of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(e),this._changedImages[e]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.k("data",{dataType:"style"}));}_validateLayer(e){const i=this.sourceCaches[e.source];if(!i)return;const r=e.sourceLayer;if(!r)return;const o=i.getSource();("geojson"===o.type||o.vectorLayerIds&&-1===o.vectorLayerIds.indexOf(r))&&this.fire(new t.j(new Error(`Source layer "${r}" does not exist on source "${o.id}" as specified by style layer "${e.id}".`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this.sourceCaches)if(!this.sourceCaches[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeByIds(e,i=!1){const r=this._serializedAllLayers();if(!e||0===e.length)return Object.values(i?t.bw(r):r);const o=[];for(const s of e)if(r[s]){const e=i?t.bw(r[s]):r[s];o.push(e);}return o}_serializedAllLayers(){let e=this._serializedLayers;if(e)return e;e=this._serializedLayers={};const t=Object.keys(this._layers);for(const i of t){const t=this._layers[i];"custom"!==t.type&&(e[i]=t.serialize());}return e}hasTransitions(){var e,t,i;if(null===(e=this.light)||void 0===e?void 0:e.hasTransition())return !0;if(null===(t=this.sky)||void 0===t?void 0:t.hasTransition())return !0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return !0;for(const e in this.sourceCaches)if(this.sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(e){if(!this._loaded)return;const i=this._changed;if(i){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const e in this._updatedSources){const t=this._updatedSources[e];if("reload"===t)this._reloadSource(e);else {if("clear"!==t)throw new Error(`Invalid action ${t}`);this._clearSource(e);}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this.sky.updateTransitions(e),this._resetUpdates();}const r={};for(const e in this.sourceCaches){const t=this.sourceCaches[e];r[e]=t.used,t.used=!1;}for(const t of this._order){const i=this._layers[t];i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0);}for(const e in r){const i=this.sourceCaches[e];!!r[e]!=!!i.used&&i.fire(new t.k("data",{sourceDataType:"visibility",dataType:"source",sourceId:e}));}this.light.recalculate(e),this.sky.recalculate(e),this.projection.recalculate(e),this.z=e.zoom,i&&this.fire(new t.k("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1;}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(e,!1),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1;}setState(e,i={}){var r;this._checkLoaded();const o=this.serialize();if(e=i.transformStyle?i.transformStyle(o,e):e,(null===(r=i.validate)||void 0===r||r)&&mi(this,t.u(e)))return !1;(e=t.bw(e)).layers=t.bu(e.layers);const s=t.bx(o,e),a=this._getOperationsToPerform(s);if(a.unimplemented.length>0)throw new Error(`Unimplemented: ${a.unimplemented.join(", ")}.`);if(0===a.operations.length)return !1;for(const e of a.operations)e();return this.stylesheet=e,this._serializedLayers=null,!0}_getOperationsToPerform(e){const t=[],i=[];for(const r of e)switch(r.command){case "setCenter":case "setZoom":case "setBearing":case "setPitch":case "setRoll":continue;case "addLayer":t.push((()=>this.addLayer.apply(this,r.args)));break;case "removeLayer":t.push((()=>this.removeLayer.apply(this,r.args)));break;case "setPaintProperty":t.push((()=>this.setPaintProperty.apply(this,r.args)));break;case "setLayoutProperty":t.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case "setFilter":t.push((()=>this.setFilter.apply(this,r.args)));break;case "addSource":t.push((()=>this.addSource.apply(this,r.args)));break;case "removeSource":t.push((()=>this.removeSource.apply(this,r.args)));break;case "setLayerZoomRange":t.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case "setLight":t.push((()=>this.setLight.apply(this,r.args)));break;case "setGeoJSONSourceData":t.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case "setGlyphs":t.push((()=>this.setGlyphs.apply(this,r.args)));break;case "setSprite":t.push((()=>this.setSprite.apply(this,r.args)));break;case "setTerrain":t.push((()=>this.map.setTerrain.apply(this,r.args)));break;case "setSky":t.push((()=>this.setSky.apply(this,r.args)));break;case "setProjection":this.setProjection.apply(this,r.args);break;case "setTransition":t.push((()=>{}));break;default:i.push(r.command);}return {operations:t,unimplemented:i}}addImage(e,i){if(this.getImage(e))return this.fire(new t.j(new Error(`An image named "${e}" already exists.`)));this.imageManager.addImage(e,i),this._afterImageUpdated(e);}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(e){if(!this.getImage(e))return this.fire(new t.j(new Error(`An image named "${e}" does not exist.`)));this.imageManager.removeImage(e),this._afterImageUpdated(e);}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.k("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,i,r={}){if(this._checkLoaded(),void 0!==this.sourceCaches[e])throw new Error(`Source "${e}" already exists.`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(t.u.source,`sources.${e}`,i,null,r))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const o=this.sourceCaches[e]=new de(e,i,this.dispatcher);o.style=this,o.setEventedParent(this,(()=>({isSourceLoaded:o.loaded(),source:o.serialize(),sourceId:e}))),o.onAdd(this.map),this._changed=!0;}removeSource(e){if(this._checkLoaded(),void 0===this.sourceCaches[e])throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===e)return this.fire(new t.j(new Error(`Source "${e}" cannot be removed while layer "${i}" is using it.`)));const i=this.sourceCaches[e];delete this.sourceCaches[e],delete this._updatedSources[e],i.fire(new t.k("data",{sourceDataType:"metadata",dataType:"source",sourceId:e})),i.setEventedParent(null),i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(e,t){if(this._checkLoaded(),void 0===this.sourceCaches[e])throw new Error(`There is no source with this ID=${e}`);const i=this.sourceCaches[e].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(t),this._changed=!0;}getSource(e){return this.sourceCaches[e]&&this.sourceCaches[e].getSource()}addLayer(e,i,r={}){this._checkLoaded();const o=e.id;if(this.getLayer(o))return void this.fire(new t.j(new Error(`Layer "${o}" already exists on this map.`)));let s;if("custom"===e.type){if(mi(this,t.by(e)))return;s=t.bv(e);}else {if("source"in e&&"object"==typeof e.source&&(this.addSource(o,e.source),e=t.bw(e),e=t.e(e,{source:o})),this._validate(t.u.layer,`layers.${o}`,e,{arrayIndex:-1},r))return;s=t.bv(e),this._validateLayer(s),s.setEventedParent(this,{layer:{id:o}});}const a=i?this._order.indexOf(i):this._order.length;if(i&&-1===a)this.fire(new t.j(new Error(`Cannot add layer "${o}" before non-existing layer "${i}".`)));else {if(this._order.splice(a,0,o),this._layerOrderChanged=!0,this._layers[o]=s,this._removedLayers[o]&&s.source&&"custom"!==s.type){const e=this._removedLayers[o];delete this._removedLayers[o],e.type!==s.type?this._updatedSources[s.source]="clear":(this._updatedSources[s.source]="reload",this.sourceCaches[s.source].pause());}this._updateLayer(s),s.onAdd&&s.onAdd(this.map);}}moveLayer(e,i){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new t.j(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===i)return;const r=this._order.indexOf(e);this._order.splice(r,1);const o=i?this._order.indexOf(i):this._order.length;i&&-1===o?this.fire(new t.j(new Error(`Cannot move layer "${e}" before non-existing layer "${i}".`))):(this._order.splice(o,0,e),this._layerOrderChanged=!0);}removeLayer(e){this._checkLoaded();const i=this._layers[e];if(!i)return void this.fire(new t.j(new Error(`Cannot remove non-existing layer "${e}".`)));i.setEventedParent(null);const r=this._order.indexOf(e);this._order.splice(r,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=i,delete this._layers[e],this._serializedLayers&&delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],i.onRemove&&i.onRemove(this.map);}getLayer(e){return this._layers[e]}getLayersOrder(){return [...this._order]}hasLayer(e){return e in this._layers}setLayerZoomRange(e,i,r){this._checkLoaded();const o=this.getLayer(e);o?o.minzoom===i&&o.maxzoom===r||(null!=i&&(o.minzoom=i),null!=r&&(o.maxzoom=r),this._updateLayer(o)):this.fire(new t.j(new Error(`Cannot set the zoom range of non-existing layer "${e}".`)));}setFilter(e,i,r={}){this._checkLoaded();const o=this.getLayer(e);if(o){if(!t.bz(o.filter,i))return null==i?(o.filter=void 0,void this._updateLayer(o)):void(this._validate(t.u.filter,`layers.${o.id}.filter`,i,null,r)||(o.filter=t.bw(i),this._updateLayer(o)))}else this.fire(new t.j(new Error(`Cannot filter non-existing layer "${e}".`)));}getFilter(e){return t.bw(this.getLayer(e).filter)}setLayoutProperty(e,i,r,o={}){this._checkLoaded();const s=this.getLayer(e);s?t.bz(s.getLayoutProperty(i),r)||(s.setLayoutProperty(i,r,o),this._updateLayer(s)):this.fire(new t.j(new Error(`Cannot style non-existing layer "${e}".`)));}getLayoutProperty(e,i){const r=this.getLayer(e);if(r)return r.getLayoutProperty(i);this.fire(new t.j(new Error(`Cannot get style of non-existing layer "${e}".`)));}setPaintProperty(e,i,r,o={}){this._checkLoaded();const s=this.getLayer(e);s?t.bz(s.getPaintProperty(i),r)||(s.setPaintProperty(i,r,o)&&this._updateLayer(s),this._changed=!0,this._updatedPaintProps[e]=!0,this._serializedLayers=null):this.fire(new t.j(new Error(`Cannot style non-existing layer "${e}".`)));}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(e,i){this._checkLoaded();const r=e.source,o=e.sourceLayer,s=this.sourceCaches[r];if(void 0===s)return void this.fire(new t.j(new Error(`The source '${r}' does not exist in the map's style.`)));const a=s.getSource().type;"geojson"===a&&o?this.fire(new t.j(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==a||o?(void 0===e.id&&this.fire(new t.j(new Error("The feature id parameter must be provided."))),s.setFeatureState(o,e.id,i)):this.fire(new t.j(new Error("The sourceLayer parameter must be provided for vector source types.")));}removeFeatureState(e,i){this._checkLoaded();const r=e.source,o=this.sourceCaches[r];if(void 0===o)return void this.fire(new t.j(new Error(`The source '${r}' does not exist in the map's style.`)));const s=o.getSource().type,a="vector"===s?e.sourceLayer:void 0;"vector"!==s||a?i&&"string"!=typeof e.id&&"number"!=typeof e.id?this.fire(new t.j(new Error("A feature id is required to remove its specific state property."))):o.removeFeatureState(a,e.id,i):this.fire(new t.j(new Error("The sourceLayer parameter must be provided for vector source types.")));}getFeatureState(e){this._checkLoaded();const i=e.source,r=e.sourceLayer,o=this.sourceCaches[i];if(void 0!==o)return "vector"!==o.getSource().type||r?(void 0===e.id&&this.fire(new t.j(new Error("The feature id parameter must be provided."))),o.getFeatureState(r,e.id)):void this.fire(new t.j(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new t.j(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return t.e({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const e=t.bA(this.sourceCaches,(e=>e.serialize())),i=this._serializeByIds(this._order,!0),r=this.map.getTerrain()||void 0,o=this.stylesheet;return t.bB({version:o.version,name:o.name,metadata:o.metadata,light:o.light,sky:o.sky,center:o.center,zoom:o.zoom,bearing:o.bearing,pitch:o.pitch,sprite:o.sprite,glyphs:o.glyphs,transition:o.transition,projection:o.projection,sources:e,layers:i,terrain:r},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0,e.source&&!this._updatedSources[e.source]&&"raster"!==this.sourceCaches[e.source].getSource().type&&(this._updatedSources[e.source]="reload",this.sourceCaches[e.source].pause()),this._serializedLayers=null,this._changed=!0;}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},r=[];for(let o=this._order.length-1;o>=0;o--){const s=this._order[o];if(t(s)){i[s]=o;for(const t of e){const e=t[s];if(e)for(const t of e)r.push(t);}}}r.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const o=[];for(let s=this._order.length-1;s>=0;s--){const a=this._order[s];if(t(a))for(let e=r.length-1;e>=0;e--){const t=r[e].feature;if(i[t.layer.id]<s)break;o.push(t),r.pop();}else for(const t of e){const e=t[a];if(e)for(const t of e)o.push(t.feature);}}return o}queryRenderedFeatures(e,i,r){i&&i.filter&&this._validate(t.u.filter,"queryRenderedFeatures.filter",i.filter,null,i);const o={};if(i&&i.layers){if(!(Array.isArray(i.layers)||i.layers instanceof Set))return this.fire(new t.j(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const e of i.layers){const i=this._layers[e];if(!i)return this.fire(new t.j(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];o[i.source]=!0;}}const s=[];i.availableImages=this._availableImages;const a=this._serializedAllLayers(),n=i.layers instanceof Set?i.layers:Array.isArray(i.layers)?new Set(i.layers):null,l=Object.assign(Object.assign({},i),{layers:n});for(const t in this.sourceCaches)i.layers&&!o[t]||s.push(N(this.sourceCaches[t],this._layers,a,e,l,r));return this.placement&&s.push(function(e,t,i,r,o,s,a){const n={},l=s.queryRenderedSymbols(r),c=[];for(const e of Object.keys(l).map(Number))c.push(a[e]);c.sort(Z);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,o.filter,o.layers,o.availableImages,e);for(const e in r){const t=n[e]=n[e]||[],o=r[e];o.sort(((e,t)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(e.featureIndex);return r.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of o)t.push(e);}}return function(e,t,i){for(const r in e)for(const o of e[r])G(o,i[t[r].source]);return e}(n,e,i)}(this._layers,a,this.sourceCaches,e,l,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(s)}querySourceFeatures(e,i){i&&i.filter&&this._validate(t.u.filter,"querySourceFeatures.filter",i.filter,null,i);const r=this.sourceCaches[e];return r?function(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),r=[],o={};for(let e=0;e<i.length;e++){const s=i[e],a=s.tileID.canonical.key;o[a]||(o[a]=!0,s.querySourceFeatures(r,t));}return r}(r,i):[]}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const r=this.light.getLight();let o=!1;for(const i in e)if(!t.bz(e[i],r[i])){o=!0;break}if(!o)return;const s={now:a.now(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,i),this.light.updateTransitions(s);}getProjection(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.projection}setProjection(e){if(this._checkLoaded(),this.projection){if(this.projection.name===e.type)return;this.projection.destroy(),delete this.projection;}this.stylesheet.projection=e,this._setProjectionInternal(e.type);}getSky(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.sky}setSky(e,i={}){this._checkLoaded();const r=this.getSky();let o=!1;if(!e&&!r)return;if(e&&!r)o=!0;else if(!e&&r)o=!0;else for(const i in e)if(!t.bz(e[i],r[i])){o=!0;break}if(!o)return;const s={now:a.now(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=e,this.sky.setSky(e,i),this.sky.updateTransitions(s);}_setProjectionInternal(e){const i=function(e){if(Array.isArray(e)){const t=new Kt({type:e});return {projection:t,transform:new di,cameraHelper:new pi(t)}}switch(e){case "mercator":return {projection:new vt,transform:new Dt,cameraHelper:new kt};case "globe":{const e=new Kt({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return {projection:e,transform:new di,cameraHelper:new pi(e)}}case "vertical-perspective":return {projection:new Xt,transform:new ui,cameraHelper:new _i};default:return t.w(`Unknown projection name: ${e}. Falling back to mercator projection.`),{projection:new vt,transform:new Dt,cameraHelper:new kt}}}(e);this.projection=i.projection,this.map.migrateProjection(i.transform,i.cameraHelper);for(const e in this.sourceCaches)this.sourceCaches[e].reload();}_validate(e,i,r,o,s={}){return (!s||!1!==s.validate)&&mi(this,e.call(t.u,t.e({key:i,style:this.serialize(),value:r,styleSpec:t.v},o)))}_remove(e=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),oe().off(te,this._rtlPluginLoaded);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this.sourceCaches){const t=this.sourceCaches[e];t.setEventedParent(null),t.onRemove(this.map);}this.imageManager.setEventedParent(null),this.setEventedParent(null),e&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(e);}_clearSource(e){this.sourceCaches[e].clearTiles();}_reloadSource(e){this.sourceCaches[e].resume(),this.sourceCaches[e].reload();}_updateSources(e){for(const t in this.sourceCaches)this.sourceCaches[t].update(e,this.map.terrain);}_generateCollisionBoxes(){for(const e in this.sourceCaches)this._reloadSource(e);}_updatePlacement(e,t,i,r,o=!1){let s=!1,n=!1;const l={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!l[i.source]){const e=this.sourceCaches[i.source];l[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const r=this.crossTileSymbolIndex.addLayer(i,l[i.source],e.center.lng);s=s||r;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((o=o||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(a.now(),e.zoom))&&(this.pauseablePlacement=new st(e,this.map.terrain,this._order,o,t,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(a.now()),n=!0),s&&this.pauseablePlacement.placement.setStale()),n||s)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,l[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(a.now())}_releaseSymbolFadeTiles(){for(const e in this.sourceCaches)this.sourceCaches[e].releaseSymbolFadeTiles();}getImages(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.imageManager.getImages(i.icons);this._updateTilesForChangedImages();const t=this.sourceCaches[i.source];return t&&t.setDependencies(i.tileID.key,i.type,i.icons),e}))}getGlyphs(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.glyphManager.getGlyphs(i.stacks),t=this.sourceCaches[i.source];return t&&t.setDependencies(i.tileID.key,i.type,[""]),e}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(e,i={}){this._checkLoaded(),e&&this._validate(t.u.glyphs,"glyphs",e,null,i)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=e,this.glyphManager.entries={},this.glyphManager.setURL(e));}addSprite(e,i,r={},o){this._checkLoaded();const s=[{id:e,url:i}],a=[...f(this.stylesheet.sprite),...s];this._validate(t.u.sprite,"sprite",a,null,r)||(this.stylesheet.sprite=a,this._loadSprite(s,!0,o));}removeSprite(e){this._checkLoaded();const i=f(this.stylesheet.sprite);if(i.find((t=>t.id===e))){if(this._spritesImagesIds[e])for(const t of this._spritesImagesIds[e])this.imageManager.removeImage(t),this._changedImages[t]=!0;i.splice(i.findIndex((t=>t.id===e)),1),this.stylesheet.sprite=i.length>0?i:void 0,delete this._spritesImagesIds[e],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.k("data",{dataType:"style"}));}else this.fire(new t.j(new Error(`Sprite "${e}" doesn't exists on this map.`)));}getSprite(){return f(this.stylesheet.sprite)}setSprite(e,i={},r){this._checkLoaded(),e&&this._validate(t.u.sprite,"sprite",e,null,i)||(this.stylesheet.sprite=e,e?this._loadSprite(e,!0,r):(this._unloadSprite(),r&&r(null)));}}var vi=t.aA([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class xi{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(e,t,i,r,o,s,a,n,l){this.context=e;let c=this.boundPaintVertexBuffers.length!==r.length;for(let e=0;!c&&e<r.length;e++)this.boundPaintVertexBuffers[e]!==r[e]&&(c=!0);!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==o||this.boundVertexOffset!==s||this.boundDynamicVertexBuffer!==a||this.boundDynamicVertexBuffer2!==n||this.boundDynamicVertexBuffer3!==l?this.freshBind(t,i,r,o,s,a,n,l):(e.bindVertexArray.set(this.vao),a&&a.bind(),o&&o.dynamicDraw&&o.bind(),n&&n.bind(),l&&l.bind());}freshBind(e,t,i,r,o,s,a,n){const l=e.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=o,this.boundDynamicVertexBuffer=s,this.boundDynamicVertexBuffer2=a,this.boundDynamicVertexBuffer3=n,t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);s&&s.enableAttributes(h,e),a&&a.enableAttributes(h,e),n&&n.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,o);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,o);s&&(s.bind(),s.setVertexAttribPointers(h,e,o)),r&&r.bind(),a&&(a.bind(),a.setVertexAttribPointers(h,e,o)),n&&(n.bind(),n.setVertexAttribPointers(h,e,o)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null);}}const bi=(e,i,r,o,s)=>({u_texture:0,u_ele_delta:e,u_fog_matrix:i,u_fog_color:r?r.properties.get("fog-color"):t.b4.white,u_fog_ground_blend:r?r.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:s?0:r?r.calculateFogBlendOpacity(o):0,u_horizon_color:r?r.properties.get("horizon-color"):t.b4.white,u_horizon_fog_blend:r?r.properties.get("horizon-fog-blend"):1,u_is_globe_mode:s?1:0}),yi={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function wi(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const r=e[i].split(" ");t.push(r.pop());}return t}class Ti{constructor(e,i,r,o,s,a,n,l){const c=e.gl;this.program=c.createProgram();const h=wi(i.staticAttributes),u=r?r.getBinderAttributes():[],d=h.concat(u),_=dt.prelude.staticUniforms?wi(dt.prelude.staticUniforms):[],p=n.staticUniforms?wi(n.staticUniforms):[],m=i.staticUniforms?wi(i.staticUniforms):[],f=r?r.getBinderUniforms():[],g=_.concat(p).concat(m).concat(f),v=[];for(const e of g)v.indexOf(e)<0&&v.push(e);const x=r?r.defines():[];Ut(c)&&x.unshift("#version 300 es"),s&&x.push("#define OVERDRAW_INSPECTOR;"),a&&x.push("#define TERRAIN3D;"),l&&x.push(l);let b=x.concat(dt.prelude.fragmentSource,n.fragmentSource,i.fragmentSource).join("\n"),y=x.concat(dt.prelude.vertexSource,n.vertexSource,i.vertexSource).join("\n");Ut(c)||(b=function(e){return e.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(b),y=function(e){return e.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(y));const w=c.createShader(c.FRAGMENT_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(w,b),c.compileShader(w),!c.getShaderParameter(w,c.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${c.getShaderInfoLog(w)}`);c.attachShader(this.program,w);const T=c.createShader(c.VERTEX_SHADER);if(c.isContextLost())return void(this.failedToCreate=!0);if(c.shaderSource(T,y),c.compileShader(T),!c.getShaderParameter(T,c.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${c.getShaderInfoLog(T)}`);c.attachShader(this.program,T),this.attributes={};const P={};this.numAttributes=d.length;for(let e=0;e<this.numAttributes;e++)d[e]&&(c.bindAttribLocation(this.program,e,d[e]),this.attributes[d[e]]=e);if(c.linkProgram(this.program),!c.getProgramParameter(this.program,c.LINK_STATUS))throw new Error(`Program failed to link: ${c.getProgramInfoLog(this.program)}`);c.deleteShader(T),c.deleteShader(w);for(let e=0;e<v.length;e++){const t=v[e];if(t&&!P[t]){const e=c.getUniformLocation(this.program,t);e&&(P[t]=e);}}this.fixedUniforms=o(e,P),this.terrainUniforms=((e,i)=>({u_depth:new t.bC(e,i.u_depth),u_terrain:new t.bC(e,i.u_terrain),u_terrain_dim:new t.b5(e,i.u_terrain_dim),u_terrain_matrix:new t.bD(e,i.u_terrain_matrix),u_terrain_unpack:new t.bE(e,i.u_terrain_unpack),u_terrain_exaggeration:new t.b5(e,i.u_terrain_exaggeration)}))(e,P),this.projectionUniforms=((e,i)=>({u_projection_matrix:new t.bD(e,i.u_projection_matrix),u_projection_tile_mercator_coords:new t.bE(e,i.u_projection_tile_mercator_coords),u_projection_clipping_plane:new t.bE(e,i.u_projection_clipping_plane),u_projection_transition:new t.b5(e,i.u_projection_transition),u_projection_fallback_matrix:new t.bD(e,i.u_projection_fallback_matrix)}))(e,P),this.binderUniforms=r?r.getUniforms(e,P):[];}draw(e,t,i,r,o,s,a,n,l,c,h,u,d,_,p,m,f,g,v){const x=e.gl;if(this.failedToCreate)return;if(e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(r),e.setColorMode(o),e.setCullFace(s),n){e.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,n.depthTexture),e.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,n.texture);for(const e in this.terrainUniforms)this.terrainUniforms[e].set(n[e]);}if(l)for(const e in l)this.projectionUniforms[yi[e]].set(l[e]);if(a)for(const e in this.fixedUniforms)this.fixedUniforms[e].set(a[e]);m&&m.setUniforms(e,this.binderUniforms,_,{zoom:p});let b=0;switch(t){case x.LINES:b=2;break;case x.TRIANGLES:b=3;break;case x.LINE_STRIP:b=1;}for(const i of d.get()){const r=i.vaos||(i.vaos={});(r[c]||(r[c]=new xi)).bind(e,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,f,g,v),x.drawElements(t,i.primitiveLength*b,x.UNSIGNED_SHORT,i.primitiveOffset*b*2);}}}function Pi(e,i,r){const o=1/t.at(r,1,i.transform.tileZoom),s=Math.pow(2,r.tileID.overscaledZ),a=r.tileSize*Math.pow(2,i.transform.tileZoom)/s,n=a*(r.tileID.canonical.x+r.tileID.wrap*s),l=a*r.tileID.canonical.y;return {u_image:0,u_texsize:r.imageAtlasTexture.size,u_scale:[o,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[n>>16,l>>16],u_pixel_coord_lower:[65535&n,65535&l]}}const Ci=(e,i,r,o)=>{const s=e.style.light,a=s.properties.get("position"),n=[a.x,a.y,a.z],l=t.bI();"viewport"===s.properties.get("anchor")&&t.bJ(l,e.transform.bearingInRadians),t.bK(n,n,l);const c=e.transform.transformLightDirection(n),h=s.properties.get("color");return {u_lightpos:n,u_lightpos_globe:c,u_lightintensity:s.properties.get("intensity"),u_lightcolor:[h.r,h.g,h.b],u_vertical_gradient:+i,u_opacity:r,u_fill_translate:o}},Ii=(e,i,r,o,s,a,n)=>t.e(Ci(e,i,r,o),Pi(a,e,n),{u_height_factor:-Math.pow(2,s.overscaledZ)/n.tileSize/8}),Ei=(e,i,r,o)=>t.e(Pi(i,e,r),{u_fill_translate:o}),Mi=(e,t)=>({u_world:e,u_fill_translate:t}),Si=(e,i,r,o,s)=>t.e(Ei(e,i,r,s),{u_world:o}),Ri=(e,i,r,o,s)=>{const a=e.transform;let n,l,c=0;if("map"===r.paint.get("circle-pitch-alignment")){const e=t.at(i,1,a.zoom);n=!0,l=[e,e],c=e/(t.X*Math.pow(2,i.tileID.overscaledZ))*2*Math.PI*s;}else n=!1,l=a.pixelsToGLUnits;return {u_camera_to_center_distance:a.cameraToCenterDistance,u_scale_with_map:+("map"===r.paint.get("circle-pitch-scale")),u_pitch_with_map:+n,u_device_pixel_ratio:e.pixelRatio,u_extrude_scale:l,u_globe_extrude_scale:c,u_translate:o}},Di=e=>({u_pixel_extrude_scale:[1/e.width,1/e.height]}),zi=e=>({u_viewport_size:[e.width,e.height]}),Ai=(e,t=1)=>({u_color:e,u_overlay:0,u_overlay_scale:t}),Li=(e,i,r,o)=>{const s=t.at(e,1,i)/(t.X*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*o;return {u_extrude_scale:t.at(e,1,i),u_intensity:r,u_globe_extrude_scale:s}},ki=(e,i,r,o)=>{const s=t.H();t.bL(s,0,e.width,e.height,0,0,1);const a=e.context.gl;return {u_matrix:s,u_world:[a.drawingBufferWidth,a.drawingBufferHeight],u_image:r,u_color_ramp:o,u_opacity:i.paint.get("heatmap-opacity")}},Fi=(e,t,i)=>{const r=i.paint.get("hillshade-shadow-color"),o=i.paint.get("hillshade-highlight-color"),s=i.paint.get("hillshade-accent-color");let a=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);return "viewport"===i.paint.get("hillshade-illumination-anchor")&&(a+=e.transform.bearingInRadians),{u_image:0,u_latrange:ji(0,t.tileID),u_light:[i.paint.get("hillshade-exaggeration"),a],u_shadow:r,u_highlight:o,u_accent:s}},Bi=(e,i)=>{const r=i.stride,o=t.H();return t.bL(o,0,t.X,-8192,0,0,1),t.J(o,o,[0,-8192,0]),{u_matrix:o,u_image:1,u_dimension:[r,r],u_zoom:e.overscaledZ,u_unpack:i.getUnpackVector()}};function ji(e,i){const r=Math.pow(2,i.canonical.z),o=i.canonical.y;return [new t.Y(0,o/r).toLngLat().lat,new t.Y(0,(o+1)/r).toLngLat().lat]}const Oi=(e,i,r,o)=>{const s=e.transform;return {u_translation:Vi(e,i,r),u_ratio:o/t.at(i,1,s.zoom),u_device_pixel_ratio:e.pixelRatio,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},Ni=(e,i,r,o,s)=>t.e(Oi(e,i,r,o),{u_image:0,u_image_height:s}),Zi=(e,i,r,o,s)=>{const a=e.transform,n=Ui(i,a);return {u_translation:Vi(e,i,r),u_texsize:i.imageAtlasTexture.size,u_ratio:o/t.at(i,1,a.zoom),u_device_pixel_ratio:e.pixelRatio,u_image:0,u_scale:[n,s.fromScale,s.toScale],u_fade:s.t,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]]}},Gi=(e,i,r,o,s,a)=>{const n=e.lineAtlas,l=Ui(i,e.transform),c="round"===r.layout.get("line-cap"),h=n.getDash(s.from,c),u=n.getDash(s.to,c),d=h.width*a.fromScale,_=u.width*a.toScale;return t.e(Oi(e,i,r,o),{u_patternscale_a:[l/d,-h.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:n.width/(256*Math.min(d,_)*e.pixelRatio)/2,u_image:0,u_tex_y_a:h.y,u_tex_y_b:u.y,u_mix:a.t})};function Ui(e,i){return 1/t.at(e,1,i.tileZoom)}function Vi(e,i,r){return t.au(e.transform,i,r.paint.get("line-translate"),r.paint.get("line-translate-anchor"))}const qi=(e,t,i,r,o)=>{return {u_tl_parent:e,u_scale_parent:t,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(a=r.paint.get("raster-saturation"),a>0?1-1/(1.001-a):-a),u_contrast_factor:(s=r.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:Hi(r.paint.get("raster-hue-rotate")),u_coords_top:[o[0].x,o[0].y,o[1].x,o[1].y],u_coords_bottom:[o[3].x,o[3].y,o[2].x,o[2].y]};var s,a;};function Hi(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const Wi=(e,t,i,r,o,s,a,n,l,c,h,u,d)=>{const _=a.transform;return {u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:_.cameraToCenterDistance,u_pitch:_.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:_.width/_.height,u_fade_change:a.options.fadeDuration?a.symbolFadeChange:1,u_label_plane_matrix:n,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+r,u_is_along_line:o,u_is_variable_anchor:s,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:d}},Xi=(e,i,r,o,s,a,n,l,c,h,u,d,_,p)=>{const m=n.transform;return t.e(Wi(e,i,r,o,s,a,n,l,c,h,u,d,p),{u_gamma_scale:o?Math.cos(m.pitch*Math.PI/180)*m.cameraToCenterDistance:1,u_device_pixel_ratio:n.pixelRatio,u_is_halo:1})},$i=(e,i,r,o,s,a,n,l,c,h,u,d,_)=>t.e(Xi(e,i,r,o,s,a,n,l,c,h,!0,u,0,_),{u_texsize_icon:d,u_texture_icon:1}),Ki=(e,t)=>({u_opacity:e,u_color:t}),Yi=(e,i,r,o,s)=>t.e(function(e,i,r,o){const s=r.imageManager.getPattern(e.from.toString()),a=r.imageManager.getPattern(e.to.toString()),{width:n,height:l}=r.imageManager.getPixelSize(),c=Math.pow(2,o.tileID.overscaledZ),h=o.tileSize*Math.pow(2,r.transform.tileZoom)/c,u=h*(o.tileID.canonical.x+o.tileID.wrap*c),d=h*o.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:s.tl,u_pattern_br_a:s.br,u_pattern_tl_b:a.tl,u_pattern_br_b:a.br,u_texsize:[n,l],u_mix:i.t,u_pattern_size_a:s.displaySize,u_pattern_size_b:a.displaySize,u_scale_a:i.fromScale,u_scale_b:i.toScale,u_tile_units_to_pixels:1/t.at(o,1,r.transform.tileZoom),u_pixel_coord_upper:[u>>16,d>>16],u_pixel_coord_lower:[65535&u,65535&d]}}(r,s,i,o),{u_opacity:e}),Ji=(e,t)=>{},Qi={fillExtrusion:(e,i)=>({u_lightpos:new t.bG(e,i.u_lightpos),u_lightpos_globe:new t.bG(e,i.u_lightpos_globe),u_lightintensity:new t.b5(e,i.u_lightintensity),u_lightcolor:new t.bG(e,i.u_lightcolor),u_vertical_gradient:new t.b5(e,i.u_vertical_gradient),u_opacity:new t.b5(e,i.u_opacity),u_fill_translate:new t.bH(e,i.u_fill_translate)}),fillExtrusionPattern:(e,i)=>({u_lightpos:new t.bG(e,i.u_lightpos),u_lightpos_globe:new t.bG(e,i.u_lightpos_globe),u_lightintensity:new t.b5(e,i.u_lightintensity),u_lightcolor:new t.bG(e,i.u_lightcolor),u_vertical_gradient:new t.b5(e,i.u_vertical_gradient),u_height_factor:new t.b5(e,i.u_height_factor),u_opacity:new t.b5(e,i.u_opacity),u_fill_translate:new t.bH(e,i.u_fill_translate),u_image:new t.bC(e,i.u_image),u_texsize:new t.bH(e,i.u_texsize),u_pixel_coord_upper:new t.bH(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bH(e,i.u_pixel_coord_lower),u_scale:new t.bG(e,i.u_scale),u_fade:new t.b5(e,i.u_fade)}),fill:(e,i)=>({u_fill_translate:new t.bH(e,i.u_fill_translate)}),fillPattern:(e,i)=>({u_image:new t.bC(e,i.u_image),u_texsize:new t.bH(e,i.u_texsize),u_pixel_coord_upper:new t.bH(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bH(e,i.u_pixel_coord_lower),u_scale:new t.bG(e,i.u_scale),u_fade:new t.b5(e,i.u_fade),u_fill_translate:new t.bH(e,i.u_fill_translate)}),fillOutline:(e,i)=>({u_world:new t.bH(e,i.u_world),u_fill_translate:new t.bH(e,i.u_fill_translate)}),fillOutlinePattern:(e,i)=>({u_world:new t.bH(e,i.u_world),u_image:new t.bC(e,i.u_image),u_texsize:new t.bH(e,i.u_texsize),u_pixel_coord_upper:new t.bH(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bH(e,i.u_pixel_coord_lower),u_scale:new t.bG(e,i.u_scale),u_fade:new t.b5(e,i.u_fade),u_fill_translate:new t.bH(e,i.u_fill_translate)}),circle:(e,i)=>({u_camera_to_center_distance:new t.b5(e,i.u_camera_to_center_distance),u_scale_with_map:new t.bC(e,i.u_scale_with_map),u_pitch_with_map:new t.bC(e,i.u_pitch_with_map),u_extrude_scale:new t.bH(e,i.u_extrude_scale),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_globe_extrude_scale:new t.b5(e,i.u_globe_extrude_scale),u_translate:new t.bH(e,i.u_translate)}),collisionBox:(e,i)=>({u_pixel_extrude_scale:new t.bH(e,i.u_pixel_extrude_scale)}),collisionCircle:(e,i)=>({u_viewport_size:new t.bH(e,i.u_viewport_size)}),debug:(e,i)=>({u_color:new t.bF(e,i.u_color),u_overlay:new t.bC(e,i.u_overlay),u_overlay_scale:new t.b5(e,i.u_overlay_scale)}),depth:Ji,clippingMask:Ji,heatmap:(e,i)=>({u_extrude_scale:new t.b5(e,i.u_extrude_scale),u_intensity:new t.b5(e,i.u_intensity),u_globe_extrude_scale:new t.b5(e,i.u_globe_extrude_scale)}),heatmapTexture:(e,i)=>({u_matrix:new t.bD(e,i.u_matrix),u_world:new t.bH(e,i.u_world),u_image:new t.bC(e,i.u_image),u_color_ramp:new t.bC(e,i.u_color_ramp),u_opacity:new t.b5(e,i.u_opacity)}),hillshade:(e,i)=>({u_image:new t.bC(e,i.u_image),u_latrange:new t.bH(e,i.u_latrange),u_light:new t.bH(e,i.u_light),u_shadow:new t.bF(e,i.u_shadow),u_highlight:new t.bF(e,i.u_highlight),u_accent:new t.bF(e,i.u_accent)}),hillshadePrepare:(e,i)=>({u_matrix:new t.bD(e,i.u_matrix),u_image:new t.bC(e,i.u_image),u_dimension:new t.bH(e,i.u_dimension),u_zoom:new t.b5(e,i.u_zoom),u_unpack:new t.bE(e,i.u_unpack)}),line:(e,i)=>({u_translation:new t.bH(e,i.u_translation),u_ratio:new t.b5(e,i.u_ratio),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.bH(e,i.u_units_to_pixels)}),lineGradient:(e,i)=>({u_translation:new t.bH(e,i.u_translation),u_ratio:new t.b5(e,i.u_ratio),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.bH(e,i.u_units_to_pixels),u_image:new t.bC(e,i.u_image),u_image_height:new t.b5(e,i.u_image_height)}),linePattern:(e,i)=>({u_translation:new t.bH(e,i.u_translation),u_texsize:new t.bH(e,i.u_texsize),u_ratio:new t.b5(e,i.u_ratio),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_image:new t.bC(e,i.u_image),u_units_to_pixels:new t.bH(e,i.u_units_to_pixels),u_scale:new t.bG(e,i.u_scale),u_fade:new t.b5(e,i.u_fade)}),lineSDF:(e,i)=>({u_translation:new t.bH(e,i.u_translation),u_ratio:new t.b5(e,i.u_ratio),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.bH(e,i.u_units_to_pixels),u_patternscale_a:new t.bH(e,i.u_patternscale_a),u_patternscale_b:new t.bH(e,i.u_patternscale_b),u_sdfgamma:new t.b5(e,i.u_sdfgamma),u_image:new t.bC(e,i.u_image),u_tex_y_a:new t.b5(e,i.u_tex_y_a),u_tex_y_b:new t.b5(e,i.u_tex_y_b),u_mix:new t.b5(e,i.u_mix)}),raster:(e,i)=>({u_tl_parent:new t.bH(e,i.u_tl_parent),u_scale_parent:new t.b5(e,i.u_scale_parent),u_buffer_scale:new t.b5(e,i.u_buffer_scale),u_fade_t:new t.b5(e,i.u_fade_t),u_opacity:new t.b5(e,i.u_opacity),u_image0:new t.bC(e,i.u_image0),u_image1:new t.bC(e,i.u_image1),u_brightness_low:new t.b5(e,i.u_brightness_low),u_brightness_high:new t.b5(e,i.u_brightness_high),u_saturation_factor:new t.b5(e,i.u_saturation_factor),u_contrast_factor:new t.b5(e,i.u_contrast_factor),u_spin_weights:new t.bG(e,i.u_spin_weights),u_coords_top:new t.bE(e,i.u_coords_top),u_coords_bottom:new t.bE(e,i.u_coords_bottom)}),symbolIcon:(e,i)=>({u_is_size_zoom_constant:new t.bC(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bC(e,i.u_is_size_feature_constant),u_size_t:new t.b5(e,i.u_size_t),u_size:new t.b5(e,i.u_size),u_camera_to_center_distance:new t.b5(e,i.u_camera_to_center_distance),u_pitch:new t.b5(e,i.u_pitch),u_rotate_symbol:new t.bC(e,i.u_rotate_symbol),u_aspect_ratio:new t.b5(e,i.u_aspect_ratio),u_fade_change:new t.b5(e,i.u_fade_change),u_label_plane_matrix:new t.bD(e,i.u_label_plane_matrix),u_coord_matrix:new t.bD(e,i.u_coord_matrix),u_is_text:new t.bC(e,i.u_is_text),u_pitch_with_map:new t.bC(e,i.u_pitch_with_map),u_is_along_line:new t.bC(e,i.u_is_along_line),u_is_variable_anchor:new t.bC(e,i.u_is_variable_anchor),u_texsize:new t.bH(e,i.u_texsize),u_texture:new t.bC(e,i.u_texture),u_translation:new t.bH(e,i.u_translation),u_pitched_scale:new t.b5(e,i.u_pitched_scale)}),symbolSDF:(e,i)=>({u_is_size_zoom_constant:new t.bC(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bC(e,i.u_is_size_feature_constant),u_size_t:new t.b5(e,i.u_size_t),u_size:new t.b5(e,i.u_size),u_camera_to_center_distance:new t.b5(e,i.u_camera_to_center_distance),u_pitch:new t.b5(e,i.u_pitch),u_rotate_symbol:new t.bC(e,i.u_rotate_symbol),u_aspect_ratio:new t.b5(e,i.u_aspect_ratio),u_fade_change:new t.b5(e,i.u_fade_change),u_label_plane_matrix:new t.bD(e,i.u_label_plane_matrix),u_coord_matrix:new t.bD(e,i.u_coord_matrix),u_is_text:new t.bC(e,i.u_is_text),u_pitch_with_map:new t.bC(e,i.u_pitch_with_map),u_is_along_line:new t.bC(e,i.u_is_along_line),u_is_variable_anchor:new t.bC(e,i.u_is_variable_anchor),u_texsize:new t.bH(e,i.u_texsize),u_texture:new t.bC(e,i.u_texture),u_gamma_scale:new t.b5(e,i.u_gamma_scale),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_is_halo:new t.bC(e,i.u_is_halo),u_translation:new t.bH(e,i.u_translation),u_pitched_scale:new t.b5(e,i.u_pitched_scale)}),symbolTextAndIcon:(e,i)=>({u_is_size_zoom_constant:new t.bC(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bC(e,i.u_is_size_feature_constant),u_size_t:new t.b5(e,i.u_size_t),u_size:new t.b5(e,i.u_size),u_camera_to_center_distance:new t.b5(e,i.u_camera_to_center_distance),u_pitch:new t.b5(e,i.u_pitch),u_rotate_symbol:new t.bC(e,i.u_rotate_symbol),u_aspect_ratio:new t.b5(e,i.u_aspect_ratio),u_fade_change:new t.b5(e,i.u_fade_change),u_label_plane_matrix:new t.bD(e,i.u_label_plane_matrix),u_coord_matrix:new t.bD(e,i.u_coord_matrix),u_is_text:new t.bC(e,i.u_is_text),u_pitch_with_map:new t.bC(e,i.u_pitch_with_map),u_is_along_line:new t.bC(e,i.u_is_along_line),u_is_variable_anchor:new t.bC(e,i.u_is_variable_anchor),u_texsize:new t.bH(e,i.u_texsize),u_texsize_icon:new t.bH(e,i.u_texsize_icon),u_texture:new t.bC(e,i.u_texture),u_texture_icon:new t.bC(e,i.u_texture_icon),u_gamma_scale:new t.b5(e,i.u_gamma_scale),u_device_pixel_ratio:new t.b5(e,i.u_device_pixel_ratio),u_is_halo:new t.bC(e,i.u_is_halo),u_translation:new t.bH(e,i.u_translation),u_pitched_scale:new t.b5(e,i.u_pitched_scale)}),background:(e,i)=>({u_opacity:new t.b5(e,i.u_opacity),u_color:new t.bF(e,i.u_color)}),backgroundPattern:(e,i)=>({u_opacity:new t.b5(e,i.u_opacity),u_image:new t.bC(e,i.u_image),u_pattern_tl_a:new t.bH(e,i.u_pattern_tl_a),u_pattern_br_a:new t.bH(e,i.u_pattern_br_a),u_pattern_tl_b:new t.bH(e,i.u_pattern_tl_b),u_pattern_br_b:new t.bH(e,i.u_pattern_br_b),u_texsize:new t.bH(e,i.u_texsize),u_mix:new t.b5(e,i.u_mix),u_pattern_size_a:new t.bH(e,i.u_pattern_size_a),u_pattern_size_b:new t.bH(e,i.u_pattern_size_b),u_scale_a:new t.b5(e,i.u_scale_a),u_scale_b:new t.b5(e,i.u_scale_b),u_pixel_coord_upper:new t.bH(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.bH(e,i.u_pixel_coord_lower),u_tile_units_to_pixels:new t.b5(e,i.u_tile_units_to_pixels)}),terrain:(e,i)=>({u_texture:new t.bC(e,i.u_texture),u_ele_delta:new t.b5(e,i.u_ele_delta),u_fog_matrix:new t.bD(e,i.u_fog_matrix),u_fog_color:new t.bF(e,i.u_fog_color),u_fog_ground_blend:new t.b5(e,i.u_fog_ground_blend),u_fog_ground_blend_opacity:new t.b5(e,i.u_fog_ground_blend_opacity),u_horizon_color:new t.bF(e,i.u_horizon_color),u_horizon_fog_blend:new t.b5(e,i.u_horizon_fog_blend),u_is_globe_mode:new t.b5(e,i.u_is_globe_mode)}),terrainDepth:(e,i)=>({u_ele_delta:new t.b5(e,i.u_ele_delta)}),terrainCoords:(e,i)=>({u_texture:new t.bC(e,i.u_texture),u_terrain_coords_id:new t.b5(e,i.u_terrain_coords_id),u_ele_delta:new t.b5(e,i.u_ele_delta)}),projectionErrorMeasurement:(e,i)=>({u_input:new t.b5(e,i.u_input),u_output_expected:new t.b5(e,i.u_output_expected)}),atmosphere:(e,i)=>({u_sun_pos:new t.bG(e,i.u_sun_pos),u_atmosphere_blend:new t.b5(e,i.u_atmosphere_blend),u_globe_position:new t.bG(e,i.u_globe_position),u_globe_radius:new t.b5(e,i.u_globe_radius),u_inv_proj_matrix:new t.bD(e,i.u_inv_proj_matrix)}),sky:(e,i)=>({u_sky_color:new t.bF(e,i.u_sky_color),u_horizon_color:new t.bF(e,i.u_horizon_color),u_horizon:new t.bH(e,i.u_horizon),u_horizon_normal:new t.bH(e,i.u_horizon_normal),u_sky_horizon_blend:new t.b5(e,i.u_sky_horizon_blend),u_sky_blend:new t.b5(e,i.u_sky_blend)})};class er{constructor(e,t,i){this.context=e;const r=e.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const tr={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class ir{constructor(e,t,i,r){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=r,this.context=e;const o=e.gl;this.buffer=o.createBuffer(),e.bindVertexBuffer.set(this.buffer),o.bufferData(o.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?o.DYNAMIC_DRAW:o.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){if(e.length!==this.length)throw new Error(`Length of new data is ${e.length}, which doesn't match current length of ${this.length}`);const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const r=t.attributes[this.attributes[i].name];void 0!==r&&e.enableVertexAttribArray(r);}}setVertexAttribPointers(e,t,i){for(let r=0;r<this.attributes.length;r++){const o=this.attributes[r],s=t.attributes[o.name];void 0!==s&&e.vertexAttribPointer(s,o.components,e[tr[o.type]],!1,this.itemSize,o.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class rr{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class or extends rr{getDefault(){return t.b4.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class sr extends rr{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class ar extends rr{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class nr extends rr{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class lr extends rr{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class cr extends rr{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class hr extends rr{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class ur extends rr{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class dr extends rr{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class _r extends rr{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class pr extends rr{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class mr extends rr{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class fr extends rr{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class gr extends rr{getDefault(){const e=this.gl;return [e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1);}}class vr extends rr{getDefault(){return t.b4.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class xr extends rr{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1);}}class br extends rr{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class yr extends rr{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class wr extends rr{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}class Tr extends rr{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}}class Pr extends rr{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class Cr extends rr{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Ir extends rr{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class Er extends rr{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class Mr extends rr{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class Sr extends rr{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Rr extends rr{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Dr extends rr{getDefault(){return null}set(e){var t;if(e===this.current&&!this.dirty)return;const i=this.gl;Ut(i)?i.bindVertexArray(e):null===(t=i.getExtension("OES_vertex_array_object"))||void 0===t||t.bindVertexArrayOES(e),this.current=e,this.dirty=!1;}}class zr extends rr{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class Ar extends rr{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class Lr extends rr{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class kr extends rr{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class Fr extends kr{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class Br extends kr{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class jr extends kr{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}const Or="Framebuffer is not complete";class Nr{constructor(e,t,i,r,o){this.context=e,this.width=t,this.height=i;const s=e.gl,a=this.framebuffer=s.createFramebuffer();if(this.colorAttachment=new Fr(e,a),r)this.depthAttachment=o?new jr(e,a):new Br(e,a);else if(o)throw new Error("Stencil cannot be set without depth");if(s.checkFramebufferStatus(s.FRAMEBUFFER)!==s.FRAMEBUFFER_COMPLETE)throw new Error(Or)}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}e.deleteFramebuffer(this.framebuffer);}}class Zr{constructor(e){var t,i;if(this.gl=e,this.clearColor=new or(this),this.clearDepth=new sr(this),this.clearStencil=new ar(this),this.colorMask=new nr(this),this.depthMask=new lr(this),this.stencilMask=new cr(this),this.stencilFunc=new hr(this),this.stencilOp=new ur(this),this.stencilTest=new dr(this),this.depthRange=new _r(this),this.depthTest=new pr(this),this.depthFunc=new mr(this),this.blend=new fr(this),this.blendFunc=new gr(this),this.blendColor=new vr(this),this.blendEquation=new xr(this),this.cullFace=new br(this),this.cullFaceSide=new yr(this),this.frontFace=new wr(this),this.program=new Tr(this),this.activeTexture=new Pr(this),this.viewport=new Cr(this),this.bindFramebuffer=new Ir(this),this.bindRenderbuffer=new Er(this),this.bindTexture=new Mr(this),this.bindVertexBuffer=new Sr(this),this.bindElementBuffer=new Rr(this),this.bindVertexArray=new Dr(this),this.pixelStoreUnpack=new zr(this),this.pixelStoreUnpackPremultiplyAlpha=new Ar(this),this.pixelStoreUnpackFlipY=new Lr(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),Ut(e)){this.HALF_FLOAT=e.HALF_FLOAT;const r=e.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(t=e.RGBA16F)&&void 0!==t?t:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=e.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,e.getExtension("EXT_color_buffer_float");}else {e.getExtension("EXT_color_buffer_half_float"),e.getExtension("OES_texture_half_float_linear");const t=e.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==t?void 0:t.HALF_FLOAT_OES;}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t){return new er(this,e,t)}createVertexBuffer(e,t,i){return new ir(this,e,t,i)}createRenderbuffer(e,t,i){const r=this.gl,o=r.createRenderbuffer();return this.bindRenderbuffer.set(o),r.renderbufferStorage(r.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),o}createFramebuffer(e,t,i,r){return new Nr(this,e,t,i,r)}clear({color:e,depth:t,stencil:i}){const r=this.gl;let o=0;e&&(o|=r.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(o|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(o|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(o);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(e){t.bz(e.blendFunction,Ft.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask);}createVertexArray(){var e;return Ut(this.gl)?this.gl.createVertexArray():null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.createVertexArrayOES()}deleteVertexArray(e){var t;return Ut(this.gl)?this.gl.deleteVertexArray(e):null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.deleteVertexArrayOES(e)}unbindVAO(){this.bindVertexArray.set(null);}}let Gr;function Ur(e,i,r,o,s){const a=e.context,n=e.transform,l=a.gl,c=e.useProgram("collisionBox"),h=[];let u=0,d=0;for(let t=0;t<o.length;t++){const _=o[t],p=i.getTile(_).getBucket(r);if(!p)continue;const m=s?p.textCollisionBox:p.iconCollisionBox,f=p.collisionCircleArray;f.length>0&&(h.push({circleArray:f,circleOffset:d,coord:_}),u+=f.length/4,d=u),m&&c.draw(a,l.LINES,Ot.disabled,Zt.disabled,e.colorModeForRenderPass(),jt.disabled,Di(e.transform),e.style.map.terrain&&e.style.map.terrain.getTerrainData(_),n.getProjectionData({overscaledTileID:_,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),r.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,e.transform.zoom,null,null,m.collisionVertexBuffer);}if(!s||!h.length)return;const _=e.useProgram("collisionCircle"),p=new t.bM;p.resize(4*u),p._trim();let m=0;for(const e of h)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,r=e.circleArray[i+0],o=e.circleArray[i+1],s=e.circleArray[i+2],a=e.circleArray[i+3];p.emplace(m++,r,o,s,a,0),p.emplace(m++,r,o,s,a,1),p.emplace(m++,r,o,s,a,2),p.emplace(m++,r,o,s,a,3);}(!Gr||Gr.length<2*u)&&(Gr=function(e){const i=2*e,r=new t.bO;r.resize(i),r._trim();for(let e=0;e<i;e++){const t=6*e;r.uint16[t+0]=4*e+0,r.uint16[t+1]=4*e+1,r.uint16[t+2]=4*e+2,r.uint16[t+3]=4*e+2,r.uint16[t+4]=4*e+3,r.uint16[t+5]=4*e+0;}return r}(u));const f=a.createIndexBuffer(Gr,!0),g=a.createVertexBuffer(p,t.bN.members,!0);for(const i of h){const o=zi(e.transform);_.draw(a,l.TRIANGLES,Ot.disabled,Zt.disabled,e.colorModeForRenderPass(),jt.disabled,o,e.style.map.terrain&&e.style.map.terrain.getTerrainData(i.coord),null,r.id,g,f,t.aD.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,e.transform.zoom,null,null,null);}g.destroy(),f.destroy();}const Vr=t.aq(new Float32Array(16));function qr(e,i,r,o,s,a){const{horizontalAlign:n,verticalAlign:l}=t.ay(e);return new t.P((-(n-.5)*i/s+o[0])*a,(-(l-.5)*r/s+o[1])*a)}function Hr(e,i,r,o,s,a){const n=i.tileAnchorPoint.add(new t.P(i.translation[0],i.translation[1]));if(i.pitchWithMap){let e=o.mult(a);r||(e=e.rotate(-s));const t=n.add(e);return ye(t.x,t.y,i.pitchedLabelPlaneMatrix,i.getElevation).point}if(r){const t=Re(i.tileAnchorPoint.x+1,i.tileAnchorPoint.y,i).point.sub(e),r=Math.atan(t.y/t.x)+(t.x<0?Math.PI:0);return e.add(o.rotate(r))}return e.add(o)}function Wr(e,i,r,o,s,a,n,l,c,h,u,d){const _=e.text.placedSymbolArray,p=e.text.dynamicLayoutVertexArray,m=e.icon.dynamicLayoutVertexArray,f={};p.clear();for(let m=0;m<_.length;m++){const g=_.get(m),v=g.hidden||!g.crossTileID||e.allowVerticalPlacement&&!g.placedOrientation?null:o[g.crossTileID];if(v){const o=new t.P(g.anchorX,g.anchorY),_={getElevation:d,width:s.width,height:s.height,pitchedLabelPlaneMatrix:a,lineVertexArray:null,pitchWithMap:r,transform:s,projectionCache:null,tileAnchorPoint:o,translation:h,unwrappedTileID:u},m=r?ze(o.x,o.y,_):Re(o.x,o.y,_),x=we(s.cameraToCenterDistance,m.signedDistanceFromCamera);let b=t.aj(e.textSizeData,l,g)*x/t.as;r&&(b*=e.tilePixelRatio/n);const{width:y,height:w,anchor:T,textOffset:P,textBoxScale:C}=v,I=qr(T,y,w,P,C,b),E=s.getPitchedTextCorrection(o.x+h[0],o.y+h[1],u),M=Hr(m.point,_,i,I,-s.bearingInRadians,E),S=e.allowVerticalPlacement&&g.placedOrientation===t.ai.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)t.ak(p,M,S);c&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:M,angle:S});}else Be(g.numGlyphs,p);}if(c){m.clear();const i=e.icon.placedSymbolArray;for(let e=0;e<i.length;e++){const r=i.get(e);if(r.hidden)Be(r.numGlyphs,m);else {const i=f[e];if(i)for(let e=0;e<r.numGlyphs;e++)t.ak(m,i.shiftedAnchor,i.angle);else Be(r.numGlyphs,m);}}e.icon.dynamicLayoutVertexBuffer.updateData(m);}e.text.dynamicLayoutVertexBuffer.updateData(p);}function Xr(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function $r(e,i,r,o,s,a,n,l,c,h,u,d,_){const p=e.context,m=p.gl,f=e.transform,g="map"===l,v="map"===c,x="viewport"!==l&&"point"!==r.layout.get("symbol-placement"),b=g&&!v&&!x,y=!r.layout.get("symbol-sort-key").isConstant();let w=!1;const T=e.getDepthModeForSublayer(0,Ot.ReadOnly),P=r._unevaluatedLayout.hasValue("text-variable-anchor")||r._unevaluatedLayout.hasValue("text-variable-anchor-offset"),C=[],I=f.getCircleRadiusCorrection();for(const l of o){const o=i.getTile(l),c=o.getBucket(r);if(!c)continue;const u=s?c.text:c.icon;if(!u||!u.segments.get().length||!u.hasVisibleVertices)continue;const d=u.programConfigurations.get(r.id),p=s||c.sdfIcons,T=s?c.textSizeData:c.iconSizeData,E=v||0!==f.pitch,M=e.useProgram(Xr(p,s,c),d),S=t.ah(T,f.zoom),R=e.style.map.terrain&&e.style.map.terrain.getTerrainData(l);let D,z,A,L,k=[0,0],F=null;if(s)z=o.glyphAtlasTexture,A=m.LINEAR,D=o.glyphAtlasTexture.size,c.iconsInText&&(k=o.imageAtlasTexture.size,F=o.imageAtlasTexture,L=E||e.options.rotating||e.options.zooming||"composite"===T.kind||"camera"===T.kind?m.LINEAR:m.NEAREST);else {const t=1!==r.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;z=o.imageAtlasTexture,A=p||e.options.rotating||e.options.zooming||t||E?m.LINEAR:m.NEAREST,D=o.imageAtlasTexture.size;}const B=t.at(o,1,e.transform.zoom),j=ve(g,e.transform,B),O=t.H();t.an(O,j);const N=xe(v,g,e.transform,B),Z=t.au(f,o,a,n),G=f.getProjectionData({overscaledTileID:l,applyGlobeMatrix:!_,applyTerrainMatrix:!0}),U=P&&c.hasTextData(),V="none"!==r.layout.get("icon-text-fit")&&U&&c.hasIconData();if(x){const t=e.style.map.terrain?(t,i)=>e.style.map.terrain.getElevation(l,t,i):null,i="map"===r.layout.get("text-rotation-alignment");Pe(c,e,s,j,O,v,h,i,l.toUnwrapped(),f.width,f.height,Z,t);}const q=s&&P||V,H=x||q?Vr:v?j:e.transform.clipSpaceToPixelsMatrix,W=p&&0!==r.paint.get(s?"text-halo-width":"icon-halo-width").constantOr(1);let X;X=p?c.iconsInText?$i(T.kind,S,b,v,x,q,e,H,N,Z,D,k,I):Xi(T.kind,S,b,v,x,q,e,H,N,Z,s,D,0,I):Wi(T.kind,S,b,v,x,q,e,H,N,Z,s,D,I);const $={program:M,buffers:u,uniformValues:X,projectionData:G,atlasTexture:z,atlasTextureIcon:F,atlasInterpolation:A,atlasInterpolationIcon:L,isSDF:p,hasHalo:W};if(y&&c.canOverlap){w=!0;const e=u.segments.get();for(const i of e)C.push({segments:new t.aD([i]),sortKey:i.sortKey,state:$,terrainData:R});}else C.push({segments:u.segments,sortKey:0,state:$,terrainData:R});}w&&C.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of C){const i=t.state;if(p.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(p.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const o=i.uniformValues;i.hasHalo&&(o.u_is_halo=1,Kr(i.buffers,t.segments,r,e,i.program,T,u,d,o,i.projectionData,t.terrainData)),o.u_is_halo=0;}Kr(i.buffers,t.segments,r,e,i.program,T,u,d,i.uniformValues,i.projectionData,t.terrainData);}}function Kr(e,t,i,r,o,s,a,n,l,c,h){const u=r.context;o.draw(u,u.gl.TRIANGLES,s,a,n,jt.backCCW,l,h,c,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,r.transform.zoom,e.programConfigurations.get(i.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer);}function Yr(e,i,r,o,s){const a=e.context,n=a.gl,l=Zt.disabled,c=new Ft([n.ONE,n.ONE],t.b4.transparent,[!0,!0,!0,!0]),h=i.getBucket(r);if(!h)return;const u=o.key;let d=r.heatmapFbos.get(u);d||(d=Qr(a,i.tileSize,i.tileSize),r.heatmapFbos.set(u,d)),a.bindFramebuffer.set(d.framebuffer),a.viewport.set([0,0,i.tileSize,i.tileSize]),a.clear({color:t.b4.transparent});const _=h.programConfigurations.get(r.id),p=e.useProgram("heatmap",_,!s),m=e.transform.getProjectionData({overscaledTileID:i.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),f=e.style.map.terrain.getTerrainData(o);p.draw(a,n.TRIANGLES,Ot.disabled,l,c,jt.disabled,Li(i,e.transform.zoom,r.paint.get("heatmap-intensity"),1),f,m,r.id,h.layoutVertexBuffer,h.indexBuffer,h.segments,r.paint,e.transform.zoom,_);}function Jr(e,t,i,r,o){const s=e.context,a=s.gl,n=e.transform;s.setColorMode(e.colorModeForRenderPass());const l=eo(s,t),c=i.key,h=t.heatmapFbos.get(c);if(!h)return;s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,h.colorAttachment.get()),s.activeTexture.set(a.TEXTURE1),l.bind(a.LINEAR,a.CLAMP_TO_EDGE);const u=n.getProjectionData({overscaledTileID:i,applyTerrainMatrix:o,applyGlobeMatrix:!r});e.useProgram("heatmapTexture").draw(s,a.TRIANGLES,Ot.disabled,Zt.disabled,e.colorModeForRenderPass(),jt.disabled,ki(e,t,0,1),null,u,t.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments,t.paint,n.zoom),h.destroy(),t.heatmapFbos.delete(c);}function Qr(e,t,i){var r,o;const s=e.gl,a=s.createTexture();s.bindTexture(s.TEXTURE_2D,a),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR);const n=null!==(r=e.HALF_FLOAT)&&void 0!==r?r:s.UNSIGNED_BYTE,l=null!==(o=e.RGBA16F)&&void 0!==o?o:s.RGBA;s.texImage2D(s.TEXTURE_2D,0,l,t,i,0,s.RGBA,n,null);const c=e.createFramebuffer(t,i,!1,!1);return c.colorAttachment.set(a),c}function eo(e,t){return t.colorRampTexture||(t.colorRampTexture=new v(e,t.colorRamp,e.gl.RGBA)),t.colorRampTexture}function to(e,t,i,r,o){if(!i||!r||!r.imageAtlas)return;const s=r.imageAtlas.patternPositions;let a=s[i.to.toString()],n=s[i.from.toString()];if(!a&&n&&(a=n),!n&&a&&(n=a),!a||!n){const e=o.getPaintProperty(t);a=s[e],n=s[e];}a&&n&&e.setConstantPatternPositions(a,n);}function io(e,i,r,o,s,a,n,l){const c=e.context.gl,h="fill-pattern",u=r.paint.get(h),d=u&&u.constantOr(1),_=r.getCrossfadeParameters();let p,m,f,g,v;const x=e.transform,b=r.paint.get("fill-translate"),y=r.paint.get("fill-translate-anchor");n?(m=d&&!r.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=c.LINES):(m=d?"fillPattern":"fill",p=c.TRIANGLES);const w=u.constantOr(null);for(const u of o){const T=i.getTile(u);if(d&&!T.patternsLoaded())continue;const P=T.getBucket(r);if(!P)continue;const C=P.programConfigurations.get(r.id),I=e.useProgram(m,C),E=e.style.map.terrain&&e.style.map.terrain.getTerrainData(u);d&&(e.context.activeTexture.set(c.TEXTURE0),T.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),C.updatePaintBuffers(_)),to(C,h,w,T,r);const M=x.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!l,applyTerrainMatrix:!0}),S=t.au(x,T,b,y);if(n){g=P.indexBuffer2,v=P.segments2;const t=[c.drawingBufferWidth,c.drawingBufferHeight];f="fillOutlinePattern"===m&&d?Si(e,_,T,t,S):Mi(t,S);}else g=P.indexBuffer,v=P.segments,f=d?Ei(e,_,T,S):{u_fill_translate:S};let R;if("translucent"===e.renderPass&&l){const[t]=e.getStencilConfigForOverlapAndUpdateStencilID(o);R=t[u.overscaledZ];}else R=e.stencilModeForClipping(u);I.draw(e.context,p,s,R,a,jt.backCCW,f,E,M,r.id,P.layoutVertexBuffer,g,v,r.paint,e.transform.zoom,C);}}function ro(e,i,r,o,s,a,n,l){const c=e.context,h=c.gl,u="fill-extrusion-pattern",d=r.paint.get(u),_=d.constantOr(1),p=r.getCrossfadeParameters(),m=r.paint.get("fill-extrusion-opacity"),f=d.constantOr(null),g=e.transform;for(const d of o){const o=i.getTile(d),v=o.getBucket(r);if(!v)continue;const x=e.style.map.terrain&&e.style.map.terrain.getTerrainData(d),b=v.programConfigurations.get(r.id),y=e.useProgram(_?"fillExtrusionPattern":"fillExtrusion",b);_&&(e.context.activeTexture.set(h.TEXTURE0),o.imageAtlasTexture.bind(h.LINEAR,h.CLAMP_TO_EDGE),b.updatePaintBuffers(p));const w=g.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!l,applyTerrainMatrix:!0});to(b,u,f,o,r);const T=t.au(g,o,r.paint.get("fill-extrusion-translate"),r.paint.get("fill-extrusion-translate-anchor")),P=r.paint.get("fill-extrusion-vertical-gradient"),C=_?Ii(e,P,m,T,d,p,o):Ci(e,P,m,T);y.draw(c,c.gl.TRIANGLES,s,a,n,jt.backCCW,C,x,w,r.id,v.layoutVertexBuffer,v.indexBuffer,v.segments,r.paint,e.transform.zoom,b,e.style.map.terrain&&v.centroidVertexBuffer);}}function oo(e,t,i,r,o,s,a,n,l){var c;const h=e.style.projection,u=e.context,d=e.transform,_=u.gl,p=e.useProgram("hillshade"),m=!e.options.moving;for(const f of r){const r=t.getTile(f),g=r.fbo;if(!g)continue;const v=h.getMeshFromTileID(u,f.canonical,n,!0,"raster"),x=null===(c=e.style.map.terrain)||void 0===c?void 0:c.getTerrainData(f);u.activeTexture.set(_.TEXTURE0),_.bindTexture(_.TEXTURE_2D,g.colorAttachment.get());const b=d.getProjectionData({overscaledTileID:f,aligned:m,applyGlobeMatrix:!l,applyTerrainMatrix:!0});p.draw(u,_.TRIANGLES,s,o[f.overscaledZ],a,jt.backCCW,Fi(e,r,i),x,b,i.id,v.vertexBuffer,v.indexBuffer,v.segments);}}const so=[new t.P(0,0),new t.P(t.X,0),new t.P(t.X,t.X),new t.P(0,t.X)];function ao(e,t,i,r,o,s,a,n,l=!1,c=!1){const h=r[r.length-1].overscaledZ,u=e.context,d=u.gl,_=e.useProgram("raster"),p=e.transform,m=e.style.projection,f=e.colorModeForRenderPass(),g=!e.options.moving;for(const v of r){const r=e.getDepthModeForSublayer(v.overscaledZ-h,1===i.paint.get("raster-opacity")?Ot.ReadWrite:Ot.ReadOnly,d.LESS),x=t.getTile(v);x.registerFadeDuration(i.paint.get("raster-fade-duration"));const b=t.findLoadedParent(v,0),y=t.findLoadedSibling(v),w=no(x,b||y||null,t,i,e.transform,e.style.map.terrain);let T,P;const C="nearest"===i.paint.get("raster-resampling")?d.NEAREST:d.LINEAR;u.activeTexture.set(d.TEXTURE0),x.texture.bind(C,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(d.TEXTURE1),b?(b.texture.bind(C,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),T=Math.pow(2,b.tileID.overscaledZ-x.tileID.overscaledZ),P=[x.tileID.canonical.x*T%1,x.tileID.canonical.y*T%1]):x.texture.bind(C,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),x.texture.useMipmap&&u.extTextureFilterAnisotropic&&e.transform.pitch>20&&d.texParameterf(d.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const I=e.style.map.terrain&&e.style.map.terrain.getTerrainData(v),E=p.getProjectionData({overscaledTileID:v,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),M=qi(P||[0,0],T||1,w,i,n),S=m.getMeshFromTileID(u,v.canonical,s,a,"raster");_.draw(u,d.TRIANGLES,r,o?o[v.overscaledZ]:Zt.disabled,f,l?jt.frontCCW:jt.backCCW,M,I,E,i.id,S.vertexBuffer,S.indexBuffer,S.segments);}}function no(e,i,r,o,s,n){const l=o.paint.get("raster-fade-duration");if(!n&&l>0){const o=a.now(),n=(o-e.timeAdded)/l,c=i?(o-i.timeAdded)/l:-1,h=r.getSource(),u=he(s,{tileSize:h.tileSize,roundZoom:h.roundZoom}),d=!i||Math.abs(i.tileID.overscaledZ-u)>Math.abs(e.tileID.overscaledZ-u),_=d&&e.refreshedUponExpiration?1:t.ab(d?n:1-c,0,1);return e.refreshedUponExpiration&&n>=1&&(e.refreshedUponExpiration=!1),i?{opacity:1,mix:1-_}:{opacity:_,mix:0}}return {opacity:1,mix:0}}const lo=new t.b4(1,0,0,1),co=new t.b4(0,1,0,1),ho=new t.b4(0,0,1,1),uo=new t.b4(1,0,1,1),_o=new t.b4(0,1,1,1);function po(e,t,i,r){fo(e,0,t+i/2,e.transform.width,i,r);}function mo(e,t,i,r){fo(e,t-i/2,0,i,e.transform.height,r);}function fo(e,t,i,r,o,s){const a=e.context,n=a.gl;n.enable(n.SCISSOR_TEST),n.scissor(t*e.pixelRatio,i*e.pixelRatio,r*e.pixelRatio,o*e.pixelRatio),a.clear({color:s}),n.disable(n.SCISSOR_TEST);}function go(e,i,r){const o=e.context,s=o.gl,a=e.useProgram("debug"),n=Ot.disabled,l=Zt.disabled,c=e.colorModeForRenderPass(),h="$debug",u=e.style.map.terrain&&e.style.map.terrain.getTerrainData(r);o.activeTexture.set(s.TEXTURE0);const d=i.getTileByID(r.key).latestRawTileData,_=Math.floor((d&&d.byteLength||0)/1024),p=i.getTile(r).tileSize,m=512/Math.min(p,512)*(r.overscaledZ/e.transform.zoom)*.5;let f=r.canonical.toString();r.overscaledZ!==r.canonical.z&&(f+=` => ${r.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,r=e.context.gl,o=e.debugOverlayCanvas.getContext("2d");o.clearRect(0,0,i.width,i.height),o.shadowColor="white",o.shadowBlur=2,o.lineWidth=1.5,o.strokeStyle="white",o.textBaseline="top",o.font="bold 36px Open Sans, sans-serif",o.fillText(t,5,5),o.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE);}(e,`${f} ${_}kB`);const g=e.transform.getProjectionData({overscaledTileID:r,applyGlobeMatrix:!0,applyTerrainMatrix:!0});a.draw(o,s.TRIANGLES,n,l,Ft.alphaBlended,jt.disabled,Ai(t.b4.transparent,m),null,g,h,e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments),a.draw(o,s.LINE_STRIP,n,l,c,jt.disabled,Ai(t.b4.red),u,g,h,e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments);}function vo(e,t,i,r){const{isRenderingGlobe:o}=r,s=e.context,a=s.gl,n=e.transform,l=e.colorModeForRenderPass(),c=e.getDepthModeFor3D(),h=e.useProgram("terrain");s.bindFramebuffer.set(null),s.viewport.set([0,0,e.width,e.height]);for(const r of i){const i=t.getTerrainMesh(r.tileID),u=e.renderToTexture.getTexture(r),d=t.getTerrainData(r.tileID);s.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,u.texture);const _=t.getMeshFrameDelta(n.zoom),p=n.calculateFogMatrix(r.tileID.toUnwrapped()),m=bi(_,p,e.style.sky,n.pitch,o),f=n.getProjectionData({overscaledTileID:r.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(s,a.TRIANGLES,c,Zt.disabled,l,jt.backCCW,m,d,f,"terrain",i.vertexBuffer,i.indexBuffer,i.segments);}}function xo(e,i){if(!i.mesh){const r=new t.aC;r.emplaceBack(-1,-1),r.emplaceBack(1,-1),r.emplaceBack(1,1),r.emplaceBack(-1,1);const o=new t.aE;o.emplaceBack(0,1,2),o.emplaceBack(0,2,3),i.mesh=new pt(e.createVertexBuffer(r,mt.members),e.createIndexBuffer(o),t.aD.simpleSegment(0,0,r.length,o.length));}return i.mesh}class bo{constructor(e,i){this.context=new Zr(e),this.transform=i,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:t.aq(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=de.maxUnderzooming+de.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new ht;}resize(e,t,i){if(this.width=Math.floor(e*i),this.height=Math.floor(t*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style._order)this.style._layers[e].resize();}setup(){const e=this.context,i=new t.aC;i.emplaceBack(0,0),i.emplaceBack(t.X,0),i.emplaceBack(0,t.X),i.emplaceBack(t.X,t.X),this.tileExtentBuffer=e.createVertexBuffer(i,mt.members),this.tileExtentSegments=t.aD.simpleSegment(0,0,4,2);const r=new t.aC;r.emplaceBack(0,0),r.emplaceBack(t.X,0),r.emplaceBack(0,t.X),r.emplaceBack(t.X,t.X),this.debugBuffer=e.createVertexBuffer(r,mt.members),this.debugSegments=t.aD.simpleSegment(0,0,4,5);const o=new t.bT;o.emplaceBack(0,0,0,0),o.emplaceBack(t.X,0,t.X,0),o.emplaceBack(0,t.X,0,t.X),o.emplaceBack(t.X,t.X,t.X,t.X),this.rasterBoundsBuffer=e.createVertexBuffer(o,vi.members),this.rasterBoundsSegments=t.aD.simpleSegment(0,0,4,2);const s=new t.aC;s.emplaceBack(0,0),s.emplaceBack(t.X,0),s.emplaceBack(0,t.X),s.emplaceBack(t.X,t.X),this.rasterBoundsBufferPosOnly=e.createVertexBuffer(s,mt.members),this.rasterBoundsSegmentsPosOnly=t.aD.simpleSegment(0,0,4,5);const a=new t.aC;a.emplaceBack(0,0),a.emplaceBack(1,0),a.emplaceBack(0,1),a.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(a,mt.members),this.viewportSegments=t.aD.simpleSegment(0,0,4,2);const n=new t.bU;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(n);const l=new t.aE;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(l);const c=this.context.gl;this.stencilClearMode=new Zt({func:c.ALWAYS,mask:0},0,255,c.ZERO,c.ZERO,c.ZERO),this.tileExtentMesh=new pt(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}clearStencil(){const e=this.context,i=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const r=t.H();t.bL(r,0,this.width,this.height,0,0,1),t.K(r,r,[i.drawingBufferWidth,i.drawingBufferHeight,0]);const o={mainMatrix:r,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:r};this.useProgram("clippingMask",null,!0).draw(e,i.TRIANGLES,Ot.disabled,this.stencilClearMode,Ft.disabled,jt.disabled,null,null,o,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(e,t,i){if(this.currentStencilSource===e.source||!e.isTileClipped()||!t||!t.length)return;this.currentStencilSource=e.source,this.nextStencilID+t.length>256&&this.clearStencil();const r=this.context;r.setColorMode(Ft.disabled),r.setDepthMode(Ot.disabled);const o={};for(const e of t)o[e.key]=this.nextStencilID++;this._renderTileMasks(o,t,i,!0),this._renderTileMasks(o,t,i,!1),this._tileClippingMaskIDs=o;}_renderTileMasks(e,t,i,r){const o=this.context,s=o.gl,a=this.style.projection,n=this.transform,l=this.useProgram("clippingMask");for(const c of t){const t=e[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=a.getMeshFromTileID(this.context,c.canonical,r,!0,"stencil"),d=n.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!0,applyTerrainMatrix:!0});l.draw(o,s.TRIANGLES,Ot.disabled,new Zt({func:s.ALWAYS,mask:0},t,255,s.KEEP,s.KEEP,s.REPLACE),Ft.disabled,i?jt.disabled:jt.backCCW,null,h,d,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments);}}_renderTilesDepthBuffer(){const e=this.context,t=e.gl,i=this.style.projection,r=this.transform,o=this.useProgram("depth"),s=this.getDepthModeFor3D(),a=ue(r,{tileSize:r.tileSize});for(const n of a){const a=this.style.map.terrain&&this.style.map.terrain.getTerrainData(n),l=i.getMeshFromTileID(this.context,n.canonical,!0,!0,"raster"),c=r.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!0,applyTerrainMatrix:!0});o.draw(e,t.TRIANGLES,s,Zt.disabled,Ft.disabled,jt.backCCW,null,a,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,t=this.context.gl;return new Zt({func:t.NOTEQUAL,mask:255},e,255,t.KEEP,t.KEEP,t.REPLACE)}stencilModeForClipping(e){const t=this.context.gl;return new Zt({func:t.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,t.KEEP,t.KEEP,t.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=i[i.length-1].overscaledZ,o=i[0].overscaledZ-r+1;if(o>1){this.currentStencilSource=void 0,this.nextStencilID+o>256&&this.clearStencil();const e={};for(let i=0;i<o;i++)e[i+r]=new Zt({func:t.GEQUAL,mask:255},i+this.nextStencilID,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID+=o,[e,i]}return [{[r]:Zt.disabled},i]}stencilConfigForOverlapTwoPass(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=i[i.length-1].overscaledZ,o=i[0].overscaledZ-r+1;if(this.clearStencil(),o>1){const e={},s={};for(let i=0;i<o;i++)e[i+r]=new Zt({func:t.GREATER,mask:255},o+1+i,255,t.KEEP,t.KEEP,t.REPLACE),s[i+r]=new Zt({func:t.GREATER,mask:255},1+i,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID=2*o+1,[e,s,i]}return this.nextStencilID=3,[{[r]:new Zt({func:t.GREATER,mask:255},2,255,t.KEEP,t.KEEP,t.REPLACE)},{[r]:new Zt({func:t.GREATER,mask:255},1,255,t.KEEP,t.KEEP,t.REPLACE)},i]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new Ft([e.CONSTANT_COLOR,e.ONE],new t.b4(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?Ft.unblended:Ft.alphaBlended}getDepthModeForSublayer(e,t,i){if(!this.opaquePassEnabledForLayer())return Ot.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new Ot(i||this.context.gl.LEQUAL,t,[r,r])}getDepthModeFor3D(){return new Ot(this.context.gl.LEQUAL,Ot.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,i){var r,o;this.style=e,this.options=i,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(a.now()),this.imageManager.beginFrame();const s=this.style._order,n=this.style.sourceCaches,l={},c={},h={},u={isRenderingToTexture:!1,isRenderingGlobe:(null===(r=e.projection)||void 0===r?void 0:r.transitionState)>0};for(const e in n){const t=n[e];t.used&&t.prepare(this.context),l[e]=t.getVisibleCoordinates(!1),c[e]=l[e].slice().reverse(),h[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<s.length;e++)if(this.style._layers[s[e]].is3D()){this.opaquePassCutoff=e;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const e of s){const t=this.style._layers[e];if(!t.hasOffscreenPass()||t.isHidden(this.transform.zoom))continue;const i=c[t.source];("custom"===t.type||i.length)&&this.renderLayer(this,n[t.source],t,i,u);}if(null===(o=this.style.projection)||void 0===o||o.updateGPUdependent({context:this.context,useProgram:e=>this.useProgram(e)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?t.b4.black:t.b4.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(e,t){const i=e.context,r=i.gl,o=((e,t,i)=>{const r=Math.cos(t.rollInRadians),o=Math.sin(t.rollInRadians),s=yt(t),a=t.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return {u_sky_color:e.properties.get("sky-color"),u_horizon_color:e.properties.get("horizon-color"),u_horizon:[(t.width/2-s*o)*i,(t.height/2+s*r)*i],u_horizon_normal:[-o,r],u_sky_horizon_blend:e.properties.get("sky-horizon-blend")*t.height/2*i,u_sky_blend:a}})(t,e.style.map.transform,e.pixelRatio),s=new Ot(r.LEQUAL,Ot.ReadWrite,[0,1]),a=Zt.disabled,n=e.colorModeForRenderPass(),l=e.useProgram("sky"),c=xo(i,t);l.draw(i,r.TRIANGLES,s,a,n,jt.disabled,o,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments);}(this,this.style.sky),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(e._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=s.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[s[this.currentLayer]],t=n[e.source],i=l[e.source];this._renderTileClippingMasks(e,i,!1),this.renderLayer(this,t,e,i,u);}this.renderPass="translucent";let d=!1;for(this.currentLayer=0;this.currentLayer<s.length;this.currentLayer++){const e=this.style._layers[s[this.currentLayer]],t=n[e.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(e,u))continue;this.opaquePassEnabledForLayer()||d||(d=!0,u.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===e.type?h:c)[e.source];this._renderTileClippingMasks(e,l[e.source],!1),this.renderLayer(this,t,e,i,u);}if(u.isRenderingGlobe&&function(e,i,r){const o=e.context,s=o.gl,a=e.useProgram("atmosphere"),n=new Ot(s.LEQUAL,Ot.ReadOnly,[0,1]),l=e.transform,c=function(e,i){const r=e.properties.get("position"),o=[-r.x,-r.y,-r.z],s=t.aq(new Float64Array(16));return "map"===e.properties.get("anchor")&&(t.aX(s,s,i.rollInRadians),t.aY(s,s,-i.pitchInRadians),t.aX(s,s,i.bearingInRadians),t.aY(s,s,i.center.lat*Math.PI/180),t.bj(s,s,-i.center.lng*Math.PI/180)),t.bS(o,o,s),o}(r,e.transform),h=l.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),u=i.properties.get("atmosphere-blend")*h.projectionTransition;if(0===u)return;const d=ei(l.worldSize,l.center.lat),_=l.inverseProjectionMatrix,p=new Float64Array(4);p[3]=1,t.al(p,p,l.modelViewProjectionMatrix),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1,t.al(p,p,_),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1;const m=((e,t,i,r,o)=>({u_sun_pos:e,u_atmosphere_blend:t,u_globe_position:i,u_globe_radius:r,u_inv_proj_matrix:o}))(c,u,[p[0],p[1],p[2]],d,_),f=xo(o,i);a.draw(o,s.TRIANGLES,n,Zt.disabled,Ft.alphaBlended,jt.disabled,m,null,null,"atmosphere",f.vertexBuffer,f.indexBuffer,f.segments);}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const e=function(e,t){let i=null;const r=Object.values(e._layers).flatMap((i=>i.source&&!i.isHidden(t)?[e.sourceCaches[i.source]]:[])),o=r.filter((e=>"vector"===e.getSource().type)),s=r.filter((e=>"vector"!==e.getSource().type)),a=e=>{(!i||i.getSource().maxzoom<e.getSource().maxzoom)&&(i=e);};return o.forEach((e=>a(e))),i||s.forEach((e=>a(e))),i}(this.style,this.transform.zoom);e&&function(e,t,i){for(let r=0;r<i.length;r++)go(e,t,i[r]);}(this,e,e.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;po(e,e.transform.height-(t.top||0),3,lo),po(e,t.bottom||0,3,co),mo(e,t.left||0,3,ho),mo(e,e.transform.width-(t.right||0),3,uo);const i=e.transform.centerPoint;!function(e,t,i,r){fo(e,t-1,i-10,2,20,r),fo(e,t-10,i-1,20,2,r);}(e,i.x,e.transform.height-i.y,_o);}(this),this.context.setDefault();}maybeDrawDepthAndCoords(e){if(!this.style||!this.style.map||!this.style.map.terrain)return;const i=this.terrainFacilitator.matrix,r=this.transform.modelViewProjectionMatrix;let o=this.terrainFacilitator.dirty;o||(o=e?!t.bV(i,r):!t.bW(i,r)),o||(o=this.style.map.terrain.sourceCache.anyTilesAfterTime(this.terrainFacilitator.renderTime)),o&&(t.bX(i,r),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(e,i){const r=e.context,o=r.gl,s=e.transform,a=Ft.unblended,n=new Ot(o.LEQUAL,Ot.ReadWrite,[0,1]),l=i.sourceCache.getRenderableTiles(),c=e.useProgram("terrainDepth");r.bindFramebuffer.set(i.getFramebuffer("depth").framebuffer),r.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),r.clear({color:t.b4.transparent,depth:1});for(const e of l){const t=i.getTerrainMesh(e.tileID),l=i.getTerrainData(e.tileID),h=s.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:i.getMeshFrameDelta(s.zoom)};c.draw(r,o.TRIANGLES,n,Zt.disabled,a,jt.backCCW,u,l,h,"terrain",t.vertexBuffer,t.indexBuffer,t.segments);}r.bindFramebuffer.set(null),r.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain),function(e,i){const r=e.context,o=r.gl,s=e.transform,a=Ft.unblended,n=new Ot(o.LEQUAL,Ot.ReadWrite,[0,1]),l=i.getCoordsTexture(),c=i.sourceCache.getRenderableTiles(),h=e.useProgram("terrainCoords");r.bindFramebuffer.set(i.getFramebuffer("coords").framebuffer),r.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),r.clear({color:t.b4.transparent,depth:1}),i.coordsIndex=[];for(const e of c){const t=i.getTerrainMesh(e.tileID),c=i.getTerrainData(e.tileID);r.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,l.texture);const u={u_terrain_coords_id:(255-i.coordsIndex.length)/255,u_texture:0,u_ele_delta:i.getMeshFrameDelta(s.zoom)},d=s.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(r,o.TRIANGLES,n,Zt.disabled,a,jt.backCCW,u,c,d,"terrain",t.vertexBuffer,t.indexBuffer,t.segments),i.coordsIndex.push(e.tileID.key);}r.bindFramebuffer.set(null),r.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain));}renderLayer(e,i,r,o,s){r.isHidden(this.transform.zoom)||("background"===r.type||"custom"===r.type||(o||[]).length)&&(this.id=r.id,t.bY(r)?function(e,i,r,o,s,a){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:n}=a,l=Zt.disabled,c=e.colorModeForRenderPass();(r._unevaluatedLayout.hasValue("text-variable-anchor")||r._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(e,i,r,o,s,a,n,l,c){const h=i.transform,u=i.style.map.terrain,d="map"===s,_="map"===a;for(const s of e){const e=o.getTile(s),a=e.getBucket(r);if(!a||!a.text||!a.text.segments.get().length)continue;const p=t.ah(a.textSizeData,h.zoom),m=t.at(e,1,i.transform.zoom),f=ve(d,i.transform,m),g="none"!==r.layout.get("icon-text-fit")&&a.hasIconData();{const i=Math.pow(2,h.zoom-e.tileID.overscaledZ),r=u?(e,t)=>u.getElevation(s,e,t):null;Wr(a,d,_,c,h,f,i,p,g,t.au(h,e,n,l),s.toUnwrapped(),r);}}}(o,e,r,i,r.layout.get("text-rotation-alignment"),r.layout.get("text-pitch-alignment"),r.paint.get("text-translate"),r.paint.get("text-translate-anchor"),s),0!==r.paint.get("icon-opacity").constantOr(1)&&$r(e,i,r,o,!1,r.paint.get("icon-translate"),r.paint.get("icon-translate-anchor"),r.layout.get("icon-rotation-alignment"),r.layout.get("icon-pitch-alignment"),r.layout.get("icon-keep-upright"),l,c,n),0!==r.paint.get("text-opacity").constantOr(1)&&$r(e,i,r,o,!0,r.paint.get("text-translate"),r.paint.get("text-translate-anchor"),r.layout.get("text-rotation-alignment"),r.layout.get("text-pitch-alignment"),r.layout.get("text-keep-upright"),l,c,n),i.map.showCollisionBoxes&&(Ur(e,i,r,o,!0),Ur(e,i,r,o,!1));}(e,i,r,o,this.style.placement.variableOffsets,s):t.bZ(r)?function(e,i,r,o,s){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:a}=s,n=r.paint.get("circle-opacity"),l=r.paint.get("circle-stroke-width"),c=r.paint.get("circle-stroke-opacity"),h=!r.layout.get("circle-sort-key").isConstant();if(0===n.constantOr(1)&&(0===l.constantOr(1)||0===c.constantOr(1)))return;const u=e.context,d=u.gl,_=e.transform,p=e.getDepthModeForSublayer(0,Ot.ReadOnly),m=Zt.disabled,f=e.colorModeForRenderPass(),g=[],v=_.getCircleRadiusCorrection();for(let s=0;s<o.length;s++){const n=o[s],l=i.getTile(n),c=l.getBucket(r);if(!c)continue;const u=r.paint.get("circle-translate"),d=r.paint.get("circle-translate-anchor"),p=t.au(_,l,u,d),m=c.programConfigurations.get(r.id),f=e.useProgram("circle",m),x=c.layoutVertexBuffer,b=c.indexBuffer,y=e.style.map.terrain&&e.style.map.terrain.getTerrainData(n),w={programConfiguration:m,program:f,layoutVertexBuffer:x,indexBuffer:b,uniformValues:Ri(e,l,r,p,v),terrainData:y,projectionData:_.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!a,applyTerrainMatrix:!0})};if(h){const e=c.segments.get();for(const i of e)g.push({segments:new t.aD([i]),sortKey:i.sortKey,state:w});}else g.push({segments:c.segments,sortKey:0,state:w});}h&&g.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of g){const{programConfiguration:i,program:o,layoutVertexBuffer:s,indexBuffer:a,uniformValues:n,terrainData:l,projectionData:c}=t.state;o.draw(u,d.TRIANGLES,p,m,f,jt.backCCW,n,l,c,r.id,s,a,t.segments,r.paint,e.transform.zoom,i);}}(e,i,r,o,s):t.b_(r)?function(e,i,r,o,s){if(0===r.paint.get("heatmap-opacity"))return;const a=e.context,{isRenderingToTexture:n,isRenderingGlobe:l}=s;if(e.style.map.terrain){for(const t of o){const o=i.getTile(t);i.hasRenderableParent(t)||("offscreen"===e.renderPass?Yr(e,o,r,t,l):"translucent"===e.renderPass&&Jr(e,r,t,n,l));}a.viewport.set([0,0,e.width,e.height]);}else "offscreen"===e.renderPass?function(e,i,r,o){const s=e.context,a=s.gl,n=e.transform,l=Zt.disabled,c=new Ft([a.ONE,a.ONE],t.b4.transparent,[!0,!0,!0,!0]);((function(e,i,r){const o=e.gl;e.activeTexture.set(o.TEXTURE1),e.viewport.set([0,0,i.width/4,i.height/4]);let s=r.heatmapFbos.get(t.bP);s?(o.bindTexture(o.TEXTURE_2D,s.colorAttachment.get()),e.bindFramebuffer.set(s.framebuffer)):(s=Qr(e,i.width/4,i.height/4),r.heatmapFbos.set(t.bP,s));}))(s,e,r),s.clear({color:t.b4.transparent});for(let t=0;t<o.length;t++){const h=o[t];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(r);if(!d)continue;const _=d.programConfigurations.get(r.id),p=e.useProgram("heatmap",_),m=n.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),f=n.getCircleRadiusCorrection();p.draw(s,a.TRIANGLES,Ot.disabled,l,c,jt.backCCW,Li(u,n.zoom,r.paint.get("heatmap-intensity"),f),null,m,r.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,r.paint,n.zoom,_);}s.viewport.set([0,0,e.width,e.height]);}(e,i,r,o):"translucent"===e.renderPass&&function(e,i){const r=e.context,o=r.gl;r.setColorMode(e.colorModeForRenderPass());const s=i.heatmapFbos.get(t.bP);s&&(r.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,s.colorAttachment.get()),r.activeTexture.set(o.TEXTURE1),eo(r,i).bind(o.LINEAR,o.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(r,o.TRIANGLES,Ot.disabled,Zt.disabled,e.colorModeForRenderPass(),jt.disabled,ki(e,i,0,1),null,null,i.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,i.paint,e.transform.zoom));}(e,r);}(e,i,r,o,s):t.b$(r)?function(e,i,r,o,s){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:a}=s,n=r.paint.get("line-opacity"),l=r.paint.get("line-width");if(0===n.constantOr(1)||0===l.constantOr(1))return;const c=e.getDepthModeForSublayer(0,Ot.ReadOnly),h=e.colorModeForRenderPass(),u=r.paint.get("line-dasharray"),d=r.paint.get("line-pattern"),_=d.constantOr(1),p=r.paint.get("line-gradient"),m=r.getCrossfadeParameters(),f=_?"linePattern":u?"lineSDF":p?"lineGradient":"line",g=e.context,x=g.gl,b=e.transform;let y=!0;for(const s of o){const n=i.getTile(s);if(_&&!n.patternsLoaded())continue;const l=n.getBucket(r);if(!l)continue;const w=l.programConfigurations.get(r.id),T=e.context.program.get(),P=e.useProgram(f,w),C=y||P.program!==T,I=e.style.map.terrain&&e.style.map.terrain.getTerrainData(s),E=d.constantOr(null);if(E&&n.imageAtlas){const e=n.imageAtlas,t=e.patternPositions[E.to.toString()],i=e.patternPositions[E.from.toString()];t&&i&&w.setConstantPatternPositions(t,i);}const M=b.getProjectionData({overscaledTileID:s,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),S=b.getPixelScale(),R=_?Zi(e,n,r,S,m):u?Gi(e,n,r,S,u,m):p?Ni(e,n,r,S,l.lineClipsArray.length):Oi(e,n,r,S);if(_)g.activeTexture.set(x.TEXTURE0),n.imageAtlasTexture.bind(x.LINEAR,x.CLAMP_TO_EDGE),w.updatePaintBuffers(m);else if(u&&(C||e.lineAtlas.dirty))g.activeTexture.set(x.TEXTURE0),e.lineAtlas.bind(g);else if(p){const o=l.gradients[r.id];let a=o.texture;if(r.gradientVersion!==o.version){let n=256;if(r.stepInterpolant){const r=i.getSource().maxzoom,o=s.canonical.z===r?Math.ceil(1<<e.transform.maxZoom-s.canonical.z):1;n=t.ab(t.bQ(l.maxLineLength/t.X*1024*o),256,g.maxTextureSize);}o.gradient=t.bR({expression:r.gradientExpression(),evaluationKey:"lineProgress",resolution:n,image:o.gradient||void 0,clips:l.lineClipsArray}),o.texture?o.texture.update(o.gradient):o.texture=new v(g,o.gradient,x.RGBA),o.version=r.gradientVersion,a=o.texture;}g.activeTexture.set(x.TEXTURE0),a.bind(r.stepInterpolant?x.NEAREST:x.LINEAR,x.CLAMP_TO_EDGE);}let D;if(a){const[t]=e.getStencilConfigForOverlapAndUpdateStencilID(o);D=t[s.overscaledZ];}else D=e.stencilModeForClipping(s);P.draw(g,x.TRIANGLES,c,D,h,jt.disabled,R,I,M,r.id,l.layoutVertexBuffer,l.indexBuffer,l.segments,r.paint,e.transform.zoom,w,l.layoutVertexBuffer2),y=!1;}}(e,i,r,o,s):t.c0(r)?function(e,i,r,o,s){const a=r.paint.get("fill-color"),n=r.paint.get("fill-opacity");if(0===n.constantOr(1))return;const{isRenderingToTexture:l}=s,c=e.colorModeForRenderPass(),h=r.paint.get("fill-pattern"),u=e.opaquePassEnabledForLayer()&&!h.constantOr(1)&&1===a.constantOr(t.b4.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(e.renderPass===u){const t=e.getDepthModeForSublayer(1,"opaque"===e.renderPass?Ot.ReadWrite:Ot.ReadOnly);io(e,i,r,o,t,c,!1,l);}if("translucent"===e.renderPass&&r.paint.get("fill-antialias")){const t=e.getDepthModeForSublayer(r.getPaintProperty("fill-outline-color")?2:0,Ot.ReadOnly);io(e,i,r,o,t,c,!0,l);}}(e,i,r,o,s):t.c1(r)?function(e,t,i,r,o){const s=i.paint.get("fill-extrusion-opacity");if(0===s)return;const{isRenderingToTexture:a}=o;if("translucent"===e.renderPass){const o=new Ot(e.context.gl.LEQUAL,Ot.ReadWrite,e.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))ro(e,t,i,r,o,Zt.disabled,Ft.disabled,a),ro(e,t,i,r,o,e.stencilModeFor3D(),e.colorModeForRenderPass(),a);else {const s=e.colorModeForRenderPass();ro(e,t,i,r,o,Zt.disabled,s,a);}}}(e,i,r,o,s):t.c2(r)?function(e,t,i,r,o){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=o,a=e.context,n=e.style.projection.useSubdivision,l=e.getDepthModeForSublayer(0,Ot.ReadOnly),c=e.colorModeForRenderPass();if("offscreen"===e.renderPass)!function(e,t,i,r,o,s,a){const n=e.context,l=n.gl;for(const c of i){const i=t.getTile(c),h=i.dem;if(!h||!h.data)continue;if(!i.needsHillshadePrepare)continue;const u=h.dim,d=h.stride,_=h.getPixels();if(n.activeTexture.set(l.TEXTURE1),n.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||e.getTileTexture(d),i.demTexture){const e=i.demTexture;e.update(_,{premultiply:!1}),e.bind(l.NEAREST,l.CLAMP_TO_EDGE);}else i.demTexture=new v(n,_,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);n.activeTexture.set(l.TEXTURE0);let p=i.fbo;if(!p){const e=new v(n,{width:u,height:u,data:null},l.RGBA);e.bind(l.LINEAR,l.CLAMP_TO_EDGE),p=i.fbo=n.createFramebuffer(u,u,!0,!1),p.colorAttachment.set(e.texture);}n.bindFramebuffer.set(p.framebuffer),n.viewport.set([0,0,u,u]),e.useProgram("hillshadePrepare").draw(n,l.TRIANGLES,o,s,a,jt.disabled,Bi(i.tileID,h),null,null,r.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),i.needsHillshadePrepare=!1;}}(e,t,r,i,l,Zt.disabled,c),a.viewport.set([0,0,e.width,e.height]);else if("translucent"===e.renderPass)if(n){const[o,a,n]=e.stencilConfigForOverlapTwoPass(r);oo(e,t,i,n,o,l,c,!1,s),oo(e,t,i,n,a,l,c,!0,s);}else {const[o,a]=e.getStencilConfigForOverlapAndUpdateStencilID(r);oo(e,t,i,a,o,l,c,!1,s);}}(e,i,r,o,s):t.c3(r)?function(e,t,i,r,o){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const{isRenderingToTexture:s}=o,a=t.getSource(),n=e.style.projection.useSubdivision;if(a instanceof K)ao(e,t,i,r,null,!1,!1,a.tileCoords,a.flippedWindingOrder,s);else if(n){const[o,a,n]=e.stencilConfigForOverlapTwoPass(r);ao(e,t,i,n,o,!1,!0,so,!1,s),ao(e,t,i,n,a,!0,!0,so,!1,s);}else {const[o,a]=e.getStencilConfigForOverlapAndUpdateStencilID(r);ao(e,t,i,a,o,!1,!0,so,!1,s);}}(e,i,r,o,s):t.c4(r)?function(e,t,i,r,o){const s=i.paint.get("background-color"),a=i.paint.get("background-opacity");if(0===a)return;const{isRenderingToTexture:n}=o,l=e.context,c=l.gl,h=e.style.projection,u=e.transform,d=u.tileSize,_=i.paint.get("background-pattern");if(e.isPatternMissing(_))return;const p=!_&&1===s.a&&1===a&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==p)return;const m=Zt.disabled,f=e.getDepthModeForSublayer(0,"opaque"===p?Ot.ReadWrite:Ot.ReadOnly),g=e.colorModeForRenderPass(),v=e.useProgram(_?"backgroundPattern":"background"),x=r||ue(u,{tileSize:d,terrain:e.style.map.terrain});_&&(l.activeTexture.set(c.TEXTURE0),e.imageManager.bind(e.context));const b=i.getCrossfadeParameters();for(const t of x){const r=u.getProjectionData({overscaledTileID:t,applyGlobeMatrix:!n,applyTerrainMatrix:!0}),o=_?Yi(a,e,_,{tileID:t,tileSize:d},b):Ki(a,s),p=e.style.map.terrain&&e.style.map.terrain.getTerrainData(t),x=h.getMeshFromTileID(l,t.canonical,!1,!0,"raster");v.draw(l,c.TRIANGLES,f,m,g,jt.backCCW,o,p,r,i.id,x.vertexBuffer,x.indexBuffer,x.segments);}}(e,0,r,o,s):t.c5(r)&&function(e,t,i,r){const{isRenderingGlobe:o}=r,s=e.context,a=i.implementation,n=e.style.projection,l=e.transform,c=l.getProjectionDataForCustomLayer(o),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:n.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${n.shaderPreludeCode.vertexSource}`,define:n.shaderDefine},defaultProjectionData:c},u=a.renderingMode?a.renderingMode:"2d";if("offscreen"===e.renderPass){const t=a.prerender;t&&(e.setCustomLayerDefaults(),s.setColorMode(e.colorModeForRenderPass()),t.call(a,s.gl,h),s.setDirty(),e.setBaseState());}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),s.setColorMode(e.colorModeForRenderPass()),s.setStencilMode(Zt.disabled);const t="3d"===u?e.getDepthModeFor3D():e.getDepthModeForSublayer(0,Ot.ReadOnly);s.setDepthMode(t),a.render(s.gl,h),s.setDirty(),e.setBaseState(),s.bindFramebuffer.set(null);}}(e,0,r,s));}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return !1;if(!e.from||!e.to)return !0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return !t||!i}useProgram(e,t,i=!1){this.cache=this.cache||{};const r=!!this.style.map.terrain,o=this.style.projection,s=e+(t?t.cacheKey:"")+`/${i?gt:o.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(r?"/terrain":"");return this.cache[s]||(this.cache[s]=new Ti(this.context,dt[e],t,Qi[e],this._showOverdrawInspector,r,i?dt.projectionMercator:o.shaderPreludeCode,i?ft:o.shaderDefine)),this.cache[s]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new v(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}overLimit(){const{drawingBufferWidth:e,drawingBufferHeight:t}=this.context.gl;return this.width!==e||this.height!==t}}function yo(e,t){let i,r=!1,o=null,s=null;const a=()=>{o=null,r&&(e.apply(s,i),o=setTimeout(a,t),r=!1);};return (...e)=>(r=!0,s=this,i=e,o||a(),o)}class wo{constructor(e){this._getCurrentHash=()=>{const e=window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map((e=>e.split("="))).forEach((e=>{e[0]===this._hashName&&(t=e);})),(t&&t[1]||"").split("/")}return e.split("/")},this._onHashChange=()=>{const e=this._getCurrentHash();if(!this._isValidHash(e))return !1;const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0},this._updateHashUnthrottled=()=>{const e=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,e);},this._removeHash=()=>{const e=this._getCurrentHash();if(0===e.length)return;const t=e.join("/");let i=t;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${t}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let o=window.location.href.replace(/(#.+)?$/,r);o=o.replace("&&","&"),window.history.replaceState(window.history.state,null,o);},this._updateHash=yo(this._updateHashUnthrottled,300),this._hashName=e&&encodeURIComponent(e);}addTo(e){return this._map=e,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(e){const t=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),o=Math.pow(10,r),s=Math.round(t.lng*o)/o,a=Math.round(t.lat*o)/o,n=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=e?`/${s}/${a}/${i}`:`${i}/${a}/${s}`,(n||l)&&(c+="/"+Math.round(10*n)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const e=this._hashName;let t=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===e?(t=!0,`${r}=${c}`):i})).filter((e=>e));return t||i.push(`${e}=${c}`),`#${i.join("&")}`}return `#${c}`}_isValidHash(e){if(e.length<3||e.some(isNaN))return !1;try{new t.N(+e[2],+e[1]);}catch(e){return !1}const i=+e[0],r=+(e[3]||0),o=+(e[4]||0);return i>=this._map.getMinZoom()&&i<=this._map.getMaxZoom()&&r>=0&&r<=180&&o>=this._map.getMinPitch()&&o<=this._map.getMaxPitch()}}const To={linearity:.3,easing:t.c6(0,0,.3,1)},Po=t.e({deceleration:2500,maxSpeed:1400},To),Co=t.e({deceleration:20,maxSpeed:1400},To),Io=t.e({deceleration:1e3,maxSpeed:360},To),Eo=t.e({deceleration:1e3,maxSpeed:90},To),Mo=t.e({deceleration:1e3,maxSpeed:360},To);class So{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:a.now(),settings:e});}_drainInertiaBuffer(){const e=this._inertiaBuffer,t=a.now();for(;e.length>0&&t-e[0].time>160;)e.shift();}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,roll:0,pan:new t.P(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,i.roll+=e.rollDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const r=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,o={};if(i.pan.mag()){const s=Do(i.pan.mag(),r,t.e({},Po,e||{})),a=i.pan.mult(s.amount/i.pan.mag()),n=this._map.cameraHelper.handlePanInertia(a,this._map.transform);o.center=n.easingCenter,o.offset=n.easingOffset,Ro(o,s);}if(i.zoom){const e=Do(i.zoom,r,Co);o.zoom=this._map.transform.zoom+e.amount,Ro(o,e);}if(i.bearing){const e=Do(i.bearing,r,Io);o.bearing=this._map.transform.bearing+t.ab(e.amount,-179,179),Ro(o,e);}if(i.pitch){const e=Do(i.pitch,r,Eo);o.pitch=this._map.transform.pitch+e.amount,Ro(o,e);}if(i.roll){const e=Do(i.roll,r,Mo);o.roll=this._map.transform.roll+t.ab(e.amount,-179,179),Ro(o,e);}if(o.zoom||o.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;o.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),t.e(o,{noMoveStart:!0})}}function Ro(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function Do(e,i,r){const{maxSpeed:o,linearity:s,deceleration:a}=r,n=t.ab(e*s/(i/1e3),-o,o),l=Math.abs(n)/(a*s);return {easing:r.easing,duration:1e3*l,amount:n*(l/2)}}class zo extends t.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,r,o={}){const s=n.mousePos(i.getCanvas(),r),a=i.unproject(s);super(e,t.e({point:s,lngLat:a,originalEvent:r},o)),this._defaultPrevented=!1,this.target=i;}}class Ao extends t.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,r){const o="touchend"===e?r.changedTouches:r.touches,s=n.touchPos(i.getCanvasContainer(),o),a=s.map((e=>i.unproject(e))),l=s.reduce(((e,t,i,r)=>e.add(t.div(r.length))),new t.P(0,0));super(e,{points:s,point:l,lngLats:a,lngLat:i.unproject(l),originalEvent:r}),this._defaultPrevented=!1;}}class Lo extends t.k{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class ko{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){delete this._mousedownPos;}wheel(e){return this._firePreventable(new Lo(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new zo(e.type,this._map,e))}mouseup(e){this._map.fire(new zo(e.type,this._map,e));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||this._map.fire(new zo(e.type,this._map,e));}dblclick(e){return this._firePreventable(new zo(e.type,this._map,e))}mouseover(e){this._map.fire(new zo(e.type,this._map,e));}mouseout(e){this._map.fire(new zo(e.type,this._map,e));}touchstart(e){return this._firePreventable(new Ao(e.type,this._map,e))}touchmove(e){this._map.fire(new Ao(e.type,this._map,e));}touchend(e){this._map.fire(new Ao(e.type,this._map,e));}touchcancel(e){this._map.fire(new Ao(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Fo{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent;}mousemove(e){this._map.fire(new zo(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new zo("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._ignoreContextMenu||this._map.fire(new zo(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class Bo{constructor(e){this._map=e;}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return {lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this._map.terrain)}}class jo{constructor(e,t){this._map=e,this._tr=new Bo(e),this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(n.disableDrag(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=n.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",e));const o=Math.min(r.x,i.x),s=Math.max(r.x,i.x),a=Math.min(r.y,i.y),l=Math.max(r.y,i.y);n.setTransform(this._box,`translate(${o}px,${a}px)`),this._box.style.width=s-o+"px",this._box.style.height=l-a+"px";}mouseupWindow(e,i){if(!this._active)return;if(0!==e.button)return;const r=this._startPos,o=i;if(this.reset(),n.suppressClick(),r.x!==o.x||r.y!==o.y)return this._map.fire(new t.k("boxzoomend",{originalEvent:e})),{cameraAnimation:e=>e.fitScreenCoordinates(r,o,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",e);}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(n.remove(this._box),this._box=null),n.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(e,i){return this._map.fire(new t.k(e,{originalEvent:i}))}}function Oo(e,t){if(e.length!==t.length)throw new Error(`The number of touches and points are not equal - touches ${e.length}, points ${t.length}`);const i={};for(let r=0;r<e.length;r++)i[e[r].identifier]=t[r];return i}class No{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(e,i,r){(this.centroid||r.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),r.length===this.numTouches&&(this.centroid=function(e){const i=new t.P(0,0);for(const t of e)i._add(t);return i.div(e.length)}(i),this.touches=Oo(r,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const r=Oo(i,t);for(const e in this.touches){const t=r[e];(!t||t.dist(this.touches[e])>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class Zo{constructor(e){this.singleTap=new No(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const r=this.singleTap.touchend(e,t,i);if(r){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class Go{constructor(e){this._tr=new Bo(e),this._zoomIn=new Zo({numTouches:1,numTaps:2}),this._zoomOut=new Zo({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const r=this._zoomIn.touchend(e,t,i),o=this._zoomOut.touchend(e,t,i),s=this._tr;return r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:s.zoom+1,around:s.unproject(r)},{originalEvent:e})}):o?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:s.zoom-1,around:s.unproject(o)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Uo{constructor(e){this._enabled=!!e.enable,this._moveStateManager=e.moveStateManager,this._clickTolerance=e.clickTolerance||1,this._moveFunction=e.move,this._activateOnStart=!!e.activateOnStart,e.assignEvents(this),this.reset();}reset(e){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(e);}_move(...e){const t=this._moveFunction(...e);if(t.bearingDelta||t.pitchDelta||t.rollDelta||t.around||t.panDelta)return this._active=!0,t}dragStart(e,t){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(e)&&(this._moveStateManager.startMove(e),this._lastPoint=Array.isArray(t)?t[0]:t,this._activateOnStart&&this._lastPoint&&(this._active=!0));}dragMove(e,t){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(e.preventDefault(),!this._moveStateManager.isValidMoveEvent(e))return void this.reset(e);const r=Array.isArray(t)?t[0]:t;return !this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(e){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(e)&&(this._moved&&n.suppressClick(),this.reset(e));}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const Vo={0:1,2:2};class qo{constructor(e){this._correctEvent=e.checkCorrectEvent;}startMove(e){const t=n.mouseButton(e);this._eventButton=t;}endMove(e){delete this._eventButton;}isValidStartEvent(e){return this._correctEvent(e)}isValidMoveEvent(e){return !function(e,t){const i=Vo[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton)}isValidEndEvent(e){return n.mouseButton(e)===this._eventButton}}class Ho{constructor(){this._firstTouch=void 0;}_isOneFingerTouch(e){return 1===e.targetTouches.length}_isSameTouchEvent(e){return e.targetTouches[0].identifier===this._firstTouch}startMove(e){this._firstTouch=e.targetTouches[0].identifier;}endMove(e){delete this._firstTouch;}isValidStartEvent(e){return this._isOneFingerTouch(e)}isValidMoveEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}isValidEndEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}}class Wo{constructor(e=new qo({checkCorrectEvent:()=>!0}),t=new Ho){this.mouseMoveStateManager=e,this.oneFingerTouchMoveStateManager=t;}_executeRelevantHandler(e,t,i){return e instanceof MouseEvent?t(e):"undefined"!=typeof TouchEvent&&e instanceof TouchEvent?i(e):void 0}startMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.startMove(e)),(e=>this.oneFingerTouchMoveStateManager.startMove(e)));}endMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.endMove(e)),(e=>this.oneFingerTouchMoveStateManager.endMove(e)));}isValidStartEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidStartEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidStartEvent(e)))}isValidMoveEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidMoveEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(e)))}isValidEndEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidEndEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidEndEvent(e)))}}const Xo=e=>{e.mousedown=e.dragStart,e.mousemoveWindow=e.dragMove,e.mouseup=e.dragEnd,e.contextmenu=e=>{e.preventDefault();};};class $o{constructor(e,t){this._clickTolerance=e.clickTolerance||1,this._map=t,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new t.P(0,0);}_shouldBePrevented(e){return e<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active){if(!this._shouldBePrevented(i.length))return e.preventDefault(),this._calculateTransform(e,t,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",e);}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&this._shouldBePrevented(i.length)&&this.reset();}touchcancel(){this.reset();}_calculateTransform(e,i,r){r.length>0&&(this._active=!0);const o=Oo(r,i),s=new t.P(0,0),a=new t.P(0,0);let n=0;for(const e in o){const t=o[e],i=this._touches[e];i&&(s._add(t),a._add(t.sub(i)),n++,o[e]=t);}if(this._touches=o,this._shouldBePrevented(n)||!a.mag())return;const l=a.div(n);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:s.div(n),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Ko{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[r,o]=this._firstTwoTouches,s=Yo(i,t,r),a=Yo(i,t,o);if(!s||!a)return;const n=this._aroundCenter?null:s.add(a).div(2);return this._move([s,a],n,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[r,o]=this._firstTwoTouches,s=Yo(i,t,r),a=Yo(i,t,o);s&&a||(this._active&&n.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}}function Yo(e,t,i){for(let r=0;r<e.length;r++)if(e[r].identifier===i)return t[r]}function Jo(e,t){return Math.log(e/t)/Math.LN2}class Qo extends Ko{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(Jo(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Jo(this._distance,i),pinchAround:t}}}function es(e,t){return 180*e.angleWith(t)/Math.PI}class ts extends Ko{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t,i){const r=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:es(this._vector,r),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=es(e,this._startVector);return Math.abs(i)<t}}function is(e){return Math.abs(e.y)>Math.abs(e.x)}class rs extends Ko{constructor(e){super(),this._currentTouchCount=0,this._map=e;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}touchstart(e,t,i){super.touchstart(e,t,i),this._currentTouchCount=i.length;}_start(e){this._lastPoints=e,is(e[0].sub(e[1]))&&(this._valid=!1);}_move(e,t,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=e[0].sub(this._lastPoints[0]),o=e[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,o,i.timeStamp),this._valid?(this._lastPoints=e,this._active=!0,{pitchDelta:(r.y+o.y)/2*-.5}):void 0}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const r=e.mag()>=2,o=t.mag()>=2;if(!r&&!o)return;if(!r||!o)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const s=e.y>0==t.y>0;return is(e)&&is(t)&&s}}const os={panStep:100,bearingStep:15,pitchStep:10};class ss{constructor(e){this._tr=new Bo(e);const t=os;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,r=0,o=0,s=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),o=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),o=1);break;case 38:e.shiftKey?r=1:(e.preventDefault(),s=-1);break;case 40:e.shiftKey?r=-1:(e.preventDefault(),s=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:a=>{const n=this._tr;a.easeTo({duration:300,easeId:"keyboardHandler",easing:as,zoom:t?Math.round(n.zoom)+t*(e.shiftKey?2:1):n.zoom,bearing:n.bearing+i*this._bearingStep,pitch:n.pitch+r*this._pitchStep,offset:[-o*this._panStep,-s*this._panStep],center:n.center},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function as(e){return e*(2-e)}const ns=4.000244140625;class ls{constructor(e,t){this._onTimeout=e=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);},this._map=e,this._tr=new Bo(e),this._triggerRenderFrame=t,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222;}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around);}disable(){this.isEnabled()&&(this._enabled=!1);}_shouldBePrevented(e){return !!this._map.cooperativeGestures.isEnabled()&&!(e.ctrlKey||this._map.cooperativeGestures.isBypassed(e))}wheel(e){if(!this.isEnabled())return;if(this._shouldBePrevented(e))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",e);let t=e.deltaMode===WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const i=a.now(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==t&&t%ns==0?this._type="wheel":0!==t&&Math.abs(t)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=t,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(r*t)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,t+=this._lastValue)),e.shiftKey&&t&&(t/=4),this._type&&(this._lastWheelEvent=e,this._delta-=t,this._active||this._start(e)),e.preventDefault();}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const i=n.mousePos(this._map.getCanvas(),e),r=this._tr;this._aroundPoint=this._aroundCenter?r.transform.locationToScreenPoint(t.N.convert(r.center)):i,this._frameId||(this._frameId=!0,this._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const t=e.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=t),"number"==typeof this._targetZoom&&(this._targetZoom+=t);}if(0!==this._delta){const i="wheel"===this._type&&Math.abs(this._delta)>ns?this._wheelZoomRate:this._defaultZoomRate;let r=2/(1+Math.exp(-Math.abs(this._delta*i)));this._delta<0&&0!==r&&(r=1/r);const o="number"!=typeof this._targetZoom?e.scale:t.aG(this._targetZoom);this._targetZoom=Math.min(e.maxZoom,Math.max(e.minZoom,t.a8(o*r))),"wheel"===this._type&&(this._startZoom=e.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0;}const i="number"!=typeof this._targetZoom?e.zoom:this._targetZoom,r=this._startZoom,o=this._easing;let s,n=!1;if("wheel"===this._type&&r&&o){const e=a.now()-this._lastWheelEventTime,l=Math.min((e+5)/200,1),c=o(l);s=t.y.number(r,i,c),l<1?this._frameId||(this._frameId=!0):n=!0;}else s=i,n=!0;return this._active=!0,n&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout;}),200)),this._lastExpectedZoom=s,{noInertia:!0,needsRenderFrame:!n,zoomDelta:s-e.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let i=t.c8;if(this._prevEase){const e=this._prevEase,r=(a.now()-e.start)/e.duration,o=e.easing(r+.01)-e.easing(r),s=.27/Math.sqrt(o*o+1e-4)*.01,n=Math.sqrt(.0729-s*s);i=t.c6(s,n,.25,1);}return this._prevEase={start:a.now(),duration:e,easing:i},i}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);}}class cs{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class hs{constructor(e){this._tr=new Bo(e),this.reset();}reset(){this._active=!1;}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(e.shiftKey?-1:1),around:this._tr.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class us{constructor(){this._tap=new Zo({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset();}touchstart(e,t,i){if(!this._swipePoint)if(this._tapTime){const r=t[0],o=e.timeStamp-this._tapTime<500,s=this._tapPoint.dist(r)<30;o&&s?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset();}else this._tap.touchstart(e,t,i);}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=t[0],o=r.y-this._swipePoint.y;return this._swipePoint=r,e.preventDefault(),this._active=!0,{zoomDelta:o/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else {const r=this._tap.touchend(e,t,i);r&&(this._tapTime=e.timeStamp,this._tapPoint=r);}}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class ds{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class _s{constructor(e,t,i,r){this._pitchWithRotate=e.pitchWithRotate,this._rollEnabled=e.rollEnabled,this._mouseRotate=t,this._mousePitch=i,this._mouseRoll=r;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class ps{constructor(e,t,i,r){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}class ms{constructor(e,t){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=e,this._options=t,this._enabled=!1;}isActive(){return !1}reset(){}_setupUI(){if(this._container)return;const e=this._map.getCanvasContainer();e.classList.add("maplibregl-cooperative-gestures"),this._container=n.create("div","maplibregl-cooperative-gesture-screen",e);let t=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(t=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=t,this._container.appendChild(r);const o=document.createElement("div");o.className="maplibregl-mobile-message",o.textContent=i,this._container.appendChild(o),this._container.setAttribute("aria-hidden","true");}_destroyUI(){this._container&&(n.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container;}enable(){this._setupUI(),this._enabled=!0;}disable(){this._enabled=!1,this._destroyUI();}isEnabled(){return this._enabled}isBypassed(e){return e[this._bypassKey]}notifyGestureBlocked(e,i){this._enabled&&(this._map.fire(new t.k("cooperativegestureprevented",{gestureType:e,originalEvent:i})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show");}),100));}}const fs=e=>e.zoom||e.drag||e.roll||e.pitch||e.rotate;class gs extends t.k{}function vs(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta||e.rollDelta}class xs{constructor(e,t){this.handleWindowEvent=e=>{this.handleEvent(e,`${e.type}Window`);},this.handleEvent=(e,t)=>{if("blur"===e.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===e.type?void 0:e,r={needsRenderFrame:!1},o={},s={},a=e.touches,l=a?this._getMapTouches(a):void 0,c=l?n.touchPos(this._map.getCanvas(),l):n.mousePos(this._map.getCanvas(),e);for(const{handlerName:a,handler:n,allowed:h}of this._handlers){if(!n.isEnabled())continue;let u;this._blockedByActive(s,h,a)?n.reset():n[t||e.type]&&(u=n[t||e.type](e,c,l),this.mergeHandlerResult(r,o,u,a,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||n.isActive())&&(s[a]=n);}const h={};for(const e in this._previousActiveHandlers)s[e]||(h[e]=i);this._previousActiveHandlers=s,(Object.keys(h).length||vs(r))&&(this._changes.push([r,o,h]),this._triggerRenderFrame()),(Object.keys(s).length||vs(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:u}=r;u&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],u(this._map));},this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new So(e),this._bearingSnap=t.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(t);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[e,t,i]of this._listeners)n.addEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}destroy(){for(const[e,t,i]of this._listeners)n.removeEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}_addDefaultHandlers(e){const i=this._map,r=i.getCanvasContainer();this._add("mapEvent",new ko(i,e));const o=i.boxZoom=new jo(i,e);this._add("boxZoom",o),e.interactive&&e.boxZoom&&o.enable();const s=i.cooperativeGestures=new ms(i,e.cooperativeGestures);this._add("cooperativeGestures",s),e.cooperativeGestures&&s.enable();const a=new Go(i),l=new hs(i);i.doubleClickZoom=new cs(l,a),this._add("tapZoom",a),this._add("clickZoom",l),e.interactive&&e.doubleClickZoom&&i.doubleClickZoom.enable();const c=new us;this._add("tapDragZoom",c);const h=i.touchPitch=new rs(i);this._add("touchPitch",h),e.interactive&&e.touchPitch&&i.touchPitch.enable(e.touchPitch);const u=()=>i.project(i.getCenter()),d=function({enable:e,clickTolerance:i,aroundCenter:r=!0,minPixelCenterThreshold:o=100,rotateDegreesPerPixelMoved:s=.8},a){const l=new qo({checkCorrectEvent:e=>0===n.mouseButton(e)&&e.ctrlKey||2===n.mouseButton(e)&&!e.ctrlKey});return new Uo({clickTolerance:i,move:(e,i)=>{const n=a();if(r&&Math.abs(n.y-e.y)>o)return {bearingDelta:t.c7(new t.P(e.x,i.y),i,n)};let l=(i.x-e.x)*s;return r&&i.y<n.y&&(l=-l),{bearingDelta:l}},moveStateManager:l,enable:e,assignEvents:Xo})}(e,u),_=function({enable:e,clickTolerance:t,pitchDegreesPerPixelMoved:i=-.5}){const r=new qo({checkCorrectEvent:e=>0===n.mouseButton(e)&&e.ctrlKey||2===n.mouseButton(e)});return new Uo({clickTolerance:t,move:(e,t)=>({pitchDelta:(t.y-e.y)*i}),moveStateManager:r,enable:e,assignEvents:Xo})}(e),p=function({enable:e,clickTolerance:t,rollDegreesPerPixelMoved:i=.3},r){const o=new qo({checkCorrectEvent:e=>2===n.mouseButton(e)&&e.ctrlKey});return new Uo({clickTolerance:t,move:(e,t)=>{const o=r();let s=(t.x-e.x)*i;return t.y<o.y&&(s=-s),{rollDelta:s}},moveStateManager:o,enable:e,assignEvents:Xo})}(e,u);i.dragRotate=new _s(e,d,_,p),this._add("mouseRotate",d,["mousePitch"]),this._add("mousePitch",_,["mouseRotate","mouseRoll"]),this._add("mouseRoll",p,["mousePitch"]),e.interactive&&e.dragRotate&&i.dragRotate.enable();const m=function({enable:e,clickTolerance:t}){const i=new qo({checkCorrectEvent:e=>0===n.mouseButton(e)&&!e.ctrlKey});return new Uo({clickTolerance:t,move:(e,t)=>({around:t,panDelta:t.sub(e)}),activateOnStart:!0,moveStateManager:i,enable:e,assignEvents:Xo})}(e),f=new $o(e,i);i.dragPan=new ds(r,m,f),this._add("mousePan",m),this._add("touchPan",f,["touchZoom","touchRotate"]),e.interactive&&e.dragPan&&i.dragPan.enable(e.dragPan);const g=new ts,v=new Qo;i.touchZoomRotate=new ps(r,v,g,c),this._add("touchRotate",g,["touchPan","touchZoom"]),this._add("touchZoom",v,["touchPan","touchRotate"]),e.interactive&&e.touchZoomRotate&&i.touchZoomRotate.enable(e.touchZoomRotate);const x=i.scrollZoom=new ls(i,(()=>this._triggerRenderFrame()));this._add("scrollZoom",x,["mousePan"]),e.interactive&&e.scrollZoom&&i.scrollZoom.enable(e.scrollZoom);const b=i.keyboard=new ss(i);this._add("keyboard",b),e.interactive&&e.keyboard&&i.keyboard.enable(),this._add("blockableMapEvent",new Fo(i));}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(fs(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const r in e)if(r!==i&&(!t||t.indexOf(r)<0))return !0;return !1}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}mergeHandlerResult(e,i,r,o,s){if(!r)return;t.e(e,r);const a={handlerName:o,originalEvent:r.originalEvent||s};void 0!==r.zoomDelta&&(i.zoom=a),void 0!==r.panDelta&&(i.drag=a),void 0!==r.rollDelta&&(i.roll=a),void 0!==r.pitchDelta&&(i.pitch=a),void 0!==r.bearingDelta&&(i.rotate=a);}_applyChanges(){const e={},i={},r={};for(const[o,s,a]of this._changes)o.panDelta&&(e.panDelta=(e.panDelta||new t.P(0,0))._add(o.panDelta)),o.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+o.zoomDelta),o.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+o.bearingDelta),o.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+o.pitchDelta),o.rollDelta&&(e.rollDelta=(e.rollDelta||0)+o.rollDelta),void 0!==o.around&&(e.around=o.around),void 0!==o.pinchAround&&(e.pinchAround=o.pinchAround),o.noInertia&&(e.noInertia=o.noInertia),t.e(i,s),t.e(r,a);this._updateMapTransform(e,i,r),this._changes=[];}_updateMapTransform(e,t,i){const r=this._map,o=r._getTransformForUpdate(),s=r.terrain;if(!(vs(e)||s&&this._terrainMovement))return this._fireEvents(t,i,!0);r._stop(!0);let{panDelta:a,zoomDelta:n,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:d}=e;void 0!==d&&(u=d),u=u||r.transform.centerPoint,s&&!o.isPointOnMapSurface(u)&&(u=o.centerPoint);const _={panDelta:a,zoomDelta:n,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!o.isPointOnMapSurface(u)&&(u=o.centerPoint);const p=u.distSqr(o.centerPoint)<.01?o.center:o.screenPointToLocation(a?u.sub(a):u);s?(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(_,o),this._terrainMovement||!t.drag&&!t.zoom?t.drag&&this._terrainMovement?o.setCenter(o.screenPointToLocation(o.centerPoint.sub(a))):this._map.cameraHelper.handleMapControlsPan(_,o,p):(this._terrainMovement=!0,this._map._elevationFreeze=!0,this._map.cameraHelper.handleMapControlsPan(_,o,p))):(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(_,o),this._map.cameraHelper.handleMapControlsPan(_,o,p)),r._applyUpdatedTransform(o),this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(t,i,!0);}_fireEvents(e,i,r){const o=fs(this._eventsInProgress),s=fs(e),n={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(n[`${t}start`]=i),this._eventsInProgress[t]=e[t];}!o&&s&&this._fireEvent("movestart",s.originalEvent);for(const e in n)this._fireEvent(e,n[e]);s&&this._fireEvent("move",s.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i);}const l={};let c;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:r}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],c=i[t]||r,l[`${e}end`]=c);}for(const e in l)this._fireEvent(e,l[e]);const h=fs(this._eventsInProgress),u=(o||s)&&!h;if(u&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const e=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&e.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(e);}if(r&&u){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;!e||!e.essential&&a.prefersReducedMotion?(this._map.fire(new t.k("moveend",{originalEvent:c})),i(this._map.getBearing())&&this._map.resetNorth()):(i(e.bearing||this._map.getBearing())&&(e.bearing=0),e.freezeElevation=!0,this._map.easeTo(e,{originalEvent:c})),this._updatingCamera=!1;}}_fireEvent(e,i){this._map.fire(new t.k(e,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{delete this._frameId,this.handleEvent(new gs("renderFrame",{timeStamp:e})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class bs extends t.E{constructor(e,t,i){super(),this._renderFrameCallback=()=>{const e=Math.min((a.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();},this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,this.cameraHelper=t,this.on("moveend",(()=>{delete this._requestedCameraState;}));}migrateProjection(e,t){e.apply(this.transform),this.transform=e,this.cameraHelper=t;}getCenter(){return new t.N(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}getCenterElevation(){return this.transform.elevation}setCenterElevation(e,t){return this.jumpTo({elevation:e},t),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(e){this._centerClampedToGround=e;}panBy(e,i,r){return e=t.P.convert(e).mult(-1),this.panTo(this.transform.center,t.e({offset:e},i),r)}panTo(e,i,r){return this.easeTo(t.e({center:e},i),r)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(e,i,r){return this.easeTo(t.e({zoom:e},i),r)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(e,i){return e!=this.transform.fov&&(this.transform.setFov(e),this.fire(new t.k("movestart",i)).fire(new t.k("move",i)).fire(new t.k("moveend",i))),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(e,i,r){return this.easeTo(t.e({bearing:e},i),r)}resetNorth(e,i){return this.rotateTo(0,t.e({duration:1e3},e),i),this}resetNorthPitch(e,i){return this.easeTo(t.e({bearing:0,pitch:0,roll:0,duration:1e3},e),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}getRoll(){return this.transform.roll}setRoll(e,t){return this.jumpTo({roll:e},t),this}cameraForBounds(e,t){e=V.convert(e).adjustAntiMeridian();const i=t&&t.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),i,t)}_cameraForBoxAndBearing(e,i,r,o){const s={top:0,bottom:0,right:0,left:0};if("number"==typeof(o=t.e({padding:s,offset:[0,0],maxZoom:this.transform.maxZoom},o)).padding){const e=o.padding;o.padding={top:e,bottom:e,right:e,left:e};}const a=t.e(s,o.padding);o.padding=a;const n=this.transform,l=new V(e,i);return this.cameraHelper.cameraForBoxAndBearing(o,a,l,r,n)}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}fitScreenCoordinates(e,i,r,o,s){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(t.P.convert(e)),this.transform.screenPointToLocation(t.P.convert(i)),r,o),o,s)}_fitInternal(e,i,r){return e?(delete(i=t.e(e,i)).padding,i.linear?this.easeTo(i,r):this.flyTo(i,r)):this}jumpTo(e,i){this.stop();const r=this._getTransformForUpdate();let o=!1,s=!1,a=!1;const n=r.zoom;this.cameraHelper.handleJumpToCenterZoom(r,e);const l=r.zoom!==n;return "elevation"in e&&r.elevation!==+e.elevation&&r.setElevation(+e.elevation),"bearing"in e&&r.bearing!==+e.bearing&&(o=!0,r.setBearing(+e.bearing)),"pitch"in e&&r.pitch!==+e.pitch&&(s=!0,r.setPitch(+e.pitch)),"roll"in e&&r.roll!==+e.roll&&(a=!0,r.setRoll(+e.roll)),null==e.padding||r.isPaddingEqual(e.padding)||r.setPadding(e.padding),this._applyUpdatedTransform(r),this.fire(new t.k("movestart",i)).fire(new t.k("move",i)),l&&this.fire(new t.k("zoomstart",i)).fire(new t.k("zoom",i)).fire(new t.k("zoomend",i)),o&&this.fire(new t.k("rotatestart",i)).fire(new t.k("rotate",i)).fire(new t.k("rotateend",i)),s&&this.fire(new t.k("pitchstart",i)).fire(new t.k("pitch",i)).fire(new t.k("pitchend",i)),a&&this.fire(new t.k("rollstart",i)).fire(new t.k("roll",i)).fire(new t.k("rollend",i)),this.fire(new t.k("moveend",i))}calculateCameraOptionsFromTo(e,i,r,o=0){const s=t.Y.fromLngLat(e,i),a=t.Y.fromLngLat(r,o),n=a.x-s.x,l=a.y-s.y,c=a.z-s.z,h=Math.hypot(n,l,c);if(0===h)throw new Error("Can't calculate camera options with same From and To");const u=Math.hypot(n,l),d=t.a8(this.transform.cameraToCenterDistance/h/this.transform.tileSize),_=180*Math.atan2(n,-l)/Math.PI;let p=180*Math.acos(u/h)/Math.PI;return p=c<0?90-p:90+p,{center:a.toLngLat(),elevation:o,zoom:d,pitch:p,bearing:_}}calculateCameraOptionsFromCameraLngLatAltRotation(e,t,i,r,o){const s=this.transform.calculateCenterFromCameraLngLatAlt(e,t,i,r);return {center:s.center,elevation:s.elevation,zoom:s.zoom,bearing:i,pitch:r,roll:o}}easeTo(e,i){this._stop(!1,e.easeId),(!1===(e=t.e({offset:[0,0],duration:500,easing:t.c8},e)).animate||!e.essential&&a.prefersReducedMotion)&&(e.duration=0);const r=this._getTransformForUpdate(),o=this.getBearing(),s=r.pitch,n=r.roll,l="bearing"in e?this._normalizeBearing(e.bearing,o):o,c="pitch"in e?+e.pitch:s,h="roll"in e?this._normalizeBearing(e.roll,n):n,u="padding"in e?e.padding:r.padding,d=t.P.convert(e.offset);let _,p;e.around&&(_=t.N.convert(e.around),p=r.locationToScreenPoint(_));const m={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},f=this.cameraHelper.handleEaseTo(r,{bearing:l,pitch:c,roll:h,padding:u,around:_,aroundPoint:p,offsetAsPoint:d,offset:e.offset,zoom:e.zoom,center:e.center});return this._rotating=this._rotating||o!==l,this._pitching=this._pitching||c!==s,this._rolling=this._rolling||h!==n,this._padding=!r.isPaddingEqual(u),this._zooming=this._zooming||f.isZooming,this._easeId=e.easeId,this._prepareEase(i,e.noMoveStart,m),this.terrain&&this._prepareElevation(f.elevationCenter),this._ease((t=>{f.easeFunc(t),this.terrain&&!e.freezeElevation&&this._updateElevation(t),this._applyUpdatedTransform(r),this._fireMoveEvents(i);}),(t=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i,t);}),e),this}_prepareEase(e,i,r={}){this._moving=!0,i||r.moving||this.fire(new t.k("movestart",e)),this._zooming&&!r.zooming&&this.fire(new t.k("zoomstart",e)),this._rotating&&!r.rotating&&this.fire(new t.k("rotatestart",e)),this._pitching&&!r.pitching&&this.fire(new t.k("pitchstart",e)),this._rolling&&!r.rolling&&this.fire(new t.k("rollstart",e));}_prepareElevation(e){this._elevationCenter=e,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(e,this.transform.tileZoom),this._elevationFreeze=!0;}_updateElevation(e){this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const i=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(e<1&&i!==this._elevationTarget){const t=this._elevationTarget-this._elevationStart;this._elevationStart+=e*(t-(i-(t*e+this._elevationStart))/(1-e)),this._elevationTarget=i;}this.transform.setElevation(t.y.number(this._elevationStart,this._elevationTarget,e));}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain);}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(e){if(!this.terrain&&e.elevation>=0&&e.pitch<=90)return {};const t=e.getCameraLngLat(),i=e.getCameraAltitude(),r=this.terrain?this.terrain.getElevationForLngLatZoom(t,e.zoom):0;if(i<r){const i=this.calculateCameraOptionsFromTo(t,r,e.center,e.elevation);return {pitch:i.pitch,zoom:i.zoom}}return {}}_applyUpdatedTransform(e){const t=[];if(t.push((e=>this._elevateCameraIfInsideTerrain(e))),this.transformCameraUpdate&&t.push((e=>this.transformCameraUpdate(e))),!t.length)return;const i=e.clone();for(const e of t){const t=i.clone(),{center:r,zoom:o,roll:s,pitch:a,bearing:n,elevation:l}=e(t);r&&t.setCenter(r),void 0!==l&&t.setElevation(l),void 0!==o&&t.setZoom(o),void 0!==s&&t.setRoll(s),void 0!==a&&t.setPitch(a),void 0!==n&&t.setBearing(n),i.apply(t);}this.transform.apply(i);}_fireMoveEvents(e){this.fire(new t.k("move",e)),this._zooming&&this.fire(new t.k("zoom",e)),this._rotating&&this.fire(new t.k("rotate",e)),this._pitching&&this.fire(new t.k("pitch",e)),this._rolling&&this.fire(new t.k("roll",e));}_afterEase(e,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId;const r=this._zooming,o=this._rotating,s=this._pitching,a=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,r&&this.fire(new t.k("zoomend",e)),o&&this.fire(new t.k("rotateend",e)),s&&this.fire(new t.k("pitchend",e)),a&&this.fire(new t.k("rollend",e)),this.fire(new t.k("moveend",e));}flyTo(e,i){if(!e.essential&&a.prefersReducedMotion){const r=t.M(e,["center","zoom","bearing","pitch","roll","elevation"]);return this.jumpTo(r,i)}this.stop(),e=t.e({offset:[0,0],speed:1.2,curve:1.42,easing:t.c8},e);const r=this._getTransformForUpdate(),o=r.bearing,s=r.pitch,n=r.roll,l=r.padding,c="bearing"in e?this._normalizeBearing(e.bearing,o):o,h="pitch"in e?+e.pitch:s,u="roll"in e?this._normalizeBearing(e.roll,n):n,d="padding"in e?e.padding:r.padding,_=t.P.convert(e.offset);let p=r.centerPoint.add(_);const m=r.screenPointToLocation(p),f=this.cameraHelper.handleFlyTo(r,{bearing:c,pitch:h,roll:u,padding:d,locationAtOffset:m,offsetAsPoint:_,center:e.center,minZoom:e.minZoom,zoom:e.zoom});let g=e.curve;const v=Math.max(r.width,r.height),x=v/f.scaleOfZoom,b=f.pixelPathLength;"number"==typeof f.scaleOfMinZoom&&(g=Math.sqrt(v/f.scaleOfMinZoom/b*2));const y=g*g;function w(e){const t=(x*x-v*v+(e?-1:1)*y*y*b*b)/(2*(e?x:v)*y*b);return Math.log(Math.sqrt(t*t+1)-t)}function T(e){return (Math.exp(e)-Math.exp(-e))/2}function P(e){return (Math.exp(e)+Math.exp(-e))/2}const C=w(!1);let I=function(e){return P(C)/P(C+g*e)},E=function(e){return v*((P(C)*(T(t=C+g*e)/P(t))-T(C))/y)/b;var t;},M=(w(!0)-C)/g;if(Math.abs(b)<2e-6||!isFinite(M)){if(Math.abs(v-x)<1e-6)return this.easeTo(e,i);const t=x<v?-1:1;M=Math.abs(Math.log(x/v))/g,E=()=>0,I=e=>Math.exp(t*g*e);}return e.duration="duration"in e?+e.duration:1e3*M/("screenSpeed"in e?+e.screenSpeed/g:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=o!==c,this._pitching=h!==s,this._rolling=u!==n,this._padding=!r.isPaddingEqual(d),this._prepareEase(i,!1),this.terrain&&this._prepareElevation(f.targetCenter),this._ease((a=>{const m=a*M,g=1/I(m),v=E(m);this._rotating&&r.setBearing(t.y.number(o,c,a)),this._pitching&&r.setPitch(t.y.number(s,h,a)),this._rolling&&r.setRoll(t.y.number(n,u,a)),this._padding&&(r.interpolatePadding(l,d,a),p=r.centerPoint.add(_)),f.easeFunc(a,g,v,p),this.terrain&&!e.freezeElevation&&this._updateElevation(a),this._applyUpdatedTransform(r),this._fireMoveEvents(i);}),(()=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i);}),e),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t);}return e||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(e,t,i){!1===i.animate||0===i.duration?(e(1),t()):(this._easeStart=a.now(),this._easeOptions=i,this._onEaseFrame=e,this._onEaseEnd=t,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_normalizeBearing(e,i){e=t.aI(e,-180,180);const r=Math.abs(e-i);return Math.abs(e-360-i)<r&&(e-=360),Math.abs(e+360-i)<r&&(e+=360),e}queryTerrainElevation(e){return this.terrain?this.terrain.getElevationForLngLatZoom(t.N.convert(e),this.transform.tileZoom):null}}const ys={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class ws{constructor(e=ys){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")));},this._updateData=e=>{!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType&&"terrain"!==e.type||this._updateAttributions();},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"));},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show");},this.options=e;}getDefaultPosition(){return "bottom-right"}onAdd(e){return this._map=e,this._compact=this.options.compact,this._container=n.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=n.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=n.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){n.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._sanitizedAttributionHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.title=i,e.setAttribute("aria-label",i);}_updateAttributions(){if(!this._map.style)return;let e=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=e.concat(this.options.customAttribution.map((e=>"string"!=typeof e?"":e))):"string"==typeof this.options.customAttribution&&e.push(this.options.customAttribution)),this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style.sourceCaches;for(const i in t){const r=t[i];if(r.used||r.usedForTerrain){const t=r.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e=e.filter((e=>String(e).trim())),e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let r=i+1;r<e.length;r++)if(e[r].indexOf(t)>=0)return !1;return !0}));const i=e.join(" | ");i!==this._sanitizedAttributionHTML&&(this._sanitizedAttributionHTML=n.sanitize(i),e.length?(this._innerContainer.innerHTML=this._sanitizedAttributionHTML,this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null);}}class Ts{constructor(e={}){this._updateCompact=()=>{const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&t.classList.add("maplibregl-compact"):t.classList.remove("maplibregl-compact");}},this.options=e;}getDefaultPosition(){return "bottom-left"}onAdd(e){this._map=e,this._compact=this.options&&this.options.compact,this._container=n.create("div","maplibregl-ctrl");const t=n.create("a","maplibregl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://maplibre.org/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){n.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0;}}class Ps{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}var Cs=t.aA([{name:"a_pos3d",type:"Int16",components:3}]);class Is extends t.E{constructor(e){super(),this._lastTilesetChange=a.now(),this.sourceCache=e,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=e._source.tileSize*2**this.deltaZoom,e.usedForTerrain=!0,e.tileSize=this.tileSize;}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null;}update(e,i){this.sourceCache.update(e,i),this._renderableTilesKeys=[];const r={};for(const o of ue(e,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:i,calculateTileZoom:this.sourceCache._source.calculateTileZoom}))r[o.key]=!0,this._renderableTilesKeys.push(o.key),this._tiles[o.key]||(o.terrainRttPosMatrix32f=new Float64Array(16),t.bL(o.terrainRttPosMatrix32f,0,t.X,t.X,0,0,1),this._tiles[o.key]=new se(o,this.tileSize),this._lastTilesetChange=a.now());for(const e in this._tiles)r[e]||delete this._tiles[e];}freeRtt(e){for(const t in this._tiles){const i=this._tiles[t];(!e||i.tileID.equals(e)||i.tileID.isChildOf(e)||e.isChildOf(i.tileID))&&(i.rtt=[]);}}getRenderableTiles(){return this._renderableTilesKeys.map((e=>this.getTileByID(e)))}getTileByID(e){return this._tiles[e]}getTerrainCoords(e){const i={};for(const r of this._renderableTilesKeys){const o=this._tiles[r].tileID,s=e.clone(),a=t.a$();if(o.canonical.equals(e.canonical))t.bL(a,0,t.X,t.X,0,0,1);else if(o.canonical.isChildOf(e.canonical)){const i=o.canonical.z-e.canonical.z,r=o.canonical.x-(o.canonical.x>>i<<i),s=o.canonical.y-(o.canonical.y>>i<<i),n=t.X>>i;t.bL(a,0,n,n,0,0,1),t.J(a,a,[-r*n,-s*n,0]);}else {if(!e.canonical.isChildOf(o.canonical))continue;{const i=e.canonical.z-o.canonical.z,r=e.canonical.x-(e.canonical.x>>i<<i),s=e.canonical.y-(e.canonical.y>>i<<i),n=t.X>>i;t.bL(a,0,t.X,t.X,0,0,1),t.J(a,a,[r*n,s*n,0]),t.K(a,a,[1/2**i,1/2**i,0]);}}s.terrainRttPosMatrix32f=new Float32Array(a),i[r]=s;}return i}getSourceTile(e,t){const i=this.sourceCache._source;let r=e.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return null;this._sourceTileCache[e.key]||(this._sourceTileCache[e.key]=e.scaledTo(r).key);let o=this.sourceCache.getTileByID(this._sourceTileCache[e.key]);if((!o||!o.dem)&&t)for(;r>=i.minzoom&&(!o||!o.dem);)o=this.sourceCache.getTileByID(e.scaledTo(r--).key);return o}anyTilesAfterTime(e=Date.now()){return this._lastTilesetChange>=e}}class Es{constructor(e,t,i){this._meshCache={},this.painter=e,this.sourceCache=new Is(t),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024;}getDEMElevation(e,i,r,o=t.X){var s;if(!(i>=0&&i<o&&r>=0&&r<o))return 0;const a=this.getTerrainData(e),n=null===(s=a.tile)||void 0===s?void 0:s.dem;if(!n)return 0;const l=t.c9([],[i/o*t.X,r/o*t.X],a.u_terrain_matrix),c=[l[0]*n.dim,l[1]*n.dim],h=Math.floor(c[0]),u=Math.floor(c[1]),d=c[0]-h,_=c[1]-u;return n.get(h,u)*(1-d)*(1-_)+n.get(h+1,u)*d*(1-_)+n.get(h,u+1)*(1-d)*_+n.get(h+1,u+1)*d*_}getElevationForLngLatZoom(e,i){if(!t.ca(i,e.wrap()))return 0;const{tileID:r,mercatorX:o,mercatorY:s}=this._getOverscaledTileIDFromLngLatZoom(e,i);return this.getElevation(r,o%t.X,s%t.X,t.X)}getElevation(e,i,r,o=t.X){return this.getDEMElevation(e,i,r,o)*this.exaggeration}getTerrainData(e){if(!this._emptyDemTexture){const e=this.painter.context,i=new t.R({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new v(e,i,e.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new v(e,new t.R({width:1,height:1}),e.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=t.aq([]);}const i=this.sourceCache.getSourceTile(e,!0);if(i&&i.dem&&(!i.demTexture||i.needsTerrainPrepare)){const e=this.painter.context;i.demTexture=this.painter.getTileTexture(i.dem.stride),i.demTexture?i.demTexture.update(i.dem.getPixels(),{premultiply:!1}):i.demTexture=new v(e,i.dem.getPixels(),e.gl.RGBA,{premultiply:!1}),i.demTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),i.needsTerrainPrepare=!1;}const r=i&&i+i.tileID.key+e.key;if(r&&!this._demMatrixCache[r]){const r=this.sourceCache.sourceCache._source.maxzoom;let o=e.canonical.z-i.tileID.canonical.z;e.overscaledZ>e.canonical.z&&(e.canonical.z>=r?o=e.canonical.z-r:t.w("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const s=e.canonical.x-(e.canonical.x>>o<<o),a=e.canonical.y-(e.canonical.y>>o<<o),n=t.cb(new Float64Array(16),[1/(t.X<<o),1/(t.X<<o),0]);t.J(n,n,[s*t.X,a*t.X,0]),this._demMatrixCache[e.key]={matrix:n,coord:e};}return {u_depth:2,u_terrain:3,u_terrain_dim:i&&i.dem&&i.dem.dim||1,u_terrain_matrix:r?this._demMatrixCache[e.key].matrix:this._emptyDemMatrix,u_terrain_unpack:i&&i.dem&&i.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(i&&i.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:i}}getFramebuffer(e){const t=this.painter,i=t.width/devicePixelRatio,r=t.height/devicePixelRatio;return !this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new v(t.context,{width:i,height:r,data:null},t.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(t.context.gl.NEAREST,t.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new v(t.context,{width:i,height:r,data:null},t.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(t.context.gl.NEAREST,t.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=t.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(t.context.createRenderbuffer(t.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===e?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const e=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const i=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let e=0,t=0;e<this._coordsTextureSize;e++)for(let r=0;r<this._coordsTextureSize;r++,t+=4)i[t+0]=255&r,i[t+1]=255&e,i[t+2]=r>>8<<4|e>>8,i[t+3]=0;const r=new t.R({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(i.buffer)),o=new v(e,r,e.gl.RGBA,{premultiply:!1});return o.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._coordsTexture=o,o}pointCoordinate(e){this.painter.maybeDrawDepthAndCoords(!0);const i=new Uint8Array(4),r=this.painter.context,o=r.gl,s=Math.round(e.x*this.painter.pixelRatio/devicePixelRatio),a=Math.round(e.y*this.painter.pixelRatio/devicePixelRatio),n=Math.round(this.painter.height/devicePixelRatio);r.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),o.readPixels(s,n-a-1,1,1,o.RGBA,o.UNSIGNED_BYTE,i),r.bindFramebuffer.set(null);const l=i[0]+(i[2]>>4<<8),c=i[1]+((15&i[2])<<8),h=this.coordsIndex[255-i[3]],u=h&&this.sourceCache.getTileByID(h);if(!u)return null;const d=this._coordsTextureSize,_=(1<<u.tileID.canonical.z)*d;return new t.Y((u.tileID.canonical.x*d+l)/_+u.tileID.wrap,(u.tileID.canonical.y*d+c)/_,this.getElevation(u.tileID,l,c,d))}depthAtPoint(e){const t=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(e.x,this.painter.height/devicePixelRatio-e.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,t),i.bindFramebuffer.set(null),(t[0]/16777216+t[1]/65536+t[2]/256+t[3])/256}getTerrainMesh(e){var i;const r=(null===(i=this.painter.style.projection)||void 0===i?void 0:i.transitionState)>0,o=r&&0===e.canonical.y,s=r&&e.canonical.y===(1<<e.canonical.z)-1,a=`m_${o?"n":""}_${s?"s":""}`;if(this._meshCache[a])return this._meshCache[a];const n=this.painter.context,l=new t.cc,c=new t.aE,h=this.meshSize,u=t.X/h,d=h*h;for(let e=0;e<=h;e++)for(let t=0;t<=h;t++)l.emplaceBack(t*u,e*u,0);for(let e=0;e<d;e+=h+1)for(let t=0;t<h;t++)c.emplaceBack(t+e,h+t+e+1,h+t+e+2),c.emplaceBack(t+e,h+t+e+2,t+e+1);const _=l.length,p=_+(h+1),m=(h+1)*h,f=o?t.b6:0,g=o?0:1,v=s?t.b7:t.X,x=s?0:1;for(let e=0;e<=h;e++)l.emplaceBack(e*u,f,g);for(let e=0;e<=h;e++)l.emplaceBack(e*u,v,x);for(let e=0;e<h;e++)c.emplaceBack(m+e,p+e,p+e+1),c.emplaceBack(m+e,p+e+1,m+e+1),c.emplaceBack(0+e,_+e+1,_+e),c.emplaceBack(0+e,0+e+1,_+e+1);const b=l.length,y=b+2*(h+1);for(const e of [0,1])for(let i=0;i<=h;i++)for(const r of [0,1])l.emplaceBack(e*t.X,i*u,r);for(let e=0;e<2*h;e+=2)c.emplaceBack(b+e,b+e+1,b+e+3),c.emplaceBack(b+e,b+e+3,b+e+2),c.emplaceBack(y+e,y+e+3,y+e+1),c.emplaceBack(y+e,y+e+2,y+e+3);const w=new pt(n.createVertexBuffer(l,Cs.members),n.createIndexBuffer(c),t.aD.simpleSegment(0,0,l.length,c.length));return this._meshCache[a]=w,w}getMeshFrameDelta(e){return 2*Math.PI*t.bo/Math.pow(2,Math.max(e,0))/5}getMinTileElevationForLngLatZoom(e,t){var i;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(e,t);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(e){const t=this.getTerrainData(e).tile,i={minElevation:null,maxElevation:null};return t&&t.dem&&(i.minElevation=t.dem.min*this.exaggeration,i.maxElevation=t.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(e,i){const r=t.Y.fromLngLat(e.wrap()),o=(1<<i)*t.X,s=r.x*o,a=r.y*o,n=Math.floor(s/t.X),l=Math.floor(a/t.X);return {tileID:new t.S(i,0,i,n,l),mercatorX:s,mercatorY:a}}}class Ms{constructor(e,t,i){this._context=e,this._size=t,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0;}destruct(){for(const e of this._objects)e.texture.destroy(),e.fbo.destroy();}_createObject(e){const t=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new v(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),t.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),t.colorAttachment.set(i.texture),{id:e,fbo:t,texture:i,stamp:-1,inUse:!1}}getObjectForId(e){return this._objects[e]}useObject(e){e.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((t=>e.id!==t)),this._recentlyUsed.push(e.id);}stampObject(e){e.stamp=++this._stamp;}getOrCreateFreeObject(){for(const e of this._recentlyUsed)if(!this._objects[e].inUse)return this._objects[e];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const e=this._createObject(this._objects.length);return this._objects.push(e),e}freeObject(e){e.inUse=!1;}freeAllObjects(){for(const e of this._objects)this.freeObject(e);}isFull(){return !(this._objects.length<this._size)&&!1===this._objects.some((e=>!e.inUse))}}const Ss={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0};class Rs{constructor(e,t){this.painter=e,this.terrain=t,this.pool=new Ms(e.context,30,t.sourceCache.tileSize*t.qualityFactor);}destruct(){this.pool.destruct();}getTexture(e){return this.pool.getObjectForId(e.rtt[this._stacks.length-1].id).texture}prepareForRender(e,t){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=e._order.filter((i=>!e._layers[i].isHidden(t))),this._coordsAscending={};for(const t in e.sourceCaches){this._coordsAscending[t]={};const i=e.sourceCaches[t].getVisibleCoordinates();for(const e of i){const i=this.terrain.sourceCache.getTerrainCoords(e);for(const e in i)this._coordsAscending[t][e]||(this._coordsAscending[t][e]=[]),this._coordsAscending[t][e].push(i[e]);}}this._coordsAscendingStr={};for(const t of e._order){const i=e._layers[t],r=i.source;if(Ss[i.type]&&!this._coordsAscendingStr[r]){this._coordsAscendingStr[r]={};for(const e in this._coordsAscending[r])this._coordsAscendingStr[r][e]=this._coordsAscending[r][e].map((e=>e.key)).sort().join();}}for(const e of this._renderableTiles)for(const t in this._coordsAscendingStr){const i=this._coordsAscendingStr[t][e.tileID.key];i&&i!==e.rttCoords[t]&&(e.rtt=[]);}}renderLayer(e,i){if(e.isHidden(this.painter.transform.zoom))return !1;const r=Object.assign(Object.assign({},i),{isRenderingToTexture:!0}),o=e.type,s=this.painter,a=this._renderableLayerIds[this._renderableLayerIds.length-1]===e.id;if(Ss[o]&&(this._prevType&&Ss[this._prevType]||this._stacks.push([]),this._prevType=o,this._stacks[this._stacks.length-1].push(e.id),!a))return !0;if(Ss[this._prevType]||Ss[o]&&a){this._prevType=o;const e=this._stacks.length-1,i=this._stacks[e]||[];for(const o of this._renderableTiles){if(this.pool.isFull()&&(vo(this.painter,this.terrain,this._rttTiles,r),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(o),o.rtt[e]){const t=this.pool.getObjectForId(o.rtt[e].id);if(t.stamp===o.rtt[e].stamp){this.pool.useObject(t);continue}}const a=this.pool.getOrCreateFreeObject();this.pool.useObject(a),this.pool.stampObject(a),o.rtt[e]={id:a.id,stamp:a.stamp},s.context.bindFramebuffer.set(a.fbo.framebuffer),s.context.clear({color:t.b4.transparent,stencil:0}),s.currentStencilSource=void 0;for(let e=0;e<i.length;e++){const t=s.style._layers[i[e]],n=t.source?this._coordsAscending[t.source][o.tileID.key]:[o.tileID];s.context.viewport.set([0,0,a.fbo.width,a.fbo.height]),s._renderTileClippingMasks(t,n,!0),s.renderLayer(s,s.style.sourceCaches[t.source],t,n,r),t.source&&(o.rttCoords[t.source]=this._coordsAscendingStr[t.source][o.tileID.key]);}}return vo(this.painter,this.terrain,this._rttTiles,r),this._rttTiles=[],this.pool.freeAllObjects(),Ss[o]}return !1}}const Ds={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},zs=i,As={hash:!1,interactive:!0,bearingSnap:7,attributionControl:ys,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:t.a.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0},Ls={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class ks{constructor(e,i,r=!1){this.mousedown=e=>{this.startMove(e,n.mousePos(this.element,e)),n.addEventListener(window,"mousemove",this.mousemove),n.addEventListener(window,"mouseup",this.mouseup);},this.mousemove=e=>{this.move(e,n.mousePos(this.element,e));},this.mouseup=e=>{this._rotatePitchHanlder.dragEnd(e),this.offTemp();},this.touchstart=e=>{1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=n.touchPos(this.element,e.targetTouches)[0],this.startMove(e,this._startPos),n.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),n.addEventListener(window,"touchend",this.touchend));},this.touchmove=e=>{1!==e.targetTouches.length?this.reset():(this._lastPos=n.touchPos(this.element,e.targetTouches)[0],this.move(e,this._lastPos));},this.touchend=e=>{0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp();},this.reset=()=>{this._rotatePitchHanlder.reset(),delete this._startPos,delete this._lastPos,this.offTemp();},this._clickTolerance=10,this.element=i;const o=new Wo;this._rotatePitchHanlder=new Uo({clickTolerance:3,move:(e,o)=>{const s=i.getBoundingClientRect(),a=new t.P((s.bottom-s.top)/2,(s.right-s.left)/2);return {bearingDelta:t.c7(new t.P(e.x,o.y),o,a),pitchDelta:r?-.5*(o.y-e.y):void 0}},moveStateManager:o,enable:!0,assignEvents:()=>{}}),this.map=e,n.addEventListener(i,"mousedown",this.mousedown),n.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),n.addEventListener(i,"touchcancel",this.reset);}startMove(e,t){this._rotatePitchHanlder.dragStart(e,t),n.disableDrag();}move(e,t){const i=this.map,{bearingDelta:r,pitchDelta:o}=this._rotatePitchHanlder.dragMove(e,t)||{};r&&i.setBearing(i.getBearing()+r),o&&i.setPitch(i.getPitch()+o);}off(){const e=this.element;n.removeEventListener(e,"mousedown",this.mousedown),n.removeEventListener(e,"touchstart",this.touchstart,{passive:!1}),n.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),n.removeEventListener(window,"touchend",this.touchend),n.removeEventListener(e,"touchcancel",this.reset),this.offTemp();}offTemp(){n.enableDrag(),n.removeEventListener(window,"mousemove",this.mousemove),n.removeEventListener(window,"mouseup",this.mouseup),n.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),n.removeEventListener(window,"touchend",this.touchend);}}let Fs;function Bs(e,i,r){const o=new t.N(e.lng,e.lat);if(e=new t.N(e.lng,e.lat),i){const o=new t.N(e.lng-360,e.lat),s=new t.N(e.lng+360,e.lat),a=r.locationToScreenPoint(e).distSqr(i);r.locationToScreenPoint(o).distSqr(i)<a?e=o:r.locationToScreenPoint(s).distSqr(i)<a&&(e=s);}for(;Math.abs(e.lng-r.center.lng)>180;){const t=r.locationToScreenPoint(e);if(t.x>=0&&t.y>=0&&t.x<=r.width&&t.y<=r.height)break;e.lng>r.center.lng?e.lng-=360:e.lng+=360;}return e.lng!==o.lng&&r.isPointOnMapSurface(r.locationToScreenPoint(e))?e:o}const js={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Os(e,t,i){const r=e.classList;for(const e in js)r.remove(`maplibregl-${i}-anchor-${e}`);r.add(`maplibregl-${i}-anchor-${t}`);}class Ns extends t.E{constructor(e){if(super(),this._onKeyPress=e=>{const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();},this._onMapClick=e=>{const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();},this._update=e=>{var t;if(!this._map)return;const i=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==e?void 0:e.type)||"render"===(null==e?void 0:e.type)&&!i)&&this._map.once("render",this._update),this._lngLat=this._map.transform.renderWorldCopies?Bs(this._lngLat,this._flatPos,this._map.transform):null===(t=this._lngLat)||void 0===t?void 0:t.wrap(),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let r="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?r=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(r=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let o="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?o="rotateX(0deg)":"map"===this._pitchAlignment&&(o=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||e&&"moveend"!==e.type||(this._pos=this._pos.round()),n.setTransform(this._element,`${js[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${o} ${r}`),a.frameAsync(new AbortController).then((()=>{this._updateOpacity(e&&"moveend"===e.type);})).catch((()=>{}));},this._onMove=e=>{if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t;}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new t.k("dragstart"))),this.fire(new t.k("drag")));},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new t.k("dragend")),this._state="inactive";},this._addDragHandler=e=>{this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._offset),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));},this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._subpixelPositioning=e&&e.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,this.setOpacity(),this.setOpacity(null==e?void 0:e.opacity,null==e?void 0:e.opacityWhenCovered),e&&e.element)this._element=e.element,this._offset=t.P.convert(e&&e.offset||[0,0]);else {this._defaultMarker=!0,this._element=n.create("div");const i=n.createNS("http://www.w3.org/2000/svg","svg"),r=41,o=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${r}px`),i.setAttributeNS(null,"width",`${o}px`),i.setAttributeNS(null,"viewBox",`0 0 ${o} ${r}`);const s=n.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"stroke","none"),s.setAttributeNS(null,"stroke-width","1"),s.setAttributeNS(null,"fill","none"),s.setAttributeNS(null,"fill-rule","evenodd");const a=n.createNS("http://www.w3.org/2000/svg","g");a.setAttributeNS(null,"fill-rule","nonzero");const l=n.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const c=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const e of c){const t=n.createNS("http://www.w3.org/2000/svg","ellipse");t.setAttributeNS(null,"opacity","0.04"),t.setAttributeNS(null,"cx","10.5"),t.setAttributeNS(null,"cy","5.80029008"),t.setAttributeNS(null,"rx",e.rx),t.setAttributeNS(null,"ry",e.ry),l.appendChild(t);}const h=n.createNS("http://www.w3.org/2000/svg","g");h.setAttributeNS(null,"fill",this._color);const u=n.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),h.appendChild(u);const d=n.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=n.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const p=n.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const m=n.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=n.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=n.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),m.appendChild(f),m.appendChild(g),a.appendChild(l),a.appendChild(h),a.appendChild(d),a.appendChild(p),a.appendChild(m),i.appendChild(a),i.setAttributeNS(null,"height",r*this._scale+"px"),i.setAttributeNS(null,"width",o*this._scale+"px"),this._element.appendChild(i),this._offset=t.P.convert(e&&e.offset||[0,-14]);}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault();})),this._element.addEventListener("mousedown",(e=>{e.preventDefault();})),Os(this._element,this._anchor,"marker"),e&&e.className)for(const t of e.className.split(" "))this._element.classList.add(t);this._popup=null;}addTo(e){return this.remove(),this._map=e,this._element.setAttribute("aria-label",e._getUIString("Marker.Title")),e.getCanvasContainer().appendChild(this._element),e.on("move",this._update),e.on("moveend",this._update),e.on("terrain",this._update),e.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),n.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.N.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-38.1],"bottom-left":[r,-1*(t-i+r)],"bottom-right":[-r,-1*(t-i+r)],left:[i,-1*(t-i)],right:[-13.5,-1*(t-i)]}:this._offset;}this._popup=e,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}setSubpixelPositioning(e){return this._subpixelPositioning=e,this}getPopup(){return this._popup}togglePopup(){const e=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:e?(e.isOpen()?e.remove():(e.setLngLat(this._lngLat),e.addTo(this._map)),this):this}_updateOpacity(e=!1){var i,r;if(!(null===(i=this._map)||void 0===i?void 0:i.terrain)){const e=this._map.transform.isLocationOccluded(this._lngLat)?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==e&&(this._element.style.opacity=e))}if(e)this._opacityTimeout=null;else {if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null;}),100);}const o=this._map,s=o.terrain.depthAtPoint(this._pos),a=o.terrain.getElevationForLngLatZoom(this._lngLat,o.transform.tileZoom);if(o.transform.lngLatToCameraDepth(this._lngLat,a)-s<.006)return void(this._element.style.opacity=this._opacity);const n=-this._offset.y/o.transform.pixelsPerMeter,l=Math.sin(o.getPitch()*Math.PI/180)*n,c=o.terrain.depthAtPoint(new t.P(this._pos.x,this._pos.y-this._offset.y)),h=o.transform.lngLatToCameraDepth(this._lngLat,a+l)-c>.006;(null===(r=this._popup)||void 0===r?void 0:r.isOpen())&&h&&this._popup.remove(),this._element.style.opacity=h?this._opacityWhenCovered:this._opacity;}getOffset(){return this._offset}setOffset(e){return this._offset=t.P.convert(e),this._update(),this}addClassName(e){this._element.classList.add(e);}removeClassName(e){this._element.classList.remove(e);}toggleClassName(e){return this._element.classList.toggle(e)}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(e,t){return void 0===e&&void 0===t&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==e&&(this._opacity=e),void 0!==t&&(this._opacityWhenCovered=t),this._map&&this._updateOpacity(!0),this}}const Zs={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let Gs=0,Us=!1;const Vs={maxWidth:100,unit:"metric"};function qs(e,t,i){const r=i&&i.maxWidth||100,o=e._container.clientHeight/2,s=e._container.clientWidth/2,a=e.unproject([s-r/2,o]),n=e.unproject([s+r/2,o]),l=Math.round(e.project(n).x-e.project(a).x),c=Math.min(r,l,e._container.clientWidth),h=a.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?Hs(t,c,i/5280,e._getUIString("ScaleControl.Miles")):Hs(t,c,i,e._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?Hs(t,c,h/1852,e._getUIString("ScaleControl.NauticalMiles")):h>=1e3?Hs(t,c,h/1e3,e._getUIString("ScaleControl.Kilometers")):Hs(t,c,h,e._getUIString("ScaleControl.Meters"));}function Hs(e,t,i,r){const o=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i);e.style.width=t*(o/i)+"px",e.innerHTML=`${o}&nbsp;${r}`;}const Ws={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1},Xs=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function $s(e){if(e){if("number"==typeof e){const i=Math.round(Math.abs(e)/Math.SQRT2);return {center:new t.P(0,0),top:new t.P(0,e),"top-left":new t.P(i,i),"top-right":new t.P(-i,i),bottom:new t.P(0,-e),"bottom-left":new t.P(i,-i),"bottom-right":new t.P(-i,-i),left:new t.P(e,0),right:new t.P(-e,0)}}if(e instanceof t.P||Array.isArray(e)){const i=t.P.convert(e);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:t.P.convert(e.center||[0,0]),top:t.P.convert(e.top||[0,0]),"top-left":t.P.convert(e["top-left"]||[0,0]),"top-right":t.P.convert(e["top-right"]||[0,0]),bottom:t.P.convert(e.bottom||[0,0]),"bottom-left":t.P.convert(e["bottom-left"]||[0,0]),"bottom-right":t.P.convert(e["bottom-right"]||[0,0]),left:t.P.convert(e.left||[0,0]),right:t.P.convert(e.right||[0,0])}}return $s(new t.P(0,0))}const Ks=i;e.AJAXError=t.cg,e.Event=t.k,e.Evented=t.E,e.LngLat=t.N,e.MercatorCoordinate=t.Y,e.Point=t.P,e.addProtocol=t.ch,e.config=t.a,e.removeProtocol=t.ci,e.AttributionControl=ws,e.BoxZoomHandler=jo,e.CanvasSource=J,e.CooperativeGesturesHandler=ms,e.DoubleClickZoomHandler=cs,e.DragPanHandler=ds,e.DragRotateHandler=_s,e.EdgeInsets=Pt,e.FullscreenControl=class extends t.E{constructor(e={}){super(),this._onFullscreenChange=()=>{var e;let t=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(e=null==t?void 0:t.shadowRoot)||void 0===e?void 0:e.fullscreenElement;)t=t.shadowRoot.fullscreenElement;t===this._container!==this._fullscreen&&this._handleFullscreenChange();},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen();},this._fullscreen=!1,e&&e.container&&(e.container instanceof HTMLElement?this._container=e.container:t.w("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange");}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){n.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange);}_setupUI(){const e=this._fullscreenButton=n.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);n.create("span","maplibregl-ctrl-icon",e).setAttribute("aria-hidden","true"),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.title=e;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new t.k("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new t.k("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable());}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen();}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen();}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize();}},e.GeoJSONSource=$,e.GeolocateControl=class extends t.E{constructor(e){super(),this._onSuccess=e=>{if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new t.k("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "BACKGROUND":case "BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new t.k("geolocate",e)),this._finish();}},this._updateCamera=e=>{const i=new t.N(e.coords.longitude,e.coords.latitude),r=e.coords.accuracy,o=this._map.getBearing(),s=t.e({bearing:o},this.options.fitBoundsOptions),a=V.fromLngLat(i,r);this._map.fitBounds(a,s,{geolocateSource:!0});},this._updateMarker=e=>{if(e){const i=new t.N(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=e.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();},this._onZoom=()=>{this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();},this._onError=e=>{if(this._map){if(this.options.trackUserLocation)if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===e.code&&Us)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new t.k("error",e)),this._finish();}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=n.create("button","maplibregl-ctrl-geolocate",this._container),n.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0);},this._finishSetupUI=e=>{if(this._map){if(!1===e){t.w("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=n.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new Ns({element:this._dotElement}),this._circleElement=n.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Ns({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||e.originalEvent&&"resize"===e.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new t.k("trackuserlocationend")),this.fire(new t.k("userlocationlostfocus")));}));}},this.options=t.e({},Zs,e);}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return t._(this,arguments,void 0,(function*(e=!1){if(void 0!==Fs&&!e)return Fs;if(void 0===window.navigator.permissions)return Fs=!!window.navigator.geolocation,Fs;try{const e=yield window.navigator.permissions.query({name:"geolocation"});Fs="denied"!==e.state;}catch(e){Fs=!!window.navigator.geolocation;}return Fs}))}().then((e=>this._finishSetupUI(e))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),n.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,Gs=0,Us=!1;}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case "WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case "ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadius(){const e=this._map.getBounds(),t=e.getSouthEast(),i=e.getNorthEast(),r=t.distanceTo(i),o=Math.ceil(this._accuracy/(r/this._map._container.clientHeight)*2);this._circleElement.style.width=`${o}px`,this._circleElement.style.height=`${o}px`;}trigger(){if(!this._setup)return t.w("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case "OFF":this._watchState="WAITING_ACTIVE",this.fire(new t.k("trackuserlocationstart"));break;case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":case "BACKGROUND_ERROR":Gs--,Us=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new t.k("trackuserlocationend"));break;case "BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new t.k("trackuserlocationstart")),this.fire(new t.k("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case "WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),Gs++,Gs>1?(e={maximumAge:6e5,timeout:0},Us=!0):(e=this.options.positionOptions,Us=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e);}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},e.GlobeControl=class{constructor(){this._toggleProjection=()=>{var e;const t=null===(e=this._map.getProjection())||void 0===e?void 0:e.type;this._map.setProjection("mercator"!==t&&t?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon();},this._updateGlobeIcon=()=>{var e;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(e=this._map.getProjection())||void 0===e?void 0:e.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"));};}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=n.create("button","maplibregl-ctrl-globe",this._container),n.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){n.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0;}},e.Hash=wo,e.ImageSource=K,e.KeyboardHandler=ss,e.LngLatBounds=V,e.LogoControl=Ts,e.Map=class extends bs{constructor(e){var i,r;t.cd.mark(t.ce.create);const o=Object.assign(Object.assign(Object.assign({},As),e),{canvasContextAttributes:Object.assign(Object.assign({},As.canvasContextAttributes),e.canvasContextAttributes)});if(null!=o.minZoom&&null!=o.maxZoom&&o.minZoom>o.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=o.minPitch&&null!=o.maxPitch&&o.minPitch>o.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=o.minPitch&&o.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=o.maxPitch&&o.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const s=new Dt,a=new kt;if(void 0!==o.minZoom&&s.setMinZoom(o.minZoom),void 0!==o.maxZoom&&s.setMaxZoom(o.maxZoom),void 0!==o.minPitch&&s.setMinPitch(o.minPitch),void 0!==o.maxPitch&&s.setMaxPitch(o.maxPitch),void 0!==o.renderWorldCopies&&s.setRenderWorldCopies(o.renderWorldCopies),super(s,a,{bearingSnap:o.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new Ps,this._controls=[],this._mapId=t.a1(),this._contextLost=e=>{e.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new t.k("webglcontextlost",{originalEvent:e}));},this._contextRestored=e=>{this._setupPainter(),this.resize(),this._update(),this.fire(new t.k("webglcontextrestored",{originalEvent:e}));},this._onMapScroll=e=>{if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update();},this._interactive=o.interactive,this._maxTileCacheSize=o.maxTileCacheSize,this._maxTileCacheZoomLevels=o.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},o.canvasContextAttributes),this._trackResize=!0===o.trackResize,this._bearingSnap=o.bearingSnap,this._centerClampedToGround=o.centerClampedToGround,this._refreshExpiredTiles=!0===o.refreshExpiredTiles,this._fadeDuration=o.fadeDuration,this._crossSourceCollisions=!0===o.crossSourceCollisions,this._collectResourceTiming=!0===o.collectResourceTiming,this._locale=Object.assign(Object.assign({},Ds),o.locale),this._clickTolerance=o.clickTolerance,this._overridePixelRatio=o.pixelRatio,this._maxCanvasSize=o.maxCanvasSize,this.transformCameraUpdate=o.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===o.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=p.addThrottleControl((()=>this.isMoving())),this._requestManager=new m(o.transformRequest),"string"==typeof o.container){if(this._container=document.getElementById(o.container),!this._container)throw new Error(`Container '${o.container}' not found.`)}else {if(!(o.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=o.container;}if(o.maxBounds&&this.setMaxBounds(o.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0);})),this.once("idle",(()=>{this._idleTriggered=!0;})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let e=!1;const t=yo((e=>{this._trackResize&&!this._removed&&(this.resize(e),this.redraw());}),50);this._resizeObserver=new ResizeObserver((i=>{e?t(i):e=!0;})),this._resizeObserver.observe(this._container);}this.handlers=new xs(this,o),this._hash=o.hash&&new wo("string"==typeof o.hash&&o.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:o.center,elevation:o.elevation,zoom:o.zoom,bearing:o.bearing,pitch:o.pitch,roll:o.roll}),o.bounds&&(this.resize(),this.fitBounds(o.bounds,t.e({},o.fitBoundsOptions,{duration:0}))));const n="string"==typeof o.style||!("globe"===(null===(r=null===(i=o.style)||void 0===i?void 0:i.projection)||void 0===r?void 0:r.type));this.resize(null,n),this._localIdeographFontFamily=o.localIdeographFontFamily,this._validateStyle=o.validateStyle,o.style&&this.setStyle(o.style,{localIdeographFontFamily:o.localIdeographFontFamily}),o.attributionControl&&this.addControl(new ws("boolean"==typeof o.attributionControl?void 0:o.attributionControl)),o.maplibreLogo&&this.addControl(new Ts,o.logoPosition),this.on("style.load",(()=>{if(n||this._resizeTransform(),this.transform.unmodified){const e=t.M(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(e);}})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new t.k(`${e.dataType}data`,e));})),this.on("dataloading",(e=>{this.fire(new t.k(`${e.dataType}dataloading`,e));})),this.on("dataabort",(e=>{this.fire(new t.k("sourcedataabort",e));}));}_getMapId(){return this._mapId}addControl(e,i){if(void 0===i&&(i=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new t.j(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const r=e.onAdd(this);this._controls.push(e);const o=this._controlPositions[i];return -1!==i.indexOf("bottom")?o.insertBefore(r,o.firstChild):o.appendChild(r),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new t.j(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(e);return i>-1&&this._controls.splice(i,1),e.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}calculateCameraOptionsFromTo(e,t,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(e,t,i,r)}resize(e,i=!0){const[r,o]=this._containerDimensions(),s=this._getClampedPixelRatio(r,o);if(this._resizeCanvas(r,o,s),this.painter.resize(r,o,s),this.painter.overLimit()){const e=this.painter.context.gl;this._maxCanvasSize=[e.drawingBufferWidth,e.drawingBufferHeight];const t=this._getClampedPixelRatio(r,o);this._resizeCanvas(r,o,t),this.painter.resize(r,o,t);}this._resizeTransform(i);const a=!this._moving;return a&&(this.stop(),this.fire(new t.k("movestart",e)).fire(new t.k("move",e))),this.fire(new t.k("resize",e)),a&&this.fire(new t.k("moveend",e)),this}_resizeTransform(e=!0){var t;const[i,r]=this._containerDimensions();this.transform.resize(i,r,e),null===(t=this._requestedCameraState)||void 0===t||t.resize(i,r,e);}_getClampedPixelRatio(e,t){const{0:i,1:r}=this._maxCanvasSize,o=this.getPixelRatio(),s=e*o,a=t*o;return Math.min(s>i?i/s:1,a>r?r/a:1)*o}getPixelRatio(){var e;return null!==(e=this._overridePixelRatio)&&void 0!==e?e:devicePixelRatio}setPixelRatio(e){this._overridePixelRatio=e,this.resize();}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds(V.convert(e)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom)return this.transform.setMinZoom(e),this._update(),this.getZoom()<e&&this.setZoom(e),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom)return this.transform.setMaxZoom(e),this._update(),this.getZoom()>e&&this.setZoom(e),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.setMinPitch(e),this._update(),this.getPitch()<e&&this.setPitch(e),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?60:e)>180)throw new Error("maxPitch must be less than or equal to 180");if(e>=this.transform.minPitch)return this.transform.setMaxPitch(e),this._update(),this.getPitch()>e&&this.setPitch(e),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.setRenderWorldCopies(e),this._update()}project(e){return this.transform.locationToScreenPoint(t.N.convert(e),this.style&&this.terrain)}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this.terrain)}isMoving(){var e;return this._moving||(null===(e=this.handlers)||void 0===e?void 0:e.isMoving())}isZooming(){var e;return this._zooming||(null===(e=this.handlers)||void 0===e?void 0:e.isZooming())}isRotating(){var e;return this._rotating||(null===(e=this.handlers)||void 0===e?void 0:e.isRotating())}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let r=!1;const o=o=>{const s=t.filter((e=>this.getLayer(e))),a=0!==s.length?this.queryRenderedFeatures(o.point,{layers:s}):[];a.length?r||(r=!0,i.call(this,new zo(e,this,o.originalEvent,{features:a}))):r=!1;};return {layers:t,listener:i,delegates:{mousemove:o,mouseout:()=>{r=!1;}}}}if("mouseleave"===e||"mouseout"===e){let r=!1;const o=o=>{const s=t.filter((e=>this.getLayer(e)));(0!==s.length?this.queryRenderedFeatures(o.point,{layers:s}):[]).length?r=!0:r&&(r=!1,i.call(this,new zo(e,this,o.originalEvent)));},s=t=>{r&&(r=!1,i.call(this,new zo(e,this,t.originalEvent)));};return {layers:t,listener:i,delegates:{mousemove:o,mouseout:s}}}{const r=e=>{const r=t.filter((e=>this.getLayer(e))),o=0!==r.length?this.queryRenderedFeatures(e.point,{layers:r}):[];o.length&&(e.features=o,i.call(this,e),delete e.features);};return {layers:t,listener:i,delegates:{[e]:r}}}}_saveDelegatedListener(e,t){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(t);}_removeDelegatedListener(e,t,i){if(!this._delegatedListeners||!this._delegatedListeners[e])return;const r=this._delegatedListeners[e];for(let e=0;e<r.length;e++){const o=r[e];if(o.listener===i&&o.layers.length===t.length&&o.layers.every((e=>t.includes(e)))){for(const e in o.delegates)this.off(e,o.delegates[e]);return void r.splice(e,1)}}}on(e,t,i){if(void 0===i)return super.on(e,t);const r="string"==typeof t?[t]:t,o=this._createDelegatedListener(e,r,i);this._saveDelegatedListener(e,o);for(const e in o.delegates)this.on(e,o.delegates[e]);return {unsubscribe:()=>{this._removeDelegatedListener(e,r,i);}}}once(e,t,i){if(void 0===i)return super.once(e,t);const r="string"==typeof t?[t]:t,o=this._createDelegatedListener(e,r,i);for(const t in o.delegates){const s=o.delegates[t];o.delegates[t]=(...t)=>{this._removeDelegatedListener(e,r,i),s(...t);};}this._saveDelegatedListener(e,o);for(const e in o.delegates)this.once(e,o.delegates[e]);return this}off(e,t,i){return void 0===i?super.off(e,t):(this._removeDelegatedListener(e,"string"==typeof t?[t]:t,i),this)}queryRenderedFeatures(e,i){if(!this.style)return [];let r;const o=e instanceof t.P||Array.isArray(e),s=o?e:[[0,0],[this.transform.width,this.transform.height]];if(i=i||(o?{}:e)||{},s instanceof t.P||"number"==typeof s[0])r=[t.P.convert(s)];else {const e=t.P.convert(s[0]),i=t.P.convert(s[1]);r=[e,new t.P(i.x,e.y),i,new t.P(e.x,i.y),e];}return this.style.queryRenderedFeatures(r,i,this.transform)}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(e,i){return !1!==(i=t.e({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&e?(this._diffStyle(e,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(e,i))}setTransformRequest(e){return this._requestManager.setTransformRequest(e),this}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){var i,r;if(t.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(e,t)));const o=this.style&&t.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!e)),e?(this.style=new gi(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e,t,o):this.style.loadJSON(e,t,o),this):(null===(r=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===r||r.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new gi(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(e,i){if("string"==typeof e){const r=this._requestManager.transformRequest(e,"Style");t.h(r,new AbortController).then((e=>{this._updateDiff(e.data,i);})).catch((e=>{e&&this.fire(new t.j(e));}));}else "object"==typeof e&&this._updateDiff(e,i);}_updateDiff(e,i){try{this.style.setState(e,i)&&this._update(!0);}catch(r){t.w(`Unable to perform style diff: ${r.message||r.error||r}.  Rebuilding the style from scratch.`),this._updateStyle(e,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():t.w("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){const i=this.style&&this.style.sourceCaches[e];if(void 0!==i)return i.loaded();this.fire(new t.j(new Error(`There is no source with ID '${e}'`)));}setTerrain(e){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),e){const i=this.style.sourceCaches[e.source];if(!i)throw new Error(`cannot load terrain, because there exists no source with ID: ${e.source}`);null===this.terrain&&i.reload();for(const i in this.style._layers){const r=this.style._layers[i];"hillshade"===r.type&&r.source===e.source&&t.w("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.");}this.terrain=new Es(this.painter,i,e),this.painter.renderToTexture=new Rs(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=t=>{"style"===t.dataType?this.terrain.sourceCache.freeRtt():"source"===t.dataType&&t.tile&&(t.sourceId!==e.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),this.terrain.sourceCache.freeRtt(t.tile.tileID));},this.style.on("data",this._terrainDataCallback);}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new t.k("terrain",{terrain:e})),this}getTerrain(){var e,t;return null!==(t=null===(e=this.terrain)||void 0===e?void 0:e.options)&&void 0!==t?t:null}areTilesLoaded(){const e=this.style&&this.style.sourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}removeSource(e){return this.style.removeSource(e),this._update(!0)}getSource(e){return this.style.getSource(e)}addImage(e,i,r={}){const{pixelRatio:o=1,sdf:s=!1,stretchX:n,stretchY:l,content:c,textFitWidth:h,textFitHeight:u}=r;if(this._lazyInitEmptyStyle(),!(i instanceof HTMLImageElement||t.b(i))){if(void 0===i.width||void 0===i.height)return this.fire(new t.j(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:r,height:a,data:d}=i,_=i;return this.style.addImage(e,{data:new t.R({width:r,height:a},new Uint8Array(d)),pixelRatio:o,stretchX:n,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:s,version:0,userImage:_}),_.onAdd&&_.onAdd(this,e),this}}{const{width:r,height:d,data:_}=a.getImageData(i);this.style.addImage(e,{data:new t.R({width:r,height:d},_),pixelRatio:o,stretchX:n,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:s,version:0});}}updateImage(e,i){const r=this.style.getImage(e);if(!r)return this.fire(new t.j(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const o=i instanceof HTMLImageElement||t.b(i)?a.getImageData(i):i,{width:s,height:n,data:l}=o;if(void 0===s||void 0===n)return this.fire(new t.j(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(s!==r.data.width||n!==r.data.height)return this.fire(new t.j(new Error("The width and height of the updated image must be that same as the previous version of the image")));const c=!(i instanceof HTMLImageElement||t.b(i));return r.data.replace(l,c),this.style.updateImage(e,r),this}getImage(e){return this.style.getImage(e)}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new t.j(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(e){return p.getImage(this._requestManager.transformRequest(e,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,r={}){return this.style.setPaintProperty(e,t,i,r),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,r={}){return this.style.setLayoutProperty(e,t,i,r),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setGlyphs(e,t={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(e,t),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(e,t,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(e,t,i,(e=>{e||this._update(!0);})),this}removeSprite(e){return this._lazyInitEmptyStyle(),this.style.removeSprite(e),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSprite(e,t,(e=>{e||this._update(!0);})),this}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setSky(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSky(e,t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let e=0,t=0;return this._container&&(e=this._container.clientWidth||400,t=this._container.clientHeight||300),[e,t]}_setupContainer(){const e=this._container;e.classList.add("maplibregl-map");const t=this._canvasContainer=n.create("div","maplibregl-canvas-container",e);this._interactive&&t.classList.add("maplibregl-interactive"),this._canvas=n.create("canvas","maplibregl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const o=this._controlContainer=n.create("div","maplibregl-control-container",e),s=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{s[e]=n.create("div",`maplibregl-ctrl-${e} `,o);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(e,t,i){this._canvas.width=Math.floor(i*e),this._canvas.height=Math.floor(i*t),this._canvas.style.width=`${e}px`,this._canvas.style.height=`${t}px`;}_setupPainter(){const e=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let t=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{t={requestedAttributes:e},i&&(t.statusMessage=i.statusMessage,t.type=i.type);}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,e):this._canvas.getContext("webgl2",e)||this._canvas.getContext("webgl",e),!i){const e="Failed to initialize WebGL";throw t?(t.message=e,new Error(JSON.stringify(t))):new Error(e)}this.painter=new bo(i,this.transform),l.testSupport(i);}migrateProjection(e,i){super.migrateProjection(e,i),this.painter.transform=e,this.fire(new t.k("projectiontransition",{newProjection:this.style.projection.name}));}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_render(e){var i,r,o,s,n;const l=this._idleTriggered?this._fadeDuration:0,c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let h=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,i=a.now();this.style.zoomHistory.update(e,i);const r=new t.z(e,{now:i,fadeDuration:l,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),o=r.crossFadingFactor();1===o&&o===this._crossFadingFactor||(h=!0,this._crossFadingFactor=o),this.style.update(r);}const u=(null===(r=this.style.projection)||void 0===r?void 0:r.transitionState)>0!==c;null===(o=this.style.projection)||void 0===o||o.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(s=this.style.projection)||void 0===s?void 0:s.transitionState,null===(n=this.style.projection)||void 0===n?void 0:n.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||u)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,l,this._crossSourceCollisions,u),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:l,showPadding:this.showPadding}),this.fire(new t.k("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,t.cd.mark(t.ce.load),this.fire(new t.k("load"))),this.style&&(this.style.hasTransitions()||h)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const d=this._sourcesDirty||this._styleDirty||this._placementDirty;return d||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new t.k("idle")),!this._loaded||this._fullyLoaded||d||(this._fullyLoaded=!0,t.cd.mark(t.ce.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var e;this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),p.removeThrottleControl(this._imageQueueHandle),null===(e=this._resizeObserver)||void 0===e||e.disconnect();const i=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==i?void 0:i.loseContext)&&i.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),n.remove(this._canvasContainer),n.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),t.cd.clearMetrics(),this._removed=!0,this.fire(new t.k("remove"));}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,a.frame(this._frameRequest,(e=>{t.cd.frame(e),this._frameRequest=null;try{this._render(e);}catch(e){if(!t.cf(e)&&!function(e){return e.message===Or}(e))throw e}}),(()=>{})));}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update());}get showPadding(){return !!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update());}get repaint(){return !!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(e){this._vertices=e,this._update();}get version(){return zs}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(e){return this._lazyInitEmptyStyle(),this.style.setProjection(e),this._update(!0)}},e.MapMouseEvent=zo,e.MapTouchEvent=Ao,e.MapWheelEvent=Lo,e.Marker=Ns,e.NavigationControl=class{constructor(e){this._updateZoomButtons=()=>{const e=this._map.getZoom(),t=e===this._map.getMaxZoom(),i=e===this._map.getMinZoom();this._zoomInButton.disabled=t,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",t.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`;},this._setButtonTitle=(e,t)=>{const i=this._map._getUIString(`NavigationControl.${t}`);e.title=i,e.setAttribute("aria-label",i);},this.options=t.e({},Ls,e),this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(e=>this._map.zoomIn({},{originalEvent:e}))),n.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(e=>this._map.zoomOut({},{originalEvent:e}))),n.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(e=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:e}):this._map.resetNorth({},{originalEvent:e});})),this._compassIcon=n.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"));}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new ks(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){n.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(e,t){const i=n.create("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}},e.Popup=class extends t.E{constructor(e){super(),this.remove=()=>(this._content&&n.remove(this._content),this._container&&(n.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new t.k("close"))),this),this._onMouseUp=e=>{this._update(e.point);},this._onMouseMove=e=>{this._update(e.point);},this._onDrag=e=>{this._update(e.point);},this._update=e=>{var t;if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=n.create("div","maplibregl-popup",this._map.getContainer()),this._tip=n.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const e of this.options.className.split(" "))this._container.classList.add(e);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer");}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=this._map.transform.renderWorldCopies&&!this._trackPointer?Bs(this._lngLat,this._flatPos,this._map.transform):null===(t=this._lngLat)||void 0===t?void 0:t.wrap(),this._trackPointer&&!e)return;const i=this._flatPos=this._pos=this._trackPointer&&e?e:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&e?e:this._map.transform.locationToScreenPoint(this._lngLat));let r=this.options.anchor;const o=$s(this.options.offset);if(!r){const e=this._container.offsetWidth,t=this._container.offsetHeight;let s;s=i.y+o.bottom.y<t?["top"]:i.y>this._map.transform.height-t?["bottom"]:[],i.x<e/2?s.push("left"):i.x>this._map.transform.width-e/2&&s.push("right"),r=0===s.length?"bottom":s.join("-");}let s=i.add(o[r]);this.options.subpixelPositioning||(s=s.round()),n.setTransform(this._container,`${js[r]} translate(${s.x}px,${s.y}px)`),Os(this._container,r,"popup");},this._onClose=()=>{this.remove();},this.options=t.e(Object.create(Ws),e);}addTo(e){return this._map&&this.remove(),this._map=e,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new t.k("open")),this}isOpen(){return !!this._map}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.N.convert(e),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(e){return this.setDOMContent(document.createTextNode(e))}setHTML(e){const t=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=e;r=i.firstChild,r;)t.appendChild(r);return this.setDOMContent(t)}getMaxWidth(){var e;return null===(e=this._container)||void 0===e?void 0:e.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=n.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(e),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(e){return this._container&&this._container.classList.add(e),this}removeClassName(e){return this._container&&this._container.classList.remove(e),this}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){if(this._container)return this._container.classList.toggle(e)}setSubpixelPositioning(e){this.options.subpixelPositioning=e;}_createCloseButton(){this.options.closeButton&&(this._closeButton=n.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(Xs);e&&e.focus();}},e.RasterDEMTileSource=X,e.RasterTileSource=W,e.ScaleControl=class{constructor(e){this._onMove=()=>{qs(this._map,this._container,this.options);},this.setUnit=e=>{this.options.unit=e,qs(this._map,this._container,this.options);},this.options=Object.assign(Object.assign({},Vs),e);}getDefaultPosition(){return "bottom-left"}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-scale",e.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){n.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}},e.ScrollZoomHandler=ls,e.Style=gi,e.TerrainControl=class{constructor(e){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon();},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"));},this.options=e;}onAdd(e){return this._map=e,this._container=n.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=n.create("button","maplibregl-ctrl-terrain",this._container),n.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){n.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0;}},e.TwoFingersTouchPitchHandler=rs,e.TwoFingersTouchRotateHandler=ts,e.TwoFingersTouchZoomHandler=Qo,e.TwoFingersTouchZoomRotateHandler=ps,e.VectorTileSource=H,e.VideoSource=Y,e.addSourceType=(e,i)=>t._(void 0,void 0,void 0,(function*(){if(ee(e))throw new Error(`A source type called "${e}" already exists.`);((e,t)=>{Q[e]=t;})(e,i);})),e.clearPrewarmedResources=function(){const e=L;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(D),L=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},e.createTileMesh=Ht,e.getMaxParallelImageRequests=function(){return t.a.MAX_PARALLEL_IMAGE_REQUESTS},e.getRTLTextPluginStatus=function(){return oe().getRTLTextPluginStatus()},e.getVersion=function(){return Ks},e.getWorkerCount=function(){return z.workerCount},e.getWorkerUrl=function(){return t.a.WORKER_URL},e.importScriptInWorkers=function(e){return j().broadcast("IS",e)},e.prewarm=function(){F().acquire(D);},e.setMaxParallelImageRequests=function(e){t.a.MAX_PARALLEL_IMAGE_REQUESTS=e;},e.setRTLTextPlugin=function(e,t){return oe().setRTLTextPlugin(e,t)},e.setWorkerCount=function(e){z.workerCount=e;},e.setWorkerUrl=function(e){t.a.WORKER_URL=e;};}));

//
// Our custom intro provides a specialized "define()" function, called by the
// AMD modules below, that sets up the worker blob URL and then executes the
// main module, storing its exported value as 'maplibregl'


var maplibregl$1 = maplibregl;

return maplibregl$1;

}));
//# sourceMappingURL=maplibre-gl.js.map
