# Migrate from Streamlit to Panel

These guides addresses how to migrate from Streamlit to Panel.

![Panel App Example](../../_static/images/panel_layout_example.png)

These guides can also be used as:

- An alternative *Introduction to Panel* if you are already familiar with Streamlit.
- A means of comparing Streamlit and Panel on a more detailed level, without going into some of the unique functionality that Panel provides.

---

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`rocket;2.5em;sd-mr-1 sd-animate-grow50` Serve Apps
:link: get_started
:link-type: doc

How to convert a *Hello World* application from Streamlit to Panel and serve it
:::

:::{grid-item-card} {octicon}`device-desktop;2.5em;sd-mr-1 sd-animate-grow50` Display Objects
:link: panes
:link-type: doc

How to display content with panes
:::

:::{grid-item-card} {octicon}`project;2.5em;sd-mr-1 sd-animate-grow50` Organize Components
:link: layouts
:link-type: doc

How to organize components with layouts
:::

:::{grid-item-card} {octicon}`person;2.5em;sd-mr-1 sd-animate-grow50` Accept User Input
:link: widgets
:link-type: doc

How to accept user input with widgets
:::

:::{grid-item-card} {octicon}`browser;2.5em;sd-mr-1 sd-animate-grow50` Organize and Style
:link: templates
:link-type: doc

How to organize and style with templates
:::

:::{grid-item-card} {octicon}`issue-draft;2.5em;sd-mr-1 sd-animate-grow50` Show Activity
:link: activity
:link-type: doc

How to show activity with indicators
:::

:::{grid-item-card} {octicon}`zap;2.5em;sd-mr-1 sd-animate-grow50` Add Interactivity
:link: interactivity
:link-type: doc

How to add interactivity with `pn.bind`.
:::

:::{grid-item-card} {octicon}`versions;2.5em;sd-mr-1 sd-animate-grow50` Improve Performance
:link: caching
:link-type: doc

How to improve the performance with caching
:::

:::{grid-item-card} {octicon}`list-ordered;2.5em;sd-mr-1 sd-animate-grow50` Session State
:link: session_state
:link-type: doc

How to store state for a session
:::

:::{grid-item-card} {octicon}`dependabot;2.5em;sd-mr-1 sd-animate-grow50` Chat Interfaces
:link: chat
:link-type: doc

How to create create chat interfaces
:::

:::{grid-item-card} {octicon}`stack;2.5em;sd-mr-1 sd-animate-grow50` Multi Page Apps
:link: multipage_apps
:link-type: doc

How to create multi page apps
:::

::::

We hope you will have fun with the Panel framework. If you have usage questions you can post them
on [Discourse](https://discourse.holoviz.org/). If you experience issues or have requests for
features please post them on [Github](https://github.com/holoviz/panel).

If you want to support Panel please

- give a ⭐ on [Github](https://github.com/holoviz/panel) or
- donate to [HoloViz](https://holoviz.org/) via [Numfocus](https://numfocus.org/support#donate)

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

get_started
panes
layouts
widgets
templates
activity
interactivity
caching
session_state
multipage_apps
```
