(() => {
  var __defProp = Object.defineProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[Object.keys(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };

  // ../schema/src/lib/batches/base-table-batch-aggregator.ts
  var DEFAULT_ROW_COUNT, RowTableBatchAggregator;
  var init_base_table_batch_aggregator = __esm({
    "../schema/src/lib/batches/base-table-batch-aggregator.ts"() {
      DEFAULT_ROW_COUNT = 100;
      RowTableBatchAggregator = class {
        constructor(schema, options) {
          this.length = 0;
          this.rows = null;
          this.cursor = 0;
          this._headers = [];
          this.options = options;
          this.schema = schema;
          if (!Array.isArray(schema)) {
            this._headers = [];
            for (const key in schema) {
              this._headers[schema[key].index] = schema[key].name;
            }
          }
        }
        rowCount() {
          return this.length;
        }
        addArrayRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          this.rows = this.rows || new Array(DEFAULT_ROW_COUNT);
          this.rows[this.length] = row;
          this.length++;
        }
        addObjectRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          this.rows = this.rows || new Array(DEFAULT_ROW_COUNT);
          this.rows[this.length] = row;
          this.length++;
        }
        getBatch() {
          let rows = this.rows;
          if (!rows) {
            return null;
          }
          rows = rows.slice(0, this.length);
          this.rows = null;
          const batch = {
            shape: this.options.shape,
            batchType: "data",
            data: rows,
            length: this.length,
            schema: this.schema,
            cursor: this.cursor
          };
          return batch;
        }
      };
    }
  });

  // ../schema/src/lib/utils/row-utils.ts
  function convertToObjectRow(arrayRow, headers) {
    if (!arrayRow) {
      throw new Error("null row");
    }
    if (!headers) {
      throw new Error("no headers");
    }
    const objectRow = {};
    for (let i = 0; i < headers.length; i++) {
      objectRow[headers[i]] = arrayRow[i];
    }
    return objectRow;
  }
  function convertToArrayRow(objectRow, headers) {
    if (!objectRow) {
      throw new Error("null row");
    }
    if (!headers) {
      throw new Error("no headers");
    }
    const arrayRow = new Array(headers.length);
    for (let i = 0; i < headers.length; i++) {
      arrayRow[i] = objectRow[headers[i]];
    }
    return arrayRow;
  }
  var init_row_utils = __esm({
    "../schema/src/lib/utils/row-utils.ts"() {
    }
  });

  // ../schema/src/lib/batches/row-table-batch-aggregator.ts
  var DEFAULT_ROW_COUNT2, RowTableBatchAggregator2;
  var init_row_table_batch_aggregator = __esm({
    "../schema/src/lib/batches/row-table-batch-aggregator.ts"() {
      init_row_utils();
      DEFAULT_ROW_COUNT2 = 100;
      RowTableBatchAggregator2 = class {
        constructor(schema, options) {
          this.length = 0;
          this.objectRows = null;
          this.arrayRows = null;
          this.cursor = 0;
          this._headers = [];
          this.options = options;
          this.schema = schema;
          if (!Array.isArray(schema)) {
            this._headers = [];
            for (const key in schema) {
              this._headers[schema[key].index] = schema[key].name;
            }
          }
        }
        rowCount() {
          return this.length;
        }
        addArrayRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          switch (this.options.shape) {
            case "object-row-table":
              const rowObject = convertToObjectRow(row, this._headers);
              this.addObjectRow(rowObject, cursor);
              break;
            case "array-row-table":
              this.arrayRows = this.arrayRows || new Array(DEFAULT_ROW_COUNT2);
              this.arrayRows[this.length] = row;
              this.length++;
              break;
          }
        }
        addObjectRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          switch (this.options.shape) {
            case "array-row-table":
              const rowArray = convertToArrayRow(row, this._headers);
              this.addArrayRow(rowArray, cursor);
              break;
            case "object-row-table":
              this.objectRows = this.objectRows || new Array(DEFAULT_ROW_COUNT2);
              this.objectRows[this.length] = row;
              this.length++;
              break;
          }
        }
        getBatch() {
          let rows = this.arrayRows || this.objectRows;
          if (!rows) {
            return null;
          }
          rows = rows.slice(0, this.length);
          this.arrayRows = null;
          this.objectRows = null;
          return {
            shape: this.options.shape,
            batchType: "data",
            data: rows,
            length: this.length,
            schema: this.schema,
            cursor: this.cursor
          };
        }
      };
    }
  });

  // ../schema/src/lib/batches/columnar-table-batch-aggregator.ts
  var DEFAULT_ROW_COUNT3, ColumnarTableBatchAggregator;
  var init_columnar_table_batch_aggregator = __esm({
    "../schema/src/lib/batches/columnar-table-batch-aggregator.ts"() {
      DEFAULT_ROW_COUNT3 = 100;
      ColumnarTableBatchAggregator = class {
        constructor(schema, options) {
          this.length = 0;
          this.allocated = 0;
          this.columns = {};
          this.schema = schema;
          this._reallocateColumns();
        }
        rowCount() {
          return this.length;
        }
        addArrayRow(row) {
          this._reallocateColumns();
          let i = 0;
          for (const fieldName in this.columns) {
            this.columns[fieldName][this.length] = row[i++];
          }
          this.length++;
        }
        addObjectRow(row) {
          this._reallocateColumns();
          for (const fieldName in row) {
            this.columns[fieldName][this.length] = row[fieldName];
          }
          this.length++;
        }
        getBatch() {
          this._pruneColumns();
          const columns = Array.isArray(this.schema) ? this.columns : {};
          if (!Array.isArray(this.schema)) {
            for (const fieldName in this.schema) {
              const field = this.schema[fieldName];
              columns[field.name] = this.columns[field.index];
            }
          }
          this.columns = {};
          const batch = {
            shape: "columnar-table",
            batchType: "data",
            data: columns,
            schema: this.schema,
            length: this.length
          };
          return batch;
        }
        _reallocateColumns() {
          if (this.length < this.allocated) {
            return;
          }
          this.allocated = this.allocated > 0 ? this.allocated *= 2 : DEFAULT_ROW_COUNT3;
          this.columns = {};
          for (const fieldName in this.schema) {
            const field = this.schema[fieldName];
            const ArrayType = field.type || Float32Array;
            const oldColumn = this.columns[field.index];
            if (oldColumn && ArrayBuffer.isView(oldColumn)) {
              const typedArray = new ArrayType(this.allocated);
              typedArray.set(oldColumn);
              this.columns[field.index] = typedArray;
            } else if (oldColumn) {
              oldColumn.length = this.allocated;
              this.columns[field.index] = oldColumn;
            } else {
              this.columns[field.index] = new ArrayType(this.allocated);
            }
          }
        }
        _pruneColumns() {
          for (const [columnName, column] of Object.entries(this.columns)) {
            this.columns[columnName] = column.slice(0, this.length);
          }
        }
      };
    }
  });

  // ../schema/src/lib/batches/table-batch-builder.ts
  var DEFAULT_OPTIONS, ERR_MESSAGE, TableBatchBuilder;
  var init_table_batch_builder = __esm({
    "../schema/src/lib/batches/table-batch-builder.ts"() {
      init_base_table_batch_aggregator();
      init_row_table_batch_aggregator();
      init_columnar_table_batch_aggregator();
      DEFAULT_OPTIONS = {
        shape: "array-row-table",
        batchSize: "auto",
        batchDebounceMs: 0,
        limit: 0,
        _limitMB: 0
      };
      ERR_MESSAGE = "TableBatchBuilder";
      TableBatchBuilder = class {
        constructor(schema, options) {
          this.aggregator = null;
          this.batchCount = 0;
          this.bytesUsed = 0;
          this.isChunkComplete = false;
          this.lastBatchEmittedMs = Date.now();
          this.totalLength = 0;
          this.totalBytes = 0;
          this.rowBytes = 0;
          this.schema = schema;
          this.options = { ...DEFAULT_OPTIONS, ...options };
        }
        limitReached() {
          if (Boolean(this.options?.limit) && this.totalLength >= this.options.limit) {
            return true;
          }
          if (Boolean(this.options?._limitMB) && this.totalBytes / 1e6 >= this.options._limitMB) {
            return true;
          }
          return false;
        }
        addRow(row) {
          if (this.limitReached()) {
            return;
          }
          this.totalLength++;
          this.rowBytes = this.rowBytes || this._estimateRowMB(row);
          this.totalBytes += this.rowBytes;
          if (Array.isArray(row)) {
            this.addArrayRow(row);
          } else {
            this.addObjectRow(row);
          }
        }
        addArrayRow(row) {
          if (!this.aggregator) {
            const TableBatchType = this._getTableBatchType();
            this.aggregator = new TableBatchType(this.schema, this.options);
          }
          this.aggregator.addArrayRow(row);
        }
        addObjectRow(row) {
          if (!this.aggregator) {
            const TableBatchType = this._getTableBatchType();
            this.aggregator = new TableBatchType(this.schema, this.options);
          }
          this.aggregator.addObjectRow(row);
        }
        chunkComplete(chunk) {
          if (chunk instanceof ArrayBuffer) {
            this.bytesUsed += chunk.byteLength;
          }
          if (typeof chunk === "string") {
            this.bytesUsed += chunk.length;
          }
          this.isChunkComplete = true;
        }
        getFullBatch(options) {
          return this._isFull() ? this._getBatch(options) : null;
        }
        getFinalBatch(options) {
          return this._getBatch(options);
        }
        _estimateRowMB(row) {
          return Array.isArray(row) ? row.length * 8 : Object.keys(row).length * 8;
        }
        _isFull() {
          if (!this.aggregator || this.aggregator.rowCount() === 0) {
            return false;
          }
          if (this.options.batchSize === "auto") {
            if (!this.isChunkComplete) {
              return false;
            }
          } else if (this.options.batchSize > this.aggregator.rowCount()) {
            return false;
          }
          if (this.options.batchDebounceMs > Date.now() - this.lastBatchEmittedMs) {
            return false;
          }
          this.isChunkComplete = false;
          this.lastBatchEmittedMs = Date.now();
          return true;
        }
        _getBatch(options) {
          if (!this.aggregator) {
            return null;
          }
          if (options?.bytesUsed) {
            this.bytesUsed = options.bytesUsed;
          }
          const normalizedBatch = this.aggregator.getBatch();
          normalizedBatch.count = this.batchCount;
          normalizedBatch.bytesUsed = this.bytesUsed;
          Object.assign(normalizedBatch, options);
          this.batchCount++;
          this.aggregator = null;
          return normalizedBatch;
        }
        _getTableBatchType() {
          switch (this.options.shape) {
            case "row-table":
              return RowTableBatchAggregator;
            case "array-row-table":
            case "object-row-table":
              return RowTableBatchAggregator2;
            case "columnar-table":
              return ColumnarTableBatchAggregator;
            case "arrow-table":
              if (!TableBatchBuilder.ArrowBatch) {
                throw new Error(ERR_MESSAGE);
              }
              return TableBatchBuilder.ArrowBatch;
            default:
              throw new Error(ERR_MESSAGE);
          }
        }
      };
    }
  });

  // ../schema/src/lib/utils/async-queue.ts
  var ArrayQueue, AsyncQueue;
  var init_async_queue = __esm({
    "../schema/src/lib/utils/async-queue.ts"() {
      ArrayQueue = class extends Array {
        enqueue(value) {
          return this.push(value);
        }
        dequeue() {
          return this.shift();
        }
      };
      AsyncQueue = class {
        constructor() {
          this._values = new ArrayQueue();
          this._settlers = new ArrayQueue();
          this._closed = false;
        }
        close() {
          while (this._settlers.length > 0) {
            this._settlers.dequeue().resolve({ done: true });
          }
          this._closed = true;
        }
        [Symbol.asyncIterator]() {
          return this;
        }
        enqueue(value) {
          if (this._closed) {
            throw new Error("Closed");
          }
          if (this._settlers.length > 0) {
            if (this._values.length > 0) {
              throw new Error("Illegal internal state");
            }
            const settler = this._settlers.dequeue();
            if (value instanceof Error) {
              settler.reject(value);
            } else {
              settler.resolve({ value });
            }
          } else {
            this._values.enqueue(value);
          }
        }
        next() {
          if (this._values.length > 0) {
            const value = this._values.dequeue();
            if (value instanceof Error) {
              return Promise.reject(value);
            }
            return Promise.resolve({ value });
          }
          if (this._closed) {
            if (this._settlers.length > 0) {
              throw new Error("Illegal internal state");
            }
            return Promise.resolve({ done: true });
          }
          return new Promise((resolve, reject) => {
            this._settlers.enqueue({ resolve, reject });
          });
        }
      };
    }
  });

  // ../schema/src/index.ts
  var init_src = __esm({
    "../schema/src/index.ts"() {
      init_table_batch_builder();
      init_row_utils();
      init_async_queue();
    }
  });

  // src/papaparse/papaparse.ts
  function CsvToJson(_input, _config, UserDefinedStreamer) {
    _config = _config || {};
    var dynamicTyping = _config.dynamicTyping || false;
    if (isFunction(dynamicTyping)) {
      _config.dynamicTypingFunction = dynamicTyping;
      dynamicTyping = {};
    }
    _config.dynamicTyping = dynamicTyping;
    _config.transform = isFunction(_config.transform) ? _config.transform : false;
    if (_config.worker && Papa.WORKERS_SUPPORTED) {
      var w = newWorker();
      w.userStep = _config.step;
      w.userChunk = _config.chunk;
      w.userComplete = _config.complete;
      w.userError = _config.error;
      _config.step = isFunction(_config.step);
      _config.chunk = isFunction(_config.chunk);
      _config.complete = isFunction(_config.complete);
      _config.error = isFunction(_config.error);
      delete _config.worker;
      w.postMessage({
        input: _input,
        config: _config,
        workerId: w.id
      });
      return;
    }
    var streamer = null;
    if (typeof _input === "string") {
      streamer = new StringStreamer(_config);
    }
    if (!streamer) {
      streamer = new UserDefinedStreamer(_config);
    }
    return streamer.stream(_input);
  }
  function JsonToCsv(_input, _config) {
    var _quotes = false;
    var _writeHeader = true;
    var _delimiter = ",";
    var _newline = "\r\n";
    var _quoteChar = '"';
    var _escapedQuote = _quoteChar + _quoteChar;
    var _skipEmptyLines = false;
    var _columns = null;
    unpackConfig();
    var quoteCharRegex = new RegExp(escapeRegExp(_quoteChar), "g");
    if (typeof _input === "string")
      _input = JSON.parse(_input);
    if (Array.isArray(_input)) {
      if (!_input.length || Array.isArray(_input[0]))
        return serialize(null, _input, _skipEmptyLines);
      else if (typeof _input[0] === "object")
        return serialize(_columns || objectKeys(_input[0]), _input, _skipEmptyLines);
    } else if (typeof _input === "object") {
      if (typeof _input.data === "string")
        _input.data = JSON.parse(_input.data);
      if (Array.isArray(_input.data)) {
        if (!_input.fields)
          _input.fields = _input.meta && _input.meta.fields;
        if (!_input.fields)
          _input.fields = Array.isArray(_input.data[0]) ? _input.fields : objectKeys(_input.data[0]);
        if (!Array.isArray(_input.data[0]) && typeof _input.data[0] !== "object")
          _input.data = [_input.data];
      }
      return serialize(_input.fields || [], _input.data || [], _skipEmptyLines);
    }
    throw new Error("Unable to serialize unrecognized input");
    function unpackConfig() {
      if (typeof _config !== "object")
        return;
      if (typeof _config.delimiter === "string" && !Papa.BAD_DELIMITERS.filter(function(value) {
        return _config.delimiter.indexOf(value) !== -1;
      }).length) {
        _delimiter = _config.delimiter;
      }
      if (typeof _config.quotes === "boolean" || Array.isArray(_config.quotes))
        _quotes = _config.quotes;
      if (typeof _config.skipEmptyLines === "boolean" || typeof _config.skipEmptyLines === "string")
        _skipEmptyLines = _config.skipEmptyLines;
      if (typeof _config.newline === "string")
        _newline = _config.newline;
      if (typeof _config.quoteChar === "string")
        _quoteChar = _config.quoteChar;
      if (typeof _config.header === "boolean")
        _writeHeader = _config.header;
      if (Array.isArray(_config.columns)) {
        if (_config.columns.length === 0)
          throw new Error("Option columns is empty");
        _columns = _config.columns;
      }
      if (_config.escapeChar !== void 0) {
        _escapedQuote = _config.escapeChar + _quoteChar;
      }
    }
    function objectKeys(obj) {
      if (typeof obj !== "object")
        return [];
      var keys = [];
      for (var key in obj)
        keys.push(key);
      return keys;
    }
    function serialize(fields, data, skipEmptyLines) {
      var csv = "";
      if (typeof fields === "string")
        fields = JSON.parse(fields);
      if (typeof data === "string")
        data = JSON.parse(data);
      var hasHeader = Array.isArray(fields) && fields.length > 0;
      var dataKeyedByField = !Array.isArray(data[0]);
      if (hasHeader && _writeHeader) {
        for (var i = 0; i < fields.length; i++) {
          if (i > 0)
            csv += _delimiter;
          csv += safe(fields[i], i);
        }
        if (data.length > 0)
          csv += _newline;
      }
      for (var row = 0; row < data.length; row++) {
        var maxCol = hasHeader ? fields.length : data[row].length;
        var emptyLine = false;
        var nullLine = hasHeader ? Object.keys(data[row]).length === 0 : data[row].length === 0;
        if (skipEmptyLines && !hasHeader) {
          emptyLine = skipEmptyLines === "greedy" ? data[row].join("").trim() === "" : data[row].length === 1 && data[row][0].length === 0;
        }
        if (skipEmptyLines === "greedy" && hasHeader) {
          var line = [];
          for (var c = 0; c < maxCol; c++) {
            var cx = dataKeyedByField ? fields[c] : c;
            line.push(data[row][cx]);
          }
          emptyLine = line.join("").trim() === "";
        }
        if (!emptyLine) {
          for (var col = 0; col < maxCol; col++) {
            if (col > 0 && !nullLine)
              csv += _delimiter;
            var colIdx = hasHeader && dataKeyedByField ? fields[col] : col;
            csv += safe(data[row][colIdx], col);
          }
          if (row < data.length - 1 && (!skipEmptyLines || maxCol > 0 && !nullLine)) {
            csv += _newline;
          }
        }
      }
      return csv;
    }
    function safe(str, col) {
      if (typeof str === "undefined" || str === null)
        return "";
      if (str.constructor === Date)
        return JSON.stringify(str).slice(1, 25);
      str = str.toString().replace(quoteCharRegex, _escapedQuote);
      var needsQuotes = typeof _quotes === "boolean" && _quotes || Array.isArray(_quotes) && _quotes[col] || hasAny(str, Papa.BAD_DELIMITERS) || str.indexOf(_delimiter) > -1 || str.charAt(0) === " " || str.charAt(str.length - 1) === " ";
      return needsQuotes ? _quoteChar + str + _quoteChar : str;
    }
    function hasAny(str, substrings) {
      for (var i = 0; i < substrings.length; i++)
        if (str.indexOf(substrings[i]) > -1)
          return true;
      return false;
    }
  }
  function ChunkStreamer(config) {
    this._handle = null;
    this._finished = false;
    this._completed = false;
    this._input = null;
    this._baseIndex = 0;
    this._partialLine = "";
    this._rowCount = 0;
    this._start = 0;
    this._nextChunk = null;
    this.isFirstChunk = true;
    this._completeResults = {
      data: [],
      errors: [],
      meta: {}
    };
    replaceConfig.call(this, config);
    this.parseChunk = function(chunk, isFakeChunk) {
      if (this.isFirstChunk && isFunction(this._config.beforeFirstChunk)) {
        var modifiedChunk = this._config.beforeFirstChunk(chunk);
        if (modifiedChunk !== void 0)
          chunk = modifiedChunk;
      }
      this.isFirstChunk = false;
      var aggregate = this._partialLine + chunk;
      this._partialLine = "";
      var results = this._handle.parse(aggregate, this._baseIndex, !this._finished);
      if (this._handle.paused() || this._handle.aborted())
        return;
      var lastIndex = results.meta.cursor;
      if (!this._finished) {
        this._partialLine = aggregate.substring(lastIndex - this._baseIndex);
        this._baseIndex = lastIndex;
      }
      if (results && results.data)
        this._rowCount += results.data.length;
      var finishedIncludingPreview = this._finished || this._config.preview && this._rowCount >= this._config.preview;
      if (isFunction(this._config.chunk) && !isFakeChunk) {
        this._config.chunk(results, this._handle);
        if (this._handle.paused() || this._handle.aborted())
          return;
        results = void 0;
        this._completeResults = void 0;
      }
      if (!this._config.step && !this._config.chunk) {
        this._completeResults.data = this._completeResults.data.concat(results.data);
        this._completeResults.errors = this._completeResults.errors.concat(results.errors);
        this._completeResults.meta = results.meta;
      }
      if (!this._completed && finishedIncludingPreview && isFunction(this._config.complete) && (!results || !results.meta.aborted)) {
        this._config.complete(this._completeResults, this._input);
        this._completed = true;
      }
      if (!finishedIncludingPreview && (!results || !results.meta.paused))
        this._nextChunk();
      return results;
    };
    this._sendError = function(error) {
      if (isFunction(this._config.error))
        this._config.error(error);
    };
    function replaceConfig(config2) {
      var configCopy = copy(config2);
      configCopy.chunkSize = parseInt(configCopy.chunkSize);
      if (!config2.step && !config2.chunk)
        configCopy.chunkSize = null;
      this._handle = new ParserHandle(configCopy);
      this._handle.streamer = this;
      this._config = configCopy;
    }
  }
  function StringStreamer(config) {
    config = config || {};
    ChunkStreamer.call(this, config);
    var remaining;
    this.stream = function(s) {
      remaining = s;
      return this._nextChunk();
    };
    this._nextChunk = function() {
      if (this._finished)
        return;
      var size = this._config.chunkSize;
      var chunk = size ? remaining.substr(0, size) : remaining;
      remaining = size ? remaining.substr(size) : "";
      this._finished = !remaining;
      return this.parseChunk(chunk);
    };
  }
  function ParserHandle(_config) {
    var FLOAT = /^\s*-?(\d*\.?\d+|\d+\.?\d*)(e[-+]?\d+)?\s*$/i;
    var ISO_DATE = /(\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d\.\d+([+-][0-2]\d:[0-5]\d|Z))|(\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d:[0-5]\d([+-][0-2]\d:[0-5]\d|Z))|(\d{4}-[01]\d-[0-3]\dT[0-2]\d:[0-5]\d([+-][0-2]\d:[0-5]\d|Z))/;
    var self = this;
    var _stepCounter = 0;
    var _rowCounter = 0;
    var _input;
    var _parser;
    var _paused = false;
    var _aborted = false;
    var _delimiterError;
    var _fields = [];
    var _results = {
      data: [],
      errors: [],
      meta: {}
    };
    if (isFunction(_config.step)) {
      var userStep = _config.step;
      _config.step = function(results) {
        _results = results;
        if (needsHeaderRow())
          processResults();
        else {
          processResults();
          if (!_results.data || _results.data.length === 0)
            return;
          _stepCounter += results.data.length;
          if (_config.preview && _stepCounter > _config.preview)
            _parser.abort();
          else
            userStep(_results, self);
        }
      };
    }
    this.parse = function(input, baseIndex, ignoreLastRow) {
      var quoteChar = _config.quoteChar || '"';
      if (!_config.newline)
        _config.newline = guessLineEndings(input, quoteChar);
      _delimiterError = false;
      if (!_config.delimiter) {
        var delimGuess = guessDelimiter(input, _config.newline, _config.skipEmptyLines, _config.comments, _config.delimitersToGuess);
        if (delimGuess.successful)
          _config.delimiter = delimGuess.bestDelimiter;
        else {
          _delimiterError = true;
          _config.delimiter = Papa.DefaultDelimiter;
        }
        _results.meta.delimiter = _config.delimiter;
      } else if (isFunction(_config.delimiter)) {
        _config.delimiter = _config.delimiter(input);
        _results.meta.delimiter = _config.delimiter;
      }
      var parserConfig = copy(_config);
      if (_config.preview && _config.header)
        parserConfig.preview++;
      _input = input;
      _parser = new Parser(parserConfig);
      _results = _parser.parse(_input, baseIndex, ignoreLastRow);
      processResults();
      return _paused ? { meta: { paused: true } } : _results || { meta: { paused: false } };
    };
    this.paused = function() {
      return _paused;
    };
    this.pause = function() {
      _paused = true;
      _parser.abort();
      _input = _input.substr(_parser.getCharIndex());
    };
    this.resume = function() {
      _paused = false;
      self.streamer.parseChunk(_input, true);
    };
    this.aborted = function() {
      return _aborted;
    };
    this.abort = function() {
      _aborted = true;
      _parser.abort();
      _results.meta.aborted = true;
      if (isFunction(_config.complete))
        _config.complete(_results);
      _input = "";
    };
    function testEmptyLine(s) {
      return _config.skipEmptyLines === "greedy" ? s.join("").trim() === "" : s.length === 1 && s[0].length === 0;
    }
    function processResults() {
      if (_results && _delimiterError) {
        addError("Delimiter", "UndetectableDelimiter", "Unable to auto-detect delimiting character; defaulted to '" + Papa.DefaultDelimiter + "'");
        _delimiterError = false;
      }
      if (_config.skipEmptyLines) {
        for (var i = 0; i < _results.data.length; i++)
          if (testEmptyLine(_results.data[i]))
            _results.data.splice(i--, 1);
      }
      if (needsHeaderRow())
        fillHeaderFields();
      return applyHeaderAndDynamicTypingAndTransformation();
    }
    function needsHeaderRow() {
      return _config.header && _fields.length === 0;
    }
    function fillHeaderFields() {
      if (!_results)
        return;
      function addHeder(header) {
        if (isFunction(_config.transformHeader))
          header = _config.transformHeader(header);
        _fields.push(header);
      }
      if (Array.isArray(_results.data[0])) {
        for (var i = 0; needsHeaderRow() && i < _results.data.length; i++)
          _results.data[i].forEach(addHeder);
        _results.data.splice(0, 1);
      } else
        _results.data.forEach(addHeder);
    }
    function shouldApplyDynamicTyping(field) {
      if (_config.dynamicTypingFunction && _config.dynamicTyping[field] === void 0) {
        _config.dynamicTyping[field] = _config.dynamicTypingFunction(field);
      }
      return (_config.dynamicTyping[field] || _config.dynamicTyping) === true;
    }
    function parseDynamic(field, value) {
      if (shouldApplyDynamicTyping(field)) {
        if (value === "true" || value === "TRUE")
          return true;
        else if (value === "false" || value === "FALSE")
          return false;
        else if (FLOAT.test(value))
          return parseFloat(value);
        else if (ISO_DATE.test(value))
          return new Date(value);
        else
          return value === "" ? null : value;
      }
      return value;
    }
    function applyHeaderAndDynamicTypingAndTransformation() {
      if (!_results || !_results.data || !_config.header && !_config.dynamicTyping && !_config.transform)
        return _results;
      function processRow(rowSource, i) {
        var row = _config.header ? {} : [];
        var j;
        for (j = 0; j < rowSource.length; j++) {
          var field = j;
          var value = rowSource[j];
          if (_config.header)
            field = j >= _fields.length ? "__parsed_extra" : _fields[j];
          if (_config.transform)
            value = _config.transform(value, field);
          value = parseDynamic(field, value);
          if (field === "__parsed_extra") {
            row[field] = row[field] || [];
            row[field].push(value);
          } else
            row[field] = value;
        }
        if (_config.header) {
          if (j > _fields.length)
            addError("FieldMismatch", "TooManyFields", "Too many fields: expected " + _fields.length + " fields but parsed " + j, _rowCounter + i);
          else if (j < _fields.length)
            addError("FieldMismatch", "TooFewFields", "Too few fields: expected " + _fields.length + " fields but parsed " + j, _rowCounter + i);
        }
        return row;
      }
      var incrementBy = 1;
      if (!_results.data[0] || Array.isArray(_results.data[0])) {
        _results.data = _results.data.map(processRow);
        incrementBy = _results.data.length;
      } else
        _results.data = processRow(_results.data, 0);
      if (_config.header && _results.meta)
        _results.meta.fields = _fields;
      _rowCounter += incrementBy;
      return _results;
    }
    function guessDelimiter(input, newline, skipEmptyLines, comments, delimitersToGuess) {
      var bestDelim, bestDelta, fieldCountPrevRow;
      delimitersToGuess = delimitersToGuess || [",", "	", "|", ";", Papa.RECORD_SEP, Papa.UNIT_SEP];
      for (var i = 0; i < delimitersToGuess.length; i++) {
        var delim = delimitersToGuess[i];
        var delta = 0, avgFieldCount = 0, emptyLinesCount = 0;
        fieldCountPrevRow = void 0;
        var preview = new Parser({
          comments,
          delimiter: delim,
          newline,
          preview: 10
        }).parse(input);
        for (var j = 0; j < preview.data.length; j++) {
          if (skipEmptyLines && testEmptyLine(preview.data[j])) {
            emptyLinesCount++;
            continue;
          }
          var fieldCount = preview.data[j].length;
          avgFieldCount += fieldCount;
          if (typeof fieldCountPrevRow === "undefined") {
            fieldCountPrevRow = 0;
            continue;
          } else if (fieldCount > 1) {
            delta += Math.abs(fieldCount - fieldCountPrevRow);
            fieldCountPrevRow = fieldCount;
          }
        }
        if (preview.data.length > 0)
          avgFieldCount /= preview.data.length - emptyLinesCount;
        if ((typeof bestDelta === "undefined" || delta > bestDelta) && avgFieldCount > 1.99) {
          bestDelta = delta;
          bestDelim = delim;
        }
      }
      _config.delimiter = bestDelim;
      return {
        successful: !!bestDelim,
        bestDelimiter: bestDelim
      };
    }
    function guessLineEndings(input, quoteChar) {
      input = input.substr(0, 1024 * 1024);
      var re = new RegExp(escapeRegExp(quoteChar) + "([^]*?)" + escapeRegExp(quoteChar), "gm");
      input = input.replace(re, "");
      var r = input.split("\r");
      var n = input.split("\n");
      var nAppearsFirst = n.length > 1 && n[0].length < r[0].length;
      if (r.length === 1 || nAppearsFirst)
        return "\n";
      var numWithN = 0;
      for (var i = 0; i < r.length; i++) {
        if (r[i][0] === "\n")
          numWithN++;
      }
      return numWithN >= r.length / 2 ? "\r\n" : "\r";
    }
    function addError(type, code, msg, row) {
      _results.errors.push({
        type,
        code,
        message: msg,
        row
      });
    }
  }
  function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
  }
  function Parser(config) {
    config = config || {};
    var delim = config.delimiter;
    var newline = config.newline;
    var comments = config.comments;
    var step = config.step;
    var preview = config.preview;
    var fastMode = config.fastMode;
    var quoteChar;
    if (config.quoteChar === void 0) {
      quoteChar = '"';
    } else {
      quoteChar = config.quoteChar;
    }
    var escapeChar = quoteChar;
    if (config.escapeChar !== void 0) {
      escapeChar = config.escapeChar;
    }
    if (typeof delim !== "string" || Papa.BAD_DELIMITERS.indexOf(delim) > -1)
      delim = ",";
    if (comments === delim)
      throw new Error("Comment character same as delimiter");
    else if (comments === true)
      comments = "#";
    else if (typeof comments !== "string" || Papa.BAD_DELIMITERS.indexOf(comments) > -1)
      comments = false;
    if (newline !== "\n" && newline !== "\r" && newline !== "\r\n")
      newline = "\n";
    var cursor = 0;
    var aborted = false;
    this.parse = function(input, baseIndex, ignoreLastRow) {
      if (typeof input !== "string")
        throw new Error("Input must be a string");
      var inputLen = input.length, delimLen = delim.length, newlineLen = newline.length, commentsLen = comments.length;
      var stepIsFunction = isFunction(step);
      cursor = 0;
      var data = [], errors = [], row = [], lastCursor = 0;
      if (!input)
        return returnable();
      if (fastMode || fastMode !== false && input.indexOf(quoteChar) === -1) {
        var rows = input.split(newline);
        for (var i = 0; i < rows.length; i++) {
          row = rows[i];
          cursor += row.length;
          if (i !== rows.length - 1)
            cursor += newline.length;
          else if (ignoreLastRow)
            return returnable();
          if (comments && row.substr(0, commentsLen) === comments)
            continue;
          if (stepIsFunction) {
            data = [];
            pushRow(row.split(delim));
            doStep();
            if (aborted)
              return returnable();
          } else
            pushRow(row.split(delim));
          if (preview && i >= preview) {
            data = data.slice(0, preview);
            return returnable(true);
          }
        }
        return returnable();
      }
      var nextDelim = input.indexOf(delim, cursor);
      var nextNewline = input.indexOf(newline, cursor);
      var quoteCharRegex = new RegExp(escapeRegExp(escapeChar) + escapeRegExp(quoteChar), "g");
      var quoteSearch;
      for (; ; ) {
        if (input[cursor] === quoteChar) {
          quoteSearch = cursor;
          cursor++;
          for (; ; ) {
            quoteSearch = input.indexOf(quoteChar, quoteSearch + 1);
            if (quoteSearch === -1) {
              if (!ignoreLastRow) {
                errors.push({
                  type: "Quotes",
                  code: "MissingQuotes",
                  message: "Quoted field unterminated",
                  row: data.length,
                  index: cursor
                });
              }
              return finish();
            }
            if (quoteSearch === inputLen - 1) {
              var value = input.substring(cursor, quoteSearch).replace(quoteCharRegex, quoteChar);
              return finish(value);
            }
            if (quoteChar === escapeChar && input[quoteSearch + 1] === escapeChar) {
              quoteSearch++;
              continue;
            }
            if (quoteChar !== escapeChar && quoteSearch !== 0 && input[quoteSearch - 1] === escapeChar) {
              continue;
            }
            var checkUpTo = nextNewline === -1 ? nextDelim : Math.min(nextDelim, nextNewline);
            var spacesBetweenQuoteAndDelimiter = extraSpaces(checkUpTo);
            if (input[quoteSearch + 1 + spacesBetweenQuoteAndDelimiter] === delim) {
              row.push(input.substring(cursor, quoteSearch).replace(quoteCharRegex, quoteChar));
              cursor = quoteSearch + 1 + spacesBetweenQuoteAndDelimiter + delimLen;
              nextDelim = input.indexOf(delim, cursor);
              nextNewline = input.indexOf(newline, cursor);
              if (stepIsFunction) {
                doStep();
                if (aborted)
                  return returnable();
              }
              if (preview && data.length >= preview)
                return returnable(true);
              break;
            }
            var spacesBetweenQuoteAndNewLine = extraSpaces(nextNewline);
            if (input.substr(quoteSearch + 1 + spacesBetweenQuoteAndNewLine, newlineLen) === newline) {
              row.push(input.substring(cursor, quoteSearch).replace(quoteCharRegex, quoteChar));
              saveRow(quoteSearch + 1 + spacesBetweenQuoteAndNewLine + newlineLen);
              nextDelim = input.indexOf(delim, cursor);
              if (stepIsFunction) {
                doStep();
                if (aborted)
                  return returnable();
              }
              if (preview && data.length >= preview)
                return returnable(true);
              break;
            }
            errors.push({
              type: "Quotes",
              code: "InvalidQuotes",
              message: "Trailing quote on quoted field is malformed",
              row: data.length,
              index: cursor
            });
            quoteSearch++;
            continue;
          }
          if (stepIsFunction) {
            doStep();
            if (aborted)
              return returnable();
          }
          if (preview && data.length >= preview)
            return returnable(true);
          continue;
        }
        if (comments && row.length === 0 && input.substr(cursor, commentsLen) === comments) {
          if (nextNewline === -1)
            return returnable();
          cursor = nextNewline + newlineLen;
          nextNewline = input.indexOf(newline, cursor);
          nextDelim = input.indexOf(delim, cursor);
          continue;
        }
        if (nextDelim !== -1 && (nextDelim < nextNewline || nextNewline === -1)) {
          row.push(input.substring(cursor, nextDelim));
          cursor = nextDelim + delimLen;
          nextDelim = input.indexOf(delim, cursor);
          continue;
        }
        if (nextNewline !== -1) {
          row.push(input.substring(cursor, nextNewline));
          saveRow(nextNewline + newlineLen);
          if (stepIsFunction) {
            doStep();
            if (aborted)
              return returnable();
          }
          if (preview && data.length >= preview)
            return returnable(true);
          continue;
        }
        break;
      }
      return finish();
      function pushRow(row2) {
        data.push(row2);
        lastCursor = cursor;
      }
      function extraSpaces(index) {
        var spaceLength = 0;
        if (index !== -1) {
          var textBetweenClosingQuoteAndIndex = input.substring(quoteSearch + 1, index);
          if (textBetweenClosingQuoteAndIndex && textBetweenClosingQuoteAndIndex.trim() === "") {
            spaceLength = textBetweenClosingQuoteAndIndex.length;
          }
        }
        return spaceLength;
      }
      function finish(value2) {
        if (ignoreLastRow)
          return returnable();
        if (typeof value2 === "undefined")
          value2 = input.substr(cursor);
        row.push(value2);
        cursor = inputLen;
        pushRow(row);
        if (stepIsFunction)
          doStep();
        return returnable();
      }
      function saveRow(newCursor) {
        cursor = newCursor;
        pushRow(row);
        row = [];
        nextNewline = input.indexOf(newline, cursor);
      }
      function returnable(stopped, step2) {
        var isStep = step2 || false;
        return {
          data: isStep ? data[0] : data,
          errors,
          meta: {
            delimiter: delim,
            linebreak: newline,
            aborted,
            truncated: !!stopped,
            cursor: lastCursor + (baseIndex || 0)
          }
        };
      }
      function doStep() {
        step(returnable(void 0, true));
        data = [];
        errors = [];
      }
    };
    this.abort = function() {
      aborted = true;
    };
    this.getCharIndex = function() {
      return cursor;
    };
  }
  function copy(obj) {
    if (typeof obj !== "object" || obj === null)
      return obj;
    var cpy = Array.isArray(obj) ? [] : {};
    for (var key in obj)
      cpy[key] = copy(obj[key]);
    return cpy;
  }
  function isFunction(func) {
    return typeof func === "function";
  }
  var BYTE_ORDER_MARK, Papa, papaparse_default;
  var init_papaparse = __esm({
    "src/papaparse/papaparse.ts"() {
      BYTE_ORDER_MARK = "\uFEFF";
      Papa = {
        parse: CsvToJson,
        unparse: JsonToCsv,
        RECORD_SEP: String.fromCharCode(30),
        UNIT_SEP: String.fromCharCode(31),
        BYTE_ORDER_MARK,
        BAD_DELIMITERS: ["\r", "\n", '"', BYTE_ORDER_MARK],
        WORKERS_SUPPORTED: false,
        NODE_STREAM_INPUT: 1,
        LocalChunkSize: 1024 * 1024 * 10,
        RemoteChunkSize: 1024 * 1024 * 5,
        DefaultDelimiter: ",",
        Parser,
        ParserHandle,
        ChunkStreamer,
        StringStreamer
      };
      papaparse_default = Papa;
      StringStreamer.prototype = Object.create(StringStreamer.prototype);
      StringStreamer.prototype.constructor = StringStreamer;
    }
  });

  // src/papaparse/async-iterator-streamer.ts
  function AsyncIteratorStreamer(config) {
    config = config || {};
    ChunkStreamer2.call(this, config);
    this.textDecoder = new TextDecoder(this._config.encoding);
    this.stream = async function(asyncIterator) {
      this._input = asyncIterator;
      try {
        for await (const chunk of asyncIterator) {
          this.parseChunk(this.getStringChunk(chunk));
        }
        this._finished = true;
        this.parseChunk("");
      } catch (error) {
        this._sendError(error);
      }
    };
    this._nextChunk = function nextChunk() {
    };
    this.getStringChunk = function(chunk) {
      return typeof chunk === "string" ? chunk : this.textDecoder.decode(chunk, { stream: true });
    };
  }
  var ChunkStreamer2;
  var init_async_iterator_streamer = __esm({
    "src/papaparse/async-iterator-streamer.ts"() {
      init_papaparse();
      ({ ChunkStreamer: ChunkStreamer2 } = papaparse_default);
      AsyncIteratorStreamer.prototype = Object.create(ChunkStreamer2.prototype);
      AsyncIteratorStreamer.prototype.constructor = AsyncIteratorStreamer;
    }
  });

  // src/csv-loader.ts
  async function parseCSV(csvText, options) {
    const csvOptions = { ...DEFAULT_CSV_LOADER_OPTIONS.csv, ...options?.csv };
    const firstRow = readFirstRow(csvText);
    const header = csvOptions.header === "auto" ? isHeaderRow(firstRow) : Boolean(csvOptions.header);
    const parseWithHeader = header;
    const papaparseConfig = {
      ...csvOptions,
      header: parseWithHeader,
      download: false,
      transformHeader: parseWithHeader ? duplicateColumnTransformer() : void 0,
      error: (e) => {
        throw new Error(e);
      }
    };
    const result = papaparse_default.parse(csvText, papaparseConfig);
    let { data: rows } = result;
    const headerRow = result.meta.fields || generateHeader(csvOptions.columnPrefix, firstRow.length);
    switch (csvOptions.shape) {
      case "object-row-table":
        rows = rows.map((row) => Array.isArray(row) ? convertToObjectRow(row, headerRow) : row);
        break;
      case "array-row-table":
        rows = rows.map((row) => Array.isArray(row) ? row : convertToArrayRow(row, headerRow));
        break;
      default:
    }
    return rows;
  }
  function parseCSVInBatches(asyncIterator, options) {
    options = { ...options };
    if (options.batchSize === "auto") {
      options.batchSize = 4e3;
    }
    const csvOptions = { ...DEFAULT_CSV_LOADER_OPTIONS.csv, ...options?.csv };
    const asyncQueue = new AsyncQueue();
    let isFirstRow = true;
    let headerRow = null;
    let tableBatchBuilder = null;
    let schema = null;
    const config = {
      ...csvOptions,
      header: false,
      download: false,
      chunkSize: 1024 * 1024 * 5,
      skipEmptyLines: false,
      step(results) {
        let row = results.data;
        if (csvOptions.skipEmptyLines) {
          const collapsedRow = row.flat().join("").trim();
          if (collapsedRow === "") {
            return;
          }
        }
        const bytesUsed = results.meta.cursor;
        if (isFirstRow && !headerRow) {
          const header = csvOptions.header === "auto" ? isHeaderRow(row) : Boolean(csvOptions.header);
          if (header) {
            headerRow = row.map(duplicateColumnTransformer());
            return;
          }
        }
        if (isFirstRow) {
          isFirstRow = false;
          if (!headerRow) {
            headerRow = generateHeader(csvOptions.columnPrefix, row.length);
          }
          schema = deduceSchema(row, headerRow);
        }
        if (csvOptions.optimizeMemoryUsage) {
          row = JSON.parse(JSON.stringify(row));
        }
        tableBatchBuilder = tableBatchBuilder || new TableBatchBuilder(schema, {
          shape: csvOptions.shape || "array-row-table",
          ...options
        });
        try {
          tableBatchBuilder.addRow(row);
          const batch = tableBatchBuilder && tableBatchBuilder.getFullBatch({ bytesUsed });
          if (batch) {
            asyncQueue.enqueue(batch);
          }
        } catch (error) {
          asyncQueue.enqueue(error);
        }
      },
      complete(results) {
        try {
          const bytesUsed = results.meta.cursor;
          const batch = tableBatchBuilder && tableBatchBuilder.getFinalBatch({ bytesUsed });
          if (batch) {
            asyncQueue.enqueue(batch);
          }
        } catch (error) {
          asyncQueue.enqueue(error);
        }
        asyncQueue.close();
      }
    };
    papaparse_default.parse(asyncIterator, config, AsyncIteratorStreamer);
    return asyncQueue;
  }
  function isHeaderRow(row) {
    return row && row.every((value) => typeof value === "string");
  }
  function readFirstRow(csvText) {
    const result = papaparse_default.parse(csvText, {
      download: false,
      dynamicTyping: true,
      preview: 1
    });
    return result.data[0];
  }
  function duplicateColumnTransformer() {
    const observedColumns = new Set();
    return (col) => {
      let colName = col;
      let counter = 1;
      while (observedColumns.has(colName)) {
        colName = `${col}.${counter}`;
        counter++;
      }
      observedColumns.add(colName);
      return colName;
    };
  }
  function generateHeader(columnPrefix, count = 0) {
    const headers = [];
    for (let i = 0; i < count; i++) {
      headers.push(`${columnPrefix}${i + 1}`);
    }
    return headers;
  }
  function deduceSchema(row, headerRow) {
    const schema = headerRow ? {} : [];
    for (let i = 0; i < row.length; i++) {
      const columnName = headerRow && headerRow[i] || i;
      const value = row[i];
      switch (typeof value) {
        case "number":
        case "boolean":
          schema[columnName] = { name: String(columnName), index: i, type: Float32Array };
          break;
        case "string":
        default:
          schema[columnName] = { name: String(columnName), index: i, type: Array };
      }
    }
    return schema;
  }
  var VERSION, DEFAULT_CSV_LOADER_OPTIONS, CSVLoader;
  var init_csv_loader = __esm({
    "src/csv-loader.ts"() {
      init_src();
      init_papaparse();
      init_async_iterator_streamer();
      VERSION = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      DEFAULT_CSV_LOADER_OPTIONS = {
        csv: {
          shape: "object-row-table",
          optimizeMemoryUsage: false,
          header: "auto",
          columnPrefix: "column",
          quoteChar: '"',
          escapeChar: '"',
          dynamicTyping: true,
          comments: false,
          skipEmptyLines: true,
          delimitersToGuess: [",", "	", "|", ";"]
        }
      };
      CSVLoader = {
        id: "csv",
        module: "csv",
        name: "CSV",
        version: VERSION,
        extensions: ["csv", "tsv", "dsv"],
        mimeTypes: ["text/csv", "text/tab-separated-values", "text/dsv"],
        category: "table",
        parse: async (arrayBuffer, options) => parseCSV(new TextDecoder().decode(arrayBuffer), options),
        parseText: (text, options) => parseCSV(text, options),
        parseInBatches: parseCSVInBatches,
        options: DEFAULT_CSV_LOADER_OPTIONS
      };
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    CSVLoader: () => CSVLoader
  });
  var init_src2 = __esm({
    "src/index.ts"() {
      init_csv_loader();
    }
  });

  // src/bundle.ts
  var require_bundle = __commonJS({
    "src/bundle.ts"(exports, module) {
      var moduleExports = (init_src2(), src_exports);
      globalThis.loaders = globalThis.loaders || {};
      module.exports = Object.assign(globalThis.loaders, moduleExports);
    }
  });
  require_bundle();
})();
/* @license
Papa Parse
v5.0.0-beta.0
https://github.com/mholt/PapaParse
License: MIT
*/
