#!/usr/bin/env python

from distutils.core import setup

DESCRIPTION = """
PyORQ (Python Object Relational binding with Queries) implements persistence
for Python objects using a relational database (RDBMS, e.g. PostgreSQL MySQL)
for storage.

PyORQ uses native Python expressions to denote queries which can be
automatically translated into SQL and then be executed by the backend. This
leverages the full search capabilities of RDBMSs in an object-oriented
programming environment.
"""

CLASSIFIERS = ['Development Status :: 3 - Alpha',
               'Environment :: Other Environment',
               'Intended Audience :: Developers',
               'License :: OSI Approved :: MIT License',
               'Natural Language :: English',
               'Operating System :: OS Independent',
               'Programming Language :: Python',
               'Topic :: Database :: Front-Ends']

def main():
    import sys
    if sys.version_info < (2, 3):
        print "PyORQ requires Python 2.3 or later"
        sys.exit()

    setup(name="PyORQ",
          version="0.1",
          description="Object Relational binding with Queries",
          long_description=DESCRIPTION,
          author="Roeland Rengelink",
          author_email="roeland.rengelink@chello.nl",
          url="http://www.sourceforge.net/projects/pyorq",
          packages=['pyorq', 'pyorq.interface'],
          license='MIT',
          platform='OS Independent',
          download_url="",
          classifiers = CLASSIFIERS
          )

if __name__ == '__main__':
    main()
