# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnomalyDataPoint(object):
    """
    anomaly evaluation result fo the data point
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AnomalyDataPoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param anomaly:
            The value to assign to the anomaly property of this AnomalyDataPoint.
        :type anomaly: float

        :param low:
            The value to assign to the low property of this AnomalyDataPoint.
        :type low: float

        :param high:
            The value to assign to the high property of this AnomalyDataPoint.
        :type high: float

        :param timestamp:
            The value to assign to the timestamp property of this AnomalyDataPoint.
        :type timestamp: datetime

        :param value:
            The value to assign to the value property of this AnomalyDataPoint.
        :type value: float

        """
        self.swagger_types = {
            'anomaly': 'float',
            'low': 'float',
            'high': 'float',
            'timestamp': 'datetime',
            'value': 'float'
        }

        self.attribute_map = {
            'anomaly': 'anomaly',
            'low': 'low',
            'high': 'high',
            'timestamp': 'timestamp',
            'value': 'value'
        }

        self._anomaly = None
        self._low = None
        self._high = None
        self._timestamp = None
        self._value = None

    @property
    def anomaly(self):
        """
        **[Required]** Gets the anomaly of this AnomalyDataPoint.
        if the value is anomaly or not 0 indicates not an anomaly -1 indicates value is below the threshold +1 indicates value is above the threshold


        :return: The anomaly of this AnomalyDataPoint.
        :rtype: float
        """
        return self._anomaly

    @anomaly.setter
    def anomaly(self, anomaly):
        """
        Sets the anomaly of this AnomalyDataPoint.
        if the value is anomaly or not 0 indicates not an anomaly -1 indicates value is below the threshold +1 indicates value is above the threshold


        :param anomaly: The anomaly of this AnomalyDataPoint.
        :type: float
        """
        self._anomaly = anomaly

    @property
    def low(self):
        """
        Gets the low of this AnomalyDataPoint.
        lower threshold for the metric value


        :return: The low of this AnomalyDataPoint.
        :rtype: float
        """
        return self._low

    @low.setter
    def low(self, low):
        """
        Sets the low of this AnomalyDataPoint.
        lower threshold for the metric value


        :param low: The low of this AnomalyDataPoint.
        :type: float
        """
        self._low = low

    @property
    def high(self):
        """
        Gets the high of this AnomalyDataPoint.
        upper threshold for the metric value


        :return: The high of this AnomalyDataPoint.
        :rtype: float
        """
        return self._high

    @high.setter
    def high(self, high):
        """
        Sets the high of this AnomalyDataPoint.
        upper threshold for the metric value


        :param high: The high of this AnomalyDataPoint.
        :type: float
        """
        self._high = high

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this AnomalyDataPoint.
        timestamp of when the metric was collected


        :return: The timestamp of this AnomalyDataPoint.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this AnomalyDataPoint.
        timestamp of when the metric was collected


        :param timestamp: The timestamp of this AnomalyDataPoint.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def value(self):
        """
        **[Required]** Gets the value of this AnomalyDataPoint.
        value for the metric data point


        :return: The value of this AnomalyDataPoint.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AnomalyDataPoint.
        value for the metric data point


        :param value: The value of this AnomalyDataPoint.
        :type: float
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
