# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RestoreDbSystemDetails(object):
    """
    Backup details to restore the database system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RestoreDbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_id:
            The value to assign to the backup_id property of this RestoreDbSystemDetails.
        :type backup_id: str

        :param ad:
            The value to assign to the ad property of this RestoreDbSystemDetails.
        :type ad: str

        """
        self.swagger_types = {
            'backup_id': 'str',
            'ad': 'str'
        }

        self.attribute_map = {
            'backup_id': 'backupId',
            'ad': 'ad'
        }

        self._backup_id = None
        self._ad = None

    @property
    def backup_id(self):
        """
        **[Required]** Gets the backup_id of this RestoreDbSystemDetails.
        The `OCID`__ of the database system backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The backup_id of this RestoreDbSystemDetails.
        :rtype: str
        """
        return self._backup_id

    @backup_id.setter
    def backup_id(self, backup_id):
        """
        Sets the backup_id of this RestoreDbSystemDetails.
        The `OCID`__ of the database system backup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param backup_id: The backup_id of this RestoreDbSystemDetails.
        :type: str
        """
        self._backup_id = backup_id

    @property
    def ad(self):
        """
        Gets the ad of this RestoreDbSystemDetails.
        The desired AD for regions with three ADs. This parameter is optional.
        If not set, the AD is chosen based on the database system's current AD.


        :return: The ad of this RestoreDbSystemDetails.
        :rtype: str
        """
        return self._ad

    @ad.setter
    def ad(self, ad):
        """
        Sets the ad of this RestoreDbSystemDetails.
        The desired AD for regions with three ADs. This parameter is optional.
        If not set, the AD is chosen based on the database system's current AD.


        :param ad: The ad of this RestoreDbSystemDetails.
        :type: str
        """
        self._ad = ad

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
