# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplicationGroup(object):
    """
    A group of applications.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApplicationGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ApplicationGroup.
        :type name: str

        :param apps:
            The value to assign to the apps property of this ApplicationGroup.
        :type apps: list[str]

        :param total_apps:
            The value to assign to the total_apps property of this ApplicationGroup.
        :type total_apps: int

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this ApplicationGroup.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'apps': 'list[str]',
            'total_apps': 'int',
            'parent_resource_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'apps': 'apps',
            'total_apps': 'totalApps',
            'parent_resource_id': 'parentResourceId'
        }

        self._name = None
        self._apps = None
        self._total_apps = None
        self._parent_resource_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ApplicationGroup.
        Name of the application Group.


        :return: The name of this ApplicationGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApplicationGroup.
        Name of the application Group.


        :param name: The name of this ApplicationGroup.
        :type: str
        """
        self._name = name

    @property
    def apps(self):
        """
        **[Required]** Gets the apps of this ApplicationGroup.
        List of apps in the group.


        :return: The apps of this ApplicationGroup.
        :rtype: list[str]
        """
        return self._apps

    @apps.setter
    def apps(self, apps):
        """
        Sets the apps of this ApplicationGroup.
        List of apps in the group.


        :param apps: The apps of this ApplicationGroup.
        :type: list[str]
        """
        self._apps = apps

    @property
    def total_apps(self):
        """
        **[Required]** Gets the total_apps of this ApplicationGroup.
        Count of total applications in the given application group.


        :return: The total_apps of this ApplicationGroup.
        :rtype: int
        """
        return self._total_apps

    @total_apps.setter
    def total_apps(self, total_apps):
        """
        Sets the total_apps of this ApplicationGroup.
        Count of total applications in the given application group.


        :param total_apps: The total_apps of this ApplicationGroup.
        :type: int
        """
        self._total_apps = total_apps

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this ApplicationGroup.
        OCID of the Network Firewall Policy this application group belongs to.


        :return: The parent_resource_id of this ApplicationGroup.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this ApplicationGroup.
        OCID of the Network Firewall Policy this application group belongs to.


        :param parent_resource_id: The parent_resource_id of this ApplicationGroup.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
