# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConditionBlock(object):
    """
    A condition block. This could represent a single condition, or have nested condition blocks under it.
    To form a single condition, specify the fieldName, labelConditionOperator and labelConditionValue(s).
    To form nested conditions, specify the conditions in conditionBlocks, and how to join them in conditionBlocksOperator.
    """

    #: A constant which can be used with the condition_blocks_operator property of a ConditionBlock.
    #: This constant has a value of "AND"
    CONDITION_BLOCKS_OPERATOR_AND = "AND"

    #: A constant which can be used with the condition_blocks_operator property of a ConditionBlock.
    #: This constant has a value of "OR"
    CONDITION_BLOCKS_OPERATOR_OR = "OR"

    #: A constant which can be used with the condition_blocks_operator property of a ConditionBlock.
    #: This constant has a value of "NOT_AND"
    CONDITION_BLOCKS_OPERATOR_NOT_AND = "NOT_AND"

    #: A constant which can be used with the condition_blocks_operator property of a ConditionBlock.
    #: This constant has a value of "NOT_OR"
    CONDITION_BLOCKS_OPERATOR_NOT_OR = "NOT_OR"

    def __init__(self, **kwargs):
        """
        Initializes a new ConditionBlock object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param condition_blocks_operator:
            The value to assign to the condition_blocks_operator property of this ConditionBlock.
            Allowed values for this property are: "AND", "OR", "NOT_AND", "NOT_OR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type condition_blocks_operator: str

        :param field_name:
            The value to assign to the field_name property of this ConditionBlock.
        :type field_name: str

        :param label_condition_operator:
            The value to assign to the label_condition_operator property of this ConditionBlock.
        :type label_condition_operator: str

        :param label_condition_value:
            The value to assign to the label_condition_value property of this ConditionBlock.
        :type label_condition_value: str

        :param label_condition_values:
            The value to assign to the label_condition_values property of this ConditionBlock.
        :type label_condition_values: list[str]

        :param condition_blocks:
            The value to assign to the condition_blocks property of this ConditionBlock.
        :type condition_blocks: list[oci.log_analytics.models.ConditionBlock]

        """
        self.swagger_types = {
            'condition_blocks_operator': 'str',
            'field_name': 'str',
            'label_condition_operator': 'str',
            'label_condition_value': 'str',
            'label_condition_values': 'list[str]',
            'condition_blocks': 'list[ConditionBlock]'
        }

        self.attribute_map = {
            'condition_blocks_operator': 'conditionBlocksOperator',
            'field_name': 'fieldName',
            'label_condition_operator': 'labelConditionOperator',
            'label_condition_value': 'labelConditionValue',
            'label_condition_values': 'labelConditionValues',
            'condition_blocks': 'conditionBlocks'
        }

        self._condition_blocks_operator = None
        self._field_name = None
        self._label_condition_operator = None
        self._label_condition_value = None
        self._label_condition_values = None
        self._condition_blocks = None

    @property
    def condition_blocks_operator(self):
        """
        Gets the condition_blocks_operator of this ConditionBlock.
        Operator using which the conditionBlocks should be joined. Specify this for nested conditions.

        Allowed values for this property are: "AND", "OR", "NOT_AND", "NOT_OR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The condition_blocks_operator of this ConditionBlock.
        :rtype: str
        """
        return self._condition_blocks_operator

    @condition_blocks_operator.setter
    def condition_blocks_operator(self, condition_blocks_operator):
        """
        Sets the condition_blocks_operator of this ConditionBlock.
        Operator using which the conditionBlocks should be joined. Specify this for nested conditions.


        :param condition_blocks_operator: The condition_blocks_operator of this ConditionBlock.
        :type: str
        """
        allowed_values = ["AND", "OR", "NOT_AND", "NOT_OR"]
        if not value_allowed_none_or_none_sentinel(condition_blocks_operator, allowed_values):
            condition_blocks_operator = 'UNKNOWN_ENUM_VALUE'
        self._condition_blocks_operator = condition_blocks_operator

    @property
    def field_name(self):
        """
        Gets the field_name of this ConditionBlock.
        The name of the field the condition is based on. Specify this if this condition block represents a single condition.


        :return: The field_name of this ConditionBlock.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this ConditionBlock.
        The name of the field the condition is based on. Specify this if this condition block represents a single condition.


        :param field_name: The field_name of this ConditionBlock.
        :type: str
        """
        self._field_name = field_name

    @property
    def label_condition_operator(self):
        """
        Gets the label_condition_operator of this ConditionBlock.
        The condition operator. Specify this if this condition block represents a single condition.


        :return: The label_condition_operator of this ConditionBlock.
        :rtype: str
        """
        return self._label_condition_operator

    @label_condition_operator.setter
    def label_condition_operator(self, label_condition_operator):
        """
        Sets the label_condition_operator of this ConditionBlock.
        The condition operator. Specify this if this condition block represents a single condition.


        :param label_condition_operator: The label_condition_operator of this ConditionBlock.
        :type: str
        """
        self._label_condition_operator = label_condition_operator

    @property
    def label_condition_value(self):
        """
        Gets the label_condition_value of this ConditionBlock.
        The condition value. Specify this if this condition block represents a single condition.


        :return: The label_condition_value of this ConditionBlock.
        :rtype: str
        """
        return self._label_condition_value

    @label_condition_value.setter
    def label_condition_value(self, label_condition_value):
        """
        Sets the label_condition_value of this ConditionBlock.
        The condition value. Specify this if this condition block represents a single condition.


        :param label_condition_value: The label_condition_value of this ConditionBlock.
        :type: str
        """
        self._label_condition_value = label_condition_value

    @property
    def label_condition_values(self):
        """
        Gets the label_condition_values of this ConditionBlock.
        A list of condition values. Specify this if this condition block represents a single condition.


        :return: The label_condition_values of this ConditionBlock.
        :rtype: list[str]
        """
        return self._label_condition_values

    @label_condition_values.setter
    def label_condition_values(self, label_condition_values):
        """
        Sets the label_condition_values of this ConditionBlock.
        A list of condition values. Specify this if this condition block represents a single condition.


        :param label_condition_values: The label_condition_values of this ConditionBlock.
        :type: list[str]
        """
        self._label_condition_values = label_condition_values

    @property
    def condition_blocks(self):
        """
        Gets the condition_blocks of this ConditionBlock.
        Condition blocks to evaluate within this condition block. Specify this for nested conditions.


        :return: The condition_blocks of this ConditionBlock.
        :rtype: list[oci.log_analytics.models.ConditionBlock]
        """
        return self._condition_blocks

    @condition_blocks.setter
    def condition_blocks(self, condition_blocks):
        """
        Sets the condition_blocks of this ConditionBlock.
        Condition blocks to evaluate within this condition block. Specify this for nested conditions.


        :param condition_blocks: The condition_blocks of this ConditionBlock.
        :type: list[oci.log_analytics.models.ConditionBlock]
        """
        self._condition_blocks = condition_blocks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
