# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalKeyVersionReference(object):
    """
    A reference to key version on external key manager.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalKeyVersionReference object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param external_key_version_id:
            The value to assign to the external_key_version_id property of this ExternalKeyVersionReference.
        :type external_key_version_id: str

        """
        self.swagger_types = {
            'external_key_version_id': 'str'
        }

        self.attribute_map = {
            'external_key_version_id': 'externalKeyVersionId'
        }

        self._external_key_version_id = None

    @property
    def external_key_version_id(self):
        """
        Gets the external_key_version_id of this ExternalKeyVersionReference.
        Key version ID associated with the external key.


        :return: The external_key_version_id of this ExternalKeyVersionReference.
        :rtype: str
        """
        return self._external_key_version_id

    @external_key_version_id.setter
    def external_key_version_id(self, external_key_version_id):
        """
        Sets the external_key_version_id of this ExternalKeyVersionReference.
        Key version ID associated with the external key.


        :param external_key_version_id: The external_key_version_id of this ExternalKeyVersionReference.
        :type: str
        """
        self._external_key_version_id = external_key_version_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
