# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchDetail(object):
    """
    My Oracle Support(MoS) patch details for the Java release.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this PatchDetail.
        :type display_name: str

        :param patch_url:
            The value to assign to the patch_url property of this PatchDetail.
        :type patch_url: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'patch_url': 'str'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'patch_url': 'patchUrl'
        }

        self._display_name = None
        self._patch_url = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PatchDetail.
        Commonly used name for the MoS release.


        :return: The display_name of this PatchDetail.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PatchDetail.
        Commonly used name for the MoS release.


        :param display_name: The display_name of this PatchDetail.
        :type: str
        """
        self._display_name = display_name

    @property
    def patch_url(self):
        """
        **[Required]** Gets the patch_url of this PatchDetail.
        MoS URL to access the artifacts for the Java release.


        :return: The patch_url of this PatchDetail.
        :rtype: str
        """
        return self._patch_url

    @patch_url.setter
    def patch_url(self, patch_url):
        """
        Sets the patch_url of this PatchDetail.
        MoS URL to access the artifacts for the Java release.


        :param patch_url: The patch_url of this PatchDetail.
        :type: str
        """
        self._patch_url = patch_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
