# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DisableDrsDetails(object):
    """
    Details of the request to disable DRS file from active managed instance(s) in a Fleet.
    When the targets aren't specified, then all active managed instance(s) currently in the Fleet are selected.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DisableDrsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param manage_drs_details:
            The value to assign to the manage_drs_details property of this DisableDrsDetails.
        :type manage_drs_details: oci.jms.models.ManageDrsDetails

        """
        self.swagger_types = {
            'manage_drs_details': 'ManageDrsDetails'
        }

        self.attribute_map = {
            'manage_drs_details': 'manageDrsDetails'
        }

        self._manage_drs_details = None

    @property
    def manage_drs_details(self):
        """
        Gets the manage_drs_details of this DisableDrsDetails.

        :return: The manage_drs_details of this DisableDrsDetails.
        :rtype: oci.jms.models.ManageDrsDetails
        """
        return self._manage_drs_details

    @manage_drs_details.setter
    def manage_drs_details(self, manage_drs_details):
        """
        Sets the manage_drs_details of this DisableDrsDetails.

        :param manage_drs_details: The manage_drs_details of this DisableDrsDetails.
        :type: oci.jms.models.ManageDrsDetails
        """
        self._manage_drs_details = manage_drs_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
