# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SelfRegistrationProfile(object):
    """
    Self Registration Profile
    """

    #: A constant which can be used with the idcs_prevented_operations property of a SelfRegistrationProfile.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a SelfRegistrationProfile.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a SelfRegistrationProfile.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    def __init__(self, **kwargs):
        """
        Initializes a new SelfRegistrationProfile object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SelfRegistrationProfile.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this SelfRegistrationProfile.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this SelfRegistrationProfile.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this SelfRegistrationProfile.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this SelfRegistrationProfile.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this SelfRegistrationProfile.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this SelfRegistrationProfile.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this SelfRegistrationProfile.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this SelfRegistrationProfile.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this SelfRegistrationProfile.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this SelfRegistrationProfile.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this SelfRegistrationProfile.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this SelfRegistrationProfile.
        :type tenancy_ocid: str

        :param external_id:
            The value to assign to the external_id property of this SelfRegistrationProfile.
        :type external_id: str

        :param name:
            The value to assign to the name property of this SelfRegistrationProfile.
        :type name: str

        :param activation_email_required:
            The value to assign to the activation_email_required property of this SelfRegistrationProfile.
        :type activation_email_required: bool

        :param number_of_days_redirect_url_is_valid:
            The value to assign to the number_of_days_redirect_url_is_valid property of this SelfRegistrationProfile.
        :type number_of_days_redirect_url_is_valid: int

        :param active:
            The value to assign to the active property of this SelfRegistrationProfile.
        :type active: bool

        :param show_on_login_page:
            The value to assign to the show_on_login_page property of this SelfRegistrationProfile.
        :type show_on_login_page: bool

        :param allowed_email_domains:
            The value to assign to the allowed_email_domains property of this SelfRegistrationProfile.
        :type allowed_email_domains: list[str]

        :param disallowed_email_domains:
            The value to assign to the disallowed_email_domains property of this SelfRegistrationProfile.
        :type disallowed_email_domains: list[str]

        :param header_logo:
            The value to assign to the header_logo property of this SelfRegistrationProfile.
        :type header_logo: str

        :param footer_logo:
            The value to assign to the footer_logo property of this SelfRegistrationProfile.
        :type footer_logo: str

        :param redirect_url:
            The value to assign to the redirect_url property of this SelfRegistrationProfile.
        :type redirect_url: str

        :param consent_text_present:
            The value to assign to the consent_text_present property of this SelfRegistrationProfile.
        :type consent_text_present: bool

        :param display_name:
            The value to assign to the display_name property of this SelfRegistrationProfile.
        :type display_name: list[oci.identity_domains.models.SelfRegistrationProfileDisplayName]

        :param after_submit_text:
            The value to assign to the after_submit_text property of this SelfRegistrationProfile.
        :type after_submit_text: list[oci.identity_domains.models.SelfRegistrationProfileAfterSubmitText]

        :param user_attributes:
            The value to assign to the user_attributes property of this SelfRegistrationProfile.
        :type user_attributes: list[oci.identity_domains.models.SelfRegistrationProfileUserAttributes]

        :param email_template:
            The value to assign to the email_template property of this SelfRegistrationProfile.
        :type email_template: oci.identity_domains.models.SelfRegistrationProfileEmailTemplate

        :param default_groups:
            The value to assign to the default_groups property of this SelfRegistrationProfile.
        :type default_groups: list[oci.identity_domains.models.SelfRegistrationProfileDefaultGroups]

        :param header_text:
            The value to assign to the header_text property of this SelfRegistrationProfile.
        :type header_text: list[oci.identity_domains.models.SelfRegistrationProfileHeaderText]

        :param footer_text:
            The value to assign to the footer_text property of this SelfRegistrationProfile.
        :type footer_text: list[oci.identity_domains.models.SelfRegistrationProfileFooterText]

        :param consent_text:
            The value to assign to the consent_text property of this SelfRegistrationProfile.
        :type consent_text: list[oci.identity_domains.models.SelfRegistrationProfileConsentText]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'external_id': 'str',
            'name': 'str',
            'activation_email_required': 'bool',
            'number_of_days_redirect_url_is_valid': 'int',
            'active': 'bool',
            'show_on_login_page': 'bool',
            'allowed_email_domains': 'list[str]',
            'disallowed_email_domains': 'list[str]',
            'header_logo': 'str',
            'footer_logo': 'str',
            'redirect_url': 'str',
            'consent_text_present': 'bool',
            'display_name': 'list[SelfRegistrationProfileDisplayName]',
            'after_submit_text': 'list[SelfRegistrationProfileAfterSubmitText]',
            'user_attributes': 'list[SelfRegistrationProfileUserAttributes]',
            'email_template': 'SelfRegistrationProfileEmailTemplate',
            'default_groups': 'list[SelfRegistrationProfileDefaultGroups]',
            'header_text': 'list[SelfRegistrationProfileHeaderText]',
            'footer_text': 'list[SelfRegistrationProfileFooterText]',
            'consent_text': 'list[SelfRegistrationProfileConsentText]'
        }

        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'external_id': 'externalId',
            'name': 'name',
            'activation_email_required': 'activationEmailRequired',
            'number_of_days_redirect_url_is_valid': 'numberOfDaysRedirectUrlIsValid',
            'active': 'active',
            'show_on_login_page': 'showOnLoginPage',
            'allowed_email_domains': 'allowedEmailDomains',
            'disallowed_email_domains': 'disallowedEmailDomains',
            'header_logo': 'headerLogo',
            'footer_logo': 'footerLogo',
            'redirect_url': 'redirectUrl',
            'consent_text_present': 'consentTextPresent',
            'display_name': 'displayName',
            'after_submit_text': 'afterSubmitText',
            'user_attributes': 'userAttributes',
            'email_template': 'emailTemplate',
            'default_groups': 'defaultGroups',
            'header_text': 'headerText',
            'footer_text': 'footerText',
            'consent_text': 'consentText'
        }

        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._external_id = None
        self._name = None
        self._activation_email_required = None
        self._number_of_days_redirect_url_is_valid = None
        self._active = None
        self._show_on_login_page = None
        self._allowed_email_domains = None
        self._disallowed_email_domains = None
        self._header_logo = None
        self._footer_logo = None
        self._redirect_url = None
        self._consent_text_present = None
        self._display_name = None
        self._after_submit_text = None
        self._user_attributes = None
        self._email_template = None
        self._default_groups = None
        self._header_text = None
        self._footer_text = None
        self._consent_text = None

    @property
    def id(self):
        """
        Gets the id of this SelfRegistrationProfile.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SelfRegistrationProfile.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this SelfRegistrationProfile.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this SelfRegistrationProfile.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this SelfRegistrationProfile.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this SelfRegistrationProfile.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this SelfRegistrationProfile.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this SelfRegistrationProfile.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this SelfRegistrationProfile.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this SelfRegistrationProfile.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this SelfRegistrationProfile.

        :return: The meta of this SelfRegistrationProfile.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this SelfRegistrationProfile.

        :param meta: The meta of this SelfRegistrationProfile.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this SelfRegistrationProfile.

        :return: The idcs_created_by of this SelfRegistrationProfile.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this SelfRegistrationProfile.

        :param idcs_created_by: The idcs_created_by of this SelfRegistrationProfile.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this SelfRegistrationProfile.

        :return: The idcs_last_modified_by of this SelfRegistrationProfile.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this SelfRegistrationProfile.

        :param idcs_last_modified_by: The idcs_last_modified_by of this SelfRegistrationProfile.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this SelfRegistrationProfile.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this SelfRegistrationProfile.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this SelfRegistrationProfile.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this SelfRegistrationProfile.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this SelfRegistrationProfile.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this SelfRegistrationProfile.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this SelfRegistrationProfile.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this SelfRegistrationProfile.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this SelfRegistrationProfile.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this SelfRegistrationProfile.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this SelfRegistrationProfile.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this SelfRegistrationProfile.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this SelfRegistrationProfile.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this SelfRegistrationProfile.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this SelfRegistrationProfile.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this SelfRegistrationProfile.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this SelfRegistrationProfile.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this SelfRegistrationProfile.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this SelfRegistrationProfile.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this SelfRegistrationProfile.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this SelfRegistrationProfile.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this SelfRegistrationProfile.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def external_id(self):
        """
        Gets the external_id of this SelfRegistrationProfile.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The external_id of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this SelfRegistrationProfile.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param external_id: The external_id of this SelfRegistrationProfile.
        :type: str
        """
        self._external_id = external_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SelfRegistrationProfile.
        Name of the profile

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: global


        :return: The name of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SelfRegistrationProfile.
        Name of the profile

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: always
         - type: string
         - uniqueness: global


        :param name: The name of this SelfRegistrationProfile.
        :type: str
        """
        self._name = name

    @property
    def activation_email_required(self):
        """
        **[Required]** Gets the activation_email_required of this SelfRegistrationProfile.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - multiValued: false
        - mutability: readWrite
        - required: true
        - returned: default
        - type: boolean
        - uniqueness: none
        A Boolean value that indicates whether Account verification email is required to be sent before login or not


        :return: The activation_email_required of this SelfRegistrationProfile.
        :rtype: bool
        """
        return self._activation_email_required

    @activation_email_required.setter
    def activation_email_required(self, activation_email_required):
        """
        Sets the activation_email_required of this SelfRegistrationProfile.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - multiValued: false
        - mutability: readWrite
        - required: true
        - returned: default
        - type: boolean
        - uniqueness: none
        A Boolean value that indicates whether Account verification email is required to be sent before login or not


        :param activation_email_required: The activation_email_required of this SelfRegistrationProfile.
        :type: bool
        """
        self._activation_email_required = activation_email_required

    @property
    def number_of_days_redirect_url_is_valid(self):
        """
        **[Required]** Gets the number_of_days_redirect_url_is_valid of this SelfRegistrationProfile.
        Number of days redirect URL is valid

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The number_of_days_redirect_url_is_valid of this SelfRegistrationProfile.
        :rtype: int
        """
        return self._number_of_days_redirect_url_is_valid

    @number_of_days_redirect_url_is_valid.setter
    def number_of_days_redirect_url_is_valid(self, number_of_days_redirect_url_is_valid):
        """
        Sets the number_of_days_redirect_url_is_valid of this SelfRegistrationProfile.
        Number of days redirect URL is valid

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: integer
         - uniqueness: none


        :param number_of_days_redirect_url_is_valid: The number_of_days_redirect_url_is_valid of this SelfRegistrationProfile.
        :type: int
        """
        self._number_of_days_redirect_url_is_valid = number_of_days_redirect_url_is_valid

    @property
    def active(self):
        """
        Gets the active of this SelfRegistrationProfile.
        A Boolean value that indicates whether the profile is enabled or not

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The active of this SelfRegistrationProfile.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this SelfRegistrationProfile.
        A Boolean value that indicates whether the profile is enabled or not

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param active: The active of this SelfRegistrationProfile.
        :type: bool
        """
        self._active = active

    @property
    def show_on_login_page(self):
        """
        **[Required]** Gets the show_on_login_page of this SelfRegistrationProfile.
        A Boolean value that indicates whether the profile should be displayed on login page

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The show_on_login_page of this SelfRegistrationProfile.
        :rtype: bool
        """
        return self._show_on_login_page

    @show_on_login_page.setter
    def show_on_login_page(self, show_on_login_page):
        """
        Sets the show_on_login_page of this SelfRegistrationProfile.
        A Boolean value that indicates whether the profile should be displayed on login page

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param show_on_login_page: The show_on_login_page of this SelfRegistrationProfile.
        :type: bool
        """
        self._show_on_login_page = show_on_login_page

    @property
    def allowed_email_domains(self):
        """
        Gets the allowed_email_domains of this SelfRegistrationProfile.
        A Multivalue String value for Email domains which are valid for this profile

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The allowed_email_domains of this SelfRegistrationProfile.
        :rtype: list[str]
        """
        return self._allowed_email_domains

    @allowed_email_domains.setter
    def allowed_email_domains(self, allowed_email_domains):
        """
        Sets the allowed_email_domains of this SelfRegistrationProfile.
        A Multivalue String value for Email domains which are valid for this profile

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param allowed_email_domains: The allowed_email_domains of this SelfRegistrationProfile.
        :type: list[str]
        """
        self._allowed_email_domains = allowed_email_domains

    @property
    def disallowed_email_domains(self):
        """
        Gets the disallowed_email_domains of this SelfRegistrationProfile.
        A Multivalue String Value for Email domains to be handled as exceptions

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The disallowed_email_domains of this SelfRegistrationProfile.
        :rtype: list[str]
        """
        return self._disallowed_email_domains

    @disallowed_email_domains.setter
    def disallowed_email_domains(self, disallowed_email_domains):
        """
        Sets the disallowed_email_domains of this SelfRegistrationProfile.
        A Multivalue String Value for Email domains to be handled as exceptions

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param disallowed_email_domains: The disallowed_email_domains of this SelfRegistrationProfile.
        :type: list[str]
        """
        self._disallowed_email_domains = disallowed_email_domains

    @property
    def header_logo(self):
        """
        Gets the header_logo of this SelfRegistrationProfile.
        Reference to header logo

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: reference


        :return: The header_logo of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._header_logo

    @header_logo.setter
    def header_logo(self, header_logo):
        """
        Sets the header_logo of this SelfRegistrationProfile.
        Reference to header logo

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: reference


        :param header_logo: The header_logo of this SelfRegistrationProfile.
        :type: str
        """
        self._header_logo = header_logo

    @property
    def footer_logo(self):
        """
        Gets the footer_logo of this SelfRegistrationProfile.
        References to footer logo

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: reference


        :return: The footer_logo of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._footer_logo

    @footer_logo.setter
    def footer_logo(self, footer_logo):
        """
        Sets the footer_logo of this SelfRegistrationProfile.
        References to footer logo

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: reference


        :param footer_logo: The footer_logo of this SelfRegistrationProfile.
        :type: str
        """
        self._footer_logo = footer_logo

    @property
    def redirect_url(self):
        """
        **[Required]** Gets the redirect_url of this SelfRegistrationProfile.
        This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\\"pending verification\\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\\"verified\\\" state, this link will be used to verify user's email.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The redirect_url of this SelfRegistrationProfile.
        :rtype: str
        """
        return self._redirect_url

    @redirect_url.setter
    def redirect_url(self, redirect_url):
        """
        Sets the redirect_url of this SelfRegistrationProfile.
        This URL will be replaced in email notification sent to user. When activation email required is set to true, user is created in \\\"pending verification\\\" state, upon clicking this link user will be able to activate himself. When activation email required is set to false, user is created in \\\"verified\\\" state, this link will be used to verify user's email.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param redirect_url: The redirect_url of this SelfRegistrationProfile.
        :type: str
        """
        self._redirect_url = redirect_url

    @property
    def consent_text_present(self):
        """
        **[Required]** Gets the consent_text_present of this SelfRegistrationProfile.
        A boolean value that indicates whether the consent text is present.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The consent_text_present of this SelfRegistrationProfile.
        :rtype: bool
        """
        return self._consent_text_present

    @consent_text_present.setter
    def consent_text_present(self, consent_text_present):
        """
        Sets the consent_text_present of this SelfRegistrationProfile.
        A boolean value that indicates whether the consent text is present.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param consent_text_present: The consent_text_present of this SelfRegistrationProfile.
        :type: bool
        """
        self._consent_text_present = consent_text_present

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this SelfRegistrationProfile.
        Registration page name

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The display_name of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileDisplayName]
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this SelfRegistrationProfile.
        Registration page name

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: complex
         - uniqueness: none


        :param display_name: The display_name of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileDisplayName]
        """
        self._display_name = display_name

    @property
    def after_submit_text(self):
        """
        Gets the after_submit_text of this SelfRegistrationProfile.
        Text to be displayed on UI after doing self registration

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The after_submit_text of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileAfterSubmitText]
        """
        return self._after_submit_text

    @after_submit_text.setter
    def after_submit_text(self, after_submit_text):
        """
        Sets the after_submit_text of this SelfRegistrationProfile.
        Text to be displayed on UI after doing self registration

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param after_submit_text: The after_submit_text of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileAfterSubmitText]
        """
        self._after_submit_text = after_submit_text

    @property
    def user_attributes(self):
        """
        Gets the user_attributes of this SelfRegistrationProfile.
        **SCIM++ Properties:**
        - idcsCompositeKey: [value]
        - idcsSearchable: true
        - multiValued: true
        - mutability: readWrite
        - required: false
        - returned: default
        - type: complex
        - uniqueness: none
        User Attributes


        :return: The user_attributes of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileUserAttributes]
        """
        return self._user_attributes

    @user_attributes.setter
    def user_attributes(self, user_attributes):
        """
        Sets the user_attributes of this SelfRegistrationProfile.
        **SCIM++ Properties:**
        - idcsCompositeKey: [value]
        - idcsSearchable: true
        - multiValued: true
        - mutability: readWrite
        - required: false
        - returned: default
        - type: complex
        - uniqueness: none
        User Attributes


        :param user_attributes: The user_attributes of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileUserAttributes]
        """
        self._user_attributes = user_attributes

    @property
    def email_template(self):
        """
        **[Required]** Gets the email_template of this SelfRegistrationProfile.

        :return: The email_template of this SelfRegistrationProfile.
        :rtype: oci.identity_domains.models.SelfRegistrationProfileEmailTemplate
        """
        return self._email_template

    @email_template.setter
    def email_template(self, email_template):
        """
        Sets the email_template of this SelfRegistrationProfile.

        :param email_template: The email_template of this SelfRegistrationProfile.
        :type: oci.identity_domains.models.SelfRegistrationProfileEmailTemplate
        """
        self._email_template = email_template

    @property
    def default_groups(self):
        """
        Gets the default_groups of this SelfRegistrationProfile.
        Default groups assigned to the user

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex


        :return: The default_groups of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileDefaultGroups]
        """
        return self._default_groups

    @default_groups.setter
    def default_groups(self, default_groups):
        """
        Sets the default_groups of this SelfRegistrationProfile.
        Default groups assigned to the user

        **SCIM++ Properties:**
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex


        :param default_groups: The default_groups of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileDefaultGroups]
        """
        self._default_groups = default_groups

    @property
    def header_text(self):
        """
        Gets the header_text of this SelfRegistrationProfile.
        Header text

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The header_text of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileHeaderText]
        """
        return self._header_text

    @header_text.setter
    def header_text(self, header_text):
        """
        Sets the header_text of this SelfRegistrationProfile.
        Header text

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param header_text: The header_text of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileHeaderText]
        """
        self._header_text = header_text

    @property
    def footer_text(self):
        """
        Gets the footer_text of this SelfRegistrationProfile.
        Footer text

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The footer_text of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileFooterText]
        """
        return self._footer_text

    @footer_text.setter
    def footer_text(self, footer_text):
        """
        Sets the footer_text of this SelfRegistrationProfile.
        Footer text

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param footer_text: The footer_text of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileFooterText]
        """
        self._footer_text = footer_text

    @property
    def consent_text(self):
        """
        Gets the consent_text of this SelfRegistrationProfile.
        Consent text

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The consent_text of this SelfRegistrationProfile.
        :rtype: list[oci.identity_domains.models.SelfRegistrationProfileConsentText]
        """
        return self._consent_text

    @consent_text.setter
    def consent_text(self, consent_text):
        """
        Sets the consent_text of this SelfRegistrationProfile.
        Consent text

        **SCIM++ Properties:**
         - idcsCompositeKey: [locale]
         - idcsMultiLanguage: true
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param consent_text: The consent_text of this SelfRegistrationProfile.
        :type: list[oci.identity_domains.models.SelfRegistrationProfileConsentText]
        """
        self._consent_text = consent_text

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
