# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaIdcsCsvAttributeNameMappings(object):
    """
    Csv meta data for those resource type attributes which can be imported / exported from / to csv.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaIdcsCsvAttributeNameMappings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param column_header_name:
            The value to assign to the column_header_name property of this SchemaIdcsCsvAttributeNameMappings.
        :type column_header_name: str

        :param deprecated_column_header_name:
            The value to assign to the deprecated_column_header_name property of this SchemaIdcsCsvAttributeNameMappings.
        :type deprecated_column_header_name: str

        :param maps_to:
            The value to assign to the maps_to property of this SchemaIdcsCsvAttributeNameMappings.
        :type maps_to: str

        :param default_value:
            The value to assign to the default_value property of this SchemaIdcsCsvAttributeNameMappings.
        :type default_value: str

        :param multi_value_delimiter:
            The value to assign to the multi_value_delimiter property of this SchemaIdcsCsvAttributeNameMappings.
        :type multi_value_delimiter: str

        :param csv_column_for_resolving_resource_type:
            The value to assign to the csv_column_for_resolving_resource_type property of this SchemaIdcsCsvAttributeNameMappings.
        :type csv_column_for_resolving_resource_type: str

        :param resolve_value_using_resource_type:
            The value to assign to the resolve_value_using_resource_type property of this SchemaIdcsCsvAttributeNameMappings.
        :type resolve_value_using_resource_type: list[oci.identity_domains.models.SchemaResolveValueUsingResourceType]

        :param referenced_resource_type_unique_attribute_name_mappings:
            The value to assign to the referenced_resource_type_unique_attribute_name_mappings property of this SchemaIdcsCsvAttributeNameMappings.
        :type referenced_resource_type_unique_attribute_name_mappings: list[oci.identity_domains.models.SchemaReferencedResourceTypeUniqueAttributeNameMappings]

        """
        self.swagger_types = {
            'column_header_name': 'str',
            'deprecated_column_header_name': 'str',
            'maps_to': 'str',
            'default_value': 'str',
            'multi_value_delimiter': 'str',
            'csv_column_for_resolving_resource_type': 'str',
            'resolve_value_using_resource_type': 'list[SchemaResolveValueUsingResourceType]',
            'referenced_resource_type_unique_attribute_name_mappings': 'list[SchemaReferencedResourceTypeUniqueAttributeNameMappings]'
        }

        self.attribute_map = {
            'column_header_name': 'columnHeaderName',
            'deprecated_column_header_name': 'deprecatedColumnHeaderName',
            'maps_to': 'mapsTo',
            'default_value': 'defaultValue',
            'multi_value_delimiter': 'multiValueDelimiter',
            'csv_column_for_resolving_resource_type': 'csvColumnForResolvingResourceType',
            'resolve_value_using_resource_type': 'resolveValueUsingResourceType',
            'referenced_resource_type_unique_attribute_name_mappings': 'referencedResourceTypeUniqueAttributeNameMappings'
        }

        self._column_header_name = None
        self._deprecated_column_header_name = None
        self._maps_to = None
        self._default_value = None
        self._multi_value_delimiter = None
        self._csv_column_for_resolving_resource_type = None
        self._resolve_value_using_resource_type = None
        self._referenced_resource_type_unique_attribute_name_mappings = None

    @property
    def column_header_name(self):
        """
        Gets the column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        The CSV column header name that maps to this attribute.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: str
        """
        return self._column_header_name

    @column_header_name.setter
    def column_header_name(self, column_header_name):
        """
        Sets the column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        The CSV column header name that maps to this attribute.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param column_header_name: The column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        :type: str
        """
        self._column_header_name = column_header_name

    @property
    def deprecated_column_header_name(self):
        """
        Gets the deprecated_column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        The deprecated CSV column header name that maps to this attribute.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The deprecated_column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: str
        """
        return self._deprecated_column_header_name

    @deprecated_column_header_name.setter
    def deprecated_column_header_name(self, deprecated_column_header_name):
        """
        Sets the deprecated_column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        The deprecated CSV column header name that maps to this attribute.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param deprecated_column_header_name: The deprecated_column_header_name of this SchemaIdcsCsvAttributeNameMappings.
        :type: str
        """
        self._deprecated_column_header_name = deprecated_column_header_name

    @property
    def maps_to(self):
        """
        Gets the maps_to of this SchemaIdcsCsvAttributeNameMappings.
        The attribute path that the CSV column header name maps to for complex multi-valued attributes.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The maps_to of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: str
        """
        return self._maps_to

    @maps_to.setter
    def maps_to(self, maps_to):
        """
        Sets the maps_to of this SchemaIdcsCsvAttributeNameMappings.
        The attribute path that the CSV column header name maps to for complex multi-valued attributes.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param maps_to: The maps_to of this SchemaIdcsCsvAttributeNameMappings.
        :type: str
        """
        self._maps_to = maps_to

    @property
    def default_value(self):
        """
        Gets the default_value of this SchemaIdcsCsvAttributeNameMappings.
        The default value to be used during import processing in case the CSV column header is not present or value is not given in the import CSV.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The default_value of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this SchemaIdcsCsvAttributeNameMappings.
        The default value to be used during import processing in case the CSV column header is not present or value is not given in the import CSV.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param default_value: The default_value of this SchemaIdcsCsvAttributeNameMappings.
        :type: str
        """
        self._default_value = default_value

    @property
    def multi_value_delimiter(self):
        """
        Gets the multi_value_delimiter of this SchemaIdcsCsvAttributeNameMappings.
        If values of the CSV column header name can contain multiple values, this attribute specifies the delimiter to be used. For example, Group's \\\"User Members\\\" CSV column header is multi-valued and it's delimiter is a semi-colon (\\\";\\\").

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The multi_value_delimiter of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: str
        """
        return self._multi_value_delimiter

    @multi_value_delimiter.setter
    def multi_value_delimiter(self, multi_value_delimiter):
        """
        Sets the multi_value_delimiter of this SchemaIdcsCsvAttributeNameMappings.
        If values of the CSV column header name can contain multiple values, this attribute specifies the delimiter to be used. For example, Group's \\\"User Members\\\" CSV column header is multi-valued and it's delimiter is a semi-colon (\\\";\\\").

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param multi_value_delimiter: The multi_value_delimiter of this SchemaIdcsCsvAttributeNameMappings.
        :type: str
        """
        self._multi_value_delimiter = multi_value_delimiter

    @property
    def csv_column_for_resolving_resource_type(self):
        """
        Gets the csv_column_for_resolving_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        This specifies the Csv Header for resolving Resource Type for this Column Header

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The csv_column_for_resolving_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: str
        """
        return self._csv_column_for_resolving_resource_type

    @csv_column_for_resolving_resource_type.setter
    def csv_column_for_resolving_resource_type(self, csv_column_for_resolving_resource_type):
        """
        Sets the csv_column_for_resolving_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        This specifies the Csv Header for resolving Resource Type for this Column Header

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param csv_column_for_resolving_resource_type: The csv_column_for_resolving_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        :type: str
        """
        self._csv_column_for_resolving_resource_type = csv_column_for_resolving_resource_type

    @property
    def resolve_value_using_resource_type(self):
        """
        Gets the resolve_value_using_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        This attribute gives a maps for resolving Resource Type after reading it's value from \\\"csvColumnForResolvingResourceType\\\" attribute

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The resolve_value_using_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: list[oci.identity_domains.models.SchemaResolveValueUsingResourceType]
        """
        return self._resolve_value_using_resource_type

    @resolve_value_using_resource_type.setter
    def resolve_value_using_resource_type(self, resolve_value_using_resource_type):
        """
        Sets the resolve_value_using_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        This attribute gives a maps for resolving Resource Type after reading it's value from \\\"csvColumnForResolvingResourceType\\\" attribute

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param resolve_value_using_resource_type: The resolve_value_using_resource_type of this SchemaIdcsCsvAttributeNameMappings.
        :type: list[oci.identity_domains.models.SchemaResolveValueUsingResourceType]
        """
        self._resolve_value_using_resource_type = resolve_value_using_resource_type

    @property
    def referenced_resource_type_unique_attribute_name_mappings(self):
        """
        Gets the referenced_resource_type_unique_attribute_name_mappings of this SchemaIdcsCsvAttributeNameMappings.
        This attribute specifies the mapping of \\\"uniqueAttributeNameForDisplay\\\" attributes(s) of the referenced resource with the columnHeaderName(s). This attribute should be given in the idcsCsvAttributeNameMappings when uniqueAttributeNameForDisplay contains more than one attribute.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The referenced_resource_type_unique_attribute_name_mappings of this SchemaIdcsCsvAttributeNameMappings.
        :rtype: list[oci.identity_domains.models.SchemaReferencedResourceTypeUniqueAttributeNameMappings]
        """
        return self._referenced_resource_type_unique_attribute_name_mappings

    @referenced_resource_type_unique_attribute_name_mappings.setter
    def referenced_resource_type_unique_attribute_name_mappings(self, referenced_resource_type_unique_attribute_name_mappings):
        """
        Sets the referenced_resource_type_unique_attribute_name_mappings of this SchemaIdcsCsvAttributeNameMappings.
        This attribute specifies the mapping of \\\"uniqueAttributeNameForDisplay\\\" attributes(s) of the referenced resource with the columnHeaderName(s). This attribute should be given in the idcsCsvAttributeNameMappings when uniqueAttributeNameForDisplay contains more than one attribute.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param referenced_resource_type_unique_attribute_name_mappings: The referenced_resource_type_unique_attribute_name_mappings of this SchemaIdcsCsvAttributeNameMappings.
        :type: list[oci.identity_domains.models.SchemaReferencedResourceTypeUniqueAttributeNameMappings]
        """
        self._referenced_resource_type_unique_attribute_name_mappings = referenced_resource_type_unique_attribute_name_mappings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
