# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentitySetting(object):
    """
    Identity Settings
    """

    #: A constant which can be used with the idcs_prevented_operations property of a IdentitySetting.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a IdentitySetting.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a IdentitySetting.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    def __init__(self, **kwargs):
        """
        Initializes a new IdentitySetting object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this IdentitySetting.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this IdentitySetting.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this IdentitySetting.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this IdentitySetting.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this IdentitySetting.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this IdentitySetting.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this IdentitySetting.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this IdentitySetting.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this IdentitySetting.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this IdentitySetting.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this IdentitySetting.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this IdentitySetting.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this IdentitySetting.
        :type tenancy_ocid: str

        :param external_id:
            The value to assign to the external_id property of this IdentitySetting.
        :type external_id: str

        :param user_allowed_to_set_recovery_email:
            The value to assign to the user_allowed_to_set_recovery_email property of this IdentitySetting.
        :type user_allowed_to_set_recovery_email: bool

        :param emit_locked_message_when_user_is_locked:
            The value to assign to the emit_locked_message_when_user_is_locked property of this IdentitySetting.
        :type emit_locked_message_when_user_is_locked: bool

        :param primary_email_required:
            The value to assign to the primary_email_required property of this IdentitySetting.
        :type primary_email_required: bool

        :param remove_invalid_emails:
            The value to assign to the remove_invalid_emails property of this IdentitySetting.
        :type remove_invalid_emails: bool

        :param return_inactive_over_locked_message:
            The value to assign to the return_inactive_over_locked_message property of this IdentitySetting.
        :type return_inactive_over_locked_message: bool

        :param my_profile:
            The value to assign to the my_profile property of this IdentitySetting.
        :type my_profile: oci.identity_domains.models.IdentitySettingsMyProfile

        :param posix_uid:
            The value to assign to the posix_uid property of this IdentitySetting.
        :type posix_uid: oci.identity_domains.models.IdentitySettingsPOSIXUid

        :param posix_gid:
            The value to assign to the posix_gid property of this IdentitySetting.
        :type posix_gid: oci.identity_domains.models.IdentitySettingsPOSIXGid

        :param tokens:
            The value to assign to the tokens property of this IdentitySetting.
        :type tokens: list[oci.identity_domains.models.IdentitySettingsTokens]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'external_id': 'str',
            'user_allowed_to_set_recovery_email': 'bool',
            'emit_locked_message_when_user_is_locked': 'bool',
            'primary_email_required': 'bool',
            'remove_invalid_emails': 'bool',
            'return_inactive_over_locked_message': 'bool',
            'my_profile': 'IdentitySettingsMyProfile',
            'posix_uid': 'IdentitySettingsPOSIXUid',
            'posix_gid': 'IdentitySettingsPOSIXGid',
            'tokens': 'list[IdentitySettingsTokens]'
        }

        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'external_id': 'externalId',
            'user_allowed_to_set_recovery_email': 'userAllowedToSetRecoveryEmail',
            'emit_locked_message_when_user_is_locked': 'emitLockedMessageWhenUserIsLocked',
            'primary_email_required': 'primaryEmailRequired',
            'remove_invalid_emails': 'removeInvalidEmails',
            'return_inactive_over_locked_message': 'returnInactiveOverLockedMessage',
            'my_profile': 'myProfile',
            'posix_uid': 'POSIXUid',
            'posix_gid': 'POSIXGid',
            'tokens': 'tokens'
        }

        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._external_id = None
        self._user_allowed_to_set_recovery_email = None
        self._emit_locked_message_when_user_is_locked = None
        self._primary_email_required = None
        self._remove_invalid_emails = None
        self._return_inactive_over_locked_message = None
        self._my_profile = None
        self._posix_uid = None
        self._posix_gid = None
        self._tokens = None

    @property
    def id(self):
        """
        Gets the id of this IdentitySetting.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this IdentitySetting.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IdentitySetting.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this IdentitySetting.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this IdentitySetting.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this IdentitySetting.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this IdentitySetting.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this IdentitySetting.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this IdentitySetting.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this IdentitySetting.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this IdentitySetting.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this IdentitySetting.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this IdentitySetting.

        :return: The meta of this IdentitySetting.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this IdentitySetting.

        :param meta: The meta of this IdentitySetting.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this IdentitySetting.

        :return: The idcs_created_by of this IdentitySetting.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this IdentitySetting.

        :param idcs_created_by: The idcs_created_by of this IdentitySetting.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this IdentitySetting.

        :return: The idcs_last_modified_by of this IdentitySetting.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this IdentitySetting.

        :param idcs_last_modified_by: The idcs_last_modified_by of this IdentitySetting.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this IdentitySetting.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this IdentitySetting.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this IdentitySetting.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this IdentitySetting.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this IdentitySetting.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this IdentitySetting.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this IdentitySetting.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this IdentitySetting.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this IdentitySetting.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this IdentitySetting.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this IdentitySetting.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this IdentitySetting.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this IdentitySetting.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this IdentitySetting.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this IdentitySetting.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this IdentitySetting.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this IdentitySetting.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this IdentitySetting.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this IdentitySetting.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this IdentitySetting.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this IdentitySetting.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this IdentitySetting.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this IdentitySetting.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this IdentitySetting.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this IdentitySetting.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this IdentitySetting.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this IdentitySetting.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this IdentitySetting.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def external_id(self):
        """
        Gets the external_id of this IdentitySetting.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The external_id of this IdentitySetting.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """
        Sets the external_id of this IdentitySetting.
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param external_id: The external_id of this IdentitySetting.
        :type: str
        """
        self._external_id = external_id

    @property
    def user_allowed_to_set_recovery_email(self):
        """
        Gets the user_allowed_to_set_recovery_email of this IdentitySetting.
        Indicates whether a user is allowed to change their own recovery email.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The user_allowed_to_set_recovery_email of this IdentitySetting.
        :rtype: bool
        """
        return self._user_allowed_to_set_recovery_email

    @user_allowed_to_set_recovery_email.setter
    def user_allowed_to_set_recovery_email(self, user_allowed_to_set_recovery_email):
        """
        Sets the user_allowed_to_set_recovery_email of this IdentitySetting.
        Indicates whether a user is allowed to change their own recovery email.

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param user_allowed_to_set_recovery_email: The user_allowed_to_set_recovery_email of this IdentitySetting.
        :type: bool
        """
        self._user_allowed_to_set_recovery_email = user_allowed_to_set_recovery_email

    @property
    def emit_locked_message_when_user_is_locked(self):
        """
        Gets the emit_locked_message_when_user_is_locked of this IdentitySetting.
        Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The emit_locked_message_when_user_is_locked of this IdentitySetting.
        :rtype: bool
        """
        return self._emit_locked_message_when_user_is_locked

    @emit_locked_message_when_user_is_locked.setter
    def emit_locked_message_when_user_is_locked(self, emit_locked_message_when_user_is_locked):
        """
        Sets the emit_locked_message_when_user_is_locked of this IdentitySetting.
        Indicates whether to show the 'user-is-locked' message during authentication if the user is already locked. The default value is false, which tells the system to show a generic 'authentication-failure' message. This is the most secure behavior. If the option is set to true, the system shows a more detailed 'error-message' that says the user is locked. This is more helpful but is less secure, for example, because the difference in error-messages could be used to determine which usernames exist and which do not.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param emit_locked_message_when_user_is_locked: The emit_locked_message_when_user_is_locked of this IdentitySetting.
        :type: bool
        """
        self._emit_locked_message_when_user_is_locked = emit_locked_message_when_user_is_locked

    @property
    def primary_email_required(self):
        """
        Gets the primary_email_required of this IdentitySetting.
        Indicates whether the primary email is required.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The primary_email_required of this IdentitySetting.
        :rtype: bool
        """
        return self._primary_email_required

    @primary_email_required.setter
    def primary_email_required(self, primary_email_required):
        """
        Sets the primary_email_required of this IdentitySetting.
        Indicates whether the primary email is required.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param primary_email_required: The primary_email_required of this IdentitySetting.
        :type: bool
        """
        self._primary_email_required = primary_email_required

    @property
    def remove_invalid_emails(self):
        """
        Gets the remove_invalid_emails of this IdentitySetting.
        Indicates whether to remove non-RFC5322 compliant emails before creating a user.

        **Added In:** 2106170416

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The remove_invalid_emails of this IdentitySetting.
        :rtype: bool
        """
        return self._remove_invalid_emails

    @remove_invalid_emails.setter
    def remove_invalid_emails(self, remove_invalid_emails):
        """
        Sets the remove_invalid_emails of this IdentitySetting.
        Indicates whether to remove non-RFC5322 compliant emails before creating a user.

        **Added In:** 2106170416

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param remove_invalid_emails: The remove_invalid_emails of this IdentitySetting.
        :type: bool
        """
        self._remove_invalid_emails = remove_invalid_emails

    @property
    def return_inactive_over_locked_message(self):
        """
        Gets the return_inactive_over_locked_message of this IdentitySetting.
        **Added In:** 2302092332

        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: boolean
        - uniqueness: none
        Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.


        :return: The return_inactive_over_locked_message of this IdentitySetting.
        :rtype: bool
        """
        return self._return_inactive_over_locked_message

    @return_inactive_over_locked_message.setter
    def return_inactive_over_locked_message(self, return_inactive_over_locked_message):
        """
        Sets the return_inactive_over_locked_message of this IdentitySetting.
        **Added In:** 2302092332

        **SCIM++ Properties:**
        - caseExact: false
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: boolean
        - uniqueness: none
        Determines the PasswordAuthenticator API response when a user is both 'locked' and 'inactive.' If false (default), a 'locked' message is shown. If true, an 'inactive' message is shown.


        :param return_inactive_over_locked_message: The return_inactive_over_locked_message of this IdentitySetting.
        :type: bool
        """
        self._return_inactive_over_locked_message = return_inactive_over_locked_message

    @property
    def my_profile(self):
        """
        Gets the my_profile of this IdentitySetting.

        :return: The my_profile of this IdentitySetting.
        :rtype: oci.identity_domains.models.IdentitySettingsMyProfile
        """
        return self._my_profile

    @my_profile.setter
    def my_profile(self, my_profile):
        """
        Sets the my_profile of this IdentitySetting.

        :param my_profile: The my_profile of this IdentitySetting.
        :type: oci.identity_domains.models.IdentitySettingsMyProfile
        """
        self._my_profile = my_profile

    @property
    def posix_uid(self):
        """
        Gets the posix_uid of this IdentitySetting.

        :return: The posix_uid of this IdentitySetting.
        :rtype: oci.identity_domains.models.IdentitySettingsPOSIXUid
        """
        return self._posix_uid

    @posix_uid.setter
    def posix_uid(self, posix_uid):
        """
        Sets the posix_uid of this IdentitySetting.

        :param posix_uid: The posix_uid of this IdentitySetting.
        :type: oci.identity_domains.models.IdentitySettingsPOSIXUid
        """
        self._posix_uid = posix_uid

    @property
    def posix_gid(self):
        """
        Gets the posix_gid of this IdentitySetting.

        :return: The posix_gid of this IdentitySetting.
        :rtype: oci.identity_domains.models.IdentitySettingsPOSIXGid
        """
        return self._posix_gid

    @posix_gid.setter
    def posix_gid(self, posix_gid):
        """
        Sets the posix_gid of this IdentitySetting.

        :param posix_gid: The posix_gid of this IdentitySetting.
        :type: oci.identity_domains.models.IdentitySettingsPOSIXGid
        """
        self._posix_gid = posix_gid

    @property
    def tokens(self):
        """
        Gets the tokens of this IdentitySetting.
        A list of tokens and their expiry length.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [type]
         - multiValued: true
         - required: false
         - type: complex
         - uniqueness: none


        :return: The tokens of this IdentitySetting.
        :rtype: list[oci.identity_domains.models.IdentitySettingsTokens]
        """
        return self._tokens

    @tokens.setter
    def tokens(self, tokens):
        """
        Sets the tokens of this IdentitySetting.
        A list of tokens and their expiry length.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [type]
         - multiValued: true
         - required: false
         - type: complex
         - uniqueness: none


        :param tokens: The tokens of this IdentitySetting.
        :type: list[oci.identity_domains.models.IdentitySettingsTokens]
        """
        self._tokens = tokens

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
