# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppExtensionEnterpriseAppApp(object):
    """
    This extension defines the Enterprise App related attributes.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppExtensionEnterpriseAppApp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param app_resources:
            The value to assign to the app_resources property of this AppExtensionEnterpriseAppApp.
        :type app_resources: list[oci.identity_domains.models.AppAppResources]

        :param deny_authz_policy:
            The value to assign to the deny_authz_policy property of this AppExtensionEnterpriseAppApp.
        :type deny_authz_policy: oci.identity_domains.models.AppDenyAuthzPolicy

        :param allow_authz_policy:
            The value to assign to the allow_authz_policy property of this AppExtensionEnterpriseAppApp.
        :type allow_authz_policy: oci.identity_domains.models.AppAllowAuthzPolicy

        :param allow_authz_decision_ttl:
            The value to assign to the allow_authz_decision_ttl property of this AppExtensionEnterpriseAppApp.
        :type allow_authz_decision_ttl: int

        :param deny_authz_decision_ttl:
            The value to assign to the deny_authz_decision_ttl property of this AppExtensionEnterpriseAppApp.
        :type deny_authz_decision_ttl: int

        """
        self.swagger_types = {
            'app_resources': 'list[AppAppResources]',
            'deny_authz_policy': 'AppDenyAuthzPolicy',
            'allow_authz_policy': 'AppAllowAuthzPolicy',
            'allow_authz_decision_ttl': 'int',
            'deny_authz_decision_ttl': 'int'
        }

        self.attribute_map = {
            'app_resources': 'appResources',
            'deny_authz_policy': 'denyAuthzPolicy',
            'allow_authz_policy': 'allowAuthzPolicy',
            'allow_authz_decision_ttl': 'allowAuthzDecisionTTL',
            'deny_authz_decision_ttl': 'denyAuthzDecisionTTL'
        }

        self._app_resources = None
        self._deny_authz_policy = None
        self._allow_authz_policy = None
        self._allow_authz_decision_ttl = None
        self._deny_authz_decision_ttl = None

    @property
    def app_resources(self):
        """
        Gets the app_resources of this AppExtensionEnterpriseAppApp.
        A list of AppResources of this App.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :return: The app_resources of this AppExtensionEnterpriseAppApp.
        :rtype: list[oci.identity_domains.models.AppAppResources]
        """
        return self._app_resources

    @app_resources.setter
    def app_resources(self, app_resources):
        """
        Sets the app_resources of this AppExtensionEnterpriseAppApp.
        A list of AppResources of this App.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - idcsCompositeKey: [value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex


        :param app_resources: The app_resources of this AppExtensionEnterpriseAppApp.
        :type: list[oci.identity_domains.models.AppAppResources]
        """
        self._app_resources = app_resources

    @property
    def deny_authz_policy(self):
        """
        Gets the deny_authz_policy of this AppExtensionEnterpriseAppApp.

        :return: The deny_authz_policy of this AppExtensionEnterpriseAppApp.
        :rtype: oci.identity_domains.models.AppDenyAuthzPolicy
        """
        return self._deny_authz_policy

    @deny_authz_policy.setter
    def deny_authz_policy(self, deny_authz_policy):
        """
        Sets the deny_authz_policy of this AppExtensionEnterpriseAppApp.

        :param deny_authz_policy: The deny_authz_policy of this AppExtensionEnterpriseAppApp.
        :type: oci.identity_domains.models.AppDenyAuthzPolicy
        """
        self._deny_authz_policy = deny_authz_policy

    @property
    def allow_authz_policy(self):
        """
        Gets the allow_authz_policy of this AppExtensionEnterpriseAppApp.

        :return: The allow_authz_policy of this AppExtensionEnterpriseAppApp.
        :rtype: oci.identity_domains.models.AppAllowAuthzPolicy
        """
        return self._allow_authz_policy

    @allow_authz_policy.setter
    def allow_authz_policy(self, allow_authz_policy):
        """
        Sets the allow_authz_policy of this AppExtensionEnterpriseAppApp.

        :param allow_authz_policy: The allow_authz_policy of this AppExtensionEnterpriseAppApp.
        :type: oci.identity_domains.models.AppAllowAuthzPolicy
        """
        self._allow_authz_policy = allow_authz_policy

    @property
    def allow_authz_decision_ttl(self):
        """
        Gets the allow_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        Allow Authz policy decision expiry time in seconds.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsMaxValue: 3600
         - idcsMinValue: 0
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The allow_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        :rtype: int
        """
        return self._allow_authz_decision_ttl

    @allow_authz_decision_ttl.setter
    def allow_authz_decision_ttl(self, allow_authz_decision_ttl):
        """
        Sets the allow_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        Allow Authz policy decision expiry time in seconds.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsMaxValue: 3600
         - idcsMinValue: 0
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param allow_authz_decision_ttl: The allow_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        :type: int
        """
        self._allow_authz_decision_ttl = allow_authz_decision_ttl

    @property
    def deny_authz_decision_ttl(self):
        """
        Gets the deny_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        Deny Authz policy decision expiry time in seconds.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsMaxValue: 3600
         - idcsMinValue: 0
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The deny_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        :rtype: int
        """
        return self._deny_authz_decision_ttl

    @deny_authz_decision_ttl.setter
    def deny_authz_decision_ttl(self, deny_authz_decision_ttl):
        """
        Sets the deny_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        Deny Authz policy decision expiry time in seconds.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsMaxValue: 3600
         - idcsMinValue: 0
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param deny_authz_decision_ttl: The deny_authz_decision_ttl of this AppExtensionEnterpriseAppApp.
        :type: int
        """
        self._deny_authz_decision_ttl = deny_authz_decision_ttl

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
