# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppAttrRenderingMetadata(object):
    """
    Label for the attribute to be shown in the UI.
    """

    #: A constant which can be used with the widget property of a AppAttrRenderingMetadata.
    #: This constant has a value of "inputtext"
    WIDGET_INPUTTEXT = "inputtext"

    #: A constant which can be used with the widget property of a AppAttrRenderingMetadata.
    #: This constant has a value of "checkbox"
    WIDGET_CHECKBOX = "checkbox"

    #: A constant which can be used with the widget property of a AppAttrRenderingMetadata.
    #: This constant has a value of "textarea"
    WIDGET_TEXTAREA = "textarea"

    #: A constant which can be used with the section property of a AppAttrRenderingMetadata.
    #: This constant has a value of "saml"
    SECTION_SAML = "saml"

    #: A constant which can be used with the section property of a AppAttrRenderingMetadata.
    #: This constant has a value of "general"
    SECTION_GENERAL = "general"

    def __init__(self, **kwargs):
        """
        Initializes a new AppAttrRenderingMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AppAttrRenderingMetadata.
        :type name: str

        :param label:
            The value to assign to the label property of this AppAttrRenderingMetadata.
        :type label: str

        :param helptext:
            The value to assign to the helptext property of this AppAttrRenderingMetadata.
        :type helptext: str

        :param widget:
            The value to assign to the widget property of this AppAttrRenderingMetadata.
            Allowed values for this property are: "inputtext", "checkbox", "textarea", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type widget: str

        :param datatype:
            The value to assign to the datatype property of this AppAttrRenderingMetadata.
        :type datatype: str

        :param section:
            The value to assign to the section property of this AppAttrRenderingMetadata.
            Allowed values for this property are: "saml", "general", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type section: str

        :param order:
            The value to assign to the order property of this AppAttrRenderingMetadata.
        :type order: int

        :param required:
            The value to assign to the required property of this AppAttrRenderingMetadata.
        :type required: bool

        :param regexp:
            The value to assign to the regexp property of this AppAttrRenderingMetadata.
        :type regexp: str

        :param read_only:
            The value to assign to the read_only property of this AppAttrRenderingMetadata.
        :type read_only: bool

        :param visible:
            The value to assign to the visible property of this AppAttrRenderingMetadata.
        :type visible: bool

        :param min_length:
            The value to assign to the min_length property of this AppAttrRenderingMetadata.
        :type min_length: int

        :param max_length:
            The value to assign to the max_length property of this AppAttrRenderingMetadata.
        :type max_length: int

        :param min_size:
            The value to assign to the min_size property of this AppAttrRenderingMetadata.
        :type min_size: int

        :param max_size:
            The value to assign to the max_size property of this AppAttrRenderingMetadata.
        :type max_size: int

        """
        self.swagger_types = {
            'name': 'str',
            'label': 'str',
            'helptext': 'str',
            'widget': 'str',
            'datatype': 'str',
            'section': 'str',
            'order': 'int',
            'required': 'bool',
            'regexp': 'str',
            'read_only': 'bool',
            'visible': 'bool',
            'min_length': 'int',
            'max_length': 'int',
            'min_size': 'int',
            'max_size': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'label': 'label',
            'helptext': 'helptext',
            'widget': 'widget',
            'datatype': 'datatype',
            'section': 'section',
            'order': 'order',
            'required': 'required',
            'regexp': 'regexp',
            'read_only': 'readOnly',
            'visible': 'visible',
            'min_length': 'minLength',
            'max_length': 'maxLength',
            'min_size': 'minSize',
            'max_size': 'maxSize'
        }

        self._name = None
        self._label = None
        self._helptext = None
        self._widget = None
        self._datatype = None
        self._section = None
        self._order = None
        self._required = None
        self._regexp = None
        self._read_only = None
        self._visible = None
        self._min_length = None
        self._max_length = None
        self._min_size = None
        self._max_size = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AppAttrRenderingMetadata.
        Name of the attribute.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AppAttrRenderingMetadata.
        Name of the attribute.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this AppAttrRenderingMetadata.
        :type: str
        """
        self._name = name

    @property
    def label(self):
        """
        Gets the label of this AppAttrRenderingMetadata.
        Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The label of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this AppAttrRenderingMetadata.
        Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param label: The label of this AppAttrRenderingMetadata.
        :type: str
        """
        self._label = label

    @property
    def helptext(self):
        """
        Gets the helptext of this AppAttrRenderingMetadata.
        Help text for the attribute. It can contain HTML tags.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The helptext of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._helptext

    @helptext.setter
    def helptext(self, helptext):
        """
        Sets the helptext of this AppAttrRenderingMetadata.
        Help text for the attribute. It can contain HTML tags.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param helptext: The helptext of this AppAttrRenderingMetadata.
        :type: str
        """
        self._helptext = helptext

    @property
    def widget(self):
        """
        Gets the widget of this AppAttrRenderingMetadata.
        UI widget to use for the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "inputtext", "checkbox", "textarea", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The widget of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._widget

    @widget.setter
    def widget(self, widget):
        """
        Sets the widget of this AppAttrRenderingMetadata.
        UI widget to use for the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param widget: The widget of this AppAttrRenderingMetadata.
        :type: str
        """
        allowed_values = ["inputtext", "checkbox", "textarea"]
        if not value_allowed_none_or_none_sentinel(widget, allowed_values):
            widget = 'UNKNOWN_ENUM_VALUE'
        self._widget = widget

    @property
    def datatype(self):
        """
        Gets the datatype of this AppAttrRenderingMetadata.
        Data type of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The datatype of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._datatype

    @datatype.setter
    def datatype(self, datatype):
        """
        Sets the datatype of this AppAttrRenderingMetadata.
        Data type of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param datatype: The datatype of this AppAttrRenderingMetadata.
        :type: str
        """
        self._datatype = datatype

    @property
    def section(self):
        """
        Gets the section of this AppAttrRenderingMetadata.
        UI widget to use for the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "saml", "general", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The section of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._section

    @section.setter
    def section(self, section):
        """
        Sets the section of this AppAttrRenderingMetadata.
        UI widget to use for the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param section: The section of this AppAttrRenderingMetadata.
        :type: str
        """
        allowed_values = ["saml", "general"]
        if not value_allowed_none_or_none_sentinel(section, allowed_values):
            section = 'UNKNOWN_ENUM_VALUE'
        self._section = section

    @property
    def order(self):
        """
        Gets the order of this AppAttrRenderingMetadata.
        Data type of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The order of this AppAttrRenderingMetadata.
        :rtype: int
        """
        return self._order

    @order.setter
    def order(self, order):
        """
        Sets the order of this AppAttrRenderingMetadata.
        Data type of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param order: The order of this AppAttrRenderingMetadata.
        :type: int
        """
        self._order = order

    @property
    def required(self):
        """
        Gets the required of this AppAttrRenderingMetadata.
        Attribute is required or optional.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The required of this AppAttrRenderingMetadata.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this AppAttrRenderingMetadata.
        Attribute is required or optional.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param required: The required of this AppAttrRenderingMetadata.
        :type: bool
        """
        self._required = required

    @property
    def regexp(self):
        """
        Gets the regexp of this AppAttrRenderingMetadata.
        Regular expression of the attribute for validation.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The regexp of this AppAttrRenderingMetadata.
        :rtype: str
        """
        return self._regexp

    @regexp.setter
    def regexp(self, regexp):
        """
        Sets the regexp of this AppAttrRenderingMetadata.
        Regular expression of the attribute for validation.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param regexp: The regexp of this AppAttrRenderingMetadata.
        :type: str
        """
        self._regexp = regexp

    @property
    def read_only(self):
        """
        Gets the read_only of this AppAttrRenderingMetadata.
        Is the attribute readOnly.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The read_only of this AppAttrRenderingMetadata.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this AppAttrRenderingMetadata.
        Is the attribute readOnly.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param read_only: The read_only of this AppAttrRenderingMetadata.
        :type: bool
        """
        self._read_only = read_only

    @property
    def visible(self):
        """
        Gets the visible of this AppAttrRenderingMetadata.
        Indicates whether the attribute is to be shown on the application creation UI.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The visible of this AppAttrRenderingMetadata.
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this AppAttrRenderingMetadata.
        Indicates whether the attribute is to be shown on the application creation UI.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param visible: The visible of this AppAttrRenderingMetadata.
        :type: bool
        """
        self._visible = visible

    @property
    def min_length(self):
        """
        Gets the min_length of this AppAttrRenderingMetadata.
        Minimum length of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The min_length of this AppAttrRenderingMetadata.
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """
        Sets the min_length of this AppAttrRenderingMetadata.
        Minimum length of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param min_length: The min_length of this AppAttrRenderingMetadata.
        :type: int
        """
        self._min_length = min_length

    @property
    def max_length(self):
        """
        Gets the max_length of this AppAttrRenderingMetadata.
        Maximum length of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_length of this AppAttrRenderingMetadata.
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """
        Sets the max_length of this AppAttrRenderingMetadata.
        Maximum length of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_length: The max_length of this AppAttrRenderingMetadata.
        :type: int
        """
        self._max_length = max_length

    @property
    def min_size(self):
        """
        Gets the min_size of this AppAttrRenderingMetadata.
        Minimum size of the attribute..

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The min_size of this AppAttrRenderingMetadata.
        :rtype: int
        """
        return self._min_size

    @min_size.setter
    def min_size(self, min_size):
        """
        Sets the min_size of this AppAttrRenderingMetadata.
        Minimum size of the attribute..

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param min_size: The min_size of this AppAttrRenderingMetadata.
        :type: int
        """
        self._min_size = min_size

    @property
    def max_size(self):
        """
        Gets the max_size of this AppAttrRenderingMetadata.
        Maximum size of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The max_size of this AppAttrRenderingMetadata.
        :rtype: int
        """
        return self._max_size

    @max_size.setter
    def max_size(self, max_size):
        """
        Sets the max_size of this AppAttrRenderingMetadata.
        Maximum size of the attribute.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param max_size: The max_size of this AppAttrRenderingMetadata.
        :type: int
        """
        self._max_size = max_size

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
