# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LoadSqlTuningSetDetails(object):
    """
    The details required to load the Sql statements into the Sql tuning set.
    """

    #: A constant which can be used with the load_type property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "INCREMENTAL_CURSOR_CACHE"
    LOAD_TYPE_INCREMENTAL_CURSOR_CACHE = "INCREMENTAL_CURSOR_CACHE"

    #: A constant which can be used with the load_type property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "CURRENT_CURSOR_CACHE"
    LOAD_TYPE_CURRENT_CURSOR_CACHE = "CURRENT_CURSOR_CACHE"

    #: A constant which can be used with the load_type property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "AWR"
    LOAD_TYPE_AWR = "AWR"

    #: A constant which can be used with the recursive_sql property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "HAS_RECURSIVE_SQL"
    RECURSIVE_SQL_HAS_RECURSIVE_SQL = "HAS_RECURSIVE_SQL"

    #: A constant which can be used with the recursive_sql property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "NO_RECURSIVE_SQL"
    RECURSIVE_SQL_NO_RECURSIVE_SQL = "NO_RECURSIVE_SQL"

    #: A constant which can be used with the ranking_measure1 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE1_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure1 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE1_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure1 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE1_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure1 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE1_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure1 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE1_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure1 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE1_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the ranking_measure2 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE2_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure2 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE2_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure2 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE2_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure2 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE2_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure2 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE2_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure2 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE2_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the ranking_measure3 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE3_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure3 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE3_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure3 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE3_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure3 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE3_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure3 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE3_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure3 property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE3_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the capture_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "INSERT"
    CAPTURE_OPTION_INSERT = "INSERT"

    #: A constant which can be used with the capture_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "UPDATE"
    CAPTURE_OPTION_UPDATE = "UPDATE"

    #: A constant which can be used with the capture_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "MERGE"
    CAPTURE_OPTION_MERGE = "MERGE"

    #: A constant which can be used with the capture_mode property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "MODE_REPLACE_OLD_STATS"
    CAPTURE_MODE_MODE_REPLACE_OLD_STATS = "MODE_REPLACE_OLD_STATS"

    #: A constant which can be used with the capture_mode property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "MODE_ACCUMULATE_STATS"
    CAPTURE_MODE_MODE_ACCUMULATE_STATS = "MODE_ACCUMULATE_STATS"

    #: A constant which can be used with the load_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "INSERT"
    LOAD_OPTION_INSERT = "INSERT"

    #: A constant which can be used with the load_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "UPDATE"
    LOAD_OPTION_UPDATE = "UPDATE"

    #: A constant which can be used with the load_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "MERGE"
    LOAD_OPTION_MERGE = "MERGE"

    #: A constant which can be used with the update_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "REPLACE"
    UPDATE_OPTION_REPLACE = "REPLACE"

    #: A constant which can be used with the update_option property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "ACCUMULATE"
    UPDATE_OPTION_ACCUMULATE = "ACCUMULATE"

    #: A constant which can be used with the update_condition property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "OLD"
    UPDATE_CONDITION_OLD = "OLD"

    #: A constant which can be used with the update_condition property of a LoadSqlTuningSetDetails.
    #: This constant has a value of "NEW"
    UPDATE_CONDITION_NEW = "NEW"

    def __init__(self, **kwargs):
        """
        Initializes a new LoadSqlTuningSetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_details:
            The value to assign to the credential_details property of this LoadSqlTuningSetDetails.
        :type credential_details: oci.database_management.models.SqlTuningSetAdminCredentialDetails

        :param show_sql_only:
            The value to assign to the show_sql_only property of this LoadSqlTuningSetDetails.
        :type show_sql_only: int

        :param owner:
            The value to assign to the owner property of this LoadSqlTuningSetDetails.
        :type owner: str

        :param name:
            The value to assign to the name property of this LoadSqlTuningSetDetails.
        :type name: str

        :param load_type:
            The value to assign to the load_type property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "INCREMENTAL_CURSOR_CACHE", "CURRENT_CURSOR_CACHE", "AWR"
        :type load_type: str

        :param basic_filter:
            The value to assign to the basic_filter property of this LoadSqlTuningSetDetails.
        :type basic_filter: str

        :param recursive_sql:
            The value to assign to the recursive_sql property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"
        :type recursive_sql: str

        :param result_percentage:
            The value to assign to the result_percentage property of this LoadSqlTuningSetDetails.
        :type result_percentage: float

        :param result_limit:
            The value to assign to the result_limit property of this LoadSqlTuningSetDetails.
        :type result_limit: int

        :param ranking_measure1:
            The value to assign to the ranking_measure1 property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure1: str

        :param ranking_measure2:
            The value to assign to the ranking_measure2 property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure2: str

        :param ranking_measure3:
            The value to assign to the ranking_measure3 property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure3: str

        :param total_time_limit:
            The value to assign to the total_time_limit property of this LoadSqlTuningSetDetails.
        :type total_time_limit: int

        :param repeat_interval:
            The value to assign to the repeat_interval property of this LoadSqlTuningSetDetails.
        :type repeat_interval: int

        :param capture_option:
            The value to assign to the capture_option property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "INSERT", "UPDATE", "MERGE"
        :type capture_option: str

        :param capture_mode:
            The value to assign to the capture_mode property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "MODE_REPLACE_OLD_STATS", "MODE_ACCUMULATE_STATS"
        :type capture_mode: str

        :param attribute_list:
            The value to assign to the attribute_list property of this LoadSqlTuningSetDetails.
        :type attribute_list: str

        :param load_option:
            The value to assign to the load_option property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "INSERT", "UPDATE", "MERGE"
        :type load_option: str

        :param update_option:
            The value to assign to the update_option property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "REPLACE", "ACCUMULATE"
        :type update_option: str

        :param update_attributes:
            The value to assign to the update_attributes property of this LoadSqlTuningSetDetails.
        :type update_attributes: str

        :param update_condition:
            The value to assign to the update_condition property of this LoadSqlTuningSetDetails.
            Allowed values for this property are: "OLD", "NEW"
        :type update_condition: str

        :param is_ignore_null:
            The value to assign to the is_ignore_null property of this LoadSqlTuningSetDetails.
        :type is_ignore_null: bool

        :param commit_rows:
            The value to assign to the commit_rows property of this LoadSqlTuningSetDetails.
        :type commit_rows: int

        :param begin_snapshot:
            The value to assign to the begin_snapshot property of this LoadSqlTuningSetDetails.
        :type begin_snapshot: int

        :param end_snapshot:
            The value to assign to the end_snapshot property of this LoadSqlTuningSetDetails.
        :type end_snapshot: int

        :param baseline_name:
            The value to assign to the baseline_name property of this LoadSqlTuningSetDetails.
        :type baseline_name: str

        """
        self.swagger_types = {
            'credential_details': 'SqlTuningSetAdminCredentialDetails',
            'show_sql_only': 'int',
            'owner': 'str',
            'name': 'str',
            'load_type': 'str',
            'basic_filter': 'str',
            'recursive_sql': 'str',
            'result_percentage': 'float',
            'result_limit': 'int',
            'ranking_measure1': 'str',
            'ranking_measure2': 'str',
            'ranking_measure3': 'str',
            'total_time_limit': 'int',
            'repeat_interval': 'int',
            'capture_option': 'str',
            'capture_mode': 'str',
            'attribute_list': 'str',
            'load_option': 'str',
            'update_option': 'str',
            'update_attributes': 'str',
            'update_condition': 'str',
            'is_ignore_null': 'bool',
            'commit_rows': 'int',
            'begin_snapshot': 'int',
            'end_snapshot': 'int',
            'baseline_name': 'str'
        }

        self.attribute_map = {
            'credential_details': 'credentialDetails',
            'show_sql_only': 'showSqlOnly',
            'owner': 'owner',
            'name': 'name',
            'load_type': 'loadType',
            'basic_filter': 'basicFilter',
            'recursive_sql': 'recursiveSql',
            'result_percentage': 'resultPercentage',
            'result_limit': 'resultLimit',
            'ranking_measure1': 'rankingMeasure1',
            'ranking_measure2': 'rankingMeasure2',
            'ranking_measure3': 'rankingMeasure3',
            'total_time_limit': 'totalTimeLimit',
            'repeat_interval': 'repeatInterval',
            'capture_option': 'captureOption',
            'capture_mode': 'captureMode',
            'attribute_list': 'attributeList',
            'load_option': 'loadOption',
            'update_option': 'updateOption',
            'update_attributes': 'updateAttributes',
            'update_condition': 'updateCondition',
            'is_ignore_null': 'isIgnoreNull',
            'commit_rows': 'commitRows',
            'begin_snapshot': 'beginSnapshot',
            'end_snapshot': 'endSnapshot',
            'baseline_name': 'baselineName'
        }

        self._credential_details = None
        self._show_sql_only = None
        self._owner = None
        self._name = None
        self._load_type = None
        self._basic_filter = None
        self._recursive_sql = None
        self._result_percentage = None
        self._result_limit = None
        self._ranking_measure1 = None
        self._ranking_measure2 = None
        self._ranking_measure3 = None
        self._total_time_limit = None
        self._repeat_interval = None
        self._capture_option = None
        self._capture_mode = None
        self._attribute_list = None
        self._load_option = None
        self._update_option = None
        self._update_attributes = None
        self._update_condition = None
        self._is_ignore_null = None
        self._commit_rows = None
        self._begin_snapshot = None
        self._end_snapshot = None
        self._baseline_name = None

    @property
    def credential_details(self):
        """
        **[Required]** Gets the credential_details of this LoadSqlTuningSetDetails.

        :return: The credential_details of this LoadSqlTuningSetDetails.
        :rtype: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        return self._credential_details

    @credential_details.setter
    def credential_details(self, credential_details):
        """
        Sets the credential_details of this LoadSqlTuningSetDetails.

        :param credential_details: The credential_details of this LoadSqlTuningSetDetails.
        :type: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        self._credential_details = credential_details

    @property
    def show_sql_only(self):
        """
        Gets the show_sql_only of this LoadSqlTuningSetDetails.
        Flag to indicate whether to create the Sql tuning set or just display the plsql used to create Sql tuning set.


        :return: The show_sql_only of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._show_sql_only

    @show_sql_only.setter
    def show_sql_only(self, show_sql_only):
        """
        Sets the show_sql_only of this LoadSqlTuningSetDetails.
        Flag to indicate whether to create the Sql tuning set or just display the plsql used to create Sql tuning set.


        :param show_sql_only: The show_sql_only of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._show_sql_only = show_sql_only

    @property
    def owner(self):
        """
        Gets the owner of this LoadSqlTuningSetDetails.
        The owner of the Sql tuning set.


        :return: The owner of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this LoadSqlTuningSetDetails.
        The owner of the Sql tuning set.


        :param owner: The owner of this LoadSqlTuningSetDetails.
        :type: str
        """
        self._owner = owner

    @property
    def name(self):
        """
        **[Required]** Gets the name of this LoadSqlTuningSetDetails.
        The name of the Sql tuning set.


        :return: The name of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LoadSqlTuningSetDetails.
        The name of the Sql tuning set.


        :param name: The name of this LoadSqlTuningSetDetails.
        :type: str
        """
        self._name = name

    @property
    def load_type(self):
        """
        **[Required]** Gets the load_type of this LoadSqlTuningSetDetails.
        Specifies the loading method into the Sql tuning set.

        Allowed values for this property are: "INCREMENTAL_CURSOR_CACHE", "CURRENT_CURSOR_CACHE", "AWR"


        :return: The load_type of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._load_type

    @load_type.setter
    def load_type(self, load_type):
        """
        Sets the load_type of this LoadSqlTuningSetDetails.
        Specifies the loading method into the Sql tuning set.


        :param load_type: The load_type of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["INCREMENTAL_CURSOR_CACHE", "CURRENT_CURSOR_CACHE", "AWR"]
        if not value_allowed_none_or_none_sentinel(load_type, allowed_values):
            raise ValueError(
                f"Invalid value for `load_type`, must be None or one of {allowed_values}"
            )
        self._load_type = load_type

    @property
    def basic_filter(self):
        """
        Gets the basic_filter of this LoadSqlTuningSetDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :return: The basic_filter of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._basic_filter

    @basic_filter.setter
    def basic_filter(self, basic_filter):
        """
        Sets the basic_filter of this LoadSqlTuningSetDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :param basic_filter: The basic_filter of this LoadSqlTuningSetDetails.
        :type: str
        """
        self._basic_filter = basic_filter

    @property
    def recursive_sql(self):
        """
        Gets the recursive_sql of this LoadSqlTuningSetDetails.
        Specifies that the filter must include recursive Sql in the Sql tuning set.

        Allowed values for this property are: "HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"


        :return: The recursive_sql of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._recursive_sql

    @recursive_sql.setter
    def recursive_sql(self, recursive_sql):
        """
        Sets the recursive_sql of this LoadSqlTuningSetDetails.
        Specifies that the filter must include recursive Sql in the Sql tuning set.


        :param recursive_sql: The recursive_sql of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"]
        if not value_allowed_none_or_none_sentinel(recursive_sql, allowed_values):
            raise ValueError(
                f"Invalid value for `recursive_sql`, must be None or one of {allowed_values}"
            )
        self._recursive_sql = recursive_sql

    @property
    def result_percentage(self):
        """
        Gets the result_percentage of this LoadSqlTuningSetDetails.
        Specifies a filter that picks the top n% according to the supplied ranking measure.
        Note that this parameter applies only if one ranking measure is supplied.


        :return: The result_percentage of this LoadSqlTuningSetDetails.
        :rtype: float
        """
        return self._result_percentage

    @result_percentage.setter
    def result_percentage(self, result_percentage):
        """
        Sets the result_percentage of this LoadSqlTuningSetDetails.
        Specifies a filter that picks the top n% according to the supplied ranking measure.
        Note that this parameter applies only if one ranking measure is supplied.


        :param result_percentage: The result_percentage of this LoadSqlTuningSetDetails.
        :type: float
        """
        self._result_percentage = result_percentage

    @property
    def result_limit(self):
        """
        Gets the result_limit of this LoadSqlTuningSetDetails.
        The top limit Sql from the filtered source, ranked by the ranking measure.


        :return: The result_limit of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._result_limit

    @result_limit.setter
    def result_limit(self, result_limit):
        """
        Sets the result_limit of this LoadSqlTuningSetDetails.
        The top limit Sql from the filtered source, ranked by the ranking measure.


        :param result_limit: The result_limit of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._result_limit = result_limit

    @property
    def ranking_measure1(self):
        """
        Gets the ranking_measure1 of this LoadSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure1 of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._ranking_measure1

    @ranking_measure1.setter
    def ranking_measure1(self, ranking_measure1):
        """
        Sets the ranking_measure1 of this LoadSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure1: The ranking_measure1 of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure1, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure1`, must be None or one of {allowed_values}"
            )
        self._ranking_measure1 = ranking_measure1

    @property
    def ranking_measure2(self):
        """
        Gets the ranking_measure2 of this LoadSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure2 of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._ranking_measure2

    @ranking_measure2.setter
    def ranking_measure2(self, ranking_measure2):
        """
        Sets the ranking_measure2 of this LoadSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure2: The ranking_measure2 of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure2, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure2`, must be None or one of {allowed_values}"
            )
        self._ranking_measure2 = ranking_measure2

    @property
    def ranking_measure3(self):
        """
        Gets the ranking_measure3 of this LoadSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure3 of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._ranking_measure3

    @ranking_measure3.setter
    def ranking_measure3(self, ranking_measure3):
        """
        Sets the ranking_measure3 of this LoadSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure3: The ranking_measure3 of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure3, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure3`, must be None or one of {allowed_values}"
            )
        self._ranking_measure3 = ranking_measure3

    @property
    def total_time_limit(self):
        """
        Gets the total_time_limit of this LoadSqlTuningSetDetails.
        Defines the total amount of time, in seconds, to execute.


        :return: The total_time_limit of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._total_time_limit

    @total_time_limit.setter
    def total_time_limit(self, total_time_limit):
        """
        Sets the total_time_limit of this LoadSqlTuningSetDetails.
        Defines the total amount of time, in seconds, to execute.


        :param total_time_limit: The total_time_limit of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._total_time_limit = total_time_limit

    @property
    def repeat_interval(self):
        """
        Gets the repeat_interval of this LoadSqlTuningSetDetails.
        Defines the amount of time, in seconds, to pause between sampling.


        :return: The repeat_interval of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._repeat_interval

    @repeat_interval.setter
    def repeat_interval(self, repeat_interval):
        """
        Sets the repeat_interval of this LoadSqlTuningSetDetails.
        Defines the amount of time, in seconds, to pause between sampling.


        :param repeat_interval: The repeat_interval of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._repeat_interval = repeat_interval

    @property
    def capture_option(self):
        """
        Gets the capture_option of this LoadSqlTuningSetDetails.
        Specifies whether to insert new statements, update existing statements, or both.

        Allowed values for this property are: "INSERT", "UPDATE", "MERGE"


        :return: The capture_option of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._capture_option

    @capture_option.setter
    def capture_option(self, capture_option):
        """
        Sets the capture_option of this LoadSqlTuningSetDetails.
        Specifies whether to insert new statements, update existing statements, or both.


        :param capture_option: The capture_option of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["INSERT", "UPDATE", "MERGE"]
        if not value_allowed_none_or_none_sentinel(capture_option, allowed_values):
            raise ValueError(
                f"Invalid value for `capture_option`, must be None or one of {allowed_values}"
            )
        self._capture_option = capture_option

    @property
    def capture_mode(self):
        """
        Gets the capture_mode of this LoadSqlTuningSetDetails.
        Specifies the capture mode. Note that this parameter is applicable only for UPDATE and MERGE capture options.
        Capture mode can take one of the following values
         - MODE_REPLACE_OLD_STATS
             Replaces statistics when the number of executions is greater than the number stored in the Sql tuning set
         - MODE_ACCUMULATE_STATS
             Adds new values to current values for Sql that is already stored.
             Note that this mode detects if a statement has been aged out, so the final value for a statistics is the sum of the statistics of all cursors that statement existed under.

        Allowed values for this property are: "MODE_REPLACE_OLD_STATS", "MODE_ACCUMULATE_STATS"


        :return: The capture_mode of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._capture_mode

    @capture_mode.setter
    def capture_mode(self, capture_mode):
        """
        Sets the capture_mode of this LoadSqlTuningSetDetails.
        Specifies the capture mode. Note that this parameter is applicable only for UPDATE and MERGE capture options.
        Capture mode can take one of the following values
         - MODE_REPLACE_OLD_STATS
             Replaces statistics when the number of executions is greater than the number stored in the Sql tuning set
         - MODE_ACCUMULATE_STATS
             Adds new values to current values for Sql that is already stored.
             Note that this mode detects if a statement has been aged out, so the final value for a statistics is the sum of the statistics of all cursors that statement existed under.


        :param capture_mode: The capture_mode of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["MODE_REPLACE_OLD_STATS", "MODE_ACCUMULATE_STATS"]
        if not value_allowed_none_or_none_sentinel(capture_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `capture_mode`, must be None or one of {allowed_values}"
            )
        self._capture_mode = capture_mode

    @property
    def attribute_list(self):
        """
        Gets the attribute_list of this LoadSqlTuningSetDetails.
        Specifies the list of Sql statement attributes to return in the result.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Attribute list can take one of the following values.
         TYPICAL - Specifies BASIC plus Sql plan (without row source statistics) and without object reference list (default).
         BASIC - Specifies all attributes (such as execution statistics and binds) except the plans. The execution context is always part of the result.
         ALL - Specifies all attributes.
         CUSTOM - Comma-separated list of the following attribute names.
                  - EXECUTION_STATISTICS
                  - BIND_LIST
                  - OBJECT_LIST
                  - SQL_PLAN
                  - SQL_PLAN_STATISTICS
        Usage examples:
          1. \"attributeList\": \"TYPICAL\"
          2. \"attributeList\": \"ALL\"
          3. \"attributeList\": \"EXECUTION_STATISTICS,OBJECT_LIST,SQL_PLAN\"


        :return: The attribute_list of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._attribute_list

    @attribute_list.setter
    def attribute_list(self, attribute_list):
        """
        Sets the attribute_list of this LoadSqlTuningSetDetails.
        Specifies the list of Sql statement attributes to return in the result.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Attribute list can take one of the following values.
         TYPICAL - Specifies BASIC plus Sql plan (without row source statistics) and without object reference list (default).
         BASIC - Specifies all attributes (such as execution statistics and binds) except the plans. The execution context is always part of the result.
         ALL - Specifies all attributes.
         CUSTOM - Comma-separated list of the following attribute names.
                  - EXECUTION_STATISTICS
                  - BIND_LIST
                  - OBJECT_LIST
                  - SQL_PLAN
                  - SQL_PLAN_STATISTICS
        Usage examples:
          1. \"attributeList\": \"TYPICAL\"
          2. \"attributeList\": \"ALL\"
          3. \"attributeList\": \"EXECUTION_STATISTICS,OBJECT_LIST,SQL_PLAN\"


        :param attribute_list: The attribute_list of this LoadSqlTuningSetDetails.
        :type: str
        """
        self._attribute_list = attribute_list

    @property
    def load_option(self):
        """
        Gets the load_option of this LoadSqlTuningSetDetails.
        Specifies which statements are loaded into the Sql tuning set.
        The possible values are.
         - INSERT (default)
              Adds only new statements.
         - UPDATE
              Updates existing the Sql statements and ignores any new statements.
         - MERGE
              Inserts new statements and updates the information of the existing ones.

        Allowed values for this property are: "INSERT", "UPDATE", "MERGE"


        :return: The load_option of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._load_option

    @load_option.setter
    def load_option(self, load_option):
        """
        Sets the load_option of this LoadSqlTuningSetDetails.
        Specifies which statements are loaded into the Sql tuning set.
        The possible values are.
         - INSERT (default)
              Adds only new statements.
         - UPDATE
              Updates existing the Sql statements and ignores any new statements.
         - MERGE
              Inserts new statements and updates the information of the existing ones.


        :param load_option: The load_option of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["INSERT", "UPDATE", "MERGE"]
        if not value_allowed_none_or_none_sentinel(load_option, allowed_values):
            raise ValueError(
                f"Invalid value for `load_option`, must be None or one of {allowed_values}"
            )
        self._load_option = load_option

    @property
    def update_option(self):
        """
        Gets the update_option of this LoadSqlTuningSetDetails.
        Specifies how existing Sql statements are updated.
        This parameter is applicable only if load_option is specified with UPDATE or MERGE as an option.
        Update option can take one of the following values.
           REPLACE (default) - Updates the statement using the new statistics, bind list, object list, and so on.
           ACCUMULATE - Combines attributes when possible (for example, statistics such as elapsed_time), otherwise replaces the existing values (for example, module and action) with the provided values.
           Following Sql statement attributes can be accumulated.
               elapsed_time
               buffer_gets
               direct_writes
               disk_reads
               row_processed
               fetches
               executions
               end_of_fetch_count
               stat_period
               active_stat_period

        Allowed values for this property are: "REPLACE", "ACCUMULATE"


        :return: The update_option of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._update_option

    @update_option.setter
    def update_option(self, update_option):
        """
        Sets the update_option of this LoadSqlTuningSetDetails.
        Specifies how existing Sql statements are updated.
        This parameter is applicable only if load_option is specified with UPDATE or MERGE as an option.
        Update option can take one of the following values.
           REPLACE (default) - Updates the statement using the new statistics, bind list, object list, and so on.
           ACCUMULATE - Combines attributes when possible (for example, statistics such as elapsed_time), otherwise replaces the existing values (for example, module and action) with the provided values.
           Following Sql statement attributes can be accumulated.
               elapsed_time
               buffer_gets
               direct_writes
               disk_reads
               row_processed
               fetches
               executions
               end_of_fetch_count
               stat_period
               active_stat_period


        :param update_option: The update_option of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["REPLACE", "ACCUMULATE"]
        if not value_allowed_none_or_none_sentinel(update_option, allowed_values):
            raise ValueError(
                f"Invalid value for `update_option`, must be None or one of {allowed_values}"
            )
        self._update_option = update_option

    @property
    def update_attributes(self):
        """
        Gets the update_attributes of this LoadSqlTuningSetDetails.
        Specifies the list of Sql statement attributes to update during a merge or update.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Update attributes can take one of the following values.
           NULL (default) - Specifies the content of the input cursor except the execution context. On other terms, it is equivalent to ALL without execution contexts such as module and action.
           BASIC - Specifies statistics and binds only.
           TYPICAL - Specifies BASIC with Sql plans (without row source statistics) and without an object reference list.
           ALL - Specifies all attributes, including the execution context attributes such as module and action.
           CUSTOM - List of comma separated attribute names to update
               EXECUTION_CONTEXT
               EXECUTION_STATISTICS
               SQL_BINDS
               SQL_PLAN
               SQL_PLAN_STATISTICS (similar to SQL_PLAN with added row source statistics)
        Usage examples:
          1. \"updateAttributes\": \"TYPICAL\"
          2. \"updateAttributes\": \"BASIC\"
          3. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN_STATISTICS,SQL_PLAN\"
          4. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN\"


        :return: The update_attributes of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._update_attributes

    @update_attributes.setter
    def update_attributes(self, update_attributes):
        """
        Sets the update_attributes of this LoadSqlTuningSetDetails.
        Specifies the list of Sql statement attributes to update during a merge or update.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Update attributes can take one of the following values.
           NULL (default) - Specifies the content of the input cursor except the execution context. On other terms, it is equivalent to ALL without execution contexts such as module and action.
           BASIC - Specifies statistics and binds only.
           TYPICAL - Specifies BASIC with Sql plans (without row source statistics) and without an object reference list.
           ALL - Specifies all attributes, including the execution context attributes such as module and action.
           CUSTOM - List of comma separated attribute names to update
               EXECUTION_CONTEXT
               EXECUTION_STATISTICS
               SQL_BINDS
               SQL_PLAN
               SQL_PLAN_STATISTICS (similar to SQL_PLAN with added row source statistics)
        Usage examples:
          1. \"updateAttributes\": \"TYPICAL\"
          2. \"updateAttributes\": \"BASIC\"
          3. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN_STATISTICS,SQL_PLAN\"
          4. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN\"


        :param update_attributes: The update_attributes of this LoadSqlTuningSetDetails.
        :type: str
        """
        self._update_attributes = update_attributes

    @property
    def update_condition(self):
        """
        Gets the update_condition of this LoadSqlTuningSetDetails.
        Specifies when to perform the update.
        The procedure only performs the update when the specified condition is satisfied.
        The condition can refer to either the data source or destination.
        The condition must use the following prefixes to refer to attributes from the source or the destination:
        OLD  \u2014 Refers to statement attributes from the SQL tuning set (destination).
        NEW  \u2014 Refers to statement attributes from the input statements (source).
        NULL \u2014 No updates are performed.

        Allowed values for this property are: "OLD", "NEW"


        :return: The update_condition of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._update_condition

    @update_condition.setter
    def update_condition(self, update_condition):
        """
        Sets the update_condition of this LoadSqlTuningSetDetails.
        Specifies when to perform the update.
        The procedure only performs the update when the specified condition is satisfied.
        The condition can refer to either the data source or destination.
        The condition must use the following prefixes to refer to attributes from the source or the destination:
        OLD  \u2014 Refers to statement attributes from the SQL tuning set (destination).
        NEW  \u2014 Refers to statement attributes from the input statements (source).
        NULL \u2014 No updates are performed.


        :param update_condition: The update_condition of this LoadSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["OLD", "NEW"]
        if not value_allowed_none_or_none_sentinel(update_condition, allowed_values):
            raise ValueError(
                f"Invalid value for `update_condition`, must be None or one of {allowed_values}"
            )
        self._update_condition = update_condition

    @property
    def is_ignore_null(self):
        """
        Gets the is_ignore_null of this LoadSqlTuningSetDetails.
        Specifies whether to update attributes when the new value is NULL.
        If TRUE, then the procedure does not update an attribute when the new value is NULL.
        That is, do not override with NULL values unless intentional.
        Possible values - true or false


        :return: The is_ignore_null of this LoadSqlTuningSetDetails.
        :rtype: bool
        """
        return self._is_ignore_null

    @is_ignore_null.setter
    def is_ignore_null(self, is_ignore_null):
        """
        Sets the is_ignore_null of this LoadSqlTuningSetDetails.
        Specifies whether to update attributes when the new value is NULL.
        If TRUE, then the procedure does not update an attribute when the new value is NULL.
        That is, do not override with NULL values unless intentional.
        Possible values - true or false


        :param is_ignore_null: The is_ignore_null of this LoadSqlTuningSetDetails.
        :type: bool
        """
        self._is_ignore_null = is_ignore_null

    @property
    def commit_rows(self):
        """
        Gets the commit_rows of this LoadSqlTuningSetDetails.
        Specifies whether to commit statements after DML.
        If a value is provided, then the load commits after each specified number of statements is inserted.
        If NULL is provided, then the load commits only once, at the end of the operation.


        :return: The commit_rows of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._commit_rows

    @commit_rows.setter
    def commit_rows(self, commit_rows):
        """
        Sets the commit_rows of this LoadSqlTuningSetDetails.
        Specifies whether to commit statements after DML.
        If a value is provided, then the load commits after each specified number of statements is inserted.
        If NULL is provided, then the load commits only once, at the end of the operation.


        :param commit_rows: The commit_rows of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._commit_rows = commit_rows

    @property
    def begin_snapshot(self):
        """
        Gets the begin_snapshot of this LoadSqlTuningSetDetails.
        Defines the beginning AWR snapshot (non-inclusive).


        :return: The begin_snapshot of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._begin_snapshot

    @begin_snapshot.setter
    def begin_snapshot(self, begin_snapshot):
        """
        Sets the begin_snapshot of this LoadSqlTuningSetDetails.
        Defines the beginning AWR snapshot (non-inclusive).


        :param begin_snapshot: The begin_snapshot of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._begin_snapshot = begin_snapshot

    @property
    def end_snapshot(self):
        """
        Gets the end_snapshot of this LoadSqlTuningSetDetails.
        Defines the ending AWR snapshot (inclusive).


        :return: The end_snapshot of this LoadSqlTuningSetDetails.
        :rtype: int
        """
        return self._end_snapshot

    @end_snapshot.setter
    def end_snapshot(self, end_snapshot):
        """
        Sets the end_snapshot of this LoadSqlTuningSetDetails.
        Defines the ending AWR snapshot (inclusive).


        :param end_snapshot: The end_snapshot of this LoadSqlTuningSetDetails.
        :type: int
        """
        self._end_snapshot = end_snapshot

    @property
    def baseline_name(self):
        """
        Gets the baseline_name of this LoadSqlTuningSetDetails.
        Specifies the name of the AWR baseline period.
        When loading the sql statements from AWR, following inputs has to be provided:
        beginSnapshot and endSnapshot
        OR
        baselineName


        :return: The baseline_name of this LoadSqlTuningSetDetails.
        :rtype: str
        """
        return self._baseline_name

    @baseline_name.setter
    def baseline_name(self, baseline_name):
        """
        Sets the baseline_name of this LoadSqlTuningSetDetails.
        Specifies the name of the AWR baseline period.
        When loading the sql statements from AWR, following inputs has to be provided:
        beginSnapshot and endSnapshot
        OR
        baselineName


        :param baseline_name: The baseline_name of this LoadSqlTuningSetDetails.
        :type: str
        """
        self._baseline_name = baseline_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
