# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421

from .vulnerability_audit_source import VulnerabilityAuditSource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciResourceVulnerabilityAuditSource(VulnerabilityAuditSource):
    """
    OCI resource source for the vulnerability audit.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciResourceVulnerabilityAuditSource object with values from keyword arguments. The default value of the :py:attr:`~oci.adm.models.OciResourceVulnerabilityAuditSource.type` attribute
        of this class is ``OCI_RESOURCE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this OciResourceVulnerabilityAuditSource.
            Allowed values for this property are: "EXTERNAL_RESOURCE", "OCI_RESOURCE", "UNKNOWN"
        :type type: str

        :param oci_resource_id:
            The value to assign to the oci_resource_id property of this OciResourceVulnerabilityAuditSource.
        :type oci_resource_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'oci_resource_id': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'oci_resource_id': 'ociResourceId'
        }

        self._type = None
        self._oci_resource_id = None
        self._type = 'OCI_RESOURCE'

    @property
    def oci_resource_id(self):
        """
        **[Required]** Gets the oci_resource_id of this OciResourceVulnerabilityAuditSource.
        The Oracle Cloud identifier (`OCID`__) of the OCI resource that triggered the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oci_resource_id of this OciResourceVulnerabilityAuditSource.
        :rtype: str
        """
        return self._oci_resource_id

    @oci_resource_id.setter
    def oci_resource_id(self, oci_resource_id):
        """
        Sets the oci_resource_id of this OciResourceVulnerabilityAuditSource.
        The Oracle Cloud identifier (`OCID`__) of the OCI resource that triggered the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oci_resource_id: The oci_resource_id of this OciResourceVulnerabilityAuditSource.
        :type: str
        """
        self._oci_resource_id = oci_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
