# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421

from .vulnerability_audit_source import VulnerabilityAuditSource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalResourceVulnerabilityAuditSource(VulnerabilityAuditSource):
    """
    External source for the vulnerability audit.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalResourceVulnerabilityAuditSource object with values from keyword arguments. The default value of the :py:attr:`~oci.adm.models.ExternalResourceVulnerabilityAuditSource.type` attribute
        of this class is ``EXTERNAL_RESOURCE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ExternalResourceVulnerabilityAuditSource.
            Allowed values for this property are: "EXTERNAL_RESOURCE", "OCI_RESOURCE", "UNKNOWN"
        :type type: str

        :param description:
            The value to assign to the description property of this ExternalResourceVulnerabilityAuditSource.
        :type description: str

        """
        self.swagger_types = {
            'type': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'type': 'type',
            'description': 'description'
        }

        self._type = None
        self._description = None
        self._type = 'EXTERNAL_RESOURCE'

    @property
    def description(self):
        """
        Gets the description of this ExternalResourceVulnerabilityAuditSource.
        Description of the external resource source.


        :return: The description of this ExternalResourceVulnerabilityAuditSource.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ExternalResourceVulnerabilityAuditSource.
        Description of the external resource source.


        :param description: The description of this ExternalResourceVulnerabilityAuditSource.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
