# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeInstanceMovableVnicMappingDetails(object):
    """
    A movable compute instance's source and destination VNIC mapping.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeInstanceMovableVnicMappingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_vnic_id:
            The value to assign to the source_vnic_id property of this ComputeInstanceMovableVnicMappingDetails.
        :type source_vnic_id: str

        :param destination_subnet_id:
            The value to assign to the destination_subnet_id property of this ComputeInstanceMovableVnicMappingDetails.
        :type destination_subnet_id: str

        :param destination_primary_private_ip_address:
            The value to assign to the destination_primary_private_ip_address property of this ComputeInstanceMovableVnicMappingDetails.
        :type destination_primary_private_ip_address: str

        :param destination_primary_private_ip_hostname_label:
            The value to assign to the destination_primary_private_ip_hostname_label property of this ComputeInstanceMovableVnicMappingDetails.
        :type destination_primary_private_ip_hostname_label: str

        :param destination_nsg_id_list:
            The value to assign to the destination_nsg_id_list property of this ComputeInstanceMovableVnicMappingDetails.
        :type destination_nsg_id_list: list[str]

        """
        self.swagger_types = {
            'source_vnic_id': 'str',
            'destination_subnet_id': 'str',
            'destination_primary_private_ip_address': 'str',
            'destination_primary_private_ip_hostname_label': 'str',
            'destination_nsg_id_list': 'list[str]'
        }

        self.attribute_map = {
            'source_vnic_id': 'sourceVnicId',
            'destination_subnet_id': 'destinationSubnetId',
            'destination_primary_private_ip_address': 'destinationPrimaryPrivateIpAddress',
            'destination_primary_private_ip_hostname_label': 'destinationPrimaryPrivateIpHostnameLabel',
            'destination_nsg_id_list': 'destinationNsgIdList'
        }

        self._source_vnic_id = None
        self._destination_subnet_id = None
        self._destination_primary_private_ip_address = None
        self._destination_primary_private_ip_hostname_label = None
        self._destination_nsg_id_list = None

    @property
    def source_vnic_id(self):
        """
        **[Required]** Gets the source_vnic_id of this ComputeInstanceMovableVnicMappingDetails.
        The OCID of the VNIC.

        Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`


        :return: The source_vnic_id of this ComputeInstanceMovableVnicMappingDetails.
        :rtype: str
        """
        return self._source_vnic_id

    @source_vnic_id.setter
    def source_vnic_id(self, source_vnic_id):
        """
        Sets the source_vnic_id of this ComputeInstanceMovableVnicMappingDetails.
        The OCID of the VNIC.

        Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`


        :param source_vnic_id: The source_vnic_id of this ComputeInstanceMovableVnicMappingDetails.
        :type: str
        """
        self._source_vnic_id = source_vnic_id

    @property
    def destination_subnet_id(self):
        """
        **[Required]** Gets the destination_subnet_id of this ComputeInstanceMovableVnicMappingDetails.
        The OCID of the destination (remote) subnet to which this VNIC should connect.

        Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`


        :return: The destination_subnet_id of this ComputeInstanceMovableVnicMappingDetails.
        :rtype: str
        """
        return self._destination_subnet_id

    @destination_subnet_id.setter
    def destination_subnet_id(self, destination_subnet_id):
        """
        Sets the destination_subnet_id of this ComputeInstanceMovableVnicMappingDetails.
        The OCID of the destination (remote) subnet to which this VNIC should connect.

        Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`


        :param destination_subnet_id: The destination_subnet_id of this ComputeInstanceMovableVnicMappingDetails.
        :type: str
        """
        self._destination_subnet_id = destination_subnet_id

    @property
    def destination_primary_private_ip_address(self):
        """
        Gets the destination_primary_private_ip_address of this ComputeInstanceMovableVnicMappingDetails.
        The primary private IP address to assign. This address must belong to the destination subnet.

        Example: `10.0.3.3`


        :return: The destination_primary_private_ip_address of this ComputeInstanceMovableVnicMappingDetails.
        :rtype: str
        """
        return self._destination_primary_private_ip_address

    @destination_primary_private_ip_address.setter
    def destination_primary_private_ip_address(self, destination_primary_private_ip_address):
        """
        Sets the destination_primary_private_ip_address of this ComputeInstanceMovableVnicMappingDetails.
        The primary private IP address to assign. This address must belong to the destination subnet.

        Example: `10.0.3.3`


        :param destination_primary_private_ip_address: The destination_primary_private_ip_address of this ComputeInstanceMovableVnicMappingDetails.
        :type: str
        """
        self._destination_primary_private_ip_address = destination_primary_private_ip_address

    @property
    def destination_primary_private_ip_hostname_label(self):
        """
        Gets the destination_primary_private_ip_hostname_label of this ComputeInstanceMovableVnicMappingDetails.
        The hostname to assign for this primary private IP.
        The value is the hostname portion of the private IP's fully qualified domain name (FQDN)
        (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).

        Example: `bminstance1`


        :return: The destination_primary_private_ip_hostname_label of this ComputeInstanceMovableVnicMappingDetails.
        :rtype: str
        """
        return self._destination_primary_private_ip_hostname_label

    @destination_primary_private_ip_hostname_label.setter
    def destination_primary_private_ip_hostname_label(self, destination_primary_private_ip_hostname_label):
        """
        Sets the destination_primary_private_ip_hostname_label of this ComputeInstanceMovableVnicMappingDetails.
        The hostname to assign for this primary private IP.
        The value is the hostname portion of the private IP's fully qualified domain name (FQDN)
        (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).

        Example: `bminstance1`


        :param destination_primary_private_ip_hostname_label: The destination_primary_private_ip_hostname_label of this ComputeInstanceMovableVnicMappingDetails.
        :type: str
        """
        self._destination_primary_private_ip_hostname_label = destination_primary_private_ip_hostname_label

    @property
    def destination_nsg_id_list(self):
        """
        Gets the destination_nsg_id_list of this ComputeInstanceMovableVnicMappingDetails.
        A list of network security group (NSG) IDs in the destination region which this VNIC should use.

        Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`


        :return: The destination_nsg_id_list of this ComputeInstanceMovableVnicMappingDetails.
        :rtype: list[str]
        """
        return self._destination_nsg_id_list

    @destination_nsg_id_list.setter
    def destination_nsg_id_list(self, destination_nsg_id_list):
        """
        Sets the destination_nsg_id_list of this ComputeInstanceMovableVnicMappingDetails.
        A list of network security group (NSG) IDs in the destination region which this VNIC should use.

        Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`


        :param destination_nsg_id_list: The destination_nsg_id_list of this ComputeInstanceMovableVnicMappingDetails.
        :type: list[str]
        """
        self._destination_nsg_id_list = destination_nsg_id_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
