# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CccInfrastructureInventory(object):
    """
    Inventory for a Compute Cloud@Customer infrastructure. This information
    cannot be updated and is from the infrastructure. The information will only be available
    after the connectionState is transitioned to CONNECTED.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CccInfrastructureInventory object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param serial_number:
            The value to assign to the serial_number property of this CccInfrastructureInventory.
        :type serial_number: str

        :param management_node_count:
            The value to assign to the management_node_count property of this CccInfrastructureInventory.
        :type management_node_count: int

        :param compute_node_count:
            The value to assign to the compute_node_count property of this CccInfrastructureInventory.
        :type compute_node_count: int

        :param capacity_storage_tray_count:
            The value to assign to the capacity_storage_tray_count property of this CccInfrastructureInventory.
        :type capacity_storage_tray_count: int

        :param performance_storage_tray_count:
            The value to assign to the performance_storage_tray_count property of this CccInfrastructureInventory.
        :type performance_storage_tray_count: int

        """
        self.swagger_types = {
            'serial_number': 'str',
            'management_node_count': 'int',
            'compute_node_count': 'int',
            'capacity_storage_tray_count': 'int',
            'performance_storage_tray_count': 'int'
        }

        self.attribute_map = {
            'serial_number': 'serialNumber',
            'management_node_count': 'managementNodeCount',
            'compute_node_count': 'computeNodeCount',
            'capacity_storage_tray_count': 'capacityStorageTrayCount',
            'performance_storage_tray_count': 'performanceStorageTrayCount'
        }

        self._serial_number = None
        self._management_node_count = None
        self._compute_node_count = None
        self._capacity_storage_tray_count = None
        self._performance_storage_tray_count = None

    @property
    def serial_number(self):
        """
        Gets the serial_number of this CccInfrastructureInventory.
        The serial number of the Compute Cloud@Customer infrastructure rack.


        :return: The serial_number of this CccInfrastructureInventory.
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """
        Sets the serial_number of this CccInfrastructureInventory.
        The serial number of the Compute Cloud@Customer infrastructure rack.


        :param serial_number: The serial_number of this CccInfrastructureInventory.
        :type: str
        """
        self._serial_number = serial_number

    @property
    def management_node_count(self):
        """
        Gets the management_node_count of this CccInfrastructureInventory.
        The number of management nodes that are available and in active use
        on the Compute Cloud@Customer infrastructure rack.


        :return: The management_node_count of this CccInfrastructureInventory.
        :rtype: int
        """
        return self._management_node_count

    @management_node_count.setter
    def management_node_count(self, management_node_count):
        """
        Sets the management_node_count of this CccInfrastructureInventory.
        The number of management nodes that are available and in active use
        on the Compute Cloud@Customer infrastructure rack.


        :param management_node_count: The management_node_count of this CccInfrastructureInventory.
        :type: int
        """
        self._management_node_count = management_node_count

    @property
    def compute_node_count(self):
        """
        Gets the compute_node_count of this CccInfrastructureInventory.
        The number of compute nodes that are available and usable
        on the Compute Cloud@Customer infrastructure rack. There is no distinction
        of compute node type in this information.


        :return: The compute_node_count of this CccInfrastructureInventory.
        :rtype: int
        """
        return self._compute_node_count

    @compute_node_count.setter
    def compute_node_count(self, compute_node_count):
        """
        Sets the compute_node_count of this CccInfrastructureInventory.
        The number of compute nodes that are available and usable
        on the Compute Cloud@Customer infrastructure rack. There is no distinction
        of compute node type in this information.


        :param compute_node_count: The compute_node_count of this CccInfrastructureInventory.
        :type: int
        """
        self._compute_node_count = compute_node_count

    @property
    def capacity_storage_tray_count(self):
        """
        Gets the capacity_storage_tray_count of this CccInfrastructureInventory.
        The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for capacity storage.


        :return: The capacity_storage_tray_count of this CccInfrastructureInventory.
        :rtype: int
        """
        return self._capacity_storage_tray_count

    @capacity_storage_tray_count.setter
    def capacity_storage_tray_count(self, capacity_storage_tray_count):
        """
        Sets the capacity_storage_tray_count of this CccInfrastructureInventory.
        The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for capacity storage.


        :param capacity_storage_tray_count: The capacity_storage_tray_count of this CccInfrastructureInventory.
        :type: int
        """
        self._capacity_storage_tray_count = capacity_storage_tray_count

    @property
    def performance_storage_tray_count(self):
        """
        Gets the performance_storage_tray_count of this CccInfrastructureInventory.
        The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for performance storage.


        :return: The performance_storage_tray_count of this CccInfrastructureInventory.
        :rtype: int
        """
        return self._performance_storage_tray_count

    @performance_storage_tray_count.setter
    def performance_storage_tray_count(self, performance_storage_tray_count):
        """
        Sets the performance_storage_tray_count of this CccInfrastructureInventory.
        The number of storage trays in the Compute Cloud@Customer infrastructure rack that are designated for performance storage.


        :param performance_storage_tray_count: The performance_storage_tray_count of this CccInfrastructureInventory.
        :type: int
        """
        self._performance_storage_tray_count = performance_storage_tray_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
