from __future__ import print_function, absolute_import
import numpy
from numba import types
from numba import unittest_support as unittest


class TestTypeNames(unittest.TestCase):
    def test_numpy_integers(self):
        expect = getattr(types, "int%d" % (numpy.dtype("int").itemsize * 8))
        self.assertEqual(types.int_, expect)

        expect = getattr(types, "uint%d" % (numpy.dtype("uint").itemsize * 8))
        self.assertEqual(types.uint, expect)


if __name__ == '__main__':
    unittest.main()
