/*******************************************************************************
 * tlx/timestamp.cpp
 *
 * Part of tlx - http://panthema.net/tlx
 *
 * Copyright (C) 2019 Timo Bingmann <tb@panthema.net>
 *
 * All rights reserved. Published under the Boost Software License, Version 1.0
 ******************************************************************************/

#include <tlx/timestamp.hpp>
#include <chrono>

namespace tlx {

double timestamp()
{
    return static_cast<double>(
               std::chrono::duration_cast<std::chrono::microseconds>(
                   std::chrono::steady_clock::now().time_since_epoch())
                   .count()) /
           1e6;
}

} // namespace tlx

/******************************************************************************/
