__version__   = "$Revision: 1.2 $"[11:-2]
__copyright__ = """Copyright (c) 2003 Not Another Corporation Incorporated
                   www.notanothercorporation.com"""
__license__ = """Licensed under the FSF GPL

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__doc__ = """* $Id: test_unhandledexception.py,v 1.2 2003/09/24 17:03:31 philiplindsay Exp $ *

    ** %s **  Ver %s
 
%s

%s

Test units for the C{UnhandledException} module.

""" % (__name__, __version__, __copyright__, __license__)

import unittest

import mongoose
#import sys

class UnhandledExceptionUnitTests(unittest.TestCase):
    """
    Test units for the C{UnhandledException} module.
    """
    sampleTraceback1 = [('tb1.py', 31, '?', 'f1()'),
                        ('tb1.py', 28, 'f1', 'f3()'),
                        ('tb1.py', 25, 'f3', 'f2()'),
                        ('tb1.py', 22, 'f2', 'raise TypeError()')]

    SAMPLE1_ID = '19962'
    SAMPLE2_ID = '74501'

    # Note: These values are fake & the last value in each tuple incorrect,
    #       we only care about the 3rd value in each..
    sampleTraceback2 = [('tb2.py', 31, '?', 'f1()'),
                        ('tb2.py', 28, 'getSomething', 'f3()'),
                        ('tb2.py', 25, 'doAnotherAction', 'f2()'),
                        ('tb2.py', 78, 'getSomethingElse', 'f3()'),
                        ('tb2.py', 55, 'doSomeAction', 'f2()'),
                        ('tb2.py', 128, 'putSomething', 'f3()'),
                        ('tb2.py', 725, 'doYetAnotherAction','f2()'),
                        ('tb2.py', 822, 'getSomethingAgain', 'raise Error()')]
    
    def testIdCalc(self):
        """
        Test that the incident id for each  traceback  matches our 'known'
        value.
        """
        self.assertEqual(mongoose.calcIncidentId(self.sampleTraceback1),
                         self.SAMPLE1_ID)
        
        self.assertEqual(mongoose.calcIncidentId(self.sampleTraceback2),
                         self.SAMPLE2_ID)

    # TODO: Add more unit tests here...
