__version__   = "$Revision: 1.2 $"[11:-2]
__copyright__ = """Copyright (c) 2003 Not Another Corporation Incorporated
                www.notanothercorporation.com"""
__license__ = """Licensed under the FSF GPL

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__doc__ = """* $Id: test_docstrings.py,v 1.2 2003/09/24 17:03:31 philiplindsay Exp $ *

    ** %s **  Ver %s
 
%s

%s

Tests docstrings are epydoc compliant.

This test uses epydoc U(http://epydoc.sourceforge.net/) which must be in
your site-packages.
""" % (__name__, __version__, __copyright__, __license__)

import sys
import os
import os.path
import glob
import copy
import unittest

try:
    from epydoc.checker import DocChecker
except ImportError:
    pass # We'll throw an error later so we don't stop all the unit tests now...

def _make_docmap(module_names):
    """
    Construct the documentation map for the given modules.

    @param modules: The modules that should be documented.
    @param options: Options from the command-line arguments.
    """
    from epydoc.objdoc import DocMap
    from epydoc.imports import import_module

    modules = []

    for name in module_names:
        try:
            module = import_module(name)
            if module not in modules:
                modules.append(module)
        except ImportError, e:
            pass

    # DocMap
    # Don't bother documenting base classes if we're just running checks.
    document_bases = False
    quiet = 0
    d = DocMap(quiet, document_bases)
    
    for module in modules:
        d.add(module)
    return d


class EpydocTestor(unittest.TestCase):
    def setUp(self):
        unittest.TestCase.setUp(self)
        self._initialPath = copy.copy(sys.path)
        self._initialWorkDir = os.getcwd()
        self.epydocCmdLineOptions = "--check"
        self.epydocPath = "epydoc"
        self.publicOptions = (DocChecker.PUBLIC)
        self.stdOptions = ( DocChecker.MODULE |
                         DocChecker.CLASS |
                         DocChecker.FUNC |
                         DocChecker.PARAM |
                         DocChecker.RETURN)
#                         DocChecker.VAR |       # module vars
#                         DocChecker.IVAR |      # instance vars
#                         DocChecker.CVAR |      # class vars


    def tearDown(self):
        unittest.TestCase.tearDown(self)
        sys.path = self._initialPath
        os.chdir(self._initialWorkDir)


    def test_mongoose(self):
        "EpyDoc foo test"
        # Build their documentation
        modules = glob.glob('mongoose/*.py')
        DocChecker(_make_docmap(modules)).check(self.publicOptions + self.stdOptions)

