import os
import unittest
import doctest
import mercurial_extension_utils

# IMPORTANT NOTE:
#
# As I wanted doctests to be readable, some of them assume
# specific paths and names (for example some tests assume /home/marcink
# as home directory). This is on purpose,
#
#    >>> normalize_path("~/src")
#    '/home/marcink/src'
#
# is readable and fulfills documentation role well, whatever I could write
# instead to handle various accounts, would be unreadable mess.
#
# If you really happen to run those tests, let me know, I'll do sth
# about it (most likely add some „fixup test code before executing it”
# routine below)


def load_tests(loader, tests, ignore):
    if os.name != 'nt':
        tests.addTests(doctest.DocTestSuite(mercurial_extension_utils))
    else:
        tests.addTests(doctest.DocFileSuite(
            "mercurial_extension_utils_win_doc.py",
            module_relative=True, package=mercurial_extension_utils,
            globs=mercurial_extension_utils.__dict__))
    return tests

if __name__ == "__main__":
    unittest.main()
    # doctest.testmod(mercurial_extension_utils)

