# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['libtmux']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'libtmux',
    'version': '0.11.0',
    'description': 'scripting library / orm for tmux',
    'long_description': '# libtmux\n\nlibtmux is a scripting library for tmux. You can use it command and control tmux servers,\nsessions, windows, and panes. It is the tool behind [tmuxp], a tmux workspace manager in python.\n\n[![Python Package](https://img.shields.io/pypi/v/libtmux.svg)](https://pypi.org/project/libtmux/)\n[![Docs](https://github.com/tmux-python/libtmux/workflows/Publish%20Docs/badge.svg)](https://libtmux.git-pull.com/)\n[![Build Status](https://github.com/tmux-python/libtmux/workflows/tests/badge.svg)](https://github.com/tmux-python/tmux-python/actions?query=workflow%3A%22tests%22)\n[![Code Coverage](https://codecov.io/gh/tmux-python/libtmux/branch/master/graph/badge.svg)](https://codecov.io/gh/tmux-python/libtmux)\n[![License](https://img.shields.io/github/license/tmux-python/libtmux.svg)](https://github.com/tmux-python/libtmux/blob/master/LICENSE)\n\nlibtmux builds upon tmux\'s\n[target](http://man.openbsd.org/OpenBSD-5.9/man1/tmux.1#COMMANDS) and\n[formats](http://man.openbsd.org/OpenBSD-5.9/man1/tmux.1#FORMATS) to\ncreate an object mapping to traverse, inspect and interact with live\ntmux sessions.\n\nView the [documentation](https://libtmux.git-pull.com/),\n[API](https://libtmux.git-pull.com/api.html) information and\n[architectural details](https://libtmux.git-pull.com/about.html).\n\nPython 2.x will be deprecated in libtmux 0.9. The backports branch is\n[v0.8.x](https://github.com/tmux-python/libtmux/tree/v0.8.x).\n\n# Install\n\n```console\n$ pip install --user libtmux\n```\n\n# Open a tmux session\n\nSession name `foo`, window name `bar`\n\n```console\n$ tmux new-session -s foo -n bar\n```\n\n# Pilot your tmux session via python\n\n```console\n$ python\n```\n\nUse [ptpython], [ipython], etc. for a nice shell with autocompletions:\n\n```console\n$ pip install --user ptpython\n```\n\n```console\n$ ptpython\n```\n\nConnect to a live tmux session:\n\n```python\n>>> import libtmux\n>>> server = libtmux.Server()\n>>> server\n<libtmux.server.Server object at 0x7fbd622c1dd0>\n```\n\nTip: You can also use [tmuxp]\'s [`tmuxp shell`] to drop straight into your\ncurrent tmux server / session / window pane.\n\n[tmuxp]: https://tmuxp.git-pull.com/\n[`tmuxp shell`]: https://tmuxp.git-pull.com/cli.html#shell\n[ptpython]: https://github.com/prompt-toolkit/ptpython\n[ipython]: https://ipython.org/\n\nList sessions:\n\n```python\n>>> server.list_sessions()\n[Session($3 foo), Session($1 libtmux)]\n```\n\nFind session:\n\n```python\n>>> server.get_by_id(\'$3\')\nSession($3 foo)\n```\n\nFind session by dict lookup:\n\n```python\n>>> server.find_where({ "session_name": "foo" })\nSession($3 foo)\n```\n\nAssign session to `session`:\n\n```python\n>>> session = server.find_where({ "session_name": "foo" })\n```\n\nControl your session:\n\n```python\n>>> session.new_window(attach=False, window_name="ha in the bg")\nWindow(@8 2:ha in the bg, Session($3 foo))\n>>> session.kill_window("ha in")\n```\n\nCreate new window in the background (don\'t switch to it):\n\n```python\n>>> w = session.new_window(attach=False, window_name="ha in the bg")\nWindow(@11 3:ha in the bg, Session($3 foo))\n```\n\nClose window:\n\n```python\n>>> w.kill_window()\n```\n\nGrab remaining tmux window:\n\n```python\n>>> window = session.attached_window\n>>> window.split_window(attach=False)\nPane(%23 Window(@10 1:bar, Session($3 foo)))\n```\n\nRename window:\n\n```python\n>>> window.rename_window(\'libtmuxower\')\nWindow(@10 1:libtmuxower, Session($3 foo))\n```\n\nSplit window (create a new pane):\n\n```python\n>>> pane = window.split_window()\n>>> pane = window.split_window(attach=False)\n>>> pane.select_pane()\n>>> window = session.new_window(attach=False, window_name="test")\n>>> pane = window.split_window(attach=False)\n```\n\nType inside the pane (send key strokes):\n\n```python\n>>> pane.send_keys(\'echo hey send now\')\n\n>>> pane.send_keys(\'echo hey\', enter=False)\n>>> pane.enter()\n```\n\nGrab the output of pane:\n\n```python\n>>> pane.clear()  # clear the pane\n>>> pane.send_keys(\'cowsay hello\')\n>>> print(\'\\n\'.join(pane.cmd(\'capture-pane\', \'-p\').stdout))\n```\n\n    sh-3.2$ cowsay \'hello\'\n     _______\n    < hello >\n     -------\n            \\   ^__^\n             \\  (oo)\\_______\n                (__)\\       )\\/\\\n                    ||----w |\n                    ||     ||\n\nTraverse and navigate:\n\n```python\n>>> pane.window\nWindow(@10 1:libtmuxower, Session($3 foo))\n>>> pane.window.session\nSession($3 foo)\n```\n\n# Donations\n\nYour donations fund development of new features, testing and support.\nYour money will go directly to maintenance and development of the\nproject. If you are an individual, feel free to give whatever feels\nright for the value you get out of the project.\n\nSee donation options at <https://git-pull.com/support.html>.\n\n# Project details\n\n- tmux support: 1.8, 1.9a, 2.0 - 2.9, 3.0\n- python support: >= 3.7, pypy, pypy3\n- Source: <https://github.com/tmux-python/libtmux>\n- Docs: <https://libtmux.git-pull.com>\n- API: <https://libtmux.git-pull.com/api.html>\n- Changelog: <https://libtmux.git-pull.com/history.html>\n- Issues: <https://github.com/tmux-python/libtmux/issues>\n- Test Coverage: <https://codecov.io/gh/tmux-python/libtmux>\n- pypi: <https://pypi.python.org/pypi/libtmux>\n- Open Hub: <https://www.openhub.net/p/libtmux-python>\n- License: [MIT](http://opensource.org/licenses/MIT).\n',
    'author': 'Tony Narlock',
    'author_email': 'tony@git-pull.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'http://github.com/tmux-python/libtmux/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
